/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.net.IIpSecService;
import android.net.INetd;
import android.net.IpSecAlgorithm;
import android.net.IpSecConfig;
import android.net.IpSecSpiResponse;
import android.net.IpSecTransformResponse;
import android.net.IpSecTunnelInterfaceResponse;
import android.net.IpSecUdpEncapResponse;
import android.net.Network;
import android.net.NetworkUtils;
import android.net.TrafficStats;
import android.net.util.NetdService;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import libcore.io.IoUtils;

public class IpSecService
extends IIpSecService.Stub {
    private static final String TAG = "IpSecService";
    private static final boolean DBG = Log.isLoggable("IpSecService", 3);
    private static final String NETD_SERVICE_NAME = "netd";
    private static final int[] DIRECTIONS = new int[]{1, 0};
    private static final String[] WILDCARD_ADDRESSES = new String[]{"0.0.0.0", "::"};
    private static final int NETD_FETCH_TIMEOUT_MS = 5000;
    private static final int MAX_PORT_BIND_ATTEMPTS = 10;
    private static final InetAddress INADDR_ANY;
    static final int FREE_PORT_MIN = 1024;
    static final int PORT_MAX = 65535;
    static final String TUNNEL_INTERFACE_PREFIX = "ipsec";
    private final Context mContext;
    @GuardedBy(value="IpSecService.this")
    private int mNextResourceId = 1;
    private final IpSecServiceConfiguration mSrvConfig;
    final UidFdTagger mUidFdTagger;
    @VisibleForTesting
    final UserResourceTracker mUserResourceTracker = new UserResourceTracker();
    @VisibleForTesting
    static final int TUN_INTF_NETID_START = 64512;
    @VisibleForTesting
    static final int TUN_INTF_NETID_RANGE = 1024;
    private final SparseBooleanArray mTunnelNetIds = new SparseBooleanArray();
    private int mNextTunnelNetIdIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int reserveNetId() {
        SparseBooleanArray sparseBooleanArray = this.mTunnelNetIds;
        synchronized (sparseBooleanArray) {
            for (int i = 0; i < 1024; ++i) {
                int index = this.mNextTunnelNetIdIndex++;
                int netId = index + 64512;
                if (this.mNextTunnelNetIdIndex >= 1024) {
                    this.mNextTunnelNetIdIndex = 0;
                }
                if (this.mTunnelNetIds.get(netId)) continue;
                this.mTunnelNetIds.put(netId, true);
                return netId;
            }
        }
        throw new IllegalStateException("No free netIds to allocate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void releaseNetId(int netId) {
        SparseBooleanArray sparseBooleanArray = this.mTunnelNetIds;
        synchronized (sparseBooleanArray) {
            this.mTunnelNetIds.delete(netId);
        }
    }

    private IpSecService(Context context) {
        this(context, IpSecServiceConfiguration.GETSRVINSTANCE);
    }

    static IpSecService create(Context context) throws InterruptedException {
        IpSecService service = new IpSecService(context);
        service.connectNativeNetdService();
        return service;
    }

    @VisibleForTesting
    public IpSecService(Context context, IpSecServiceConfiguration config) {
        this(context, config, (fd, uid) -> {
            try {
                TrafficStats.setThreadStatsUid(uid);
                TrafficStats.tagFileDescriptor(fd);
            }
            finally {
                TrafficStats.clearThreadStatsUid();
            }
        });
    }

    @VisibleForTesting
    public IpSecService(Context context, IpSecServiceConfiguration config, UidFdTagger uidFdTagger) {
        this.mContext = context;
        this.mSrvConfig = config;
        this.mUidFdTagger = uidFdTagger;
    }

    public void systemReady() {
        if (this.isNetdAlive()) {
            Slog.d(TAG, "IpSecService is ready");
        } else {
            Slog.wtf(TAG, "IpSecService not ready: failed to connect to NetD Native Service!");
        }
    }

    private void connectNativeNetdService() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IpSecService ipSecService = IpSecService.this;
                synchronized (ipSecService) {
                    NetdService.get(5000L);
                }
            }
        }.start();
    }

    synchronized boolean isNetdAlive() {
        try {
            INetd netd = this.mSrvConfig.getNetdInstance();
            if (netd == null) {
                return false;
            }
            return netd.isAlive();
        }
        catch (RemoteException re) {
            return false;
        }
    }

    private static void checkInetAddress(String inetAddress) {
        if (TextUtils.isEmpty(inetAddress)) {
            throw new IllegalArgumentException("Unspecified address");
        }
        InetAddress checkAddr = NetworkUtils.numericToInetAddress(inetAddress);
        if (checkAddr.isAnyLocalAddress()) {
            throw new IllegalArgumentException("Inappropriate wildcard address: " + inetAddress);
        }
    }

    private static void checkDirection(int direction) {
        switch (direction) {
            case 0: 
            case 1: {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid Direction: " + direction);
    }

    @Override
    public synchronized IpSecSpiResponse allocateSecurityParameterIndex(String destinationAddress, int requestedSpi, IBinder binder) throws RemoteException {
        IpSecService.checkInetAddress(destinationAddress);
        Preconditions.checkNotNull(binder, "Null Binder passed to allocateSecurityParameterIndex");
        UserRecord userRecord = this.mUserResourceTracker.getUserRecord(Binder.getCallingUid());
        int resourceId = this.mNextResourceId++;
        int spi = 0;
        try {
            if (!userRecord.mSpiQuotaTracker.isAvailable()) {
                return new IpSecSpiResponse(1, -1, spi);
            }
            spi = this.mSrvConfig.getNetdInstance().ipSecAllocateSpi(resourceId, "", destinationAddress, requestedSpi);
            Log.d(TAG, "Allocated SPI " + spi);
            userRecord.mSpiRecords.put(resourceId, new RefcountedResource(this, (IResource)new SpiRecord(resourceId, "", destinationAddress, spi), binder, new RefcountedResource[0]));
        }
        catch (ServiceSpecificException e) {
            return new IpSecSpiResponse(2, -1, spi);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return new IpSecSpiResponse(0, resourceId, spi);
    }

    private void releaseResource(RefcountedResourceArray resArray, int resourceId) throws RemoteException {
        resArray.getRefcountedResourceOrThrow(resourceId).userRelease();
    }

    @Override
    public synchronized void releaseSecurityParameterIndex(int resourceId) throws RemoteException {
        UserRecord userRecord = this.mUserResourceTracker.getUserRecord(Binder.getCallingUid());
        this.releaseResource(userRecord.mSpiRecords, resourceId);
    }

    private int bindToRandomPort(FileDescriptor sockFd) throws IOException {
        for (int i = 10; i > 0; --i) {
            try {
                FileDescriptor probeSocket = Os.socket(OsConstants.AF_INET, OsConstants.SOCK_DGRAM, OsConstants.IPPROTO_UDP);
                Os.bind(probeSocket, INADDR_ANY, 0);
                int port = ((InetSocketAddress)Os.getsockname(probeSocket)).getPort();
                Os.close(probeSocket);
                Log.v(TAG, "Binding to port " + port);
                Os.bind(sockFd, INADDR_ANY, port);
                return port;
            }
            catch (ErrnoException e) {
                if (e.errno == OsConstants.EADDRINUSE) continue;
                throw e.rethrowAsIOException();
            }
        }
        throw new IOException("Failed 10 attempts to bind to a port");
    }

    @Override
    public synchronized IpSecUdpEncapResponse openUdpEncapsulationSocket(int port, IBinder binder) throws RemoteException {
        if (port != 0 && (port < 1024 || port > 65535)) {
            throw new IllegalArgumentException("Specified port number must be a valid non-reserved UDP port");
        }
        Preconditions.checkNotNull(binder, "Null Binder passed to openUdpEncapsulationSocket");
        int callingUid = Binder.getCallingUid();
        UserRecord userRecord = this.mUserResourceTracker.getUserRecord(callingUid);
        int resourceId = this.mNextResourceId++;
        FileDescriptor sockFd = null;
        try {
            if (!userRecord.mSocketQuotaTracker.isAvailable()) {
                return new IpSecUdpEncapResponse(1);
            }
            sockFd = Os.socket(OsConstants.AF_INET, OsConstants.SOCK_DGRAM, OsConstants.IPPROTO_UDP);
            this.mUidFdTagger.tag(sockFd, callingUid);
            Os.setsockoptInt(sockFd, OsConstants.IPPROTO_UDP, OsConstants.UDP_ENCAP, OsConstants.UDP_ENCAP_ESPINUDP);
            this.mSrvConfig.getNetdInstance().ipSecSetEncapSocketOwner(sockFd, callingUid);
            if (port != 0) {
                Log.v(TAG, "Binding to port " + port);
                Os.bind(sockFd, INADDR_ANY, port);
            } else {
                port = this.bindToRandomPort(sockFd);
            }
            userRecord.mEncapSocketRecords.put(resourceId, new RefcountedResource(this, (IResource)new EncapSocketRecord(resourceId, sockFd, port), binder, new RefcountedResource[0]));
            return new IpSecUdpEncapResponse(0, resourceId, port, sockFd);
        }
        catch (ErrnoException | IOException e) {
            IoUtils.closeQuietly(sockFd);
            return new IpSecUdpEncapResponse(1);
        }
    }

    @Override
    public synchronized void closeUdpEncapsulationSocket(int resourceId) throws RemoteException {
        UserRecord userRecord = this.mUserResourceTracker.getUserRecord(Binder.getCallingUid());
        this.releaseResource(userRecord.mEncapSocketRecords, resourceId);
    }

    @Override
    public synchronized IpSecTunnelInterfaceResponse createTunnelInterface(String localAddr, String remoteAddr, Network underlyingNetwork, IBinder binder) {
        Preconditions.checkNotNull(binder, "Null Binder passed to createTunnelInterface");
        Preconditions.checkNotNull(underlyingNetwork, "No underlying network was specified");
        IpSecService.checkInetAddress(localAddr);
        IpSecService.checkInetAddress(remoteAddr);
        UserRecord userRecord = this.mUserResourceTracker.getUserRecord(Binder.getCallingUid());
        if (!userRecord.mTunnelQuotaTracker.isAvailable()) {
            return new IpSecTunnelInterfaceResponse(1);
        }
        int resourceId = this.mNextResourceId++;
        int ikey = this.reserveNetId();
        int okey = this.reserveNetId();
        String intfName = String.format("%s%d", TUNNEL_INTERFACE_PREFIX, resourceId);
        try {
            this.mSrvConfig.getNetdInstance().addVirtualTunnelInterface(intfName, localAddr, remoteAddr, ikey, okey);
            for (String wildcardAddr : WILDCARD_ADDRESSES) {
                for (int direction : DIRECTIONS) {
                    int mark = direction == 1 ? okey : ikey;
                    this.mSrvConfig.getNetdInstance().ipSecAddSecurityPolicy(0, direction, wildcardAddr, wildcardAddr, 0, mark, -1);
                }
            }
            userRecord.mTunnelInterfaceRecords.put(resourceId, new RefcountedResource(this, (IResource)new TunnelInterfaceRecord(resourceId, intfName, underlyingNetwork, localAddr, remoteAddr, ikey, okey), binder, new RefcountedResource[0]));
            return new IpSecTunnelInterfaceResponse(0, resourceId, intfName);
        }
        catch (RemoteException e) {
            this.releaseNetId(ikey);
            this.releaseNetId(okey);
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException serviceSpecificException) {
            this.releaseNetId(ikey);
            this.releaseNetId(okey);
            return new IpSecTunnelInterfaceResponse(1);
        }
    }

    @Override
    public synchronized void addAddressToTunnelInterface(int tunnelResourceId, String localAddr) {
        UserRecord userRecord = this.mUserResourceTracker.getUserRecord(Binder.getCallingUid());
        TunnelInterfaceRecord tunnelInterfaceInfo = userRecord.mTunnelInterfaceRecords.getResourceOrThrow(tunnelResourceId);
    }

    @Override
    public synchronized void removeAddressFromTunnelInterface(int tunnelResourceId, String localAddr) {
        UserRecord userRecord = this.mUserResourceTracker.getUserRecord(Binder.getCallingUid());
        TunnelInterfaceRecord tunnelInterfaceInfo = userRecord.mTunnelInterfaceRecords.getResourceOrThrow(tunnelResourceId);
    }

    @Override
    public synchronized void deleteTunnelInterface(int resourceId) throws RemoteException {
        UserRecord userRecord = this.mUserResourceTracker.getUserRecord(Binder.getCallingUid());
        this.releaseResource(userRecord.mTunnelInterfaceRecords, resourceId);
    }

    @VisibleForTesting
    void validateAlgorithms(IpSecConfig config) throws IllegalArgumentException {
        IpSecAlgorithm auth = config.getAuthentication();
        IpSecAlgorithm crypt = config.getEncryption();
        IpSecAlgorithm aead = config.getAuthenticatedEncryption();
        Preconditions.checkArgument(aead != null || crypt != null || auth != null, "No Encryption or Authentication algorithms specified");
        Preconditions.checkArgument(auth == null || auth.isAuthentication(), "Unsupported algorithm for Authentication");
        Preconditions.checkArgument(crypt == null || crypt.isEncryption(), "Unsupported algorithm for Encryption");
        Preconditions.checkArgument(aead == null || aead.isAead(), "Unsupported algorithm for Authenticated Encryption");
        Preconditions.checkArgument(aead == null || auth == null && crypt == null, "Authenticated Encryption is mutually exclusive with other Authentication or Encryption algorithms");
    }

    private void checkIpSecConfig(IpSecConfig config) {
        UserRecord userRecord = this.mUserResourceTracker.getUserRecord(Binder.getCallingUid());
        switch (config.getEncapType()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                userRecord.mEncapSocketRecords.getResourceOrThrow(config.getEncapSocketResourceId());
                int port = config.getEncapRemotePort();
                if (port > 0 && port <= 65535) break;
                throw new IllegalArgumentException("Invalid remote UDP port: " + port);
            }
            default: {
                throw new IllegalArgumentException("Invalid Encap Type: " + config.getEncapType());
            }
        }
        this.validateAlgorithms(config);
        SpiRecord s = userRecord.mSpiRecords.getResourceOrThrow(config.getSpiResourceId());
        if (s.getOwnedByTransform()) {
            throw new IllegalStateException("SPI already in use; cannot be used in new Transforms");
        }
        if (TextUtils.isEmpty(config.getDestinationAddress())) {
            config.setDestinationAddress(s.getDestinationAddress());
        }
        if (!config.getDestinationAddress().equals(s.getDestinationAddress())) {
            throw new IllegalArgumentException("Mismatched remote addresseses.");
        }
        IpSecService.checkInetAddress(config.getDestinationAddress());
        IpSecService.checkInetAddress(config.getSourceAddress());
        switch (config.getMode()) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid IpSecTransform.mode: " + config.getMode());
            }
        }
    }

    private void createOrUpdateTransform(IpSecConfig c, int resourceId, SpiRecord spiRecord, EncapSocketRecord socketRecord) throws RemoteException {
        int encapType = c.getEncapType();
        int encapLocalPort = 0;
        int encapRemotePort = 0;
        if (encapType != 0) {
            encapLocalPort = socketRecord.getPort();
            encapRemotePort = c.getEncapRemotePort();
        }
        IpSecAlgorithm auth = c.getAuthentication();
        IpSecAlgorithm crypt = c.getEncryption();
        IpSecAlgorithm authCrypt = c.getAuthenticatedEncryption();
        this.mSrvConfig.getNetdInstance().ipSecAddSecurityAssociation(resourceId, c.getMode(), c.getSourceAddress(), c.getDestinationAddress(), c.getNetwork() != null ? c.getNetwork().netId : 0, spiRecord.getSpi(), c.getMarkValue(), c.getMarkMask(), auth != null ? auth.getName() : "", auth != null ? auth.getKey() : new byte[]{}, auth != null ? auth.getTruncationLengthBits() : 0, crypt != null ? crypt.getName() : "", crypt != null ? crypt.getKey() : new byte[]{}, crypt != null ? crypt.getTruncationLengthBits() : 0, authCrypt != null ? authCrypt.getName() : "", authCrypt != null ? authCrypt.getKey() : new byte[]{}, authCrypt != null ? authCrypt.getTruncationLengthBits() : 0, encapType, encapLocalPort, encapRemotePort);
    }

    @Override
    public synchronized IpSecTransformResponse createTransform(IpSecConfig c, IBinder binder) throws RemoteException {
        this.checkIpSecConfig(c);
        Preconditions.checkNotNull(binder, "Null Binder passed to createTransform");
        int resourceId = this.mNextResourceId++;
        UserRecord userRecord = this.mUserResourceTracker.getUserRecord(Binder.getCallingUid());
        ArrayList<RefcountedResource<OwnedResourceRecord>> dependencies = new ArrayList<RefcountedResource<OwnedResourceRecord>>();
        if (!userRecord.mTransformQuotaTracker.isAvailable()) {
            return new IpSecTransformResponse(1);
        }
        EncapSocketRecord socketRecord = null;
        if (c.getEncapType() != 0) {
            RefcountedResource<EncapSocketRecord> refcountedSocketRecord = userRecord.mEncapSocketRecords.getRefcountedResourceOrThrow(c.getEncapSocketResourceId());
            dependencies.add(refcountedSocketRecord);
            socketRecord = refcountedSocketRecord.getResource();
        }
        RefcountedResource<SpiRecord> refcountedSpiRecord = userRecord.mSpiRecords.getRefcountedResourceOrThrow(c.getSpiResourceId());
        dependencies.add(refcountedSpiRecord);
        SpiRecord spiRecord = refcountedSpiRecord.getResource();
        try {
            this.createOrUpdateTransform(c, resourceId, spiRecord, socketRecord);
        }
        catch (ServiceSpecificException e) {
            return new IpSecTransformResponse(1);
        }
        userRecord.mTransformRecords.put(resourceId, new RefcountedResource(this, (IResource)new TransformRecord(resourceId, c, spiRecord, socketRecord), binder, dependencies.toArray(new RefcountedResource[dependencies.size()])));
        return new IpSecTransformResponse(0, resourceId);
    }

    @Override
    public synchronized void deleteTransform(int resourceId) throws RemoteException {
        UserRecord userRecord = this.mUserResourceTracker.getUserRecord(Binder.getCallingUid());
        this.releaseResource(userRecord.mTransformRecords, resourceId);
    }

    @Override
    public synchronized void applyTransportModeTransform(ParcelFileDescriptor socket, int direction, int resourceId) throws RemoteException {
        UserRecord userRecord = this.mUserResourceTracker.getUserRecord(Binder.getCallingUid());
        IpSecService.checkDirection(direction);
        TransformRecord info = userRecord.mTransformRecords.getResourceOrThrow(resourceId);
        if (info.pid != IpSecService.getCallingPid() || info.uid != IpSecService.getCallingUid()) {
            throw new SecurityException("Only the owner of an IpSec Transform may apply it!");
        }
        IpSecConfig c = info.getConfig();
        Preconditions.checkArgument(c.getMode() == 0, "Transform mode was not Transport mode; cannot be applied to a socket");
        try {
            this.mSrvConfig.getNetdInstance().ipSecApplyTransportModeTransform(socket.getFileDescriptor(), resourceId, direction, c.getSourceAddress(), c.getDestinationAddress(), info.getSpiRecord().getSpi());
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == OsConstants.EINVAL) {
                throw new IllegalArgumentException(e.toString());
            }
            throw e;
        }
    }

    @Override
    public synchronized void removeTransportModeTransforms(ParcelFileDescriptor socket) throws RemoteException {
        try {
            this.mSrvConfig.getNetdInstance().ipSecRemoveTransportModeTransform(socket.getFileDescriptor());
        }
        catch (ServiceSpecificException serviceSpecificException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void applyTunnelModeTransform(int tunnelResourceId, int direction, int transformResourceId) throws RemoteException {
        IpSecService.checkDirection(direction);
        UserRecord userRecord = this.mUserResourceTracker.getUserRecord(Binder.getCallingUid());
        TransformRecord transformInfo = userRecord.mTransformRecords.getResourceOrThrow(transformResourceId);
        TunnelInterfaceRecord tunnelInterfaceInfo = userRecord.mTunnelInterfaceRecords.getResourceOrThrow(tunnelResourceId);
        IpSecConfig c = transformInfo.getConfig();
        Preconditions.checkArgument(c.getMode() == 1, "Transform mode was not Tunnel mode; cannot be applied to a tunnel interface");
        EncapSocketRecord socketRecord = null;
        if (c.getEncapType() != 0) {
            socketRecord = userRecord.mEncapSocketRecords.getResourceOrThrow(c.getEncapSocketResourceId());
        }
        SpiRecord spiRecord = userRecord.mSpiRecords.getResourceOrThrow(c.getSpiResourceId());
        int mark = direction == 0 ? tunnelInterfaceInfo.getIkey() : tunnelInterfaceInfo.getOkey();
        try {
            c.setMarkValue(mark);
            c.setMarkMask(-1);
            if (direction == 1) {
                c.setNetwork(tunnelInterfaceInfo.getUnderlyingNetwork());
                for (String wildcardAddr : WILDCARD_ADDRESSES) {
                    this.mSrvConfig.getNetdInstance().ipSecUpdateSecurityPolicy(0, direction, wildcardAddr, wildcardAddr, transformInfo.getSpiRecord().getSpi(), mark, -1);
                }
            }
            this.createOrUpdateTransform(c, transformResourceId, spiRecord, socketRecord);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == OsConstants.EINVAL) {
                throw new IllegalArgumentException(e.toString());
            }
            throw e;
        }
    }

    @Override
    protected synchronized void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        pw.println("IpSecService dump:");
        pw.println("NetdNativeService Connection: " + (this.isNetdAlive() ? "alive" : "dead"));
        pw.println();
        pw.println("mUserResourceTracker:");
        pw.println(this.mUserResourceTracker);
    }

    static {
        try {
            INADDR_ANY = InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public static interface UidFdTagger {
        public void tag(FileDescriptor var1, int var2) throws IOException;
    }

    private final class EncapSocketRecord
    extends OwnedResourceRecord {
        private FileDescriptor mSocket;
        private final int mPort;

        EncapSocketRecord(int resourceId, FileDescriptor socket, int port) {
            super(resourceId);
            this.mSocket = socket;
            this.mPort = port;
        }

        @Override
        public void freeUnderlyingResources() {
            Log.d(IpSecService.TAG, "Closing port " + this.mPort);
            IoUtils.closeQuietly(this.mSocket);
            this.mSocket = null;
            this.getResourceTracker().give();
        }

        public int getPort() {
            return this.mPort;
        }

        public FileDescriptor getSocket() {
            return this.mSocket;
        }

        @Override
        protected ResourceTracker getResourceTracker() {
            return this.getUserRecord().mSocketQuotaTracker;
        }

        @Override
        public void invalidate() {
            this.getUserRecord().removeEncapSocketRecord(this.mResourceId);
        }

        @Override
        public String toString() {
            return "{super=" + super.toString() + ", mSocket=" + this.mSocket + ", mPort=" + this.mPort + "}";
        }
    }

    private final class TunnelInterfaceRecord
    extends OwnedResourceRecord {
        private final String mInterfaceName;
        private final Network mUnderlyingNetwork;
        private final String mLocalAddress;
        private final String mRemoteAddress;
        private final int mIkey;
        private final int mOkey;

        TunnelInterfaceRecord(int resourceId, String interfaceName, Network underlyingNetwork, String localAddr, String remoteAddr, int ikey, int okey) {
            super(resourceId);
            this.mInterfaceName = interfaceName;
            this.mUnderlyingNetwork = underlyingNetwork;
            this.mLocalAddress = localAddr;
            this.mRemoteAddress = remoteAddr;
            this.mIkey = ikey;
            this.mOkey = okey;
        }

        @Override
        public void freeUnderlyingResources() {
            try {
                IpSecService.this.mSrvConfig.getNetdInstance().removeVirtualTunnelInterface(this.mInterfaceName);
                for (String wildcardAddr : WILDCARD_ADDRESSES) {
                    for (int direction : DIRECTIONS) {
                        int mark = direction == 0 ? this.mIkey : this.mOkey;
                        IpSecService.this.mSrvConfig.getNetdInstance().ipSecDeleteSecurityPolicy(0, direction, wildcardAddr, wildcardAddr, mark, -1);
                    }
                }
            }
            catch (ServiceSpecificException serviceSpecificException) {
            }
            catch (RemoteException e) {
                Log.e(IpSecService.TAG, "Failed to delete VTI with interface name: " + this.mInterfaceName + " and id: " + this.mResourceId);
            }
            this.getResourceTracker().give();
            IpSecService.this.releaseNetId(this.mIkey);
            IpSecService.this.releaseNetId(this.mOkey);
        }

        public String getInterfaceName() {
            return this.mInterfaceName;
        }

        public Network getUnderlyingNetwork() {
            return this.mUnderlyingNetwork;
        }

        public String getLocalAddress() {
            return this.mLocalAddress;
        }

        public String getRemoteAddress() {
            return this.mRemoteAddress;
        }

        public int getIkey() {
            return this.mIkey;
        }

        public int getOkey() {
            return this.mOkey;
        }

        @Override
        protected ResourceTracker getResourceTracker() {
            return this.getUserRecord().mTunnelQuotaTracker;
        }

        @Override
        public void invalidate() {
            this.getUserRecord().removeTunnelInterfaceRecord(this.mResourceId);
        }

        @Override
        public String toString() {
            return "{super=" + super.toString() + ", mInterfaceName=" + this.mInterfaceName + ", mUnderlyingNetwork=" + this.mUnderlyingNetwork + ", mLocalAddress=" + this.mLocalAddress + ", mRemoteAddress=" + this.mRemoteAddress + ", mIkey=" + this.mIkey + ", mOkey=" + this.mOkey + "}";
        }
    }

    private final class SpiRecord
    extends OwnedResourceRecord {
        private final String mSourceAddress;
        private final String mDestinationAddress;
        private int mSpi;
        private boolean mOwnedByTransform;

        SpiRecord(int resourceId, String sourceAddress, String destinationAddress, int spi) {
            super(resourceId);
            this.mOwnedByTransform = false;
            this.mSourceAddress = sourceAddress;
            this.mDestinationAddress = destinationAddress;
            this.mSpi = spi;
        }

        @Override
        public void freeUnderlyingResources() {
            try {
                IpSecService.this.mSrvConfig.getNetdInstance().ipSecDeleteSecurityAssociation(this.mResourceId, this.mSourceAddress, this.mDestinationAddress, this.mSpi, 0, 0);
            }
            catch (ServiceSpecificException serviceSpecificException) {
            }
            catch (RemoteException e) {
                Log.e(IpSecService.TAG, "Failed to delete SPI reservation with ID: " + this.mResourceId);
            }
            this.mSpi = 0;
            this.getResourceTracker().give();
        }

        public int getSpi() {
            return this.mSpi;
        }

        public String getDestinationAddress() {
            return this.mDestinationAddress;
        }

        public void setOwnedByTransform() {
            if (this.mOwnedByTransform) {
                throw new IllegalStateException("Cannot own an SPI twice!");
            }
            this.mOwnedByTransform = true;
        }

        public boolean getOwnedByTransform() {
            return this.mOwnedByTransform;
        }

        @Override
        public void invalidate() throws RemoteException {
            this.getUserRecord().removeSpiRecord(this.mResourceId);
        }

        @Override
        protected ResourceTracker getResourceTracker() {
            return this.getUserRecord().mSpiQuotaTracker;
        }

        @Override
        public String toString() {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("{super=").append(super.toString()).append(", mSpi=").append(this.mSpi).append(", mSourceAddress=").append(this.mSourceAddress).append(", mDestinationAddress=").append(this.mDestinationAddress).append(", mOwnedByTransform=").append(this.mOwnedByTransform).append("}");
            return strBuilder.toString();
        }
    }

    private final class TransformRecord
    extends OwnedResourceRecord {
        private final IpSecConfig mConfig;
        private final SpiRecord mSpi;
        private final EncapSocketRecord mSocket;

        TransformRecord(int resourceId, IpSecConfig config, SpiRecord spi, EncapSocketRecord socket) {
            super(resourceId);
            this.mConfig = config;
            this.mSpi = spi;
            this.mSocket = socket;
            spi.setOwnedByTransform();
        }

        public IpSecConfig getConfig() {
            return this.mConfig;
        }

        public SpiRecord getSpiRecord() {
            return this.mSpi;
        }

        public EncapSocketRecord getSocketRecord() {
            return this.mSocket;
        }

        @Override
        public void freeUnderlyingResources() {
            int spi = this.mSpi.getSpi();
            try {
                IpSecService.this.mSrvConfig.getNetdInstance().ipSecDeleteSecurityAssociation(this.mResourceId, this.mConfig.getSourceAddress(), this.mConfig.getDestinationAddress(), spi, this.mConfig.getMarkValue(), this.mConfig.getMarkMask());
            }
            catch (ServiceSpecificException serviceSpecificException) {
            }
            catch (RemoteException e) {
                Log.e(IpSecService.TAG, "Failed to delete SA with ID: " + this.mResourceId);
            }
            this.getResourceTracker().give();
        }

        @Override
        public void invalidate() throws RemoteException {
            this.getUserRecord().removeTransformRecord(this.mResourceId);
        }

        @Override
        protected ResourceTracker getResourceTracker() {
            return this.getUserRecord().mTransformQuotaTracker;
        }

        @Override
        public String toString() {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("{super=").append(super.toString()).append(", mSocket=").append(this.mSocket).append(", mSpi.mResourceId=").append(this.mSpi.mResourceId).append(", mConfig=").append(this.mConfig).append("}");
            return strBuilder.toString();
        }
    }

    static class RefcountedResourceArray<T extends IResource> {
        SparseArray<RefcountedResource<T>> mArray = new SparseArray();
        private final String mTypeName;

        public RefcountedResourceArray(String typeName) {
            this.mTypeName = typeName;
        }

        T getResourceOrThrow(int key) {
            return this.getRefcountedResourceOrThrow(key).getResource();
        }

        RefcountedResource<T> getRefcountedResourceOrThrow(int key) {
            RefcountedResource<T> resource = this.mArray.get(key);
            if (resource == null) {
                throw new IllegalArgumentException(String.format("No such %s found for given id: %d", this.mTypeName, key));
            }
            return resource;
        }

        void put(int key, RefcountedResource<T> obj) {
            Preconditions.checkNotNull(obj, "Null resources cannot be added");
            this.mArray.put(key, obj);
        }

        void remove(int key) {
            this.mArray.remove(key);
        }

        public String toString() {
            return this.mArray.toString();
        }
    }

    private abstract class OwnedResourceRecord
    implements IResource {
        final int pid;
        final int uid;
        protected final int mResourceId;

        OwnedResourceRecord(int resourceId) {
            if (resourceId == -1) {
                throw new IllegalArgumentException("Resource ID must not be INVALID_RESOURCE_ID");
            }
            this.mResourceId = resourceId;
            this.pid = Binder.getCallingPid();
            this.uid = Binder.getCallingUid();
            this.getResourceTracker().take();
        }

        @Override
        public abstract void invalidate() throws RemoteException;

        protected UserRecord getUserRecord() {
            return IpSecService.this.mUserResourceTracker.getUserRecord(this.uid);
        }

        @Override
        public abstract void freeUnderlyingResources() throws RemoteException;

        protected abstract ResourceTracker getResourceTracker();

        public String toString() {
            return "{mResourceId=" + this.mResourceId + ", pid=" + this.pid + ", uid=" + this.uid + "}";
        }
    }

    @VisibleForTesting
    static final class UserResourceTracker {
        private final SparseArray<UserRecord> mUserRecords = new SparseArray();

        UserResourceTracker() {
        }

        public UserRecord getUserRecord(int uid) {
            this.checkCallerUid(uid);
            UserRecord r = this.mUserRecords.get(uid);
            if (r == null) {
                r = new UserRecord();
                this.mUserRecords.put(uid, r);
            }
            return r;
        }

        private void checkCallerUid(int uid) {
            if (uid != Binder.getCallingUid() && 1000 != Binder.getCallingUid()) {
                throw new SecurityException("Attempted access of unowned resources");
            }
        }

        public String toString() {
            return this.mUserRecords.toString();
        }
    }

    @VisibleForTesting
    static final class UserRecord {
        public static final int MAX_NUM_TUNNEL_INTERFACES = 2;
        public static final int MAX_NUM_ENCAP_SOCKETS = 2;
        public static final int MAX_NUM_TRANSFORMS = 4;
        public static final int MAX_NUM_SPIS = 8;
        final RefcountedResourceArray<SpiRecord> mSpiRecords = new RefcountedResourceArray(SpiRecord.class.getSimpleName());
        final RefcountedResourceArray<TransformRecord> mTransformRecords = new RefcountedResourceArray(TransformRecord.class.getSimpleName());
        final RefcountedResourceArray<EncapSocketRecord> mEncapSocketRecords = new RefcountedResourceArray(EncapSocketRecord.class.getSimpleName());
        final RefcountedResourceArray<TunnelInterfaceRecord> mTunnelInterfaceRecords = new RefcountedResourceArray(TunnelInterfaceRecord.class.getSimpleName());
        final ResourceTracker mSpiQuotaTracker = new ResourceTracker(8);
        final ResourceTracker mTransformQuotaTracker = new ResourceTracker(4);
        final ResourceTracker mSocketQuotaTracker = new ResourceTracker(2);
        final ResourceTracker mTunnelQuotaTracker = new ResourceTracker(2);

        UserRecord() {
        }

        void removeSpiRecord(int resourceId) {
            this.mSpiRecords.remove(resourceId);
        }

        void removeTransformRecord(int resourceId) {
            this.mTransformRecords.remove(resourceId);
        }

        void removeTunnelInterfaceRecord(int resourceId) {
            this.mTunnelInterfaceRecords.remove(resourceId);
        }

        void removeEncapSocketRecord(int resourceId) {
            this.mEncapSocketRecords.remove(resourceId);
        }

        public String toString() {
            return "{mSpiQuotaTracker=" + this.mSpiQuotaTracker + ", mTransformQuotaTracker=" + this.mTransformQuotaTracker + ", mSocketQuotaTracker=" + this.mSocketQuotaTracker + ", mTunnelQuotaTracker=" + this.mTunnelQuotaTracker + ", mSpiRecords=" + this.mSpiRecords + ", mTransformRecords=" + this.mTransformRecords + ", mEncapSocketRecords=" + this.mEncapSocketRecords + ", mTunnelInterfaceRecords=" + this.mTunnelInterfaceRecords + "}";
        }
    }

    @VisibleForTesting
    static class ResourceTracker {
        private final int mMax;
        int mCurrent;

        ResourceTracker(int max) {
            this.mMax = max;
            this.mCurrent = 0;
        }

        boolean isAvailable() {
            return this.mCurrent < this.mMax;
        }

        void take() {
            if (!this.isAvailable()) {
                Log.wtf(IpSecService.TAG, "Too many resources allocated!");
            }
            ++this.mCurrent;
        }

        void give() {
            if (this.mCurrent <= 0) {
                Log.wtf(IpSecService.TAG, "We've released this resource too many times");
            }
            --this.mCurrent;
        }

        public String toString() {
            return "{mCurrent=" + this.mCurrent + ", mMax=" + this.mMax + "}";
        }
    }

    @VisibleForTesting
    public static class RefcountedResource<T extends IResource>
    implements IBinder.DeathRecipient {
        private final T mResource;
        private final List<RefcountedResource> mChildren;
        int mRefCount = 1;
        IBinder mBinder;
        final /* synthetic */ IpSecService this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RefcountedResource(T resource, IBinder binder, RefcountedResource ... children) {
            this.this$0 = this$0;
            reference var5_5 = this$0;
            synchronized (var5_5) {
                this.mResource = resource;
                this.mChildren = new ArrayList<RefcountedResource>(children.length);
                this.mBinder = binder;
                for (RefcountedResource child : children) {
                    this.mChildren.add(child);
                    ++child.mRefCount;
                }
                try {
                    this.mBinder.linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    this.binderDied();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            IpSecService ipSecService = this.this$0;
            synchronized (ipSecService) {
                try {
                    this.userRelease();
                }
                catch (Exception e) {
                    Log.e(IpSecService.TAG, "Failed to release resource: " + e);
                }
            }
        }

        public T getResource() {
            return this.mResource;
        }

        @GuardedBy(value="IpSecService.this")
        public void userRelease() throws RemoteException {
            if (this.mBinder == null) {
                return;
            }
            this.mBinder.unlinkToDeath(this, 0);
            this.mBinder = null;
            this.mResource.invalidate();
            this.releaseReference();
        }

        @VisibleForTesting
        @GuardedBy(value="IpSecService.this")
        public void releaseReference() throws RemoteException {
            --this.mRefCount;
            if (this.mRefCount > 0) {
                return;
            }
            if (this.mRefCount < 0) {
                throw new IllegalStateException("Invalid operation - resource has already been released.");
            }
            this.mResource.freeUnderlyingResources();
            for (RefcountedResource child : this.mChildren) {
                child.releaseReference();
            }
            --this.mRefCount;
        }

        public String toString() {
            return "{mResource=" + this.mResource + ", mRefCount=" + this.mRefCount + ", mChildren=" + this.mChildren + "}";
        }
    }

    @VisibleForTesting
    public static interface IResource {
        public void invalidate() throws RemoteException;

        public void freeUnderlyingResources() throws RemoteException;
    }

    static interface IpSecServiceConfiguration {
        public static final IpSecServiceConfiguration GETSRVINSTANCE = new IpSecServiceConfiguration(){

            @Override
            public INetd getNetdInstance() throws RemoteException {
                INetd netd = NetdService.getInstance();
                if (netd == null) {
                    throw new RemoteException("Failed to Get Netd Instance");
                }
                return netd;
            }
        };

        public INetd getNetdInstance() throws RemoteException;
    }
}

