/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManagerInternal;
import android.database.ContentObserver;
import android.net.INetworkRecommendationProvider;
import android.net.INetworkScoreCache;
import android.net.INetworkScoreService;
import android.net.NetworkKey;
import android.net.NetworkScorerAppData;
import android.net.ScoredNetwork;
import android.net.Uri;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiScanner;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.TransferPipe;
import com.android.internal.util.DumpUtils;
import com.android.server.LocalServices;
import com.android.server.NetworkScorerAppManager;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class NetworkScoreService
extends INetworkScoreService.Stub {
    private static final String TAG = "NetworkScoreService";
    private static final boolean DBG = Build.IS_DEBUGGABLE && Log.isLoggable("NetworkScoreService", 3);
    private static final boolean VERBOSE = Build.IS_DEBUGGABLE && Log.isLoggable("NetworkScoreService", 2);
    private final Context mContext;
    private final NetworkScorerAppManager mNetworkScorerAppManager;
    @GuardedBy(value="mScoreCaches")
    private final Map<Integer, RemoteCallbackList<INetworkScoreCache>> mScoreCaches;
    private final Object mPackageMonitorLock = new Object();
    private final Object mServiceConnectionLock = new Object();
    private final Handler mHandler;
    private final DispatchingContentObserver mRecommendationSettingsObserver;
    private final ContentObserver mUseOpenWifiPackageObserver;
    private final Function<NetworkScorerAppData, ScoringServiceConnection> mServiceConnProducer;
    @GuardedBy(value="mPackageMonitorLock")
    private NetworkScorerPackageMonitor mPackageMonitor;
    @GuardedBy(value="mServiceConnectionLock")
    private ScoringServiceConnection mServiceConnection;
    private BroadcastReceiver mUserIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            if (DBG) {
                Log.d(NetworkScoreService.TAG, "Received " + action + " for userId " + userId);
            }
            if (userId == -10000) {
                return;
            }
            if ("android.intent.action.USER_UNLOCKED".equals(action)) {
                NetworkScoreService.this.onUserUnlocked(userId);
            }
        }
    };
    private BroadcastReceiver mLocationModeReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.location.MODE_CHANGED".equals(action)) {
                NetworkScoreService.this.refreshBinding();
            }
        }
    };

    public NetworkScoreService(Context context) {
        this(context, new NetworkScorerAppManager(context), ScoringServiceConnection::new, Looper.myLooper());
    }

    @VisibleForTesting
    NetworkScoreService(Context context, NetworkScorerAppManager networkScoreAppManager, Function<NetworkScorerAppData, ScoringServiceConnection> serviceConnProducer, Looper looper) {
        this.mContext = context;
        this.mNetworkScorerAppManager = networkScoreAppManager;
        this.mScoreCaches = new ArrayMap<Integer, RemoteCallbackList<INetworkScoreCache>>();
        IntentFilter filter = new IntentFilter("android.intent.action.USER_UNLOCKED");
        this.mContext.registerReceiverAsUser(this.mUserIntentReceiver, UserHandle.SYSTEM, filter, null, null);
        this.mHandler = new ServiceHandler(looper);
        IntentFilter locationModeFilter = new IntentFilter("android.location.MODE_CHANGED");
        this.mContext.registerReceiverAsUser(this.mLocationModeReceiver, UserHandle.SYSTEM, locationModeFilter, null, this.mHandler);
        this.mRecommendationSettingsObserver = new DispatchingContentObserver(context, this.mHandler);
        this.mServiceConnProducer = serviceConnProducer;
        this.mUseOpenWifiPackageObserver = new ContentObserver(this.mHandler){

            @Override
            public void onChange(boolean selfChange, Uri uri, int userId) {
                String useOpenWifiPackage;
                Uri useOpenWifiPkgUri = Settings.Global.getUriFor("use_open_wifi_package");
                if (useOpenWifiPkgUri.equals(uri) && !TextUtils.isEmpty(useOpenWifiPackage = Settings.Global.getString(NetworkScoreService.this.mContext.getContentResolver(), "use_open_wifi_package"))) {
                    LocalServices.getService(PackageManagerInternal.class).grantDefaultPermissionsToDefaultUseOpenWifiApp(useOpenWifiPackage, userId);
                }
            }
        };
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("use_open_wifi_package"), false, this.mUseOpenWifiPackageObserver);
        LocalServices.getService(PackageManagerInternal.class).setUseOpenWifiAppPackagesProvider(new PackageManagerInternal.PackagesProvider(){

            @Override
            public String[] getPackages(int userId) {
                String useOpenWifiPackage = Settings.Global.getString(NetworkScoreService.this.mContext.getContentResolver(), "use_open_wifi_package");
                if (!TextUtils.isEmpty(useOpenWifiPackage)) {
                    return new String[]{useOpenWifiPackage};
                }
                return null;
            }
        });
    }

    void systemReady() {
        if (DBG) {
            Log.d(TAG, "systemReady");
        }
        this.registerRecommendationSettingsObserver();
    }

    void systemRunning() {
        if (DBG) {
            Log.d(TAG, "systemRunning");
        }
    }

    @VisibleForTesting
    void onUserUnlocked(int userId) {
        if (DBG) {
            Log.d(TAG, "onUserUnlocked(" + userId + ")");
        }
        this.refreshBinding();
    }

    private void refreshBinding() {
        if (DBG) {
            Log.d(TAG, "refreshBinding()");
        }
        this.mNetworkScorerAppManager.updateState();
        this.mNetworkScorerAppManager.migrateNetworkScorerAppSettingIfNeeded();
        this.registerPackageMonitorIfNeeded();
        this.bindToScoringServiceIfNeeded();
    }

    private void registerRecommendationSettingsObserver() {
        Uri packageNameUri = Settings.Global.getUriFor("network_recommendations_package");
        this.mRecommendationSettingsObserver.observe(packageNameUri, 1);
        Uri settingUri = Settings.Global.getUriFor("network_recommendations_enabled");
        this.mRecommendationSettingsObserver.observe(settingUri, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPackageMonitorIfNeeded() {
        if (DBG) {
            Log.d(TAG, "registerPackageMonitorIfNeeded()");
        }
        NetworkScorerAppData appData = this.mNetworkScorerAppManager.getActiveScorer();
        Object object = this.mPackageMonitorLock;
        synchronized (object) {
            if (!(this.mPackageMonitor == null || appData != null && appData.getRecommendationServicePackageName().equals(this.mPackageMonitor.mPackageToWatch))) {
                if (DBG) {
                    Log.d(TAG, "Unregistering package monitor for " + this.mPackageMonitor.mPackageToWatch);
                }
                this.mPackageMonitor.unregister();
                this.mPackageMonitor = null;
            }
            if (appData != null && this.mPackageMonitor == null) {
                this.mPackageMonitor = new NetworkScorerPackageMonitor(appData.getRecommendationServicePackageName());
                this.mPackageMonitor.register(this.mContext, null, UserHandle.SYSTEM, false);
                if (DBG) {
                    Log.d(TAG, "Registered package monitor for " + this.mPackageMonitor.mPackageToWatch);
                }
            }
        }
    }

    private void bindToScoringServiceIfNeeded() {
        if (DBG) {
            Log.d(TAG, "bindToScoringServiceIfNeeded");
        }
        NetworkScorerAppData scorerData = this.mNetworkScorerAppManager.getActiveScorer();
        this.bindToScoringServiceIfNeeded(scorerData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindToScoringServiceIfNeeded(NetworkScorerAppData appData) {
        if (DBG) {
            Log.d(TAG, "bindToScoringServiceIfNeeded(" + appData + ")");
        }
        if (appData != null) {
            Object object = this.mServiceConnectionLock;
            synchronized (object) {
                if (this.mServiceConnection != null && !this.mServiceConnection.getAppData().equals(appData)) {
                    this.unbindFromScoringServiceIfNeeded();
                }
                if (this.mServiceConnection == null) {
                    this.mServiceConnection = this.mServiceConnProducer.apply(appData);
                }
                this.mServiceConnection.bind(this.mContext);
            }
        } else {
            this.unbindFromScoringServiceIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindFromScoringServiceIfNeeded() {
        if (DBG) {
            Log.d(TAG, "unbindFromScoringServiceIfNeeded");
        }
        Object object = this.mServiceConnectionLock;
        synchronized (object) {
            if (this.mServiceConnection != null) {
                this.mServiceConnection.unbind(this.mContext);
                if (DBG) {
                    Log.d(TAG, "Disconnected from: " + this.mServiceConnection.getAppData().getRecommendationServiceComponent());
                }
            }
            this.mServiceConnection = null;
        }
        this.clearInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateScores(ScoredNetwork[] networks) {
        if (!this.isCallerActiveScorer(NetworkScoreService.getCallingUid())) {
            throw new SecurityException("Caller with UID " + NetworkScoreService.getCallingUid() + " is not the active scorer.");
        }
        long token = Binder.clearCallingIdentity();
        try {
            List networkList;
            ArrayMap networksByType = new ArrayMap();
            for (ScoredNetwork network : networks) {
                networkList = (List)networksByType.get(network.networkKey.type);
                if (networkList == null) {
                    networkList = new ArrayList();
                    networksByType.put(network.networkKey.type, networkList);
                }
                networkList.add(network);
            }
            for (Map.Entry entry : networksByType.entrySet()) {
                boolean isEmpty;
                RemoteCallbackList<INetworkScoreCache> callbackList;
                networkList = this.mScoreCaches;
                synchronized (networkList) {
                    callbackList = this.mScoreCaches.get(entry.getKey());
                    isEmpty = callbackList == null || callbackList.getRegisteredCallbackCount() == 0;
                }
                if (isEmpty) {
                    if (!Log.isLoggable(TAG, 2)) continue;
                    Log.v(TAG, "No scorer registered for type " + entry.getKey() + ", discarding");
                    continue;
                }
                FilteringCacheUpdatingConsumer consumer = FilteringCacheUpdatingConsumer.create(this.mContext, (List)entry.getValue(), (Integer)entry.getKey());
                this.sendCacheUpdateCallback(consumer, Collections.singleton(callbackList));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clearScores() {
        this.enforceSystemOrIsActiveScorer(NetworkScoreService.getCallingUid());
        long token = Binder.clearCallingIdentity();
        try {
            this.clearInternal();
            boolean bl = true;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    public boolean setActiveScorer(String packageName) {
        this.enforceSystemOrHasScoreNetworks();
        return this.mNetworkScorerAppManager.setActiveScorer(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCallerActiveScorer(int callingUid) {
        Object object = this.mServiceConnectionLock;
        synchronized (object) {
            return this.mServiceConnection != null && this.mServiceConnection.getAppData().packageUid == callingUid;
        }
    }

    private void enforceSystemOnly() throws SecurityException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REQUEST_NETWORK_SCORES", "Caller must be granted REQUEST_NETWORK_SCORES.");
    }

    private void enforceSystemOrHasScoreNetworks() throws SecurityException {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.REQUEST_NETWORK_SCORES") != 0 && this.mContext.checkCallingOrSelfPermission("android.permission.SCORE_NETWORKS") != 0) {
            throw new SecurityException("Caller is neither the system process or a network scorer.");
        }
    }

    private void enforceSystemOrIsActiveScorer(int callingUid) throws SecurityException {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.REQUEST_NETWORK_SCORES") != 0 && !this.isCallerActiveScorer(callingUid)) {
            throw new SecurityException("Caller is neither the system process or the active network scorer.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getActiveScorerPackage() {
        this.enforceSystemOrHasScoreNetworks();
        Object object = this.mServiceConnectionLock;
        synchronized (object) {
            if (this.mServiceConnection != null) {
                return this.mServiceConnection.getPackageName();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkScorerAppData getActiveScorer() {
        this.enforceSystemOnly();
        Object object = this.mServiceConnectionLock;
        synchronized (object) {
            if (this.mServiceConnection != null) {
                return this.mServiceConnection.getAppData();
            }
            return null;
        }
    }

    @Override
    public List<NetworkScorerAppData> getAllValidScorers() {
        this.enforceSystemOnly();
        return this.mNetworkScorerAppManager.getAllValidScorers();
    }

    @Override
    public void disableScoring() {
        this.enforceSystemOrIsActiveScorer(NetworkScoreService.getCallingUid());
    }

    private void clearInternal() {
        this.sendCacheUpdateCallback(new BiConsumer<INetworkScoreCache, Object>(){

            @Override
            public void accept(INetworkScoreCache networkScoreCache, Object cookie) {
                block2: {
                    try {
                        networkScoreCache.clearScores();
                    }
                    catch (RemoteException e) {
                        if (!Log.isLoggable(NetworkScoreService.TAG, 2)) break block2;
                        Log.v(NetworkScoreService.TAG, "Unable to clear scores", e);
                    }
                }
            }
        }, this.getScoreCacheLists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNetworkScoreCache(int networkType, INetworkScoreCache scoreCache, int filterType) {
        this.enforceSystemOnly();
        long token = Binder.clearCallingIdentity();
        try {
            Map<Integer, RemoteCallbackList<INetworkScoreCache>> map = this.mScoreCaches;
            synchronized (map) {
                RemoteCallbackList<INetworkScoreCache> callbackList = this.mScoreCaches.get(networkType);
                if (callbackList == null) {
                    callbackList = new RemoteCallbackList();
                    this.mScoreCaches.put(networkType, callbackList);
                }
                if (!callbackList.register(scoreCache, filterType)) {
                    if (callbackList.getRegisteredCallbackCount() == 0) {
                        this.mScoreCaches.remove(networkType);
                    }
                    if (Log.isLoggable(TAG, 2)) {
                        Log.v(TAG, "Unable to register NetworkScoreCache for type " + networkType);
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterNetworkScoreCache(int networkType, INetworkScoreCache scoreCache) {
        this.enforceSystemOnly();
        long token = Binder.clearCallingIdentity();
        try {
            Map<Integer, RemoteCallbackList<INetworkScoreCache>> map = this.mScoreCaches;
            synchronized (map) {
                RemoteCallbackList<INetworkScoreCache> callbackList = this.mScoreCaches.get(networkType);
                if (callbackList == null || !callbackList.unregister(scoreCache)) {
                    if (Log.isLoggable(TAG, 2)) {
                        Log.v(TAG, "Unable to unregister NetworkScoreCache for type " + networkType);
                    }
                } else if (callbackList.getRegisteredCallbackCount() == 0) {
                    this.mScoreCaches.remove(networkType);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean requestScores(NetworkKey[] networks) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(final FileDescriptor fd, final PrintWriter writer, final String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, writer)) {
            return;
        }
        long token = Binder.clearCallingIdentity();
        try {
            NetworkScorerAppData currentScorer = this.mNetworkScorerAppManager.getActiveScorer();
            if (currentScorer == null) {
                writer.println("Scoring is disabled.");
                return;
            }
            writer.println("Current scorer: " + currentScorer);
            this.sendCacheUpdateCallback(new BiConsumer<INetworkScoreCache, Object>(){

                @Override
                public void accept(INetworkScoreCache networkScoreCache, Object cookie) {
                    try {
                        TransferPipe.dumpAsync(networkScoreCache.asBinder(), fd, args);
                    }
                    catch (RemoteException | IOException e) {
                        writer.println("Failed to dump score cache: " + e);
                    }
                }
            }, this.getScoreCacheLists());
            Object object = this.mServiceConnectionLock;
            synchronized (object) {
                if (this.mServiceConnection != null) {
                    this.mServiceConnection.dump(fd, writer, args);
                } else {
                    writer.println("ScoringServiceConnection: null");
                }
            }
            writer.flush();
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<RemoteCallbackList<INetworkScoreCache>> getScoreCacheLists() {
        Map<Integer, RemoteCallbackList<INetworkScoreCache>> map = this.mScoreCaches;
        synchronized (map) {
            return new ArrayList<RemoteCallbackList<INetworkScoreCache>>(this.mScoreCaches.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCacheUpdateCallback(BiConsumer<INetworkScoreCache, Object> consumer, Collection<RemoteCallbackList<INetworkScoreCache>> remoteCallbackLists) {
        Iterator<RemoteCallbackList<INetworkScoreCache>> iterator = remoteCallbackLists.iterator();
        while (iterator.hasNext()) {
            RemoteCallbackList<INetworkScoreCache> callbackList;
            RemoteCallbackList<INetworkScoreCache> remoteCallbackList = callbackList = iterator.next();
            synchronized (remoteCallbackList) {
                int count = callbackList.beginBroadcast();
                try {
                    for (int i = 0; i < count; ++i) {
                        consumer.accept(callbackList.getBroadcastItem(i), callbackList.getBroadcastCookie(i));
                    }
                }
                finally {
                    callbackList.finishBroadcast();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private INetworkRecommendationProvider getRecommendationProvider() {
        Object object = this.mServiceConnectionLock;
        synchronized (object) {
            if (this.mServiceConnection != null) {
                return this.mServiceConnection.getRecommendationProvider();
            }
            return null;
        }
    }

    @VisibleForTesting
    public final class ServiceHandler
    extends Handler {
        public static final int MSG_RECOMMENDATIONS_PACKAGE_CHANGED = 1;
        public static final int MSG_RECOMMENDATION_ENABLED_SETTING_CHANGED = 2;

        public ServiceHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            int what = msg.what;
            switch (what) {
                case 1: 
                case 2: {
                    NetworkScoreService.this.refreshBinding();
                    break;
                }
                default: {
                    Log.w(NetworkScoreService.TAG, "Unknown message: " + what);
                }
            }
        }
    }

    @VisibleForTesting
    public static class ScoringServiceConnection
    implements ServiceConnection {
        private final NetworkScorerAppData mAppData;
        private volatile boolean mBound = false;
        private volatile boolean mConnected = false;
        private volatile INetworkRecommendationProvider mRecommendationProvider;

        ScoringServiceConnection(NetworkScorerAppData appData) {
            this.mAppData = appData;
        }

        @VisibleForTesting
        public void bind(Context context) {
            if (!this.mBound) {
                Intent service = new Intent("android.net.action.RECOMMEND_NETWORKS");
                service.setComponent(this.mAppData.getRecommendationServiceComponent());
                this.mBound = context.bindServiceAsUser(service, this, 0x4000001, UserHandle.SYSTEM);
                if (!this.mBound) {
                    Log.w(NetworkScoreService.TAG, "Bind call failed for " + service);
                    context.unbindService(this);
                } else if (DBG) {
                    Log.d(NetworkScoreService.TAG, "ScoringServiceConnection bound.");
                }
            }
        }

        @VisibleForTesting
        public void unbind(Context context) {
            try {
                if (this.mBound) {
                    this.mBound = false;
                    context.unbindService(this);
                    if (DBG) {
                        Log.d(NetworkScoreService.TAG, "ScoringServiceConnection unbound.");
                    }
                }
            }
            catch (RuntimeException e) {
                Log.e(NetworkScoreService.TAG, "Unbind failed.", e);
            }
            this.mConnected = false;
            this.mRecommendationProvider = null;
        }

        @VisibleForTesting
        public NetworkScorerAppData getAppData() {
            return this.mAppData;
        }

        @VisibleForTesting
        public INetworkRecommendationProvider getRecommendationProvider() {
            return this.mRecommendationProvider;
        }

        @VisibleForTesting
        public String getPackageName() {
            return this.mAppData.getRecommendationServiceComponent().getPackageName();
        }

        @VisibleForTesting
        public boolean isAlive() {
            return this.mBound && this.mConnected;
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            if (DBG) {
                Log.d(NetworkScoreService.TAG, "ScoringServiceConnection: " + name.flattenToString());
            }
            this.mConnected = true;
            this.mRecommendationProvider = INetworkRecommendationProvider.Stub.asInterface(service);
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            if (DBG) {
                Log.d(NetworkScoreService.TAG, "ScoringServiceConnection, disconnected: " + name.flattenToString());
            }
            this.mConnected = false;
            this.mRecommendationProvider = null;
        }

        public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
            writer.println("ScoringServiceConnection: " + this.mAppData.getRecommendationServiceComponent() + ", bound: " + this.mBound + ", connected: " + this.mConnected);
        }
    }

    @VisibleForTesting
    static class ScanResultsScoreCacheFilter
    implements UnaryOperator<List<ScoredNetwork>> {
        private final Set<NetworkKey> mScanResultKeys;

        ScanResultsScoreCacheFilter(Supplier<List<ScanResult>> resultsSupplier) {
            List<ScanResult> scanResults = resultsSupplier.get();
            int size = scanResults.size();
            this.mScanResultKeys = new ArraySet<NetworkKey>(size);
            for (int i = 0; i < size; ++i) {
                ScanResult scanResult = scanResults.get(i);
                NetworkKey key = NetworkKey.createFromScanResult(scanResult);
                if (key == null) continue;
                this.mScanResultKeys.add(key);
            }
        }

        @Override
        public List<ScoredNetwork> apply(List<ScoredNetwork> scoredNetworks) {
            if (this.mScanResultKeys.isEmpty() || scoredNetworks.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ScoredNetwork> filteredScores = new ArrayList<ScoredNetwork>();
            for (int i = 0; i < scoredNetworks.size(); ++i) {
                ScoredNetwork scoredNetwork = scoredNetworks.get(i);
                if (!this.mScanResultKeys.contains(scoredNetwork.networkKey)) continue;
                filteredScores.add(scoredNetwork);
            }
            return filteredScores;
        }
    }

    @VisibleForTesting
    static class CurrentNetworkScoreCacheFilter
    implements UnaryOperator<List<ScoredNetwork>> {
        private final NetworkKey mCurrentNetwork;

        CurrentNetworkScoreCacheFilter(Supplier<WifiInfo> wifiInfoSupplier) {
            this.mCurrentNetwork = NetworkKey.createFromWifiInfo(wifiInfoSupplier.get());
        }

        @Override
        public List<ScoredNetwork> apply(List<ScoredNetwork> scoredNetworks) {
            if (this.mCurrentNetwork == null || scoredNetworks.isEmpty()) {
                return Collections.emptyList();
            }
            for (int i = 0; i < scoredNetworks.size(); ++i) {
                ScoredNetwork scoredNetwork = scoredNetworks.get(i);
                if (!scoredNetwork.networkKey.equals(this.mCurrentNetwork)) continue;
                return Collections.singletonList(scoredNetwork);
            }
            return Collections.emptyList();
        }
    }

    private static class ScanResultsSupplier
    implements Supplier<List<ScanResult>> {
        private final Context mContext;

        ScanResultsSupplier(Context context) {
            this.mContext = context;
        }

        @Override
        public List<ScanResult> get() {
            WifiScanner wifiScanner = this.mContext.getSystemService(WifiScanner.class);
            if (wifiScanner != null) {
                return wifiScanner.getSingleScanResults();
            }
            Log.w(NetworkScoreService.TAG, "WifiScanner is null, failed to return scan results.");
            return Collections.emptyList();
        }
    }

    private static class WifiInfoSupplier
    implements Supplier<WifiInfo> {
        private final Context mContext;

        WifiInfoSupplier(Context context) {
            this.mContext = context;
        }

        @Override
        public WifiInfo get() {
            WifiManager wifiManager = this.mContext.getSystemService(WifiManager.class);
            if (wifiManager != null) {
                return wifiManager.getConnectionInfo();
            }
            Log.w(NetworkScoreService.TAG, "WifiManager is null, failed to return the WifiInfo.");
            return null;
        }
    }

    @VisibleForTesting
    static class FilteringCacheUpdatingConsumer
    implements BiConsumer<INetworkScoreCache, Object> {
        private final Context mContext;
        private final List<ScoredNetwork> mScoredNetworkList;
        private final int mNetworkType;
        private UnaryOperator<List<ScoredNetwork>> mCurrentNetworkFilter;
        private UnaryOperator<List<ScoredNetwork>> mScanResultsFilter;

        static FilteringCacheUpdatingConsumer create(Context context, List<ScoredNetwork> scoredNetworkList, int networkType) {
            return new FilteringCacheUpdatingConsumer(context, scoredNetworkList, networkType, null, null);
        }

        @VisibleForTesting
        FilteringCacheUpdatingConsumer(Context context, List<ScoredNetwork> scoredNetworkList, int networkType, UnaryOperator<List<ScoredNetwork>> currentNetworkFilter, UnaryOperator<List<ScoredNetwork>> scanResultsFilter) {
            this.mContext = context;
            this.mScoredNetworkList = scoredNetworkList;
            this.mNetworkType = networkType;
            this.mCurrentNetworkFilter = currentNetworkFilter;
            this.mScanResultsFilter = scanResultsFilter;
        }

        @Override
        public void accept(INetworkScoreCache networkScoreCache, Object cookie) {
            block4: {
                int filterType = 0;
                if (cookie instanceof Integer) {
                    filterType = (Integer)cookie;
                }
                try {
                    List<ScoredNetwork> filteredNetworkList = this.filterScores(this.mScoredNetworkList, filterType);
                    if (!filteredNetworkList.isEmpty()) {
                        networkScoreCache.updateScores(filteredNetworkList);
                    }
                }
                catch (RemoteException e) {
                    if (!VERBOSE) break block4;
                    Log.v(NetworkScoreService.TAG, "Unable to update scores of type " + this.mNetworkType, e);
                }
            }
        }

        private List<ScoredNetwork> filterScores(List<ScoredNetwork> scoredNetworkList, int filterType) {
            switch (filterType) {
                case 0: {
                    return scoredNetworkList;
                }
                case 1: {
                    if (this.mCurrentNetworkFilter == null) {
                        this.mCurrentNetworkFilter = new CurrentNetworkScoreCacheFilter(new WifiInfoSupplier(this.mContext));
                    }
                    return (List)this.mCurrentNetworkFilter.apply(scoredNetworkList);
                }
                case 2: {
                    if (this.mScanResultsFilter == null) {
                        this.mScanResultsFilter = new ScanResultsScoreCacheFilter(new ScanResultsSupplier(this.mContext));
                    }
                    return (List)this.mScanResultsFilter.apply(scoredNetworkList);
                }
            }
            Log.w(NetworkScoreService.TAG, "Unknown filter type: " + filterType);
            return scoredNetworkList;
        }
    }

    @VisibleForTesting
    public static class DispatchingContentObserver
    extends ContentObserver {
        private final Map<Uri, Integer> mUriEventMap;
        private final Context mContext;
        private final Handler mHandler;

        public DispatchingContentObserver(Context context, Handler handler) {
            super(handler);
            this.mContext = context;
            this.mHandler = handler;
            this.mUriEventMap = new ArrayMap<Uri, Integer>();
        }

        void observe(Uri uri, int what) {
            this.mUriEventMap.put(uri, what);
            ContentResolver resolver = this.mContext.getContentResolver();
            resolver.registerContentObserver(uri, false, this);
        }

        @Override
        public void onChange(boolean selfChange) {
            this.onChange(selfChange, null);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            Integer what;
            if (DBG) {
                Log.d(NetworkScoreService.TAG, String.format("onChange(%s, %s)", selfChange, uri));
            }
            if ((what = this.mUriEventMap.get(uri)) != null) {
                this.mHandler.obtainMessage(what).sendToTarget();
            } else {
                Log.w(NetworkScoreService.TAG, "No matching event to send for URI = " + uri);
            }
        }
    }

    private class NetworkScorerPackageMonitor
    extends PackageMonitor {
        final String mPackageToWatch;

        private NetworkScorerPackageMonitor(String packageToWatch) {
            this.mPackageToWatch = packageToWatch;
        }

        @Override
        public void onPackageAdded(String packageName, int uid) {
            this.evaluateBinding(packageName, true);
        }

        @Override
        public void onPackageRemoved(String packageName, int uid) {
            this.evaluateBinding(packageName, true);
        }

        @Override
        public void onPackageModified(String packageName) {
            this.evaluateBinding(packageName, false);
        }

        @Override
        public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
            if (doit) {
                for (String packageName : packages) {
                    this.evaluateBinding(packageName, true);
                }
            }
            return super.onHandleForceStop(intent, packages, uid, doit);
        }

        @Override
        public void onPackageUpdateFinished(String packageName, int uid) {
            this.evaluateBinding(packageName, true);
        }

        private void evaluateBinding(String changedPackageName, boolean forceUnbind) {
            NetworkScorerAppData activeScorer;
            if (!this.mPackageToWatch.equals(changedPackageName)) {
                return;
            }
            if (DBG) {
                Log.d(NetworkScoreService.TAG, "Evaluating binding for: " + changedPackageName + ", forceUnbind=" + forceUnbind);
            }
            if ((activeScorer = NetworkScoreService.this.mNetworkScorerAppManager.getActiveScorer()) == null) {
                if (DBG) {
                    Log.d(NetworkScoreService.TAG, "No active scorers available.");
                }
                NetworkScoreService.this.refreshBinding();
            } else {
                if (forceUnbind) {
                    NetworkScoreService.this.unbindFromScoringServiceIfNeeded();
                }
                if (DBG) {
                    Log.d(NetworkScoreService.TAG, "Binding to " + activeScorer.getRecommendationServiceComponent() + " if needed.");
                }
                NetworkScoreService.this.bindToScoringServiceIfNeeded(activeScorer);
            }
        }
    }
}

