/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.os.SystemClock;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import java.io.PrintWriter;

public class StatLogger {
    private final Object mLock = new Object();
    private final int SIZE;
    @GuardedBy(value="mLock")
    private final int[] mCountStats;
    @GuardedBy(value="mLock")
    private final long[] mDurationStats;
    private final String[] mLabels;

    public StatLogger(String[] eventLabels) {
        this.SIZE = eventLabels.length;
        this.mCountStats = new int[this.SIZE];
        this.mDurationStats = new long[this.SIZE];
        this.mLabels = eventLabels;
    }

    public long getTime() {
        return SystemClock.elapsedRealtimeNanos() / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDurationStat(int eventId, long start) {
        Object object = this.mLock;
        synchronized (object) {
            int n = eventId;
            this.mCountStats[n] = this.mCountStats[n] + 1;
            int n2 = eventId;
            this.mDurationStats[n2] = this.mDurationStats[n2] + (this.getTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String prefix) {
        Object object = this.mLock;
        synchronized (object) {
            pw.print(prefix);
            pw.println("Stats:");
            for (int i = 0; i < this.SIZE; ++i) {
                pw.print(prefix);
                pw.print("  ");
                int count = this.mCountStats[i];
                double durationMs = (double)this.mDurationStats[i] / 1000.0;
                pw.println(String.format("%s: count=%d, total=%.1fms, avg=%.3fms", this.mLabels[i], count, durationMs, count == 0 ? 0.0 : durationMs / (double)count));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpProto(ProtoOutputStream proto, long fieldId) {
        Object object = this.mLock;
        synchronized (object) {
            long outer = proto.start(fieldId);
            for (int i = 0; i < this.mLabels.length; ++i) {
                long inner = proto.start(2246267895809L);
                proto.write(0x10500000001L, i);
                proto.write(1138166333442L, this.mLabels[i]);
                proto.write(1120986464259L, this.mCountStats[i]);
                proto.write(1112396529668L, this.mDurationStats[i]);
                proto.end(inner);
            }
            proto.end(outer);
        }
    }
}

