/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.app.KeyguardManager;
import android.app.admin.SecurityLog;
import android.app.usage.StorageStatsManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.content.res.ObbInfo;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.DropBoxManager;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.IStoraged;
import android.os.IVold;
import android.os.IVoldListener;
import android.os.IVoldTaskListener;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.ParcelableException;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.DiskInfo;
import android.os.storage.IObbActionListener;
import android.os.storage.IStorageEventListener;
import android.os.storage.IStorageManager;
import android.os.storage.IStorageShutdownObserver;
import android.os.storage.StorageManager;
import android.os.storage.StorageManagerInternal;
import android.os.storage.StorageVolume;
import android.os.storage.VolumeInfo;
import android.os.storage.VolumeRecord;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.DataUnit;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.TimeUtils;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IMediaContainerService;
import com.android.internal.os.AppFuseMount;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.FuseUnavailableMountException;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.HexDump;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.FgThread;
import com.android.server.IoThread;
import com.android.server.LocalServices;
import com.android.server.LockGuard;
import com.android.server.MountServiceIdler;
import com.android.server.NativeDaemonConnectorException;
import com.android.server.SystemService;
import com.android.server.Watchdog;
import com.android.server.pm.PackageManagerService;
import com.android.server.storage.AppFuseBridge;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class StorageManagerService
extends IStorageManager.Stub
implements Watchdog.Monitor,
ActivityManagerInternal.ScreenObserver {
    static StorageManagerService sSelf = null;
    private static final String ZRAM_ENABLED_PROPERTY = "persist.sys.zram_enabled";
    private static final boolean DEBUG_EVENTS = false;
    private static final boolean DEBUG_OBB = false;
    private static final boolean WATCHDOG_ENABLE = false;
    private static final boolean EMULATE_FBE_SUPPORTED = true;
    private static final String TAG = "StorageManagerService";
    private static final String TAG_STORAGE_BENCHMARK = "storage_benchmark";
    private static final String TAG_STORAGE_TRIM = "storage_trim";
    private static final int MOVE_STATUS_COPY_FINISHED = 82;
    private static final int VERSION_INIT = 1;
    private static final int VERSION_ADD_PRIMARY = 2;
    private static final int VERSION_FIX_PRIMARY = 3;
    private static final String TAG_VOLUMES = "volumes";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_PRIMARY_STORAGE_UUID = "primaryStorageUuid";
    private static final String ATTR_FORCE_ADOPTABLE = "forceAdoptable";
    private static final String TAG_VOLUME = "volume";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_FS_UUID = "fsUuid";
    private static final String ATTR_PART_GUID = "partGuid";
    private static final String ATTR_NICKNAME = "nickname";
    private static final String ATTR_USER_FLAGS = "userFlags";
    private static final String ATTR_CREATED_MILLIS = "createdMillis";
    private static final String ATTR_LAST_TRIM_MILLIS = "lastTrimMillis";
    private static final String ATTR_LAST_BENCH_MILLIS = "lastBenchMillis";
    private final AtomicFile mSettingsFile;
    private final Object mLock = LockGuard.installNewLock(4);
    @GuardedBy(value="mLock")
    private int[] mLocalUnlockedUsers = EmptyArray.INT;
    @GuardedBy(value="mLock")
    private int[] mSystemUnlockedUsers = EmptyArray.INT;
    @GuardedBy(value="mLock")
    private ArrayMap<String, DiskInfo> mDisks = new ArrayMap();
    @GuardedBy(value="mLock")
    private final ArrayMap<String, VolumeInfo> mVolumes = new ArrayMap();
    @GuardedBy(value="mLock")
    private ArrayMap<String, VolumeRecord> mRecords = new ArrayMap();
    @GuardedBy(value="mLock")
    private String mPrimaryStorageUuid;
    @GuardedBy(value="mLock")
    private boolean mForceAdoptable;
    @GuardedBy(value="mLock")
    private ArrayMap<String, CountDownLatch> mDiskScanLatches = new ArrayMap();
    @GuardedBy(value="mLock")
    private IPackageMoveObserver mMoveCallback;
    @GuardedBy(value="mLock")
    private String mMoveTargetUuid;
    private volatile int mCurrentUserId = 0;
    private final Object mAppFuseLock = new Object();
    @GuardedBy(value="mAppFuseLock")
    private int mNextAppFuseName = 0;
    @GuardedBy(value="mAppFuseLock")
    private AppFuseBridge mAppFuseBridge = null;
    public static final String[] CRYPTO_TYPES = new String[]{"password", "default", "pattern", "pin"};
    private final Context mContext;
    private volatile IVold mVold;
    private volatile IStoraged mStoraged;
    private volatile boolean mSystemReady = false;
    private volatile boolean mBootCompleted = false;
    private volatile boolean mDaemonConnected = false;
    private volatile boolean mSecureKeyguardShowing = true;
    private PackageManagerService mPms;
    private final Callbacks mCallbacks;
    private final LockPatternUtils mLockPatternUtils;
    private static final int CRYPTO_ALGORITHM_KEY_SIZE = 128;
    private static final int PBKDF2_HASH_ROUNDS = 1024;
    private final Map<IBinder, List<ObbState>> mObbMounts = new HashMap<IBinder, List<ObbState>>();
    private final Map<String, ObbState> mObbPathToStateMap = new HashMap<String, ObbState>();
    private final StorageManagerInternalImpl mStorageManagerInternal = new StorageManagerInternalImpl();
    private final ObbActionHandler mObbActionHandler;
    private static final int OBB_RUN_ACTION = 1;
    private static final int OBB_MCS_BOUND = 2;
    private static final int OBB_MCS_UNBIND = 3;
    private static final int OBB_MCS_RECONNECT = 4;
    private static final int OBB_FLUSH_MOUNT_STATE = 5;
    static final ComponentName DEFAULT_CONTAINER_COMPONENT = new ComponentName("com.android.defcontainer", "com.android.defcontainer.DefaultContainerService");
    private final DefaultContainerConnection mDefContainerConn = new DefaultContainerConnection();
    private IMediaContainerService mContainerService = null;
    private static final String LAST_FSTRIM_FILE = "last-fstrim";
    private final File mLastMaintenanceFile;
    private long mLastMaintenance;
    private static final int H_SYSTEM_READY = 1;
    private static final int H_DAEMON_CONNECTED = 2;
    private static final int H_SHUTDOWN = 3;
    private static final int H_FSTRIM = 4;
    private static final int H_VOLUME_MOUNT = 5;
    private static final int H_VOLUME_BROADCAST = 6;
    private static final int H_INTERNAL_BROADCAST = 7;
    private static final int H_VOLUME_UNMOUNT = 8;
    private static final int H_PARTITION_FORGET = 9;
    private static final int H_RESET = 10;
    private static final int H_RUN_IDLE_MAINT = 11;
    private static final int H_ABORT_IDLE_MAINT = 12;
    private final Handler mHandler;
    private BroadcastReceiver mUserReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            block7: {
                String action = intent.getAction();
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
                Preconditions.checkArgument(userId >= 0);
                try {
                    if ("android.intent.action.USER_ADDED".equals(action)) {
                        UserManager um = StorageManagerService.this.mContext.getSystemService(UserManager.class);
                        int userSerialNumber = um.getUserSerialNumber(userId);
                        StorageManagerService.this.mVold.onUserAdded(userId, userSerialNumber);
                        break block7;
                    }
                    if (!"android.intent.action.USER_REMOVED".equals(action)) break block7;
                    ArrayMap um = StorageManagerService.this.mVolumes;
                    synchronized (um) {
                        int size = StorageManagerService.this.mVolumes.size();
                        for (int i = 0; i < size; ++i) {
                            VolumeInfo vol = (VolumeInfo)StorageManagerService.this.mVolumes.valueAt(i);
                            if (vol.mountUserId != userId) continue;
                            vol.mountUserId = -10000;
                            StorageManagerService.this.mHandler.obtainMessage(8, vol).sendToTarget();
                        }
                    }
                    StorageManagerService.this.mVold.onUserRemoved(userId);
                }
                catch (Exception e) {
                    Slog.wtf(StorageManagerService.TAG, e);
                }
            }
        }
    };
    private final IVoldListener mListener = new IVoldListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDiskCreated(String diskId, int flags) {
            Object object = StorageManagerService.this.mLock;
            synchronized (object) {
                if (SystemProperties.getBoolean("persist.fw.force_adoptable", false) || StorageManagerService.this.mForceAdoptable) {
                    flags |= 1;
                }
                StorageManagerService.this.mDisks.put(diskId, new DiskInfo(diskId, flags));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDiskScanned(String diskId) {
            Object object = StorageManagerService.this.mLock;
            synchronized (object) {
                DiskInfo disk = (DiskInfo)StorageManagerService.this.mDisks.get(diskId);
                if (disk != null) {
                    StorageManagerService.this.onDiskScannedLocked(disk);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDiskMetadataChanged(String diskId, long sizeBytes, String label, String sysPath) {
            Object object = StorageManagerService.this.mLock;
            synchronized (object) {
                DiskInfo disk = (DiskInfo)StorageManagerService.this.mDisks.get(diskId);
                if (disk != null) {
                    disk.size = sizeBytes;
                    disk.label = label;
                    disk.sysPath = sysPath;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDiskDestroyed(String diskId) {
            Object object = StorageManagerService.this.mLock;
            synchronized (object) {
                DiskInfo disk = (DiskInfo)StorageManagerService.this.mDisks.remove(diskId);
                if (disk != null) {
                    StorageManagerService.this.mCallbacks.notifyDiskDestroyed(disk);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVolumeCreated(String volId, int type, String diskId, String partGuid) {
            Object object = StorageManagerService.this.mLock;
            synchronized (object) {
                DiskInfo disk = (DiskInfo)StorageManagerService.this.mDisks.get(diskId);
                VolumeInfo vol = new VolumeInfo(volId, type, disk, partGuid);
                StorageManagerService.this.mVolumes.put(volId, vol);
                StorageManagerService.this.onVolumeCreatedLocked(vol);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVolumeStateChanged(String volId, int state) {
            Object object = StorageManagerService.this.mLock;
            synchronized (object) {
                VolumeInfo vol = (VolumeInfo)StorageManagerService.this.mVolumes.get(volId);
                if (vol != null) {
                    int newState;
                    int oldState = vol.state;
                    vol.state = newState = state;
                    StorageManagerService.this.onVolumeStateChangedLocked(vol, oldState, newState);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVolumeMetadataChanged(String volId, String fsType, String fsUuid, String fsLabel) {
            Object object = StorageManagerService.this.mLock;
            synchronized (object) {
                VolumeInfo vol = (VolumeInfo)StorageManagerService.this.mVolumes.get(volId);
                if (vol != null) {
                    vol.fsType = fsType;
                    vol.fsUuid = fsUuid;
                    vol.fsLabel = fsLabel;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVolumePathChanged(String volId, String path) {
            Object object = StorageManagerService.this.mLock;
            synchronized (object) {
                VolumeInfo vol = (VolumeInfo)StorageManagerService.this.mVolumes.get(volId);
                if (vol != null) {
                    vol.path = path;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVolumeInternalPathChanged(String volId, String internalPath) {
            Object object = StorageManagerService.this.mLock;
            synchronized (object) {
                VolumeInfo vol = (VolumeInfo)StorageManagerService.this.mVolumes.get(volId);
                if (vol != null) {
                    vol.internalPath = internalPath;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVolumeDestroyed(String volId) {
            Object object = StorageManagerService.this.mLock;
            synchronized (object) {
                StorageManagerService.this.mVolumes.remove(volId);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VolumeInfo findVolumeByIdOrThrow(String id2) {
        Object object = this.mLock;
        synchronized (object) {
            VolumeInfo vol = this.mVolumes.get(id2);
            if (vol != null) {
                return vol;
            }
        }
        throw new IllegalArgumentException("No volume found for ID " + id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findVolumeIdForPathOrThrow(String path) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mVolumes.size(); ++i) {
                VolumeInfo vol = this.mVolumes.valueAt(i);
                if (vol.path == null || !path.startsWith(vol.path)) continue;
                return vol.id;
            }
        }
        throw new IllegalArgumentException("No volume found for path " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VolumeRecord findRecordForPath(String path) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mVolumes.size(); ++i) {
                VolumeInfo vol = this.mVolumes.valueAt(i);
                if (vol.path == null || !path.startsWith(vol.path)) continue;
                return this.mRecords.get(vol.fsUuid);
            }
        }
        return null;
    }

    private String scrubPath(String path) {
        if (path.startsWith(Environment.getDataDirectory().getAbsolutePath())) {
            return "internal";
        }
        VolumeRecord rec = this.findRecordForPath(path);
        if (rec == null || rec.createdMillis == 0L) {
            return "unknown";
        }
        return "ext:" + (int)((System.currentTimeMillis() - rec.createdMillis) / 604800000L) + "w";
    }

    private VolumeInfo findStorageForUuid(String volumeUuid) {
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        if (Objects.equals(StorageManager.UUID_PRIVATE_INTERNAL, volumeUuid)) {
            return storage.findVolumeById("emulated");
        }
        if (Objects.equals("primary_physical", volumeUuid)) {
            return storage.getPrimaryPhysicalVolume();
        }
        return storage.findEmulatedForPrivate(storage.findVolumeByUuid(volumeUuid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldBenchmark() {
        long benchInterval = Settings.Global.getLong(this.mContext.getContentResolver(), "storage_benchmark_interval", 604800000L);
        if (benchInterval == -1L) {
            return false;
        }
        if (benchInterval == 0L) {
            return true;
        }
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mVolumes.size(); ++i) {
                long benchAge;
                VolumeInfo vol = this.mVolumes.valueAt(i);
                VolumeRecord rec = this.mRecords.get(vol.fsUuid);
                if (!vol.isMountedWritable() || rec == null || (benchAge = System.currentTimeMillis() - rec.lastBenchMillis) < benchInterval) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountDownLatch findOrCreateDiskScanLatch(String diskId) {
        Object object = this.mLock;
        synchronized (object) {
            CountDownLatch latch = this.mDiskScanLatches.get(diskId);
            if (latch == null) {
                latch = new CountDownLatch(1);
                this.mDiskScanLatches.put(diskId, latch);
            }
            return latch;
        }
    }

    private void waitForLatch(CountDownLatch latch, String condition, long timeoutMillis) throws TimeoutException {
        long startMillis = SystemClock.elapsedRealtime();
        do {
            try {
                if (latch.await(5000L, TimeUnit.MILLISECONDS)) {
                    return;
                }
                Slog.w(TAG, "Thread " + Thread.currentThread().getName() + " still waiting for " + condition + "...");
            }
            catch (InterruptedException e) {
                Slog.w(TAG, "Interrupt while waiting for " + condition);
            }
        } while (timeoutMillis <= 0L || SystemClock.elapsedRealtime() <= startMillis + timeoutMillis);
        throw new TimeoutException("Thread " + Thread.currentThread().getName() + " gave up waiting for " + condition + " after " + timeoutMillis + "ms");
    }

    private void handleSystemReady() {
        this.initIfReadyAndConnected();
        this.resetIfReadyAndConnected();
        MountServiceIdler.scheduleIdlePass(this.mContext);
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("zram_enabled"), false, new ContentObserver(null){

            @Override
            public void onChange(boolean selfChange) {
                StorageManagerService.this.refreshZramSettings();
            }
        });
        this.refreshZramSettings();
    }

    private void refreshZramSettings() {
        String desiredPropertyValue;
        String propertyValue = SystemProperties.get(ZRAM_ENABLED_PROPERTY);
        if ("".equals(propertyValue)) {
            return;
        }
        String string2 = desiredPropertyValue = Settings.Global.getInt(this.mContext.getContentResolver(), "zram_enabled", 1) != 0 ? "1" : "0";
        if (!desiredPropertyValue.equals(propertyValue)) {
            SystemProperties.set(ZRAM_ENABLED_PROPERTY, desiredPropertyValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void killMediaProvider(List<UserInfo> users) {
        if (users == null) {
            return;
        }
        long token = Binder.clearCallingIdentity();
        try {
            for (UserInfo user : users) {
                ProviderInfo provider;
                if (user.isSystemOnly() || (provider = this.mPms.resolveContentProvider("media", 786432, user.id)) == null) continue;
                IActivityManager am = ActivityManager.getService();
                try {
                    am.killApplication(provider.applicationInfo.packageName, UserHandle.getAppId(provider.applicationInfo.uid), -1, "vold reset");
                    break;
                }
                catch (RemoteException remoteException) {
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void addInternalVolumeLocked() {
        VolumeInfo internal = new VolumeInfo("private", 1, null, null);
        internal.state = 2;
        internal.path = Environment.getDataDirectory().getAbsolutePath();
        this.mVolumes.put(internal.id, internal);
    }

    private void initIfReadyAndConnected() {
        Slog.d(TAG, "Thinking about init, mSystemReady=" + this.mSystemReady + ", mDaemonConnected=" + this.mDaemonConnected);
        if (this.mSystemReady && this.mDaemonConnected && !StorageManager.isFileEncryptedNativeOnly()) {
            boolean initLocked = StorageManager.isFileEncryptedEmulatedOnly();
            Slog.d(TAG, "Setting up emulation state, initlocked=" + initLocked);
            List<UserInfo> users = this.mContext.getSystemService(UserManager.class).getUsers();
            for (UserInfo user : users) {
                try {
                    if (initLocked) {
                        this.mVold.lockUserKey(user.id);
                        continue;
                    }
                    this.mVold.unlockUserKey(user.id, user.serialNumber, this.encodeBytes(null), this.encodeBytes(null));
                }
                catch (Exception e) {
                    Slog.wtf(TAG, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIfReadyAndConnected() {
        Slog.d(TAG, "Thinking about reset, mSystemReady=" + this.mSystemReady + ", mDaemonConnected=" + this.mDaemonConnected);
        if (this.mSystemReady && this.mDaemonConnected) {
            int[] systemUnlockedUsers;
            List<UserInfo> users = this.mContext.getSystemService(UserManager.class).getUsers();
            this.killMediaProvider(users);
            Iterator<UserInfo> iterator = this.mLock;
            synchronized (iterator) {
                systemUnlockedUsers = this.mSystemUnlockedUsers;
                this.mDisks.clear();
                this.mVolumes.clear();
                this.addInternalVolumeLocked();
            }
            try {
                this.mVold.reset();
                for (UserInfo user : users) {
                    this.mVold.onUserAdded(user.id, user.serialNumber);
                }
                for (Object userId : (Iterator<UserInfo>)systemUnlockedUsers) {
                    this.mVold.onUserStarted((int)userId);
                    this.mStoraged.onUserStarted((int)userId);
                }
                this.mVold.onSecureKeyguardStateChanged(this.mSecureKeyguardShowing);
            }
            catch (Exception e) {
                Slog.wtf(TAG, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUnlockUser(int userId) {
        Slog.d(TAG, "onUnlockUser " + userId);
        try {
            this.mVold.onUserStarted(userId);
            this.mStoraged.onUserStarted(userId);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mVolumes.size(); ++i) {
                VolumeInfo vol = this.mVolumes.valueAt(i);
                if (!vol.isVisibleForRead(userId) || !vol.isMountedReadable()) continue;
                StorageVolume userVol = vol.buildStorageVolume(this.mContext, userId, false);
                this.mHandler.obtainMessage(6, userVol).sendToTarget();
                String envState = VolumeInfo.getEnvironmentForState(vol.getState());
                this.mCallbacks.notifyStorageStateChanged(userVol.getPath(), envState, envState);
            }
            this.mSystemUnlockedUsers = ArrayUtils.appendInt(this.mSystemUnlockedUsers, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCleanupUser(int userId) {
        Slog.d(TAG, "onCleanupUser " + userId);
        try {
            this.mVold.onUserStopped(userId);
            this.mStoraged.onUserStopped(userId);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemUnlockedUsers = ArrayUtils.removeInt(this.mSystemUnlockedUsers, userId);
        }
    }

    @Override
    public void onAwakeStateChanged(boolean isAwake) {
    }

    @Override
    public void onKeyguardStateChanged(boolean isShowing) {
        this.mSecureKeyguardShowing = isShowing && this.mContext.getSystemService(KeyguardManager.class).isDeviceSecure();
        try {
            this.mVold.onSecureKeyguardStateChanged(this.mSecureKeyguardShowing);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    void runIdleMaintenance(Runnable callback) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, callback));
    }

    @Override
    public void runMaintenance() {
        this.enforcePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        this.runIdleMaintenance(null);
    }

    @Override
    public long lastMaintenance() {
        return this.mLastMaintenance;
    }

    public void onDaemonConnected() {
        this.mDaemonConnected = true;
        this.mHandler.obtainMessage(2).sendToTarget();
    }

    private void handleDaemonConnected() {
        this.initIfReadyAndConnected();
        this.resetIfReadyAndConnected();
        if ("".equals(SystemProperties.get("vold.encrypt_progress"))) {
            this.copyLocaleFromMountService();
        }
    }

    private void copyLocaleFromMountService() {
        String systemLocale;
        try {
            systemLocale = this.getField("SystemLocale");
        }
        catch (RemoteException e) {
            return;
        }
        if (TextUtils.isEmpty(systemLocale)) {
            return;
        }
        Slog.d(TAG, "Got locale " + systemLocale + " from mount service");
        Locale locale = Locale.forLanguageTag(systemLocale);
        Configuration config = new Configuration();
        config.setLocale(locale);
        try {
            ActivityManager.getService().updatePersistentConfiguration(config);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Error setting system locale from mount service", e);
        }
        Slog.d(TAG, "Setting system properties to " + systemLocale + " from mount service");
        SystemProperties.set("persist.sys.locale", locale.toLanguageTag());
    }

    private void onDiskScannedLocked(DiskInfo disk) {
        int volumeCount = 0;
        for (int i = 0; i < this.mVolumes.size(); ++i) {
            VolumeInfo vol = this.mVolumes.valueAt(i);
            if (!Objects.equals(disk.id, vol.getDiskId())) continue;
            ++volumeCount;
        }
        Intent intent = new Intent("android.os.storage.action.DISK_SCANNED");
        intent.addFlags(0x5000000);
        intent.putExtra("android.os.storage.extra.DISK_ID", disk.id);
        intent.putExtra("android.os.storage.extra.VOLUME_COUNT", volumeCount);
        this.mHandler.obtainMessage(7, intent).sendToTarget();
        CountDownLatch latch = this.mDiskScanLatches.remove(disk.id);
        if (latch != null) {
            latch.countDown();
        }
        disk.volumeCount = volumeCount;
        this.mCallbacks.notifyDiskScanned(disk, volumeCount);
    }

    private void onVolumeCreatedLocked(VolumeInfo vol) {
        if (this.mPms.isOnlyCoreApps()) {
            Slog.d(TAG, "System booted in core-only mode; ignoring volume " + vol.getId());
            return;
        }
        if (vol.type == 2) {
            StorageManager storage = this.mContext.getSystemService(StorageManager.class);
            VolumeInfo privateVol = storage.findPrivateForEmulated(vol);
            if (Objects.equals(StorageManager.UUID_PRIVATE_INTERNAL, this.mPrimaryStorageUuid) && "private".equals(privateVol.id)) {
                Slog.v(TAG, "Found primary storage at " + vol);
                vol.mountFlags |= 1;
                vol.mountFlags |= 2;
                this.mHandler.obtainMessage(5, vol).sendToTarget();
            } else if (Objects.equals(privateVol.fsUuid, this.mPrimaryStorageUuid)) {
                Slog.v(TAG, "Found primary storage at " + vol);
                vol.mountFlags |= 1;
                vol.mountFlags |= 2;
                this.mHandler.obtainMessage(5, vol).sendToTarget();
            }
        } else if (vol.type == 0) {
            if (Objects.equals("primary_physical", this.mPrimaryStorageUuid) && vol.disk.isDefaultPrimary()) {
                Slog.v(TAG, "Found primary storage at " + vol);
                vol.mountFlags |= 1;
                vol.mountFlags |= 2;
            }
            if (vol.disk.isAdoptable()) {
                vol.mountFlags |= 2;
            }
            vol.mountUserId = this.mCurrentUserId;
            this.mHandler.obtainMessage(5, vol).sendToTarget();
        } else if (vol.type == 1) {
            this.mHandler.obtainMessage(5, vol).sendToTarget();
        } else {
            Slog.d(TAG, "Skipping automatic mounting of " + vol);
        }
    }

    private boolean isBroadcastWorthy(VolumeInfo vol) {
        switch (vol.getType()) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                return false;
            }
        }
        switch (vol.getState()) {
            case 0: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void onVolumeStateChangedLocked(VolumeInfo vol, int oldState, int newState) {
        String newStateEnv;
        String oldStateEnv;
        if (vol.isMountedReadable() && !TextUtils.isEmpty(vol.fsUuid)) {
            VolumeRecord rec = this.mRecords.get(vol.fsUuid);
            if (rec == null) {
                rec = new VolumeRecord(vol.type, vol.fsUuid);
                rec.partGuid = vol.partGuid;
                rec.createdMillis = System.currentTimeMillis();
                if (vol.type == 1) {
                    rec.nickname = vol.disk.getDescription();
                }
                this.mRecords.put(rec.fsUuid, rec);
                this.writeSettingsLocked();
            } else if (TextUtils.isEmpty(rec.partGuid)) {
                rec.partGuid = vol.partGuid;
                this.writeSettingsLocked();
            }
        }
        this.mCallbacks.notifyVolumeStateChanged(vol, oldState, newState);
        if (this.mBootCompleted && this.isBroadcastWorthy(vol)) {
            Intent intent = new Intent("android.os.storage.action.VOLUME_STATE_CHANGED");
            intent.putExtra("android.os.storage.extra.VOLUME_ID", vol.id);
            intent.putExtra("android.os.storage.extra.VOLUME_STATE", newState);
            intent.putExtra("android.os.storage.extra.FS_UUID", vol.fsUuid);
            intent.addFlags(0x5000000);
            this.mHandler.obtainMessage(7, intent).sendToTarget();
        }
        if (!Objects.equals(oldStateEnv = VolumeInfo.getEnvironmentForState(oldState), newStateEnv = VolumeInfo.getEnvironmentForState(newState))) {
            for (int userId : this.mSystemUnlockedUsers) {
                if (!vol.isVisibleForRead(userId)) continue;
                StorageVolume userVol = vol.buildStorageVolume(this.mContext, userId, false);
                this.mHandler.obtainMessage(6, userVol).sendToTarget();
                this.mCallbacks.notifyStorageStateChanged(userVol.getPath(), oldStateEnv, newStateEnv);
            }
        }
        if (vol.type == 0 && vol.state == 5) {
            this.mObbActionHandler.sendMessage(this.mObbActionHandler.obtainMessage(5, vol.path));
        }
        this.maybeLogMediaMount(vol, newState);
    }

    private void maybeLogMediaMount(VolumeInfo vol, int newState) {
        String label;
        if (!SecurityLog.isLoggingEnabled()) {
            return;
        }
        DiskInfo disk = vol.getDisk();
        if (disk == null || (disk.flags & 0xC) == 0) {
            return;
        }
        String string2 = label = disk.label != null ? disk.label.trim() : "";
        if (newState == 2 || newState == 3) {
            SecurityLog.writeEvent(210013, vol.path, label);
        } else if (newState == 0 || newState == 8) {
            SecurityLog.writeEvent(210014, vol.path, label);
        }
    }

    private void onMoveStatusLocked(int status) {
        if (this.mMoveCallback == null) {
            Slog.w(TAG, "Odd, status but no move requested");
            return;
        }
        try {
            this.mMoveCallback.onStatusChanged(-1, status, -1L);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (status == 82) {
            Slog.d(TAG, "Move to " + this.mMoveTargetUuid + " copy phase finshed; persisting");
            this.mPrimaryStorageUuid = this.mMoveTargetUuid;
            this.writeSettingsLocked();
        }
        if (PackageManager.isMoveStatusFinished(status)) {
            Slog.d(TAG, "Move to " + this.mMoveTargetUuid + " finished with status " + status);
            this.mMoveCallback = null;
            this.mMoveTargetUuid = null;
        }
    }

    private void enforcePermission(String perm) {
        this.mContext.enforceCallingOrSelfPermission(perm, perm);
    }

    private boolean isMountDisallowed(VolumeInfo vol) {
        UserManager userManager = this.mContext.getSystemService(UserManager.class);
        boolean isUsbRestricted = false;
        if (vol.disk != null && vol.disk.isUsb()) {
            isUsbRestricted = userManager.hasUserRestriction("no_usb_file_transfer", Binder.getCallingUserHandle());
        }
        boolean isTypeRestricted = false;
        if (vol.type == 0 || vol.type == 1) {
            isTypeRestricted = userManager.hasUserRestriction("no_physical_media", Binder.getCallingUserHandle());
        }
        return isUsbRestricted || isTypeRestricted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceAdminUser() {
        boolean isAdmin;
        UserManager um = (UserManager)this.mContext.getSystemService("user");
        int callingUserId = UserHandle.getCallingUserId();
        long token = Binder.clearCallingIdentity();
        try {
            isAdmin = um.getUserInfo(callingUserId).isAdmin();
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        if (!isAdmin) {
            throw new SecurityException("Only admin users can adopt sd cards");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageManagerService(Context context) {
        sSelf = this;
        this.mContext = context;
        this.mCallbacks = new Callbacks(FgThread.get().getLooper());
        this.mLockPatternUtils = new LockPatternUtils(this.mContext);
        this.mPms = (PackageManagerService)ServiceManager.getService("package");
        HandlerThread hthread = new HandlerThread(TAG);
        hthread.start();
        this.mHandler = new StorageManagerServiceHandler(hthread.getLooper());
        this.mObbActionHandler = new ObbActionHandler(IoThread.get().getLooper());
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        this.mLastMaintenanceFile = new File(systemDir, LAST_FSTRIM_FILE);
        if (!this.mLastMaintenanceFile.exists()) {
            try {
                new FileOutputStream(this.mLastMaintenanceFile).close();
            }
            catch (IOException e) {
                Slog.e(TAG, "Unable to create fstrim record " + this.mLastMaintenanceFile.getPath());
            }
        } else {
            this.mLastMaintenance = this.mLastMaintenanceFile.lastModified();
        }
        this.mSettingsFile = new AtomicFile(new File(Environment.getDataSystemDirectory(), "storage.xml"), "storage-settings");
        Object e = this.mLock;
        synchronized (e) {
            this.readSettingsLocked();
        }
        LocalServices.addService(StorageManagerInternal.class, this.mStorageManagerInternal);
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction("android.intent.action.USER_ADDED");
        userFilter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiver(this.mUserReceiver, userFilter, null, this.mHandler);
        Object object = this.mLock;
        synchronized (object) {
            this.addInternalVolumeLocked();
        }
    }

    private void start() {
        this.connect();
    }

    private void connect() {
        IBinder binder = ServiceManager.getService("storaged");
        if (binder != null) {
            try {
                binder.linkToDeath(new IBinder.DeathRecipient(){

                    @Override
                    public void binderDied() {
                        Slog.w(StorageManagerService.TAG, "storaged died; reconnecting");
                        StorageManagerService.this.mStoraged = null;
                        StorageManagerService.this.connect();
                    }
                }, 0);
            }
            catch (RemoteException e) {
                binder = null;
            }
        }
        if (binder != null) {
            this.mStoraged = IStoraged.Stub.asInterface(binder);
        } else {
            Slog.w(TAG, "storaged not found; trying again");
        }
        binder = ServiceManager.getService("vold");
        if (binder != null) {
            try {
                binder.linkToDeath(new IBinder.DeathRecipient(){

                    @Override
                    public void binderDied() {
                        Slog.w(StorageManagerService.TAG, "vold died; reconnecting");
                        StorageManagerService.this.mVold = null;
                        StorageManagerService.this.connect();
                    }
                }, 0);
            }
            catch (RemoteException e) {
                binder = null;
            }
        }
        if (binder != null) {
            this.mVold = IVold.Stub.asInterface(binder);
            try {
                this.mVold.setListener(this.mListener);
            }
            catch (RemoteException e) {
                this.mVold = null;
                Slog.w(TAG, "vold listener rejected; trying again", e);
            }
        } else {
            Slog.w(TAG, "vold not found; trying again");
        }
        if (this.mStoraged == null || this.mVold == null) {
            BackgroundThread.getHandler().postDelayed(() -> this.connect(), 1000L);
        } else {
            this.onDaemonConnected();
        }
    }

    private void systemReady() {
        LocalServices.getService(ActivityManagerInternal.class).registerScreenObserver(this);
        this.mSystemReady = true;
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    private void bootCompleted() {
        this.mBootCompleted = true;
    }

    private String getDefaultPrimaryStorageUuid() {
        if (SystemProperties.getBoolean("ro.vold.primary_physical", false)) {
            return "primary_physical";
        }
        return StorageManager.UUID_PRIVATE_INTERNAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSettingsLocked() {
        this.mRecords.clear();
        this.mPrimaryStorageUuid = this.getDefaultPrimaryStorageUuid();
        this.mForceAdoptable = false;
        FileInputStream fis = null;
        try {
            int type;
            fis = this.mSettingsFile.openRead();
            XmlPullParser in = Xml.newPullParser();
            in.setInput(fis, StandardCharsets.UTF_8.name());
            while ((type = in.next()) != 1) {
                if (type != 2) continue;
                String tag = in.getName();
                if (TAG_VOLUMES.equals(tag)) {
                    boolean validAttr;
                    int version = XmlUtils.readIntAttribute(in, ATTR_VERSION, 1);
                    boolean primaryPhysical = SystemProperties.getBoolean("ro.vold.primary_physical", false);
                    boolean bl = validAttr = version >= 3 || version >= 2 && !primaryPhysical;
                    if (validAttr) {
                        this.mPrimaryStorageUuid = XmlUtils.readStringAttribute(in, ATTR_PRIMARY_STORAGE_UUID);
                    }
                    this.mForceAdoptable = XmlUtils.readBooleanAttribute(in, ATTR_FORCE_ADOPTABLE, false);
                    continue;
                }
                if (!TAG_VOLUME.equals(tag)) continue;
                VolumeRecord rec = StorageManagerService.readVolumeRecord(in);
                this.mRecords.put(rec.fsUuid, rec);
            }
        }
        catch (FileNotFoundException in) {
        }
        catch (IOException e) {
            Slog.wtf(TAG, "Failed reading metadata", e);
        }
        catch (XmlPullParserException e) {
            Slog.wtf(TAG, "Failed reading metadata", e);
        }
        finally {
            IoUtils.closeQuietly(fis);
        }
    }

    private void writeSettingsLocked() {
        block3: {
            FileOutputStream fos = null;
            try {
                fos = this.mSettingsFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.startTag(null, TAG_VOLUMES);
                XmlUtils.writeIntAttribute(out, ATTR_VERSION, 3);
                XmlUtils.writeStringAttribute(out, ATTR_PRIMARY_STORAGE_UUID, this.mPrimaryStorageUuid);
                XmlUtils.writeBooleanAttribute(out, ATTR_FORCE_ADOPTABLE, this.mForceAdoptable);
                int size = this.mRecords.size();
                for (int i = 0; i < size; ++i) {
                    VolumeRecord rec = this.mRecords.valueAt(i);
                    StorageManagerService.writeVolumeRecord(out, rec);
                }
                out.endTag(null, TAG_VOLUMES);
                out.endDocument();
                this.mSettingsFile.finishWrite(fos);
            }
            catch (IOException e) {
                if (fos == null) break block3;
                this.mSettingsFile.failWrite(fos);
            }
        }
    }

    public static VolumeRecord readVolumeRecord(XmlPullParser in) throws IOException {
        int type = XmlUtils.readIntAttribute(in, ATTR_TYPE);
        String fsUuid = XmlUtils.readStringAttribute(in, ATTR_FS_UUID);
        VolumeRecord meta = new VolumeRecord(type, fsUuid);
        meta.partGuid = XmlUtils.readStringAttribute(in, ATTR_PART_GUID);
        meta.nickname = XmlUtils.readStringAttribute(in, ATTR_NICKNAME);
        meta.userFlags = XmlUtils.readIntAttribute(in, ATTR_USER_FLAGS);
        meta.createdMillis = XmlUtils.readLongAttribute(in, ATTR_CREATED_MILLIS);
        meta.lastTrimMillis = XmlUtils.readLongAttribute(in, ATTR_LAST_TRIM_MILLIS);
        meta.lastBenchMillis = XmlUtils.readLongAttribute(in, ATTR_LAST_BENCH_MILLIS);
        return meta;
    }

    public static void writeVolumeRecord(XmlSerializer out, VolumeRecord rec) throws IOException {
        out.startTag(null, TAG_VOLUME);
        XmlUtils.writeIntAttribute(out, ATTR_TYPE, rec.type);
        XmlUtils.writeStringAttribute(out, ATTR_FS_UUID, rec.fsUuid);
        XmlUtils.writeStringAttribute(out, ATTR_PART_GUID, rec.partGuid);
        XmlUtils.writeStringAttribute(out, ATTR_NICKNAME, rec.nickname);
        XmlUtils.writeIntAttribute(out, ATTR_USER_FLAGS, rec.userFlags);
        XmlUtils.writeLongAttribute(out, ATTR_CREATED_MILLIS, rec.createdMillis);
        XmlUtils.writeLongAttribute(out, ATTR_LAST_TRIM_MILLIS, rec.lastTrimMillis);
        XmlUtils.writeLongAttribute(out, ATTR_LAST_BENCH_MILLIS, rec.lastBenchMillis);
        out.endTag(null, TAG_VOLUME);
    }

    @Override
    public void registerListener(IStorageEventListener listener) {
        this.mCallbacks.register(listener);
    }

    @Override
    public void unregisterListener(IStorageEventListener listener) {
        this.mCallbacks.unregister(listener);
    }

    @Override
    public void shutdown(IStorageShutdownObserver observer) {
        this.enforcePermission("android.permission.SHUTDOWN");
        Slog.i(TAG, "Shutting down");
        this.mHandler.obtainMessage(3, observer).sendToTarget();
    }

    @Override
    public void mount(String volId) {
        this.enforcePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        VolumeInfo vol = this.findVolumeByIdOrThrow(volId);
        if (this.isMountDisallowed(vol)) {
            throw new SecurityException("Mounting " + volId + " restricted by policy");
        }
        try {
            this.mVold.mount(vol.id, vol.mountFlags, vol.mountUserId);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    @Override
    public void unmount(String volId) {
        this.enforcePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        VolumeInfo vol = this.findVolumeByIdOrThrow(volId);
        try {
            this.mVold.unmount(vol.id);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    @Override
    public void format(String volId) {
        this.enforcePermission("android.permission.MOUNT_FORMAT_FILESYSTEMS");
        VolumeInfo vol = this.findVolumeByIdOrThrow(volId);
        try {
            this.mVold.format(vol.id, "auto");
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    @Override
    public void benchmark(String volId, final IVoldTaskListener listener) {
        this.enforcePermission("android.permission.MOUNT_FORMAT_FILESYSTEMS");
        try {
            this.mVold.benchmark(volId, new IVoldTaskListener.Stub(){

                @Override
                public void onStatus(int status, PersistableBundle extras) {
                    StorageManagerService.this.dispatchOnStatus(listener, status, extras);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFinished(int status, PersistableBundle extras) {
                    StorageManagerService.this.dispatchOnFinished(listener, status, extras);
                    String path = extras.getString("path");
                    String ident = extras.getString("ident");
                    long create = extras.getLong("create");
                    long run = extras.getLong("run");
                    long destroy = extras.getLong("destroy");
                    DropBoxManager dropBox = StorageManagerService.this.mContext.getSystemService(DropBoxManager.class);
                    dropBox.addText(StorageManagerService.TAG_STORAGE_BENCHMARK, StorageManagerService.this.scrubPath(path) + " " + ident + " " + create + " " + run + " " + destroy);
                    Object object = StorageManagerService.this.mLock;
                    synchronized (object) {
                        VolumeRecord rec = StorageManagerService.this.findRecordForPath(path);
                        if (rec != null) {
                            rec.lastBenchMillis = System.currentTimeMillis();
                            StorageManagerService.this.writeSettingsLocked();
                        }
                    }
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public void partitionPublic(String diskId) {
        this.enforcePermission("android.permission.MOUNT_FORMAT_FILESYSTEMS");
        CountDownLatch latch = this.findOrCreateDiskScanLatch(diskId);
        try {
            this.mVold.partition(diskId, 0, -1);
            this.waitForLatch(latch, "partitionPublic", 180000L);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    @Override
    public void partitionPrivate(String diskId) {
        this.enforcePermission("android.permission.MOUNT_FORMAT_FILESYSTEMS");
        this.enforceAdminUser();
        CountDownLatch latch = this.findOrCreateDiskScanLatch(diskId);
        try {
            this.mVold.partition(diskId, 1, -1);
            this.waitForLatch(latch, "partitionPrivate", 180000L);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    @Override
    public void partitionMixed(String diskId, int ratio) {
        this.enforcePermission("android.permission.MOUNT_FORMAT_FILESYSTEMS");
        this.enforceAdminUser();
        CountDownLatch latch = this.findOrCreateDiskScanLatch(diskId);
        try {
            this.mVold.partition(diskId, 2, ratio);
            this.waitForLatch(latch, "partitionMixed", 180000L);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVolumeNickname(String fsUuid, String nickname) {
        this.enforcePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        Preconditions.checkNotNull(fsUuid);
        Object object = this.mLock;
        synchronized (object) {
            VolumeRecord rec = this.mRecords.get(fsUuid);
            rec.nickname = nickname;
            this.mCallbacks.notifyVolumeRecordChanged(rec);
            this.writeSettingsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVolumeUserFlags(String fsUuid, int flags, int mask) {
        this.enforcePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        Preconditions.checkNotNull(fsUuid);
        Object object = this.mLock;
        synchronized (object) {
            VolumeRecord rec = this.mRecords.get(fsUuid);
            rec.userFlags = rec.userFlags & ~mask | flags & mask;
            this.mCallbacks.notifyVolumeRecordChanged(rec);
            this.writeSettingsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forgetVolume(String fsUuid) {
        this.enforcePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        Preconditions.checkNotNull(fsUuid);
        Object object = this.mLock;
        synchronized (object) {
            VolumeRecord rec = this.mRecords.remove(fsUuid);
            if (rec != null && !TextUtils.isEmpty(rec.partGuid)) {
                this.mHandler.obtainMessage(9, rec).sendToTarget();
            }
            this.mCallbacks.notifyVolumeForgotten(fsUuid);
            if (Objects.equals(this.mPrimaryStorageUuid, fsUuid)) {
                this.mPrimaryStorageUuid = this.getDefaultPrimaryStorageUuid();
                this.mHandler.obtainMessage(10).sendToTarget();
            }
            this.writeSettingsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forgetAllVolumes() {
        this.enforcePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mRecords.size(); ++i) {
                String fsUuid = this.mRecords.keyAt(i);
                VolumeRecord rec = this.mRecords.valueAt(i);
                if (!TextUtils.isEmpty(rec.partGuid)) {
                    this.mHandler.obtainMessage(9, rec).sendToTarget();
                }
                this.mCallbacks.notifyVolumeForgotten(fsUuid);
            }
            this.mRecords.clear();
            if (!Objects.equals(StorageManager.UUID_PRIVATE_INTERNAL, this.mPrimaryStorageUuid)) {
                this.mPrimaryStorageUuid = this.getDefaultPrimaryStorageUuid();
            }
            this.writeSettingsLocked();
            this.mHandler.obtainMessage(10).sendToTarget();
        }
    }

    private void forgetPartition(String partGuid, String fsUuid) {
        try {
            this.mVold.forgetPartition(partGuid, fsUuid);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    @Override
    public void fstrim(int flags, final IVoldTaskListener listener) {
        this.enforcePermission("android.permission.MOUNT_FORMAT_FILESYSTEMS");
        try {
            this.mVold.fstrim(flags, new IVoldTaskListener.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onStatus(int status, PersistableBundle extras) {
                    StorageManagerService.this.dispatchOnStatus(listener, status, extras);
                    if (status != 0) {
                        return;
                    }
                    String path = extras.getString("path");
                    long bytes = extras.getLong("bytes");
                    long time = extras.getLong("time");
                    DropBoxManager dropBox = StorageManagerService.this.mContext.getSystemService(DropBoxManager.class);
                    dropBox.addText(StorageManagerService.TAG_STORAGE_TRIM, StorageManagerService.this.scrubPath(path) + " " + bytes + " " + time);
                    Object object = StorageManagerService.this.mLock;
                    synchronized (object) {
                        VolumeRecord rec = StorageManagerService.this.findRecordForPath(path);
                        if (rec != null) {
                            rec.lastTrimMillis = System.currentTimeMillis();
                            StorageManagerService.this.writeSettingsLocked();
                        }
                    }
                }

                @Override
                public void onFinished(int status, PersistableBundle extras) {
                    StorageManagerService.this.dispatchOnFinished(listener, status, extras);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    void runIdleMaint(final Runnable callback) {
        this.enforcePermission("android.permission.MOUNT_FORMAT_FILESYSTEMS");
        try {
            this.mVold.runIdleMaint(new IVoldTaskListener.Stub(){

                @Override
                public void onStatus(int status, PersistableBundle extras) {
                }

                @Override
                public void onFinished(int status, PersistableBundle extras) {
                    if (callback != null) {
                        BackgroundThread.getHandler().post(callback);
                    }
                }
            });
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    @Override
    public void runIdleMaintenance() {
        this.runIdleMaint(null);
    }

    void abortIdleMaint(final Runnable callback) {
        this.enforcePermission("android.permission.MOUNT_FORMAT_FILESYSTEMS");
        try {
            this.mVold.abortIdleMaint(new IVoldTaskListener.Stub(){

                @Override
                public void onStatus(int status, PersistableBundle extras) {
                }

                @Override
                public void onFinished(int status, PersistableBundle extras) {
                    if (callback != null) {
                        BackgroundThread.getHandler().post(callback);
                    }
                }
            });
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    @Override
    public void abortIdleMaintenance() {
        this.abortIdleMaint(null);
    }

    private void remountUidExternalStorage(int uid, int mode) {
        try {
            this.mVold.remountUid(uid, mode);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDebugFlags(int flags, int mask) {
        long token;
        this.enforcePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        if ((mask & 2) != 0) {
            if (StorageManager.isFileEncryptedNativeOnly()) {
                throw new IllegalStateException("Emulation not supported on device with native FBE");
            }
            if (this.mLockPatternUtils.isCredentialRequiredToDecrypt(false)) {
                throw new IllegalStateException("Emulation requires disabling 'Secure start-up' in Settings > Security");
            }
            long token2 = Binder.clearCallingIdentity();
            try {
                boolean emulateFbe = (flags & 2) != 0;
                SystemProperties.set("persist.sys.emulate_fbe", Boolean.toString(emulateFbe));
                this.mContext.getSystemService(PowerManager.class).reboot(null);
            }
            finally {
                Binder.restoreCallingIdentity(token2);
            }
        }
        if ((mask & 1) != 0) {
            Object object = this.mLock;
            synchronized (object) {
                this.mForceAdoptable = (flags & 1) != 0;
                this.writeSettingsLocked();
                this.mHandler.obtainMessage(10).sendToTarget();
            }
        }
        if ((mask & 0xC) != 0) {
            String value = (flags & 4) != 0 ? "force_on" : ((flags & 8) != 0 ? "force_off" : "");
            token = Binder.clearCallingIdentity();
            try {
                SystemProperties.set("persist.sys.sdcardfs", value);
                this.mHandler.obtainMessage(10).sendToTarget();
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
        if ((mask & 0x10) != 0) {
            boolean enabled = (flags & 0x10) != 0;
            token = Binder.clearCallingIdentity();
            try {
                SystemProperties.set("persist.sys.virtual_disk", Boolean.toString(enabled));
                this.mHandler.obtainMessage(10).sendToTarget();
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrimaryStorageUuid() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPrimaryStorageUuid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setPrimaryStorageUuid(String volumeUuid, IPackageMoveObserver callback) {
        VolumeInfo to;
        VolumeInfo from;
        this.enforcePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        Object object = this.mLock;
        synchronized (object) {
            if (Objects.equals(this.mPrimaryStorageUuid, volumeUuid)) {
                throw new IllegalArgumentException("Primary storage already at " + volumeUuid);
            }
            if (this.mMoveCallback != null) {
                throw new IllegalStateException("Move already in progress");
            }
            this.mMoveCallback = callback;
            this.mMoveTargetUuid = volumeUuid;
            List<UserInfo> users = this.mContext.getSystemService(UserManager.class).getUsers();
            for (UserInfo user : users) {
                if (!StorageManager.isFileEncryptedNativeOrEmulated() || this.isUserKeyUnlocked(user.id)) continue;
                Slog.w(TAG, "Failing move due to locked user " + user.id);
                this.onMoveStatusLocked(-10);
                return;
            }
            if (Objects.equals("primary_physical", this.mPrimaryStorageUuid) || Objects.equals("primary_physical", volumeUuid)) {
                Slog.d(TAG, "Skipping move to/from primary physical");
                this.onMoveStatusLocked(82);
                this.onMoveStatusLocked(-100);
                this.mHandler.obtainMessage(10).sendToTarget();
                return;
            }
            from = this.findStorageForUuid(this.mPrimaryStorageUuid);
            to = this.findStorageForUuid(volumeUuid);
            if (from == null) {
                Slog.w(TAG, "Failing move due to missing from volume " + this.mPrimaryStorageUuid);
                this.onMoveStatusLocked(-6);
                return;
            }
            if (to == null) {
                Slog.w(TAG, "Failing move due to missing to volume " + volumeUuid);
                this.onMoveStatusLocked(-6);
                return;
            }
        }
        try {
            this.mVold.moveStorage(from.id, to.id, new IVoldTaskListener.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onStatus(int status, PersistableBundle extras) {
                    Object object = StorageManagerService.this.mLock;
                    synchronized (object) {
                        StorageManagerService.this.onMoveStatusLocked(status);
                    }
                }

                @Override
                public void onFinished(int status, PersistableBundle extras) {
                }
            });
            return;
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void warnOnNotMounted() {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mVolumes.size(); ++i) {
                VolumeInfo vol = this.mVolumes.valueAt(i);
                if (!vol.isPrimary() || !vol.isMountedWritable()) continue;
                return;
            }
        }
        Slog.w(TAG, "No primary storage mounted!");
    }

    private boolean isUidOwnerOfPackageOrSystem(String packageName, int callerUid) {
        if (callerUid == 1000) {
            return true;
        }
        if (packageName == null) {
            return false;
        }
        int packageUid = this.mPms.getPackageUid(packageName, 0x10000000, UserHandle.getUserId(callerUid));
        return callerUid == packageUid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMountedObbPath(String rawPath) {
        ObbState state;
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        this.warnOnNotMounted();
        Map<IBinder, List<ObbState>> map = this.mObbMounts;
        synchronized (map) {
            state = this.mObbPathToStateMap.get(rawPath);
        }
        if (state == null) {
            Slog.w(TAG, "Failed to find OBB mounted at " + rawPath);
            return null;
        }
        return this.findVolumeByIdOrThrow(state.volId).getPath().getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isObbMounted(String rawPath) {
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        Map<IBinder, List<ObbState>> map = this.mObbMounts;
        synchronized (map) {
            return this.mObbPathToStateMap.containsKey(rawPath);
        }
    }

    @Override
    public void mountObb(String rawPath, String canonicalPath, String key, IObbActionListener token, int nonce) {
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        Preconditions.checkNotNull(canonicalPath, "canonicalPath cannot be null");
        Preconditions.checkNotNull(token, "token cannot be null");
        int callingUid = Binder.getCallingUid();
        ObbState obbState = new ObbState(rawPath, canonicalPath, callingUid, token, nonce, null);
        MountObbAction action = new MountObbAction(obbState, key, callingUid);
        this.mObbActionHandler.sendMessage(this.mObbActionHandler.obtainMessage(1, action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmountObb(String rawPath, boolean force, IObbActionListener token, int nonce) {
        ObbState existingState;
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        Map<IBinder, List<ObbState>> map = this.mObbMounts;
        synchronized (map) {
            existingState = this.mObbPathToStateMap.get(rawPath);
        }
        if (existingState != null) {
            int callingUid = Binder.getCallingUid();
            ObbState newState = new ObbState(rawPath, existingState.canonicalPath, callingUid, token, nonce, existingState.volId);
            UnmountObbAction action = new UnmountObbAction(newState, force);
            this.mObbActionHandler.sendMessage(this.mObbActionHandler.obtainMessage(1, action));
        } else {
            Slog.w(TAG, "Unknown OBB mount at " + rawPath);
        }
    }

    @Override
    public int getEncryptionState() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        try {
            return this.mVold.fdeComplete();
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
            return -1;
        }
    }

    @Override
    public int decryptStorage(String password) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        if (TextUtils.isEmpty(password)) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        try {
            this.mVold.fdeCheckPassword(password);
            this.mHandler.postDelayed(() -> {
                try {
                    this.mVold.fdeRestart();
                }
                catch (Exception e) {
                    Slog.wtf(TAG, e);
                }
            }, 1000L);
            return 0;
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
            return -1;
        }
    }

    @Override
    public int encryptStorage(int type, String password) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        if (type == 1) {
            password = "";
        } else if (TextUtils.isEmpty(password)) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        try {
            this.mVold.fdeEnable(type, password, 0);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
            return -1;
        }
        return 0;
    }

    @Override
    public int changeEncryptionPassword(int type, String password) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        if (StorageManager.isFileEncryptedNativeOnly()) {
            return -1;
        }
        if (type == 1) {
            password = "";
        } else if (TextUtils.isEmpty(password)) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        try {
            this.mVold.fdeChangePassword(type, password);
            return 0;
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
            return -1;
        }
    }

    @Override
    public int verifyEncryptionPassword(String password) throws RemoteException {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("no permission to access the crypt keeper");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        if (TextUtils.isEmpty(password)) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        try {
            this.mVold.fdeVerifyPassword(password);
            return 0;
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
            return -1;
        }
    }

    @Override
    public int getPasswordType() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        try {
            return this.mVold.fdeGetPasswordType();
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
            return -1;
        }
    }

    @Override
    public void setField(String field, String contents) throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        if (StorageManager.isFileEncryptedNativeOnly()) {
            return;
        }
        try {
            this.mVold.fdeSetField(field, contents);
            return;
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
            return;
        }
    }

    @Override
    public String getField(String field) throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        if (StorageManager.isFileEncryptedNativeOnly()) {
            return null;
        }
        try {
            return this.mVold.fdeGetField(field);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
            return null;
        }
    }

    @Override
    public boolean isConvertibleToFBE() throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        try {
            return this.mVold.isConvertibleToFbe();
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
            return false;
        }
    }

    @Override
    public String getPassword() throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "only keyguard can retrieve password");
        try {
            return this.mVold.fdeGetPassword();
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
            return null;
        }
    }

    @Override
    public void clearPassword() throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "only keyguard can clear password");
        try {
            this.mVold.fdeClearPassword();
            return;
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
            return;
        }
    }

    @Override
    public void createUserKey(int userId, int serialNumber, boolean ephemeral) {
        this.enforcePermission("android.permission.STORAGE_INTERNAL");
        try {
            this.mVold.createUserKey(userId, serialNumber, ephemeral);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    @Override
    public void destroyUserKey(int userId) {
        this.enforcePermission("android.permission.STORAGE_INTERNAL");
        try {
            this.mVold.destroyUserKey(userId);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    private String encodeBytes(byte[] bytes) {
        if (ArrayUtils.isEmpty(bytes)) {
            return "!";
        }
        return HexDump.toHexString(bytes);
    }

    @Override
    public void addUserKeyAuth(int userId, int serialNumber, byte[] token, byte[] secret) {
        this.enforcePermission("android.permission.STORAGE_INTERNAL");
        try {
            this.mVold.addUserKeyAuth(userId, serialNumber, this.encodeBytes(token), this.encodeBytes(secret));
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    @Override
    public void fixateNewestUserKeyAuth(int userId) {
        this.enforcePermission("android.permission.STORAGE_INTERNAL");
        try {
            this.mVold.fixateNewestUserKeyAuth(userId);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockUserKey(int userId, int serialNumber, byte[] token, byte[] secret) {
        this.enforcePermission("android.permission.STORAGE_INTERNAL");
        if (StorageManager.isFileEncryptedNativeOrEmulated()) {
            if (this.mLockPatternUtils.isSecure(userId) && ArrayUtils.isEmpty(secret)) {
                throw new IllegalStateException("Secret required to unlock secure user " + userId);
            }
            try {
                this.mVold.unlockUserKey(userId, serialNumber, this.encodeBytes(token), this.encodeBytes(secret));
            }
            catch (Exception e) {
                Slog.wtf(TAG, e);
                return;
            }
        }
        Object e = this.mLock;
        synchronized (e) {
            this.mLocalUnlockedUsers = ArrayUtils.appendInt(this.mLocalUnlockedUsers, userId);
        }
        if (userId == 0) {
            String propertyName = "sys.user." + userId + ".ce_available";
            Slog.d(TAG, "Setting property: " + propertyName + "=true");
            SystemProperties.set(propertyName, "true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockUserKey(int userId) {
        this.enforcePermission("android.permission.STORAGE_INTERNAL");
        try {
            this.mVold.lockUserKey(userId);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mLocalUnlockedUsers = ArrayUtils.removeInt(this.mLocalUnlockedUsers, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserKeyUnlocked(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return ArrayUtils.contains(this.mLocalUnlockedUsers, userId);
        }
    }

    @Override
    public void prepareUserStorage(String volumeUuid, int userId, int serialNumber, int flags) {
        this.enforcePermission("android.permission.STORAGE_INTERNAL");
        try {
            this.mVold.prepareUserStorage(volumeUuid, userId, serialNumber, flags);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    @Override
    public void destroyUserStorage(String volumeUuid, int userId, int flags) {
        this.enforcePermission("android.permission.STORAGE_INTERNAL");
        try {
            this.mVold.destroyUserStorage(volumeUuid, userId, flags);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    @Override
    public void secdiscard(String path) {
        this.enforcePermission("android.permission.STORAGE_INTERNAL");
        try {
            this.mVold.secdiscard(path);
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppFuseMount mountProxyFileDescriptorBridge() {
        Slog.v(TAG, "mountProxyFileDescriptorBridge");
        int uid = Binder.getCallingUid();
        int pid = Binder.getCallingPid();
        while (true) {
            Object object = this.mAppFuseLock;
            synchronized (object) {
                boolean newlyCreated = false;
                if (this.mAppFuseBridge == null) {
                    this.mAppFuseBridge = new AppFuseBridge();
                    new Thread((Runnable)this.mAppFuseBridge, "AppFuseBridge").start();
                    newlyCreated = true;
                }
                try {
                    ++this.mNextAppFuseName;
                    try {
                        int name;
                        return new AppFuseMount(name, this.mAppFuseBridge.addBridge(new AppFuseMountScope(uid, pid, name)));
                    }
                    catch (FuseUnavailableMountException e) {
                        if (newlyCreated) {
                            Slog.e(TAG, "", e);
                            return null;
                        }
                        this.mAppFuseBridge = null;
                    }
                }
                catch (NativeDaemonConnectorException e) {
                    throw e.rethrowAsParcelableException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor openProxyFileDescriptor(int mountId, int fileId, int mode) {
        Slog.v(TAG, "mountProxyFileDescriptor");
        int pid = Binder.getCallingPid();
        try {
            Object object = this.mAppFuseLock;
            synchronized (object) {
                if (this.mAppFuseBridge == null) {
                    Slog.e(TAG, "FuseBridge has not been created");
                    return null;
                }
                return this.mAppFuseBridge.openFile(pid, mountId, fileId, mode);
            }
        }
        catch (FuseUnavailableMountException | InterruptedException error) {
            Slog.v(TAG, "The mount point has already been invalid", error);
            return null;
        }
    }

    @Override
    public void mkdirs(String callingPkg, String appPath) {
        int userId = UserHandle.getUserId(Binder.getCallingUid());
        Environment.UserEnvironment userEnv = new Environment.UserEnvironment(userId);
        AppOpsManager appOps = (AppOpsManager)this.mContext.getSystemService("appops");
        appOps.checkPackage(Binder.getCallingUid(), callingPkg);
        File appFile = null;
        try {
            appFile = new File(appPath).getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to resolve " + appPath + ": " + e);
        }
        if (FileUtils.contains(userEnv.buildExternalStorageAppDataDirs(callingPkg), appFile) || FileUtils.contains(userEnv.buildExternalStorageAppObbDirs(callingPkg), appFile) || FileUtils.contains(userEnv.buildExternalStorageAppMediaDirs(callingPkg), appFile)) {
            appPath = appFile.getAbsolutePath();
            if (!appPath.endsWith("/")) {
                appPath = appPath + "/";
            }
            try {
                this.mVold.mkdirs(appPath);
                return;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to prepare " + appPath + ": " + e);
            }
        }
        throw new SecurityException("Invalid mkdirs path: " + appFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageVolume[] getVolumeList(int uid, String packageName, int flags) {
        boolean storagePermission;
        boolean userKeyUnlocked;
        int userId = UserHandle.getUserId(uid);
        boolean forWrite = (flags & 0x100) != 0;
        boolean realState = (flags & 0x200) != 0;
        boolean includeInvisible = (flags & 0x400) != 0;
        long token = Binder.clearCallingIdentity();
        try {
            userKeyUnlocked = this.isUserKeyUnlocked(userId);
            storagePermission = this.mStorageManagerInternal.hasExternalStorage(uid, packageName);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        boolean foundPrimary = false;
        ArrayList<StorageVolume> res = new ArrayList<StorageVolume>();
        Object object = this.mLock;
        synchronized (object) {
            block9: for (int i = 0; i < this.mVolumes.size(); ++i) {
                VolumeInfo vol = this.mVolumes.valueAt(i);
                switch (vol.getType()) {
                    case 0: 
                    case 2: {
                        break;
                    }
                    default: {
                        continue block9;
                    }
                }
                boolean match = false;
                if (forWrite) {
                    match = vol.isVisibleForWrite(userId);
                } else {
                    boolean bl = match = vol.isVisibleForRead(userId) || includeInvisible && vol.getPath() != null;
                }
                if (!match) continue;
                boolean reportUnmounted = false;
                if (vol.getType() == 2 && !userKeyUnlocked) {
                    reportUnmounted = true;
                } else if (!storagePermission && !realState) {
                    reportUnmounted = true;
                }
                StorageVolume userVol = vol.buildStorageVolume(this.mContext, userId, reportUnmounted);
                if (vol.isPrimary()) {
                    res.add(0, userVol);
                    foundPrimary = true;
                    continue;
                }
                res.add(userVol);
            }
        }
        if (!foundPrimary) {
            Log.w(TAG, "No primary storage defined yet; hacking together a stub");
            boolean primaryPhysical = SystemProperties.getBoolean("ro.vold.primary_physical", false);
            String id2 = "stub_primary";
            File path = Environment.getLegacyExternalStorageDirectory();
            String description = this.mContext.getString(17039374);
            boolean primary = true;
            boolean removable = primaryPhysical;
            boolean emulated = !primaryPhysical;
            boolean allowMassStorage = false;
            long maxFileSize = 0L;
            UserHandle owner = new UserHandle(userId);
            String uuid = null;
            String state = "removed";
            res.add(0, new StorageVolume("stub_primary", path, description, true, removable, emulated, false, 0L, owner, uuid, "removed"));
        }
        return res.toArray(new StorageVolume[res.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiskInfo[] getDisks() {
        Object object = this.mLock;
        synchronized (object) {
            DiskInfo[] res = new DiskInfo[this.mDisks.size()];
            for (int i = 0; i < this.mDisks.size(); ++i) {
                res[i] = this.mDisks.valueAt(i);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VolumeInfo[] getVolumes(int flags) {
        Object object = this.mLock;
        synchronized (object) {
            VolumeInfo[] res = new VolumeInfo[this.mVolumes.size()];
            for (int i = 0; i < this.mVolumes.size(); ++i) {
                res[i] = this.mVolumes.valueAt(i);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VolumeRecord[] getVolumeRecords(int flags) {
        Object object = this.mLock;
        synchronized (object) {
            VolumeRecord[] res = new VolumeRecord[this.mRecords.size()];
            for (int i = 0; i < this.mRecords.size(); ++i) {
                res[i] = this.mRecords.valueAt(i);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCacheQuotaBytes(String volumeUuid, int uid) {
        if (uid != Binder.getCallingUid()) {
            this.mContext.enforceCallingPermission("android.permission.STORAGE_INTERNAL", TAG);
        }
        long token = Binder.clearCallingIdentity();
        StorageStatsManager stats = this.mContext.getSystemService(StorageStatsManager.class);
        try {
            long l = stats.getCacheQuotaBytes(volumeUuid, uid);
            return l;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    public long getCacheSizeBytes(String volumeUuid, int uid) {
        if (uid != Binder.getCallingUid()) {
            this.mContext.enforceCallingPermission("android.permission.STORAGE_INTERNAL", TAG);
        }
        long token = Binder.clearCallingIdentity();
        try {
            long l = this.mContext.getSystemService(StorageStatsManager.class).queryStatsForUid(volumeUuid, uid).getCacheBytes();
            return l;
        }
        catch (IOException e) {
            throw new ParcelableException(e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int adjustAllocateFlags(int flags, int callingUid, String callingPackage) {
        if ((flags & 1) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.ALLOCATE_AGGRESSIVE", TAG);
        }
        flags &= 0xFFFFFFFD;
        flags &= 0xFFFFFFFB;
        AppOpsManager appOps = this.mContext.getSystemService(AppOpsManager.class);
        long token = Binder.clearCallingIdentity();
        try {
            if (appOps.isOperationActive(26, callingUid, callingPackage)) {
                Slog.d(TAG, "UID " + callingUid + " is actively using camera; letting them defy reserved cached data");
                flags |= 4;
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return flags;
    }

    @Override
    public long getAllocatableBytes(String volumeUuid, int flags, String callingPackage) {
        flags = this.adjustAllocateFlags(flags, Binder.getCallingUid(), callingPackage);
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        StorageStatsManager stats = this.mContext.getSystemService(StorageStatsManager.class);
        long token = Binder.clearCallingIdentity();
        try {
            File path = storage.findPathForUuid(volumeUuid);
            long usable = path.getUsableSpace();
            long lowReserved = storage.getStorageLowBytes(path);
            long fullReserved = storage.getStorageFullBytes(path);
            if (stats.isQuotaSupported(volumeUuid)) {
                long cacheTotal = stats.getCacheBytes(volumeUuid);
                long cacheReserved = storage.getStorageCacheBytes(path, flags);
                long cacheClearable = Math.max(0L, cacheTotal - cacheReserved);
                if ((flags & 1) != 0) {
                    long l = Math.max(0L, usable + cacheClearable - fullReserved);
                    return l;
                }
                long l = Math.max(0L, usable + cacheClearable - lowReserved);
                return l;
            }
            if ((flags & 1) != 0) {
                long l = Math.max(0L, usable - fullReserved);
                return l;
            }
            long l = Math.max(0L, usable - lowReserved);
            return l;
        }
        catch (IOException e) {
            throw new ParcelableException(e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    public void allocateBytes(String volumeUuid, long bytes, int flags, String callingPackage) {
        long allocatableBytes = this.getAllocatableBytes(volumeUuid, flags = this.adjustAllocateFlags(flags, Binder.getCallingUid(), callingPackage), callingPackage);
        if (bytes > allocatableBytes) {
            throw new ParcelableException(new IOException("Failed to allocate " + bytes + " because only " + allocatableBytes + " allocatable"));
        }
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        long token = Binder.clearCallingIdentity();
        try {
            File path = storage.findPathForUuid(volumeUuid);
            bytes = (flags & 1) != 0 ? (bytes += storage.getStorageFullBytes(path)) : (bytes += storage.getStorageLowBytes(path));
            this.mPms.freeStorage(volumeUuid, bytes, flags);
        }
        catch (IOException e) {
            throw new ParcelableException(e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void addObbStateLocked(ObbState obbState) throws RemoteException {
        IBinder binder = obbState.getBinder();
        List<ObbState> obbStates = this.mObbMounts.get(binder);
        if (obbStates == null) {
            obbStates = new ArrayList<ObbState>();
            this.mObbMounts.put(binder, obbStates);
        } else {
            for (ObbState o : obbStates) {
                if (!o.rawPath.equals(obbState.rawPath)) continue;
                throw new IllegalStateException("Attempt to add ObbState twice. This indicates an error in the StorageManagerService logic.");
            }
        }
        obbStates.add(obbState);
        try {
            obbState.link();
        }
        catch (RemoteException e) {
            obbStates.remove(obbState);
            if (obbStates.isEmpty()) {
                this.mObbMounts.remove(binder);
            }
            throw e;
        }
        this.mObbPathToStateMap.put(obbState.rawPath, obbState);
    }

    private void removeObbStateLocked(ObbState obbState) {
        IBinder binder = obbState.getBinder();
        List<ObbState> obbStates = this.mObbMounts.get(binder);
        if (obbStates != null) {
            if (obbStates.remove(obbState)) {
                obbState.unlink();
            }
            if (obbStates.isEmpty()) {
                this.mObbMounts.remove(binder);
            }
        }
        this.mObbPathToStateMap.remove(obbState.rawPath);
    }

    private void dispatchOnStatus(IVoldTaskListener listener, int status, PersistableBundle extras) {
        if (listener != null) {
            try {
                listener.onStatus(status, extras);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void dispatchOnFinished(IVoldTaskListener listener, int status, PersistableBundle extras) {
        if (listener != null) {
            try {
                listener.onFinished(status, extras);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, writer)) {
            return;
        }
        IndentingPrintWriter pw = new IndentingPrintWriter(writer, "  ", 160);
        Map<IBinder, List<ObbState>> map = this.mLock;
        synchronized (map) {
            int i;
            pw.println("Disks:");
            pw.increaseIndent();
            for (i = 0; i < this.mDisks.size(); ++i) {
                DiskInfo disk = this.mDisks.valueAt(i);
                disk.dump(pw);
            }
            pw.decreaseIndent();
            pw.println();
            pw.println("Volumes:");
            pw.increaseIndent();
            for (i = 0; i < this.mVolumes.size(); ++i) {
                VolumeInfo vol = this.mVolumes.valueAt(i);
                if ("private".equals(vol.id)) continue;
                vol.dump(pw);
            }
            pw.decreaseIndent();
            pw.println();
            pw.println("Records:");
            pw.increaseIndent();
            for (i = 0; i < this.mRecords.size(); ++i) {
                VolumeRecord note = this.mRecords.valueAt(i);
                note.dump(pw);
            }
            pw.decreaseIndent();
            pw.println();
            pw.println("Primary storage UUID: " + this.mPrimaryStorageUuid);
            Pair<String, Long> pair = StorageManager.getPrimaryStoragePathAndSize();
            if (pair == null) {
                pw.println("Internal storage total size: N/A");
            } else {
                pw.print("Internal storage (");
                pw.print((String)pair.first);
                pw.print(") total size: ");
                pw.print(pair.second);
                pw.print(" (");
                pw.print(DataUnit.MEBIBYTES.toBytes((Long)pair.second));
                pw.println(" MiB)");
            }
            pw.println("Force adoptable: " + this.mForceAdoptable);
            pw.println();
            pw.println("Local unlocked users: " + Arrays.toString(this.mLocalUnlockedUsers));
            pw.println("System unlocked users: " + Arrays.toString(this.mSystemUnlockedUsers));
        }
        map = this.mObbMounts;
        synchronized (map) {
            pw.println();
            pw.println("mObbMounts:");
            pw.increaseIndent();
            for (Map.Entry<IBinder, List<ObbState>> e : this.mObbMounts.entrySet()) {
                pw.println(e.getKey() + ":");
                pw.increaseIndent();
                List<ObbState> obbStates = e.getValue();
                for (ObbState obbState : obbStates) {
                    pw.println(obbState);
                }
                pw.decreaseIndent();
            }
            pw.decreaseIndent();
            pw.println();
            pw.println("mObbPathToStateMap:");
            pw.increaseIndent();
            for (Map.Entry<String, ObbState> e : this.mObbPathToStateMap.entrySet()) {
                pw.print(e.getKey());
                pw.print(" -> ");
                pw.println(e.getValue());
            }
            pw.decreaseIndent();
        }
        pw.println();
        pw.print("Last maintenance: ");
        pw.println(TimeUtils.formatForLogging(this.mLastMaintenance));
    }

    @Override
    public void monitor() {
        try {
            this.mVold.monitor();
        }
        catch (Exception e) {
            Slog.wtf(TAG, e);
        }
    }

    private final class StorageManagerInternalImpl
    extends StorageManagerInternal {
        private final CopyOnWriteArrayList<StorageManagerInternal.ExternalStorageMountPolicy> mPolicies = new CopyOnWriteArrayList();

        private StorageManagerInternalImpl() {
        }

        @Override
        public void addExternalStoragePolicy(StorageManagerInternal.ExternalStorageMountPolicy policy) {
            this.mPolicies.add(policy);
        }

        @Override
        public void onExternalStoragePolicyChanged(int uid, String packageName) {
            int mountMode = this.getExternalStorageMountMode(uid, packageName);
            StorageManagerService.this.remountUidExternalStorage(uid, mountMode);
        }

        @Override
        public int getExternalStorageMountMode(int uid, String packageName) {
            int mountMode = Integer.MAX_VALUE;
            for (StorageManagerInternal.ExternalStorageMountPolicy policy : this.mPolicies) {
                int policyMode = policy.getMountMode(uid, packageName);
                if (policyMode == 0) {
                    return 0;
                }
                mountMode = Math.min(mountMode, policyMode);
            }
            if (mountMode == Integer.MAX_VALUE) {
                return 0;
            }
            return mountMode;
        }

        public boolean hasExternalStorage(int uid, String packageName) {
            if (uid == 1000) {
                return true;
            }
            for (StorageManagerInternal.ExternalStorageMountPolicy policy : this.mPolicies) {
                boolean policyHasStorage = policy.hasExternalStorage(uid, packageName);
                if (policyHasStorage) continue;
                return false;
            }
            return true;
        }
    }

    private static class Callbacks
    extends Handler {
        private static final int MSG_STORAGE_STATE_CHANGED = 1;
        private static final int MSG_VOLUME_STATE_CHANGED = 2;
        private static final int MSG_VOLUME_RECORD_CHANGED = 3;
        private static final int MSG_VOLUME_FORGOTTEN = 4;
        private static final int MSG_DISK_SCANNED = 5;
        private static final int MSG_DISK_DESTROYED = 6;
        private final RemoteCallbackList<IStorageEventListener> mCallbacks = new RemoteCallbackList();

        public Callbacks(Looper looper) {
            super(looper);
        }

        public void register(IStorageEventListener callback) {
            this.mCallbacks.register(callback);
        }

        public void unregister(IStorageEventListener callback) {
            this.mCallbacks.unregister(callback);
        }

        @Override
        public void handleMessage(Message msg) {
            SomeArgs args = (SomeArgs)msg.obj;
            int n = this.mCallbacks.beginBroadcast();
            for (int i = 0; i < n; ++i) {
                IStorageEventListener callback = this.mCallbacks.getBroadcastItem(i);
                try {
                    this.invokeCallback(callback, msg.what, args);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mCallbacks.finishBroadcast();
            args.recycle();
        }

        private void invokeCallback(IStorageEventListener callback, int what, SomeArgs args) throws RemoteException {
            switch (what) {
                case 1: {
                    callback.onStorageStateChanged((String)args.arg1, (String)args.arg2, (String)args.arg3);
                    break;
                }
                case 2: {
                    callback.onVolumeStateChanged((VolumeInfo)args.arg1, args.argi2, args.argi3);
                    break;
                }
                case 3: {
                    callback.onVolumeRecordChanged((VolumeRecord)args.arg1);
                    break;
                }
                case 4: {
                    callback.onVolumeForgotten((String)args.arg1);
                    break;
                }
                case 5: {
                    callback.onDiskScanned((DiskInfo)args.arg1, args.argi2);
                    break;
                }
                case 6: {
                    callback.onDiskDestroyed((DiskInfo)args.arg1);
                }
            }
        }

        private void notifyStorageStateChanged(String path, String oldState, String newState) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = path;
            args.arg2 = oldState;
            args.arg3 = newState;
            this.obtainMessage(1, args).sendToTarget();
        }

        private void notifyVolumeStateChanged(VolumeInfo vol, int oldState, int newState) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = vol.clone();
            args.argi2 = oldState;
            args.argi3 = newState;
            this.obtainMessage(2, args).sendToTarget();
        }

        private void notifyVolumeRecordChanged(VolumeRecord rec) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = rec.clone();
            this.obtainMessage(3, args).sendToTarget();
        }

        private void notifyVolumeForgotten(String fsUuid) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = fsUuid;
            this.obtainMessage(4, args).sendToTarget();
        }

        private void notifyDiskScanned(DiskInfo disk, int volumeCount) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = disk.clone();
            args.argi2 = volumeCount;
            this.obtainMessage(5, args).sendToTarget();
        }

        private void notifyDiskDestroyed(DiskInfo disk) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = disk.clone();
            this.obtainMessage(6, args).sendToTarget();
        }
    }

    class UnmountObbAction
    extends ObbAction {
        private final boolean mForceUnmount;

        UnmountObbAction(ObbState obbState, boolean force) {
            super(obbState);
            this.mForceUnmount = force;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleExecute() throws IOException {
            ObbState existingState;
            StorageManagerService.this.warnOnNotMounted();
            Map map = StorageManagerService.this.mObbMounts;
            synchronized (map) {
                existingState = (ObbState)StorageManagerService.this.mObbPathToStateMap.get(this.mObbState.rawPath);
            }
            if (existingState == null) {
                this.sendNewStatusOrIgnore(23);
                return;
            }
            if (existingState.ownerGid != this.mObbState.ownerGid) {
                Slog.w(StorageManagerService.TAG, "Permission denied attempting to unmount OBB " + existingState.rawPath + " (owned by GID " + existingState.ownerGid + ")");
                this.sendNewStatusOrIgnore(25);
                return;
            }
            int rc = 0;
            try {
                StorageManagerService.this.mVold.unmount(this.mObbState.volId);
                StorageManagerService.this.mVold.destroyObb(this.mObbState.volId);
                this.mObbState.volId = null;
            }
            catch (Exception e) {
                Slog.w(StorageManagerService.TAG, e);
                rc = -1;
            }
            if (rc == 0) {
                Map map2 = StorageManagerService.this.mObbMounts;
                synchronized (map2) {
                    StorageManagerService.this.removeObbStateLocked(existingState);
                }
                this.sendNewStatusOrIgnore(2);
            } else {
                Slog.w(StorageManagerService.TAG, "Could not unmount OBB: " + existingState);
                this.sendNewStatusOrIgnore(22);
            }
        }

        @Override
        public void handleError() {
            this.sendNewStatusOrIgnore(20);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("UnmountObbAction{");
            sb.append(this.mObbState);
            sb.append(",force=");
            sb.append(this.mForceUnmount);
            sb.append('}');
            return sb.toString();
        }
    }

    class MountObbAction
    extends ObbAction {
        private final String mKey;
        private final int mCallingUid;

        MountObbAction(ObbState obbState, String key, int callingUid) {
            super(obbState);
            this.mKey = key;
            this.mCallingUid = callingUid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleExecute() throws IOException, RemoteException {
            String binderKey;
            String hashedKey;
            boolean isMounted;
            StorageManagerService.this.warnOnNotMounted();
            ObbInfo obbInfo = this.getObbInfo();
            if (!StorageManagerService.this.isUidOwnerOfPackageOrSystem(obbInfo.packageName, this.mCallingUid)) {
                Slog.w(StorageManagerService.TAG, "Denied attempt to mount OBB " + obbInfo.filename + " which is owned by " + obbInfo.packageName);
                this.sendNewStatusOrIgnore(25);
                return;
            }
            Map map = StorageManagerService.this.mObbMounts;
            synchronized (map) {
                isMounted = StorageManagerService.this.mObbPathToStateMap.containsKey(this.mObbState.rawPath);
            }
            if (isMounted) {
                Slog.w(StorageManagerService.TAG, "Attempt to mount OBB which is already mounted: " + obbInfo.filename);
                this.sendNewStatusOrIgnore(24);
                return;
            }
            if (this.mKey == null) {
                hashedKey = "none";
                binderKey = "";
            } else {
                try {
                    SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
                    PBEKeySpec ks = new PBEKeySpec(this.mKey.toCharArray(), obbInfo.salt, 1024, 128);
                    SecretKey key = factory.generateSecret(ks);
                    BigInteger bi = new BigInteger(key.getEncoded());
                    binderKey = hashedKey = bi.toString(16);
                }
                catch (NoSuchAlgorithmException e) {
                    Slog.e(StorageManagerService.TAG, "Could not load PBKDF2 algorithm", e);
                    this.sendNewStatusOrIgnore(20);
                    return;
                }
                catch (InvalidKeySpecException e) {
                    Slog.e(StorageManagerService.TAG, "Invalid key spec when loading PBKDF2 algorithm", e);
                    this.sendNewStatusOrIgnore(20);
                    return;
                }
            }
            int rc = 0;
            try {
                this.mObbState.volId = StorageManagerService.this.mVold.createObb(this.mObbState.canonicalPath, binderKey, this.mObbState.ownerGid);
                StorageManagerService.this.mVold.mount(this.mObbState.volId, 0, -1);
            }
            catch (Exception e) {
                Slog.w(StorageManagerService.TAG, e);
                rc = -1;
            }
            if (rc == 0) {
                Map map2 = StorageManagerService.this.mObbMounts;
                synchronized (map2) {
                    StorageManagerService.this.addObbStateLocked(this.mObbState);
                }
                this.sendNewStatusOrIgnore(1);
            } else {
                Slog.e(StorageManagerService.TAG, "Couldn't mount OBB file: " + rc);
                this.sendNewStatusOrIgnore(21);
            }
        }

        @Override
        public void handleError() {
            this.sendNewStatusOrIgnore(20);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("MountObbAction{");
            sb.append(this.mObbState);
            sb.append('}');
            return sb.toString();
        }
    }

    abstract class ObbAction {
        private static final int MAX_RETRIES = 3;
        private int mRetries;
        ObbState mObbState;

        ObbAction(ObbState obbState) {
            this.mObbState = obbState;
        }

        public void execute(ObbActionHandler handler) {
            try {
                ++this.mRetries;
                if (this.mRetries > 3) {
                    Slog.w(StorageManagerService.TAG, "Failed to invoke remote methods on default container service. Giving up");
                    StorageManagerService.this.mObbActionHandler.sendEmptyMessage(3);
                    this.handleError();
                } else {
                    this.handleExecute();
                    StorageManagerService.this.mObbActionHandler.sendEmptyMessage(3);
                }
            }
            catch (RemoteException e) {
                StorageManagerService.this.mObbActionHandler.sendEmptyMessage(4);
            }
            catch (Exception e) {
                this.handleError();
                StorageManagerService.this.mObbActionHandler.sendEmptyMessage(3);
            }
        }

        abstract void handleExecute() throws RemoteException, IOException;

        abstract void handleError();

        protected ObbInfo getObbInfo() throws IOException {
            ObbInfo obbInfo;
            try {
                obbInfo = StorageManagerService.this.mContainerService.getObbInfo(this.mObbState.canonicalPath);
            }
            catch (RemoteException e) {
                Slog.d(StorageManagerService.TAG, "Couldn't call DefaultContainerService to fetch OBB info for " + this.mObbState.canonicalPath);
                obbInfo = null;
            }
            if (obbInfo == null) {
                throw new IOException("Couldn't read OBB file: " + this.mObbState.canonicalPath);
            }
            return obbInfo;
        }

        protected void sendNewStatusOrIgnore(int status) {
            if (this.mObbState == null || this.mObbState.token == null) {
                return;
            }
            try {
                this.mObbState.token.onObbResult(this.mObbState.rawPath, this.mObbState.nonce, status);
            }
            catch (RemoteException e) {
                Slog.w(StorageManagerService.TAG, "StorageEventListener went away while calling onObbStateChanged");
            }
        }
    }

    private class ObbActionHandler
    extends Handler {
        private boolean mBound;
        private final List<ObbAction> mActions;

        ObbActionHandler(Looper l) {
            super(l);
            this.mBound = false;
            this.mActions = new LinkedList<ObbAction>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ObbAction action = (ObbAction)msg.obj;
                    if (!this.mBound && !this.connectToService()) {
                        Slog.e(StorageManagerService.TAG, "Failed to bind to media container service");
                        action.handleError();
                        return;
                    }
                    this.mActions.add(action);
                    break;
                }
                case 2: {
                    if (msg.obj != null) {
                        StorageManagerService.this.mContainerService = (IMediaContainerService)msg.obj;
                    }
                    if (StorageManagerService.this.mContainerService == null) {
                        Slog.e(StorageManagerService.TAG, "Cannot bind to media container service");
                        for (ObbAction action : this.mActions) {
                            action.handleError();
                        }
                        this.mActions.clear();
                        break;
                    }
                    if (this.mActions.size() > 0) {
                        ObbAction action = this.mActions.get(0);
                        if (action == null) break;
                        action.execute(this);
                        break;
                    }
                    Slog.w(StorageManagerService.TAG, "Empty queue");
                    break;
                }
                case 4: {
                    if (this.mActions.size() <= 0) break;
                    if (this.mBound) {
                        this.disconnectService();
                    }
                    if (this.connectToService()) break;
                    Slog.e(StorageManagerService.TAG, "Failed to bind to media container service");
                    for (ObbAction action : this.mActions) {
                        action.handleError();
                    }
                    this.mActions.clear();
                    break;
                }
                case 3: {
                    if (this.mActions.size() > 0) {
                        this.mActions.remove(0);
                    }
                    if (this.mActions.size() == 0) {
                        if (!this.mBound) break;
                        this.disconnectService();
                        break;
                    }
                    StorageManagerService.this.mObbActionHandler.sendEmptyMessage(2);
                    break;
                }
                case 5: {
                    String path = (String)msg.obj;
                    Map map = StorageManagerService.this.mObbMounts;
                    synchronized (map) {
                        LinkedList<ObbState> obbStatesToRemove = new LinkedList<ObbState>();
                        for (ObbState state : StorageManagerService.this.mObbPathToStateMap.values()) {
                            if (!state.canonicalPath.startsWith(path)) continue;
                            obbStatesToRemove.add(state);
                        }
                        for (ObbState obbState : obbStatesToRemove) {
                            StorageManagerService.this.removeObbStateLocked(obbState);
                            try {
                                obbState.token.onObbResult(obbState.rawPath, obbState.nonce, 2);
                            }
                            catch (RemoteException e) {
                                Slog.i(StorageManagerService.TAG, "Couldn't send unmount notification for  OBB: " + obbState.rawPath);
                            }
                        }
                        break;
                    }
                }
            }
        }

        private boolean connectToService() {
            Intent service = new Intent().setComponent(DEFAULT_CONTAINER_COMPONENT);
            if (StorageManagerService.this.mContext.bindServiceAsUser(service, StorageManagerService.this.mDefContainerConn, 1, UserHandle.SYSTEM)) {
                this.mBound = true;
                return true;
            }
            return false;
        }

        private void disconnectService() {
            StorageManagerService.this.mContainerService = null;
            this.mBound = false;
            StorageManagerService.this.mContext.unbindService(StorageManagerService.this.mDefContainerConn);
        }
    }

    class AppFuseMountScope
    extends AppFuseBridge.MountScope {
        boolean opened;

        public AppFuseMountScope(int uid, int pid, int mountId) {
            super(uid, pid, mountId);
            this.opened = false;
        }

        @Override
        public ParcelFileDescriptor open() throws NativeDaemonConnectorException {
            try {
                return new ParcelFileDescriptor(StorageManagerService.this.mVold.mountAppFuse(this.uid, Process.myPid(), this.mountId));
            }
            catch (Exception e) {
                throw new NativeDaemonConnectorException("Failed to mount", e);
            }
        }

        @Override
        public void close() throws Exception {
            if (this.opened) {
                StorageManagerService.this.mVold.unmountAppFuse(this.uid, Process.myPid(), this.mountId);
                this.opened = false;
            }
        }
    }

    class StorageManagerServiceHandler
    extends Handler {
        public StorageManagerServiceHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    StorageManagerService.this.handleSystemReady();
                    break;
                }
                case 2: {
                    StorageManagerService.this.handleDaemonConnected();
                    break;
                }
                case 4: {
                    Slog.i(StorageManagerService.TAG, "Running fstrim idle maintenance");
                    try {
                        StorageManagerService.this.mLastMaintenance = System.currentTimeMillis();
                        StorageManagerService.this.mLastMaintenanceFile.setLastModified(StorageManagerService.this.mLastMaintenance);
                    }
                    catch (Exception e) {
                        Slog.e(StorageManagerService.TAG, "Unable to record last fstrim!");
                    }
                    StorageManagerService.this.fstrim(0, null);
                    Runnable callback = (Runnable)msg.obj;
                    if (callback == null) break;
                    callback.run();
                    break;
                }
                case 3: {
                    IStorageShutdownObserver obs = (IStorageShutdownObserver)msg.obj;
                    boolean success = false;
                    try {
                        StorageManagerService.this.mVold.shutdown();
                        success = true;
                    }
                    catch (Exception e) {
                        Slog.wtf(StorageManagerService.TAG, e);
                    }
                    if (obs == null) break;
                    try {
                        obs.onShutDownComplete(success ? 0 : -1);
                    }
                    catch (Exception e) {}
                    break;
                }
                case 5: {
                    VolumeInfo vol = (VolumeInfo)msg.obj;
                    if (StorageManagerService.this.isMountDisallowed(vol)) {
                        Slog.i(StorageManagerService.TAG, "Ignoring mount " + vol.getId() + " due to policy");
                        break;
                    }
                    try {
                        StorageManagerService.this.mVold.mount(vol.id, vol.mountFlags, vol.mountUserId);
                    }
                    catch (Exception e) {
                        Slog.wtf(StorageManagerService.TAG, e);
                    }
                    break;
                }
                case 8: {
                    VolumeInfo vol = (VolumeInfo)msg.obj;
                    StorageManagerService.this.unmount(vol.getId());
                    break;
                }
                case 6: {
                    StorageVolume userVol = (StorageVolume)msg.obj;
                    String envState = userVol.getState();
                    Slog.d(StorageManagerService.TAG, "Volume " + userVol.getId() + " broadcasting " + envState + " to " + userVol.getOwner());
                    String action = VolumeInfo.getBroadcastForEnvironment(envState);
                    if (action == null) break;
                    Intent intent = new Intent(action, Uri.fromFile(userVol.getPathFile()));
                    intent.putExtra("android.os.storage.extra.STORAGE_VOLUME", userVol);
                    intent.addFlags(0x5000000);
                    StorageManagerService.this.mContext.sendBroadcastAsUser(intent, userVol.getOwner());
                    break;
                }
                case 7: {
                    Intent intent = (Intent)msg.obj;
                    StorageManagerService.this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, "android.permission.WRITE_MEDIA_STORAGE");
                    break;
                }
                case 9: {
                    VolumeRecord rec = (VolumeRecord)msg.obj;
                    StorageManagerService.this.forgetPartition(rec.partGuid, rec.fsUuid);
                    break;
                }
                case 10: {
                    StorageManagerService.this.resetIfReadyAndConnected();
                    break;
                }
                case 11: {
                    Slog.i(StorageManagerService.TAG, "Running idle maintenance");
                    StorageManagerService.this.runIdleMaint((Runnable)msg.obj);
                    break;
                }
                case 12: {
                    Slog.i(StorageManagerService.TAG, "Aborting idle maintenance");
                    StorageManagerService.this.abortIdleMaint((Runnable)msg.obj);
                }
            }
        }
    }

    class DefaultContainerConnection
    implements ServiceConnection {
        DefaultContainerConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            IMediaContainerService imcs = IMediaContainerService.Stub.asInterface(service);
            StorageManagerService.this.mObbActionHandler.sendMessage(StorageManagerService.this.mObbActionHandler.obtainMessage(2, imcs));
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
        }
    }

    class ObbState
    implements IBinder.DeathRecipient {
        final String rawPath;
        final String canonicalPath;
        final int ownerGid;
        final IObbActionListener token;
        final int nonce;
        String volId;

        public ObbState(String rawPath, String canonicalPath, int callingUid, IObbActionListener token, int nonce, String volId) {
            this.rawPath = rawPath;
            this.canonicalPath = canonicalPath;
            this.ownerGid = UserHandle.getSharedAppGid(callingUid);
            this.token = token;
            this.nonce = nonce;
            this.volId = volId;
        }

        public IBinder getBinder() {
            return this.token.asBinder();
        }

        @Override
        public void binderDied() {
            UnmountObbAction action = new UnmountObbAction(this, true);
            StorageManagerService.this.mObbActionHandler.sendMessage(StorageManagerService.this.mObbActionHandler.obtainMessage(1, action));
        }

        public void link() throws RemoteException {
            this.getBinder().linkToDeath(this, 0);
        }

        public void unlink() {
            this.getBinder().unlinkToDeath(this, 0);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ObbState{");
            sb.append("rawPath=").append(this.rawPath);
            sb.append(",canonicalPath=").append(this.canonicalPath);
            sb.append(",ownerGid=").append(this.ownerGid);
            sb.append(",token=").append(this.token);
            sb.append(",binder=").append(this.getBinder());
            sb.append(",volId=").append(this.volId);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class Lifecycle
    extends SystemService {
        private StorageManagerService mStorageManagerService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            this.mStorageManagerService = new StorageManagerService(this.getContext());
            this.publishBinderService("mount", this.mStorageManagerService);
            this.mStorageManagerService.start();
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 550) {
                this.mStorageManagerService.systemReady();
            } else if (phase == 1000) {
                this.mStorageManagerService.bootCompleted();
            }
        }

        @Override
        public void onSwitchUser(int userHandle) {
            this.mStorageManagerService.mCurrentUserId = userHandle;
        }

        @Override
        public void onUnlockUser(int userHandle) {
            this.mStorageManagerService.onUnlockUser(userHandle);
        }

        @Override
        public void onCleanupUser(int userHandle) {
            this.mStorageManagerService.onCleanupUser(userHandle);
        }
    }
}

