/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.IActivityController;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hidl.manager.V1_0.IServiceManager;
import android.os.Binder;
import android.os.Build;
import android.os.Debug;
import android.os.Handler;
import android.os.IPowerManager;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructRlimit;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import com.android.server.DisplayThread;
import com.android.server.FgThread;
import com.android.server.IoThread;
import com.android.server.UiThread;
import com.android.server.am.ActivityManagerService;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class Watchdog
extends Thread {
    static final String TAG = "Watchdog";
    static final boolean DB = false;
    static final long DEFAULT_TIMEOUT = 60000L;
    static final long CHECK_INTERVAL = 30000L;
    static final int COMPLETED = 0;
    static final int WAITING = 1;
    static final int WAITED_HALF = 2;
    static final int OVERDUE = 3;
    public static final String[] NATIVE_STACKS_OF_INTEREST = new String[]{"/system/bin/audioserver", "/system/bin/cameraserver", "/system/bin/drmserver", "/system/bin/mediadrmserver", "/system/bin/mediaserver", "/system/bin/sdcard", "/system/bin/surfaceflinger", "media.extractor", "media.metrics", "media.codec", "com.android.bluetooth", "statsd"};
    public static final List<String> HAL_INTERFACES_OF_INTEREST = Arrays.asList("android.hardware.audio@2.0::IDevicesFactory", "android.hardware.bluetooth@1.0::IBluetoothHci", "android.hardware.camera.provider@2.4::ICameraProvider", "android.hardware.graphics.composer@2.1::IComposer", "android.hardware.media.omx@1.0::IOmx", "android.hardware.sensors@1.0::ISensors", "android.hardware.vr@1.0::IVr");
    static Watchdog sWatchdog;
    final ArrayList<HandlerChecker> mHandlerCheckers = new ArrayList();
    final HandlerChecker mMonitorChecker = new HandlerChecker(FgThread.getHandler(), "foreground thread", 60000L);
    ContentResolver mResolver;
    ActivityManagerService mActivity;
    int mPhonePid;
    IActivityController mController;
    boolean mAllowRestart = true;
    final OpenFdMonitor mOpenFdMonitor;

    public static Watchdog getInstance() {
        if (sWatchdog == null) {
            sWatchdog = new Watchdog();
        }
        return sWatchdog;
    }

    private Watchdog() {
        super("watchdog");
        this.mHandlerCheckers.add(this.mMonitorChecker);
        this.mHandlerCheckers.add(new HandlerChecker(new Handler(Looper.getMainLooper()), "main thread", 60000L));
        this.mHandlerCheckers.add(new HandlerChecker(UiThread.getHandler(), "ui thread", 60000L));
        this.mHandlerCheckers.add(new HandlerChecker(IoThread.getHandler(), "i/o thread", 60000L));
        this.mHandlerCheckers.add(new HandlerChecker(DisplayThread.getHandler(), "display thread", 60000L));
        this.addMonitor(new BinderThreadMonitor());
        this.mOpenFdMonitor = OpenFdMonitor.create();
    }

    public void init(Context context, ActivityManagerService activity) {
        this.mResolver = context.getContentResolver();
        this.mActivity = activity;
        context.registerReceiver(new RebootRequestReceiver(), new IntentFilter("android.intent.action.REBOOT"), "android.permission.REBOOT", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStarted(String name, int pid) {
        Watchdog watchdog = this;
        synchronized (watchdog) {
            if ("com.android.phone".equals(name)) {
                this.mPhonePid = pid;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActivityController(IActivityController controller) {
        Watchdog watchdog = this;
        synchronized (watchdog) {
            this.mController = controller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowRestart(boolean allowRestart) {
        Watchdog watchdog = this;
        synchronized (watchdog) {
            this.mAllowRestart = allowRestart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitor(Monitor monitor) {
        Watchdog watchdog = this;
        synchronized (watchdog) {
            if (this.isAlive()) {
                throw new RuntimeException("Monitors can't be added once the Watchdog is running");
            }
            this.mMonitorChecker.addMonitor(monitor);
        }
    }

    public void addThread(Handler thread) {
        this.addThread(thread, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThread(Handler thread, long timeoutMillis) {
        Watchdog watchdog = this;
        synchronized (watchdog) {
            if (this.isAlive()) {
                throw new RuntimeException("Threads can't be added once the Watchdog is running");
            }
            String name = thread.getLooper().getThread().getName();
            this.mHandlerCheckers.add(new HandlerChecker(thread, name, timeoutMillis));
        }
    }

    void rebootSystem(String reason) {
        Slog.i(TAG, "Rebooting system because: " + reason);
        IPowerManager pms = (IPowerManager)((Object)ServiceManager.getService("power"));
        try {
            pms.reboot(false, reason, false);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private int evaluateCheckerCompletionLocked() {
        int state = 0;
        for (int i = 0; i < this.mHandlerCheckers.size(); ++i) {
            HandlerChecker hc = this.mHandlerCheckers.get(i);
            state = Math.max(state, hc.getCompletionStateLocked());
        }
        return state;
    }

    private ArrayList<HandlerChecker> getBlockedCheckersLocked() {
        ArrayList<HandlerChecker> checkers = new ArrayList<HandlerChecker>();
        for (int i = 0; i < this.mHandlerCheckers.size(); ++i) {
            HandlerChecker hc = this.mHandlerCheckers.get(i);
            if (!hc.isOverdueLocked()) continue;
            checkers.add(hc);
        }
        return checkers;
    }

    private String describeCheckersLocked(List<HandlerChecker> checkers) {
        StringBuilder builder = new StringBuilder(128);
        for (int i = 0; i < checkers.size(); ++i) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(checkers.get(i).describeBlockedStateLocked());
        }
        return builder.toString();
    }

    private ArrayList<Integer> getInterestingHalPids() {
        try {
            IServiceManager serviceManager = IServiceManager.getService();
            ArrayList dump = serviceManager.debugDump();
            HashSet<Integer> pids = new HashSet<Integer>();
            for (IServiceManager.InstanceDebugInfo info : dump) {
                if (info.pid == -1 || !HAL_INTERFACES_OF_INTEREST.contains(info.interfaceName)) continue;
                pids.add(info.pid);
            }
            return new ArrayList<Integer>(pids);
        }
        catch (RemoteException e) {
            return new ArrayList<Integer>();
        }
    }

    private ArrayList<Integer> getInterestingNativePids() {
        ArrayList<Integer> pids = this.getInterestingHalPids();
        int[] nativePids = android.os.Process.getPidsForCommands(NATIVE_STACKS_OF_INTEREST);
        if (nativePids != null) {
            pids.ensureCapacity(pids.size() + nativePids.length);
            for (int i : nativePids) {
                pids.add(i);
            }
        }
        return pids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean waitedHalf = false;
        while (true) {
            IActivityController controller;
            boolean allowRestart;
            String subject;
            List<HandlerChecker> blockedCheckers;
            Runnable hc;
            int debuggerWasConnected = 0;
            Watchdog watchdog = this;
            synchronized (watchdog) {
                long timeout = 30000L;
                for (int i = 0; i < this.mHandlerCheckers.size(); ++i) {
                    hc = this.mHandlerCheckers.get(i);
                    hc.scheduleCheckLocked();
                }
                if (debuggerWasConnected > 0) {
                    --debuggerWasConnected;
                }
                long start = SystemClock.uptimeMillis();
                while (timeout > 0L) {
                    if (Debug.isDebuggerConnected()) {
                        debuggerWasConnected = 2;
                    }
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        Log.wtf(TAG, e);
                    }
                    if (Debug.isDebuggerConnected()) {
                        debuggerWasConnected = 2;
                    }
                    timeout = 30000L - (SystemClock.uptimeMillis() - start);
                }
                boolean fdLimitTriggered = false;
                if (this.mOpenFdMonitor != null) {
                    fdLimitTriggered = this.mOpenFdMonitor.monitor();
                }
                if (!fdLimitTriggered) {
                    int waitState = this.evaluateCheckerCompletionLocked();
                    if (waitState == 0) {
                        waitedHalf = false;
                        continue;
                    }
                    if (waitState == 1) {
                        continue;
                    }
                    if (waitState == 2) {
                        if (!waitedHalf) {
                            ArrayList<Integer> pids = new ArrayList<Integer>();
                            pids.add(android.os.Process.myPid());
                            ActivityManagerService.dumpStackTraces(true, pids, null, null, this.getInterestingNativePids());
                            waitedHalf = true;
                        }
                        continue;
                    }
                    blockedCheckers = this.getBlockedCheckersLocked();
                    subject = this.describeCheckersLocked(blockedCheckers);
                } else {
                    blockedCheckers = Collections.emptyList();
                    subject = "Open FD high water mark reached";
                }
                allowRestart = this.mAllowRestart;
            }
            EventLog.writeEvent(2802, subject);
            ArrayList<Integer> pids = new ArrayList<Integer>();
            pids.add(android.os.Process.myPid());
            if (this.mPhonePid > 0) {
                pids.add(this.mPhonePid);
            }
            final File stack = ActivityManagerService.dumpStackTraces(!waitedHalf, pids, null, null, this.getInterestingNativePids());
            SystemClock.sleep(2000L);
            this.doSysRq('w');
            this.doSysRq('l');
            Thread dropboxThread = new Thread("watchdogWriteToDropbox"){

                @Override
                public void run() {
                    Watchdog.this.mActivity.addErrorToDropBox("watchdog", null, "system_server", null, null, subject, null, stack, null);
                }
            };
            dropboxThread.start();
            try {
                dropboxThread.join(2000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            hc = this;
            synchronized (hc) {
                controller = this.mController;
            }
            if (controller != null) {
                Slog.i(TAG, "Reporting stuck state to activity controller");
                try {
                    Binder.setDumpDisabled("Service dumps disabled due to hung system process.");
                    int res = controller.systemNotResponding(subject);
                    if (res >= 0) {
                        Slog.i(TAG, "Activity controller requested to coninue to wait");
                        waitedHalf = false;
                        continue;
                    }
                }
                catch (RemoteException res) {
                    // empty catch block
                }
            }
            if (Debug.isDebuggerConnected()) {
                debuggerWasConnected = 2;
            }
            if (debuggerWasConnected >= 2) {
                Slog.w(TAG, "Debugger connected: Watchdog is *not* killing the system process");
            } else if (debuggerWasConnected > 0) {
                Slog.w(TAG, "Debugger was connected: Watchdog is *not* killing the system process");
            } else if (!allowRestart) {
                Slog.w(TAG, "Restart not allowed: Watchdog is *not* killing the system process");
            } else {
                Slog.w(TAG, "*** WATCHDOG KILLING SYSTEM PROCESS: " + subject);
                for (int i = 0; i < blockedCheckers.size(); ++i) {
                    StackTraceElement[] stackTrace;
                    Slog.w(TAG, blockedCheckers.get(i).getName() + " stack trace:");
                    for (StackTraceElement element : stackTrace = blockedCheckers.get(i).getThread().getStackTrace()) {
                        Slog.w(TAG, "    at " + element);
                    }
                }
                Slog.w(TAG, "*** GOODBYE!");
                android.os.Process.killProcess(android.os.Process.myPid());
                System.exit(10);
            }
            waitedHalf = false;
        }
    }

    private void doSysRq(char c) {
        try {
            FileWriter sysrq_trigger = new FileWriter("/proc/sysrq-trigger");
            sysrq_trigger.write(c);
            sysrq_trigger.close();
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed to write to /proc/sysrq-trigger", e);
        }
    }

    public static final class OpenFdMonitor {
        private static final int FD_HIGH_WATER_MARK = 12;
        private final File mDumpDir;
        private final File mFdHighWaterMark;

        public static OpenFdMonitor create() {
            StructRlimit rlimit;
            if (!Build.IS_DEBUGGABLE) {
                return null;
            }
            String dumpDirStr = SystemProperties.get("dalvik.vm.stack-trace-dir", "");
            if (dumpDirStr.isEmpty()) {
                return null;
            }
            try {
                rlimit = Os.getrlimit(OsConstants.RLIMIT_NOFILE);
            }
            catch (ErrnoException errno) {
                Slog.w(Watchdog.TAG, "Error thrown from getrlimit(RLIMIT_NOFILE)", errno);
                return null;
            }
            File fdThreshold = new File("/proc/self/fd/" + (rlimit.rlim_cur - 12L));
            return new OpenFdMonitor(new File(dumpDirStr), fdThreshold);
        }

        OpenFdMonitor(File dumpDir, File fdThreshold) {
            this.mDumpDir = dumpDir;
            this.mFdHighWaterMark = fdThreshold;
        }

        private void dumpOpenDescriptors() {
            try {
                File dumpFile = File.createTempFile("anr_fd_", "", this.mDumpDir);
                Process proc = new ProcessBuilder(new String[0]).command("/system/bin/lsof", "-p", String.valueOf(android.os.Process.myPid())).redirectErrorStream(true).redirectOutput(dumpFile).start();
                int returnCode = proc.waitFor();
                if (returnCode != 0) {
                    Slog.w(Watchdog.TAG, "Unable to dump open descriptors, lsof return code: " + returnCode);
                    dumpFile.delete();
                }
            }
            catch (IOException | InterruptedException ex) {
                Slog.w(Watchdog.TAG, "Unable to dump open descriptors: " + ex);
            }
        }

        public boolean monitor() {
            if (this.mFdHighWaterMark.exists()) {
                this.dumpOpenDescriptors();
                return true;
            }
            return false;
        }
    }

    public static interface Monitor {
        public void monitor();
    }

    private static final class BinderThreadMonitor
    implements Monitor {
        private BinderThreadMonitor() {
        }

        @Override
        public void monitor() {
            Binder.blockUntilThreadAvailable();
        }
    }

    final class RebootRequestReceiver
    extends BroadcastReceiver {
        RebootRequestReceiver() {
        }

        @Override
        public void onReceive(Context c, Intent intent) {
            if (intent.getIntExtra("nowait", 0) != 0) {
                Watchdog.this.rebootSystem("Received ACTION_REBOOT broadcast");
                return;
            }
            Slog.w(Watchdog.TAG, "Unsupported ACTION_REBOOT broadcast: " + intent);
        }
    }

    public final class HandlerChecker
    implements Runnable {
        private final Handler mHandler;
        private final String mName;
        private final long mWaitMax;
        private final ArrayList<Monitor> mMonitors = new ArrayList();
        private boolean mCompleted;
        private Monitor mCurrentMonitor;
        private long mStartTime;

        HandlerChecker(Handler handler, String name, long waitMaxMillis) {
            this.mHandler = handler;
            this.mName = name;
            this.mWaitMax = waitMaxMillis;
            this.mCompleted = true;
        }

        public void addMonitor(Monitor monitor) {
            this.mMonitors.add(monitor);
        }

        public void scheduleCheckLocked() {
            if (this.mMonitors.size() == 0 && this.mHandler.getLooper().getQueue().isPolling()) {
                this.mCompleted = true;
                return;
            }
            if (!this.mCompleted) {
                return;
            }
            this.mCompleted = false;
            this.mCurrentMonitor = null;
            this.mStartTime = SystemClock.uptimeMillis();
            this.mHandler.postAtFrontOfQueue(this);
        }

        public boolean isOverdueLocked() {
            return !this.mCompleted && SystemClock.uptimeMillis() > this.mStartTime + this.mWaitMax;
        }

        public int getCompletionStateLocked() {
            if (this.mCompleted) {
                return 0;
            }
            long latency = SystemClock.uptimeMillis() - this.mStartTime;
            if (latency < this.mWaitMax / 2L) {
                return 1;
            }
            if (latency < this.mWaitMax) {
                return 2;
            }
            return 3;
        }

        public Thread getThread() {
            return this.mHandler.getLooper().getThread();
        }

        public String getName() {
            return this.mName;
        }

        public String describeBlockedStateLocked() {
            if (this.mCurrentMonitor == null) {
                return "Blocked in handler on " + this.mName + " (" + this.getThread().getName() + ")";
            }
            return "Blocked in monitor " + this.mCurrentMonitor.getClass().getName() + " on " + this.mName + " (" + this.getThread().getName() + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int size = this.mMonitors.size();
            for (int i = 0; i < size; ++i) {
                Watchdog watchdog = Watchdog.this;
                synchronized (watchdog) {
                    this.mCurrentMonitor = this.mMonitors.get(i);
                }
                this.mCurrentMonitor.monitor();
            }
            Watchdog watchdog = Watchdog.this;
            synchronized (watchdog) {
                this.mCompleted = true;
                this.mCurrentMonitor = null;
            }
        }
    }
}

