/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.app.ActivityManagerInternal;
import android.app.AlertDialog;
import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.appwidget.AppWidgetManagerInternal;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.display.DisplayManager;
import android.hardware.fingerprint.IFingerprintService;
import android.media.AudioManagerInternal;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.UserManagerInternal;
import android.provider.Settings;
import android.provider.SettingsStringUtil;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.IntArray;
import android.util.Slog;
import android.util.SparseArray;
import android.view.Display;
import android.view.IWindow;
import android.view.KeyEvent;
import android.view.MagnificationSpec;
import android.view.WindowInfo;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import android.view.accessibility.IAccessibilityManager;
import android.view.accessibility.IAccessibilityManagerClient;
import com.android.internal.accessibility.AccessibilityShortcutController;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.content.PackageMonitor;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FunctionalUtils;
import com.android.internal.util.IntPair;
import com.android.server.LocalServices;
import com.android.server.accessibility.AbstractAccessibilityServiceConnection;
import com.android.server.accessibility.AccessibilityInputFilter;
import com.android.server.accessibility.AccessibilityServiceConnection;
import com.android.server.accessibility.AccessibilityShellCommand;
import com.android.server.accessibility.ActionReplacingCallback;
import com.android.server.accessibility.DisplayAdjustmentUtils;
import com.android.server.accessibility.FingerprintGestureDispatcher;
import com.android.server.accessibility.GlobalActionPerformer;
import com.android.server.accessibility.KeyEventDispatcher;
import com.android.server.accessibility.MagnificationController;
import com.android.server.accessibility.MotionEventInjector;
import com.android.server.accessibility.UiAutomationManager;
import com.android.server.wm.WindowManagerInternal;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParserException;

public class AccessibilityManagerService
extends IAccessibilityManager.Stub
implements AbstractAccessibilityServiceConnection.SystemSupport {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AccessibilityManagerService";
    private static final int WAIT_FOR_USER_STATE_FULLY_INITIALIZED_MILLIS = 3000;
    private static final int WAIT_WINDOWS_TIMEOUT_MILLIS = 5000;
    private static final int WAIT_MOTION_INJECTOR_TIMEOUT_MILLIS = 1000;
    private static final String FUNCTION_REGISTER_UI_TEST_AUTOMATION_SERVICE = "registerUiTestAutomationService";
    private static final String TEMPORARY_ENABLE_ACCESSIBILITY_UNTIL_KEYGUARD_REMOVED = "temporaryEnableAccessibilityStateUntilKeyguardRemoved";
    private static final String GET_WINDOW_TOKEN = "getWindowToken";
    private static final String SET_PIP_ACTION_REPLACEMENT = "setPictureInPictureActionReplacingConnection";
    private static final String FUNCTION_DUMP = "dump";
    private static final char COMPONENT_NAME_SEPARATOR = ':';
    private static final int OWN_PROCESS_ID = Process.myPid();
    public static final int MAGNIFICATION_GESTURE_HANDLER_ID = 0;
    private static int sIdCounter = 1;
    private static int sNextWindowId;
    private final Context mContext;
    private final Object mLock = new Object();
    private final TextUtils.SimpleStringSplitter mStringColonSplitter = new TextUtils.SimpleStringSplitter(':');
    private final Rect mTempRect = new Rect();
    private final Rect mTempRect1 = new Rect();
    private final Point mTempPoint = new Point();
    private final PackageManager mPackageManager;
    private final PowerManager mPowerManager;
    private final WindowManagerInternal mWindowManagerService;
    private AppWidgetManagerInternal mAppWidgetService;
    private final SecurityPolicy mSecurityPolicy;
    private final AppOpsManager mAppOpsManager;
    private final MainHandler mMainHandler;
    private final GlobalActionPerformer mGlobalActionPerformer;
    private MagnificationController mMagnificationController;
    private InteractionBridge mInteractionBridge;
    private AlertDialog mEnableTouchExplorationDialog;
    private AccessibilityInputFilter mInputFilter;
    private boolean mHasInputFilter;
    private KeyEventDispatcher mKeyEventDispatcher;
    private MotionEventInjector mMotionEventInjector;
    private FingerprintGestureDispatcher mFingerprintGestureDispatcher;
    private final Set<ComponentName> mTempComponentNameSet = new HashSet<ComponentName>();
    private final List<AccessibilityServiceInfo> mTempAccessibilityServiceInfoList = new ArrayList<AccessibilityServiceInfo>();
    private final IntArray mTempIntArray = new IntArray(0);
    private final RemoteCallbackList<IAccessibilityManagerClient> mGlobalClients = new RemoteCallbackList();
    private final SparseArray<RemoteAccessibilityConnection> mGlobalInteractionConnections = new SparseArray();
    private RemoteAccessibilityConnection mPictureInPictureActionReplacingConnection;
    private final SparseArray<IBinder> mGlobalWindowTokens = new SparseArray();
    private final SparseArray<UserState> mUserStates = new SparseArray();
    private final UserManager mUserManager;
    private final UiAutomationManager mUiAutomationManager = new UiAutomationManager();
    private int mCurrentUserId = 0;
    private boolean mInitialized;
    private WindowsForAccessibilityCallback mWindowsForAccessibilityCallback;
    private boolean mIsAccessibilityButtonShown;

    private UserState getCurrentUserStateLocked() {
        return this.getUserStateLocked(this.mCurrentUserId);
    }

    public AccessibilityManagerService(Context context) {
        this.mContext = context;
        this.mPackageManager = this.mContext.getPackageManager();
        this.mPowerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mWindowManagerService = LocalServices.getService(WindowManagerInternal.class);
        this.mUserManager = (UserManager)context.getSystemService("user");
        this.mSecurityPolicy = new SecurityPolicy();
        this.mAppOpsManager = (AppOpsManager)context.getSystemService("appops");
        this.mMainHandler = new MainHandler(this.mContext.getMainLooper());
        this.mGlobalActionPerformer = new GlobalActionPerformer(this.mContext, this.mWindowManagerService);
        this.registerBroadcastReceivers();
        new AccessibilityContentObserver(this.mMainHandler).register(context.getContentResolver());
    }

    @Override
    public int getCurrentUserIdLocked() {
        return this.mCurrentUserId;
    }

    @Override
    public boolean isAccessibilityButtonShown() {
        return this.mIsAccessibilityButtonShown;
    }

    @Override
    public FingerprintGestureDispatcher getFingerprintGestureDispatcher() {
        return this.mFingerprintGestureDispatcher;
    }

    private UserState getUserStateLocked(int userId) {
        UserState state = this.mUserStates.get(userId);
        if (state == null) {
            state = new UserState(userId);
            this.mUserStates.put(userId, state);
        }
        return state;
    }

    boolean getBindInstantServiceAllowed(int userId) {
        return this.mSecurityPolicy.getBindInstantServiceAllowed(userId);
    }

    void setBindInstantServiceAllowed(int userId, boolean allowed) {
        this.mSecurityPolicy.setBindInstantServiceAllowed(userId, allowed);
    }

    private void registerBroadcastReceivers() {
        PackageMonitor monitor = new PackageMonitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSomePackagesChanged() {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    if (this.getChangingUserId() != AccessibilityManagerService.this.mCurrentUserId) {
                        return;
                    }
                    UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                    userState.mInstalledServices.clear();
                    if (AccessibilityManagerService.this.readConfigurationForUserStateLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageUpdateFinished(String packageName, int uid) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    int userId = this.getChangingUserId();
                    if (userId != AccessibilityManagerService.this.mCurrentUserId) {
                        return;
                    }
                    UserState userState = AccessibilityManagerService.this.getUserStateLocked(userId);
                    boolean unboundAService = false;
                    for (int i = userState.mBoundServices.size() - 1; i >= 0; --i) {
                        AccessibilityServiceConnection boundService = userState.mBoundServices.get(i);
                        String servicePkg = boundService.mComponentName.getPackageName();
                        if (!servicePkg.equals(packageName)) continue;
                        boundService.unbindLocked();
                        unboundAService = true;
                    }
                    if (unboundAService) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageRemoved(String packageName, int uid) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    int userId = this.getChangingUserId();
                    if (userId != AccessibilityManagerService.this.mCurrentUserId) {
                        return;
                    }
                    UserState userState = AccessibilityManagerService.this.getUserStateLocked(userId);
                    Iterator<ComponentName> it = userState.mEnabledServices.iterator();
                    while (it.hasNext()) {
                        ComponentName comp = it.next();
                        String compPkg = comp.getPackageName();
                        if (!compPkg.equals(packageName)) continue;
                        it.remove();
                        AccessibilityManagerService.this.persistComponentNamesToSettingLocked("enabled_accessibility_services", userState.mEnabledServices, userId);
                        userState.mTouchExplorationGrantedServices.remove(comp);
                        AccessibilityManagerService.this.persistComponentNamesToSettingLocked("touch_exploration_granted_accessibility_services", userState.mTouchExplorationGrantedServices, userId);
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                        return;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    int userId = this.getChangingUserId();
                    if (userId != AccessibilityManagerService.this.mCurrentUserId) {
                        return false;
                    }
                    UserState userState = AccessibilityManagerService.this.getUserStateLocked(userId);
                    Iterator<ComponentName> it = userState.mEnabledServices.iterator();
                    while (it.hasNext()) {
                        ComponentName comp = it.next();
                        String compPkg = comp.getPackageName();
                        for (String pkg : packages) {
                            if (!compPkg.equals(pkg)) continue;
                            if (!doit) {
                                return true;
                            }
                            it.remove();
                            AccessibilityManagerService.this.persistComponentNamesToSettingLocked("enabled_accessibility_services", userState.mEnabledServices, userId);
                            AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                        }
                    }
                    return false;
                }
            }
        };
        monitor.register(this.mContext, null, UserHandle.ALL, true);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_SWITCHED");
        intentFilter.addAction("android.intent.action.USER_UNLOCKED");
        intentFilter.addAction("android.intent.action.USER_REMOVED");
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.os.action.SETTING_RESTORED");
        this.mContext.registerReceiverAsUser(new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.intent.action.USER_SWITCHED".equals(action)) {
                    AccessibilityManagerService.this.switchUser(intent.getIntExtra("android.intent.extra.user_handle", 0));
                } else if ("android.intent.action.USER_UNLOCKED".equals(action)) {
                    AccessibilityManagerService.this.unlockUser(intent.getIntExtra("android.intent.extra.user_handle", 0));
                } else if ("android.intent.action.USER_REMOVED".equals(action)) {
                    AccessibilityManagerService.this.removeUser(intent.getIntExtra("android.intent.extra.user_handle", 0));
                } else {
                    String which;
                    if ("android.intent.action.USER_PRESENT".equals(action)) {
                        Object object = AccessibilityManagerService.this.mLock;
                        synchronized (object) {
                            UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                            if (AccessibilityManagerService.this.readConfigurationForUserStateLocked(userState)) {
                                AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                            }
                        }
                    }
                    if ("android.os.action.SETTING_RESTORED".equals(action) && "enabled_accessibility_services".equals(which = intent.getStringExtra("setting_name"))) {
                        Object object = AccessibilityManagerService.this.mLock;
                        synchronized (object) {
                            AccessibilityManagerService.this.restoreEnabledAccessibilityServicesLocked(intent.getStringExtra("previous_value"), intent.getStringExtra("new_value"));
                        }
                    }
                }
            }
        }, UserHandle.ALL, intentFilter, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addClient(IAccessibilityManagerClient callback, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            UserState userState = this.getUserStateLocked(resolvedUserId);
            Client client = new Client(callback, Binder.getCallingUid(), userState);
            if (this.mSecurityPolicy.isCallerInteractingAcrossUsers(userId)) {
                this.mGlobalClients.register(callback, client);
                return IntPair.of(userState.getClientState(), client.mLastSentRelevantEventTypes);
            }
            userState.mUserClients.register(callback, client);
            return IntPair.of(resolvedUserId == this.mCurrentUserId ? userState.getClientState() : 0, client.mLastSentRelevantEventTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendAccessibilityEvent(AccessibilityEvent event, int userId) {
        boolean dispatchEvent = false;
        Object object = this.mLock;
        synchronized (object) {
            AccessibilityWindowInfo pip;
            if (event.getWindowId() == -3 && (pip = this.mSecurityPolicy.getPictureInPictureWindow()) != null) {
                int pipId = pip.getId();
                event.setWindowId(pipId);
            }
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            event.setPackageName(this.mSecurityPolicy.resolveValidReportedPackageLocked(event.getPackageName(), UserHandle.getCallingAppId(), resolvedUserId));
            if (resolvedUserId == this.mCurrentUserId) {
                if (this.mSecurityPolicy.canDispatchAccessibilityEventLocked(event)) {
                    this.mSecurityPolicy.updateActiveAndAccessibilityFocusedWindowLocked(event.getWindowId(), event.getSourceNodeId(), event.getEventType(), event.getAction());
                    this.mSecurityPolicy.updateEventSourceLocked(event);
                    dispatchEvent = true;
                }
                if (this.mHasInputFilter && this.mInputFilter != null) {
                    this.mMainHandler.obtainMessage(1, AccessibilityEvent.obtain(event)).sendToTarget();
                }
            }
        }
        if (dispatchEvent) {
            if (event.getEventType() == 32 && this.mWindowsForAccessibilityCallback != null) {
                WindowManagerInternal wm = LocalServices.getService(WindowManagerInternal.class);
                wm.computeWindowsForAccessibility();
            }
            object = this.mLock;
            synchronized (object) {
                this.notifyAccessibilityServicesDelayedLocked(event, false);
                this.notifyAccessibilityServicesDelayedLocked(event, true);
                this.mUiAutomationManager.sendAccessibilityEventLocked(event);
            }
        }
        if (OWN_PROCESS_ID != Binder.getCallingPid()) {
            event.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            return this.getUserStateLocked((int)resolvedUserId).mInstalledServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackType, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            UserState userState = this.getUserStateLocked(resolvedUserId);
            if (this.mUiAutomationManager.suppressingAccessibilityServicesLocked()) {
                return Collections.emptyList();
            }
            CopyOnWriteArrayList<AccessibilityServiceConnection> services = userState.mBoundServices;
            int serviceCount = services.size();
            ArrayList<AccessibilityServiceInfo> result = new ArrayList<AccessibilityServiceInfo>(serviceCount);
            for (int i = 0; i < serviceCount; ++i) {
                AccessibilityServiceConnection service = (AccessibilityServiceConnection)services.get(i);
                if ((service.mFeedbackType & feedbackType) == 0) continue;
                result.add(service.mAccessibilityServiceInfo);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt(int userId) {
        ArrayList<IAccessibilityServiceClient> interfacesToInterrupt;
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            if (resolvedUserId != this.mCurrentUserId) {
                return;
            }
            CopyOnWriteArrayList<AccessibilityServiceConnection> services = this.getUserStateLocked((int)resolvedUserId).mBoundServices;
            int numServices = services.size();
            interfacesToInterrupt = new ArrayList<IAccessibilityServiceClient>(numServices);
            for (int i = 0; i < numServices; ++i) {
                AccessibilityServiceConnection service = (AccessibilityServiceConnection)services.get(i);
                IBinder a11yServiceBinder = service.mService;
                IAccessibilityServiceClient a11yServiceInterface = service.mServiceInterface;
                if (a11yServiceBinder == null || a11yServiceInterface == null) continue;
                interfacesToInterrupt.add(a11yServiceInterface);
            }
        }
        int count = interfacesToInterrupt.size();
        for (int i = 0; i < count; ++i) {
            try {
                ((IAccessibilityServiceClient)interfacesToInterrupt.get(i)).onInterrupt();
                continue;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error sending interrupt request to " + interfacesToInterrupt.get(i), re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addAccessibilityInteractionConnection(IWindow windowToken, IAccessibilityInteractionConnection connection, String packageName, int userId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            int resolvedUid = UserHandle.getUid(resolvedUserId, UserHandle.getCallingAppId());
            packageName = this.mSecurityPolicy.resolveValidReportedPackageLocked(packageName, UserHandle.getCallingAppId(), resolvedUserId);
            int windowId = sNextWindowId++;
            if (this.mSecurityPolicy.isCallerInteractingAcrossUsers(userId)) {
                RemoteAccessibilityConnection wrapper = new RemoteAccessibilityConnection(windowId, connection, packageName, resolvedUid, -1);
                wrapper.linkToDeath();
                this.mGlobalInteractionConnections.put(windowId, wrapper);
                this.mGlobalWindowTokens.put(windowId, windowToken.asBinder());
            } else {
                RemoteAccessibilityConnection wrapper = new RemoteAccessibilityConnection(windowId, connection, packageName, resolvedUid, resolvedUserId);
                wrapper.linkToDeath();
                UserState userState = this.getUserStateLocked(resolvedUserId);
                userState.mInteractionConnections.put(windowId, wrapper);
                userState.mWindowTokens.put(windowId, windowToken.asBinder());
            }
            return windowId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAccessibilityInteractionConnection(IWindow window) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(UserHandle.getCallingUserId());
            IBinder token = window.asBinder();
            int removedWindowId = this.removeAccessibilityInteractionConnectionInternalLocked(token, this.mGlobalWindowTokens, this.mGlobalInteractionConnections);
            if (removedWindowId >= 0) {
                return;
            }
            int userCount = this.mUserStates.size();
            for (int i = 0; i < userCount; ++i) {
                UserState userState = this.mUserStates.valueAt(i);
                int removedWindowIdForUser = this.removeAccessibilityInteractionConnectionInternalLocked(token, userState.mWindowTokens, userState.mInteractionConnections);
                if (removedWindowIdForUser < 0) continue;
                return;
            }
        }
    }

    private int removeAccessibilityInteractionConnectionInternalLocked(IBinder windowToken, SparseArray<IBinder> windowTokens, SparseArray<RemoteAccessibilityConnection> interactionConnections) {
        int count = windowTokens.size();
        for (int i = 0; i < count; ++i) {
            if (windowTokens.valueAt(i) != windowToken) continue;
            int windowId = windowTokens.keyAt(i);
            windowTokens.removeAt(i);
            RemoteAccessibilityConnection wrapper = interactionConnections.get(windowId);
            wrapper.unlinkToDeath();
            interactionConnections.remove(windowId);
            return windowId;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPictureInPictureActionReplacingConnection(IAccessibilityInteractionConnection connection) throws RemoteException {
        this.mSecurityPolicy.enforceCallingPermission("android.permission.MODIFY_ACCESSIBILITY_DATA", SET_PIP_ACTION_REPLACEMENT);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPictureInPictureActionReplacingConnection != null) {
                this.mPictureInPictureActionReplacingConnection.unlinkToDeath();
                this.mPictureInPictureActionReplacingConnection = null;
            }
            if (connection != null) {
                RemoteAccessibilityConnection wrapper;
                this.mPictureInPictureActionReplacingConnection = wrapper = new RemoteAccessibilityConnection(-3, connection, "foo.bar.baz", 1000, -1);
                wrapper.linkToDeath();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerUiTestAutomationService(IBinder owner, IAccessibilityServiceClient serviceClient, AccessibilityServiceInfo accessibilityServiceInfo, int flags) {
        this.mSecurityPolicy.enforceCallingPermission("android.permission.RETRIEVE_WINDOW_CONTENT", FUNCTION_REGISTER_UI_TEST_AUTOMATION_SERVICE);
        Object object = this.mLock;
        synchronized (object) {
            this.mUiAutomationManager.registerUiTestAutomationServiceLocked(owner, serviceClient, this.mContext, accessibilityServiceInfo, sIdCounter++, this.mMainHandler, this.mLock, this.mSecurityPolicy, this, this.mWindowManagerService, this.mGlobalActionPerformer, flags);
            this.onUserStateChangedLocked(this.getCurrentUserStateLocked());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterUiTestAutomationService(IAccessibilityServiceClient serviceClient) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUiAutomationManager.unregisterUiTestAutomationServiceLocked(serviceClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void temporaryEnableAccessibilityStateUntilKeyguardRemoved(ComponentName service, boolean touchExplorationEnabled) {
        this.mSecurityPolicy.enforceCallingPermission("android.permission.TEMPORARY_ENABLE_ACCESSIBILITY", TEMPORARY_ENABLE_ACCESSIBILITY_UNTIL_KEYGUARD_REMOVED);
        if (!this.mWindowManagerService.isKeyguardLocked()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getCurrentUserStateLocked();
            userState.mIsTouchExplorationEnabled = touchExplorationEnabled;
            userState.mIsDisplayMagnificationEnabled = false;
            userState.mIsNavBarMagnificationEnabled = false;
            userState.mIsAutoclickEnabled = false;
            userState.mEnabledServices.clear();
            userState.mEnabledServices.add(service);
            userState.mBindingServices.clear();
            userState.mTouchExplorationGrantedServices.clear();
            userState.mTouchExplorationGrantedServices.add(service);
            this.onUserStateChangedLocked(userState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder getWindowToken(int windowId, int userId) {
        this.mSecurityPolicy.enforceCallingPermission("android.permission.RETRIEVE_WINDOW_TOKEN", GET_WINDOW_TOKEN);
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            if (resolvedUserId != this.mCurrentUserId) {
                return null;
            }
            if (this.mSecurityPolicy.findA11yWindowInfoById(windowId) == null) {
                return null;
            }
            IBinder token = this.mGlobalWindowTokens.get(windowId);
            if (token != null) {
                return token;
            }
            return this.getCurrentUserStateLocked().mWindowTokens.get(windowId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAccessibilityButtonClicked() {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE") != 0) {
            throw new SecurityException("Caller does not hold permission android.permission.STATUS_BAR_SERVICE");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.notifyAccessibilityButtonClickedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAccessibilityButtonVisibilityChanged(boolean shown) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE") != 0) {
            throw new SecurityException("Caller does not hold permission android.permission.STATUS_BAR_SERVICE");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.notifyAccessibilityButtonVisibilityChangedLocked(shown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onGesture(int gestureId) {
        Object object = this.mLock;
        synchronized (object) {
            boolean handled = this.notifyGestureLocked(gestureId, false);
            if (!handled) {
                handled = this.notifyGestureLocked(gestureId, true);
            }
            return handled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean notifyKeyEvent(KeyEvent event, int policyFlags) {
        Object object = this.mLock;
        synchronized (object) {
            CopyOnWriteArrayList<AccessibilityServiceConnection> boundServices = this.getCurrentUserStateLocked().mBoundServices;
            if (boundServices.isEmpty()) {
                return false;
            }
            return this.getKeyEventDispatcher().notifyKeyEventLocked(event, policyFlags, boundServices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMagnificationChanged(Region region, float scale, float centerX, float centerY) {
        Object object = this.mLock;
        synchronized (object) {
            this.notifyClearAccessibilityCacheLocked();
            this.notifyMagnificationChangedLocked(region, scale, centerX, centerY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMotionEventInjector(MotionEventInjector motionEventInjector) {
        Object object = this.mLock;
        synchronized (object) {
            this.mMotionEventInjector = motionEventInjector;
            this.mLock.notifyAll();
        }
    }

    @Override
    public MotionEventInjector getMotionEventInjectorLocked() {
        long endMillis = SystemClock.uptimeMillis() + 1000L;
        while (this.mMotionEventInjector == null && SystemClock.uptimeMillis() < endMillis) {
            try {
                this.mLock.wait(endMillis - SystemClock.uptimeMillis());
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.mMotionEventInjector == null) {
            Slog.e(LOG_TAG, "MotionEventInjector installation timed out");
        }
        return this.mMotionEventInjector;
    }

    boolean getAccessibilityFocusClickPointInScreen(Point outPoint) {
        return this.getInteractionBridge().getAccessibilityFocusClickPointInScreenNotLocked(outPoint);
    }

    public boolean performActionOnAccessibilityFocusedItem(AccessibilityNodeInfo.AccessibilityAction action) {
        return this.getInteractionBridge().performActionOnAccessibilityFocusedItemNotLocked(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getWindowBounds(int windowId, Rect outBounds) {
        IBinder token;
        Object object = this.mLock;
        synchronized (object) {
            token = this.mGlobalWindowTokens.get(windowId);
            if (token == null) {
                token = this.getCurrentUserStateLocked().mWindowTokens.get(windowId);
            }
        }
        this.mWindowManagerService.getWindowFrame(token, outBounds);
        return !outBounds.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean accessibilityFocusOnlyInActiveWindow() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mWindowsForAccessibilityCallback == null;
        }
    }

    int getActiveWindowId() {
        return this.mSecurityPolicy.getActiveWindowId();
    }

    void onTouchInteractionStart() {
        this.mSecurityPolicy.onTouchInteractionStart();
    }

    void onTouchInteractionEnd() {
        this.mSecurityPolicy.onTouchInteractionEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            UserManager userManager;
            if (this.mCurrentUserId == userId && this.mInitialized) {
                return;
            }
            UserState oldUserState = this.getCurrentUserStateLocked();
            oldUserState.onSwitchToAnotherUser();
            if (oldUserState.mUserClients.getRegisteredCallbackCount() > 0) {
                this.mMainHandler.obtainMessage(3, oldUserState.mUserId, 0).sendToTarget();
            }
            boolean announceNewUser = (userManager = (UserManager)this.mContext.getSystemService("user")).getUsers().size() > 1;
            this.mCurrentUserId = userId;
            UserState userState = this.getCurrentUserStateLocked();
            this.readConfigurationForUserStateLocked(userState);
            this.onUserStateChangedLocked(userState);
            if (announceNewUser) {
                this.mMainHandler.sendEmptyMessageDelayed(5, 3000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int parentUserId = this.mSecurityPolicy.resolveProfileParentLocked(userId);
            if (parentUserId == this.mCurrentUserId) {
                UserState userState = this.getUserStateLocked(this.mCurrentUserId);
                this.onUserStateChangedLocked(userState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUserStates.remove(userId);
        }
    }

    void restoreEnabledAccessibilityServicesLocked(String oldSetting, String newSetting) {
        this.readComponentNamesFromStringLocked(oldSetting, this.mTempComponentNameSet, false);
        this.readComponentNamesFromStringLocked(newSetting, this.mTempComponentNameSet, true);
        UserState userState = this.getUserStateLocked(0);
        userState.mEnabledServices.clear();
        userState.mEnabledServices.addAll(this.mTempComponentNameSet);
        this.persistComponentNamesToSettingLocked("enabled_accessibility_services", userState.mEnabledServices, 0);
        this.onUserStateChangedLocked(userState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InteractionBridge getInteractionBridge() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInteractionBridge == null) {
                this.mInteractionBridge = new InteractionBridge();
            }
            return this.mInteractionBridge;
        }
    }

    private boolean notifyGestureLocked(int gestureId, boolean isDefault) {
        UserState state = this.getCurrentUserStateLocked();
        for (int i = state.mBoundServices.size() - 1; i >= 0; --i) {
            AccessibilityServiceConnection service = state.mBoundServices.get(i);
            if (!service.mRequestTouchExplorationMode || service.mIsDefault != isDefault) continue;
            service.notifyGesture(gestureId);
            return true;
        }
        return false;
    }

    private void notifyClearAccessibilityCacheLocked() {
        UserState state = this.getCurrentUserStateLocked();
        for (int i = state.mBoundServices.size() - 1; i >= 0; --i) {
            AccessibilityServiceConnection service = state.mBoundServices.get(i);
            service.notifyClearAccessibilityNodeInfoCache();
        }
    }

    private void notifyMagnificationChangedLocked(Region region, float scale, float centerX, float centerY) {
        UserState state = this.getCurrentUserStateLocked();
        for (int i = state.mBoundServices.size() - 1; i >= 0; --i) {
            AccessibilityServiceConnection service = state.mBoundServices.get(i);
            service.notifyMagnificationChangedLocked(region, scale, centerX, centerY);
        }
    }

    private void notifySoftKeyboardShowModeChangedLocked(int showMode) {
        UserState state = this.getCurrentUserStateLocked();
        for (int i = state.mBoundServices.size() - 1; i >= 0; --i) {
            AccessibilityServiceConnection service = state.mBoundServices.get(i);
            service.notifySoftKeyboardShowModeChangedLocked(showMode);
        }
    }

    private void notifyAccessibilityButtonClickedLocked() {
        AccessibilityServiceConnection service;
        int i;
        UserState state = this.getCurrentUserStateLocked();
        int potentialTargets = state.mIsNavBarMagnificationEnabled ? 1 : 0;
        for (i = state.mBoundServices.size() - 1; i >= 0; --i) {
            service = state.mBoundServices.get(i);
            if (!service.mRequestAccessibilityButton) continue;
            ++potentialTargets;
        }
        if (potentialTargets == 0) {
            return;
        }
        if (potentialTargets == 1) {
            if (state.mIsNavBarMagnificationEnabled) {
                this.mMainHandler.obtainMessage(13).sendToTarget();
                return;
            }
            for (i = state.mBoundServices.size() - 1; i >= 0; --i) {
                service = state.mBoundServices.get(i);
                if (!service.mRequestAccessibilityButton) continue;
                service.notifyAccessibilityButtonClickedLocked();
                return;
            }
        } else {
            if (state.mServiceAssignedToAccessibilityButton == null && !state.mIsNavBarMagnificationAssignedToAccessibilityButton) {
                this.mMainHandler.obtainMessage(14).sendToTarget();
            } else {
                if (state.mIsNavBarMagnificationEnabled && state.mIsNavBarMagnificationAssignedToAccessibilityButton) {
                    this.mMainHandler.obtainMessage(13).sendToTarget();
                    return;
                }
                for (i = state.mBoundServices.size() - 1; i >= 0; --i) {
                    service = state.mBoundServices.get(i);
                    if (!service.mRequestAccessibilityButton || !service.mComponentName.equals(state.mServiceAssignedToAccessibilityButton)) continue;
                    service.notifyAccessibilityButtonClickedLocked();
                    return;
                }
            }
            this.mMainHandler.obtainMessage(14).sendToTarget();
        }
    }

    private void notifyAccessibilityButtonVisibilityChangedLocked(boolean available) {
        UserState state = this.getCurrentUserStateLocked();
        this.mIsAccessibilityButtonShown = available;
        for (int i = state.mBoundServices.size() - 1; i >= 0; --i) {
            AccessibilityServiceConnection clientConnection = state.mBoundServices.get(i);
            if (!clientConnection.mRequestAccessibilityButton) continue;
            clientConnection.notifyAccessibilityButtonAvailabilityChangedLocked(clientConnection.isAccessibilityButtonAvailableLocked(state));
        }
    }

    private void removeAccessibilityInteractionConnectionLocked(int windowId, int userId) {
        if (userId == -1) {
            this.mGlobalWindowTokens.remove(windowId);
            this.mGlobalInteractionConnections.remove(windowId);
        } else {
            UserState userState = this.getCurrentUserStateLocked();
            userState.mWindowTokens.remove(windowId);
            userState.mInteractionConnections.remove(windowId);
        }
    }

    private boolean readInstalledAccessibilityServiceLocked(UserState userState) {
        this.mTempAccessibilityServiceInfoList.clear();
        int flags = 819332;
        if (userState.mBindInstantServiceAllowed) {
            flags |= 0x800000;
        }
        List<ResolveInfo> installedServices = this.mPackageManager.queryIntentServicesAsUser(new Intent("android.accessibilityservice.AccessibilityService"), flags, this.mCurrentUserId);
        int count = installedServices.size();
        for (int i = 0; i < count; ++i) {
            ResolveInfo resolveInfo = installedServices.get(i);
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (!this.canRegisterService(serviceInfo)) continue;
            try {
                AccessibilityServiceInfo accessibilityServiceInfo = new AccessibilityServiceInfo(resolveInfo, this.mContext);
                this.mTempAccessibilityServiceInfoList.add(accessibilityServiceInfo);
                continue;
            }
            catch (IOException | XmlPullParserException xppe) {
                Slog.e(LOG_TAG, "Error while initializing AccessibilityServiceInfo", xppe);
            }
        }
        if (!this.mTempAccessibilityServiceInfoList.equals(userState.mInstalledServices)) {
            userState.mInstalledServices.clear();
            userState.mInstalledServices.addAll(this.mTempAccessibilityServiceInfoList);
            this.mTempAccessibilityServiceInfoList.clear();
            return true;
        }
        this.mTempAccessibilityServiceInfoList.clear();
        return false;
    }

    private boolean canRegisterService(ServiceInfo serviceInfo) {
        if (!"android.permission.BIND_ACCESSIBILITY_SERVICE".equals(serviceInfo.permission)) {
            Slog.w(LOG_TAG, "Skipping accessibility service " + new ComponentName(serviceInfo.packageName, serviceInfo.name).flattenToShortString() + ": it does not require the permission " + "android.permission.BIND_ACCESSIBILITY_SERVICE");
            return false;
        }
        int servicePackageUid = serviceInfo.applicationInfo.uid;
        if (this.mAppOpsManager.noteOpNoThrow("bind_accessibility_service", servicePackageUid, serviceInfo.packageName) != 0) {
            Slog.w(LOG_TAG, "Skipping accessibility service " + new ComponentName(serviceInfo.packageName, serviceInfo.name).flattenToShortString() + ": disallowed by AppOps");
            return false;
        }
        return true;
    }

    private boolean readEnabledAccessibilityServicesLocked(UserState userState) {
        this.mTempComponentNameSet.clear();
        this.readComponentNamesFromSettingLocked("enabled_accessibility_services", userState.mUserId, this.mTempComponentNameSet);
        if (!this.mTempComponentNameSet.equals(userState.mEnabledServices)) {
            userState.mEnabledServices.clear();
            userState.mEnabledServices.addAll(this.mTempComponentNameSet);
            this.mTempComponentNameSet.clear();
            return true;
        }
        this.mTempComponentNameSet.clear();
        return false;
    }

    private boolean readTouchExplorationGrantedAccessibilityServicesLocked(UserState userState) {
        this.mTempComponentNameSet.clear();
        this.readComponentNamesFromSettingLocked("touch_exploration_granted_accessibility_services", userState.mUserId, this.mTempComponentNameSet);
        if (!this.mTempComponentNameSet.equals(userState.mTouchExplorationGrantedServices)) {
            userState.mTouchExplorationGrantedServices.clear();
            userState.mTouchExplorationGrantedServices.addAll(this.mTempComponentNameSet);
            this.mTempComponentNameSet.clear();
            return true;
        }
        this.mTempComponentNameSet.clear();
        return false;
    }

    private void notifyAccessibilityServicesDelayedLocked(AccessibilityEvent event, boolean isDefault) {
        try {
            UserState state = this.getCurrentUserStateLocked();
            int count = state.mBoundServices.size();
            for (int i = 0; i < count; ++i) {
                AccessibilityServiceConnection service = state.mBoundServices.get(i);
                if (service.mIsDefault != isDefault) continue;
                service.notifyAccessibilityEvent(event);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void updateRelevantEventsLocked(UserState userState) {
        this.mMainHandler.post(() -> this.broadcastToClients(userState, FunctionalUtils.ignoreRemoteException(client -> {
            int relevantEventTypes = this.computeRelevantEventTypes(userState, (Client)client);
            if (client.mLastSentRelevantEventTypes != relevantEventTypes) {
                client.mLastSentRelevantEventTypes = relevantEventTypes;
                client.mCallback.setRelevantEventTypes(relevantEventTypes);
            }
        })));
    }

    private int computeRelevantEventTypes(UserState userState, Client client) {
        int relevantEventTypes = 0;
        for (AccessibilityServiceConnection service : userState.mBoundServices) {
            relevantEventTypes |= AccessibilityManagerService.isClientInPackageWhitelist(service.getServiceInfo(), client) ? service.getRelevantEventTypes() : 0;
        }
        return relevantEventTypes |= AccessibilityManagerService.isClientInPackageWhitelist(this.mUiAutomationManager.getServiceInfo(), client) ? this.mUiAutomationManager.getRelevantEventTypes() : 0;
    }

    private static boolean isClientInPackageWhitelist(AccessibilityServiceInfo serviceInfo, Client client) {
        if (serviceInfo == null) {
            return false;
        }
        String[] clientPackages = client.mPackageNames;
        boolean result = ArrayUtils.isEmpty(serviceInfo.packageNames);
        if (!result && clientPackages != null) {
            for (String packageName : clientPackages) {
                if (!ArrayUtils.contains(serviceInfo.packageNames, packageName)) continue;
                result = true;
                break;
            }
        }
        if (!result) {
            // empty if block
        }
        return result;
    }

    private void broadcastToClients(UserState userState, Consumer<Client> clientAction) {
        this.mGlobalClients.broadcastForEachCookie(clientAction);
        userState.mUserClients.broadcastForEachCookie(clientAction);
    }

    private void unbindAllServicesLocked(UserState userState) {
        CopyOnWriteArrayList<AccessibilityServiceConnection> services = userState.mBoundServices;
        for (int count = services.size(); count > 0; --count) {
            ((AccessibilityServiceConnection)services.get(0)).unbindLocked();
        }
    }

    private void readComponentNamesFromSettingLocked(String settingName, int userId, Set<ComponentName> outComponentNames) {
        String settingValue = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), settingName, userId);
        this.readComponentNamesFromStringLocked(settingValue, outComponentNames, false);
    }

    private void readComponentNamesFromStringLocked(String names, Set<ComponentName> outComponentNames, boolean doMerge) {
        if (!doMerge) {
            outComponentNames.clear();
        }
        if (names != null) {
            TextUtils.SimpleStringSplitter splitter = this.mStringColonSplitter;
            splitter.setString(names);
            while (splitter.hasNext()) {
                ComponentName enabledService;
                String str = splitter.next();
                if (str == null || str.length() <= 0 || (enabledService = ComponentName.unflattenFromString(str)) == null) continue;
                outComponentNames.add(enabledService);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistComponentNamesToSettingLocked(String settingName, Set<ComponentName> componentNames, int userId) {
        StringBuilder builder = new StringBuilder();
        for (ComponentName componentName : componentNames) {
            if (builder.length() > 0) {
                builder.append(':');
            }
            builder.append(componentName.flattenToShortString());
        }
        long identity = Binder.clearCallingIdentity();
        try {
            Settings.Secure.putStringForUser(this.mContext.getContentResolver(), settingName, builder.toString(), userId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void updateServicesLocked(UserState userState) {
        Map<ComponentName, AccessibilityServiceConnection> componentNameToServiceMap = userState.mComponentNameToServiceMap;
        boolean isUnlockingOrUnlocked = LocalServices.getService(UserManagerInternal.class).isUserUnlockingOrUnlocked(userState.mUserId);
        int count = userState.mInstalledServices.size();
        for (int i = 0; i < count; ++i) {
            AccessibilityServiceInfo installedService = userState.mInstalledServices.get(i);
            ComponentName componentName = ComponentName.unflattenFromString(installedService.getId());
            AccessibilityServiceConnection service = componentNameToServiceMap.get(componentName);
            if (!isUnlockingOrUnlocked && !installedService.isDirectBootAware()) {
                Slog.d(LOG_TAG, "Ignoring non-encryption-aware service " + componentName);
                continue;
            }
            if (userState.mBindingServices.contains(componentName)) continue;
            if (userState.mEnabledServices.contains(componentName) && !this.mUiAutomationManager.suppressingAccessibilityServicesLocked()) {
                if (service == null) {
                    service = new AccessibilityServiceConnection(userState, this.mContext, componentName, installedService, sIdCounter++, this.mMainHandler, this.mLock, this.mSecurityPolicy, this, this.mWindowManagerService, this.mGlobalActionPerformer);
                } else if (userState.mBoundServices.contains(service)) continue;
                service.bindLocked();
                continue;
            }
            if (service == null) continue;
            service.unbindLocked();
        }
        int count2 = userState.mBoundServices.size();
        this.mTempIntArray.clear();
        for (int i = 0; i < count2; ++i) {
            ResolveInfo resolveInfo = userState.mBoundServices.get((int)i).mAccessibilityServiceInfo.getResolveInfo();
            if (resolveInfo == null) continue;
            this.mTempIntArray.add(resolveInfo.serviceInfo.applicationInfo.uid);
        }
        AudioManagerInternal audioManager = LocalServices.getService(AudioManagerInternal.class);
        if (audioManager != null) {
            audioManager.setAccessibilityServiceUids(this.mTempIntArray);
        }
        this.updateAccessibilityEnabledSetting(userState);
    }

    private void scheduleUpdateClientsIfNeededLocked(UserState userState) {
        int clientState = userState.getClientState();
        if (userState.mLastSentClientState != clientState && (this.mGlobalClients.getRegisteredCallbackCount() > 0 || userState.mUserClients.getRegisteredCallbackCount() > 0)) {
            userState.mLastSentClientState = clientState;
            this.mMainHandler.obtainMessage(2, clientState, userState.mUserId).sendToTarget();
        }
    }

    private void showAccessibilityButtonTargetSelection() {
        Intent intent = new Intent("com.android.internal.intent.action.CHOOSE_ACCESSIBILITY_BUTTON");
        intent.addFlags(0x10008000);
        this.mContext.startActivityAsUser(intent, UserHandle.of(this.mCurrentUserId));
    }

    private void scheduleNotifyClientsOfServicesStateChange(UserState userState) {
        this.mMainHandler.obtainMessage(10, userState.mUserId).sendToTarget();
    }

    private void scheduleUpdateInputFilter(UserState userState) {
        this.mMainHandler.obtainMessage(6, userState).sendToTarget();
    }

    private void scheduleUpdateFingerprintGestureHandling(UserState userState) {
        this.mMainHandler.obtainMessage(11, userState).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInputFilter(UserState userState) {
        if (this.mUiAutomationManager.suppressingAccessibilityServicesLocked()) {
            return;
        }
        boolean setInputFilter = false;
        AccessibilityInputFilter inputFilter = null;
        Object object = this.mLock;
        synchronized (object) {
            int flags = 0;
            if (userState.mIsDisplayMagnificationEnabled) {
                flags |= 1;
            }
            if (userState.mIsNavBarMagnificationEnabled) {
                flags |= 0x40;
            }
            if (this.userHasMagnificationServicesLocked(userState)) {
                flags |= 0x20;
            }
            if (userState.isHandlingAccessibilityEvents() && userState.mIsTouchExplorationEnabled) {
                flags |= 2;
            }
            if (userState.mIsFilterKeyEventsEnabled) {
                flags |= 4;
            }
            if (userState.mIsAutoclickEnabled) {
                flags |= 8;
            }
            if (userState.mIsPerformGesturesEnabled) {
                flags |= 0x10;
            }
            if (flags != 0) {
                if (!this.mHasInputFilter) {
                    this.mHasInputFilter = true;
                    if (this.mInputFilter == null) {
                        this.mInputFilter = new AccessibilityInputFilter(this.mContext, this);
                    }
                    inputFilter = this.mInputFilter;
                    setInputFilter = true;
                }
                this.mInputFilter.setUserAndEnabledFeatures(userState.mUserId, flags);
            } else if (this.mHasInputFilter) {
                this.mHasInputFilter = false;
                this.mInputFilter.setUserAndEnabledFeatures(userState.mUserId, 0);
                inputFilter = null;
                setInputFilter = true;
            }
        }
        if (setInputFilter) {
            this.mWindowManagerService.setInputFilter(inputFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showEnableTouchExplorationDialog(final AccessibilityServiceConnection service) {
        Object object = this.mLock;
        synchronized (object) {
            String label = service.getServiceInfo().getResolveInfo().loadLabel(this.mContext.getPackageManager()).toString();
            final UserState userState = this.getCurrentUserStateLocked();
            if (userState.mIsTouchExplorationEnabled) {
                return;
            }
            if (this.mEnableTouchExplorationDialog != null && this.mEnableTouchExplorationDialog.isShowing()) {
                return;
            }
            this.mEnableTouchExplorationDialog = new AlertDialog.Builder(this.mContext).setIconAttribute(16843605).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    userState.mTouchExplorationGrantedServices.add(service.mComponentName);
                    AccessibilityManagerService.this.persistComponentNamesToSettingLocked("touch_exploration_granted_accessibility_services", userState.mTouchExplorationGrantedServices, userState.mUserId);
                    userState.mIsTouchExplorationEnabled = true;
                    long identity = Binder.clearCallingIdentity();
                    try {
                        Settings.Secure.putIntForUser(AccessibilityManagerService.this.mContext.getContentResolver(), "touch_exploration_enabled", 1, userState.mUserId);
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                    AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }).setTitle(17039821).setMessage(this.mContext.getString(17039820, label)).create();
            this.mEnableTouchExplorationDialog.getWindow().setType(2003);
            this.mEnableTouchExplorationDialog.getWindow().getAttributes().privateFlags |= 0x10;
            this.mEnableTouchExplorationDialog.setCanceledOnTouchOutside(true);
            this.mEnableTouchExplorationDialog.show();
        }
    }

    private void onUserStateChangedLocked(UserState userState) {
        this.mInitialized = true;
        this.updateLegacyCapabilitiesLocked(userState);
        this.updateServicesLocked(userState);
        this.updateAccessibilityShortcutLocked(userState);
        this.updateWindowsForAccessibilityCallbackLocked(userState);
        this.updateAccessibilityFocusBehaviorLocked(userState);
        this.updateFilterKeyEventsLocked(userState);
        this.updateTouchExplorationLocked(userState);
        this.updatePerformGesturesLocked(userState);
        this.updateDisplayDaltonizerLocked(userState);
        this.updateDisplayInversionLocked(userState);
        this.updateMagnificationLocked(userState);
        this.updateSoftKeyboardShowModeLocked(userState);
        this.scheduleUpdateFingerprintGestureHandling(userState);
        this.scheduleUpdateInputFilter(userState);
        this.scheduleUpdateClientsIfNeededLocked(userState);
        this.updateRelevantEventsLocked(userState);
        this.updateAccessibilityButtonTargetsLocked(userState);
    }

    private void updateAccessibilityFocusBehaviorLocked(UserState userState) {
        CopyOnWriteArrayList<AccessibilityServiceConnection> boundServices = userState.mBoundServices;
        int boundServiceCount = boundServices.size();
        for (int i = 0; i < boundServiceCount; ++i) {
            AccessibilityServiceConnection boundService = (AccessibilityServiceConnection)boundServices.get(i);
            if (!boundService.canRetrieveInteractiveWindowsLocked()) continue;
            userState.mAccessibilityFocusOnlyInActiveWindow = false;
            return;
        }
        userState.mAccessibilityFocusOnlyInActiveWindow = true;
    }

    private void updateWindowsForAccessibilityCallbackLocked(UserState userState) {
        boolean observingWindows = this.mUiAutomationManager.canRetrieveInteractiveWindowsLocked();
        CopyOnWriteArrayList<AccessibilityServiceConnection> boundServices = userState.mBoundServices;
        int boundServiceCount = boundServices.size();
        for (int i = 0; !observingWindows && i < boundServiceCount; ++i) {
            AccessibilityServiceConnection boundService = (AccessibilityServiceConnection)boundServices.get(i);
            if (!boundService.canRetrieveInteractiveWindowsLocked()) continue;
            observingWindows = true;
        }
        if (observingWindows) {
            if (this.mWindowsForAccessibilityCallback == null) {
                this.mWindowsForAccessibilityCallback = new WindowsForAccessibilityCallback();
                this.mWindowManagerService.setWindowsForAccessibilityCallback(this.mWindowsForAccessibilityCallback);
            }
            return;
        }
        if (this.mWindowsForAccessibilityCallback != null) {
            this.mWindowsForAccessibilityCallback = null;
            this.mWindowManagerService.setWindowsForAccessibilityCallback(null);
            this.mSecurityPolicy.clearWindowsLocked();
        }
    }

    private void updateLegacyCapabilitiesLocked(UserState userState) {
        int installedServiceCount = userState.mInstalledServices.size();
        for (int i = 0; i < installedServiceCount; ++i) {
            ComponentName componentName;
            AccessibilityServiceInfo serviceInfo = userState.mInstalledServices.get(i);
            ResolveInfo resolveInfo = serviceInfo.getResolveInfo();
            if ((serviceInfo.getCapabilities() & 2) != 0 || resolveInfo.serviceInfo.applicationInfo.targetSdkVersion > 17 || !userState.mTouchExplorationGrantedServices.contains(componentName = new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name))) continue;
            serviceInfo.setCapabilities(serviceInfo.getCapabilities() | 2);
        }
    }

    private void updatePerformGesturesLocked(UserState userState) {
        int serviceCount = userState.mBoundServices.size();
        for (int i = 0; i < serviceCount; ++i) {
            AccessibilityServiceConnection service = userState.mBoundServices.get(i);
            if ((service.mAccessibilityServiceInfo.getCapabilities() & 0x20) == 0) continue;
            userState.mIsPerformGesturesEnabled = true;
            return;
        }
        userState.mIsPerformGesturesEnabled = false;
    }

    private void updateFilterKeyEventsLocked(UserState userState) {
        int serviceCount = userState.mBoundServices.size();
        for (int i = 0; i < serviceCount; ++i) {
            AccessibilityServiceConnection service = userState.mBoundServices.get(i);
            if (!service.mRequestFilterKeyEvents || (service.mAccessibilityServiceInfo.getCapabilities() & 8) == 0) continue;
            userState.mIsFilterKeyEventsEnabled = true;
            return;
        }
        userState.mIsFilterKeyEventsEnabled = false;
    }

    private boolean readConfigurationForUserStateLocked(UserState userState) {
        boolean somethingChanged = this.readInstalledAccessibilityServiceLocked(userState);
        somethingChanged |= this.readEnabledAccessibilityServicesLocked(userState);
        somethingChanged |= this.readTouchExplorationGrantedAccessibilityServicesLocked(userState);
        somethingChanged |= this.readTouchExplorationEnabledSettingLocked(userState);
        somethingChanged |= this.readHighTextContrastEnabledSettingLocked(userState);
        somethingChanged |= this.readMagnificationEnabledSettingsLocked(userState);
        somethingChanged |= this.readAutoclickEnabledSettingLocked(userState);
        somethingChanged |= this.readAccessibilityShortcutSettingLocked(userState);
        return somethingChanged |= this.readAccessibilityButtonSettingsLocked(userState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAccessibilityEnabledSetting(UserState userState) {
        long identity = Binder.clearCallingIdentity();
        boolean isA11yEnabled = this.mUiAutomationManager.isUiAutomationRunningLocked() || userState.isHandlingAccessibilityEvents();
        try {
            Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "accessibility_enabled", isA11yEnabled ? 1 : 0, userState.mUserId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private boolean readTouchExplorationEnabledSettingLocked(UserState userState) {
        boolean touchExplorationEnabled;
        boolean bl = touchExplorationEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "touch_exploration_enabled", 0, userState.mUserId) == 1;
        if (touchExplorationEnabled != userState.mIsTouchExplorationEnabled) {
            userState.mIsTouchExplorationEnabled = touchExplorationEnabled;
            return true;
        }
        return false;
    }

    private boolean readMagnificationEnabledSettingsLocked(UserState userState) {
        boolean navBarMagnificationEnabled;
        boolean displayMagnificationEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_display_magnification_enabled", 0, userState.mUserId) == 1;
        boolean bl = navBarMagnificationEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_display_magnification_navbar_enabled", 0, userState.mUserId) == 1;
        if (displayMagnificationEnabled != userState.mIsDisplayMagnificationEnabled || navBarMagnificationEnabled != userState.mIsNavBarMagnificationEnabled) {
            userState.mIsDisplayMagnificationEnabled = displayMagnificationEnabled;
            userState.mIsNavBarMagnificationEnabled = navBarMagnificationEnabled;
            return true;
        }
        return false;
    }

    private boolean readAutoclickEnabledSettingLocked(UserState userState) {
        boolean autoclickEnabled;
        boolean bl = autoclickEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_autoclick_enabled", 0, userState.mUserId) == 1;
        if (autoclickEnabled != userState.mIsAutoclickEnabled) {
            userState.mIsAutoclickEnabled = autoclickEnabled;
            return true;
        }
        return false;
    }

    private boolean readHighTextContrastEnabledSettingLocked(UserState userState) {
        boolean highTextContrastEnabled;
        boolean bl = highTextContrastEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "high_text_contrast_enabled", 0, userState.mUserId) == 1;
        if (highTextContrastEnabled != userState.mIsTextHighContrastEnabled) {
            userState.mIsTextHighContrastEnabled = highTextContrastEnabled;
            return true;
        }
        return false;
    }

    private boolean readSoftKeyboardShowModeChangedLocked(UserState userState) {
        int softKeyboardShowMode = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_soft_keyboard_mode", 0, userState.mUserId);
        if (softKeyboardShowMode != userState.mSoftKeyboardShowMode) {
            userState.mSoftKeyboardShowMode = softKeyboardShowMode;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTouchExplorationLocked(UserState userState) {
        boolean enabled = this.mUiAutomationManager.isTouchExplorationEnabledLocked();
        int serviceCount = userState.mBoundServices.size();
        for (int i = 0; i < serviceCount; ++i) {
            AccessibilityServiceConnection service = userState.mBoundServices.get(i);
            if (!this.canRequestAndRequestsTouchExplorationLocked(service, userState)) continue;
            enabled = true;
            break;
        }
        if (enabled != userState.mIsTouchExplorationEnabled) {
            userState.mIsTouchExplorationEnabled = enabled;
            long identity = Binder.clearCallingIdentity();
            try {
                Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "touch_exploration_enabled", enabled ? 1 : 0, userState.mUserId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private boolean readAccessibilityShortcutSettingLocked(UserState userState) {
        String componentNameToEnableString = AccessibilityShortcutController.getTargetServiceComponentNameString(this.mContext, userState.mUserId);
        if (componentNameToEnableString == null || componentNameToEnableString.isEmpty()) {
            if (userState.mServiceToEnableWithShortcut == null) {
                return false;
            }
            userState.mServiceToEnableWithShortcut = null;
            return true;
        }
        ComponentName componentNameToEnable = ComponentName.unflattenFromString(componentNameToEnableString);
        if (componentNameToEnable != null && componentNameToEnable.equals(userState.mServiceToEnableWithShortcut)) {
            return false;
        }
        userState.mServiceToEnableWithShortcut = componentNameToEnable;
        return true;
    }

    private boolean readAccessibilityButtonSettingsLocked(UserState userState) {
        String componentId = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "accessibility_button_target_component", userState.mUserId);
        if (TextUtils.isEmpty(componentId)) {
            if (userState.mServiceAssignedToAccessibilityButton == null && !userState.mIsNavBarMagnificationAssignedToAccessibilityButton) {
                return false;
            }
            userState.mServiceAssignedToAccessibilityButton = null;
            userState.mIsNavBarMagnificationAssignedToAccessibilityButton = false;
            return true;
        }
        if (componentId.equals(MagnificationController.class.getName())) {
            if (userState.mIsNavBarMagnificationAssignedToAccessibilityButton) {
                return false;
            }
            userState.mServiceAssignedToAccessibilityButton = null;
            userState.mIsNavBarMagnificationAssignedToAccessibilityButton = true;
            return true;
        }
        ComponentName componentName = ComponentName.unflattenFromString(componentId);
        if (componentName.equals(userState.mServiceAssignedToAccessibilityButton)) {
            return false;
        }
        userState.mServiceAssignedToAccessibilityButton = componentName;
        userState.mIsNavBarMagnificationAssignedToAccessibilityButton = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAccessibilityShortcutLocked(UserState userState) {
        if (userState.mServiceToEnableWithShortcut == null) {
            return;
        }
        boolean shortcutServiceIsInstalled = AccessibilityShortcutController.getFrameworkShortcutFeaturesMap().containsKey(userState.mServiceToEnableWithShortcut);
        for (int i = 0; !shortcutServiceIsInstalled && i < userState.mInstalledServices.size(); ++i) {
            if (!userState.mInstalledServices.get(i).getComponentName().equals(userState.mServiceToEnableWithShortcut)) continue;
            shortcutServiceIsInstalled = true;
        }
        if (!shortcutServiceIsInstalled) {
            userState.mServiceToEnableWithShortcut = null;
            long identity = Binder.clearCallingIdentity();
            try {
                Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "accessibility_shortcut_target_service", null, userState.mUserId);
                Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "accessibility_shortcut_enabled", 0, userState.mUserId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private boolean canRequestAndRequestsTouchExplorationLocked(AccessibilityServiceConnection service, UserState userState) {
        if (!service.canReceiveEventsLocked() || !service.mRequestTouchExplorationMode) {
            return false;
        }
        if (service.getServiceInfo().getResolveInfo().serviceInfo.applicationInfo.targetSdkVersion <= 17) {
            if (userState.mTouchExplorationGrantedServices.contains(service.mComponentName)) {
                return true;
            }
            if (this.mEnableTouchExplorationDialog == null || !this.mEnableTouchExplorationDialog.isShowing()) {
                this.mMainHandler.obtainMessage(7, service).sendToTarget();
            }
        } else if ((service.mAccessibilityServiceInfo.getCapabilities() & 2) != 0) {
            return true;
        }
        return false;
    }

    private void updateDisplayDaltonizerLocked(UserState userState) {
        DisplayAdjustmentUtils.applyDaltonizerSetting(this.mContext, userState.mUserId);
    }

    private void updateDisplayInversionLocked(UserState userState) {
        DisplayAdjustmentUtils.applyInversionSetting(this.mContext, userState.mUserId);
    }

    private void updateMagnificationLocked(UserState userState) {
        if (userState.mUserId != this.mCurrentUserId) {
            return;
        }
        if (!this.mUiAutomationManager.suppressingAccessibilityServicesLocked() && (userState.mIsDisplayMagnificationEnabled || userState.mIsNavBarMagnificationEnabled || this.userHasListeningMagnificationServicesLocked(userState))) {
            this.getMagnificationController();
            this.mMagnificationController.register();
        } else if (this.mMagnificationController != null) {
            this.mMagnificationController.unregister();
        }
    }

    private boolean userHasMagnificationServicesLocked(UserState userState) {
        CopyOnWriteArrayList<AccessibilityServiceConnection> services = userState.mBoundServices;
        int count = services.size();
        for (int i = 0; i < count; ++i) {
            AccessibilityServiceConnection service = (AccessibilityServiceConnection)services.get(i);
            if (!this.mSecurityPolicy.canControlMagnification(service)) continue;
            return true;
        }
        return false;
    }

    private boolean userHasListeningMagnificationServicesLocked(UserState userState) {
        CopyOnWriteArrayList<AccessibilityServiceConnection> services = userState.mBoundServices;
        int count = services.size();
        for (int i = 0; i < count; ++i) {
            AccessibilityServiceConnection service = (AccessibilityServiceConnection)services.get(i);
            if (!this.mSecurityPolicy.canControlMagnification(service) || !service.isMagnificationCallbackEnabled()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSoftKeyboardShowModeLocked(UserState userState) {
        boolean serviceChangingSoftKeyboardModeIsEnabled;
        int userId = userState.mUserId;
        if (userId == this.mCurrentUserId && userState.mSoftKeyboardShowMode != 0 && !(serviceChangingSoftKeyboardModeIsEnabled = userState.mEnabledServices.contains(userState.mServiceChangingSoftKeyboardMode))) {
            long identity = Binder.clearCallingIdentity();
            try {
                Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "accessibility_soft_keyboard_mode", 0, userState.mUserId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            userState.mSoftKeyboardShowMode = 0;
            userState.mServiceChangingSoftKeyboardMode = null;
            this.notifySoftKeyboardShowModeChangedLocked(userState.mSoftKeyboardShowMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFingerprintGestureHandling(UserState userState) {
        CopyOnWriteArrayList<AccessibilityServiceConnection> services;
        Object object = this.mLock;
        synchronized (object) {
            services = userState.mBoundServices;
            if (this.mFingerprintGestureDispatcher == null && this.mPackageManager.hasSystemFeature("android.hardware.fingerprint")) {
                int numServices = services.size();
                for (int i = 0; i < numServices; ++i) {
                    if (!((AccessibilityServiceConnection)services.get(i)).isCapturingFingerprintGestures()) continue;
                    long identity = Binder.clearCallingIdentity();
                    IFingerprintService service = null;
                    try {
                        service = IFingerprintService.Stub.asInterface(ServiceManager.getService("fingerprint"));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                    if (service == null) continue;
                    this.mFingerprintGestureDispatcher = new FingerprintGestureDispatcher(service, this.mLock);
                    break;
                }
            }
        }
        if (this.mFingerprintGestureDispatcher != null) {
            this.mFingerprintGestureDispatcher.updateClientList(services);
        }
    }

    private void updateAccessibilityButtonTargetsLocked(UserState userState) {
        for (int i = userState.mBoundServices.size() - 1; i >= 0; --i) {
            AccessibilityServiceConnection service = userState.mBoundServices.get(i);
            if (!service.mRequestAccessibilityButton) continue;
            service.notifyAccessibilityButtonAvailabilityChangedLocked(service.isAccessibilityButtonAvailableLocked(userState));
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public MagnificationSpec getCompatibleMagnificationSpecLocked(int windowId) {
        IBinder windowToken = this.mGlobalWindowTokens.get(windowId);
        if (windowToken == null) {
            windowToken = this.getCurrentUserStateLocked().mWindowTokens.get(windowId);
        }
        if (windowToken != null) {
            return this.mWindowManagerService.getCompatibleMagnificationSpecForWindow(windowToken);
        }
        return null;
    }

    @Override
    public KeyEventDispatcher getKeyEventDispatcher() {
        if (this.mKeyEventDispatcher == null) {
            this.mKeyEventDispatcher = new KeyEventDispatcher(this.mMainHandler, 8, this.mLock, this.mPowerManager);
        }
        return this.mKeyEventDispatcher;
    }

    @Override
    public PendingIntent getPendingIntentActivity(Context context, int requestCode, Intent intent, int flags) {
        return PendingIntent.getActivity(context, requestCode, intent, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performAccessibilityShortcut() {
        if (UserHandle.getAppId(Binder.getCallingUid()) != 1000 && this.mContext.checkCallingPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("performAccessibilityShortcut requires the WRITE_SECURE_SETTINGS permission");
        }
        Map<ComponentName, AccessibilityShortcutController.ToggleableFrameworkFeatureInfo> frameworkFeatureMap = AccessibilityShortcutController.getFrameworkShortcutFeaturesMap();
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getUserStateLocked(this.mCurrentUserId);
            ComponentName serviceName = userState.mServiceToEnableWithShortcut;
            if (serviceName == null) {
                return;
            }
            if (frameworkFeatureMap.containsKey(serviceName)) {
                AccessibilityShortcutController.ToggleableFrameworkFeatureInfo featureInfo = frameworkFeatureMap.get(serviceName);
                SettingsStringUtil.SettingStringHelper setting = new SettingsStringUtil.SettingStringHelper(this.mContext.getContentResolver(), featureInfo.getSettingKey(), this.mCurrentUserId);
                if (!TextUtils.equals(featureInfo.getSettingOnValue(), setting.read())) {
                    setting.write(featureInfo.getSettingOnValue());
                } else {
                    setting.write(featureInfo.getSettingOffValue());
                }
            }
            long identity = Binder.clearCallingIdentity();
            try {
                if (userState.mComponentNameToServiceMap.get(serviceName) == null) {
                    this.enableAccessibilityServiceLocked(serviceName, this.mCurrentUserId);
                } else {
                    this.disableAccessibilityServiceLocked(serviceName, this.mCurrentUserId);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private void enableAccessibilityServiceLocked(ComponentName componentName, int userId) {
        SettingsStringUtil.SettingStringHelper setting = new SettingsStringUtil.SettingStringHelper(this.mContext.getContentResolver(), "enabled_accessibility_services", userId);
        setting.write(SettingsStringUtil.ComponentNameSet.add(setting.read(), componentName));
        UserState userState = this.getUserStateLocked(userId);
        if (userState.mEnabledServices.add(componentName)) {
            this.onUserStateChangedLocked(userState);
        }
    }

    private void disableAccessibilityServiceLocked(ComponentName componentName, int userId) {
        SettingsStringUtil.SettingStringHelper setting = new SettingsStringUtil.SettingStringHelper(this.mContext.getContentResolver(), "enabled_accessibility_services", userId);
        setting.write(SettingsStringUtil.ComponentNameSet.remove(setting.read(), componentName));
        UserState userState = this.getUserStateLocked(userId);
        if (userState.mEnabledServices.remove(componentName)) {
            this.onUserStateChangedLocked(userState);
        }
    }

    private void sendAccessibilityEventLocked(AccessibilityEvent event, int userId) {
        event.setEventTime(SystemClock.uptimeMillis());
        this.mMainHandler.obtainMessage(16, userId, 0, event).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendFingerprintGesture(int gestureKeyCode) {
        Object object = this.mLock;
        synchronized (object) {
            if (UserHandle.getAppId(Binder.getCallingUid()) != 1000) {
                throw new SecurityException("Only SYSTEM can call sendFingerprintGesture");
            }
        }
        if (this.mFingerprintGestureDispatcher == null) {
            return false;
        }
        return this.mFingerprintGestureDispatcher.onFingerprintGesture(gestureKeyCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, LOG_TAG, pw)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            pw.println("ACCESSIBILITY MANAGER (dumpsys accessibility)");
            pw.println();
            int userCount = this.mUserStates.size();
            for (int i = 0; i < userCount; ++i) {
                UserState userState = this.mUserStates.valueAt(i);
                pw.append("User state[attributes:{id=" + userState.mUserId);
                pw.append(", currentUser=" + (userState.mUserId == this.mCurrentUserId));
                pw.append(", touchExplorationEnabled=" + userState.mIsTouchExplorationEnabled);
                pw.append(", displayMagnificationEnabled=" + userState.mIsDisplayMagnificationEnabled);
                pw.append(", navBarMagnificationEnabled=" + userState.mIsNavBarMagnificationEnabled);
                pw.append(", autoclickEnabled=" + userState.mIsAutoclickEnabled);
                if (this.mUiAutomationManager.isUiAutomationRunningLocked()) {
                    pw.append(", ");
                    this.mUiAutomationManager.dumpUiAutomationService(fd, pw, args);
                    pw.println();
                }
                pw.append("}");
                pw.println();
                pw.append("           services:{");
                int serviceCount = userState.mBoundServices.size();
                for (int j = 0; j < serviceCount; ++j) {
                    if (j > 0) {
                        pw.append(", ");
                        pw.println();
                        pw.append("                     ");
                    }
                    AccessibilityServiceConnection service = userState.mBoundServices.get(j);
                    service.dump(fd, pw, args);
                }
                pw.println("}]");
                pw.println();
            }
            if (this.mSecurityPolicy.mWindows != null) {
                int windowCount = this.mSecurityPolicy.mWindows.size();
                for (int j = 0; j < windowCount; ++j) {
                    if (j > 0) {
                        pw.append(',');
                        pw.println();
                    }
                    pw.append("Window[");
                    AccessibilityWindowInfo window = this.mSecurityPolicy.mWindows.get(j);
                    pw.append(window.toString());
                    pw.append(']');
                }
            }
        }
    }

    private int findWindowIdLocked(IBinder token) {
        int globalIndex = this.mGlobalWindowTokens.indexOfValue(token);
        if (globalIndex >= 0) {
            return this.mGlobalWindowTokens.keyAt(globalIndex);
        }
        UserState userState = this.getCurrentUserStateLocked();
        int userIndex = userState.mWindowTokens.indexOfValue(token);
        if (userIndex >= 0) {
            return userState.mWindowTokens.keyAt(userIndex);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureWindowsAvailableTimed() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSecurityPolicy.mWindows != null) {
                return;
            }
            if (this.mWindowsForAccessibilityCallback == null) {
                UserState userState = this.getCurrentUserStateLocked();
                this.onUserStateChangedLocked(userState);
            }
            if (this.mWindowsForAccessibilityCallback == null) {
                return;
            }
            long startMillis = SystemClock.uptimeMillis();
            while (this.mSecurityPolicy.mWindows == null) {
                long elapsedMillis = SystemClock.uptimeMillis() - startMillis;
                long remainMillis = 5000L - elapsedMillis;
                if (remainMillis <= 0L) {
                    return;
                }
                try {
                    this.mLock.wait(remainMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MagnificationController getMagnificationController() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mMagnificationController == null) {
                this.mMagnificationController = new MagnificationController(this.mContext, this, this.mLock);
                this.mMagnificationController.setUserId(this.mCurrentUserId);
            }
            return this.mMagnificationController;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performAccessibilityAction(int resolvedWindowId, long accessibilityNodeId, int action, Bundle arguments, int interactionId, IAccessibilityInteractionConnectionCallback callback, int fetchFlags, long interrogatingTid) {
        RemoteAccessibilityConnection connection;
        IBinder activityToken = null;
        Object object = this.mLock;
        synchronized (object) {
            WindowInfo windowInfo;
            connection = this.getConnectionLocked(resolvedWindowId);
            if (connection == null) {
                return false;
            }
            boolean isA11yFocusAction = action == 64 || action == 128;
            AccessibilityWindowInfo a11yWindowInfo = this.mSecurityPolicy.findA11yWindowInfoById(resolvedWindowId);
            if (!isA11yFocusAction && (windowInfo = this.mSecurityPolicy.findWindowInfoById(resolvedWindowId)) != null) {
                activityToken = windowInfo.activityToken;
            }
            if (a11yWindowInfo != null && a11yWindowInfo.isInPictureInPictureMode() && this.mPictureInPictureActionReplacingConnection != null && !isA11yFocusAction) {
                connection = this.mPictureInPictureActionReplacingConnection;
            }
        }
        int interrogatingPid = Binder.getCallingPid();
        long identityToken = Binder.clearCallingIdentity();
        try {
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), 3, 0);
            if (activityToken != null) {
                LocalServices.getService(ActivityManagerInternal.class).setFocusedActivity(activityToken);
            }
            connection.mConnection.performAccessibilityAction(accessibilityNodeId, action, arguments, interactionId, callback, fetchFlags, interrogatingPid, interrogatingTid);
        }
        catch (RemoteException re) {
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
        }
        return true;
    }

    @Override
    public RemoteAccessibilityConnection getConnectionLocked(int windowId) {
        RemoteAccessibilityConnection connection = this.mGlobalInteractionConnections.get(windowId);
        if (connection == null) {
            connection = this.getCurrentUserStateLocked().mInteractionConnections.get(windowId);
        }
        if (connection != null && connection.mConnection != null) {
            return connection;
        }
        return null;
    }

    @Override
    public IAccessibilityInteractionConnectionCallback replaceCallbackIfNeeded(IAccessibilityInteractionConnectionCallback originalCallback, int resolvedWindowId, int interactionId, int interrogatingPid, long interrogatingTid) {
        AccessibilityWindowInfo windowInfo = this.mSecurityPolicy.findA11yWindowInfoById(resolvedWindowId);
        if (windowInfo == null || !windowInfo.isInPictureInPictureMode() || this.mPictureInPictureActionReplacingConnection == null) {
            return originalCallback;
        }
        return new ActionReplacingCallback(originalCallback, this.mPictureInPictureActionReplacingConnection.mConnection, interactionId, interrogatingPid, interrogatingTid);
    }

    @Override
    public void onClientChange(boolean serviceInfoChanged) {
        UserState userState = this.getUserStateLocked(this.mCurrentUserId);
        this.onUserStateChangedLocked(userState);
        if (serviceInfoChanged) {
            this.scheduleNotifyClientsOfServicesStateChange(userState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppWidgetManagerInternal getAppWidgetManager() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAppWidgetService == null && this.mPackageManager.hasSystemFeature("android.software.app_widgets")) {
                this.mAppWidgetService = LocalServices.getService(AppWidgetManagerInternal.class);
            }
            return this.mAppWidgetService;
        }
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        new AccessibilityShellCommand(this).exec(this, in, out, err, args, callback, resultReceiver);
    }

    private final class AccessibilityContentObserver
    extends ContentObserver {
        private final Uri mTouchExplorationEnabledUri;
        private final Uri mDisplayMagnificationEnabledUri;
        private final Uri mNavBarMagnificationEnabledUri;
        private final Uri mAutoclickEnabledUri;
        private final Uri mEnabledAccessibilityServicesUri;
        private final Uri mTouchExplorationGrantedAccessibilityServicesUri;
        private final Uri mDisplayInversionEnabledUri;
        private final Uri mDisplayDaltonizerEnabledUri;
        private final Uri mDisplayDaltonizerUri;
        private final Uri mHighTextContrastUri;
        private final Uri mAccessibilitySoftKeyboardModeUri;
        private final Uri mAccessibilityShortcutServiceIdUri;
        private final Uri mAccessibilityButtonComponentIdUri;

        public AccessibilityContentObserver(Handler handler) {
            super(handler);
            this.mTouchExplorationEnabledUri = Settings.Secure.getUriFor("touch_exploration_enabled");
            this.mDisplayMagnificationEnabledUri = Settings.Secure.getUriFor("accessibility_display_magnification_enabled");
            this.mNavBarMagnificationEnabledUri = Settings.Secure.getUriFor("accessibility_display_magnification_navbar_enabled");
            this.mAutoclickEnabledUri = Settings.Secure.getUriFor("accessibility_autoclick_enabled");
            this.mEnabledAccessibilityServicesUri = Settings.Secure.getUriFor("enabled_accessibility_services");
            this.mTouchExplorationGrantedAccessibilityServicesUri = Settings.Secure.getUriFor("touch_exploration_granted_accessibility_services");
            this.mDisplayInversionEnabledUri = Settings.Secure.getUriFor("accessibility_display_inversion_enabled");
            this.mDisplayDaltonizerEnabledUri = Settings.Secure.getUriFor("accessibility_display_daltonizer_enabled");
            this.mDisplayDaltonizerUri = Settings.Secure.getUriFor("accessibility_display_daltonizer");
            this.mHighTextContrastUri = Settings.Secure.getUriFor("high_text_contrast_enabled");
            this.mAccessibilitySoftKeyboardModeUri = Settings.Secure.getUriFor("accessibility_soft_keyboard_mode");
            this.mAccessibilityShortcutServiceIdUri = Settings.Secure.getUriFor("accessibility_shortcut_target_service");
            this.mAccessibilityButtonComponentIdUri = Settings.Secure.getUriFor("accessibility_button_target_component");
        }

        public void register(ContentResolver contentResolver) {
            contentResolver.registerContentObserver(this.mTouchExplorationEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mDisplayMagnificationEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mNavBarMagnificationEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mAutoclickEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mEnabledAccessibilityServicesUri, false, this, -1);
            contentResolver.registerContentObserver(this.mTouchExplorationGrantedAccessibilityServicesUri, false, this, -1);
            contentResolver.registerContentObserver(this.mDisplayInversionEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mDisplayDaltonizerEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mDisplayDaltonizerUri, false, this, -1);
            contentResolver.registerContentObserver(this.mHighTextContrastUri, false, this, -1);
            contentResolver.registerContentObserver(this.mAccessibilitySoftKeyboardModeUri, false, this, -1);
            contentResolver.registerContentObserver(this.mAccessibilityShortcutServiceIdUri, false, this, -1);
            contentResolver.registerContentObserver(this.mAccessibilityButtonComponentIdUri, false, this, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                if (this.mTouchExplorationEnabledUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readTouchExplorationEnabledSettingLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mDisplayMagnificationEnabledUri.equals(uri) || this.mNavBarMagnificationEnabledUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readMagnificationEnabledSettingsLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mAutoclickEnabledUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readAutoclickEnabledSettingLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mEnabledAccessibilityServicesUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readEnabledAccessibilityServicesLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mTouchExplorationGrantedAccessibilityServicesUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readTouchExplorationGrantedAccessibilityServicesLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mDisplayDaltonizerEnabledUri.equals(uri) || this.mDisplayDaltonizerUri.equals(uri)) {
                    AccessibilityManagerService.this.updateDisplayDaltonizerLocked(userState);
                } else if (this.mDisplayInversionEnabledUri.equals(uri)) {
                    AccessibilityManagerService.this.updateDisplayInversionLocked(userState);
                } else if (this.mHighTextContrastUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readHighTextContrastEnabledSettingLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mAccessibilitySoftKeyboardModeUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readSoftKeyboardShowModeChangedLocked(userState)) {
                        AccessibilityManagerService.this.notifySoftKeyboardShowModeChangedLocked(userState.mSoftKeyboardShowMode);
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mAccessibilityShortcutServiceIdUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readAccessibilityShortcutSettingLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mAccessibilityButtonComponentIdUri.equals(uri) && AccessibilityManagerService.this.readAccessibilityButtonSettingsLocked(userState)) {
                    AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                }
            }
        }
    }

    public class UserState {
        public final int mUserId;
        public final RemoteCallbackList<IAccessibilityManagerClient> mUserClients = new RemoteCallbackList();
        public final SparseArray<RemoteAccessibilityConnection> mInteractionConnections = new SparseArray();
        public final SparseArray<IBinder> mWindowTokens = new SparseArray();
        public final CopyOnWriteArrayList<AccessibilityServiceConnection> mBoundServices = new CopyOnWriteArrayList();
        public final Map<ComponentName, AccessibilityServiceConnection> mComponentNameToServiceMap = new HashMap<ComponentName, AccessibilityServiceConnection>();
        public final List<AccessibilityServiceInfo> mInstalledServices = new ArrayList<AccessibilityServiceInfo>();
        private final Set<ComponentName> mBindingServices = new HashSet<ComponentName>();
        public final Set<ComponentName> mEnabledServices = new HashSet<ComponentName>();
        public final Set<ComponentName> mTouchExplorationGrantedServices = new HashSet<ComponentName>();
        public ComponentName mServiceChangingSoftKeyboardMode;
        public ComponentName mServiceToEnableWithShortcut;
        public int mLastSentClientState = -1;
        public int mSoftKeyboardShowMode = 0;
        public boolean mIsNavBarMagnificationAssignedToAccessibilityButton;
        public ComponentName mServiceAssignedToAccessibilityButton;
        public boolean mIsTouchExplorationEnabled;
        public boolean mIsTextHighContrastEnabled;
        public boolean mIsDisplayMagnificationEnabled;
        public boolean mIsNavBarMagnificationEnabled;
        public boolean mIsAutoclickEnabled;
        public boolean mIsPerformGesturesEnabled;
        public boolean mIsFilterKeyEventsEnabled;
        public boolean mAccessibilityFocusOnlyInActiveWindow;
        public boolean mBindInstantServiceAllowed;

        public UserState(int userId) {
            this.mUserId = userId;
        }

        public int getClientState() {
            boolean a11yEnabled;
            int clientState = 0;
            boolean bl = a11yEnabled = AccessibilityManagerService.this.mUiAutomationManager.isUiAutomationRunningLocked() || this.isHandlingAccessibilityEvents();
            if (a11yEnabled) {
                clientState |= 1;
            }
            if (a11yEnabled && this.mIsTouchExplorationEnabled) {
                clientState |= 2;
            }
            if (this.mIsTextHighContrastEnabled) {
                clientState |= 4;
            }
            return clientState;
        }

        public boolean isHandlingAccessibilityEvents() {
            return !this.mBoundServices.isEmpty() || !this.mBindingServices.isEmpty();
        }

        public void onSwitchToAnotherUser() {
            AccessibilityManagerService.this.unbindAllServicesLocked(this);
            this.mBoundServices.clear();
            this.mBindingServices.clear();
            this.mLastSentClientState = -1;
            this.mEnabledServices.clear();
            this.mTouchExplorationGrantedServices.clear();
            this.mIsTouchExplorationEnabled = false;
            this.mIsDisplayMagnificationEnabled = false;
            this.mIsNavBarMagnificationEnabled = false;
            this.mServiceAssignedToAccessibilityButton = null;
            this.mIsNavBarMagnificationAssignedToAccessibilityButton = false;
            this.mIsAutoclickEnabled = false;
            this.mSoftKeyboardShowMode = 0;
        }

        public void addServiceLocked(AccessibilityServiceConnection serviceConnection) {
            if (!this.mBoundServices.contains(serviceConnection)) {
                serviceConnection.onAdded();
                this.mBoundServices.add(serviceConnection);
                this.mComponentNameToServiceMap.put(serviceConnection.mComponentName, serviceConnection);
                AccessibilityManagerService.this.scheduleNotifyClientsOfServicesStateChange(this);
            }
        }

        public void removeServiceLocked(AccessibilityServiceConnection serviceConnection) {
            this.mBoundServices.remove(serviceConnection);
            serviceConnection.onRemoved();
            this.mComponentNameToServiceMap.clear();
            for (int i = 0; i < this.mBoundServices.size(); ++i) {
                AccessibilityServiceConnection boundClient = this.mBoundServices.get(i);
                this.mComponentNameToServiceMap.put(boundClient.mComponentName, boundClient);
            }
            AccessibilityManagerService.this.scheduleNotifyClientsOfServicesStateChange(this);
        }

        public Set<ComponentName> getBindingServicesLocked() {
            return this.mBindingServices;
        }
    }

    class Client {
        final IAccessibilityManagerClient mCallback;
        final String[] mPackageNames;
        int mLastSentRelevantEventTypes;

        private Client(IAccessibilityManagerClient callback, int clientUid, UserState userState) {
            this.mCallback = callback;
            this.mPackageNames = AccessibilityManagerService.this.mPackageManager.getPackagesForUid(clientUid);
            this.mLastSentRelevantEventTypes = AccessibilityManagerService.this.computeRelevantEventTypes(userState, this);
        }
    }

    public class SecurityPolicy {
        public static final int INVALID_WINDOW_ID = -1;
        private static final int KEEP_SOURCE_EVENT_TYPES = 4438463;
        public List<AccessibilityWindowInfo> mWindows;
        public SparseArray<AccessibilityWindowInfo> mA11yWindowInfoById = new SparseArray();
        public SparseArray<WindowInfo> mWindowInfoById = new SparseArray();
        public int mActiveWindowId = -1;
        public int mFocusedWindowId = -1;
        public int mAccessibilityFocusedWindowId = -1;
        public long mAccessibilityFocusNodeId = Integer.MAX_VALUE;
        private boolean mTouchInteractionInProgress;

        private boolean canDispatchAccessibilityEventLocked(AccessibilityEvent event) {
            int eventType = event.getEventType();
            switch (eventType) {
                case 32: 
                case 64: 
                case 128: 
                case 256: 
                case 512: 
                case 1024: 
                case 16384: 
                case 262144: 
                case 524288: 
                case 0x100000: 
                case 0x200000: 
                case 0x400000: 
                case 0x1000000: {
                    return true;
                }
            }
            return this.isRetrievalAllowingWindow(event.getWindowId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isValidPackageForUid(String packageName, int uid) {
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = uid == AccessibilityManagerService.this.mPackageManager.getPackageUidAsUser(packageName, UserHandle.getUserId(uid));
                return bl;
            }
            catch (PackageManager.NameNotFoundException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        String resolveValidReportedPackageLocked(CharSequence packageName, int appId, int userId) {
            int resolvedUid;
            if (packageName == null) {
                return null;
            }
            if (appId == 1000) {
                return packageName.toString();
            }
            String packageNameStr = packageName.toString();
            if (this.isValidPackageForUid(packageNameStr, resolvedUid = UserHandle.getUid(userId, appId))) {
                return packageName.toString();
            }
            AppWidgetManagerInternal appWidgetManager = AccessibilityManagerService.this.getAppWidgetManager();
            if (appWidgetManager != null && ArrayUtils.contains(appWidgetManager.getHostedWidgetPackages(resolvedUid), packageNameStr)) {
                return packageName.toString();
            }
            String[] packageNames = AccessibilityManagerService.this.mPackageManager.getPackagesForUid(resolvedUid);
            if (ArrayUtils.isEmpty(packageNames)) {
                return null;
            }
            return packageNames[0];
        }

        String[] computeValidReportedPackages(int callingUid, String targetPackage, int targetUid) {
            ArraySet<String> widgetPackages;
            if (UserHandle.getAppId(callingUid) == 1000) {
                return EmptyArray.STRING;
            }
            String[] uidPackages = new String[]{targetPackage};
            AppWidgetManagerInternal appWidgetManager = AccessibilityManagerService.this.getAppWidgetManager();
            if (appWidgetManager != null && (widgetPackages = appWidgetManager.getHostedWidgetPackages(targetUid)) != null && !widgetPackages.isEmpty()) {
                String[] validPackages = new String[uidPackages.length + widgetPackages.size()];
                System.arraycopy(uidPackages, 0, validPackages, 0, uidPackages.length);
                int widgetPackageCount = widgetPackages.size();
                for (int i = 0; i < widgetPackageCount; ++i) {
                    validPackages[uidPackages.length + i] = widgetPackages.valueAt(i);
                }
                return validPackages;
            }
            return uidPackages;
        }

        private boolean getBindInstantServiceAllowed(int userId) {
            AccessibilityManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_BIND_INSTANT_SERVICE", "getBindInstantServiceAllowed");
            UserState state = (UserState)AccessibilityManagerService.this.mUserStates.get(userId);
            return state != null && state.mBindInstantServiceAllowed;
        }

        private void setBindInstantServiceAllowed(int userId, boolean allowed) {
            AccessibilityManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_BIND_INSTANT_SERVICE", "setBindInstantServiceAllowed");
            UserState state = (UserState)AccessibilityManagerService.this.mUserStates.get(userId);
            if (state == null) {
                if (!allowed) {
                    return;
                }
                state = new UserState(userId);
                AccessibilityManagerService.this.mUserStates.put(userId, state);
            }
            if (state.mBindInstantServiceAllowed != allowed) {
                state.mBindInstantServiceAllowed = allowed;
                AccessibilityManagerService.this.onUserStateChangedLocked(state);
            }
        }

        public void clearWindowsLocked() {
            List<WindowInfo> windows = Collections.emptyList();
            int activeWindowId = this.mActiveWindowId;
            this.updateWindowsLocked(windows);
            this.mActiveWindowId = activeWindowId;
            this.mWindows = null;
        }

        public void updateWindowsLocked(List<WindowInfo> windows) {
            int i;
            if (this.mWindows == null) {
                this.mWindows = new ArrayList<AccessibilityWindowInfo>();
            }
            ArrayList<AccessibilityWindowInfo> oldWindowList = new ArrayList<AccessibilityWindowInfo>(this.mWindows);
            Object oldWindowsById = this.mA11yWindowInfoById.clone();
            this.mWindows.clear();
            this.mA11yWindowInfoById.clear();
            for (int i2 = 0; i2 < this.mWindowInfoById.size(); ++i2) {
                this.mWindowInfoById.valueAt(i2).recycle();
            }
            this.mWindowInfoById.clear();
            this.mFocusedWindowId = -1;
            if (!this.mTouchInteractionInProgress) {
                this.mActiveWindowId = -1;
            }
            boolean activeWindowGone = true;
            int windowCount = windows.size();
            if (windowCount > 0) {
                AccessibilityWindowInfo window;
                for (int i3 = 0; i3 < windowCount; ++i3) {
                    WindowInfo windowInfo = windows.get(i3);
                    AccessibilityWindowInfo accessibilityWindowInfo = window = AccessibilityManagerService.this.mWindowsForAccessibilityCallback != null ? AccessibilityManagerService.this.mWindowsForAccessibilityCallback.populateReportedWindow(windowInfo) : null;
                    if (window == null) continue;
                    int windowId = window.getId();
                    if (window.isFocused()) {
                        this.mFocusedWindowId = windowId;
                        if (!this.mTouchInteractionInProgress) {
                            this.mActiveWindowId = windowId;
                            window.setActive(true);
                        } else if (windowId == this.mActiveWindowId) {
                            activeWindowGone = false;
                        }
                    }
                    this.mWindows.add(window);
                    this.mA11yWindowInfoById.put(windowId, window);
                    this.mWindowInfoById.put(windowId, WindowInfo.obtain(windowInfo));
                }
                if (this.mTouchInteractionInProgress && activeWindowGone) {
                    this.mActiveWindowId = this.mFocusedWindowId;
                }
                int accessibilityWindowCount = this.mWindows.size();
                for (i = 0; i < accessibilityWindowCount; ++i) {
                    window = this.mWindows.get(i);
                    if (window.getId() == this.mActiveWindowId) {
                        window.setActive(true);
                    }
                    if (window.getId() != this.mAccessibilityFocusedWindowId) continue;
                    window.setAccessibilityFocused(true);
                }
            }
            this.sendEventsForChangedWindowsLocked(oldWindowList, (SparseArray<AccessibilityWindowInfo>)oldWindowsById);
            int oldWindowCount = oldWindowList.size();
            for (i = oldWindowCount - 1; i >= 0; --i) {
                ((AccessibilityWindowInfo)oldWindowList.remove(i)).recycle();
            }
        }

        private void sendEventsForChangedWindowsLocked(List<AccessibilityWindowInfo> oldWindows, SparseArray<AccessibilityWindowInfo> oldWindowsById) {
            ArrayList<AccessibilityEvent> events = new ArrayList<AccessibilityEvent>();
            int oldWindowsCount = oldWindows.size();
            for (int i = 0; i < oldWindowsCount; ++i) {
                AccessibilityWindowInfo window = oldWindows.get(i);
                if (this.mA11yWindowInfoById.get(window.getId()) != null) continue;
                events.add(AccessibilityEvent.obtainWindowsChangedEvent(window.getId(), 2));
            }
            boolean oldWindowIndex = false;
            int newWindowCount = this.mWindows.size();
            for (int i = 0; i < newWindowCount; ++i) {
                AccessibilityWindowInfo newWindow = this.mWindows.get(i);
                AccessibilityWindowInfo oldWindow = oldWindowsById.get(newWindow.getId());
                if (oldWindow == null) {
                    events.add(AccessibilityEvent.obtainWindowsChangedEvent(newWindow.getId(), 1));
                    continue;
                }
                int changes = newWindow.differenceFrom(oldWindow);
                if (changes == 0) continue;
                events.add(AccessibilityEvent.obtainWindowsChangedEvent(newWindow.getId(), changes));
            }
            int numEvents = events.size();
            for (int i = 0; i < numEvents; ++i) {
                AccessibilityManagerService.this.sendAccessibilityEventLocked((AccessibilityEvent)events.get(i), AccessibilityManagerService.this.mCurrentUserId);
            }
        }

        public boolean computePartialInteractiveRegionForWindowLocked(int windowId, Region outRegion) {
            if (this.mWindows == null) {
                return false;
            }
            Region windowInteractiveRegion = null;
            boolean windowInteractiveRegionChanged = false;
            int windowCount = this.mWindows.size();
            for (int i = windowCount - 1; i >= 0; --i) {
                Rect currentWindowBounds;
                AccessibilityWindowInfo currentWindow = this.mWindows.get(i);
                if (windowInteractiveRegion == null) {
                    if (currentWindow.getId() != windowId) continue;
                    currentWindowBounds = AccessibilityManagerService.this.mTempRect;
                    currentWindow.getBoundsInScreen(currentWindowBounds);
                    outRegion.set(currentWindowBounds);
                    windowInteractiveRegion = outRegion;
                    continue;
                }
                if (currentWindow.getType() == 4) continue;
                currentWindowBounds = AccessibilityManagerService.this.mTempRect;
                currentWindow.getBoundsInScreen(currentWindowBounds);
                if (!windowInteractiveRegion.op(currentWindowBounds, Region.Op.DIFFERENCE)) continue;
                windowInteractiveRegionChanged = true;
            }
            return windowInteractiveRegionChanged;
        }

        public void updateEventSourceLocked(AccessibilityEvent event) {
            if ((event.getEventType() & 0x43B9BF) == 0) {
                event.setSource(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateActiveAndAccessibilityFocusedWindowLocked(int windowId, long nodeId, int eventType, int eventAction) {
            switch (eventType) {
                case 32: {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (AccessibilityManagerService.this.mWindowsForAccessibilityCallback == null) {
                            this.mFocusedWindowId = this.getFocusedWindowId();
                            if (windowId == this.mFocusedWindowId) {
                                this.mActiveWindowId = windowId;
                            }
                        }
                        break;
                    }
                }
                case 128: {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (this.mTouchInteractionInProgress && this.mActiveWindowId != windowId) {
                            this.setActiveWindowLocked(windowId);
                        }
                        break;
                    }
                }
                case 32768: {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (this.mAccessibilityFocusedWindowId != windowId) {
                            AccessibilityManagerService.this.mMainHandler.obtainMessage(9, this.mAccessibilityFocusedWindowId, 0).sendToTarget();
                            AccessibilityManagerService.this.mSecurityPolicy.setAccessibilityFocusedWindowLocked(windowId);
                            this.mAccessibilityFocusNodeId = nodeId;
                        }
                        break;
                    }
                }
                case 65536: {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (this.mAccessibilityFocusNodeId == nodeId) {
                            this.mAccessibilityFocusNodeId = Integer.MAX_VALUE;
                        }
                        if (this.mAccessibilityFocusNodeId == Integer.MAX_VALUE && this.mAccessibilityFocusedWindowId == windowId && eventAction != 64) {
                            this.mAccessibilityFocusedWindowId = -1;
                        }
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTouchInteractionStart() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                this.mTouchInteractionInProgress = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTouchInteractionEnd() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                this.mTouchInteractionInProgress = false;
                int oldActiveWindow = ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mActiveWindowId;
                this.setActiveWindowLocked(this.mFocusedWindowId);
                if (oldActiveWindow != ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mActiveWindowId && this.mAccessibilityFocusedWindowId == oldActiveWindow && ((AccessibilityManagerService)AccessibilityManagerService.this).getCurrentUserStateLocked().mAccessibilityFocusOnlyInActiveWindow) {
                    AccessibilityManagerService.this.mMainHandler.obtainMessage(9, oldActiveWindow, 0).sendToTarget();
                }
            }
        }

        public int getActiveWindowId() {
            if (this.mActiveWindowId == -1 && !this.mTouchInteractionInProgress) {
                this.mActiveWindowId = this.getFocusedWindowId();
            }
            return this.mActiveWindowId;
        }

        private void setActiveWindowLocked(int windowId) {
            if (this.mActiveWindowId != windowId) {
                AccessibilityManagerService.this.sendAccessibilityEventLocked(AccessibilityEvent.obtainWindowsChangedEvent(this.mActiveWindowId, 32), AccessibilityManagerService.this.mCurrentUserId);
                this.mActiveWindowId = windowId;
                if (this.mWindows != null) {
                    int windowCount = this.mWindows.size();
                    for (int i = 0; i < windowCount; ++i) {
                        AccessibilityWindowInfo window = this.mWindows.get(i);
                        if (window.getId() == windowId) {
                            window.setActive(true);
                            AccessibilityManagerService.this.sendAccessibilityEventLocked(AccessibilityEvent.obtainWindowsChangedEvent(windowId, 32), AccessibilityManagerService.this.mCurrentUserId);
                            continue;
                        }
                        window.setActive(false);
                    }
                }
            }
        }

        private void setAccessibilityFocusedWindowLocked(int windowId) {
            if (this.mAccessibilityFocusedWindowId != windowId) {
                AccessibilityManagerService.this.sendAccessibilityEventLocked(AccessibilityEvent.obtainWindowsChangedEvent(this.mAccessibilityFocusedWindowId, 128), AccessibilityManagerService.this.mCurrentUserId);
                this.mAccessibilityFocusedWindowId = windowId;
                if (this.mWindows != null) {
                    int windowCount = this.mWindows.size();
                    for (int i = 0; i < windowCount; ++i) {
                        AccessibilityWindowInfo window = this.mWindows.get(i);
                        if (window.getId() == windowId) {
                            window.setAccessibilityFocused(true);
                            AccessibilityManagerService.this.sendAccessibilityEventLocked(AccessibilityEvent.obtainWindowsChangedEvent(windowId, 128), AccessibilityManagerService.this.mCurrentUserId);
                            continue;
                        }
                        window.setAccessibilityFocused(false);
                    }
                }
            }
        }

        public boolean canGetAccessibilityNodeInfoLocked(AbstractAccessibilityServiceConnection service, int windowId) {
            return this.canRetrieveWindowContentLocked(service) && this.isRetrievalAllowingWindow(windowId);
        }

        public boolean canRetrieveWindowsLocked(AbstractAccessibilityServiceConnection service) {
            return this.canRetrieveWindowContentLocked(service) && service.mRetrieveInteractiveWindows;
        }

        public boolean canRetrieveWindowContentLocked(AbstractAccessibilityServiceConnection service) {
            return (service.mAccessibilityServiceInfo.getCapabilities() & 1) != 0;
        }

        public boolean canControlMagnification(AbstractAccessibilityServiceConnection service) {
            return (service.mAccessibilityServiceInfo.getCapabilities() & 0x10) != 0;
        }

        public boolean canPerformGestures(AccessibilityServiceConnection service) {
            return (service.mAccessibilityServiceInfo.getCapabilities() & 0x20) != 0;
        }

        public boolean canCaptureFingerprintGestures(AccessibilityServiceConnection service) {
            return (service.mAccessibilityServiceInfo.getCapabilities() & 0x40) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int resolveProfileParentLocked(int userId) {
            if (userId != AccessibilityManagerService.this.mCurrentUserId) {
                long identity = Binder.clearCallingIdentity();
                try {
                    UserInfo parent = AccessibilityManagerService.this.mUserManager.getProfileParent(userId);
                    if (parent != null) {
                        int n = parent.getUserHandle().getIdentifier();
                        return n;
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            return userId;
        }

        public int resolveCallingUserIdEnforcingPermissionsLocked(int userId) {
            int callingUid = Binder.getCallingUid();
            if (callingUid == 0 || callingUid == 1000 || callingUid == 2000) {
                if (userId == -2 || userId == -3) {
                    return AccessibilityManagerService.this.mCurrentUserId;
                }
                return this.resolveProfileParentLocked(userId);
            }
            int callingUserId = UserHandle.getUserId(callingUid);
            if (callingUserId == userId) {
                return this.resolveProfileParentLocked(userId);
            }
            int callingUserParentId = this.resolveProfileParentLocked(callingUserId);
            if (callingUserParentId == AccessibilityManagerService.this.mCurrentUserId && (userId == -2 || userId == -3)) {
                return AccessibilityManagerService.this.mCurrentUserId;
            }
            if (!this.hasPermission("android.permission.INTERACT_ACROSS_USERS") && !this.hasPermission("android.permission.INTERACT_ACROSS_USERS_FULL")) {
                throw new SecurityException("Call from user " + callingUserId + " as user " + userId + " without permission INTERACT_ACROSS_USERS or INTERACT_ACROSS_USERS_FULL not allowed.");
            }
            if (userId == -2 || userId == -3) {
                return AccessibilityManagerService.this.mCurrentUserId;
            }
            throw new IllegalArgumentException("Calling user can be changed to only UserHandle.USER_CURRENT or UserHandle.USER_CURRENT_OR_SELF.");
        }

        public boolean isCallerInteractingAcrossUsers(int userId) {
            int callingUid = Binder.getCallingUid();
            return Binder.getCallingPid() == Process.myPid() || callingUid == 2000 || userId == -2 || userId == -3;
        }

        private boolean isRetrievalAllowingWindow(int windowId) {
            if (Binder.getCallingUid() == 1000) {
                return true;
            }
            if (windowId == this.mActiveWindowId) {
                return true;
            }
            return this.findA11yWindowInfoById(windowId) != null;
        }

        public AccessibilityWindowInfo findA11yWindowInfoById(int windowId) {
            return this.mA11yWindowInfoById.get(windowId);
        }

        private WindowInfo findWindowInfoById(int windowId) {
            return this.mWindowInfoById.get(windowId);
        }

        private AccessibilityWindowInfo getPictureInPictureWindow() {
            if (this.mWindows != null) {
                int windowCount = this.mWindows.size();
                for (int i = 0; i < windowCount; ++i) {
                    AccessibilityWindowInfo window = this.mWindows.get(i);
                    if (!window.isInPictureInPictureMode()) continue;
                    return window;
                }
            }
            return null;
        }

        private void enforceCallingPermission(String permission2, String function) {
            if (OWN_PROCESS_ID == Binder.getCallingPid()) {
                return;
            }
            if (!this.hasPermission(permission2)) {
                throw new SecurityException("You do not have " + permission2 + " required to call " + function + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            }
        }

        private boolean hasPermission(String permission2) {
            return AccessibilityManagerService.this.mContext.checkCallingPermission(permission2) == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getFocusedWindowId() {
            IBinder token = AccessibilityManagerService.this.mWindowManagerService.getFocusedWindowToken();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                return AccessibilityManagerService.this.findWindowIdLocked(token);
            }
        }
    }

    private final class InteractionBridge {
        private final ComponentName COMPONENT_NAME = new ComponentName("com.android.server.accessibility", "InteractionBridge");
        private final Display mDefaultDisplay;
        private final int mConnectionId;
        private final AccessibilityInteractionClient mClient;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InteractionBridge() {
            UserState userState;
            AccessibilityServiceInfo info = new AccessibilityServiceInfo();
            info.setCapabilities(1);
            info.flags |= 0x40;
            info.flags |= 2;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
            }
            AccessibilityServiceConnection service = new AccessibilityServiceConnection(userState, AccessibilityManagerService.this.mContext, this.COMPONENT_NAME, info, sIdCounter++, AccessibilityManagerService.this.mMainHandler, AccessibilityManagerService.this.mLock, AccessibilityManagerService.this.mSecurityPolicy, AccessibilityManagerService.this, AccessibilityManagerService.this.mWindowManagerService, AccessibilityManagerService.this.mGlobalActionPerformer){

                @Override
                public boolean supportsFlagForNotImportantViews(AccessibilityServiceInfo info) {
                    return true;
                }
            };
            this.mConnectionId = service.mId;
            this.mClient = AccessibilityInteractionClient.getInstance();
            AccessibilityInteractionClient.addConnection(this.mConnectionId, service);
            DisplayManager displayManager = (DisplayManager)AccessibilityManagerService.this.mContext.getSystemService("display");
            this.mDefaultDisplay = displayManager.getDisplay(0);
        }

        public void clearAccessibilityFocusNotLocked(int windowId) {
            AccessibilityNodeInfo focus = this.getAccessibilityFocusNotLocked(windowId);
            if (focus != null) {
                focus.performAction(128);
            }
        }

        public boolean performActionOnAccessibilityFocusedItemNotLocked(AccessibilityNodeInfo.AccessibilityAction action) {
            AccessibilityNodeInfo focus = this.getAccessibilityFocusNotLocked();
            if (focus == null || !focus.getActionList().contains(action)) {
                return false;
            }
            return focus.performAction(action.getId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getAccessibilityFocusClickPointInScreenNotLocked(Point outPoint) {
            AccessibilityNodeInfo focus = this.getAccessibilityFocusNotLocked();
            if (focus == null) {
                return false;
            }
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                Rect boundsInScreen = AccessibilityManagerService.this.mTempRect;
                focus.getBoundsInScreen(boundsInScreen);
                MagnificationSpec spec = AccessibilityManagerService.this.getCompatibleMagnificationSpecLocked(focus.getWindowId());
                if (spec != null && !spec.isNop()) {
                    boundsInScreen.offset((int)(-spec.offsetX), (int)(-spec.offsetY));
                    boundsInScreen.scale(1.0f / spec.scale);
                }
                Rect windowBounds = AccessibilityManagerService.this.mTempRect1;
                AccessibilityManagerService.this.getWindowBounds(focus.getWindowId(), windowBounds);
                if (!boundsInScreen.intersect(windowBounds)) {
                    return false;
                }
                Point screenSize = AccessibilityManagerService.this.mTempPoint;
                this.mDefaultDisplay.getRealSize(screenSize);
                if (!boundsInScreen.intersect(0, 0, screenSize.x, screenSize.y)) {
                    return false;
                }
                outPoint.set(boundsInScreen.centerX(), boundsInScreen.centerY());
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AccessibilityNodeInfo getAccessibilityFocusNotLocked() {
            int focusedWindowId;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                focusedWindowId = ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mAccessibilityFocusedWindowId;
                if (focusedWindowId == -1) {
                    return null;
                }
            }
            return this.getAccessibilityFocusNotLocked(focusedWindowId);
        }

        private AccessibilityNodeInfo getAccessibilityFocusNotLocked(int windowId) {
            return this.mClient.findFocus(this.mConnectionId, windowId, AccessibilityNodeInfo.ROOT_NODE_ID, 2);
        }
    }

    final class WindowsForAccessibilityCallback
    implements WindowManagerInternal.WindowsForAccessibilityCallback {
        WindowsForAccessibilityCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWindowsForAccessibilityChanged(List<WindowInfo> windows) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                AccessibilityManagerService.this.mSecurityPolicy.updateWindowsLocked(windows);
                AccessibilityManagerService.this.mLock.notifyAll();
            }
        }

        private AccessibilityWindowInfo populateReportedWindow(WindowInfo window) {
            int windowId = AccessibilityManagerService.this.findWindowIdLocked(window.token);
            if (windowId < 0) {
                return null;
            }
            AccessibilityWindowInfo reportedWindow = AccessibilityWindowInfo.obtain();
            reportedWindow.setId(windowId);
            reportedWindow.setType(this.getTypeForWindowManagerWindowType(window.type));
            reportedWindow.setLayer(window.layer);
            reportedWindow.setFocused(window.focused);
            reportedWindow.setBoundsInScreen(window.boundsInScreen);
            reportedWindow.setTitle(window.title);
            reportedWindow.setAnchorId(window.accessibilityIdOfAnchor);
            reportedWindow.setPictureInPicture(window.inPictureInPicture);
            int parentId = AccessibilityManagerService.this.findWindowIdLocked(window.parentToken);
            if (parentId >= 0) {
                reportedWindow.setParentId(parentId);
            }
            if (window.childTokens != null) {
                int childCount = window.childTokens.size();
                for (int i = 0; i < childCount; ++i) {
                    IBinder childToken = window.childTokens.get(i);
                    int childId = AccessibilityManagerService.this.findWindowIdLocked(childToken);
                    if (childId < 0) continue;
                    reportedWindow.addChild(childId);
                }
            }
            return reportedWindow;
        }

        private int getTypeForWindowManagerWindowType(int windowType) {
            switch (windowType) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 1000: 
                case 1001: 
                case 1002: 
                case 1003: 
                case 1005: 
                case 2002: 
                case 2005: 
                case 2007: {
                    return 1;
                }
                case 2011: 
                case 2012: {
                    return 2;
                }
                case 2000: 
                case 2001: 
                case 2003: 
                case 2006: 
                case 2008: 
                case 2009: 
                case 2010: 
                case 2014: 
                case 2017: 
                case 2019: 
                case 2020: 
                case 2024: 
                case 2036: 
                case 2038: {
                    return 3;
                }
                case 2034: {
                    return 5;
                }
                case 2032: {
                    return 4;
                }
            }
            return -1;
        }
    }

    final class MainHandler
    extends Handler {
        public static final int MSG_SEND_ACCESSIBILITY_EVENT_TO_INPUT_FILTER = 1;
        public static final int MSG_SEND_STATE_TO_CLIENTS = 2;
        public static final int MSG_SEND_CLEARED_STATE_TO_CLIENTS_FOR_USER = 3;
        public static final int MSG_ANNOUNCE_NEW_USER_IF_NEEDED = 5;
        public static final int MSG_UPDATE_INPUT_FILTER = 6;
        public static final int MSG_SHOW_ENABLED_TOUCH_EXPLORATION_DIALOG = 7;
        public static final int MSG_SEND_KEY_EVENT_TO_INPUT_FILTER = 8;
        public static final int MSG_CLEAR_ACCESSIBILITY_FOCUS = 9;
        public static final int MSG_SEND_SERVICES_STATE_CHANGED_TO_CLIENTS = 10;
        public static final int MSG_UPDATE_FINGERPRINT = 11;
        public static final int MSG_SEND_RELEVANT_EVENTS_CHANGED_TO_CLIENTS = 12;
        public static final int MSG_SEND_ACCESSIBILITY_BUTTON_TO_INPUT_FILTER = 13;
        public static final int MSG_SHOW_ACCESSIBILITY_BUTTON_CHOOSER = 14;
        public static final int MSG_INIT_SERVICE = 15;
        public static final int MSG_SEND_ACCESSIBILITY_EVENT = 16;

        public MainHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            int type = msg.what;
            switch (type) {
                case 1: {
                    AccessibilityEvent event = (AccessibilityEvent)msg.obj;
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (AccessibilityManagerService.this.mHasInputFilter && AccessibilityManagerService.this.mInputFilter != null) {
                            AccessibilityManagerService.this.mInputFilter.notifyAccessibilityEvent(event);
                        }
                    }
                    event.recycle();
                    break;
                }
                case 8: {
                    KeyEvent event = (KeyEvent)msg.obj;
                    int policyFlags = msg.arg1;
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (AccessibilityManagerService.this.mHasInputFilter && AccessibilityManagerService.this.mInputFilter != null) {
                            AccessibilityManagerService.this.mInputFilter.sendInputEvent(event, policyFlags);
                        }
                    }
                    event.recycle();
                    break;
                }
                case 2: {
                    int clientState = msg.arg1;
                    int userId = msg.arg2;
                    this.sendStateToClients(clientState, AccessibilityManagerService.this.mGlobalClients);
                    this.sendStateToClients(clientState, this.getUserClientsForId(userId));
                    break;
                }
                case 3: {
                    int userId = msg.arg1;
                    this.sendStateToClients(0, this.getUserClientsForId(userId));
                    break;
                }
                case 5: {
                    this.announceNewUserIfNeeded();
                    break;
                }
                case 6: {
                    UserState userState = (UserState)msg.obj;
                    AccessibilityManagerService.this.updateInputFilter(userState);
                    break;
                }
                case 7: {
                    AccessibilityServiceConnection service = (AccessibilityServiceConnection)msg.obj;
                    AccessibilityManagerService.this.showEnableTouchExplorationDialog(service);
                    break;
                }
                case 9: {
                    int windowId = msg.arg1;
                    AccessibilityManagerService.this.getInteractionBridge().clearAccessibilityFocusNotLocked(windowId);
                    break;
                }
                case 10: {
                    int userId = msg.arg1;
                    this.notifyClientsOfServicesStateChange(AccessibilityManagerService.this.mGlobalClients);
                    this.notifyClientsOfServicesStateChange(this.getUserClientsForId(userId));
                    break;
                }
                case 11: {
                    AccessibilityManagerService.this.updateFingerprintGestureHandling((UserState)msg.obj);
                    break;
                }
                case 12: {
                    UserState userState;
                    int userId = msg.arg1;
                    int relevantEventTypes = msg.arg2;
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        userState = AccessibilityManagerService.this.getUserStateLocked(userId);
                    }
                    AccessibilityManagerService.this.broadcastToClients(userState, FunctionalUtils.ignoreRemoteException(client -> client.mCallback.setRelevantEventTypes(relevantEventTypes)));
                    break;
                }
                case 13: {
                    Object userId = AccessibilityManagerService.this.mLock;
                    synchronized (userId) {
                        if (AccessibilityManagerService.this.mHasInputFilter && AccessibilityManagerService.this.mInputFilter != null) {
                            AccessibilityManagerService.this.mInputFilter.notifyAccessibilityButtonClicked();
                        }
                        break;
                    }
                }
                case 14: {
                    AccessibilityManagerService.this.showAccessibilityButtonTargetSelection();
                    break;
                }
                case 15: {
                    AccessibilityServiceConnection service = (AccessibilityServiceConnection)msg.obj;
                    service.initializeService();
                    break;
                }
                case 16: {
                    AccessibilityEvent event = (AccessibilityEvent)msg.obj;
                    int userId = msg.arg1;
                    AccessibilityManagerService.this.sendAccessibilityEvent(event, userId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void announceNewUserIfNeeded() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                if (userState.isHandlingAccessibilityEvents()) {
                    UserManager userManager = (UserManager)AccessibilityManagerService.this.mContext.getSystemService("user");
                    String message = AccessibilityManagerService.this.mContext.getString(17040983, userManager.getUserInfo((int)((AccessibilityManagerService)AccessibilityManagerService.this).mCurrentUserId).name);
                    AccessibilityEvent event = AccessibilityEvent.obtain(16384);
                    event.getText().add(message);
                    AccessibilityManagerService.this.sendAccessibilityEventLocked(event, AccessibilityManagerService.this.mCurrentUserId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RemoteCallbackList<IAccessibilityManagerClient> getUserClientsForId(int userId) {
            UserState userState;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                userState = AccessibilityManagerService.this.getUserStateLocked(userId);
            }
            return userState.mUserClients;
        }

        private void sendStateToClients(int clientState, RemoteCallbackList<IAccessibilityManagerClient> clients) {
            clients.broadcast(FunctionalUtils.ignoreRemoteException(client -> client.setState(clientState)));
        }

        private void notifyClientsOfServicesStateChange(RemoteCallbackList<IAccessibilityManagerClient> clients) {
            clients.broadcast(FunctionalUtils.ignoreRemoteException(client -> client.notifyServicesStateChanged()));
        }
    }

    class RemoteAccessibilityConnection
    implements IBinder.DeathRecipient {
        private final int mUid;
        private final String mPackageName;
        private final int mWindowId;
        private final int mUserId;
        private final IAccessibilityInteractionConnection mConnection;

        RemoteAccessibilityConnection(int windowId, IAccessibilityInteractionConnection connection, String packageName, int uid, int userId) {
            this.mWindowId = windowId;
            this.mPackageName = packageName;
            this.mUid = uid;
            this.mUserId = userId;
            this.mConnection = connection;
        }

        public int getUid() {
            return this.mUid;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public IAccessibilityInteractionConnection getRemote() {
            return this.mConnection;
        }

        public void linkToDeath() throws RemoteException {
            this.mConnection.asBinder().linkToDeath(this, 0);
        }

        public void unlinkToDeath() {
            this.mConnection.asBinder().unlinkToDeath(this, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            this.unlinkToDeath();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                AccessibilityManagerService.this.removeAccessibilityInteractionConnectionLocked(this.mWindowId, this.mUserId);
            }
        }
    }
}

