/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Slog;
import com.android.server.accessibility.AbstractAccessibilityServiceConnection;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.accessibility.GlobalActionPerformer;
import com.android.server.accessibility.MotionEventInjector;
import com.android.server.wm.WindowManagerInternal;
import java.lang.ref.WeakReference;
import java.util.Set;

class AccessibilityServiceConnection
extends AbstractAccessibilityServiceConnection {
    private static final String LOG_TAG = "AccessibilityServiceConnection";
    final WeakReference<AccessibilityManagerService.UserState> mUserStateWeakReference;
    final Intent mIntent;
    private final Handler mMainHandler;
    private boolean mWasConnectedAndDied;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityServiceConnection(AccessibilityManagerService.UserState userState, Context context, ComponentName componentName, AccessibilityServiceInfo accessibilityServiceInfo, int id2, Handler mainHandler, Object lock, AccessibilityManagerService.SecurityPolicy securityPolicy, AbstractAccessibilityServiceConnection.SystemSupport systemSupport, WindowManagerInternal windowManagerInternal, GlobalActionPerformer globalActionPerfomer) {
        super(context, componentName, accessibilityServiceInfo, id2, mainHandler, lock, securityPolicy, systemSupport, windowManagerInternal, globalActionPerfomer);
        this.mUserStateWeakReference = new WeakReference<AccessibilityManagerService.UserState>(userState);
        this.mIntent = new Intent().setComponent(this.mComponentName);
        this.mMainHandler = mainHandler;
        this.mIntent.putExtra("android.intent.extra.client_label", 17039420);
        long identity = Binder.clearCallingIdentity();
        try {
            this.mIntent.putExtra("android.intent.extra.client_intent", this.mSystemSupport.getPendingIntentActivity(this.mContext, 0, new Intent("android.settings.ACCESSIBILITY_SETTINGS"), 0));
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindLocked() {
        AccessibilityManagerService.UserState userState = (AccessibilityManagerService.UserState)this.mUserStateWeakReference.get();
        if (userState == null) {
            return;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            int flags = 0x2000001;
            if (userState.mBindInstantServiceAllowed) {
                flags |= 0x400000;
            }
            if (this.mService == null && this.mContext.bindServiceAsUser(this.mIntent, this, flags, new UserHandle(userState.mUserId))) {
                userState.getBindingServicesLocked().add(this.mComponentName);
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public void unbindLocked() {
        this.mContext.unbindService(this);
        AccessibilityManagerService.UserState userState = (AccessibilityManagerService.UserState)this.mUserStateWeakReference.get();
        if (userState == null) {
            return;
        }
        userState.removeServiceLocked(this);
        this.resetLocked();
    }

    public boolean canRetrieveInteractiveWindowsLocked() {
        return this.mSecurityPolicy.canRetrieveWindowContentLocked(this) && this.mRetrieveInteractiveWindows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableSelf() {
        Object object = this.mLock;
        synchronized (object) {
            AccessibilityManagerService.UserState userState = (AccessibilityManagerService.UserState)this.mUserStateWeakReference.get();
            if (userState == null) {
                return;
            }
            if (userState.mEnabledServices.remove(this.mComponentName)) {
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mSystemSupport.persistComponentNamesToSettingLocked("enabled_accessibility_services", userState.mEnabledServices, userState.mUserId);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
                this.mSystemSupport.onClientChange(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceConnected(ComponentName componentName, IBinder service) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mService != service) {
                if (this.mService != null) {
                    this.mService.unlinkToDeath(this, 0);
                }
                this.mService = service;
                try {
                    this.mService.linkToDeath(this, 0);
                }
                catch (RemoteException re) {
                    Slog.e(LOG_TAG, "Failed registering death link");
                    this.binderDied();
                    return;
                }
            }
            this.mServiceInterface = IAccessibilityServiceClient.Stub.asInterface(service);
            AccessibilityManagerService.UserState userState = (AccessibilityManagerService.UserState)this.mUserStateWeakReference.get();
            if (userState == null) {
                return;
            }
            userState.addServiceLocked(this);
            this.mSystemSupport.onClientChange(false);
            this.mMainHandler.obtainMessage(15, this).sendToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeService() {
        IAccessibilityServiceClient serviceInterface = null;
        Object object = this.mLock;
        synchronized (object) {
            AccessibilityManagerService.UserState userState = (AccessibilityManagerService.UserState)this.mUserStateWeakReference.get();
            if (userState == null) {
                return;
            }
            Set<ComponentName> bindingServices = userState.getBindingServicesLocked();
            if (bindingServices.contains(this.mComponentName) || this.mWasConnectedAndDied) {
                bindingServices.remove(this.mComponentName);
                this.mWasConnectedAndDied = false;
                serviceInterface = this.mServiceInterface;
            }
        }
        if (serviceInterface == null) {
            this.binderDied();
            return;
        }
        try {
            serviceInterface.init(this, this.mId, this.mOverlayWindowToken);
        }
        catch (RemoteException re) {
            Slog.w(LOG_TAG, "Error while setting connection for service: " + serviceInterface, re);
            this.binderDied();
        }
    }

    @Override
    public void onServiceDisconnected(ComponentName componentName) {
        this.binderDied();
    }

    @Override
    protected boolean isCalledForCurrentUserLocked() {
        int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(-2);
        return resolvedUserId == this.mSystemSupport.getCurrentUserIdLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setSoftKeyboardShowMode(int showMode) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isCalledForCurrentUserLocked()) {
                return false;
            }
        }
        AccessibilityManagerService.UserState userState = (AccessibilityManagerService.UserState)this.mUserStateWeakReference.get();
        if (userState == null) {
            return false;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            userState.mServiceChangingSoftKeyboardMode = showMode == 0 ? null : this.mComponentName;
            Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "accessibility_soft_keyboard_mode", showMode, userState.mUserId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAccessibilityButtonAvailable() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isCalledForCurrentUserLocked()) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            AccessibilityManagerService.UserState userState = (AccessibilityManagerService.UserState)this.mUserStateWeakReference.get();
            return userState != null && this.isAccessibilityButtonAvailableLocked(userState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binderDied() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isConnectedLocked()) {
                return;
            }
            this.mWasConnectedAndDied = true;
            this.resetLocked();
            if (this.mId == this.mSystemSupport.getMagnificationController().getIdOfLastServiceToMagnify()) {
                this.mSystemSupport.getMagnificationController().resetIfNeeded(true);
            }
            this.mSystemSupport.onClientChange(false);
        }
    }

    public boolean isAccessibilityButtonAvailableLocked(AccessibilityManagerService.UserState userState) {
        if (!this.mRequestAccessibilityButton) {
            return false;
        }
        if (!this.mSystemSupport.isAccessibilityButtonShown()) {
            return false;
        }
        if (userState.mIsNavBarMagnificationEnabled && userState.mIsNavBarMagnificationAssignedToAccessibilityButton) {
            return false;
        }
        int requestingServices = 0;
        for (int i = userState.mBoundServices.size() - 1; i >= 0; --i) {
            AccessibilityServiceConnection service = userState.mBoundServices.get(i);
            if (!service.mRequestAccessibilityButton) continue;
            ++requestingServices;
        }
        if (requestingServices == 1) {
            return true;
        }
        if (userState.mServiceAssignedToAccessibilityButton == null) {
            return true;
        }
        return this.mComponentName.equals(userState.mServiceAssignedToAccessibilityButton);
    }

    @Override
    public boolean isCapturingFingerprintGestures() {
        return this.mServiceInterface != null && this.mSecurityPolicy.canCaptureFingerprintGestures(this) && this.mCaptureFingerprintGestures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFingerprintGestureDetectionActiveChanged(boolean active) {
        IAccessibilityServiceClient serviceInterface;
        if (!this.isCapturingFingerprintGestures()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            serviceInterface = this.mServiceInterface;
        }
        if (serviceInterface != null) {
            try {
                this.mServiceInterface.onFingerprintCapturingGesturesChanged(active);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFingerprintGesture(int gesture) {
        IAccessibilityServiceClient serviceInterface;
        if (!this.isCapturingFingerprintGestures()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            serviceInterface = this.mServiceInterface;
        }
        if (serviceInterface != null) {
            try {
                this.mServiceInterface.onFingerprintGesture(gesture);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendGesture(int sequence, ParceledListSlice gestureSteps) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSecurityPolicy.canPerformGestures(this)) {
                MotionEventInjector motionEventInjector = this.mSystemSupport.getMotionEventInjectorLocked();
                if (motionEventInjector != null) {
                    motionEventInjector.injectEvents(gestureSteps.getList(), this.mServiceInterface, sequence);
                } else {
                    try {
                        this.mServiceInterface.onPerformGestureResult(sequence, false);
                    }
                    catch (RemoteException re) {
                        Slog.e(LOG_TAG, "Error sending motion event injection failure to " + this.mServiceInterface, re);
                    }
                }
            }
        }
    }
}

