/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.animation.ValueAnimator;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.MathUtils;
import android.view.MagnificationSpec;
import android.view.animation.DecelerateInterpolator;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.SomeArgs;
import com.android.server.LocalServices;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.wm.WindowManagerInternal;
import java.util.Locale;

class MagnificationController
implements Handler.Callback {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "MagnificationController";
    public static final float MIN_SCALE = 1.0f;
    public static final float MAX_SCALE = 5.0f;
    private static final boolean DEBUG_SET_MAGNIFICATION_SPEC = false;
    private static final int INVALID_ID = -1;
    private static final float DEFAULT_MAGNIFICATION_SCALE = 2.0f;
    private static final int MSG_SEND_SPEC_TO_ANIMATION = 1;
    private static final int MSG_SCREEN_TURNED_OFF = 2;
    private static final int MSG_ON_MAGNIFIED_BOUNDS_CHANGED = 3;
    private static final int MSG_ON_RECTANGLE_ON_SCREEN_REQUESTED = 4;
    private static final int MSG_ON_USER_CONTEXT_CHANGED = 5;
    private final Object mLock;
    private final MagnificationSpec mCurrentMagnificationSpec = MagnificationSpec.obtain();
    private final Region mMagnificationRegion = Region.obtain();
    private final Rect mMagnificationBounds = new Rect();
    private final Rect mTempRect = new Rect();
    private final Rect mTempRect1 = new Rect();
    private final AccessibilityManagerService mAms;
    private final SettingsBridge mSettingsBridge;
    private final ScreenStateObserver mScreenStateObserver;
    private final SpecAnimationBridge mSpecAnimationBridge;
    private final WindowManagerInternal.MagnificationCallbacks mWMCallbacks = new WindowManagerInternal.MagnificationCallbacks(){

        @Override
        public void onMagnificationRegionChanged(Region region) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = Region.obtain(region);
            MagnificationController.this.mHandler.obtainMessage(3, args).sendToTarget();
        }

        @Override
        public void onRectangleOnScreenRequested(int left, int top, int right, int bottom) {
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = left;
            args.argi2 = top;
            args.argi3 = right;
            args.argi4 = bottom;
            MagnificationController.this.mHandler.obtainMessage(4, args).sendToTarget();
        }

        @Override
        public void onRotationChanged(int rotation) {
            MagnificationController.this.mHandler.sendEmptyMessage(5);
        }

        @Override
        public void onUserContextChanged() {
            MagnificationController.this.mHandler.sendEmptyMessage(5);
        }
    };
    private int mUserId;
    private final long mMainThreadId;
    private Handler mHandler;
    private int mIdOfLastServiceToMagnify = -1;
    private final WindowManagerInternal mWindowManager;
    @VisibleForTesting
    boolean mRegistered;
    private boolean mUnregisterPending;

    public MagnificationController(Context context, AccessibilityManagerService ams, Object lock) {
        this(context, ams, lock, null, LocalServices.getService(WindowManagerInternal.class), new ValueAnimator(), new SettingsBridge(context.getContentResolver()));
        this.mHandler = new Handler(context.getMainLooper(), this);
    }

    public MagnificationController(Context context, AccessibilityManagerService ams, Object lock, Handler handler, WindowManagerInternal windowManagerInternal, ValueAnimator valueAnimator, SettingsBridge settingsBridge) {
        this.mHandler = handler;
        this.mWindowManager = windowManagerInternal;
        this.mMainThreadId = context.getMainLooper().getThread().getId();
        this.mAms = ams;
        this.mScreenStateObserver = new ScreenStateObserver(context, this);
        this.mLock = lock;
        this.mSpecAnimationBridge = new SpecAnimationBridge(context, this.mLock, this.mWindowManager, valueAnimator);
        this.mSettingsBridge = settingsBridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mRegistered) {
                this.mScreenStateObserver.register();
                this.mWindowManager.setMagnificationCallbacks(this.mWMCallbacks);
                this.mSpecAnimationBridge.setEnabled(true);
                this.mWindowManager.getMagnificationRegion(this.mMagnificationRegion);
                this.mMagnificationRegion.getBounds(this.mMagnificationBounds);
                this.mRegistered = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isMagnifying()) {
                this.unregisterInternalLocked();
            } else {
                this.mUnregisterPending = true;
                this.resetLocked(true);
            }
        }
    }

    public boolean isRegisteredLocked() {
        return this.mRegistered;
    }

    private void unregisterInternalLocked() {
        if (this.mRegistered) {
            this.mSpecAnimationBridge.setEnabled(false);
            this.mScreenStateObserver.unregister();
            this.mWindowManager.setMagnificationCallbacks(null);
            this.mMagnificationRegion.setEmpty();
            this.mRegistered = false;
        }
        this.mUnregisterPending = false;
    }

    public boolean isMagnifying() {
        return this.mCurrentMagnificationSpec.scale > 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMagnificationRegionChanged(Region magnified) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mRegistered) {
                return;
            }
            if (!this.mMagnificationRegion.equals(magnified)) {
                this.mMagnificationRegion.set(magnified);
                this.mMagnificationRegion.getBounds(this.mMagnificationBounds);
                if (this.updateCurrentSpecWithOffsetsLocked(this.mCurrentMagnificationSpec.offsetX, this.mCurrentMagnificationSpec.offsetY)) {
                    this.sendSpecToAnimation(this.mCurrentMagnificationSpec, false);
                }
                this.onMagnificationChangedLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean magnificationRegionContains(float x, float y) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mMagnificationRegion.contains((int)x, (int)y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMagnificationBounds(Rect outBounds) {
        Object object = this.mLock;
        synchronized (object) {
            outBounds.set(this.mMagnificationBounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMagnificationRegion(Region outRegion) {
        Object object = this.mLock;
        synchronized (object) {
            outRegion.set(this.mMagnificationRegion);
        }
    }

    public float getScale() {
        return this.mCurrentMagnificationSpec.scale;
    }

    public float getOffsetX() {
        return this.mCurrentMagnificationSpec.offsetX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getCenterX() {
        Object object = this.mLock;
        synchronized (object) {
            return ((float)this.mMagnificationBounds.width() / 2.0f + (float)this.mMagnificationBounds.left - this.getOffsetX()) / this.getScale();
        }
    }

    public float getOffsetY() {
        return this.mCurrentMagnificationSpec.offsetY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getCenterY() {
        Object object = this.mLock;
        synchronized (object) {
            return ((float)this.mMagnificationBounds.height() / 2.0f + (float)this.mMagnificationBounds.top - this.getOffsetY()) / this.getScale();
        }
    }

    private float getSentScale() {
        return ((SpecAnimationBridge)this.mSpecAnimationBridge).mSentMagnificationSpec.scale;
    }

    private float getSentOffsetX() {
        return ((SpecAnimationBridge)this.mSpecAnimationBridge).mSentMagnificationSpec.offsetX;
    }

    private float getSentOffsetY() {
        return ((SpecAnimationBridge)this.mSpecAnimationBridge).mSentMagnificationSpec.offsetY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reset(boolean animate) {
        Object object = this.mLock;
        synchronized (object) {
            return this.resetLocked(animate);
        }
    }

    private boolean resetLocked(boolean animate) {
        boolean changed;
        if (!this.mRegistered) {
            return false;
        }
        MagnificationSpec spec = this.mCurrentMagnificationSpec;
        boolean bl = changed = !spec.isNop();
        if (changed) {
            spec.clear();
            this.onMagnificationChangedLocked();
        }
        this.mIdOfLastServiceToMagnify = -1;
        this.sendSpecToAnimation(spec, animate);
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScale(float scale, float pivotX, float pivotY, boolean animate, int id2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mRegistered) {
                return false;
            }
            scale = MathUtils.constrain(scale, 1.0f, 5.0f);
            Rect viewport = this.mTempRect;
            this.mMagnificationRegion.getBounds(viewport);
            MagnificationSpec spec = this.mCurrentMagnificationSpec;
            float oldScale = spec.scale;
            float oldCenterX = ((float)viewport.width() / 2.0f - spec.offsetX) / oldScale;
            float oldCenterY = ((float)viewport.height() / 2.0f - spec.offsetY) / oldScale;
            float normPivotX = (pivotX - spec.offsetX) / oldScale;
            float normPivotY = (pivotY - spec.offsetY) / oldScale;
            float offsetX = (oldCenterX - normPivotX) * (oldScale / scale);
            float offsetY = (oldCenterY - normPivotY) * (oldScale / scale);
            float centerX = normPivotX + offsetX;
            float centerY = normPivotY + offsetY;
            this.mIdOfLastServiceToMagnify = id2;
            return this.setScaleAndCenterLocked(scale, centerX, centerY, animate, id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCenter(float centerX, float centerY, boolean animate, int id2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mRegistered) {
                return false;
            }
            return this.setScaleAndCenterLocked(Float.NaN, centerX, centerY, animate, id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScaleAndCenter(float scale, float centerX, float centerY, boolean animate, int id2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mRegistered) {
                return false;
            }
            return this.setScaleAndCenterLocked(scale, centerX, centerY, animate, id2);
        }
    }

    private boolean setScaleAndCenterLocked(float scale, float centerX, float centerY, boolean animate, int id2) {
        boolean changed = this.updateMagnificationSpecLocked(scale, centerX, centerY);
        this.sendSpecToAnimation(this.mCurrentMagnificationSpec, animate);
        if (this.isMagnifying() && id2 != -1) {
            this.mIdOfLastServiceToMagnify = id2;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offsetMagnifiedRegion(float offsetX, float offsetY, int id2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mRegistered) {
                return;
            }
            float nonNormOffsetX = this.mCurrentMagnificationSpec.offsetX - offsetX;
            float nonNormOffsetY = this.mCurrentMagnificationSpec.offsetY - offsetY;
            if (this.updateCurrentSpecWithOffsetsLocked(nonNormOffsetX, nonNormOffsetY)) {
                this.onMagnificationChangedLocked();
            }
            if (id2 != -1) {
                this.mIdOfLastServiceToMagnify = id2;
            }
            this.sendSpecToAnimation(this.mCurrentMagnificationSpec, false);
        }
    }

    public int getIdOfLastServiceToMagnify() {
        return this.mIdOfLastServiceToMagnify;
    }

    private void onMagnificationChangedLocked() {
        this.mAms.notifyMagnificationChanged(this.mMagnificationRegion, this.getScale(), this.getCenterX(), this.getCenterY());
        if (this.mUnregisterPending && !this.isMagnifying()) {
            this.unregisterInternalLocked();
        }
    }

    public void persistScale() {
        final float scale = this.mCurrentMagnificationSpec.scale;
        final int userId = this.mUserId;
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                MagnificationController.this.mSettingsBridge.putMagnificationScale(scale, userId);
                return null;
            }
        }.execute(new Void[0]);
    }

    public float getPersistedScale() {
        return this.mSettingsBridge.getMagnificationScale(this.mUserId);
    }

    private boolean updateMagnificationSpecLocked(float scale, float centerX, float centerY) {
        float nonNormOffsetY;
        float nonNormOffsetX;
        if (Float.isNaN(centerX)) {
            centerX = this.getCenterX();
        }
        if (Float.isNaN(centerY)) {
            centerY = this.getCenterY();
        }
        if (Float.isNaN(scale)) {
            scale = this.getScale();
        }
        boolean changed = false;
        float normScale = MathUtils.constrain(scale, 1.0f, 5.0f);
        if (Float.compare(this.mCurrentMagnificationSpec.scale, normScale) != 0) {
            this.mCurrentMagnificationSpec.scale = normScale;
            changed = true;
        }
        if (changed |= this.updateCurrentSpecWithOffsetsLocked(nonNormOffsetX = (float)this.mMagnificationBounds.width() / 2.0f + (float)this.mMagnificationBounds.left - centerX * normScale, nonNormOffsetY = (float)this.mMagnificationBounds.height() / 2.0f + (float)this.mMagnificationBounds.top - centerY * normScale)) {
            this.onMagnificationChangedLocked();
        }
        return changed;
    }

    private boolean updateCurrentSpecWithOffsetsLocked(float nonNormOffsetX, float nonNormOffsetY) {
        float offsetY;
        boolean changed = false;
        float offsetX = MathUtils.constrain(nonNormOffsetX, this.getMinOffsetXLocked(), 0.0f);
        if (Float.compare(this.mCurrentMagnificationSpec.offsetX, offsetX) != 0) {
            this.mCurrentMagnificationSpec.offsetX = offsetX;
            changed = true;
        }
        if (Float.compare(this.mCurrentMagnificationSpec.offsetY, offsetY = MathUtils.constrain(nonNormOffsetY, this.getMinOffsetYLocked(), 0.0f)) != 0) {
            this.mCurrentMagnificationSpec.offsetY = offsetY;
            changed = true;
        }
        return changed;
    }

    private float getMinOffsetXLocked() {
        float viewportWidth = this.mMagnificationBounds.width();
        return viewportWidth - viewportWidth * this.mCurrentMagnificationSpec.scale;
    }

    private float getMinOffsetYLocked() {
        float viewportHeight = this.mMagnificationBounds.height();
        return viewportHeight - viewportHeight * this.mCurrentMagnificationSpec.scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserId(int userId) {
        if (this.mUserId != userId) {
            this.mUserId = userId;
            Object object = this.mLock;
            synchronized (object) {
                if (this.isMagnifying()) {
                    this.reset(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resetIfNeeded(boolean animate) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isMagnifying()) {
                this.reset(animate);
                return true;
            }
            return false;
        }
    }

    void setForceShowMagnifiableBounds(boolean show) {
        if (this.mRegistered) {
            this.mWindowManager.setForceShowMagnifiableBounds(show);
        }
    }

    private void getMagnifiedFrameInContentCoordsLocked(Rect outFrame) {
        float scale = this.getSentScale();
        float offsetX = this.getSentOffsetX();
        float offsetY = this.getSentOffsetY();
        this.getMagnificationBounds(outFrame);
        outFrame.offset((int)(-offsetX), (int)(-offsetY));
        outFrame.scale(1.0f / scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestRectangleOnScreen(int left, int top, int right, int bottom) {
        Object object = this.mLock;
        synchronized (object) {
            int direction;
            Rect magnifiedFrame = this.mTempRect;
            this.getMagnificationBounds(magnifiedFrame);
            if (!magnifiedFrame.intersects(left, top, right, bottom)) {
                return;
            }
            Rect magnifFrameInScreenCoords = this.mTempRect1;
            this.getMagnifiedFrameInContentCoordsLocked(magnifFrameInScreenCoords);
            float scrollX = right - left > magnifFrameInScreenCoords.width() ? ((direction = TextUtils.getLayoutDirectionFromLocale(Locale.getDefault())) == 0 ? (float)(left - magnifFrameInScreenCoords.left) : (float)(right - magnifFrameInScreenCoords.right)) : (left < magnifFrameInScreenCoords.left ? (float)(left - magnifFrameInScreenCoords.left) : (right > magnifFrameInScreenCoords.right ? (float)(right - magnifFrameInScreenCoords.right) : 0.0f));
            float scrollY = bottom - top > magnifFrameInScreenCoords.height() ? (float)(top - magnifFrameInScreenCoords.top) : (top < magnifFrameInScreenCoords.top ? (float)(top - magnifFrameInScreenCoords.top) : (bottom > magnifFrameInScreenCoords.bottom ? (float)(bottom - magnifFrameInScreenCoords.bottom) : 0.0f));
            float scale = this.getScale();
            this.offsetMagnifiedRegion(scrollX * scale, scrollY * scale, -1);
        }
    }

    private void sendSpecToAnimation(MagnificationSpec spec, boolean animate) {
        if (Thread.currentThread().getId() == this.mMainThreadId) {
            this.mSpecAnimationBridge.updateSentSpecMainThread(spec, animate);
        } else {
            this.mHandler.obtainMessage(1, animate ? 1 : 0, 0, spec).sendToTarget();
        }
    }

    private void onScreenTurnedOff() {
        this.mHandler.sendEmptyMessage(2);
    }

    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                boolean animate = msg.arg1 == 1;
                MagnificationSpec spec = (MagnificationSpec)msg.obj;
                this.mSpecAnimationBridge.updateSentSpecMainThread(spec, animate);
                break;
            }
            case 2: {
                this.resetIfNeeded(false);
                break;
            }
            case 3: {
                SomeArgs args = (SomeArgs)msg.obj;
                Region magnifiedBounds = (Region)args.arg1;
                this.onMagnificationRegionChanged(magnifiedBounds);
                magnifiedBounds.recycle();
                args.recycle();
                break;
            }
            case 4: {
                SomeArgs args = (SomeArgs)msg.obj;
                int left = args.argi1;
                int top = args.argi2;
                int right = args.argi3;
                int bottom = args.argi4;
                this.requestRectangleOnScreen(left, top, right, bottom);
                args.recycle();
                break;
            }
            case 5: {
                this.resetIfNeeded(true);
            }
        }
        return true;
    }

    public String toString() {
        return "MagnificationController{mCurrentMagnificationSpec=" + this.mCurrentMagnificationSpec + ", mMagnificationRegion=" + this.mMagnificationRegion + ", mMagnificationBounds=" + this.mMagnificationBounds + ", mUserId=" + this.mUserId + ", mIdOfLastServiceToMagnify=" + this.mIdOfLastServiceToMagnify + ", mRegistered=" + this.mRegistered + ", mUnregisterPending=" + this.mUnregisterPending + '}';
    }

    public static class SettingsBridge {
        private final ContentResolver mContentResolver;

        public SettingsBridge(ContentResolver contentResolver) {
            this.mContentResolver = contentResolver;
        }

        public void putMagnificationScale(float value, int userId) {
            Settings.Secure.putFloatForUser(this.mContentResolver, "accessibility_display_magnification_scale", value, userId);
        }

        public float getMagnificationScale(int userId) {
            return Settings.Secure.getFloatForUser(this.mContentResolver, "accessibility_display_magnification_scale", 2.0f, userId);
        }
    }

    private static class ScreenStateObserver
    extends BroadcastReceiver {
        private final Context mContext;
        private final MagnificationController mController;

        public ScreenStateObserver(Context context, MagnificationController controller) {
            this.mContext = context;
            this.mController = controller;
        }

        public void register() {
            this.mContext.registerReceiver(this, new IntentFilter("android.intent.action.SCREEN_OFF"));
        }

        public void unregister() {
            this.mContext.unregisterReceiver(this);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            this.mController.onScreenTurnedOff();
        }
    }

    private static class SpecAnimationBridge
    implements ValueAnimator.AnimatorUpdateListener {
        private final WindowManagerInternal mWindowManager;
        private final MagnificationSpec mSentMagnificationSpec = MagnificationSpec.obtain();
        private final MagnificationSpec mStartMagnificationSpec = MagnificationSpec.obtain();
        private final MagnificationSpec mEndMagnificationSpec = MagnificationSpec.obtain();
        private final MagnificationSpec mTmpMagnificationSpec = MagnificationSpec.obtain();
        private final ValueAnimator mValueAnimator;
        private final Object mLock;
        @GuardedBy(value="mLock")
        private boolean mEnabled = false;

        private SpecAnimationBridge(Context context, Object lock, WindowManagerInternal wm, ValueAnimator animator2) {
            this.mLock = lock;
            this.mWindowManager = wm;
            long animationDuration = context.getResources().getInteger(17694722);
            this.mValueAnimator = animator2;
            this.mValueAnimator.setDuration(animationDuration);
            this.mValueAnimator.setInterpolator(new DecelerateInterpolator(2.5f));
            this.mValueAnimator.setFloatValues(0.0f, 1.0f);
            this.mValueAnimator.addUpdateListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEnabled(boolean enabled) {
            Object object = this.mLock;
            synchronized (object) {
                if (enabled != this.mEnabled) {
                    this.mEnabled = enabled;
                    if (!this.mEnabled) {
                        this.mSentMagnificationSpec.clear();
                        this.mWindowManager.setMagnificationSpec(this.mSentMagnificationSpec);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateSentSpecMainThread(MagnificationSpec spec, boolean animate) {
            if (this.mValueAnimator.isRunning()) {
                this.mValueAnimator.cancel();
            }
            Object object = this.mLock;
            synchronized (object) {
                boolean changed;
                boolean bl = changed = !this.mSentMagnificationSpec.equals(spec);
                if (changed) {
                    if (animate) {
                        this.animateMagnificationSpecLocked(spec);
                    } else {
                        this.setMagnificationSpecLocked(spec);
                    }
                }
            }
        }

        private void setMagnificationSpecLocked(MagnificationSpec spec) {
            if (this.mEnabled) {
                this.mSentMagnificationSpec.setTo(spec);
                this.mWindowManager.setMagnificationSpec(spec);
            }
        }

        private void animateMagnificationSpecLocked(MagnificationSpec toSpec) {
            this.mEndMagnificationSpec.setTo(toSpec);
            this.mStartMagnificationSpec.setTo(this.mSentMagnificationSpec);
            this.mValueAnimator.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAnimationUpdate(ValueAnimator animation) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mEnabled) {
                    float fract = animation.getAnimatedFraction();
                    this.mTmpMagnificationSpec.scale = this.mStartMagnificationSpec.scale + (this.mEndMagnificationSpec.scale - this.mStartMagnificationSpec.scale) * fract;
                    this.mTmpMagnificationSpec.offsetX = this.mStartMagnificationSpec.offsetX + (this.mEndMagnificationSpec.offsetX - this.mStartMagnificationSpec.offsetX) * fract;
                    this.mTmpMagnificationSpec.offsetY = this.mStartMagnificationSpec.offsetY + (this.mEndMagnificationSpec.offsetY - this.mStartMagnificationSpec.offsetY) * fract;
                    Object object2 = this.mLock;
                    synchronized (object2) {
                        this.setMagnificationSpecLocked(this.mTmpMagnificationSpec);
                    }
                }
            }
        }
    }
}

