/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.content.Context;
import android.graphics.Point;
import android.os.Handler;
import android.util.Slog;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.server.accessibility.AccessibilityGestureDetector;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.accessibility.BaseEventStreamTransformation;
import com.android.server.accessibility.GestureUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class TouchExplorer
extends BaseEventStreamTransformation
implements AccessibilityGestureDetector.Listener {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "TouchExplorer";
    private static final int STATE_TOUCH_EXPLORING = 1;
    private static final int STATE_DRAGGING = 2;
    private static final int STATE_DELEGATING = 4;
    private static final int STATE_GESTURE_DETECTING = 5;
    private static final int CLICK_LOCATION_NONE = 0;
    private static final int CLICK_LOCATION_ACCESSIBILITY_FOCUS = 1;
    private static final int CLICK_LOCATION_LAST_TOUCH_EXPLORED = 2;
    private static final float MAX_DRAGGING_ANGLE_COS = 0.52532196f;
    private static final int ALL_POINTER_ID_BITS = -1;
    private static final int MAX_POINTER_COUNT = 32;
    private static final int INVALID_POINTER_ID = -1;
    private static final int MIN_POINTER_DISTANCE_TO_USE_MIDDLE_LOCATION_DIP = 200;
    private static final int EXIT_GESTURE_DETECTION_TIMEOUT = 2000;
    private final int mDetermineUserIntentTimeout;
    private final int mDoubleTapSlop;
    private int mCurrentState = 1;
    private int mDraggingPointerId;
    private final Handler mHandler;
    private final SendHoverEnterAndMoveDelayed mSendHoverEnterAndMoveDelayed;
    private final SendHoverExitDelayed mSendHoverExitDelayed;
    private final SendAccessibilityEventDelayed mSendTouchExplorationEndDelayed;
    private final SendAccessibilityEventDelayed mSendTouchInteractionEndDelayed;
    private final ExitGestureDetectionModeDelayed mExitGestureDetectionModeDelayed;
    private final AccessibilityGestureDetector mGestureDetector;
    private final int mScaledMinPointerDistanceToUseMiddleLocation;
    private final ReceivedPointerTracker mReceivedPointerTracker;
    private final InjectedPointerTracker mInjectedPointerTracker;
    private final AccessibilityManagerService mAms;
    private final Point mTempPoint = new Point();
    private final Context mContext;
    private int mLongPressingPointerId = -1;
    private int mLongPressingPointerDeltaX;
    private int mLongPressingPointerDeltaY;
    private int mLastTouchedWindowId;
    private boolean mTouchExplorationInProgress;

    public TouchExplorer(Context context, AccessibilityManagerService service) {
        this.mContext = context;
        this.mAms = service;
        this.mReceivedPointerTracker = new ReceivedPointerTracker();
        this.mInjectedPointerTracker = new InjectedPointerTracker();
        this.mDetermineUserIntentTimeout = ViewConfiguration.getDoubleTapTimeout();
        this.mDoubleTapSlop = ViewConfiguration.get(context).getScaledDoubleTapSlop();
        this.mHandler = new Handler(context.getMainLooper());
        this.mExitGestureDetectionModeDelayed = new ExitGestureDetectionModeDelayed();
        this.mSendHoverEnterAndMoveDelayed = new SendHoverEnterAndMoveDelayed();
        this.mSendHoverExitDelayed = new SendHoverExitDelayed();
        this.mSendTouchExplorationEndDelayed = new SendAccessibilityEventDelayed(1024, this.mDetermineUserIntentTimeout);
        this.mSendTouchInteractionEndDelayed = new SendAccessibilityEventDelayed(0x200000, this.mDetermineUserIntentTimeout);
        this.mGestureDetector = new AccessibilityGestureDetector(context, this);
        float density = context.getResources().getDisplayMetrics().density;
        this.mScaledMinPointerDistanceToUseMiddleLocation = (int)(200.0f * density);
    }

    @Override
    public void clearEvents(int inputSource) {
        if (inputSource == 4098) {
            this.clear();
        }
        super.clearEvents(inputSource);
    }

    @Override
    public void onDestroy() {
        this.clear();
    }

    private void clear() {
        MotionEvent event = this.mReceivedPointerTracker.getLastReceivedEvent();
        if (event != null) {
            this.clear(this.mReceivedPointerTracker.getLastReceivedEvent(), 0x2000000);
        }
    }

    private void clear(MotionEvent event, int policyFlags) {
        switch (this.mCurrentState) {
            case 1: {
                this.sendHoverExitAndTouchExplorationGestureEndIfNeeded(policyFlags);
                break;
            }
            case 2: {
                this.mDraggingPointerId = -1;
                this.sendUpForInjectedDownPointers(event, policyFlags);
                break;
            }
            case 4: {
                this.sendUpForInjectedDownPointers(event, policyFlags);
                break;
            }
        }
        this.mSendHoverEnterAndMoveDelayed.cancel();
        this.mSendHoverExitDelayed.cancel();
        this.mExitGestureDetectionModeDelayed.cancel();
        this.mSendTouchExplorationEndDelayed.cancel();
        this.mSendTouchInteractionEndDelayed.cancel();
        this.mReceivedPointerTracker.clear();
        this.mInjectedPointerTracker.clear();
        this.mGestureDetector.clear();
        this.mLongPressingPointerId = -1;
        this.mLongPressingPointerDeltaX = 0;
        this.mLongPressingPointerDeltaY = 0;
        this.mCurrentState = 1;
        this.mTouchExplorationInProgress = false;
        this.mAms.onTouchInteractionEnd();
    }

    @Override
    public void onMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
        if (!event.isFromSource(4098)) {
            super.onMotionEvent(event, rawEvent, policyFlags);
            return;
        }
        this.mReceivedPointerTracker.onMotionEvent(rawEvent);
        if (this.mGestureDetector.onMotionEvent(rawEvent, policyFlags)) {
            return;
        }
        if (event.getActionMasked() == 3) {
            this.clear(event, policyFlags);
            return;
        }
        switch (this.mCurrentState) {
            case 1: {
                this.handleMotionEventStateTouchExploring(event, rawEvent, policyFlags);
                break;
            }
            case 2: {
                this.handleMotionEventStateDragging(event, policyFlags);
                break;
            }
            case 4: {
                this.handleMotionEventStateDelegating(event, policyFlags);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalStateException("Illegal state: " + this.mCurrentState);
            }
        }
    }

    @Override
    public void onAccessibilityEvent(AccessibilityEvent event) {
        int eventType = event.getEventType();
        if (this.mSendTouchExplorationEndDelayed.isPending() && eventType == 256) {
            this.mSendTouchExplorationEndDelayed.cancel();
            this.sendAccessibilityEvent(1024);
        }
        if (this.mSendTouchInteractionEndDelayed.isPending() && eventType == 256) {
            this.mSendTouchInteractionEndDelayed.cancel();
            this.sendAccessibilityEvent(0x200000);
        }
        switch (eventType) {
            case 32: 
            case 32768: {
                if (this.mInjectedPointerTracker.mLastInjectedHoverEventForClick != null) {
                    this.mInjectedPointerTracker.mLastInjectedHoverEventForClick.recycle();
                    this.mInjectedPointerTracker.mLastInjectedHoverEventForClick = null;
                }
                this.mLastTouchedWindowId = -1;
                break;
            }
            case 128: 
            case 256: {
                this.mLastTouchedWindowId = event.getWindowId();
            }
        }
        super.onAccessibilityEvent(event);
    }

    @Override
    public void onDoubleTapAndHold(MotionEvent event, int policyFlags) {
        if (this.mCurrentState != 1) {
            return;
        }
        if (this.mReceivedPointerTracker.getLastReceivedEvent().getPointerCount() == 0) {
            return;
        }
        int pointerIndex = event.getActionIndex();
        int pointerId = event.getPointerId(pointerIndex);
        Point clickLocation = this.mTempPoint;
        int result = this.computeClickLocation(clickLocation);
        if (result == 0) {
            return;
        }
        this.mLongPressingPointerId = pointerId;
        this.mLongPressingPointerDeltaX = (int)event.getX(pointerIndex) - clickLocation.x;
        this.mLongPressingPointerDeltaY = (int)event.getY(pointerIndex) - clickLocation.y;
        this.sendHoverExitAndTouchExplorationGestureEndIfNeeded(policyFlags);
        this.mCurrentState = 4;
        this.sendDownForAllNotInjectedPointers(event, policyFlags);
    }

    @Override
    public boolean onDoubleTap(MotionEvent event, int policyFlags) {
        if (this.mCurrentState != 1) {
            return false;
        }
        this.mSendHoverEnterAndMoveDelayed.cancel();
        this.mSendHoverExitDelayed.cancel();
        if (this.mSendTouchExplorationEndDelayed.isPending()) {
            this.mSendTouchExplorationEndDelayed.forceSendAndRemove();
        }
        if (this.mSendTouchInteractionEndDelayed.isPending()) {
            this.mSendTouchInteractionEndDelayed.forceSendAndRemove();
        }
        if (this.mAms.performActionOnAccessibilityFocusedItem(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLICK)) {
            return true;
        }
        Slog.e(LOG_TAG, "ACTION_CLICK failed. Dispatching motion events to simulate click.");
        int pointerIndex = event.getActionIndex();
        int pointerId = event.getPointerId(pointerIndex);
        Point clickLocation = this.mTempPoint;
        int result = this.computeClickLocation(clickLocation);
        if (result == 0) {
            return true;
        }
        MotionEvent.PointerProperties[] properties = new MotionEvent.PointerProperties[]{new MotionEvent.PointerProperties()};
        event.getPointerProperties(pointerIndex, properties[0]);
        MotionEvent.PointerCoords[] coords = new MotionEvent.PointerCoords[]{new MotionEvent.PointerCoords()};
        coords[0].x = clickLocation.x;
        coords[0].y = clickLocation.y;
        MotionEvent click_event = MotionEvent.obtain(event.getDownTime(), event.getEventTime(), 0, 1, properties, coords, 0, 0, 1.0f, 1.0f, event.getDeviceId(), 0, event.getSource(), event.getFlags());
        boolean targetAccessibilityFocus = result == 1;
        this.sendActionDownAndUp(click_event, policyFlags, targetAccessibilityFocus);
        click_event.recycle();
        return true;
    }

    @Override
    public boolean onGestureStarted() {
        this.mCurrentState = 5;
        this.mSendHoverEnterAndMoveDelayed.cancel();
        this.mSendHoverExitDelayed.cancel();
        this.mExitGestureDetectionModeDelayed.post();
        this.sendAccessibilityEvent(262144);
        return false;
    }

    @Override
    public boolean onGestureCompleted(int gestureId) {
        if (this.mCurrentState != 5) {
            return false;
        }
        this.endGestureDetection();
        this.mAms.onGesture(gestureId);
        return true;
    }

    @Override
    public boolean onGestureCancelled(MotionEvent event, int policyFlags) {
        if (this.mCurrentState == 5) {
            this.endGestureDetection();
            return true;
        }
        if (this.mCurrentState == 1 && event.getActionMasked() == 2) {
            int pointerId = this.mReceivedPointerTracker.getPrimaryPointerId();
            int pointerIdBits = 1 << pointerId;
            this.mSendHoverEnterAndMoveDelayed.addEvent(event);
            this.mSendHoverEnterAndMoveDelayed.forceSendAndRemove();
            this.mSendHoverExitDelayed.cancel();
            this.sendMotionEvent(event, 7, pointerIdBits, policyFlags);
            return true;
        }
        return false;
    }

    private void handleMotionEventStateTouchExploring(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
        ReceivedPointerTracker receivedTracker = this.mReceivedPointerTracker;
        block0 : switch (event.getActionMasked()) {
            case 0: {
                this.mAms.onTouchInteractionStart();
                this.sendAccessibilityEvent(0x100000);
                this.mSendHoverEnterAndMoveDelayed.cancel();
                this.mSendHoverExitDelayed.cancel();
                if (this.mSendTouchExplorationEndDelayed.isPending()) {
                    this.mSendTouchExplorationEndDelayed.forceSendAndRemove();
                }
                if (this.mSendTouchInteractionEndDelayed.isPending()) {
                    this.mSendTouchInteractionEndDelayed.forceSendAndRemove();
                }
                if (this.mGestureDetector.firstTapDetected() || this.mTouchExplorationInProgress) break;
                if (!this.mSendHoverEnterAndMoveDelayed.isPending()) {
                    int pointerId = receivedTracker.getPrimaryPointerId();
                    int pointerIdBits = 1 << pointerId;
                    this.mSendHoverEnterAndMoveDelayed.post(event, true, pointerIdBits, policyFlags);
                    break;
                }
                this.mSendHoverEnterAndMoveDelayed.addEvent(event);
                break;
            }
            case 5: {
                this.mSendHoverEnterAndMoveDelayed.cancel();
                this.mSendHoverExitDelayed.cancel();
                break;
            }
            case 2: {
                int pointerId = receivedTracker.getPrimaryPointerId();
                int pointerIndex = event.findPointerIndex(pointerId);
                int pointerIdBits = 1 << pointerId;
                switch (event.getPointerCount()) {
                    case 1: {
                        if (this.mSendHoverEnterAndMoveDelayed.isPending()) {
                            this.mSendHoverEnterAndMoveDelayed.addEvent(event);
                            break;
                        }
                        if (!this.mTouchExplorationInProgress) break block0;
                        this.sendTouchExplorationGestureStartAndHoverEnterIfNeeded(policyFlags);
                        this.sendMotionEvent(event, 7, pointerIdBits, policyFlags);
                        break;
                    }
                    case 2: {
                        if (this.mSendHoverEnterAndMoveDelayed.isPending()) {
                            this.mSendHoverEnterAndMoveDelayed.cancel();
                            this.mSendHoverExitDelayed.cancel();
                        } else if (this.mTouchExplorationInProgress) {
                            float deltaY;
                            float deltaX = receivedTracker.getReceivedPointerDownX(pointerId) - rawEvent.getX(pointerIndex);
                            double moveDelta = Math.hypot(deltaX, deltaY = receivedTracker.getReceivedPointerDownY(pointerId) - rawEvent.getY(pointerIndex));
                            if (moveDelta < (double)this.mDoubleTapSlop) break;
                            this.sendHoverExitAndTouchExplorationGestureEndIfNeeded(policyFlags);
                        }
                        if (this.isDraggingGesture(event)) {
                            this.mCurrentState = 2;
                            this.mDraggingPointerId = pointerId;
                            event.setEdgeFlags(receivedTracker.getLastReceivedDownEdgeFlags());
                            this.sendMotionEvent(event, 0, pointerIdBits, policyFlags);
                            break;
                        }
                        this.mCurrentState = 4;
                        this.sendDownForAllNotInjectedPointers(event, policyFlags);
                        break;
                    }
                    default: {
                        if (this.mSendHoverEnterAndMoveDelayed.isPending()) {
                            this.mSendHoverEnterAndMoveDelayed.cancel();
                            this.mSendHoverExitDelayed.cancel();
                        } else {
                            this.sendHoverExitAndTouchExplorationGestureEndIfNeeded(policyFlags);
                        }
                        this.mCurrentState = 4;
                        this.sendDownForAllNotInjectedPointers(event, policyFlags);
                        break;
                    }
                }
                break;
            }
            case 1: {
                this.mAms.onTouchInteractionEnd();
                int pointerId = event.getPointerId(event.getActionIndex());
                int pointerIdBits = 1 << pointerId;
                if (this.mSendHoverEnterAndMoveDelayed.isPending()) {
                    this.mSendHoverExitDelayed.post(event, pointerIdBits, policyFlags);
                } else {
                    this.sendHoverExitAndTouchExplorationGestureEndIfNeeded(policyFlags);
                }
                if (this.mSendTouchInteractionEndDelayed.isPending()) break;
                this.mSendTouchInteractionEndDelayed.post();
            }
        }
    }

    private void handleMotionEventStateDragging(MotionEvent event, int policyFlags) {
        int pointerIdBits = 0;
        if (event.findPointerIndex(this.mDraggingPointerId) == -1) {
            Slog.e(LOG_TAG, "mDraggingPointerId doesn't match any pointers on current event. mDraggingPointerId: " + Integer.toString(this.mDraggingPointerId) + ", Event: " + event);
            this.mDraggingPointerId = -1;
        } else {
            pointerIdBits = 1 << this.mDraggingPointerId;
        }
        block0 : switch (event.getActionMasked()) {
            case 0: {
                throw new IllegalStateException("Dragging state can be reached only if two pointers are already down");
            }
            case 5: {
                this.mCurrentState = 4;
                if (this.mDraggingPointerId != -1) {
                    this.sendMotionEvent(event, 1, pointerIdBits, policyFlags);
                }
                this.sendDownForAllNotInjectedPointers(event, policyFlags);
                break;
            }
            case 2: {
                if (this.mDraggingPointerId == -1) break;
                switch (event.getPointerCount()) {
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        if (this.isDraggingGesture(event)) {
                            float secondPtrY;
                            float deltaY;
                            float firstPtrX = event.getX(0);
                            float firstPtrY = event.getY(0);
                            float secondPtrX = event.getX(1);
                            float deltaX = firstPtrX - secondPtrX;
                            double distance = Math.hypot(deltaX, deltaY = firstPtrY - (secondPtrY = event.getY(1)));
                            if (distance > (double)this.mScaledMinPointerDistanceToUseMiddleLocation) {
                                event.setLocation(deltaX / 2.0f, deltaY / 2.0f);
                            }
                            this.sendMotionEvent(event, 2, pointerIdBits, policyFlags);
                            break block0;
                        }
                        this.mCurrentState = 4;
                        this.sendMotionEvent(event, 1, pointerIdBits, policyFlags);
                        this.sendDownForAllNotInjectedPointers(event, policyFlags);
                        break block0;
                    }
                }
                this.mCurrentState = 4;
                this.sendMotionEvent(event, 1, pointerIdBits, policyFlags);
                this.sendDownForAllNotInjectedPointers(event, policyFlags);
                break;
            }
            case 6: {
                int pointerId = event.getPointerId(event.getActionIndex());
                if (pointerId != this.mDraggingPointerId) break;
                this.mDraggingPointerId = -1;
                this.sendMotionEvent(event, 1, pointerIdBits, policyFlags);
                break;
            }
            case 1: {
                this.mAms.onTouchInteractionEnd();
                this.sendAccessibilityEvent(0x200000);
                int pointerId = event.getPointerId(event.getActionIndex());
                if (pointerId == this.mDraggingPointerId) {
                    this.mDraggingPointerId = -1;
                    this.sendMotionEvent(event, 1, pointerIdBits, policyFlags);
                }
                this.mCurrentState = 1;
            }
        }
    }

    private void handleMotionEventStateDelegating(MotionEvent event, int policyFlags) {
        switch (event.getActionMasked()) {
            case 0: {
                throw new IllegalStateException("Delegating state can only be reached if there is at least one pointer down!");
            }
            case 1: {
                if (this.mLongPressingPointerId >= 0) {
                    event = this.offsetEvent(event, -this.mLongPressingPointerDeltaX, -this.mLongPressingPointerDeltaY);
                    this.mLongPressingPointerId = -1;
                    this.mLongPressingPointerDeltaX = 0;
                    this.mLongPressingPointerDeltaY = 0;
                }
                this.sendMotionEvent(event, event.getAction(), -1, policyFlags);
                this.mAms.onTouchInteractionEnd();
                this.sendAccessibilityEvent(0x200000);
                this.mCurrentState = 1;
                break;
            }
            default: {
                this.sendMotionEvent(event, event.getAction(), -1, policyFlags);
            }
        }
    }

    private void endGestureDetection() {
        this.mAms.onTouchInteractionEnd();
        this.sendAccessibilityEvent(524288);
        this.sendAccessibilityEvent(0x200000);
        this.mExitGestureDetectionModeDelayed.cancel();
        this.mCurrentState = 1;
    }

    private void sendAccessibilityEvent(int type) {
        AccessibilityManager accessibilityManager = AccessibilityManager.getInstance(this.mContext);
        if (accessibilityManager.isEnabled()) {
            AccessibilityEvent event = AccessibilityEvent.obtain(type);
            event.setWindowId(this.mAms.getActiveWindowId());
            accessibilityManager.sendAccessibilityEvent(event);
            switch (type) {
                case 512: {
                    this.mTouchExplorationInProgress = true;
                    break;
                }
                case 1024: {
                    this.mTouchExplorationInProgress = false;
                }
            }
        }
    }

    private void sendDownForAllNotInjectedPointers(MotionEvent prototype, int policyFlags) {
        InjectedPointerTracker injectedPointers = this.mInjectedPointerTracker;
        int pointerIdBits = 0;
        int pointerCount = prototype.getPointerCount();
        for (int i = 0; i < pointerCount; ++i) {
            int pointerId = prototype.getPointerId(i);
            if (injectedPointers.isInjectedPointerDown(pointerId)) continue;
            int action = this.computeInjectionAction(0, i);
            this.sendMotionEvent(prototype, action, pointerIdBits |= 1 << pointerId, policyFlags);
        }
    }

    private void sendHoverExitAndTouchExplorationGestureEndIfNeeded(int policyFlags) {
        MotionEvent event = this.mInjectedPointerTracker.getLastInjectedHoverEvent();
        if (event != null && event.getActionMasked() != 10) {
            int pointerIdBits = event.getPointerIdBits();
            if (!this.mSendTouchExplorationEndDelayed.isPending()) {
                this.mSendTouchExplorationEndDelayed.post();
            }
            this.sendMotionEvent(event, 10, pointerIdBits, policyFlags);
        }
    }

    private void sendTouchExplorationGestureStartAndHoverEnterIfNeeded(int policyFlags) {
        MotionEvent event = this.mInjectedPointerTracker.getLastInjectedHoverEvent();
        if (event != null && event.getActionMasked() == 10) {
            int pointerIdBits = event.getPointerIdBits();
            this.sendAccessibilityEvent(512);
            this.sendMotionEvent(event, 9, pointerIdBits, policyFlags);
        }
    }

    private void sendUpForInjectedDownPointers(MotionEvent prototype, int policyFlags) {
        InjectedPointerTracker injectedTracked = this.mInjectedPointerTracker;
        int pointerIdBits = 0;
        int pointerCount = prototype.getPointerCount();
        for (int i = 0; i < pointerCount; ++i) {
            int pointerId = prototype.getPointerId(i);
            if (!injectedTracked.isInjectedPointerDown(pointerId)) continue;
            int action = this.computeInjectionAction(1, i);
            this.sendMotionEvent(prototype, action, pointerIdBits |= 1 << pointerId, policyFlags);
        }
    }

    private void sendActionDownAndUp(MotionEvent prototype, int policyFlags, boolean targetAccessibilityFocus) {
        int pointerId = prototype.getPointerId(prototype.getActionIndex());
        int pointerIdBits = 1 << pointerId;
        prototype.setTargetAccessibilityFocus(targetAccessibilityFocus);
        this.sendMotionEvent(prototype, 0, pointerIdBits, policyFlags);
        prototype.setTargetAccessibilityFocus(targetAccessibilityFocus);
        this.sendMotionEvent(prototype, 1, pointerIdBits, policyFlags);
    }

    private void sendMotionEvent(MotionEvent prototype, int action, int pointerIdBits, int policyFlags) {
        prototype.setAction(action);
        MotionEvent event = null;
        if (pointerIdBits == -1) {
            event = prototype;
        } else {
            try {
                event = prototype.split(pointerIdBits);
            }
            catch (IllegalArgumentException e) {
                Slog.e(LOG_TAG, "sendMotionEvent: Failed to split motion event: " + e);
                return;
            }
        }
        if (action == 0) {
            event.setDownTime(event.getEventTime());
        } else {
            event.setDownTime(this.mInjectedPointerTracker.getLastInjectedDownEventTime());
        }
        if (this.mLongPressingPointerId >= 0) {
            event = this.offsetEvent(event, -this.mLongPressingPointerDeltaX, -this.mLongPressingPointerDeltaY);
        }
        super.onMotionEvent(event, null, policyFlags |= 0x40000000);
        this.mInjectedPointerTracker.onMotionEvent(event);
        if (event != prototype) {
            event.recycle();
        }
    }

    private MotionEvent offsetEvent(MotionEvent event, int offsetX, int offsetY) {
        if (offsetX == 0 && offsetY == 0) {
            return event;
        }
        int remappedIndex = event.findPointerIndex(this.mLongPressingPointerId);
        int pointerCount = event.getPointerCount();
        MotionEvent.PointerProperties[] props = MotionEvent.PointerProperties.createArray(pointerCount);
        MotionEvent.PointerCoords[] coords = MotionEvent.PointerCoords.createArray(pointerCount);
        for (int i = 0; i < pointerCount; ++i) {
            event.getPointerProperties(i, props[i]);
            event.getPointerCoords(i, coords[i]);
            if (i != remappedIndex) continue;
            coords[i].x += (float)offsetX;
            coords[i].y += (float)offsetY;
        }
        return MotionEvent.obtain(event.getDownTime(), event.getEventTime(), event.getAction(), event.getPointerCount(), props, coords, event.getMetaState(), event.getButtonState(), 1.0f, 1.0f, event.getDeviceId(), event.getEdgeFlags(), event.getSource(), event.getFlags());
    }

    private int computeInjectionAction(int actionMasked, int pointerIndex) {
        switch (actionMasked) {
            case 0: 
            case 5: {
                InjectedPointerTracker injectedTracker = this.mInjectedPointerTracker;
                if (injectedTracker.getInjectedPointerDownCount() == 0) {
                    return 0;
                }
                return pointerIndex << 8 | 5;
            }
            case 6: {
                InjectedPointerTracker injectedTracker = this.mInjectedPointerTracker;
                if (injectedTracker.getInjectedPointerDownCount() == 1) {
                    return 1;
                }
                return pointerIndex << 8 | 6;
            }
        }
        return actionMasked;
    }

    private boolean isDraggingGesture(MotionEvent event) {
        ReceivedPointerTracker receivedTracker = this.mReceivedPointerTracker;
        float firstPtrX = event.getX(0);
        float firstPtrY = event.getY(0);
        float secondPtrX = event.getX(1);
        float secondPtrY = event.getY(1);
        float firstPtrDownX = receivedTracker.getReceivedPointerDownX(0);
        float firstPtrDownY = receivedTracker.getReceivedPointerDownY(0);
        float secondPtrDownX = receivedTracker.getReceivedPointerDownX(1);
        float secondPtrDownY = receivedTracker.getReceivedPointerDownY(1);
        return GestureUtils.isDraggingGesture(firstPtrDownX, firstPtrDownY, secondPtrDownX, secondPtrDownY, firstPtrX, firstPtrY, secondPtrX, secondPtrY, 0.52532196f);
    }

    private int computeClickLocation(Point outLocation) {
        MotionEvent lastExploreEvent = this.mInjectedPointerTracker.getLastInjectedHoverEventForClick();
        if (lastExploreEvent != null) {
            int lastExplorePointerIndex = lastExploreEvent.getActionIndex();
            outLocation.x = (int)lastExploreEvent.getX(lastExplorePointerIndex);
            outLocation.y = (int)lastExploreEvent.getY(lastExplorePointerIndex);
            if (!this.mAms.accessibilityFocusOnlyInActiveWindow() || this.mLastTouchedWindowId == this.mAms.getActiveWindowId()) {
                if (this.mAms.getAccessibilityFocusClickPointInScreen(outLocation)) {
                    return 1;
                }
                return 2;
            }
        }
        if (this.mAms.getAccessibilityFocusClickPointInScreen(outLocation)) {
            return 1;
        }
        return 0;
    }

    private static String getStateSymbolicName(int state) {
        switch (state) {
            case 1: {
                return "STATE_TOUCH_EXPLORING";
            }
            case 2: {
                return "STATE_DRAGGING";
            }
            case 4: {
                return "STATE_DELEGATING";
            }
            case 5: {
                return "STATE_GESTURE_DETECTING";
            }
        }
        throw new IllegalArgumentException("Unknown state: " + state);
    }

    public String toString() {
        return LOG_TAG;
    }

    class ReceivedPointerTracker {
        private static final String LOG_TAG_RECEIVED_POINTER_TRACKER = "ReceivedPointerTracker";
        private final float[] mReceivedPointerDownX = new float[32];
        private final float[] mReceivedPointerDownY = new float[32];
        private final long[] mReceivedPointerDownTime = new long[32];
        private int mReceivedPointersDown;
        private int mLastReceivedDownEdgeFlags;
        private int mPrimaryPointerId;
        private long mLastReceivedUpPointerDownTime;
        private float mLastReceivedUpPointerDownX;
        private float mLastReceivedUpPointerDownY;
        private MotionEvent mLastReceivedEvent;

        ReceivedPointerTracker() {
        }

        public void clear() {
            Arrays.fill(this.mReceivedPointerDownX, 0.0f);
            Arrays.fill(this.mReceivedPointerDownY, 0.0f);
            Arrays.fill(this.mReceivedPointerDownTime, 0L);
            this.mReceivedPointersDown = 0;
            this.mPrimaryPointerId = 0;
            this.mLastReceivedUpPointerDownTime = 0L;
            this.mLastReceivedUpPointerDownX = 0.0f;
            this.mLastReceivedUpPointerDownY = 0.0f;
        }

        public void onMotionEvent(MotionEvent event) {
            if (this.mLastReceivedEvent != null) {
                this.mLastReceivedEvent.recycle();
            }
            this.mLastReceivedEvent = MotionEvent.obtain(event);
            int action = event.getActionMasked();
            switch (action) {
                case 0: {
                    this.handleReceivedPointerDown(event.getActionIndex(), event);
                    break;
                }
                case 5: {
                    this.handleReceivedPointerDown(event.getActionIndex(), event);
                    break;
                }
                case 1: {
                    this.handleReceivedPointerUp(event.getActionIndex(), event);
                    break;
                }
                case 6: {
                    this.handleReceivedPointerUp(event.getActionIndex(), event);
                }
            }
        }

        public MotionEvent getLastReceivedEvent() {
            return this.mLastReceivedEvent;
        }

        public int getReceivedPointerDownCount() {
            return Integer.bitCount(this.mReceivedPointersDown);
        }

        public boolean isReceivedPointerDown(int pointerId) {
            int pointerFlag = 1 << pointerId;
            return (this.mReceivedPointersDown & pointerFlag) != 0;
        }

        public float getReceivedPointerDownX(int pointerId) {
            return this.mReceivedPointerDownX[pointerId];
        }

        public float getReceivedPointerDownY(int pointerId) {
            return this.mReceivedPointerDownY[pointerId];
        }

        public long getReceivedPointerDownTime(int pointerId) {
            return this.mReceivedPointerDownTime[pointerId];
        }

        public int getPrimaryPointerId() {
            if (this.mPrimaryPointerId == -1) {
                this.mPrimaryPointerId = this.findPrimaryPointerId();
            }
            return this.mPrimaryPointerId;
        }

        public long getLastReceivedUpPointerDownTime() {
            return this.mLastReceivedUpPointerDownTime;
        }

        public float getLastReceivedUpPointerDownX() {
            return this.mLastReceivedUpPointerDownX;
        }

        public float getLastReceivedUpPointerDownY() {
            return this.mLastReceivedUpPointerDownY;
        }

        public int getLastReceivedDownEdgeFlags() {
            return this.mLastReceivedDownEdgeFlags;
        }

        private void handleReceivedPointerDown(int pointerIndex, MotionEvent event) {
            int pointerId = event.getPointerId(pointerIndex);
            int pointerFlag = 1 << pointerId;
            this.mLastReceivedUpPointerDownTime = 0L;
            this.mLastReceivedUpPointerDownX = 0.0f;
            this.mLastReceivedUpPointerDownX = 0.0f;
            this.mLastReceivedDownEdgeFlags = event.getEdgeFlags();
            this.mReceivedPointersDown |= pointerFlag;
            this.mReceivedPointerDownX[pointerId] = event.getX(pointerIndex);
            this.mReceivedPointerDownY[pointerId] = event.getY(pointerIndex);
            this.mReceivedPointerDownTime[pointerId] = event.getEventTime();
            this.mPrimaryPointerId = pointerId;
        }

        private void handleReceivedPointerUp(int pointerIndex, MotionEvent event) {
            int pointerId = event.getPointerId(pointerIndex);
            int pointerFlag = 1 << pointerId;
            this.mLastReceivedUpPointerDownTime = this.getReceivedPointerDownTime(pointerId);
            this.mLastReceivedUpPointerDownX = this.mReceivedPointerDownX[pointerId];
            this.mLastReceivedUpPointerDownY = this.mReceivedPointerDownY[pointerId];
            this.mReceivedPointersDown &= ~pointerFlag;
            this.mReceivedPointerDownX[pointerId] = 0.0f;
            this.mReceivedPointerDownY[pointerId] = 0.0f;
            this.mReceivedPointerDownTime[pointerId] = 0L;
            if (this.mPrimaryPointerId == pointerId) {
                this.mPrimaryPointerId = -1;
            }
        }

        private int findPrimaryPointerId() {
            int pointerId;
            int primaryPointerId = -1;
            long minDownTime = Long.MAX_VALUE;
            for (int pointerIdBits = this.mReceivedPointersDown; pointerIdBits > 0; pointerIdBits &= ~(1 << pointerId)) {
                pointerId = Integer.numberOfTrailingZeros(pointerIdBits);
                long downPointerTime = this.mReceivedPointerDownTime[pointerId];
                if (downPointerTime >= minDownTime) continue;
                minDownTime = downPointerTime;
                primaryPointerId = pointerId;
            }
            return primaryPointerId;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("=========================");
            builder.append("\nDown pointers #");
            builder.append(this.getReceivedPointerDownCount());
            builder.append(" [ ");
            for (int i = 0; i < 32; ++i) {
                if (!this.isReceivedPointerDown(i)) continue;
                builder.append(i);
                builder.append(" ");
            }
            builder.append("]");
            builder.append("\nPrimary pointer id [ ");
            builder.append(this.getPrimaryPointerId());
            builder.append(" ]");
            builder.append("\n=========================");
            return builder.toString();
        }
    }

    class InjectedPointerTracker {
        private static final String LOG_TAG_INJECTED_POINTER_TRACKER = "InjectedPointerTracker";
        private int mInjectedPointersDown;
        private long mLastInjectedDownEventTime;
        private MotionEvent mLastInjectedHoverEvent;
        private MotionEvent mLastInjectedHoverEventForClick;

        InjectedPointerTracker() {
        }

        public void onMotionEvent(MotionEvent event) {
            int action = event.getActionMasked();
            switch (action) {
                case 0: 
                case 5: {
                    int pointerId = event.getPointerId(event.getActionIndex());
                    int pointerFlag = 1 << pointerId;
                    this.mInjectedPointersDown |= pointerFlag;
                    this.mLastInjectedDownEventTime = event.getDownTime();
                    break;
                }
                case 1: 
                case 6: {
                    int pointerId = event.getPointerId(event.getActionIndex());
                    int pointerFlag = 1 << pointerId;
                    this.mInjectedPointersDown &= ~pointerFlag;
                    if (this.mInjectedPointersDown != 0) break;
                    this.mLastInjectedDownEventTime = 0L;
                    break;
                }
                case 7: 
                case 9: 
                case 10: {
                    if (this.mLastInjectedHoverEvent != null) {
                        this.mLastInjectedHoverEvent.recycle();
                    }
                    this.mLastInjectedHoverEvent = MotionEvent.obtain(event);
                    if (this.mLastInjectedHoverEventForClick != null) {
                        this.mLastInjectedHoverEventForClick.recycle();
                    }
                    this.mLastInjectedHoverEventForClick = MotionEvent.obtain(event);
                }
            }
        }

        public void clear() {
            this.mInjectedPointersDown = 0;
        }

        public long getLastInjectedDownEventTime() {
            return this.mLastInjectedDownEventTime;
        }

        public int getInjectedPointerDownCount() {
            return Integer.bitCount(this.mInjectedPointersDown);
        }

        public int getInjectedPointersDown() {
            return this.mInjectedPointersDown;
        }

        public boolean isInjectedPointerDown(int pointerId) {
            int pointerFlag = 1 << pointerId;
            return (this.mInjectedPointersDown & pointerFlag) != 0;
        }

        public MotionEvent getLastInjectedHoverEvent() {
            return this.mLastInjectedHoverEvent;
        }

        public MotionEvent getLastInjectedHoverEventForClick() {
            return this.mLastInjectedHoverEventForClick;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("=========================");
            builder.append("\nDown pointers #");
            builder.append(Integer.bitCount(this.mInjectedPointersDown));
            builder.append(" [ ");
            for (int i = 0; i < 32; ++i) {
                if ((this.mInjectedPointersDown & i) == 0) continue;
                builder.append(i);
                builder.append(" ");
            }
            builder.append("]");
            builder.append("\n=========================");
            return builder.toString();
        }
    }

    private class SendAccessibilityEventDelayed
    implements Runnable {
        private final int mEventType;
        private final int mDelay;

        public SendAccessibilityEventDelayed(int eventType, int delay) {
            this.mEventType = eventType;
            this.mDelay = delay;
        }

        public void cancel() {
            TouchExplorer.this.mHandler.removeCallbacks(this);
        }

        public void post() {
            TouchExplorer.this.mHandler.postDelayed(this, this.mDelay);
        }

        public boolean isPending() {
            return TouchExplorer.this.mHandler.hasCallbacks(this);
        }

        public void forceSendAndRemove() {
            if (this.isPending()) {
                this.run();
                this.cancel();
            }
        }

        @Override
        public void run() {
            TouchExplorer.this.sendAccessibilityEvent(this.mEventType);
        }
    }

    class SendHoverExitDelayed
    implements Runnable {
        private final String LOG_TAG_SEND_HOVER_DELAYED = "SendHoverExitDelayed";
        private MotionEvent mPrototype;
        private int mPointerIdBits;
        private int mPolicyFlags;

        SendHoverExitDelayed() {
        }

        public void post(MotionEvent prototype, int pointerIdBits, int policyFlags) {
            this.cancel();
            this.mPrototype = MotionEvent.obtain(prototype);
            this.mPointerIdBits = pointerIdBits;
            this.mPolicyFlags = policyFlags;
            TouchExplorer.this.mHandler.postDelayed(this, TouchExplorer.this.mDetermineUserIntentTimeout);
        }

        public void cancel() {
            if (this.isPending()) {
                TouchExplorer.this.mHandler.removeCallbacks(this);
                this.clear();
            }
        }

        private boolean isPending() {
            return TouchExplorer.this.mHandler.hasCallbacks(this);
        }

        private void clear() {
            this.mPrototype.recycle();
            this.mPrototype = null;
            this.mPointerIdBits = -1;
            this.mPolicyFlags = 0;
        }

        public void forceSendAndRemove() {
            if (this.isPending()) {
                this.run();
                this.cancel();
            }
        }

        @Override
        public void run() {
            TouchExplorer.this.sendMotionEvent(this.mPrototype, 10, this.mPointerIdBits, this.mPolicyFlags);
            if (!TouchExplorer.this.mSendTouchExplorationEndDelayed.isPending()) {
                TouchExplorer.this.mSendTouchExplorationEndDelayed.cancel();
                TouchExplorer.this.mSendTouchExplorationEndDelayed.post();
            }
            if (TouchExplorer.this.mSendTouchInteractionEndDelayed.isPending()) {
                TouchExplorer.this.mSendTouchInteractionEndDelayed.cancel();
                TouchExplorer.this.mSendTouchInteractionEndDelayed.post();
            }
            this.clear();
        }
    }

    class SendHoverEnterAndMoveDelayed
    implements Runnable {
        private final String LOG_TAG_SEND_HOVER_DELAYED = "SendHoverEnterAndMoveDelayed";
        private final List<MotionEvent> mEvents = new ArrayList<MotionEvent>();
        private int mPointerIdBits;
        private int mPolicyFlags;

        SendHoverEnterAndMoveDelayed() {
        }

        public void post(MotionEvent event, boolean touchExplorationInProgress, int pointerIdBits, int policyFlags) {
            this.cancel();
            this.addEvent(event);
            this.mPointerIdBits = pointerIdBits;
            this.mPolicyFlags = policyFlags;
            TouchExplorer.this.mHandler.postDelayed(this, TouchExplorer.this.mDetermineUserIntentTimeout);
        }

        public void addEvent(MotionEvent event) {
            this.mEvents.add(MotionEvent.obtain(event));
        }

        public void cancel() {
            if (this.isPending()) {
                TouchExplorer.this.mHandler.removeCallbacks(this);
                this.clear();
            }
        }

        private boolean isPending() {
            return TouchExplorer.this.mHandler.hasCallbacks(this);
        }

        private void clear() {
            this.mPointerIdBits = -1;
            this.mPolicyFlags = 0;
            int eventCount = this.mEvents.size();
            for (int i = eventCount - 1; i >= 0; --i) {
                this.mEvents.remove(i).recycle();
            }
        }

        public void forceSendAndRemove() {
            if (this.isPending()) {
                this.run();
                this.cancel();
            }
        }

        @Override
        public void run() {
            TouchExplorer.this.sendAccessibilityEvent(512);
            if (!this.mEvents.isEmpty()) {
                TouchExplorer.this.sendMotionEvent(this.mEvents.get(0), 9, this.mPointerIdBits, this.mPolicyFlags);
                int eventCount = this.mEvents.size();
                for (int i = 1; i < eventCount; ++i) {
                    TouchExplorer.this.sendMotionEvent(this.mEvents.get(i), 7, this.mPointerIdBits, this.mPolicyFlags);
                }
            }
            this.clear();
        }
    }

    private final class ExitGestureDetectionModeDelayed
    implements Runnable {
        private ExitGestureDetectionModeDelayed() {
        }

        public void post() {
            TouchExplorer.this.mHandler.postDelayed(this, 2000L);
        }

        public void cancel() {
            TouchExplorer.this.mHandler.removeCallbacks(this);
        }

        @Override
        public void run() {
            TouchExplorer.this.sendAccessibilityEvent(524288);
            TouchExplorer.this.sendAccessibilityEvent(512);
            TouchExplorer.this.clear();
        }
    }
}

