/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accounts;

import android.accounts.Account;
import android.accounts.AccountAndUser;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManagerInternal;
import android.accounts.AccountManagerResponse;
import android.accounts.AuthenticatorDescription;
import android.accounts.CantAddAccountActivity;
import android.accounts.ChooseAccountActivity;
import android.accounts.GrantCredentialsPermissionActivity;
import android.accounts.IAccountAuthenticator;
import android.accounts.IAccountAuthenticatorResponse;
import android.accounts.IAccountManager;
import android.accounts.IAccountManagerResponse;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.AppOpsManager;
import android.app.INotificationManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.admin.DevicePolicyManager;
import android.app.admin.DevicePolicyManagerInternal;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.RegisteredServicesCache;
import android.content.pm.RegisteredServicesCacheListener;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.content.pm.UserInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.content.PackageMonitor;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.server.LocalServices;
import com.android.server.ServiceThread;
import com.android.server.SystemService;
import com.android.server.accounts.AccountAuthenticatorCache;
import com.android.server.accounts.AccountManagerBackupHelper;
import com.android.server.accounts.AccountsDb;
import com.android.server.accounts.CryptoHelper;
import com.android.server.accounts.IAccountAuthenticatorCache;
import com.android.server.accounts.TokenCache;
import com.google.android.collect.Lists;
import com.google.android.collect.Sets;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

public class AccountManagerService
extends IAccountManager.Stub
implements RegisteredServicesCacheListener<AuthenticatorDescription> {
    private static final String TAG = "AccountManagerService";
    final Context mContext;
    private final PackageManager mPackageManager;
    private final AppOpsManager mAppOpsManager;
    private UserManager mUserManager;
    private final Injector mInjector;
    final MessageHandler mHandler;
    private static final int MESSAGE_TIMED_OUT = 3;
    private static final int MESSAGE_COPY_SHARED_ACCOUNT = 4;
    private final IAccountAuthenticatorCache mAuthenticatorCache;
    private static final String PRE_N_DATABASE_NAME = "accounts.db";
    private static final Intent ACCOUNTS_CHANGED_INTENT = new Intent("android.accounts.LOGIN_ACCOUNTS_CHANGED");
    private static final int SIGNATURE_CHECK_MISMATCH = 0;
    private static final int SIGNATURE_CHECK_MATCH = 1;
    private static final int SIGNATURE_CHECK_UID_MATCH = 2;
    private final LinkedHashMap<String, Session> mSessions = new LinkedHashMap();
    private final SparseArray<UserAccounts> mUsers = new SparseArray();
    private final SparseBooleanArray mLocalUnlockedUsers = new SparseBooleanArray();
    private final SimpleDateFormat mDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private CopyOnWriteArrayList<AccountManagerInternal.OnAppPermissionChangeListener> mAppPermissionChangeListeners = new CopyOnWriteArrayList();
    private static AtomicReference<AccountManagerService> sThis;
    private static final Account[] EMPTY_ACCOUNT_ARRAY;

    public static AccountManagerService getSingleton() {
        return sThis.get();
    }

    public AccountManagerService(Injector injector) {
        this.mInjector = injector;
        this.mContext = injector.getContext();
        this.mPackageManager = this.mContext.getPackageManager();
        this.mAppOpsManager = this.mContext.getSystemService(AppOpsManager.class);
        this.mHandler = new MessageHandler(injector.getMessageHandlerLooper());
        this.mAuthenticatorCache = this.mInjector.getAccountAuthenticatorCache();
        this.mAuthenticatorCache.setListener(this, null);
        sThis.set(this);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addDataScheme("package");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context1, Intent intent) {
                if (!intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                    final String removedPackageName = intent.getData().getSchemeSpecificPart();
                    Runnable purgingRunnable = new Runnable(){

                        @Override
                        public void run() {
                            AccountManagerService.this.purgeOldGrantsAll();
                            AccountManagerService.this.removeVisibilityValuesForPackage(removedPackageName);
                        }
                    };
                    AccountManagerService.this.mHandler.post(purgingRunnable);
                }
            }
        }, intentFilter);
        injector.addLocalService(new AccountManagerInternalImpl());
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiverAsUser(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.intent.action.USER_REMOVED".equals(action)) {
                    int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
                    if (userId < 1) {
                        return;
                    }
                    Slog.i(AccountManagerService.TAG, "User " + userId + " removed");
                    AccountManagerService.this.purgeUserData(userId);
                }
            }
        }, UserHandle.ALL, userFilter, null, null);
        new PackageMonitor(){

            @Override
            public void onPackageAdded(String packageName, int uid) {
                AccountManagerService.this.cancelAccountAccessRequestNotificationIfNeeded(uid, true);
            }

            @Override
            public void onPackageUpdateFinished(String packageName, int uid) {
                AccountManagerService.this.cancelAccountAccessRequestNotificationIfNeeded(uid, true);
            }
        }.register(this.mContext, this.mHandler.getLooper(), UserHandle.ALL, true);
        this.mAppOpsManager.startWatchingMode(62, null, (AppOpsManager.OnOpChangedListener)new AppOpsManager.OnOpChangedInternalListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOpChanged(int op, String packageName) {
                block5: {
                    try {
                        int userId = ActivityManager.getCurrentUser();
                        int uid = AccountManagerService.this.mPackageManager.getPackageUidAsUser(packageName, userId);
                        int mode = AccountManagerService.this.mAppOpsManager.checkOpNoThrow(62, uid, packageName);
                        if (mode != 0) break block5;
                        long identity = Binder.clearCallingIdentity();
                        try {
                            AccountManagerService.this.cancelAccountAccessRequestNotificationIfNeeded(packageName, uid, true);
                        }
                        finally {
                            Binder.restoreCallingIdentity(identity);
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                }
            }
        });
        this.mPackageManager.addOnPermissionsChangeListener(uid -> {
            Account[] accounts = null;
            String[] packageNames = this.mPackageManager.getPackagesForUid(uid);
            if (packageNames != null) {
                int userId = UserHandle.getUserId(uid);
                long identity = Binder.clearCallingIdentity();
                try {
                    for (String packageName : packageNames) {
                        if (this.mPackageManager.checkPermission("android.permission.GET_ACCOUNTS", packageName) != 0) continue;
                        if (accounts == null && ArrayUtils.isEmpty(accounts = this.getAccountsAsUser(null, userId, "android"))) {
                            return;
                        }
                        for (Account account : accounts) {
                            this.cancelAccountAccessRequestNotificationIfNeeded(account, uid, packageName, true);
                        }
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        });
    }

    private void cancelAccountAccessRequestNotificationIfNeeded(int uid, boolean checkAccess) {
        Account[] accounts;
        for (Account account : accounts = this.getAccountsAsUser(null, UserHandle.getUserId(uid), "android")) {
            this.cancelAccountAccessRequestNotificationIfNeeded(account, uid, checkAccess);
        }
    }

    private void cancelAccountAccessRequestNotificationIfNeeded(String packageName, int uid, boolean checkAccess) {
        Account[] accounts;
        for (Account account : accounts = this.getAccountsAsUser(null, UserHandle.getUserId(uid), "android")) {
            this.cancelAccountAccessRequestNotificationIfNeeded(account, uid, packageName, checkAccess);
        }
    }

    private void cancelAccountAccessRequestNotificationIfNeeded(Account account, int uid, boolean checkAccess) {
        String[] packageNames = this.mPackageManager.getPackagesForUid(uid);
        if (packageNames != null) {
            for (String packageName : packageNames) {
                this.cancelAccountAccessRequestNotificationIfNeeded(account, uid, packageName, checkAccess);
            }
        }
    }

    private void cancelAccountAccessRequestNotificationIfNeeded(Account account, int uid, String packageName, boolean checkAccess) {
        if (!checkAccess || this.hasAccountAccess(account, packageName, UserHandle.getUserHandleForUid(uid))) {
            this.cancelNotification(this.getCredentialPermissionNotificationId(account, "com.android.AccountManager.ACCOUNT_ACCESS_TOKEN_TYPE", uid), packageName, UserHandle.getUserHandleForUid(uid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAccountExplicitlyWithVisibility(Account account, String password, Bundle extras, Map packageToVisibility) {
        Bundle.setDefusable(extras, true);
        int callingUid = Binder.getCallingUid();
        int userId = UserHandle.getCallingUserId();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "addAccountExplicitly: " + account + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        Preconditions.checkNotNull(account, "account cannot be null");
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot explicitly add accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            boolean bl = this.addAccountInternal(accounts, account, password, extras, callingUid, packageToVisibility);
            return bl;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Account, Integer> getAccountsAndVisibilityForPackage(String packageName, String accountType) {
        int callingUid = Binder.getCallingUid();
        int userId = UserHandle.getCallingUserId();
        boolean isSystemUid = UserHandle.isSameApp(callingUid, 1000);
        List<String> managedTypes = this.getTypesForCaller(callingUid, userId, isSystemUid);
        if (accountType != null && !managedTypes.contains(accountType) || accountType == null && !isSystemUid) {
            throw new SecurityException("getAccountsAndVisibilityForPackage() called from unauthorized uid " + callingUid + " with packageName=" + packageName);
        }
        if (accountType != null) {
            managedTypes = new ArrayList<String>();
            managedTypes.add(accountType);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            Map<Account, Integer> map = this.getAccountsAndVisibilityForPackage(packageName, managedTypes, callingUid, accounts);
            return map;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Account, Integer> getAccountsAndVisibilityForPackage(String packageName, List<String> accountTypes, Integer callingUid, UserAccounts accounts) {
        if (!this.packageExistsForUser(packageName, accounts.userId)) {
            Log.d(TAG, "Package not found " + packageName);
            return new LinkedHashMap<Account, Integer>();
        }
        LinkedHashMap<Account, Integer> result = new LinkedHashMap<Account, Integer>();
        for (String accountType : accountTypes) {
            Object object = accounts.dbLock;
            synchronized (object) {
                Object object2 = accounts.cacheLock;
                synchronized (object2) {
                    Account[] accountsOfType = accounts.accountCache.get(accountType);
                    if (accountsOfType != null) {
                        for (Account account : accountsOfType) {
                            result.put(account, this.resolveAccountVisibility(account, packageName, accounts));
                        }
                    }
                }
            }
        }
        return this.filterSharedAccounts(accounts, result, callingUid, packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getPackagesAndVisibilityForAccount(Account account) {
        Preconditions.checkNotNull(account, "account cannot be null");
        int callingUid = Binder.getCallingUid();
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId) && !this.isSystemUid(callingUid)) {
            String msg = String.format("uid %s cannot get secrets for account %s", callingUid, account);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            Object object = accounts.dbLock;
            synchronized (object) {
                Object object2 = accounts.cacheLock;
                synchronized (object2) {
                    Map<String, Integer> map = this.getPackagesAndVisibilityForAccountLocked(account, accounts);
                    return map;
                }
            }
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    private Map<String, Integer> getPackagesAndVisibilityForAccountLocked(Account account, UserAccounts accounts) {
        HashMap accountVisibility = (HashMap)accounts.visibilityCache.get(account);
        if (accountVisibility == null) {
            Log.d(TAG, "Visibility was not initialized");
            accountVisibility = new HashMap();
            accounts.visibilityCache.put(account, accountVisibility);
        }
        return accountVisibility;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAccountVisibility(Account account, String packageName) {
        Preconditions.checkNotNull(account, "account cannot be null");
        Preconditions.checkNotNull(packageName, "packageName cannot be null");
        int callingUid = Binder.getCallingUid();
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId) && !this.isSystemUid(callingUid)) {
            String msg = String.format("uid %s cannot get secrets for accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            if ("android:accounts:key_legacy_visible".equals(packageName)) {
                int visibility = this.getAccountVisibilityFromCache(account, packageName, accounts);
                if (0 != visibility) {
                    int n = visibility;
                    return n;
                }
                int n = 2;
                return n;
            }
            if ("android:accounts:key_legacy_not_visible".equals(packageName)) {
                int visibility = this.getAccountVisibilityFromCache(account, packageName, accounts);
                if (0 != visibility) {
                    int n = visibility;
                    return n;
                }
                int n = 4;
                return n;
            }
            int n = this.resolveAccountVisibility(account, packageName, accounts);
            return n;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAccountVisibilityFromCache(Account account, String packageName, UserAccounts accounts) {
        Object object = accounts.cacheLock;
        synchronized (object) {
            Map<String, Integer> accountVisibility = this.getPackagesAndVisibilityForAccountLocked(account, accounts);
            Integer visibility = accountVisibility.get(packageName);
            return visibility != null ? visibility : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer resolveAccountVisibility(Account account, String packageName, UserAccounts accounts) {
        Preconditions.checkNotNull(packageName, "packageName cannot be null");
        int uid = -1;
        try {
            long identityToken = AccountManagerService.clearCallingIdentity();
            try {
                uid = this.mPackageManager.getPackageUidAsUser(packageName, accounts.userId);
            }
            finally {
                AccountManagerService.restoreCallingIdentity(identityToken);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d(TAG, "Package not found " + e.getMessage());
            return 3;
        }
        if (UserHandle.isSameApp(uid, 1000)) {
            return 1;
        }
        int signatureCheckResult = this.checkPackageSignature(account.type, uid, accounts.userId);
        if (signatureCheckResult == 2) {
            return 1;
        }
        int visibility = this.getAccountVisibilityFromCache(account, packageName, accounts);
        if (0 != visibility) {
            return visibility;
        }
        boolean isPrivileged = this.isPermittedForPackage(packageName, uid, accounts.userId, "android.permission.GET_ACCOUNTS_PRIVILEGED");
        if (this.isProfileOwner(uid)) {
            return 1;
        }
        boolean preO = this.isPreOApplication(packageName);
        if (signatureCheckResult != 0 || preO && this.checkGetAccountsPermission(packageName, uid, accounts.userId) || this.checkReadContactsPermission(packageName, uid, accounts.userId) && this.accountTypeManagesContacts(account.type, accounts.userId) || isPrivileged) {
            visibility = this.getAccountVisibilityFromCache(account, "android:accounts:key_legacy_visible", accounts);
            if (0 == visibility) {
                visibility = 2;
            }
        } else {
            visibility = this.getAccountVisibilityFromCache(account, "android:accounts:key_legacy_not_visible", accounts);
            if (0 == visibility) {
                visibility = 4;
            }
        }
        return visibility;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPreOApplication(String packageName) {
        try {
            ApplicationInfo applicationInfo;
            long identityToken = AccountManagerService.clearCallingIdentity();
            try {
                applicationInfo = this.mPackageManager.getApplicationInfo(packageName, 0);
            }
            finally {
                AccountManagerService.restoreCallingIdentity(identityToken);
            }
            if (applicationInfo != null) {
                int version = applicationInfo.targetSdkVersion;
                return version < 26;
            }
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d(TAG, "Package not found " + e.getMessage());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAccountVisibility(Account account, String packageName, int newVisibility) {
        Preconditions.checkNotNull(account, "account cannot be null");
        Preconditions.checkNotNull(packageName, "packageName cannot be null");
        int callingUid = Binder.getCallingUid();
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId) && !this.isSystemUid(callingUid)) {
            String msg = String.format("uid %s cannot get secrets for accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            boolean bl = this.setAccountVisibility(account, packageName, newVisibility, true, accounts);
            return bl;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    private boolean isVisible(int visibility) {
        return visibility == 1 || visibility == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setAccountVisibility(Account account, String packageName, int newVisibility, boolean notify, UserAccounts accounts) {
        Object object = accounts.dbLock;
        synchronized (object) {
            Object object2 = accounts.cacheLock;
            synchronized (object2) {
                List<Object> accountRemovedReceivers;
                Map<Object, Object> packagesToVisibility;
                if (notify) {
                    if (this.isSpecialPackageKey(packageName)) {
                        packagesToVisibility = this.getRequestingPackages(account, accounts);
                        accountRemovedReceivers = this.getAccountRemovedReceivers(account, accounts);
                    } else {
                        if (!this.packageExistsForUser(packageName, accounts.userId)) {
                            return false;
                        }
                        packagesToVisibility = new HashMap();
                        packagesToVisibility.put(packageName, this.resolveAccountVisibility(account, packageName, accounts));
                        accountRemovedReceivers = new ArrayList();
                        if (this.shouldNotifyPackageOnAccountRemoval(account, packageName, accounts)) {
                            accountRemovedReceivers.add(packageName);
                        }
                    }
                } else {
                    if (!this.isSpecialPackageKey(packageName) && !this.packageExistsForUser(packageName, accounts.userId)) {
                        return false;
                    }
                    packagesToVisibility = Collections.emptyMap();
                    accountRemovedReceivers = Collections.emptyList();
                }
                if (!this.updateAccountVisibilityLocked(account, packageName, newVisibility, accounts)) {
                    return false;
                }
                if (notify) {
                    for (Map.Entry<Object, Object> entry : packagesToVisibility.entrySet()) {
                        int oldVisibility = (Integer)entry.getValue();
                        int currentVisibility = this.resolveAccountVisibility(account, packageName, accounts);
                        if (this.isVisible(oldVisibility) == this.isVisible(currentVisibility)) continue;
                        this.notifyPackage((String)entry.getKey(), accounts);
                    }
                    for (String string2 : accountRemovedReceivers) {
                        this.sendAccountRemovedBroadcast(account, string2, accounts.userId);
                    }
                    this.sendAccountsChangedBroadcast(accounts.userId);
                }
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateAccountVisibilityLocked(Account account, String packageName, int newVisibility, UserAccounts accounts) {
        long accountId = accounts.accountsDb.findDeAccountId(account);
        if (accountId < 0L) {
            return false;
        }
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            if (!accounts.accountsDb.setAccountVisibility(accountId, packageName, newVisibility)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
        Map<String, Integer> accountVisibility = this.getPackagesAndVisibilityForAccountLocked(account, accounts);
        accountVisibility.put(packageName, newVisibility);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAccountListener(String[] accountTypes, String opPackageName) {
        int callingUid = Binder.getCallingUid();
        this.mAppOpsManager.checkPackage(callingUid, opPackageName);
        int userId = UserHandle.getCallingUserId();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            this.registerAccountListener(accountTypes, opPackageName, accounts);
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAccountListener(String[] accountTypes, String opPackageName, UserAccounts accounts) {
        Map map = accounts.mReceiversForType;
        synchronized (map) {
            if (accountTypes == null) {
                accountTypes = new String[]{null};
            }
            for (String type : accountTypes) {
                Integer cnt;
                HashMap<String, Integer> receivers = (HashMap<String, Integer>)accounts.mReceiversForType.get(type);
                if (receivers == null) {
                    receivers = new HashMap<String, Integer>();
                    accounts.mReceiversForType.put(type, receivers);
                }
                receivers.put(opPackageName, (cnt = (Integer)receivers.get(opPackageName)) != null ? cnt + 1 : 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAccountListener(String[] accountTypes, String opPackageName) {
        int callingUid = Binder.getCallingUid();
        this.mAppOpsManager.checkPackage(callingUid, opPackageName);
        int userId = UserHandle.getCallingUserId();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            this.unregisterAccountListener(accountTypes, opPackageName, accounts);
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAccountListener(String[] accountTypes, String opPackageName, UserAccounts accounts) {
        Map map = accounts.mReceiversForType;
        synchronized (map) {
            if (accountTypes == null) {
                accountTypes = new String[]{null};
            }
            for (String type : accountTypes) {
                Map receivers = (Map)accounts.mReceiversForType.get(type);
                if (receivers == null || receivers.get(opPackageName) == null) {
                    throw new IllegalArgumentException("attempt to unregister wrong receiver");
                }
                Integer cnt = (Integer)receivers.get(opPackageName);
                if (cnt == 1) {
                    receivers.remove(opPackageName);
                    continue;
                }
                receivers.put(opPackageName, cnt - 1);
            }
        }
    }

    private void sendNotificationAccountUpdated(Account account, UserAccounts accounts) {
        Map<String, Integer> packagesToVisibility = this.getRequestingPackages(account, accounts);
        for (Map.Entry<String, Integer> packageToVisibility : packagesToVisibility.entrySet()) {
            if (packageToVisibility.getValue() == 3 || packageToVisibility.getValue() == 4) continue;
            this.notifyPackage(packageToVisibility.getKey(), accounts);
        }
    }

    private void notifyPackage(String packageName, UserAccounts accounts) {
        Intent intent = new Intent("android.accounts.action.VISIBLE_ACCOUNTS_CHANGED");
        intent.setPackage(packageName);
        intent.setFlags(0x40000000);
        this.mContext.sendBroadcastAsUser(intent, new UserHandle(accounts.userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> getRequestingPackages(Account account, UserAccounts accounts) {
        HashSet packages = new HashSet();
        Map map = accounts.mReceiversForType;
        synchronized (map) {
            for (String type : new String[]{account.type, null}) {
                Map receivers = (Map)accounts.mReceiversForType.get(type);
                if (receivers == null) continue;
                packages.addAll(receivers.keySet());
            }
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (String packageName : packages) {
            result.put(packageName, this.resolveAccountVisibility(account, packageName, accounts));
        }
        return result;
    }

    private List<String> getAccountRemovedReceivers(Account account, UserAccounts accounts) {
        Intent intent = new Intent("android.accounts.action.ACCOUNT_REMOVED");
        intent.setFlags(0x1000000);
        List<ResolveInfo> receivers = this.mPackageManager.queryBroadcastReceiversAsUser(intent, 0, accounts.userId);
        ArrayList<String> result = new ArrayList<String>();
        if (receivers == null) {
            return result;
        }
        for (ResolveInfo resolveInfo : receivers) {
            String packageName = resolveInfo.activityInfo.applicationInfo.packageName;
            int visibility = this.resolveAccountVisibility(account, packageName, accounts);
            if (visibility != 1 && visibility != 2) continue;
            result.add(packageName);
        }
        return result;
    }

    private boolean shouldNotifyPackageOnAccountRemoval(Account account, String packageName, UserAccounts accounts) {
        int visibility = this.resolveAccountVisibility(account, packageName, accounts);
        if (visibility != 1 && visibility != 2) {
            return false;
        }
        Intent intent = new Intent("android.accounts.action.ACCOUNT_REMOVED");
        intent.setFlags(0x1000000);
        intent.setPackage(packageName);
        List<ResolveInfo> receivers = this.mPackageManager.queryBroadcastReceiversAsUser(intent, 0, accounts.userId);
        return receivers != null && receivers.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean packageExistsForUser(String packageName, int userId) {
        boolean bl;
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            this.mPackageManager.getPackageUidAsUser(packageName, userId);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                AccountManagerService.restoreCallingIdentity(identityToken);
                throw throwable;
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        }
        AccountManagerService.restoreCallingIdentity(identityToken);
        return bl;
    }

    private boolean isSpecialPackageKey(String packageName) {
        return "android:accounts:key_legacy_visible".equals(packageName) || "android:accounts:key_legacy_not_visible".equals(packageName);
    }

    private void sendAccountsChangedBroadcast(int userId) {
        Log.i(TAG, "the accounts changed, sending broadcast of " + ACCOUNTS_CHANGED_INTENT.getAction());
        this.mContext.sendBroadcastAsUser(ACCOUNTS_CHANGED_INTENT, new UserHandle(userId));
    }

    private void sendAccountRemovedBroadcast(Account account, String packageName, int userId) {
        Intent intent = new Intent("android.accounts.action.ACCOUNT_REMOVED");
        intent.setFlags(0x1000000);
        intent.setPackage(packageName);
        intent.putExtra("authAccount", account.name);
        intent.putExtra("accountType", account.type);
        this.mContext.sendBroadcastAsUser(intent, new UserHandle(userId));
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf(TAG, "Account Manager Crash", e);
            }
            throw e;
        }
    }

    private UserManager getUserManager() {
        if (this.mUserManager == null) {
            this.mUserManager = UserManager.get(this.mContext);
        }
        return this.mUserManager;
    }

    public void validateAccounts(int userId) {
        UserAccounts accounts = this.getUserAccounts(userId);
        this.validateAccountsInternal(accounts, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateAccountsInternal(UserAccounts accounts, boolean invalidateAuthenticatorCache) {
        if (Log.isLoggable(TAG, 3)) {
            Log.d(TAG, "validateAccountsInternal " + accounts.userId + " isCeDatabaseAttached=" + accounts.accountsDb.isCeDatabaseAttached() + " userLocked=" + this.mLocalUnlockedUsers.get(accounts.userId));
        }
        if (invalidateAuthenticatorCache) {
            this.mAuthenticatorCache.invalidateCache(accounts.userId);
        }
        HashMap<String, Integer> knownAuth = AccountManagerService.getAuthenticatorTypeAndUIDForUser(this.mAuthenticatorCache, accounts.userId);
        boolean userUnlocked = this.isLocalUnlockedUser(accounts.userId);
        Object object = accounts.dbLock;
        synchronized (object) {
            Object object2 = accounts.cacheLock;
            synchronized (object2) {
                boolean accountDeleted = false;
                AccountsDb accountsDb = accounts.accountsDb;
                Map<String, Integer> metaAuthUid = accountsDb.findMetaAuthUid();
                HashSet obsoleteAuthType = Sets.newHashSet();
                SparseBooleanArray knownUids = null;
                for (Map.Entry<String, Integer> authToUidEntry : metaAuthUid.entrySet()) {
                    String type = authToUidEntry.getKey();
                    int n = authToUidEntry.getValue();
                    Integer knownUid = knownAuth.get(type);
                    if (knownUid != null && n == knownUid) {
                        knownAuth.remove(type);
                        continue;
                    }
                    if (knownUids == null) {
                        knownUids = this.getUidsOfInstalledOrUpdatedPackagesAsUser(accounts.userId);
                    }
                    if (knownUids.get(n)) continue;
                    obsoleteAuthType.add(type);
                    accountsDb.deleteMetaByAuthTypeAndUid(type, n);
                }
                for (Map.Entry<String, Integer> entry : knownAuth.entrySet()) {
                    accountsDb.insertOrReplaceMetaAuthTypeAndUid(entry.getKey(), entry.getValue());
                }
                Map<Long, Account> accountsMap = accountsDb.findAllDeAccounts();
                try {
                    accounts.accountCache.clear();
                    LinkedHashMap<String, ArrayList<String>> accountNamesByType = new LinkedHashMap<String, ArrayList<String>>();
                    for (Map.Entry<Long, Account> entry : accountsMap.entrySet()) {
                        long accountId = entry.getKey();
                        Account account = entry.getValue();
                        if (obsoleteAuthType.contains(account.type)) {
                            Slog.w(TAG, "deleting account " + account.name + " because type " + account.type + "'s registered authenticator no longer exist.");
                            Map<String, Integer> packagesToVisibility = this.getRequestingPackages(account, accounts);
                            List<String> accountRemovedReceivers = this.getAccountRemovedReceivers(account, accounts);
                            accountsDb.beginTransaction();
                            try {
                                accountsDb.deleteDeAccount(accountId);
                                if (userUnlocked) {
                                    accountsDb.deleteCeAccount(accountId);
                                }
                                accountsDb.setTransactionSuccessful();
                            }
                            finally {
                                accountsDb.endTransaction();
                            }
                            accountDeleted = true;
                            this.logRecord(AccountsDb.DEBUG_ACTION_AUTHENTICATOR_REMOVE, "accounts", accountId, accounts);
                            accounts.userDataCache.remove(account);
                            accounts.authTokenCache.remove(account);
                            accounts.accountTokenCaches.remove(account);
                            accounts.visibilityCache.remove(account);
                            for (Map.Entry<String, Integer> packageToVisibility : packagesToVisibility.entrySet()) {
                                if (!this.isVisible(packageToVisibility.getValue())) continue;
                                this.notifyPackage(packageToVisibility.getKey(), accounts);
                            }
                            for (String packageName : accountRemovedReceivers) {
                                this.sendAccountRemovedBroadcast(account, packageName, accounts.userId);
                            }
                            continue;
                        }
                        ArrayList<String> accountNames = (ArrayList<String>)((HashMap)accountNamesByType).get(account.type);
                        if (accountNames == null) {
                            accountNames = new ArrayList<String>();
                            accountNamesByType.put(account.type, accountNames);
                        }
                        accountNames.add(account.name);
                    }
                    for (Map.Entry<Long, Account> entry : ((HashMap)accountNamesByType).entrySet()) {
                        String accountType = (String)((Object)entry.getKey());
                        ArrayList accountNames = (ArrayList)((Object)entry.getValue());
                        Account[] accountsForType = new Account[accountNames.size()];
                        for (int i = 0; i < accountsForType.length; ++i) {
                            accountsForType[i] = new Account((String)accountNames.get(i), accountType, UUID.randomUUID().toString());
                        }
                        accounts.accountCache.put(accountType, accountsForType);
                    }
                    accounts.visibilityCache.putAll(accountsDb.findAllVisibilityValues());
                }
                finally {
                    if (accountDeleted) {
                        this.sendAccountsChangedBroadcast(accounts.userId);
                    }
                }
            }
        }
    }

    private SparseBooleanArray getUidsOfInstalledOrUpdatedPackagesAsUser(int userId) {
        List<PackageInfo> pkgsWithData = this.mPackageManager.getInstalledPackagesAsUser(8192, userId);
        SparseBooleanArray knownUids = new SparseBooleanArray(pkgsWithData.size());
        for (PackageInfo pkgInfo : pkgsWithData) {
            if (pkgInfo.applicationInfo == null || (pkgInfo.applicationInfo.flags & 0x800000) == 0) continue;
            knownUids.put(pkgInfo.applicationInfo.uid, true);
        }
        return knownUids;
    }

    static HashMap<String, Integer> getAuthenticatorTypeAndUIDForUser(Context context, int userId) {
        AccountAuthenticatorCache authCache = new AccountAuthenticatorCache(context);
        return AccountManagerService.getAuthenticatorTypeAndUIDForUser(authCache, userId);
    }

    private static HashMap<String, Integer> getAuthenticatorTypeAndUIDForUser(IAccountAuthenticatorCache authCache, int userId) {
        LinkedHashMap<String, Integer> knownAuth = new LinkedHashMap<String, Integer>();
        for (RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> service : authCache.getAllServices(userId)) {
            knownAuth.put(((AuthenticatorDescription)service.type).type, service.uid);
        }
        return knownAuth;
    }

    private UserAccounts getUserAccountsForCaller() {
        return this.getUserAccounts(UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserAccounts getUserAccounts(int userId) {
        SparseArray<UserAccounts> sparseArray = this.mUsers;
        synchronized (sparseArray) {
            UserAccounts accounts = this.mUsers.get(userId);
            boolean validateAccounts = false;
            if (accounts == null) {
                File preNDbFile = new File(this.mInjector.getPreNDatabaseName(userId));
                File deDbFile = new File(this.mInjector.getDeDatabaseName(userId));
                accounts = new UserAccounts(this.mContext, userId, preNDbFile, deDbFile);
                this.initializeDebugDbSizeAndCompileSqlStatementForLogging(accounts);
                this.mUsers.append(userId, accounts);
                this.purgeOldGrants(accounts);
                validateAccounts = true;
            }
            if (!accounts.accountsDb.isCeDatabaseAttached() && this.mLocalUnlockedUsers.get(userId)) {
                Log.i(TAG, "User " + userId + " is unlocked - opening CE database");
                Object object = accounts.dbLock;
                synchronized (object) {
                    Object object2 = accounts.cacheLock;
                    synchronized (object2) {
                        File ceDatabaseFile = new File(this.mInjector.getCeDatabaseName(userId));
                        accounts.accountsDb.attachCeDatabase(ceDatabaseFile);
                    }
                }
                this.syncDeCeAccountsLocked(accounts);
            }
            if (validateAccounts) {
                this.validateAccountsInternal(accounts, true);
            }
            return accounts;
        }
    }

    private void syncDeCeAccountsLocked(UserAccounts accounts) {
        Preconditions.checkState(Thread.holdsLock(this.mUsers), "mUsers lock must be held");
        List<Account> accountsToRemove = accounts.accountsDb.findCeAccountsNotInDe();
        if (!accountsToRemove.isEmpty()) {
            Slog.i(TAG, "Accounts " + accountsToRemove + " were previously deleted while user " + accounts.userId + " was locked. Removing accounts from CE tables");
            this.logRecord(accounts, AccountsDb.DEBUG_ACTION_SYNC_DE_CE_ACCOUNTS, "accounts");
            for (Account account : accountsToRemove) {
                this.removeAccountInternal(accounts, account, 1000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOldGrantsAll() {
        SparseArray<UserAccounts> sparseArray = this.mUsers;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mUsers.size(); ++i) {
                this.purgeOldGrants(this.mUsers.valueAt(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOldGrants(UserAccounts accounts) {
        Object object = accounts.dbLock;
        synchronized (object) {
            Object object2 = accounts.cacheLock;
            synchronized (object2) {
                List<Integer> uids = accounts.accountsDb.findAllUidGrants();
                for (int uid : uids) {
                    boolean packageExists;
                    boolean bl = packageExists = this.mPackageManager.getPackagesForUid(uid) != null;
                    if (packageExists) continue;
                    Log.d(TAG, "deleting grants for UID " + uid + " because its package is no longer installed");
                    accounts.accountsDb.deleteGrantsByUid(uid);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeVisibilityValuesForPackage(String packageName) {
        if (this.isSpecialPackageKey(packageName)) {
            return;
        }
        SparseArray<UserAccounts> sparseArray = this.mUsers;
        synchronized (sparseArray) {
            int numberOfUsers = this.mUsers.size();
            for (int i = 0; i < numberOfUsers; ++i) {
                UserAccounts accounts = this.mUsers.valueAt(i);
                try {
                    this.mPackageManager.getPackageUidAsUser(packageName, accounts.userId);
                    continue;
                }
                catch (PackageManager.NameNotFoundException e) {
                    accounts.accountsDb.deleteAccountVisibilityForPackage(packageName);
                    Object object = accounts.dbLock;
                    synchronized (object) {
                        Object object2 = accounts.cacheLock;
                        synchronized (object2) {
                            for (Account account : accounts.visibilityCache.keySet()) {
                                Map<String, Integer> accountVisibility = this.getPackagesAndVisibilityForAccountLocked(account, accounts);
                                accountVisibility.remove(packageName);
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeUserData(int userId) {
        UserAccounts accounts;
        Object object = this.mUsers;
        synchronized (object) {
            accounts = this.mUsers.get(userId);
            this.mUsers.remove(userId);
            this.mLocalUnlockedUsers.delete(userId);
        }
        if (accounts != null) {
            object = accounts.dbLock;
            synchronized (object) {
                Object object2 = accounts.cacheLock;
                synchronized (object2) {
                    accounts.statementForLogging.close();
                    accounts.accountsDb.close();
                }
            }
        }
    }

    @VisibleForTesting
    void onUserUnlocked(Intent intent) {
        this.onUnlockUser(intent.getIntExtra("android.intent.extra.user_handle", -1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUnlockUser(int userId) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "onUserUnlocked " + userId);
        }
        SparseArray<UserAccounts> sparseArray = this.mUsers;
        synchronized (sparseArray) {
            this.mLocalUnlockedUsers.put(userId, true);
        }
        if (userId < 1) {
            return;
        }
        this.mHandler.post(() -> this.syncSharedAccounts(userId));
    }

    private void syncSharedAccounts(int userId) {
        int parentUserId;
        Account[] sharedAccounts = this.getSharedAccountsAsUser(userId);
        if (sharedAccounts == null || sharedAccounts.length == 0) {
            return;
        }
        Account[] accounts = this.getAccountsAsUser(null, userId, this.mContext.getOpPackageName());
        int n = parentUserId = UserManager.isSplitSystemUser() ? this.getUserManager().getUserInfo((int)userId).restrictedProfileParentId : 0;
        if (parentUserId < 0) {
            Log.w(TAG, "User " + userId + " has shared accounts, but no parent user");
            return;
        }
        for (Account sa : sharedAccounts) {
            if (ArrayUtils.contains(accounts, sa)) continue;
            this.copyAccountToUser(null, sa, parentUserId, userId);
        }
    }

    @Override
    public void onServiceChanged(AuthenticatorDescription desc, int userId, boolean removed) {
        this.validateAccountsInternal(this.getUserAccounts(userId), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPassword(Account account) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "getPassword: " + account + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid());
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot get secrets for accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            String string2 = this.readPasswordInternal(accounts, account);
            return string2;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readPasswordInternal(UserAccounts accounts, Account account) {
        if (account == null) {
            return null;
        }
        if (!this.isLocalUnlockedUser(accounts.userId)) {
            Log.w(TAG, "Password is not available - user " + accounts.userId + " data is locked");
            return null;
        }
        Object object = accounts.dbLock;
        synchronized (object) {
            Object object2 = accounts.cacheLock;
            synchronized (object2) {
                return accounts.accountsDb.findAccountPasswordByNameAndType(account.name, account.type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPreviousName(Account account) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "getPreviousName: " + account + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid());
        }
        Preconditions.checkNotNull(account, "account cannot be null");
        int userId = UserHandle.getCallingUserId();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            String string2 = this.readPreviousNameInternal(accounts, account);
            return string2;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readPreviousNameInternal(UserAccounts accounts, Account account) {
        if (account == null) {
            return null;
        }
        Object object = accounts.dbLock;
        synchronized (object) {
            Object object2 = accounts.cacheLock;
            synchronized (object2) {
                AtomicReference<String> previousNameRef = (AtomicReference<String>)accounts.previousNameCache.get(account);
                if (previousNameRef == null) {
                    String previousName = accounts.accountsDb.findDeAccountPreviousName(account);
                    previousNameRef = new AtomicReference<String>(previousName);
                    accounts.previousNameCache.put(account, previousNameRef);
                    return previousName;
                }
                return (String)previousNameRef.get();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserData(Account account, String key) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            String msg = String.format("getUserData( account: %s, key: %s, callerUid: %s, pid: %s", account, key, callingUid, Binder.getCallingPid());
            Log.v(TAG, msg);
        }
        Preconditions.checkNotNull(account, "account cannot be null");
        Preconditions.checkNotNull(key, "key cannot be null");
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot get user data for accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        if (!this.isLocalUnlockedUser(userId)) {
            Log.w(TAG, "User " + userId + " data is locked. callingUid " + callingUid);
            return null;
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            if (!this.accountExistsCache(accounts, account)) {
                String string2 = null;
                return string2;
            }
            String string3 = this.readUserDataInternal(accounts, account, key);
            return string3;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticatorDescription[] getAuthenticatorTypes(int userId) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "getAuthenticatorTypes: for user id " + userId + " caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (this.isCrossUser(callingUid, userId)) {
            throw new SecurityException(String.format("User %s tying to get authenticator types for %s", UserHandle.getCallingUserId(), userId));
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            AuthenticatorDescription[] authenticatorDescriptionArray = this.getAuthenticatorTypesInternal(userId);
            return authenticatorDescriptionArray;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    private AuthenticatorDescription[] getAuthenticatorTypesInternal(int userId) {
        this.mAuthenticatorCache.updateServices(userId);
        Collection<RegisteredServicesCache.ServiceInfo<AuthenticatorDescription>> authenticatorCollection = this.mAuthenticatorCache.getAllServices(userId);
        AuthenticatorDescription[] types = new AuthenticatorDescription[authenticatorCollection.size()];
        int i = 0;
        for (RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> authenticator : authenticatorCollection) {
            types[i] = (AuthenticatorDescription)authenticator.type;
            ++i;
        }
        return types;
    }

    private boolean isCrossUser(int callingUid, int userId) {
        return userId != UserHandle.getCallingUserId() && callingUid != 1000 && this.mContext.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0;
    }

    @Override
    public boolean addAccountExplicitly(Account account, String password, Bundle extras) {
        return this.addAccountExplicitlyWithVisibility(account, password, extras, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyAccountToUser(final IAccountManagerResponse response, final Account account, final int userFrom, int userTo) {
        int callingUid = Binder.getCallingUid();
        if (this.isCrossUser(callingUid, -1)) {
            throw new SecurityException("Calling copyAccountToUser requires android.permission.INTERACT_ACROSS_USERS_FULL");
        }
        UserAccounts fromAccounts = this.getUserAccounts(userFrom);
        final UserAccounts toAccounts = this.getUserAccounts(userTo);
        if (fromAccounts == null || toAccounts == null) {
            if (response != null) {
                Bundle result = new Bundle();
                result.putBoolean("booleanResult", false);
                try {
                    response.onResult(result);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Failed to report error back to the client." + e);
                }
            }
            return;
        }
        Slog.d(TAG, "Copying account " + account.name + " from user " + userFrom + " to user " + userTo);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            new Session(fromAccounts, response, account.type, false, false, account.name, false){

                @Override
                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", getAccountCredentialsForClone, " + account.type;
                }

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.getAccountCredentialsForCloning(this, account);
                }

                @Override
                public void onResult(Bundle result) {
                    Bundle.setDefusable(result, true);
                    if (result != null && result.getBoolean("booleanResult", false)) {
                        AccountManagerService.this.completeCloningAccount(response, result, account, toAccounts, userFrom);
                    } else {
                        super.onResult(result);
                    }
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accountAuthenticated(Account account) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            String msg = String.format("accountAuthenticated( account: %s, callerUid: %s)", account, callingUid);
            Log.v(TAG, msg);
        }
        Preconditions.checkNotNull(account, "account cannot be null");
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot notify authentication for accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        if (!this.canUserModifyAccounts(userId, callingUid) || !this.canUserModifyAccountsForType(userId, account.type, callingUid)) {
            return false;
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            boolean bl = this.updateLastAuthenticatedTime(account);
            return bl;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateLastAuthenticatedTime(Account account) {
        UserAccounts accounts = this.getUserAccountsForCaller();
        Object object = accounts.dbLock;
        synchronized (object) {
            Object object2 = accounts.cacheLock;
            synchronized (object2) {
                return accounts.accountsDb.updateAccountLastAuthenticatedTime(account);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeCloningAccount(IAccountManagerResponse response, final Bundle accountCredentials, final Account account, UserAccounts targetUser, final int parentUserId) {
        Bundle.setDefusable(accountCredentials, true);
        long id2 = AccountManagerService.clearCallingIdentity();
        try {
            new Session(targetUser, response, account.type, false, false, account.name, false){

                @Override
                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", getAccountCredentialsForClone, " + account.type;
                }

                @Override
                public void run() throws RemoteException {
                    for (Account acc : AccountManagerService.this.getAccounts(parentUserId, AccountManagerService.this.mContext.getOpPackageName())) {
                        if (!acc.equals(account)) continue;
                        this.mAuthenticator.addAccountFromCredentials(this, account, accountCredentials);
                        break;
                    }
                }

                @Override
                public void onResult(Bundle result) {
                    Bundle.setDefusable(result, true);
                    super.onResult(result);
                }

                @Override
                public void onError(int errorCode, String errorMessage) {
                    super.onError(errorCode, errorMessage);
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean addAccountInternal(UserAccounts accounts, Account account, String password, Bundle extras, int callingUid, Map<String, Integer> packageToVisibility) {
        Bundle.setDefusable(extras, true);
        if (account == null) {
            return false;
        }
        if (!this.isLocalUnlockedUser(accounts.userId)) {
            Log.w(TAG, "Account " + account + " cannot be added - user " + accounts.userId + " is locked. callingUid=" + callingUid);
            return false;
        }
        Object object = accounts.dbLock;
        // MONITORENTER : object
        Object object2 = accounts.cacheLock;
        // MONITORENTER : object2
        accounts.accountsDb.beginTransaction();
        try {
            if (accounts.accountsDb.findCeAccountId(account) >= 0L) {
                Log.w(TAG, "insertAccountIntoDatabase: " + account + ", skipping since the account already exists");
                boolean bl = false;
                return bl;
            }
            long accountId = accounts.accountsDb.insertCeAccount(account, password);
            if (accountId < 0L) {
                Log.w(TAG, "insertAccountIntoDatabase: " + account + ", skipping the DB insert failed");
                boolean bl = false;
                return bl;
            }
            if (accounts.accountsDb.insertDeAccount(account, accountId) < 0L) {
                Log.w(TAG, "insertAccountIntoDatabase: " + account + ", skipping the DB insert failed");
                boolean bl = false;
                return bl;
            }
            if (extras != null) {
                for (String string2 : extras.keySet()) {
                    String value;
                    if (accounts.accountsDb.insertExtra(accountId, string2, value = extras.getString(string2)) >= 0L) continue;
                    Log.w(TAG, "insertAccountIntoDatabase: " + account + ", skipping since insertExtra failed for key " + string2);
                    boolean bl = false;
                    return bl;
                }
            }
            if (packageToVisibility != null) {
                for (Map.Entry entry : packageToVisibility.entrySet()) {
                    this.setAccountVisibility(account, (String)entry.getKey(), (Integer)entry.getValue(), false, accounts);
                }
            }
            accounts.accountsDb.setTransactionSuccessful();
            this.logRecord(AccountsDb.DEBUG_ACTION_ACCOUNT_ADD, "accounts", accountId, accounts, callingUid);
            this.insertAccountIntoCacheLocked(accounts, account);
        }
        finally {
            accounts.accountsDb.endTransaction();
        }
        // MONITOREXIT : object2
        // MONITOREXIT : object
        if (this.getUserManager().getUserInfo(accounts.userId).canHaveProfile()) {
            this.addAccountToLinkedRestrictedUsers(account, accounts.userId);
        }
        this.sendNotificationAccountUpdated(account, accounts);
        this.sendAccountsChangedBroadcast(accounts.userId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLocalUnlockedUser(int userId) {
        SparseArray<UserAccounts> sparseArray = this.mUsers;
        synchronized (sparseArray) {
            return this.mLocalUnlockedUsers.get(userId);
        }
    }

    private void addAccountToLinkedRestrictedUsers(Account account, int parentUserId) {
        List<UserInfo> users = this.getUserManager().getUsers();
        for (UserInfo user : users) {
            if (!user.isRestricted() || parentUserId != user.restrictedProfileParentId) continue;
            this.addSharedAccountAsUser(account, user.id);
            if (!this.isLocalUnlockedUser(user.id)) continue;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(4, parentUserId, user.id, account));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hasFeatures(IAccountManagerResponse response, Account account, String[] features, String opPackageName) {
        int callingUid = Binder.getCallingUid();
        this.mAppOpsManager.checkPackage(callingUid, opPackageName);
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "hasFeatures: " + account + ", response " + response + ", features " + Arrays.toString(features) + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        Preconditions.checkArgument(account != null, "account cannot be null");
        Preconditions.checkArgument(response != null, "response cannot be null");
        Preconditions.checkArgument(features != null, "features cannot be null");
        int userId = UserHandle.getCallingUserId();
        this.checkReadAccountsPermitted(callingUid, account.type, userId, opPackageName);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            new TestFeaturesSession(accounts, response, account, features).bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameAccount(IAccountManagerResponse response, Account accountToRename, String newName) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "renameAccount: " + accountToRename + " -> " + newName + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (accountToRename == null) {
            throw new IllegalArgumentException("account is null");
        }
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(accountToRename.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot rename accounts of type: %s", callingUid, accountToRename.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            Account resultingAccount = this.renameAccountInternal(accounts, accountToRename, newName);
            Bundle result = new Bundle();
            result.putString("authAccount", resultingAccount.name);
            result.putString("accountType", resultingAccount.type);
            result.putString("accountAccessId", resultingAccount.getAccessId());
            try {
                response.onResult(result);
            }
            catch (RemoteException e) {
                Log.w(TAG, e.getMessage());
            }
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Account renameAccountInternal(UserAccounts accounts, Account accountToRename, String newName) {
        Account resultAccount = null;
        this.cancelNotification(this.getSigninRequiredNotificationId(accounts, accountToRename), new UserHandle(accounts.userId));
        Object object = accounts.credentialsPermissionNotificationIds;
        synchronized (object) {
            for (Pair pair : accounts.credentialsPermissionNotificationIds.keySet()) {
                if (!accountToRename.equals(((Pair)pair.first).first)) continue;
                NotificationId id2 = (NotificationId)accounts.credentialsPermissionNotificationIds.get(pair);
                this.cancelNotification(id2, new UserHandle(accounts.userId));
            }
        }
        object = accounts.dbLock;
        synchronized (object) {
            Object object2 = accounts.cacheLock;
            synchronized (object2) {
                Account renamedAccount;
                List<String> accountRemovedReceivers;
                block21: {
                    accountRemovedReceivers = this.getAccountRemovedReceivers(accountToRename, accounts);
                    accounts.accountsDb.beginTransaction();
                    renamedAccount = new Account(newName, accountToRename.type);
                    if (accounts.accountsDb.findCeAccountId(renamedAccount) >= 0L) {
                        Log.e(TAG, "renameAccount failed - account with new name already exists");
                        Account account = null;
                        return account;
                    }
                    long accountId = accounts.accountsDb.findDeAccountId(accountToRename);
                    if (accountId >= 0L) {
                        accounts.accountsDb.renameCeAccount(accountId, newName);
                        if (accounts.accountsDb.renameDeAccount(accountId, newName, accountToRename.name)) {
                            accounts.accountsDb.setTransactionSuccessful();
                            break block21;
                        } else {
                            Log.e(TAG, "renameAccount failed");
                            Account account = null;
                            return account;
                        }
                    }
                    Log.e(TAG, "renameAccount failed - old account does not exist");
                    Account account = null;
                    return account;
                    finally {
                        accounts.accountsDb.endTransaction();
                    }
                }
                renamedAccount = this.insertAccountIntoCacheLocked(accounts, renamedAccount);
                Map tmpData = (Map)accounts.userDataCache.get(accountToRename);
                Map tmpTokens = (Map)accounts.authTokenCache.get(accountToRename);
                Map tmpVisibility = (Map)accounts.visibilityCache.get(accountToRename);
                this.removeAccountFromCacheLocked(accounts, accountToRename);
                accounts.userDataCache.put(renamedAccount, tmpData);
                accounts.authTokenCache.put(renamedAccount, tmpTokens);
                accounts.visibilityCache.put(renamedAccount, tmpVisibility);
                accounts.previousNameCache.put(renamedAccount, new AtomicReference<String>(accountToRename.name));
                resultAccount = renamedAccount;
                int parentUserId = accounts.userId;
                if (this.canHaveProfile(parentUserId)) {
                    List<UserInfo> users = this.getUserManager().getUsers(true);
                    for (UserInfo user : users) {
                        if (!user.isRestricted() || user.restrictedProfileParentId != parentUserId) continue;
                        this.renameSharedAccountAsUser(accountToRename, newName, user.id);
                    }
                }
                this.sendNotificationAccountUpdated(resultAccount, accounts);
                this.sendAccountsChangedBroadcast(accounts.userId);
                Iterator<String> iterator = accountRemovedReceivers.iterator();
                while (iterator.hasNext()) {
                    String packageName = iterator.next();
                    this.sendAccountRemovedBroadcast(accountToRename, packageName, accounts.userId);
                }
                return resultAccount;
            }
        }
    }

    private boolean canHaveProfile(int parentUserId) {
        UserInfo userInfo = this.getUserManager().getUserInfo(parentUserId);
        return userInfo != null && userInfo.canHaveProfile();
    }

    @Override
    public void removeAccount(IAccountManagerResponse response, Account account, boolean expectActivityLaunch) {
        this.removeAccountAsUser(response, account, expectActivityLaunch, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAccountAsUser(IAccountManagerResponse response, Account account, boolean expectActivityLaunch, int userId) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "removeAccount: " + account + ", response " + response + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid() + ", for user id " + userId);
        }
        Preconditions.checkArgument(account != null, "account cannot be null");
        Preconditions.checkArgument(response != null, "response cannot be null");
        if (this.isCrossUser(callingUid, userId)) {
            throw new SecurityException(String.format("User %s tying remove account for %s", UserHandle.getCallingUserId(), userId));
        }
        UserHandle user = UserHandle.of(userId);
        if (!(this.isAccountManagedByCaller(account.type, callingUid, user.getIdentifier()) || this.isSystemUid(callingUid) || this.isProfileOwner(callingUid))) {
            String msg = String.format("uid %s cannot remove accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        if (!this.canUserModifyAccounts(userId, callingUid)) {
            try {
                response.onError(100, "User cannot modify accounts");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        if (!this.canUserModifyAccountsForType(userId, account.type, callingUid)) {
            try {
                response.onError(101, "User cannot modify accounts of this type (policy).");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        UserAccounts accounts = this.getUserAccounts(userId);
        this.cancelNotification(this.getSigninRequiredNotificationId(accounts, account), user);
        HashMap hashMap = accounts.credentialsPermissionNotificationIds;
        synchronized (hashMap) {
            for (Pair pair : accounts.credentialsPermissionNotificationIds.keySet()) {
                if (!account.equals(((Pair)pair.first).first)) continue;
                NotificationId id2 = (NotificationId)accounts.credentialsPermissionNotificationIds.get(pair);
                this.cancelNotification(id2, user);
            }
        }
        long accountId = accounts.accountsDb.findDeAccountId(account);
        this.logRecord(AccountsDb.DEBUG_ACTION_CALLED_ACCOUNT_REMOVE, "accounts", accountId, accounts, callingUid);
        try {
            new RemoveAccountSession(accounts, response, account, expectActivityLaunch).bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAccountExplicitly(Account account) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "removeAccountExplicitly: " + account + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        int userId = Binder.getCallingUserHandle().getIdentifier();
        if (account == null) {
            Log.e(TAG, "account is null");
            return false;
        }
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot explicitly remove accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        UserAccounts accounts = this.getUserAccountsForCaller();
        long accountId = accounts.accountsDb.findDeAccountId(account);
        this.logRecord(AccountsDb.DEBUG_ACTION_CALLED_ACCOUNT_REMOVE, "accounts", accountId, accounts, callingUid);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            boolean bl = this.removeAccountInternal(accounts, account, callingUid);
            return bl;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    @VisibleForTesting
    protected void removeAccountInternal(Account account) {
        this.removeAccountInternal(this.getUserAccountsForCaller(), account, AccountManagerService.getCallingUid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeAccountInternal(UserAccounts accounts, Account account, int callingUid) {
        boolean isChanged = false;
        boolean userUnlocked = this.isLocalUnlockedUser(accounts.userId);
        if (!userUnlocked) {
            Slog.i(TAG, "Removing account " + account + " while user " + accounts.userId + " is still locked. CE data will be removed later");
        }
        Object object = accounts.dbLock;
        synchronized (object) {
            Object object2 = accounts.cacheLock;
            synchronized (object2) {
                Map<String, Integer> packagesToVisibility = this.getRequestingPackages(account, accounts);
                List<String> accountRemovedReceivers = this.getAccountRemovedReceivers(account, accounts);
                accounts.accountsDb.beginTransaction();
                long accountId = -1L;
                try {
                    long ceAccountId;
                    accountId = accounts.accountsDb.findDeAccountId(account);
                    if (accountId >= 0L) {
                        isChanged = accounts.accountsDb.deleteDeAccount(accountId);
                    }
                    if (userUnlocked && (ceAccountId = accounts.accountsDb.findCeAccountId(account)) >= 0L) {
                        accounts.accountsDb.deleteCeAccount(ceAccountId);
                    }
                    accounts.accountsDb.setTransactionSuccessful();
                }
                finally {
                    accounts.accountsDb.endTransaction();
                }
                if (isChanged) {
                    this.removeAccountFromCacheLocked(accounts, account);
                    for (Map.Entry<String, Integer> packageToVisibility : packagesToVisibility.entrySet()) {
                        if (packageToVisibility.getValue() != 1 && packageToVisibility.getValue() != 2) continue;
                        this.notifyPackage(packageToVisibility.getKey(), accounts);
                    }
                    this.sendAccountsChangedBroadcast(accounts.userId);
                    for (String packageName : accountRemovedReceivers) {
                        this.sendAccountRemovedBroadcast(account, packageName, accounts.userId);
                    }
                    String action = userUnlocked ? AccountsDb.DEBUG_ACTION_ACCOUNT_REMOVE : AccountsDb.DEBUG_ACTION_ACCOUNT_REMOVE_DE;
                    this.logRecord(action, "accounts", accountId, accounts);
                }
            }
        }
        long id2 = Binder.clearCallingIdentity();
        try {
            int parentUserId = accounts.userId;
            if (this.canHaveProfile(parentUserId)) {
                List<UserInfo> users = this.getUserManager().getUsers(true);
                for (UserInfo user : users) {
                    if (!user.isRestricted() || parentUserId != user.restrictedProfileParentId) continue;
                    this.removeSharedAccountAsUser(account, user.id, callingUid);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(id2);
        }
        if (isChanged) {
            HashMap hashMap = accounts.credentialsPermissionNotificationIds;
            synchronized (hashMap) {
                for (Pair key : accounts.credentialsPermissionNotificationIds.keySet()) {
                    if (!account.equals(((Pair)key.first).first) || !"com.android.AccountManager.ACCOUNT_ACCESS_TOKEN_TYPE".equals(((Pair)key.first).second)) continue;
                    int uid = (Integer)key.second;
                    this.mHandler.post(() -> this.cancelAccountAccessRequestNotificationIfNeeded(account, uid, false));
                }
            }
        }
        return isChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAuthToken(String accountType, String authToken) {
        int callerUid = Binder.getCallingUid();
        Preconditions.checkNotNull(accountType, "accountType cannot be null");
        Preconditions.checkNotNull(authToken, "authToken cannot be null");
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "invalidateAuthToken: accountType " + accountType + ", caller's uid " + callerUid + ", pid " + Binder.getCallingPid());
        }
        int userId = UserHandle.getCallingUserId();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            Object object = accounts.dbLock;
            synchronized (object) {
                List<Pair<Account, String>> deletedTokens;
                accounts.accountsDb.beginTransaction();
                try {
                    deletedTokens = this.invalidateAuthTokenLocked(accounts, accountType, authToken);
                    accounts.accountsDb.setTransactionSuccessful();
                }
                finally {
                    accounts.accountsDb.endTransaction();
                }
                Object object2 = accounts.cacheLock;
                synchronized (object2) {
                    for (Pair<Account, String> tokenInfo : deletedTokens) {
                        Account act = (Account)tokenInfo.first;
                        String tokenType = (String)tokenInfo.second;
                        this.writeAuthTokenIntoCacheLocked(accounts, act, tokenType, null);
                    }
                    accounts.accountTokenCaches.remove(accountType, authToken);
                }
            }
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<Account, String>> invalidateAuthTokenLocked(UserAccounts accounts, String accountType, String authToken) {
        ArrayList<Pair<Account, String>> results = new ArrayList<Pair<Account, String>>();
        try (Cursor cursor = accounts.accountsDb.findAuthtokenForAllAccounts(accountType, authToken);){
            while (cursor.moveToNext()) {
                String authTokenId = cursor.getString(0);
                String accountName = cursor.getString(1);
                String authTokenType = cursor.getString(2);
                accounts.accountsDb.deleteAuthToken(authTokenId);
                results.add(Pair.create(new Account(accountName, accountType), authTokenType));
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCachedToken(UserAccounts accounts, Account account, String callerPkg, byte[] callerSigDigest, String tokenType, String token, long expiryMillis) {
        if (account == null || tokenType == null || callerPkg == null || callerSigDigest == null) {
            return;
        }
        this.cancelNotification(this.getSigninRequiredNotificationId(accounts, account), UserHandle.of(accounts.userId));
        Object object = accounts.cacheLock;
        synchronized (object) {
            accounts.accountTokenCaches.put(account, token, tokenType, callerPkg, callerSigDigest, expiryMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveAuthTokenToDatabase(UserAccounts accounts, Account account, String type, String authToken) {
        if (account == null) return false;
        if (type == null) {
            return false;
        }
        this.cancelNotification(this.getSigninRequiredNotificationId(accounts, account), UserHandle.of(accounts.userId));
        Object object = accounts.dbLock;
        synchronized (object) {
            boolean updateCache;
            block16: {
                long accountId;
                block15: {
                    Object object2;
                    boolean bl;
                    accounts.accountsDb.beginTransaction();
                    updateCache = false;
                    try {
                        accountId = accounts.accountsDb.findDeAccountId(account);
                        if (accountId >= 0L) break block15;
                        bl = false;
                        accounts.accountsDb.endTransaction();
                        if (!updateCache) return bl;
                        object2 = accounts.cacheLock;
                    }
                    catch (Throwable throwable) {
                        accounts.accountsDb.endTransaction();
                        if (!updateCache) throw throwable;
                        Object object3 = accounts.cacheLock;
                        synchronized (object3) {
                            this.writeAuthTokenIntoCacheLocked(accounts, account, type, authToken);
                            throw throwable;
                        }
                    }
                    synchronized (object2) {
                        this.writeAuthTokenIntoCacheLocked(accounts, account, type, authToken);
                        return bl;
                    }
                }
                accounts.accountsDb.deleteAuthtokensByAccountIdAndType(accountId, type);
                if (accounts.accountsDb.insertAuthToken(accountId, type, authToken) < 0L) break block16;
                accounts.accountsDb.setTransactionSuccessful();
                updateCache = true;
                boolean bl = true;
                accounts.accountsDb.endTransaction();
                if (!updateCache) return bl;
                Object object4 = accounts.cacheLock;
                synchronized (object4) {
                    this.writeAuthTokenIntoCacheLocked(accounts, account, type, authToken);
                    return bl;
                }
            }
            boolean bl = false;
            accounts.accountsDb.endTransaction();
            if (!updateCache) return bl;
            Object object5 = accounts.cacheLock;
            synchronized (object5) {
                this.writeAuthTokenIntoCacheLocked(accounts, account, type, authToken);
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String peekAuthToken(Account account, String authTokenType) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "peekAuthToken: " + account + ", authTokenType " + authTokenType + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        Preconditions.checkNotNull(account, "account cannot be null");
        Preconditions.checkNotNull(authTokenType, "authTokenType cannot be null");
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot peek the authtokens associated with accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        if (!this.isLocalUnlockedUser(userId)) {
            Log.w(TAG, "Authtoken not available - user " + userId + " data is locked. callingUid " + callingUid);
            return null;
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            String string2 = this.readAuthTokenInternal(accounts, account, authTokenType);
            return string2;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAuthToken(Account account, String authTokenType, String authToken) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "setAuthToken: " + account + ", authTokenType " + authTokenType + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        Preconditions.checkNotNull(account, "account cannot be null");
        Preconditions.checkNotNull(authTokenType, "authTokenType cannot be null");
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot set auth tokens associated with accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            this.saveAuthTokenToDatabase(accounts, account, authTokenType, authToken);
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPassword(Account account, String password) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "setAuthToken: " + account + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        Preconditions.checkNotNull(account, "account cannot be null");
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot set secrets for accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            this.setPasswordInternal(accounts, account, password, callingUid);
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPasswordInternal(UserAccounts accounts, Account account, String password, int callingUid) {
        if (account == null) {
            return;
        }
        boolean isChanged = false;
        Object object = accounts.dbLock;
        synchronized (object) {
            Object object2 = accounts.cacheLock;
            synchronized (object2) {
                accounts.accountsDb.beginTransaction();
                try {
                    long accountId = accounts.accountsDb.findDeAccountId(account);
                    if (accountId >= 0L) {
                        accounts.accountsDb.updateCeAccountPassword(accountId, password);
                        accounts.accountsDb.deleteAuthTokensByAccountId(accountId);
                        accounts.authTokenCache.remove(account);
                        accounts.accountTokenCaches.remove(account);
                        accounts.accountsDb.setTransactionSuccessful();
                        isChanged = true;
                        String action = password == null || password.length() == 0 ? AccountsDb.DEBUG_ACTION_CLEAR_PASSWORD : AccountsDb.DEBUG_ACTION_SET_PASSWORD;
                        this.logRecord(action, "accounts", accountId, accounts, callingUid);
                    }
                }
                finally {
                    accounts.accountsDb.endTransaction();
                    if (isChanged) {
                        this.sendNotificationAccountUpdated(account, accounts);
                        this.sendAccountsChangedBroadcast(accounts.userId);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPassword(Account account) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "clearPassword: " + account + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        Preconditions.checkNotNull(account, "account cannot be null");
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot clear passwords for accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            this.setPasswordInternal(accounts, account, null, callingUid);
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Account account, String key, String value) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "setUserData: " + account + ", key " + key + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot set user data for accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            if (!this.accountExistsCache(accounts, account)) {
                return;
            }
            this.setUserdataInternal(accounts, account, key, value);
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean accountExistsCache(UserAccounts accounts, Account account) {
        Object object = accounts.cacheLock;
        synchronized (object) {
            if (accounts.accountCache.containsKey(account.type)) {
                for (Account acc : accounts.accountCache.get(account.type)) {
                    if (!acc.name.equals(account.name)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setUserdataInternal(UserAccounts accounts, Account account, String key, String value) {
        Object object = accounts.dbLock;
        synchronized (object) {
            accounts.accountsDb.beginTransaction();
            try {
                long accountId = accounts.accountsDb.findDeAccountId(account);
                if (accountId < 0L) {
                    return;
                }
                long extrasId = accounts.accountsDb.findExtrasIdByAccountId(accountId, key);
                if (extrasId < 0L) {
                    extrasId = accounts.accountsDb.insertExtra(accountId, key, value);
                    if (extrasId < 0L) {
                        return;
                    }
                } else if (!accounts.accountsDb.updateExtra(extrasId, value)) {
                    return;
                }
                accounts.accountsDb.setTransactionSuccessful();
            }
            finally {
                accounts.accountsDb.endTransaction();
            }
            Object object2 = accounts.cacheLock;
            synchronized (object2) {
                this.writeUserDataIntoCacheLocked(accounts, account, key, value);
                return;
            }
        }
    }

    private void onResult(IAccountManagerResponse response, Bundle result) {
        block4: {
            if (result == null) {
                Log.e(TAG, "the result is unexpectedly null", new Exception());
            }
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, this.getClass().getSimpleName() + " calling onResult() on response " + response);
            }
            try {
                response.onResult(result);
            }
            catch (RemoteException e) {
                if (!Log.isLoggable(TAG, 2)) break block4;
                Log.v(TAG, "failure while notifying response", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAuthTokenLabel(IAccountManagerResponse response, final String accountType, final String authTokenType) throws RemoteException {
        Preconditions.checkArgument(accountType != null, "accountType cannot be null");
        Preconditions.checkArgument(authTokenType != null, "authTokenType cannot be null");
        int callingUid = AccountManagerService.getCallingUid();
        AccountManagerService.clearCallingIdentity();
        if (UserHandle.getAppId(callingUid) != 1000) {
            throw new SecurityException("can only call from system");
        }
        int userId = UserHandle.getUserId(callingUid);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            new Session(accounts, response, accountType, false, false, null, false){

                @Override
                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", getAuthTokenLabel, " + accountType + ", authTokenType " + authTokenType;
                }

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.getAuthTokenLabel(this, authTokenType);
                }

                @Override
                public void onResult(Bundle result) {
                    Bundle.setDefusable(result, true);
                    if (result != null) {
                        String label = result.getString("authTokenLabelKey");
                        Bundle bundle = new Bundle();
                        bundle.putString("authTokenLabelKey", label);
                        super.onResult(bundle);
                        return;
                    }
                    super.onResult(result);
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAuthToken(IAccountManagerResponse response, final Account account, final String authTokenType, final boolean notifyOnAuthFailure, boolean expectActivityLaunch, final Bundle loginOptions) {
        List<String> callerOwnedPackageNames;
        RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> authenticatorInfo;
        UserAccounts accounts;
        Bundle.setDefusable(loginOptions, true);
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "getAuthToken: " + account + ", response " + response + ", authTokenType " + authTokenType + ", notifyOnAuthFailure " + notifyOnAuthFailure + ", expectActivityLaunch " + expectActivityLaunch + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid());
        }
        Preconditions.checkArgument(response != null, "response cannot be null");
        try {
            if (account == null) {
                Slog.w(TAG, "getAuthToken called with null account");
                response.onError(7, "account is null");
                return;
            }
            if (authTokenType == null) {
                Slog.w(TAG, "getAuthToken called with null authTokenType");
                response.onError(7, "authTokenType is null");
                return;
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Failed to report error back to the client." + e);
            return;
        }
        int userId = UserHandle.getCallingUserId();
        long ident = Binder.clearCallingIdentity();
        try {
            accounts = this.getUserAccounts(userId);
            authenticatorInfo = this.mAuthenticatorCache.getServiceInfo(AuthenticatorDescription.newKey(account.type), accounts.userId);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        final boolean customTokens = authenticatorInfo != null && ((AuthenticatorDescription)authenticatorInfo.type).customTokens;
        final int callerUid = Binder.getCallingUid();
        final boolean permissionGranted = customTokens || this.permissionIsGranted(account, authTokenType, callerUid, userId);
        final String callerPkg = loginOptions.getString("androidPackageName");
        ident = Binder.clearCallingIdentity();
        try {
            callerOwnedPackageNames = Arrays.asList(this.mPackageManager.getPackagesForUid(callerUid));
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        if (callerPkg == null || !callerOwnedPackageNames.contains(callerPkg)) {
            String msg = String.format("Uid %s is attempting to illegally masquerade as package %s!", callerUid, callerPkg);
            throw new SecurityException(msg);
        }
        loginOptions.putInt("callerUid", callerUid);
        loginOptions.putInt("callerPid", Binder.getCallingPid());
        if (notifyOnAuthFailure) {
            loginOptions.putBoolean("notifyOnAuthFailure", true);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            String token;
            String authToken;
            final byte[] callerPkgSigDigest = this.calculatePackageSignatureDigest(callerPkg);
            if (!customTokens && permissionGranted && (authToken = this.readAuthTokenInternal(accounts, account, authTokenType)) != null) {
                Bundle result = new Bundle();
                result.putString("authtoken", authToken);
                result.putString("authAccount", account.name);
                result.putString("accountType", account.type);
                this.onResult(response, result);
                return;
            }
            if (customTokens && (token = this.readCachedTokenInternal(accounts, account, authTokenType, callerPkg, callerPkgSigDigest)) != null) {
                if (Log.isLoggable(TAG, 2)) {
                    Log.v(TAG, "getAuthToken: cache hit ofr custom token authenticator.");
                }
                Bundle result = new Bundle();
                result.putString("authtoken", token);
                result.putString("authAccount", account.name);
                result.putString("accountType", account.type);
                this.onResult(response, result);
                return;
            }
            new Session(accounts, response, account.type, expectActivityLaunch, false, account.name, false){

                @Override
                protected String toDebugString(long now) {
                    if (loginOptions != null) {
                        loginOptions.keySet();
                    }
                    return super.toDebugString(now) + ", getAuthToken, " + account + ", authTokenType " + authTokenType + ", loginOptions " + loginOptions + ", notifyOnAuthFailure " + notifyOnAuthFailure;
                }

                @Override
                public void run() throws RemoteException {
                    if (!permissionGranted) {
                        this.mAuthenticator.getAuthTokenLabel(this, authTokenType);
                    } else {
                        this.mAuthenticator.getAuthToken(this, account, authTokenType, loginOptions);
                    }
                }

                @Override
                public void onResult(Bundle result) {
                    Bundle.setDefusable(result, true);
                    if (result != null) {
                        Intent intent;
                        if (result.containsKey("authTokenLabelKey")) {
                            Intent intent2 = AccountManagerService.this.newGrantCredentialsPermissionIntent(account, null, callerUid, new AccountAuthenticatorResponse(this), authTokenType, true);
                            Bundle bundle = new Bundle();
                            bundle.putParcelable("intent", intent2);
                            this.onResult(bundle);
                            return;
                        }
                        String authToken = result.getString("authtoken");
                        if (authToken != null) {
                            String name = result.getString("authAccount");
                            String type = result.getString("accountType");
                            if (TextUtils.isEmpty(type) || TextUtils.isEmpty(name)) {
                                this.onError(5, "the type and name should not be empty");
                                return;
                            }
                            Account resultAccount = new Account(name, type);
                            if (!customTokens) {
                                AccountManagerService.this.saveAuthTokenToDatabase(this.mAccounts, resultAccount, authTokenType, authToken);
                            }
                            long expiryMillis = result.getLong("android.accounts.expiry", 0L);
                            if (customTokens && expiryMillis > System.currentTimeMillis()) {
                                AccountManagerService.this.saveCachedToken(this.mAccounts, account, callerPkg, callerPkgSigDigest, authTokenType, authToken, expiryMillis);
                            }
                        }
                        if ((intent = (Intent)result.getParcelable("intent")) != null && notifyOnAuthFailure && !customTokens) {
                            if (!this.checkKeyIntent(Binder.getCallingUid(), intent)) {
                                this.onError(5, "invalid intent in bundle returned");
                                return;
                            }
                            AccountManagerService.this.doNotification(this.mAccounts, account, result.getString("authFailedMessage"), intent, "android", accounts.userId);
                        }
                    }
                    super.onResult(result);
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    private byte[] calculatePackageSignatureDigest(String callerPkg) {
        MessageDigest digester;
        try {
            digester = MessageDigest.getInstance("SHA-256");
            PackageInfo pkgInfo = this.mPackageManager.getPackageInfo(callerPkg, 64);
            for (Signature sig : pkgInfo.signatures) {
                digester.update(sig.toByteArray());
            }
        }
        catch (NoSuchAlgorithmException x) {
            Log.wtf(TAG, "SHA-256 should be available", x);
            digester = null;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "Could not find packageinfo for: " + callerPkg);
            digester = null;
        }
        return digester == null ? null : digester.digest();
    }

    private void createNoCredentialsPermissionNotification(Account account, Intent intent, String packageName, int userId) {
        int uid = intent.getIntExtra("uid", -1);
        String authTokenType = intent.getStringExtra("authTokenType");
        String titleAndSubtitle = this.mContext.getString(17040523, account.name);
        int index = titleAndSubtitle.indexOf(10);
        String title = titleAndSubtitle;
        String subtitle = "";
        if (index > 0) {
            title = titleAndSubtitle.substring(0, index);
            subtitle = titleAndSubtitle.substring(index + 1);
        }
        UserHandle user = UserHandle.of(userId);
        Context contextForUser = this.getContextForUser(user);
        Notification n = new Notification.Builder(contextForUser, SystemNotificationChannels.ACCOUNT).setSmallIcon(17301642).setWhen(0L).setColor(contextForUser.getColor(17170760)).setContentTitle(title).setContentText(subtitle).setContentIntent(PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0x10000000, null, user)).build();
        this.installNotification(this.getCredentialPermissionNotificationId(account, authTokenType, uid), n, packageName, user.getIdentifier());
    }

    private Intent newGrantCredentialsPermissionIntent(Account account, String packageName, int uid, AccountAuthenticatorResponse response, String authTokenType, boolean startInNewTask) {
        Intent intent = new Intent(this.mContext, GrantCredentialsPermissionActivity.class);
        if (startInNewTask) {
            intent.setFlags(0x10000000);
        }
        intent.addCategory(this.getCredentialPermissionNotificationId((Account)account, (String)authTokenType, (int)uid).mTag + (packageName != null ? packageName : ""));
        intent.putExtra("account", account);
        intent.putExtra("authTokenType", authTokenType);
        intent.putExtra("response", response);
        intent.putExtra("uid", uid);
        return intent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationId getCredentialPermissionNotificationId(Account account, String authTokenType, int uid) {
        NotificationId nId;
        UserAccounts accounts = this.getUserAccounts(UserHandle.getUserId(uid));
        HashMap hashMap = accounts.credentialsPermissionNotificationIds;
        synchronized (hashMap) {
            Pair<Pair<Account, String>, Integer> key = new Pair<Pair<Account, String>, Integer>(new Pair<Account, String>(account, authTokenType), uid);
            nId = (NotificationId)accounts.credentialsPermissionNotificationIds.get(key);
            if (nId == null) {
                String tag = "AccountManagerService:38:" + account.hashCode() + ":" + authTokenType.hashCode();
                int id2 = 38;
                nId = new NotificationId(tag, id2);
                accounts.credentialsPermissionNotificationIds.put(key, nId);
            }
        }
        return nId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationId getSigninRequiredNotificationId(UserAccounts accounts, Account account) {
        NotificationId nId;
        HashMap hashMap = accounts.signinRequiredNotificationIds;
        synchronized (hashMap) {
            nId = (NotificationId)accounts.signinRequiredNotificationIds.get(account);
            if (nId == null) {
                String tag = "AccountManagerService:37:" + account.hashCode();
                int id2 = 37;
                nId = new NotificationId(tag, id2);
                accounts.signinRequiredNotificationIds.put(account, nId);
            }
        }
        return nId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAccount(IAccountManagerResponse response, final String accountType, final String authTokenType, final String[] requiredFeatures, boolean expectActivityLaunch, Bundle optionsIn) {
        Bundle.setDefusable(optionsIn, true);
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "addAccount: accountType " + accountType + ", response " + response + ", authTokenType " + authTokenType + ", requiredFeatures " + Arrays.toString(requiredFeatures) + ", expectActivityLaunch " + expectActivityLaunch + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid());
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (accountType == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        int uid = Binder.getCallingUid();
        int userId = UserHandle.getUserId(uid);
        if (!this.canUserModifyAccounts(userId, uid)) {
            try {
                response.onError(100, "User is not allowed to add an account!");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.showCantAddAccount(100, userId);
            return;
        }
        if (!this.canUserModifyAccountsForType(userId, accountType, uid)) {
            try {
                response.onError(101, "User cannot modify accounts of this type (policy).");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.showCantAddAccount(101, userId);
            return;
        }
        int pid = Binder.getCallingPid();
        final Bundle options = optionsIn == null ? new Bundle() : optionsIn;
        options.putInt("callerUid", uid);
        options.putInt("callerPid", pid);
        int usrId = UserHandle.getCallingUserId();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(usrId);
            this.logRecordWithUid(accounts, AccountsDb.DEBUG_ACTION_CALLED_ACCOUNT_ADD, "accounts", uid);
            new Session(accounts, response, accountType, expectActivityLaunch, true, null, false, true){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.addAccount(this, this.mAccountType, authTokenType, requiredFeatures, options);
                }

                @Override
                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", addAccount, accountType " + accountType + ", requiredFeatures " + Arrays.toString(requiredFeatures);
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAccountAsUser(IAccountManagerResponse response, final String accountType, final String authTokenType, final String[] requiredFeatures, boolean expectActivityLaunch, Bundle optionsIn, int userId) {
        Bundle.setDefusable(optionsIn, true);
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "addAccount: accountType " + accountType + ", response " + response + ", authTokenType " + authTokenType + ", requiredFeatures " + Arrays.toString(requiredFeatures) + ", expectActivityLaunch " + expectActivityLaunch + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid() + ", for user id " + userId);
        }
        Preconditions.checkArgument(response != null, "response cannot be null");
        Preconditions.checkArgument(accountType != null, "accountType cannot be null");
        if (this.isCrossUser(callingUid, userId)) {
            throw new SecurityException(String.format("User %s trying to add account for %s", UserHandle.getCallingUserId(), userId));
        }
        if (!this.canUserModifyAccounts(userId, callingUid)) {
            try {
                response.onError(100, "User is not allowed to add an account!");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.showCantAddAccount(100, userId);
            return;
        }
        if (!this.canUserModifyAccountsForType(userId, accountType, callingUid)) {
            try {
                response.onError(101, "User cannot modify accounts of this type (policy).");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.showCantAddAccount(101, userId);
            return;
        }
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        final Bundle options = optionsIn == null ? new Bundle() : optionsIn;
        options.putInt("callerUid", uid);
        options.putInt("callerPid", pid);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            this.logRecordWithUid(accounts, AccountsDb.DEBUG_ACTION_CALLED_ACCOUNT_ADD, "accounts", userId);
            new Session(accounts, response, accountType, expectActivityLaunch, true, null, false, true){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.addAccount(this, this.mAccountType, authTokenType, requiredFeatures, options);
                }

                @Override
                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", addAccount, accountType " + accountType + ", requiredFeatures " + (requiredFeatures != null ? TextUtils.join((CharSequence)",", requiredFeatures) : null);
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAddAccountSession(IAccountManagerResponse response, final String accountType, final String authTokenType, final String[] requiredFeatures, boolean expectActivityLaunch, Bundle optionsIn) {
        Bundle.setDefusable(optionsIn, true);
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "startAddAccountSession: accountType " + accountType + ", response " + response + ", authTokenType " + authTokenType + ", requiredFeatures " + Arrays.toString(requiredFeatures) + ", expectActivityLaunch " + expectActivityLaunch + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid());
        }
        Preconditions.checkArgument(response != null, "response cannot be null");
        Preconditions.checkArgument(accountType != null, "accountType cannot be null");
        int uid = Binder.getCallingUid();
        int userId = UserHandle.getUserId(uid);
        if (!this.canUserModifyAccounts(userId, uid)) {
            try {
                response.onError(100, "User is not allowed to add an account!");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.showCantAddAccount(100, userId);
            return;
        }
        if (!this.canUserModifyAccountsForType(userId, accountType, uid)) {
            try {
                response.onError(101, "User cannot modify accounts of this type (policy).");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.showCantAddAccount(101, userId);
            return;
        }
        int pid = Binder.getCallingPid();
        final Bundle options = optionsIn == null ? new Bundle() : optionsIn;
        options.putInt("callerUid", uid);
        options.putInt("callerPid", pid);
        String callerPkg = optionsIn.getString("androidPackageName");
        boolean isPasswordForwardingAllowed = this.isPermitted(callerPkg, uid, "android.permission.GET_PASSWORD");
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            this.logRecordWithUid(accounts, AccountsDb.DEBUG_ACTION_CALLED_START_ACCOUNT_ADD, "accounts", uid);
            new StartAccountSession(accounts, response, accountType, expectActivityLaunch, null, false, true, isPasswordForwardingAllowed){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.startAddAccountSession(this, this.mAccountType, authTokenType, requiredFeatures, options);
                }

                @Override
                protected String toDebugString(long now) {
                    String requiredFeaturesStr = TextUtils.join((CharSequence)",", requiredFeatures);
                    return super.toDebugString(now) + ", startAddAccountSession, accountType " + accountType + ", requiredFeatures " + (requiredFeatures != null ? requiredFeaturesStr : null);
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishSessionAsUser(IAccountManagerResponse response, Bundle sessionBundle, boolean expectActivityLaunch, Bundle appInfo, int userId) {
        String accountType;
        Bundle decryptedBundle;
        Bundle.setDefusable(sessionBundle, true);
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "finishSession: response " + response + ", expectActivityLaunch " + expectActivityLaunch + ", caller's uid " + callingUid + ", caller's user id " + UserHandle.getCallingUserId() + ", pid " + Binder.getCallingPid() + ", for user id " + userId);
        }
        Preconditions.checkArgument(response != null, "response cannot be null");
        if (sessionBundle == null || sessionBundle.size() == 0) {
            throw new IllegalArgumentException("sessionBundle is empty");
        }
        if (this.isCrossUser(callingUid, userId)) {
            throw new SecurityException(String.format("User %s trying to finish session for %s without cross user permission", UserHandle.getCallingUserId(), userId));
        }
        if (!this.canUserModifyAccounts(userId, callingUid)) {
            this.sendErrorResponse(response, 100, "User is not allowed to add an account!");
            this.showCantAddAccount(100, userId);
            return;
        }
        int pid = Binder.getCallingPid();
        try {
            CryptoHelper cryptoHelper = CryptoHelper.getInstance();
            decryptedBundle = cryptoHelper.decryptBundle(sessionBundle);
            if (decryptedBundle == null) {
                this.sendErrorResponse(response, 8, "failed to decrypt session bundle");
                return;
            }
            accountType = decryptedBundle.getString("accountType");
            if (TextUtils.isEmpty(accountType)) {
                this.sendErrorResponse(response, 7, "accountType is empty");
                return;
            }
            if (appInfo != null) {
                decryptedBundle.putAll(appInfo);
            }
            decryptedBundle.putInt("callerUid", callingUid);
            decryptedBundle.putInt("callerPid", pid);
        }
        catch (GeneralSecurityException e) {
            if (Log.isLoggable(TAG, 3)) {
                Log.v(TAG, "Failed to decrypt session bundle!", e);
            }
            this.sendErrorResponse(response, 8, "failed to decrypt session bundle");
            return;
        }
        if (!this.canUserModifyAccountsForType(userId, accountType, callingUid)) {
            this.sendErrorResponse(response, 101, "User cannot modify accounts of this type (policy).");
            this.showCantAddAccount(101, userId);
            return;
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            this.logRecordWithUid(accounts, AccountsDb.DEBUG_ACTION_CALLED_ACCOUNT_SESSION_FINISH, "accounts", callingUid);
            new Session(accounts, response, accountType, expectActivityLaunch, true, null, false, true){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.finishSession(this, this.mAccountType, decryptedBundle);
                }

                @Override
                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", finishSession, accountType " + accountType;
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCantAddAccount(int errorCode, int userId) {
        DevicePolicyManagerInternal dpmi = LocalServices.getService(DevicePolicyManagerInternal.class);
        Intent intent = null;
        if (dpmi == null) {
            intent = this.getDefaultCantAddAccountIntent(errorCode);
        } else if (errorCode == 100) {
            intent = dpmi.createUserRestrictionSupportIntent(userId, "no_modify_accounts");
        } else if (errorCode == 101) {
            intent = dpmi.createShowAdminSupportIntent(userId, false);
        }
        if (intent == null) {
            intent = this.getDefaultCantAddAccountIntent(errorCode);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            this.mContext.startActivityAsUser(intent, new UserHandle(userId));
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    private Intent getDefaultCantAddAccountIntent(int errorCode) {
        Intent cantAddAccount = new Intent(this.mContext, CantAddAccountActivity.class);
        cantAddAccount.putExtra("android.accounts.extra.ERROR_CODE", errorCode);
        cantAddAccount.addFlags(0x10000000);
        return cantAddAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void confirmCredentialsAsUser(IAccountManagerResponse response, final Account account, final Bundle options, boolean expectActivityLaunch, int userId) {
        Bundle.setDefusable(options, true);
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "confirmCredentials: " + account + ", response " + response + ", expectActivityLaunch " + expectActivityLaunch + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (this.isCrossUser(callingUid, userId)) {
            throw new SecurityException(String.format("User %s trying to confirm account credentials for %s", UserHandle.getCallingUserId(), userId));
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            new Session(accounts, response, account.type, expectActivityLaunch, true, account.name, true, true){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.confirmCredentials(this, account, options);
                }

                @Override
                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", confirmCredentials, " + account;
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCredentials(IAccountManagerResponse response, final Account account, final String authTokenType, boolean expectActivityLaunch, final Bundle loginOptions) {
        Bundle.setDefusable(loginOptions, true);
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "updateCredentials: " + account + ", response " + response + ", authTokenType " + authTokenType + ", expectActivityLaunch " + expectActivityLaunch + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid());
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        int userId = UserHandle.getCallingUserId();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            new Session(accounts, response, account.type, expectActivityLaunch, true, account.name, false, true){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.updateCredentials(this, account, authTokenType, loginOptions);
                }

                @Override
                protected String toDebugString(long now) {
                    if (loginOptions != null) {
                        loginOptions.keySet();
                    }
                    return super.toDebugString(now) + ", updateCredentials, " + account + ", authTokenType " + authTokenType + ", loginOptions " + loginOptions;
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startUpdateCredentialsSession(IAccountManagerResponse response, final Account account, final String authTokenType, boolean expectActivityLaunch, final Bundle loginOptions) {
        Bundle.setDefusable(loginOptions, true);
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "startUpdateCredentialsSession: " + account + ", response " + response + ", authTokenType " + authTokenType + ", expectActivityLaunch " + expectActivityLaunch + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid());
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        int uid = Binder.getCallingUid();
        int userId = UserHandle.getCallingUserId();
        String callerPkg = loginOptions.getString("androidPackageName");
        boolean isPasswordForwardingAllowed = this.isPermitted(callerPkg, uid, "android.permission.GET_PASSWORD");
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            new StartAccountSession(accounts, response, account.type, expectActivityLaunch, account.name, false, true, isPasswordForwardingAllowed){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.startUpdateCredentialsSession(this, account, authTokenType, loginOptions);
                }

                @Override
                protected String toDebugString(long now) {
                    if (loginOptions != null) {
                        loginOptions.keySet();
                    }
                    return super.toDebugString(now) + ", startUpdateCredentialsSession, " + account + ", authTokenType " + authTokenType + ", loginOptions " + loginOptions;
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void isCredentialsUpdateSuggested(IAccountManagerResponse response, final Account account, final String statusToken) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "isCredentialsUpdateSuggested: " + account + ", response " + response + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid());
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (TextUtils.isEmpty(statusToken)) {
            throw new IllegalArgumentException("status token is empty");
        }
        int usrId = UserHandle.getCallingUserId();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(usrId);
            new Session(accounts, response, account.type, false, false, account.name, false){

                @Override
                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", isCredentialsUpdateSuggested, " + account;
                }

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.isCredentialsUpdateSuggested(this, account, statusToken);
                }

                @Override
                public void onResult(Bundle result) {
                    Bundle.setDefusable(result, true);
                    IAccountManagerResponse response = this.getResponseAndClose();
                    if (response == null) {
                        return;
                    }
                    if (result == null) {
                        AccountManagerService.this.sendErrorResponse(response, 5, "null bundle");
                        return;
                    }
                    if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                        Log.v(AccountManagerService.TAG, this.getClass().getSimpleName() + " calling onResult() on response " + response);
                    }
                    if (result.getInt("errorCode", -1) > 0) {
                        AccountManagerService.this.sendErrorResponse(response, result.getInt("errorCode"), result.getString("errorMessage"));
                        return;
                    }
                    if (!result.containsKey("booleanResult")) {
                        AccountManagerService.this.sendErrorResponse(response, 5, "no result in response");
                        return;
                    }
                    Bundle newResult = new Bundle();
                    newResult.putBoolean("booleanResult", result.getBoolean("booleanResult", false));
                    AccountManagerService.this.sendResponse(response, newResult);
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void editProperties(IAccountManagerResponse response, final String accountType, boolean expectActivityLaunch) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "editProperties: accountType " + accountType + ", response " + response + ", expectActivityLaunch " + expectActivityLaunch + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (accountType == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(accountType, callingUid, userId) && !this.isSystemUid(callingUid)) {
            String msg = String.format("uid %s cannot edit authenticator properites for account type: %s", callingUid, accountType);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            new Session(accounts, response, accountType, expectActivityLaunch, true, null, false){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.editProperties(this, this.mAccountType);
                }

                @Override
                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", editProperties, accountType " + accountType;
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    @Override
    public boolean hasAccountAccess(Account account, String packageName, UserHandle userHandle) {
        if (UserHandle.getAppId(Binder.getCallingUid()) != 1000) {
            throw new SecurityException("Can be called only by system UID");
        }
        Preconditions.checkNotNull(account, "account cannot be null");
        Preconditions.checkNotNull(packageName, "packageName cannot be null");
        Preconditions.checkNotNull(userHandle, "userHandle cannot be null");
        int userId = userHandle.getIdentifier();
        Preconditions.checkArgumentInRange(userId, 0, Integer.MAX_VALUE, "user must be concrete");
        try {
            int uid = this.mPackageManager.getPackageUidAsUser(packageName, userId);
            return this.hasAccountAccess(account, packageName, uid);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d(TAG, "Package not found " + e.getMessage());
            return false;
        }
    }

    private String getPackageNameForUid(int uid) {
        String[] packageNames = this.mPackageManager.getPackagesForUid(uid);
        if (ArrayUtils.isEmpty(packageNames)) {
            return null;
        }
        String packageName = packageNames[0];
        if (packageNames.length == 1) {
            return packageName;
        }
        int oldestVersion = Integer.MAX_VALUE;
        for (String name : packageNames) {
            try {
                int version;
                ApplicationInfo applicationInfo = this.mPackageManager.getApplicationInfo(name, 0);
                if (applicationInfo == null || (version = applicationInfo.targetSdkVersion) >= oldestVersion) continue;
                oldestVersion = version;
                packageName = name;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return packageName;
    }

    private boolean hasAccountAccess(Account account, String packageName, int uid) {
        if (packageName == null && (packageName = this.getPackageNameForUid(uid)) == null) {
            return false;
        }
        if (this.permissionIsGranted(account, null, uid, UserHandle.getUserId(uid))) {
            return true;
        }
        int visibility = this.resolveAccountVisibility(account, packageName, this.getUserAccounts(UserHandle.getUserId(uid)));
        return visibility == 1 || visibility == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntentSender createRequestAccountAccessIntentSenderAsUser(Account account, String packageName, UserHandle userHandle) {
        int uid;
        if (UserHandle.getAppId(Binder.getCallingUid()) != 1000) {
            throw new SecurityException("Can be called only by system UID");
        }
        Preconditions.checkNotNull(account, "account cannot be null");
        Preconditions.checkNotNull(packageName, "packageName cannot be null");
        Preconditions.checkNotNull(userHandle, "userHandle cannot be null");
        int userId = userHandle.getIdentifier();
        Preconditions.checkArgumentInRange(userId, 0, Integer.MAX_VALUE, "user must be concrete");
        try {
            uid = this.mPackageManager.getPackageUidAsUser(packageName, userId);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(TAG, "Unknown package " + packageName);
            return null;
        }
        Intent intent = this.newRequestAccountAccessIntent(account, packageName, uid, null);
        long identity = Binder.clearCallingIdentity();
        try {
            IntentSender intentSender = PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0x54000000, null, new UserHandle(userId)).getIntentSender();
            return intentSender;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private Intent newRequestAccountAccessIntent(final Account account, final String packageName, final int uid, final RemoteCallback callback) {
        return this.newGrantCredentialsPermissionIntent(account, packageName, uid, new AccountAuthenticatorResponse(new IAccountAuthenticatorResponse.Stub(){

            @Override
            public void onResult(Bundle value) throws RemoteException {
                this.handleAuthenticatorResponse(true);
            }

            @Override
            public void onRequestContinued() {
            }

            @Override
            public void onError(int errorCode, String errorMessage) throws RemoteException {
                this.handleAuthenticatorResponse(false);
            }

            private void handleAuthenticatorResponse(boolean accessGranted) throws RemoteException {
                AccountManagerService.this.cancelNotification(AccountManagerService.this.getCredentialPermissionNotificationId(account, "com.android.AccountManager.ACCOUNT_ACCESS_TOKEN_TYPE", uid), packageName, UserHandle.getUserHandleForUid(uid));
                if (callback != null) {
                    Bundle result = new Bundle();
                    result.putBoolean("booleanResult", accessGranted);
                    callback.sendResult(result);
                }
            }
        }), "com.android.AccountManager.ACCOUNT_ACCESS_TOKEN_TYPE", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean someUserHasAccount(Account account) {
        if (!UserHandle.isSameApp(1000, Binder.getCallingUid())) {
            throw new SecurityException("Only system can check for accounts across users");
        }
        long token = Binder.clearCallingIdentity();
        try {
            AccountAndUser[] allAccounts = this.getAllAccounts();
            for (int i = allAccounts.length - 1; i >= 0; --i) {
                if (!allAccounts[i].account.equals(account)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account[] getAccounts(int userId, String opPackageName) {
        int callingUid = Binder.getCallingUid();
        this.mAppOpsManager.checkPackage(callingUid, opPackageName);
        List<String> visibleAccountTypes = this.getTypesVisibleToCaller(callingUid, userId, opPackageName);
        if (visibleAccountTypes.isEmpty()) {
            return EMPTY_ACCOUNT_ARRAY;
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            Account[] accountArray = this.getAccountsInternal(accounts, callingUid, opPackageName, visibleAccountTypes, false);
            return accountArray;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    public AccountAndUser[] getRunningAccounts() {
        int[] runningUserIds;
        try {
            runningUserIds = ActivityManager.getService().getRunningUserIds();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        return this.getAccounts(runningUserIds);
    }

    public AccountAndUser[] getAllAccounts() {
        List<UserInfo> users = this.getUserManager().getUsers(true);
        int[] userIds = new int[users.size()];
        for (int i = 0; i < userIds.length; ++i) {
            userIds[i] = users.get((int)i).id;
        }
        return this.getAccounts(userIds);
    }

    private AccountAndUser[] getAccounts(int[] userIds) {
        ArrayList<AccountAndUser> runningAccounts = Lists.newArrayList();
        for (int userId : userIds) {
            Account[] accounts;
            UserAccounts userAccounts = this.getUserAccounts(userId);
            if (userAccounts == null) continue;
            for (Account account : accounts = this.getAccountsFromCache(userAccounts, null, Binder.getCallingUid(), null, false)) {
                runningAccounts.add(new AccountAndUser(account, userId));
            }
        }
        AccountAndUser[] accountsArray = new AccountAndUser[runningAccounts.size()];
        return runningAccounts.toArray(accountsArray);
    }

    @Override
    public Account[] getAccountsAsUser(String type, int userId, String opPackageName) {
        int callingUid = Binder.getCallingUid();
        this.mAppOpsManager.checkPackage(callingUid, opPackageName);
        return this.getAccountsAsUserForPackage(type, userId, opPackageName, -1, opPackageName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Account[] getAccountsAsUserForPackage(String type, int userId, String callingPackage, int packageUid, String opPackageName, boolean includeUserManagedNotVisible) {
        List<String> visibleAccountTypes;
        int callingUid = Binder.getCallingUid();
        if (userId != UserHandle.getCallingUserId() && callingUid != 1000 && this.mContext.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            throw new SecurityException("User " + UserHandle.getCallingUserId() + " trying to get account for " + userId);
        }
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "getAccounts: accountType " + type + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid());
        }
        List<String> managedTypes = this.getTypesManagedByCaller(callingUid, UserHandle.getUserId(callingUid));
        if (packageUid != -1 && (UserHandle.isSameApp(callingUid, 1000) || type != null && managedTypes.contains(type))) {
            callingUid = packageUid;
            opPackageName = callingPackage;
        }
        if ((visibleAccountTypes = this.getTypesVisibleToCaller(callingUid, userId, opPackageName)).isEmpty() || type != null && !visibleAccountTypes.contains(type)) {
            return EMPTY_ACCOUNT_ARRAY;
        }
        if (visibleAccountTypes.contains(type)) {
            visibleAccountTypes = new ArrayList<String>();
            visibleAccountTypes.add(type);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            Account[] accountArray = this.getAccountsInternal(accounts, callingUid, opPackageName, visibleAccountTypes, includeUserManagedNotVisible);
            return accountArray;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    private Account[] getAccountsInternal(UserAccounts userAccounts, int callingUid, String callingPackage, List<String> visibleAccountTypes, boolean includeUserManagedNotVisible) {
        ArrayList<Account> visibleAccounts = new ArrayList<Account>();
        for (String visibleType : visibleAccountTypes) {
            Account[] accountsForType = this.getAccountsFromCache(userAccounts, visibleType, callingUid, callingPackage, includeUserManagedNotVisible);
            if (accountsForType == null) continue;
            visibleAccounts.addAll(Arrays.asList(accountsForType));
        }
        Account[] result = new Account[visibleAccounts.size()];
        for (int i = 0; i < visibleAccounts.size(); ++i) {
            result[i] = (Account)visibleAccounts.get(i);
        }
        return result;
    }

    @Override
    public void addSharedAccountsFromParentUser(int parentUserId, int userId, String opPackageName) {
        Account[] accounts;
        AccountManagerService.checkManageOrCreateUsersPermission("addSharedAccountsFromParentUser");
        for (Account account : accounts = this.getAccountsAsUser(null, parentUserId, opPackageName)) {
            this.addSharedAccountAsUser(account, userId);
        }
    }

    private boolean addSharedAccountAsUser(Account account, int userId) {
        userId = this.handleIncomingUser(userId);
        UserAccounts accounts = this.getUserAccounts(userId);
        accounts.accountsDb.deleteSharedAccount(account);
        long accountId = accounts.accountsDb.insertSharedAccount(account);
        if (accountId < 0L) {
            Log.w(TAG, "insertAccountIntoDatabase: " + account + ", skipping the DB insert failed");
            return false;
        }
        this.logRecord(AccountsDb.DEBUG_ACTION_ACCOUNT_ADD, "shared_accounts", accountId, accounts);
        return true;
    }

    @Override
    public boolean renameSharedAccountAsUser(Account account, String newName, int userId) {
        userId = this.handleIncomingUser(userId);
        UserAccounts accounts = this.getUserAccounts(userId);
        long sharedTableAccountId = accounts.accountsDb.findSharedAccountId(account);
        int r = accounts.accountsDb.renameSharedAccount(account, newName);
        if (r > 0) {
            int callingUid = AccountManagerService.getCallingUid();
            this.logRecord(AccountsDb.DEBUG_ACTION_ACCOUNT_RENAME, "shared_accounts", sharedTableAccountId, accounts, callingUid);
            this.renameAccountInternal(accounts, account, newName);
        }
        return r > 0;
    }

    @Override
    public boolean removeSharedAccountAsUser(Account account, int userId) {
        return this.removeSharedAccountAsUser(account, userId, AccountManagerService.getCallingUid());
    }

    private boolean removeSharedAccountAsUser(Account account, int userId, int callingUid) {
        userId = this.handleIncomingUser(userId);
        UserAccounts accounts = this.getUserAccounts(userId);
        long sharedTableAccountId = accounts.accountsDb.findSharedAccountId(account);
        boolean deleted = accounts.accountsDb.deleteSharedAccount(account);
        if (deleted) {
            this.logRecord(AccountsDb.DEBUG_ACTION_ACCOUNT_REMOVE, "shared_accounts", sharedTableAccountId, accounts, callingUid);
            this.removeAccountInternal(accounts, account, callingUid);
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Account[] getSharedAccountsAsUser(int userId) {
        userId = this.handleIncomingUser(userId);
        UserAccounts accounts = this.getUserAccounts(userId);
        Object object = accounts.dbLock;
        synchronized (object) {
            List<Account> accountList = accounts.accountsDb.getSharedAccounts();
            Account[] accountArray = new Account[accountList.size()];
            accountList.toArray(accountArray);
            return accountArray;
        }
    }

    @Override
    public Account[] getAccounts(String type, String opPackageName) {
        return this.getAccountsAsUser(type, UserHandle.getCallingUserId(), opPackageName);
    }

    @Override
    public Account[] getAccountsForPackage(String packageName, int uid, String opPackageName) {
        int callingUid = Binder.getCallingUid();
        if (!UserHandle.isSameApp(callingUid, 1000)) {
            throw new SecurityException("getAccountsForPackage() called from unauthorized uid " + callingUid + " with uid=" + uid);
        }
        return this.getAccountsAsUserForPackage(null, UserHandle.getCallingUserId(), packageName, uid, opPackageName, true);
    }

    @Override
    public Account[] getAccountsByTypeForPackage(String type, String packageName, String opPackageName) {
        int callingUid = Binder.getCallingUid();
        int userId = UserHandle.getCallingUserId();
        this.mAppOpsManager.checkPackage(callingUid, opPackageName);
        int packageUid = -1;
        try {
            packageUid = this.mPackageManager.getPackageUidAsUser(packageName, userId);
        }
        catch (PackageManager.NameNotFoundException re) {
            Slog.e(TAG, "Couldn't determine the packageUid for " + packageName + re);
            return EMPTY_ACCOUNT_ARRAY;
        }
        if (!UserHandle.isSameApp(callingUid, 1000) && type != null && !this.isAccountManagedByCaller(type, callingUid, userId)) {
            return EMPTY_ACCOUNT_ARRAY;
        }
        if (!UserHandle.isSameApp(callingUid, 1000) && type == null) {
            return this.getAccountsAsUserForPackage(type, userId, packageName, packageUid, opPackageName, false);
        }
        return this.getAccountsAsUserForPackage(type, userId, packageName, packageUid, opPackageName, true);
    }

    private boolean needToStartChooseAccountActivity(Account[] accounts, String callingPackage) {
        if (accounts.length < 1) {
            return false;
        }
        if (accounts.length > 1) {
            return true;
        }
        Account account = accounts[0];
        UserAccounts userAccounts = this.getUserAccounts(UserHandle.getCallingUserId());
        int visibility = this.resolveAccountVisibility(account, callingPackage, userAccounts);
        return visibility == 4;
    }

    private void startChooseAccountActivityWithAccounts(IAccountManagerResponse response, Account[] accounts, String callingPackage) {
        Intent intent = new Intent(this.mContext, ChooseAccountActivity.class);
        intent.putExtra("accounts", accounts);
        intent.putExtra("accountManagerResponse", new AccountManagerResponse(response));
        intent.putExtra("androidPackageName", callingPackage);
        this.mContext.startActivityAsUser(intent, UserHandle.of(UserHandle.getCallingUserId()));
    }

    private void handleGetAccountsResult(IAccountManagerResponse response, Account[] accounts, String callingPackage) {
        if (this.needToStartChooseAccountActivity(accounts, callingPackage)) {
            this.startChooseAccountActivityWithAccounts(response, accounts, callingPackage);
            return;
        }
        if (accounts.length == 1) {
            Bundle bundle = new Bundle();
            bundle.putString("authAccount", accounts[0].name);
            bundle.putString("accountType", accounts[0].type);
            this.onResult(response, bundle);
            return;
        }
        this.onResult(response, new Bundle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAccountByTypeAndFeatures(final IAccountManagerResponse response, String accountType, String[] features, final String opPackageName) {
        int callingUid = Binder.getCallingUid();
        this.mAppOpsManager.checkPackage(callingUid, opPackageName);
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "getAccount: accountType " + accountType + ", response " + response + ", features " + Arrays.toString(features) + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (accountType == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        int userId = UserHandle.getCallingUserId();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts userAccounts = this.getUserAccounts(userId);
            if (ArrayUtils.isEmpty(features)) {
                Account[] accountsWithManagedNotVisible = this.getAccountsFromCache(userAccounts, accountType, callingUid, opPackageName, true);
                this.handleGetAccountsResult(response, accountsWithManagedNotVisible, opPackageName);
                return;
            }
            IAccountManagerResponse.Stub retrieveAccountsResponse = new IAccountManagerResponse.Stub(){

                @Override
                public void onResult(Bundle value) throws RemoteException {
                    Parcelable[] parcelables = value.getParcelableArray("accounts");
                    Account[] accounts = new Account[parcelables.length];
                    for (int i = 0; i < parcelables.length; ++i) {
                        accounts[i] = (Account)parcelables[i];
                    }
                    AccountManagerService.this.handleGetAccountsResult(response, accounts, opPackageName);
                }

                @Override
                public void onError(int errorCode, String errorMessage) throws RemoteException {
                }
            };
            new GetAccountsByTypeAndFeatureSession(userAccounts, (IAccountManagerResponse)retrieveAccountsResponse, accountType, features, callingUid, opPackageName, true).bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAccountsByFeatures(IAccountManagerResponse response, String type, String[] features, String opPackageName) {
        int callingUid = Binder.getCallingUid();
        this.mAppOpsManager.checkPackage(callingUid, opPackageName);
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "getAccounts: accountType " + type + ", response " + response + ", features " + Arrays.toString(features) + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        int userId = UserHandle.getCallingUserId();
        List<String> visibleAccountTypes = this.getTypesVisibleToCaller(callingUid, userId, opPackageName);
        if (!visibleAccountTypes.contains(type)) {
            Bundle result = new Bundle();
            result.putParcelableArray("accounts", EMPTY_ACCOUNT_ARRAY);
            try {
                response.onResult(result);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Cannot respond to caller do to exception.", e);
            }
            return;
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts userAccounts = this.getUserAccounts(userId);
            if (features == null || features.length == 0) {
                Parcelable[] accounts = this.getAccountsFromCache(userAccounts, type, callingUid, opPackageName, false);
                Bundle result = new Bundle();
                result.putParcelableArray("accounts", accounts);
                this.onResult(response, result);
                return;
            }
            new GetAccountsByTypeAndFeatureSession(userAccounts, response, type, features, callingUid, opPackageName, false).bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAccountAccessed(String token) throws RemoteException {
        int uid = Binder.getCallingUid();
        if (UserHandle.getAppId(uid) == 1000) {
            return;
        }
        int userId = UserHandle.getCallingUserId();
        long identity = Binder.clearCallingIdentity();
        try {
            for (Account account : this.getAccounts(userId, this.mContext.getOpPackageName())) {
                if (!Objects.equals(account.getAccessId(), token) || this.hasAccountAccess(account, null, uid)) continue;
                this.updateAppPermission(account, "com.android.AccountManager.ACCOUNT_ACCESS_TOKEN_TYPE", uid, true);
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void logRecord(UserAccounts accounts, String action, String tableName) {
        this.logRecord(action, tableName, -1L, accounts);
    }

    private void logRecordWithUid(UserAccounts accounts, String action, String tableName, int uid) {
        this.logRecord(action, tableName, -1L, accounts, uid);
    }

    private void logRecord(String action, String tableName, long accountId, UserAccounts userAccount) {
        this.logRecord(action, tableName, accountId, userAccount, AccountManagerService.getCallingUid());
    }

    private void logRecord(String action, String tableName, long accountId, UserAccounts userAccount, int callingUid) {
        class LogRecordTask
        implements Runnable {
            private final String action;
            private final String tableName;
            private final long accountId;
            private final UserAccounts userAccount;
            private final int callingUid;
            private final long userDebugDbInsertionPoint;

            LogRecordTask(String action, String tableName, long accountId, UserAccounts userAccount, int callingUid, long userDebugDbInsertionPoint) {
                this.action = action;
                this.tableName = tableName;
                this.accountId = accountId;
                this.userAccount = userAccount;
                this.callingUid = callingUid;
                this.userDebugDbInsertionPoint = userDebugDbInsertionPoint;
            }

            @Override
            public void run() {
                SQLiteStatement logStatement = this.userAccount.statementForLogging;
                logStatement.bindLong(1, this.accountId);
                logStatement.bindString(2, this.action);
                logStatement.bindString(3, AccountManagerService.this.mDateFormat.format(new Date()));
                logStatement.bindLong(4, this.callingUid);
                logStatement.bindString(5, this.tableName);
                logStatement.bindLong(6, this.userDebugDbInsertionPoint);
                try {
                    logStatement.execute();
                }
                catch (IllegalStateException e) {
                    Slog.w(AccountManagerService.TAG, "Failed to insert a log record. accountId=" + this.accountId + " action=" + this.action + " tableName=" + this.tableName + " Error: " + e);
                }
                finally {
                    logStatement.clearBindings();
                }
            }
        }
        LogRecordTask logTask = new LogRecordTask(action, tableName, accountId, userAccount, callingUid, userAccount.debugDbInsertionPoint);
        userAccount.debugDbInsertionPoint = (userAccount.debugDbInsertionPoint + 1) % 64;
        this.mHandler.post(logTask);
    }

    private void initializeDebugDbSizeAndCompileSqlStatementForLogging(UserAccounts userAccount) {
        userAccount.debugDbInsertionPoint = userAccount.accountsDb.calculateDebugTableInsertionPoint();
        userAccount.statementForLogging = userAccount.accountsDb.compileSqlStatementForLogging();
    }

    public IBinder onBind(Intent intent) {
        return this.asBinder();
    }

    private static boolean scanArgs(String[] args, String value) {
        if (args != null) {
            for (String arg : args) {
                if (!value.equals(arg)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, fout)) {
            return;
        }
        boolean isCheckinRequest = AccountManagerService.scanArgs(args, "--checkin") || AccountManagerService.scanArgs(args, "-c");
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)fout, "  ");
        List<UserInfo> users = this.getUserManager().getUsers();
        for (UserInfo user : users) {
            ipw.println("User " + user + ":");
            ipw.increaseIndent();
            this.dumpUser(this.getUserAccounts(user.id), fd, ipw, args, isCheckinRequest);
            ipw.println();
            ipw.decreaseIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpUser(UserAccounts userAccounts, FileDescriptor fd, PrintWriter fout, String[] args, boolean isCheckinRequest) {
        boolean bl;
        if (isCheckinRequest) {
            Object object = userAccounts.dbLock;
            synchronized (object) {
                userAccounts.accountsDb.dumpDeAccountsTable(fout);
            }
        }
        Account[] accounts = this.getAccountsFromCache(userAccounts, null, 1000, null, false);
        fout.println("Accounts: " + accounts.length);
        for (Account account : accounts) {
            fout.println("  " + account);
        }
        fout.println();
        Object object = userAccounts.dbLock;
        synchronized (object) {
            userAccounts.accountsDb.dumpDebugTable(fout);
        }
        fout.println();
        LinkedHashMap<String, Session> linkedHashMap = this.mSessions;
        synchronized (linkedHashMap) {
            long now = SystemClock.elapsedRealtime();
            fout.println("Active Sessions: " + this.mSessions.size());
            for (Session session : this.mSessions.values()) {
                fout.println("  " + session.toDebugString(now));
            }
        }
        fout.println();
        this.mAuthenticatorCache.dump(fd, fout, args, userAccounts.userId);
        Object object2 = this.mUsers;
        synchronized (object2) {
            bl = this.isLocalUnlockedUser(userAccounts.userId);
        }
        if (!bl) {
            return;
        }
        fout.println();
        object2 = userAccounts.dbLock;
        synchronized (object2) {
            Map<Account, Map<String, Integer>> allVisibilityValues = userAccounts.accountsDb.findAllVisibilityValues();
            fout.println("Account visibility:");
            for (Account account : allVisibilityValues.keySet()) {
                fout.println("  " + account.name);
                Map<String, Integer> visibilities = allVisibilityValues.get(account);
                for (Map.Entry<String, Integer> entry : visibilities.entrySet()) {
                    fout.println("    " + entry.getKey() + ", " + entry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotification(UserAccounts accounts, Account account, CharSequence message, Intent intent, String packageName, int userId) {
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "doNotification: " + message + " intent:" + intent);
            }
            if (intent.getComponent() != null && GrantCredentialsPermissionActivity.class.getName().equals(intent.getComponent().getClassName())) {
                this.createNoCredentialsPermissionNotification(account, intent, packageName, userId);
            } else {
                Context contextForUser = this.getContextForUser(new UserHandle(userId));
                NotificationId id2 = this.getSigninRequiredNotificationId(accounts, account);
                intent.addCategory(id2.mTag);
                String notificationTitleFormat = contextForUser.getText(17040358).toString();
                Notification n = new Notification.Builder(contextForUser, SystemNotificationChannels.ACCOUNT).setWhen(0L).setSmallIcon(17301642).setColor(contextForUser.getColor(17170760)).setContentTitle(String.format(notificationTitleFormat, account.name)).setContentText(message).setContentIntent(PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0x10000000, null, new UserHandle(userId))).build();
                this.installNotification(id2, n, packageName, userId);
            }
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installNotification(NotificationId id2, Notification notification, String packageName, int userId) {
        long token = AccountManagerService.clearCallingIdentity();
        try {
            INotificationManager notificationManager = this.mInjector.getNotificationManager();
            try {
                notificationManager.enqueueNotificationWithTag(packageName, packageName, id2.mTag, id2.mId, notification, userId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void cancelNotification(NotificationId id2, UserHandle user) {
        this.cancelNotification(id2, this.mContext.getPackageName(), user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelNotification(NotificationId id2, String packageName, UserHandle user) {
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            INotificationManager service = this.mInjector.getNotificationManager();
            service.cancelNotificationWithTag(packageName, id2.mTag, id2.mId, user.getIdentifier());
        }
        catch (RemoteException remoteException) {
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPermittedForPackage(String packageName, int uid, int userId, String ... permissions) {
        long identity = Binder.clearCallingIdentity();
        try {
            IPackageManager pm = ActivityThread.getPackageManager();
            for (String perm : permissions) {
                int opCode;
                if (pm.checkPermission(perm, packageName, userId) != 0 || (opCode = AppOpsManager.permissionToOpCode(perm)) != -1 && this.mAppOpsManager.noteOpNoThrow(opCode, uid, packageName) != 0) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return false;
    }

    private boolean isPermitted(String opPackageName, int callingUid, String ... permissions) {
        for (String perm : permissions) {
            int opCode;
            if (this.mContext.checkCallingOrSelfPermission(perm) != 0) continue;
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "  caller uid " + callingUid + " has " + perm);
            }
            if ((opCode = AppOpsManager.permissionToOpCode(perm)) != -1 && this.mAppOpsManager.noteOpNoThrow(opCode, callingUid, opPackageName) != 0) continue;
            return true;
        }
        return false;
    }

    private int handleIncomingUser(int userId) {
        try {
            return ActivityManager.getService().handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, true, "", null);
        }
        catch (RemoteException remoteException) {
            return userId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPrivileged(int callingUid) {
        long identityToken = Binder.clearCallingIdentity();
        try {
            String[] packages = this.mPackageManager.getPackagesForUid(callingUid);
            if (packages == null) {
                Log.d(TAG, "No packages for callingUid " + callingUid);
                boolean bl = false;
                return bl;
            }
            for (String name : packages) {
                try {
                    PackageInfo packageInfo = this.mPackageManager.getPackageInfo(name, 0);
                    if (packageInfo == null || (packageInfo.applicationInfo.privateFlags & 8) == 0) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.d(TAG, "Package not found " + e.getMessage());
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
        }
        return false;
    }

    private boolean permissionIsGranted(Account account, String authTokenType, int callerUid, int userId) {
        if (UserHandle.getAppId(callerUid) == 1000) {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "Access to " + account + " granted calling uid is system");
            }
            return true;
        }
        if (this.isPrivileged(callerUid)) {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "Access to " + account + " granted calling uid " + callerUid + " privileged");
            }
            return true;
        }
        if (account != null && this.isAccountManagedByCaller(account.type, callerUid, userId)) {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "Access to " + account + " granted calling uid " + callerUid + " manages the account");
            }
            return true;
        }
        if (account != null && this.hasExplicitlyGrantedPermission(account, authTokenType, callerUid)) {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "Access to " + account + " granted calling uid " + callerUid + " user granted access");
            }
            return true;
        }
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "Access to " + account + " not granted for uid " + callerUid);
        }
        return false;
    }

    private boolean isAccountVisibleToCaller(String accountType, int callingUid, int userId, String opPackageName) {
        if (accountType == null) {
            return false;
        }
        return this.getTypesVisibleToCaller(callingUid, userId, opPackageName).contains(accountType);
    }

    private boolean checkGetAccountsPermission(String packageName, int uid, int userId) {
        return this.isPermittedForPackage(packageName, uid, userId, "android.permission.GET_ACCOUNTS", "android.permission.GET_ACCOUNTS_PRIVILEGED");
    }

    private boolean checkReadContactsPermission(String packageName, int uid, int userId) {
        return this.isPermittedForPackage(packageName, uid, userId, "android.permission.READ_CONTACTS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean accountTypeManagesContacts(String accountType, int userId) {
        Collection<RegisteredServicesCache.ServiceInfo<AuthenticatorDescription>> serviceInfos;
        if (accountType == null) {
            return false;
        }
        long identityToken = Binder.clearCallingIdentity();
        try {
            serviceInfos = this.mAuthenticatorCache.getAllServices(userId);
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
        }
        for (RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> serviceInfo : serviceInfos) {
            if (!accountType.equals(((AuthenticatorDescription)serviceInfo.type).type)) continue;
            return this.isPermittedForPackage(((AuthenticatorDescription)serviceInfo.type).packageName, serviceInfo.uid, userId, "android.permission.WRITE_CONTACTS");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkPackageSignature(String accountType, int callingUid, int userId) {
        Collection<RegisteredServicesCache.ServiceInfo<AuthenticatorDescription>> serviceInfos;
        if (accountType == null) {
            return 0;
        }
        long identityToken = Binder.clearCallingIdentity();
        try {
            serviceInfos = this.mAuthenticatorCache.getAllServices(userId);
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
        }
        for (RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> serviceInfo : serviceInfos) {
            if (!accountType.equals(((AuthenticatorDescription)serviceInfo.type).type)) continue;
            if (serviceInfo.uid == callingUid) {
                return 2;
            }
            int sigChk = this.mPackageManager.checkSignatures(serviceInfo.uid, callingUid);
            if (sigChk != 0) continue;
            return 1;
        }
        return 0;
    }

    private boolean isAccountManagedByCaller(String accountType, int callingUid, int userId) {
        if (accountType == null) {
            return false;
        }
        return this.getTypesManagedByCaller(callingUid, userId).contains(accountType);
    }

    private List<String> getTypesVisibleToCaller(int callingUid, int userId, String opPackageName) {
        return this.getTypesForCaller(callingUid, userId, true);
    }

    private List<String> getTypesManagedByCaller(int callingUid, int userId) {
        return this.getTypesForCaller(callingUid, userId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getTypesForCaller(int callingUid, int userId, boolean isOtherwisePermitted) {
        Collection<RegisteredServicesCache.ServiceInfo<AuthenticatorDescription>> serviceInfos;
        ArrayList<String> managedAccountTypes = new ArrayList<String>();
        long identityToken = Binder.clearCallingIdentity();
        try {
            serviceInfos = this.mAuthenticatorCache.getAllServices(userId);
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
        }
        for (RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> serviceInfo : serviceInfos) {
            if (!isOtherwisePermitted && this.mPackageManager.checkSignatures(serviceInfo.uid, callingUid) != 0) continue;
            managedAccountTypes.add(((AuthenticatorDescription)serviceInfo.type).type);
        }
        return managedAccountTypes;
    }

    private boolean isAccountPresentForCaller(String accountName, String accountType) {
        if (this.getUserAccountsForCaller().accountCache.containsKey(accountType)) {
            for (Account account : this.getUserAccountsForCaller().accountCache.get(accountType)) {
                if (!account.name.equals(accountName)) continue;
                return true;
            }
        }
        return false;
    }

    private static void checkManageUsersPermission(String message) {
        if (ActivityManager.checkComponentPermission("android.permission.MANAGE_USERS", Binder.getCallingUid(), -1, true) != 0) {
            throw new SecurityException("You need MANAGE_USERS permission to: " + message);
        }
    }

    private static void checkManageOrCreateUsersPermission(String message) {
        if (ActivityManager.checkComponentPermission("android.permission.MANAGE_USERS", Binder.getCallingUid(), -1, true) != 0 && ActivityManager.checkComponentPermission("android.permission.CREATE_USERS", Binder.getCallingUid(), -1, true) != 0) {
            throw new SecurityException("You need MANAGE_USERS or CREATE_USERS permission to: " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasExplicitlyGrantedPermission(Account account, String authTokenType, int callerUid) {
        if (UserHandle.getAppId(callerUid) == 1000) {
            return true;
        }
        UserAccounts accounts = this.getUserAccounts(UserHandle.getUserId(callerUid));
        Object object = accounts.dbLock;
        synchronized (object) {
            Object object2 = accounts.cacheLock;
            synchronized (object2) {
                boolean permissionGranted;
                long grantsCount = authTokenType != null ? accounts.accountsDb.findMatchingGrantsCount(callerUid, authTokenType, account) : accounts.accountsDb.findMatchingGrantsCountAnyToken(callerUid, account);
                boolean bl = permissionGranted = grantsCount > 0L;
                if (!permissionGranted && ActivityManager.isRunningInTestHarness()) {
                    Log.d(TAG, "no credentials permission for usage of " + account + ", " + authTokenType + " by uid " + callerUid + " but ignoring since device is in test harness.");
                    return true;
                }
                return permissionGranted;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSystemUid(int callingUid) {
        block8: {
            String[] packages = null;
            long ident = Binder.clearCallingIdentity();
            try {
                packages = this.mPackageManager.getPackagesForUid(callingUid);
                if (packages != null) {
                    for (String name : packages) {
                        try {
                            PackageInfo packageInfo = this.mPackageManager.getPackageInfo(name, 0);
                            if (packageInfo == null || (packageInfo.applicationInfo.flags & 1) == 0) continue;
                            boolean bl = true;
                            return bl;
                        }
                        catch (PackageManager.NameNotFoundException e) {
                            Log.w(TAG, String.format("Could not find package [%s]", name), e);
                        }
                    }
                    break block8;
                }
                Log.w(TAG, "No known packages with uid " + callingUid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        return false;
    }

    private void checkReadAccountsPermitted(int callingUid, String accountType, int userId, String opPackageName) {
        if (!this.isAccountVisibleToCaller(accountType, callingUid, userId, opPackageName)) {
            String msg = String.format("caller uid %s cannot access %s accounts", callingUid, accountType);
            Log.w(TAG, "  " + msg);
            throw new SecurityException(msg);
        }
    }

    private boolean canUserModifyAccounts(int userId, int callingUid) {
        if (this.isProfileOwner(callingUid)) {
            return true;
        }
        return !this.getUserManager().getUserRestrictions(new UserHandle(userId)).getBoolean("no_modify_accounts");
    }

    private boolean canUserModifyAccountsForType(int userId, String accountType, int callingUid) {
        if (this.isProfileOwner(callingUid)) {
            return true;
        }
        DevicePolicyManager dpm = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
        String[] typesArray = dpm.getAccountTypesWithManagementDisabledAsUser(userId);
        if (typesArray == null) {
            return true;
        }
        for (String forbiddenType : typesArray) {
            if (!forbiddenType.equals(accountType)) continue;
            return false;
        }
        return true;
    }

    private boolean isProfileOwner(int uid) {
        DevicePolicyManagerInternal dpmi = LocalServices.getService(DevicePolicyManagerInternal.class);
        return dpmi != null && dpmi.isActiveAdminWithPolicy(uid, -1);
    }

    @Override
    public void updateAppPermission(Account account, String authTokenType, int uid, boolean value) throws RemoteException {
        int callingUid = AccountManagerService.getCallingUid();
        if (UserHandle.getAppId(callingUid) != 1000) {
            throw new SecurityException();
        }
        if (value) {
            this.grantAppPermission(account, authTokenType, uid);
        } else {
            this.revokeAppPermission(account, authTokenType, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void grantAppPermission(Account account, String authTokenType, int uid) {
        if (account == null || authTokenType == null) {
            Log.e(TAG, "grantAppPermission: called with invalid arguments", new Exception());
            return;
        }
        UserAccounts accounts = this.getUserAccounts(UserHandle.getUserId(uid));
        Iterator<AccountManagerInternal.OnAppPermissionChangeListener> iterator = accounts.dbLock;
        synchronized (iterator) {
            Object object = accounts.cacheLock;
            synchronized (object) {
                long accountId = accounts.accountsDb.findDeAccountId(account);
                if (accountId >= 0L) {
                    accounts.accountsDb.insertGrant(accountId, authTokenType, uid);
                }
                this.cancelNotification(this.getCredentialPermissionNotificationId(account, authTokenType, uid), UserHandle.of(accounts.userId));
                this.cancelAccountAccessRequestNotificationIfNeeded(account, uid, true);
            }
        }
        for (AccountManagerInternal.OnAppPermissionChangeListener listener : this.mAppPermissionChangeListeners) {
            this.mHandler.post(() -> listener.onAppPermissionChanged(account, uid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revokeAppPermission(Account account, String authTokenType, int uid) {
        if (account == null || authTokenType == null) {
            Log.e(TAG, "revokeAppPermission: called with invalid arguments", new Exception());
            return;
        }
        UserAccounts accounts = this.getUserAccounts(UserHandle.getUserId(uid));
        Iterator<AccountManagerInternal.OnAppPermissionChangeListener> iterator = accounts.dbLock;
        synchronized (iterator) {
            Object object = accounts.cacheLock;
            synchronized (object) {
                accounts.accountsDb.beginTransaction();
                try {
                    long accountId = accounts.accountsDb.findDeAccountId(account);
                    if (accountId >= 0L) {
                        accounts.accountsDb.deleteGrantsByAccountIdAuthTokenTypeAndUid(accountId, authTokenType, uid);
                        accounts.accountsDb.setTransactionSuccessful();
                    }
                }
                finally {
                    accounts.accountsDb.endTransaction();
                }
                this.cancelNotification(this.getCredentialPermissionNotificationId(account, authTokenType, uid), UserHandle.of(accounts.userId));
            }
        }
        for (AccountManagerInternal.OnAppPermissionChangeListener listener : this.mAppPermissionChangeListeners) {
            this.mHandler.post(() -> listener.onAppPermissionChanged(account, uid));
        }
    }

    private void removeAccountFromCacheLocked(UserAccounts accounts, Account account) {
        Account[] oldAccountsForType = accounts.accountCache.get(account.type);
        if (oldAccountsForType != null) {
            ArrayList<Account> newAccountsList = new ArrayList<Account>();
            for (Account curAccount : oldAccountsForType) {
                if (curAccount.equals(account)) continue;
                newAccountsList.add(curAccount);
            }
            if (newAccountsList.isEmpty()) {
                accounts.accountCache.remove(account.type);
            } else {
                Account[] newAccountsForType = new Account[newAccountsList.size()];
                newAccountsForType = newAccountsList.toArray(newAccountsForType);
                accounts.accountCache.put(account.type, newAccountsForType);
            }
        }
        accounts.userDataCache.remove(account);
        accounts.authTokenCache.remove(account);
        accounts.previousNameCache.remove(account);
        accounts.visibilityCache.remove(account);
    }

    private Account insertAccountIntoCacheLocked(UserAccounts accounts, Account account) {
        Account[] accountsForType = accounts.accountCache.get(account.type);
        int oldLength = accountsForType != null ? accountsForType.length : 0;
        Account[] newAccountsForType = new Account[oldLength + 1];
        if (accountsForType != null) {
            System.arraycopy(accountsForType, 0, newAccountsForType, 0, oldLength);
        }
        String token = account.getAccessId() != null ? account.getAccessId() : UUID.randomUUID().toString();
        newAccountsForType[oldLength] = new Account(account, token);
        accounts.accountCache.put(account.type, newAccountsForType);
        return newAccountsForType[oldLength];
    }

    private Account[] filterAccounts(UserAccounts accounts, Account[] unfiltered, int callingUid, String callingPackage, boolean includeManagedNotVisible) {
        String visibilityFilterPackage = callingPackage;
        if (visibilityFilterPackage == null) {
            visibilityFilterPackage = this.getPackageNameForUid(callingUid);
        }
        LinkedHashMap<Account, Integer> firstPass = new LinkedHashMap<Account, Integer>();
        for (Account account : unfiltered) {
            int visibility = this.resolveAccountVisibility(account, visibilityFilterPackage, accounts);
            if (visibility != 1 && visibility != 2 && (!includeManagedNotVisible || visibility != 4)) continue;
            firstPass.put(account, visibility);
        }
        Map<Account, Integer> secondPass = this.filterSharedAccounts(accounts, firstPass, callingUid, callingPackage);
        Account[] filtered = new Account[secondPass.size()];
        filtered = secondPass.keySet().toArray(filtered);
        return filtered;
    }

    /*
     * WARNING - void declaration
     */
    private Map<Account, Integer> filterSharedAccounts(UserAccounts userAccounts, Map<Account, Integer> unfiltered, int callingUid, String callingPackage) {
        if (this.getUserManager() == null || userAccounts == null || userAccounts.userId < 0 || callingUid == 1000) {
            return unfiltered;
        }
        UserInfo user = this.getUserManager().getUserInfo(userAccounts.userId);
        if (user != null && user.isRestricted()) {
            String requiredAccountType;
            Account[] sharedAccounts;
            block14: {
                void var10_12;
                String[] packages = this.mPackageManager.getPackagesForUid(callingUid);
                if (packages == null) {
                    packages = new String[]{};
                }
                String visibleList = this.mContext.getResources().getString(17039630);
                String[] stringArray = packages;
                int n = stringArray.length;
                boolean bl = false;
                while (var10_12 < n) {
                    String packageName = stringArray[var10_12];
                    if (visibleList.contains(";" + packageName + ";")) {
                        return unfiltered;
                    }
                    ++var10_12;
                }
                sharedAccounts = this.getSharedAccountsAsUser(userAccounts.userId);
                if (ArrayUtils.isEmpty(sharedAccounts)) {
                    return unfiltered;
                }
                requiredAccountType = "";
                try {
                    if (callingPackage != null) {
                        PackageInfo packageInfo = this.mPackageManager.getPackageInfo(callingPackage, 0);
                        if (packageInfo != null && packageInfo.restrictedAccountType != null) {
                            requiredAccountType = packageInfo.restrictedAccountType;
                        }
                        break block14;
                    }
                    for (String packageName : packages) {
                        PackageInfo pi = this.mPackageManager.getPackageInfo(packageName, 0);
                        if (pi == null || pi.restrictedAccountType == null) continue;
                        requiredAccountType = pi.restrictedAccountType;
                        break;
                    }
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Log.d(TAG, "Package not found " + nameNotFoundException.getMessage());
                }
            }
            LinkedHashMap<Account, Integer> linkedHashMap = new LinkedHashMap<Account, Integer>();
            for (Map.Entry<Account, Integer> entry : unfiltered.entrySet()) {
                Account account = entry.getKey();
                if (account.type.equals(requiredAccountType)) {
                    linkedHashMap.put(account, entry.getValue());
                    continue;
                }
                boolean found = false;
                for (Account shared : sharedAccounts) {
                    if (!shared.equals(account)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                linkedHashMap.put(account, entry.getValue());
            }
            return linkedHashMap;
        }
        return unfiltered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Account[] getAccountsFromCache(UserAccounts userAccounts, String accountType, int callingUid, String callingPackage, boolean includeManagedNotVisible) {
        Account[] accountsArray;
        Preconditions.checkState(!Thread.holdsLock(userAccounts.cacheLock), "Method should not be called with cacheLock");
        if (accountType != null) {
            Account[] accounts;
            Object object = userAccounts.cacheLock;
            synchronized (object) {
                accounts = userAccounts.accountCache.get(accountType);
            }
            if (accounts == null) {
                return EMPTY_ACCOUNT_ARRAY;
            }
            return this.filterAccounts(userAccounts, Arrays.copyOf(accounts, accounts.length), callingUid, callingPackage, includeManagedNotVisible);
        }
        int totalLength = 0;
        Object object = userAccounts.cacheLock;
        synchronized (object) {
            for (Account[] accounts : userAccounts.accountCache.values()) {
                totalLength += accounts.length;
            }
            if (totalLength == 0) {
                return EMPTY_ACCOUNT_ARRAY;
            }
            accountsArray = new Account[totalLength];
            totalLength = 0;
            for (Account[] accountsOfType : userAccounts.accountCache.values()) {
                System.arraycopy(accountsOfType, 0, accountsArray, totalLength, accountsOfType.length);
                totalLength += accountsOfType.length;
            }
        }
        return this.filterAccounts(userAccounts, accountsArray, callingUid, callingPackage, includeManagedNotVisible);
    }

    protected void writeUserDataIntoCacheLocked(UserAccounts accounts, Account account, String key, String value) {
        Map<String, String> userDataForAccount = (Map<String, String>)accounts.userDataCache.get(account);
        if (userDataForAccount == null) {
            userDataForAccount = accounts.accountsDb.findUserExtrasForAccount(account);
            accounts.userDataCache.put(account, userDataForAccount);
        }
        if (value == null) {
            userDataForAccount.remove(key);
        } else {
            userDataForAccount.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readCachedTokenInternal(UserAccounts accounts, Account account, String tokenType, String callingPackage, byte[] pkgSigDigest) {
        Object object = accounts.cacheLock;
        synchronized (object) {
            return accounts.accountTokenCaches.get(account, tokenType, callingPackage, pkgSigDigest);
        }
    }

    protected void writeAuthTokenIntoCacheLocked(UserAccounts accounts, Account account, String key, String value) {
        Map<String, String> authTokensForAccount = (Map<String, String>)accounts.authTokenCache.get(account);
        if (authTokensForAccount == null) {
            authTokensForAccount = accounts.accountsDb.findAuthTokensByAccount(account);
            accounts.authTokenCache.put(account, authTokensForAccount);
        }
        if (value == null) {
            authTokensForAccount.remove(key);
        } else {
            authTokensForAccount.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readAuthTokenInternal(UserAccounts accounts, Account account, String authTokenType) {
        Object object = accounts.cacheLock;
        synchronized (object) {
            Map authTokensForAccount = (Map)accounts.authTokenCache.get(account);
            if (authTokensForAccount != null) {
                return (String)authTokensForAccount.get(authTokenType);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl9 : MonitorExitStatement: MONITOREXIT : var4_4
            object = accounts.dbLock;
        }
        synchronized (object) {
            Object object2 = accounts.cacheLock;
            synchronized (object2) {
                Map<String, String> authTokensForAccount = (Map<String, String>)accounts.authTokenCache.get(account);
                if (authTokensForAccount == null) {
                    authTokensForAccount = accounts.accountsDb.findAuthTokensByAccount(account);
                    accounts.authTokenCache.put(account, authTokensForAccount);
                }
                return (String)authTokensForAccount.get(authTokenType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readUserDataInternal(UserAccounts accounts, Account account, String key) {
        Map<String, String> userDataForAccount;
        Object object = accounts.cacheLock;
        synchronized (object) {
            userDataForAccount = (Map<String, String>)accounts.userDataCache.get(account);
        }
        if (userDataForAccount == null) {
            object = accounts.dbLock;
            synchronized (object) {
                Object object2 = accounts.cacheLock;
                synchronized (object2) {
                    userDataForAccount = (Map)accounts.userDataCache.get(account);
                    if (userDataForAccount == null) {
                        userDataForAccount = accounts.accountsDb.findUserExtrasForAccount(account);
                        accounts.userDataCache.put(account, userDataForAccount);
                    }
                }
            }
        }
        return (String)userDataForAccount.get(key);
    }

    private Context getContextForUser(UserHandle user) {
        try {
            return this.mContext.createPackageContextAsUser(this.mContext.getPackageName(), 0, user);
        }
        catch (PackageManager.NameNotFoundException e) {
            return this.mContext;
        }
    }

    private void sendResponse(IAccountManagerResponse response, Bundle result) {
        block2: {
            try {
                response.onResult(result);
            }
            catch (RemoteException e) {
                if (!Log.isLoggable(TAG, 2)) break block2;
                Log.v(TAG, "failure while notifying response", e);
            }
        }
    }

    private void sendErrorResponse(IAccountManagerResponse response, int errorCode, String errorMessage) {
        block2: {
            try {
                response.onError(errorCode, errorMessage);
            }
            catch (RemoteException e) {
                if (!Log.isLoggable(TAG, 2)) break block2;
                Log.v(TAG, "failure while notifying response", e);
            }
        }
    }

    static {
        ACCOUNTS_CHANGED_INTENT.setFlags(0x5000000);
        sThis = new AtomicReference();
        EMPTY_ACCOUNT_ARRAY = new Account[0];
    }

    private static class NotificationId {
        final String mTag;
        private final int mId;

        NotificationId(String tag, int type) {
            this.mTag = tag;
            this.mId = type;
        }
    }

    @VisibleForTesting
    static class Injector {
        private final Context mContext;

        public Injector(Context context) {
            this.mContext = context;
        }

        Looper getMessageHandlerLooper() {
            ServiceThread serviceThread = new ServiceThread(AccountManagerService.TAG, -2, true);
            serviceThread.start();
            return serviceThread.getLooper();
        }

        Context getContext() {
            return this.mContext;
        }

        void addLocalService(AccountManagerInternal service) {
            LocalServices.addService(AccountManagerInternal.class, service);
        }

        String getDeDatabaseName(int userId) {
            File databaseFile = new File(Environment.getDataSystemDeDirectory(userId), "accounts_de.db");
            return databaseFile.getPath();
        }

        String getCeDatabaseName(int userId) {
            File databaseFile = new File(Environment.getDataSystemCeDirectory(userId), "accounts_ce.db");
            return databaseFile.getPath();
        }

        String getPreNDatabaseName(int userId) {
            File oldFile;
            File systemDir = Environment.getDataSystemDirectory();
            File databaseFile = new File(Environment.getUserSystemDirectory(userId), AccountManagerService.PRE_N_DATABASE_NAME);
            if (userId == 0 && (oldFile = new File(systemDir, AccountManagerService.PRE_N_DATABASE_NAME)).exists() && !databaseFile.exists()) {
                File userDir = Environment.getUserSystemDirectory(userId);
                if (!userDir.exists() && !userDir.mkdirs()) {
                    throw new IllegalStateException("User dir cannot be created: " + userDir);
                }
                if (!oldFile.renameTo(databaseFile)) {
                    throw new IllegalStateException("User dir cannot be migrated: " + databaseFile);
                }
            }
            return databaseFile.getPath();
        }

        IAccountAuthenticatorCache getAccountAuthenticatorCache() {
            return new AccountAuthenticatorCache(this.mContext);
        }

        INotificationManager getNotificationManager() {
            return NotificationManager.getService();
        }
    }

    private final class AccountManagerInternalImpl
    extends AccountManagerInternal {
        private final Object mLock = new Object();
        @GuardedBy(value="mLock")
        private AccountManagerBackupHelper mBackupHelper;

        private AccountManagerInternalImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestAccountAccess(Account account, String packageName, int userId, RemoteCallback callback) {
            UserAccounts userAccounts;
            int uid;
            if (account == null) {
                Slog.w(AccountManagerService.TAG, "account cannot be null");
                return;
            }
            if (packageName == null) {
                Slog.w(AccountManagerService.TAG, "packageName cannot be null");
                return;
            }
            if (userId < 0) {
                Slog.w(AccountManagerService.TAG, "user id must be concrete");
                return;
            }
            if (callback == null) {
                Slog.w(AccountManagerService.TAG, "callback cannot be null");
                return;
            }
            int visibility = AccountManagerService.this.resolveAccountVisibility(account, packageName, AccountManagerService.this.getUserAccounts(userId));
            if (visibility == 3) {
                Slog.w(AccountManagerService.TAG, "requestAccountAccess: account is hidden");
                return;
            }
            if (AccountManagerService.this.hasAccountAccess(account, packageName, new UserHandle(userId))) {
                Bundle result = new Bundle();
                result.putBoolean("booleanResult", true);
                callback.sendResult(result);
                return;
            }
            try {
                uid = AccountManagerService.this.mPackageManager.getPackageUidAsUser(packageName, userId);
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.e(AccountManagerService.TAG, "Unknown package " + packageName);
                return;
            }
            Intent intent = AccountManagerService.this.newRequestAccountAccessIntent(account, packageName, uid, callback);
            SparseArray sparseArray = AccountManagerService.this.mUsers;
            synchronized (sparseArray) {
                userAccounts = (UserAccounts)AccountManagerService.this.mUsers.get(userId);
            }
            SystemNotificationChannels.createAccountChannelForPackage(packageName, uid, AccountManagerService.this.mContext);
            AccountManagerService.this.doNotification(userAccounts, account, null, intent, packageName, userId);
        }

        @Override
        public void addOnAppPermissionChangeListener(AccountManagerInternal.OnAppPermissionChangeListener listener) {
            AccountManagerService.this.mAppPermissionChangeListeners.add(listener);
        }

        @Override
        public boolean hasAccountAccess(Account account, int uid) {
            return AccountManagerService.this.hasAccountAccess(account, null, uid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] backupAccountAccessPermissions(int userId) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mBackupHelper == null) {
                    this.mBackupHelper = new AccountManagerBackupHelper(AccountManagerService.this, this);
                }
                return this.mBackupHelper.backupAccountAccessPermissions(userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void restoreAccountAccessPermissions(byte[] data, int userId) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mBackupHelper == null) {
                    this.mBackupHelper = new AccountManagerBackupHelper(AccountManagerService.this, this);
                }
                this.mBackupHelper.restoreAccountAccessPermissions(data, userId);
            }
        }
    }

    class MessageHandler
    extends Handler {
        MessageHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: {
                    Session session = (Session)msg.obj;
                    session.onTimedOut();
                    break;
                }
                case 4: {
                    AccountManagerService.this.copyAccountToUser(null, (Account)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                default: {
                    throw new IllegalStateException("unhandled message: " + msg.what);
                }
            }
        }
    }

    private abstract class Session
    extends IAccountAuthenticatorResponse.Stub
    implements IBinder.DeathRecipient,
    ServiceConnection {
        IAccountManagerResponse mResponse;
        final String mAccountType;
        final boolean mExpectActivityLaunch;
        final long mCreationTime;
        final String mAccountName;
        final boolean mAuthDetailsRequired;
        final boolean mUpdateLastAuthenticatedTime;
        public int mNumResults = 0;
        private int mNumRequestContinued = 0;
        private int mNumErrors = 0;
        IAccountAuthenticator mAuthenticator = null;
        private final boolean mStripAuthTokenFromResult;
        protected final UserAccounts mAccounts;

        public Session(UserAccounts accounts, IAccountManagerResponse response, String accountType, boolean expectActivityLaunch, boolean stripAuthTokenFromResult, String accountName, boolean authDetailsRequired) {
            this(accounts, response, accountType, expectActivityLaunch, stripAuthTokenFromResult, accountName, authDetailsRequired, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Session(UserAccounts accounts, IAccountManagerResponse response, String accountType, boolean expectActivityLaunch, boolean stripAuthTokenFromResult, String accountName, boolean authDetailsRequired, boolean updateLastAuthenticatedTime) {
            if (accountType == null) {
                throw new IllegalArgumentException("accountType is null");
            }
            this.mAccounts = accounts;
            this.mStripAuthTokenFromResult = stripAuthTokenFromResult;
            this.mResponse = response;
            this.mAccountType = accountType;
            this.mExpectActivityLaunch = expectActivityLaunch;
            this.mCreationTime = SystemClock.elapsedRealtime();
            this.mAccountName = accountName;
            this.mAuthDetailsRequired = authDetailsRequired;
            this.mUpdateLastAuthenticatedTime = updateLastAuthenticatedTime;
            LinkedHashMap linkedHashMap = AccountManagerService.this.mSessions;
            synchronized (linkedHashMap) {
                AccountManagerService.this.mSessions.put(this.toString(), this);
            }
            if (response != null) {
                try {
                    response.asBinder().linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    this.mResponse = null;
                    this.binderDied();
                }
            }
        }

        IAccountManagerResponse getResponseAndClose() {
            if (this.mResponse == null) {
                return null;
            }
            IAccountManagerResponse response = this.mResponse;
            this.close();
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean checkKeyIntent(int authUid, Intent intent) {
            intent.setFlags(intent.getFlags() & 0xFFFFFF3C);
            long bid = Binder.clearCallingIdentity();
            try {
                PackageManager pm = AccountManagerService.this.mContext.getPackageManager();
                ResolveInfo resolveInfo = pm.resolveActivityAsUser(intent, 0, this.mAccounts.userId);
                if (resolveInfo == null) {
                    boolean bl = false;
                    return bl;
                }
                ActivityInfo targetActivityInfo = resolveInfo.activityInfo;
                int targetUid = targetActivityInfo.applicationInfo.uid;
                if (!this.isExportedSystemActivity(targetActivityInfo) && 0 != pm.checkSignatures(authUid, targetUid)) {
                    String pkgName = targetActivityInfo.packageName;
                    String activityName = targetActivityInfo.name;
                    String tmpl = "KEY_INTENT resolved to an Activity (%s) in a package (%s) that does not share a signature with the supplying authenticator (%s).";
                    Log.e(AccountManagerService.TAG, String.format(tmpl, activityName, pkgName, this.mAccountType));
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(bid);
            }
        }

        private boolean isExportedSystemActivity(ActivityInfo activityInfo) {
            String className = activityInfo.name;
            return "android".equals(activityInfo.packageName) && (GrantCredentialsPermissionActivity.class.getName().equals(className) || CantAddAccountActivity.class.getName().equals(className));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            block5: {
                LinkedHashMap linkedHashMap = AccountManagerService.this.mSessions;
                synchronized (linkedHashMap) {
                    if (AccountManagerService.this.mSessions.remove(this.toString()) == null) {
                        return;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                    if (this.mResponse == null) break block5;
                    this.mResponse.asBinder().unlinkToDeath(this, 0);
                }
                this.mResponse = null;
            }
            this.cancelTimeout();
            this.unbind();
        }

        @Override
        public void binderDied() {
            this.mResponse = null;
            this.close();
        }

        protected String toDebugString() {
            return this.toDebugString(SystemClock.elapsedRealtime());
        }

        protected String toDebugString(long now) {
            return "Session: expectLaunch " + this.mExpectActivityLaunch + ", connected " + (this.mAuthenticator != null) + ", stats (" + this.mNumResults + "/" + this.mNumRequestContinued + "/" + this.mNumErrors + "), lifetime " + (double)(now - this.mCreationTime) / 1000.0;
        }

        void bind() {
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "initiating bind to authenticator type " + this.mAccountType);
            }
            if (!this.bindToAuthenticator(this.mAccountType)) {
                Log.d(AccountManagerService.TAG, "bind attempt failed for " + this.toDebugString());
                this.onError(1, "bind failure");
            }
        }

        private void unbind() {
            if (this.mAuthenticator != null) {
                this.mAuthenticator = null;
                AccountManagerService.this.mContext.unbindService(this);
            }
        }

        public void cancelTimeout() {
            AccountManagerService.this.mHandler.removeMessages(3, this);
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            this.mAuthenticator = IAccountAuthenticator.Stub.asInterface(service);
            try {
                this.run();
            }
            catch (RemoteException e) {
                this.onError(1, "remote exception");
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            block3: {
                this.mAuthenticator = null;
                IAccountManagerResponse response = this.getResponseAndClose();
                if (response != null) {
                    try {
                        response.onError(1, "disconnected");
                    }
                    catch (RemoteException e) {
                        if (!Log.isLoggable(AccountManagerService.TAG, 2)) break block3;
                        Log.v(AccountManagerService.TAG, "Session.onServiceDisconnected: caught RemoteException while responding", e);
                    }
                }
            }
        }

        public abstract void run() throws RemoteException;

        public void onTimedOut() {
            block3: {
                IAccountManagerResponse response = this.getResponseAndClose();
                if (response != null) {
                    try {
                        response.onError(1, "timeout");
                    }
                    catch (RemoteException e) {
                        if (!Log.isLoggable(AccountManagerService.TAG, 2)) break block3;
                        Log.v(AccountManagerService.TAG, "Session.onTimedOut: caught RemoteException while responding", e);
                    }
                }
            }
        }

        @Override
        public void onResult(Bundle result) {
            block18: {
                IAccountManagerResponse response;
                Bundle.setDefusable(result, true);
                ++this.mNumResults;
                Intent intent = null;
                if (result != null) {
                    boolean needUpdate;
                    boolean isSuccessfulConfirmCreds = result.getBoolean("booleanResult", false);
                    boolean isSuccessfulUpdateCredsOrAddAccount = result.containsKey("authAccount") && result.containsKey("accountType");
                    boolean bl = needUpdate = this.mUpdateLastAuthenticatedTime && (isSuccessfulConfirmCreds || isSuccessfulUpdateCredsOrAddAccount);
                    if (needUpdate || this.mAuthDetailsRequired) {
                        boolean accountPresent = AccountManagerService.this.isAccountPresentForCaller(this.mAccountName, this.mAccountType);
                        if (needUpdate && accountPresent) {
                            AccountManagerService.this.updateLastAuthenticatedTime(new Account(this.mAccountName, this.mAccountType));
                        }
                        if (this.mAuthDetailsRequired) {
                            long lastAuthenticatedTime = -1L;
                            if (accountPresent) {
                                lastAuthenticatedTime = this.mAccounts.accountsDb.findAccountLastAuthenticatedTime(new Account(this.mAccountName, this.mAccountType));
                            }
                            result.putLong("lastAuthenticatedTime", lastAuthenticatedTime);
                        }
                    }
                }
                if (result != null && (intent = (Intent)result.getParcelable("intent")) != null && !this.checkKeyIntent(Binder.getCallingUid(), intent)) {
                    this.onError(5, "invalid intent in bundle returned");
                    return;
                }
                if (result != null && !TextUtils.isEmpty(result.getString("authtoken"))) {
                    String accountName = result.getString("authAccount");
                    String accountType = result.getString("accountType");
                    if (!TextUtils.isEmpty(accountName) && !TextUtils.isEmpty(accountType)) {
                        Account account = new Account(accountName, accountType);
                        AccountManagerService.this.cancelNotification(AccountManagerService.this.getSigninRequiredNotificationId(this.mAccounts, account), new UserHandle(this.mAccounts.userId));
                    }
                }
                if ((response = this.mExpectActivityLaunch && result != null && result.containsKey("intent") ? this.mResponse : this.getResponseAndClose()) != null) {
                    try {
                        if (result == null) {
                            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                                Log.v(AccountManagerService.TAG, this.getClass().getSimpleName() + " calling onError() on response " + response);
                            }
                            response.onError(5, "null bundle returned");
                        } else {
                            if (this.mStripAuthTokenFromResult) {
                                result.remove("authtoken");
                            }
                            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                                Log.v(AccountManagerService.TAG, this.getClass().getSimpleName() + " calling onResult() on response " + response);
                            }
                            if (result.getInt("errorCode", -1) > 0 && intent == null) {
                                response.onError(result.getInt("errorCode"), result.getString("errorMessage"));
                            } else {
                                response.onResult(result);
                            }
                        }
                    }
                    catch (RemoteException e) {
                        if (!Log.isLoggable(AccountManagerService.TAG, 2)) break block18;
                        Log.v(AccountManagerService.TAG, "failure while notifying response", e);
                    }
                }
            }
        }

        @Override
        public void onRequestContinued() {
            ++this.mNumRequestContinued;
        }

        @Override
        public void onError(int errorCode, String errorMessage) {
            ++this.mNumErrors;
            IAccountManagerResponse response = this.getResponseAndClose();
            if (response != null) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    Log.v(AccountManagerService.TAG, this.getClass().getSimpleName() + " calling onError() on response " + response);
                }
                try {
                    response.onError(errorCode, errorMessage);
                }
                catch (RemoteException e) {
                    if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                        Log.v(AccountManagerService.TAG, "Session.onError: caught RemoteException while responding", e);
                    }
                }
            } else if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "Session.onError: already closed");
            }
        }

        private boolean bindToAuthenticator(String authenticatorType) {
            RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> authenticatorInfo = AccountManagerService.this.mAuthenticatorCache.getServiceInfo(AuthenticatorDescription.newKey(authenticatorType), this.mAccounts.userId);
            if (authenticatorInfo == null) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    Log.v(AccountManagerService.TAG, "there is no authenticator for " + authenticatorType + ", bailing out");
                }
                return false;
            }
            if (!AccountManagerService.this.isLocalUnlockedUser(this.mAccounts.userId) && !authenticatorInfo.componentInfo.directBootAware) {
                Slog.w(AccountManagerService.TAG, "Blocking binding to authenticator " + authenticatorInfo.componentName + " which isn't encryption aware");
                return false;
            }
            Intent intent = new Intent();
            intent.setAction("android.accounts.AccountAuthenticator");
            intent.setComponent(authenticatorInfo.componentName);
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "performing bindService to " + authenticatorInfo.componentName);
            }
            if (!AccountManagerService.this.mContext.bindServiceAsUser(intent, this, 1, UserHandle.of(this.mAccounts.userId))) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    Log.v(AccountManagerService.TAG, "bindService to " + authenticatorInfo.componentName + " failed");
                }
                return false;
            }
            return true;
        }
    }

    private class GetAccountsByTypeAndFeatureSession
    extends Session {
        private final String[] mFeatures;
        private volatile Account[] mAccountsOfType;
        private volatile ArrayList<Account> mAccountsWithFeatures;
        private volatile int mCurrentAccount;
        private final int mCallingUid;
        private final String mPackageName;
        private final boolean mIncludeManagedNotVisible;

        public GetAccountsByTypeAndFeatureSession(UserAccounts accounts, IAccountManagerResponse response, String type, String[] features, int callingUid, String packageName, boolean includeManagedNotVisible) {
            super(accounts, response, type, false, true, null, false);
            this.mAccountsOfType = null;
            this.mAccountsWithFeatures = null;
            this.mCurrentAccount = 0;
            this.mCallingUid = callingUid;
            this.mFeatures = features;
            this.mPackageName = packageName;
            this.mIncludeManagedNotVisible = includeManagedNotVisible;
        }

        @Override
        public void run() throws RemoteException {
            this.mAccountsOfType = AccountManagerService.this.getAccountsFromCache(this.mAccounts, this.mAccountType, this.mCallingUid, this.mPackageName, this.mIncludeManagedNotVisible);
            this.mAccountsWithFeatures = new ArrayList(this.mAccountsOfType.length);
            this.mCurrentAccount = 0;
            this.checkAccount();
        }

        public void checkAccount() {
            if (this.mCurrentAccount >= this.mAccountsOfType.length) {
                this.sendResult();
                return;
            }
            IAccountAuthenticator accountAuthenticator = this.mAuthenticator;
            if (accountAuthenticator == null) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    Log.v(AccountManagerService.TAG, "checkAccount: aborting session since we are no longer connected to the authenticator, " + this.toDebugString());
                }
                return;
            }
            try {
                accountAuthenticator.hasFeatures(this, this.mAccountsOfType[this.mCurrentAccount], this.mFeatures);
            }
            catch (RemoteException e) {
                this.onError(1, "remote exception");
            }
        }

        @Override
        public void onResult(Bundle result) {
            Bundle.setDefusable(result, true);
            ++this.mNumResults;
            if (result == null) {
                this.onError(5, "null bundle");
                return;
            }
            if (result.getBoolean("booleanResult", false)) {
                this.mAccountsWithFeatures.add(this.mAccountsOfType[this.mCurrentAccount]);
            }
            ++this.mCurrentAccount;
            this.checkAccount();
        }

        public void sendResult() {
            block5: {
                IAccountManagerResponse response = this.getResponseAndClose();
                if (response != null) {
                    try {
                        Parcelable[] accounts = new Account[this.mAccountsWithFeatures.size()];
                        for (int i = 0; i < accounts.length; ++i) {
                            accounts[i] = this.mAccountsWithFeatures.get(i);
                        }
                        if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                            Log.v(AccountManagerService.TAG, this.getClass().getSimpleName() + " calling onResult() on response " + response);
                        }
                        Bundle result = new Bundle();
                        result.putParcelableArray("accounts", accounts);
                        response.onResult(result);
                    }
                    catch (RemoteException e) {
                        if (!Log.isLoggable(AccountManagerService.TAG, 2)) break block5;
                        Log.v(AccountManagerService.TAG, "failure while notifying response", e);
                    }
                }
            }
        }

        @Override
        protected String toDebugString(long now) {
            return super.toDebugString(now) + ", getAccountsByTypeAndFeatures, " + (this.mFeatures != null ? TextUtils.join((CharSequence)",", this.mFeatures) : null);
        }
    }

    private abstract class StartAccountSession
    extends Session {
        private final boolean mIsPasswordForwardingAllowed;

        public StartAccountSession(UserAccounts accounts, IAccountManagerResponse response, String accountType, boolean expectActivityLaunch, String accountName, boolean authDetailsRequired, boolean updateLastAuthenticationTime, boolean isPasswordForwardingAllowed) {
            super(accounts, response, accountType, expectActivityLaunch, true, accountName, authDetailsRequired, updateLastAuthenticationTime);
            this.mIsPasswordForwardingAllowed = isPasswordForwardingAllowed;
        }

        @Override
        public void onResult(Bundle result) {
            Bundle sessionBundle;
            Bundle.setDefusable(result, true);
            ++this.mNumResults;
            Intent intent = null;
            if (result != null && (intent = (Intent)result.getParcelable("intent")) != null && !this.checkKeyIntent(Binder.getCallingUid(), intent)) {
                this.onError(5, "invalid intent in bundle returned");
                return;
            }
            IAccountManagerResponse response = this.mExpectActivityLaunch && result != null && result.containsKey("intent") ? this.mResponse : this.getResponseAndClose();
            if (response == null) {
                return;
            }
            if (result == null) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    Log.v(AccountManagerService.TAG, this.getClass().getSimpleName() + " calling onError() on response " + response);
                }
                AccountManagerService.this.sendErrorResponse(response, 5, "null bundle returned");
                return;
            }
            if (result.getInt("errorCode", -1) > 0 && intent == null) {
                AccountManagerService.this.sendErrorResponse(response, result.getInt("errorCode"), result.getString("errorMessage"));
                return;
            }
            if (!this.mIsPasswordForwardingAllowed) {
                result.remove("password");
            }
            result.remove("authtoken");
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, this.getClass().getSimpleName() + " calling onResult() on response " + response);
            }
            if ((sessionBundle = result.getBundle("accountSessionBundle")) != null) {
                String accountType = sessionBundle.getString("accountType");
                if (TextUtils.isEmpty(accountType) || !this.mAccountType.equalsIgnoreCase(accountType)) {
                    Log.w(AccountManagerService.TAG, "Account type in session bundle doesn't match request.");
                }
                sessionBundle.putString("accountType", this.mAccountType);
                try {
                    CryptoHelper cryptoHelper = CryptoHelper.getInstance();
                    Bundle encryptedBundle = cryptoHelper.encryptBundle(sessionBundle);
                    result.putBundle("accountSessionBundle", encryptedBundle);
                }
                catch (GeneralSecurityException e) {
                    if (Log.isLoggable(AccountManagerService.TAG, 3)) {
                        Log.v(AccountManagerService.TAG, "Failed to encrypt session bundle!", e);
                    }
                    AccountManagerService.this.sendErrorResponse(response, 5, "failed to encrypt session bundle");
                    return;
                }
            }
            AccountManagerService.this.sendResponse(response, result);
        }
    }

    private class RemoveAccountSession
    extends Session {
        final Account mAccount;

        public RemoveAccountSession(UserAccounts accounts, IAccountManagerResponse response, Account account, boolean expectActivityLaunch) {
            super(accounts, response, account.type, expectActivityLaunch, true, account.name, false);
            this.mAccount = account;
        }

        @Override
        protected String toDebugString(long now) {
            return super.toDebugString(now) + ", removeAccount, account " + this.mAccount;
        }

        @Override
        public void run() throws RemoteException {
            this.mAuthenticator.getAccountRemovalAllowed(this, this.mAccount);
        }

        @Override
        public void onResult(Bundle result) {
            Bundle.setDefusable(result, true);
            if (result != null && result.containsKey("booleanResult") && !result.containsKey("intent")) {
                IAccountManagerResponse response;
                boolean removalAllowed = result.getBoolean("booleanResult");
                if (removalAllowed) {
                    AccountManagerService.this.removeAccountInternal(this.mAccounts, this.mAccount, RemoveAccountSession.getCallingUid());
                }
                if ((response = this.getResponseAndClose()) != null) {
                    if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                        Log.v(AccountManagerService.TAG, this.getClass().getSimpleName() + " calling onResult() on response " + response);
                    }
                    try {
                        response.onResult(result);
                    }
                    catch (RemoteException e) {
                        Slog.e(AccountManagerService.TAG, "Error calling onResult()", e);
                    }
                }
            }
            super.onResult(result);
        }
    }

    private class TestFeaturesSession
    extends Session {
        private final String[] mFeatures;
        private final Account mAccount;

        public TestFeaturesSession(UserAccounts accounts, IAccountManagerResponse response, Account account, String[] features) {
            super(accounts, response, account.type, false, true, account.name, false);
            this.mFeatures = features;
            this.mAccount = account;
        }

        @Override
        public void run() throws RemoteException {
            try {
                this.mAuthenticator.hasFeatures(this, this.mAccount, this.mFeatures);
            }
            catch (RemoteException e) {
                this.onError(1, "remote exception");
            }
        }

        @Override
        public void onResult(Bundle result) {
            block5: {
                Bundle.setDefusable(result, true);
                IAccountManagerResponse response = this.getResponseAndClose();
                if (response != null) {
                    try {
                        if (result == null) {
                            response.onError(5, "null bundle");
                            return;
                        }
                        if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                            Log.v(AccountManagerService.TAG, this.getClass().getSimpleName() + " calling onResult() on response " + response);
                        }
                        Bundle newResult = new Bundle();
                        newResult.putBoolean("booleanResult", result.getBoolean("booleanResult", false));
                        response.onResult(newResult);
                    }
                    catch (RemoteException e) {
                        if (!Log.isLoggable(AccountManagerService.TAG, 2)) break block5;
                        Log.v(AccountManagerService.TAG, "failure while notifying response", e);
                    }
                }
            }
        }

        @Override
        protected String toDebugString(long now) {
            return super.toDebugString(now) + ", hasFeatures, " + this.mAccount + ", " + (this.mFeatures != null ? TextUtils.join((CharSequence)",", this.mFeatures) : null);
        }
    }

    static class UserAccounts {
        private final int userId;
        final AccountsDb accountsDb;
        private final HashMap<Pair<Pair<Account, String>, Integer>, NotificationId> credentialsPermissionNotificationIds = new HashMap();
        private final HashMap<Account, NotificationId> signinRequiredNotificationIds = new HashMap();
        final Object cacheLock = new Object();
        final Object dbLock = new Object();
        final HashMap<String, Account[]> accountCache = new LinkedHashMap<String, Account[]>();
        private final Map<Account, Map<String, String>> userDataCache = new HashMap<Account, Map<String, String>>();
        private final Map<Account, Map<String, String>> authTokenCache = new HashMap<Account, Map<String, String>>();
        private final TokenCache accountTokenCaches = new TokenCache();
        private final Map<Account, Map<String, Integer>> visibilityCache = new HashMap<Account, Map<String, Integer>>();
        private final Map<String, Map<String, Integer>> mReceiversForType = new HashMap<String, Map<String, Integer>>();
        private final HashMap<Account, AtomicReference<String>> previousNameCache = new HashMap();
        private int debugDbInsertionPoint = -1;
        private SQLiteStatement statementForLogging;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        UserAccounts(Context context, int userId, File preNDbFile, File deDbFile) {
            this.userId = userId;
            Object object = this.dbLock;
            synchronized (object) {
                Object object2 = this.cacheLock;
                synchronized (object2) {
                    this.accountsDb = AccountsDb.create(context, userId, preNDbFile, deDbFile);
                }
            }
        }
    }

    public static class Lifecycle
    extends SystemService {
        private AccountManagerService mService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            this.mService = new AccountManagerService(new Injector(this.getContext()));
            this.publishBinderService("account", this.mService);
        }

        @Override
        public void onUnlockUser(int userHandle) {
            this.mService.onUnlockUser(userHandle);
        }

        @Override
        public void onStopUser(int userHandle) {
            Slog.i(AccountManagerService.TAG, "onStopUser " + userHandle);
            this.mService.purgeUserData(userHandle);
        }
    }
}

