/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManagerInternal;
import android.app.ActivityOptions;
import android.app.WindowConfiguration;
import android.graphics.Point;
import android.util.IntArray;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.PinnedActivityStack;
import com.android.server.am.TaskRecord;
import com.android.server.wm.ConfigurationContainer;
import com.android.server.wm.DisplayWindowController;
import com.android.server.wm.StackWindowController;
import com.android.server.wm.WindowContainerListener;
import java.io.PrintWriter;
import java.util.ArrayList;

class ActivityDisplay
extends ConfigurationContainer<ActivityStack>
implements WindowContainerListener {
    private static final String TAG = "ActivityManager";
    private static final String TAG_STACK = "ActivityManager";
    static final int POSITION_TOP = Integer.MAX_VALUE;
    static final int POSITION_BOTTOM = Integer.MIN_VALUE;
    private static int sNextFreeStackId = 0;
    private ActivityStackSupervisor mSupervisor;
    int mDisplayId;
    Display mDisplay;
    private final ArrayList<ActivityStack> mStacks = new ArrayList();
    private IntArray mDisplayAccessUIDs = new IntArray();
    final ArrayList<ActivityManagerInternal.SleepToken> mAllSleepTokens = new ArrayList();
    ActivityManagerInternal.SleepToken mOffToken;
    private boolean mSleeping;
    private ActivityStack mHomeStack = null;
    private ActivityStack mRecentsStack = null;
    private ActivityStack mPinnedStack = null;
    private ActivityStack mSplitScreenPrimaryStack = null;
    private Point mTmpDisplaySize = new Point();
    private DisplayWindowController mWindowContainerController;

    ActivityDisplay(ActivityStackSupervisor supervisor, int displayId) {
        this.mSupervisor = supervisor;
        this.mDisplayId = displayId;
        Display display = supervisor.mDisplayManager.getDisplay(displayId);
        if (display == null) {
            throw new IllegalStateException("Display does not exist displayId=" + displayId);
        }
        this.mDisplay = display;
        this.mWindowContainerController = this.createWindowContainerController();
        this.updateBounds();
    }

    protected DisplayWindowController createWindowContainerController() {
        return new DisplayWindowController(this.mDisplayId, this);
    }

    void updateBounds() {
        this.mDisplay.getSize(this.mTmpDisplaySize);
        this.setBounds(0, 0, this.mTmpDisplaySize.x, this.mTmpDisplaySize.y);
    }

    void addChild(ActivityStack stack, int position) {
        if (position == Integer.MIN_VALUE) {
            position = 0;
        } else if (position == Integer.MAX_VALUE) {
            position = this.mStacks.size();
        }
        this.addStackReferenceIfNeeded(stack);
        this.positionChildAt(stack, position);
        this.mSupervisor.mService.updateSleepIfNeededLocked();
    }

    void removeChild(ActivityStack stack) {
        this.mStacks.remove(stack);
        this.removeStackReferenceIfNeeded(stack);
        this.mSupervisor.mService.updateSleepIfNeededLocked();
    }

    void positionChildAtTop(ActivityStack stack) {
        this.positionChildAt(stack, this.mStacks.size());
    }

    void positionChildAtBottom(ActivityStack stack) {
        this.positionChildAt(stack, 0);
    }

    private void positionChildAt(ActivityStack stack, int position) {
        this.mStacks.remove(stack);
        int insertPosition = this.getTopInsertPosition(stack, position);
        this.mStacks.add(insertPosition, stack);
        this.mWindowContainerController.positionChildAt((StackWindowController)stack.getWindowContainerController(), insertPosition);
    }

    private int getTopInsertPosition(ActivityStack stack, int candidatePosition) {
        ActivityStack topStack;
        int position = this.mStacks.size();
        if (position > 0 && (topStack = this.mStacks.get(position - 1)).getWindowConfiguration().isAlwaysOnTop() && topStack != stack) {
            --position;
        }
        return Math.min(position, candidatePosition);
    }

    <T extends ActivityStack> T getStack(int stackId) {
        for (int i = this.mStacks.size() - 1; i >= 0; --i) {
            ActivityStack stack = this.mStacks.get(i);
            if (stack.mStackId != stackId) continue;
            return (T)stack;
        }
        return null;
    }

    <T extends ActivityStack> T getStack(int windowingMode, int activityType) {
        if (activityType == 2) {
            return (T)this.mHomeStack;
        }
        if (activityType == 3) {
            return (T)this.mRecentsStack;
        }
        if (windowingMode == 2) {
            return (T)this.mPinnedStack;
        }
        if (windowingMode == 3) {
            return (T)this.mSplitScreenPrimaryStack;
        }
        for (int i = this.mStacks.size() - 1; i >= 0; --i) {
            ActivityStack stack = this.mStacks.get(i);
            if (!stack.isCompatible(windowingMode, activityType)) continue;
            return (T)stack;
        }
        return null;
    }

    private boolean alwaysCreateStack(int windowingMode, int activityType) {
        return activityType == 1 && (windowingMode == 1 || windowingMode == 5 || windowingMode == 4);
    }

    <T extends ActivityStack> T getOrCreateStack(int windowingMode, int activityType, boolean onTop) {
        T stack;
        if (!this.alwaysCreateStack(windowingMode, activityType) && (stack = this.getStack(windowingMode, activityType)) != null) {
            return stack;
        }
        return this.createStack(windowingMode, activityType, onTop);
    }

    <T extends ActivityStack> T getOrCreateStack(ActivityRecord r, ActivityOptions options, TaskRecord candidateTask, int activityType, boolean onTop) {
        int windowingMode = this.resolveWindowingMode(r, options, candidateTask, activityType);
        return this.getOrCreateStack(windowingMode, activityType, onTop);
    }

    private int getNextStackId() {
        return sNextFreeStackId++;
    }

    <T extends ActivityStack> T createStack(int windowingMode, int activityType, boolean onTop) {
        T stack;
        if (activityType == 0) {
            activityType = 1;
        }
        if (activityType != 1 && (stack = this.getStack(0, activityType)) != null) {
            throw new IllegalArgumentException("Stack=" + stack + " of activityType=" + activityType + " already on display=" + this + ". Can't have multiple.");
        }
        ActivityManagerService service = this.mSupervisor.mService;
        if (!this.isWindowingModeSupported(windowingMode, service.mSupportsMultiWindow, service.mSupportsSplitScreenMultiWindow, service.mSupportsFreeformWindowManagement, service.mSupportsPictureInPicture, activityType)) {
            throw new IllegalArgumentException("Can't create stack for unsupported windowingMode=" + windowingMode);
        }
        if (windowingMode == 0 && (windowingMode = this.getWindowingMode()) == 0) {
            windowingMode = 1;
        }
        int stackId = this.getNextStackId();
        return this.createStackUnchecked(windowingMode, activityType, stackId, onTop);
    }

    @VisibleForTesting
    <T extends ActivityStack> T createStackUnchecked(int windowingMode, int activityType, int stackId, boolean onTop) {
        if (windowingMode == 2) {
            return (T)new PinnedActivityStack(this, stackId, this.mSupervisor, onTop);
        }
        return (T)new ActivityStack(this, stackId, this.mSupervisor, windowingMode, activityType, onTop);
    }

    void removeStacksInWindowingModes(int ... windowingModes) {
        if (windowingModes == null || windowingModes.length == 0) {
            return;
        }
        for (int j = windowingModes.length - 1; j >= 0; --j) {
            int windowingMode = windowingModes[j];
            for (int i = this.mStacks.size() - 1; i >= 0; --i) {
                ActivityStack stack = this.mStacks.get(i);
                if (!stack.isActivityTypeStandardOrUndefined() || stack.getWindowingMode() != windowingMode) continue;
                this.mSupervisor.removeStack(stack);
            }
        }
    }

    void removeStacksWithActivityTypes(int ... activityTypes) {
        if (activityTypes == null || activityTypes.length == 0) {
            return;
        }
        for (int j = activityTypes.length - 1; j >= 0; --j) {
            int activityType = activityTypes[j];
            for (int i = this.mStacks.size() - 1; i >= 0; --i) {
                ActivityStack stack = this.mStacks.get(i);
                if (stack.getActivityType() != activityType) continue;
                this.mSupervisor.removeStack(stack);
            }
        }
    }

    void onStackWindowingModeChanged(ActivityStack stack) {
        this.removeStackReferenceIfNeeded(stack);
        this.addStackReferenceIfNeeded(stack);
    }

    private void addStackReferenceIfNeeded(ActivityStack stack) {
        int activityType = stack.getActivityType();
        int windowingMode = stack.getWindowingMode();
        if (activityType == 2) {
            if (this.mHomeStack != null && this.mHomeStack != stack) {
                throw new IllegalArgumentException("addStackReferenceIfNeeded: home stack=" + this.mHomeStack + " already exist on display=" + this + " stack=" + stack);
            }
            this.mHomeStack = stack;
        } else if (activityType == 3) {
            if (this.mRecentsStack != null && this.mRecentsStack != stack) {
                throw new IllegalArgumentException("addStackReferenceIfNeeded: recents stack=" + this.mRecentsStack + " already exist on display=" + this + " stack=" + stack);
            }
            this.mRecentsStack = stack;
        }
        if (windowingMode == 2) {
            if (this.mPinnedStack != null && this.mPinnedStack != stack) {
                throw new IllegalArgumentException("addStackReferenceIfNeeded: pinned stack=" + this.mPinnedStack + " already exist on display=" + this + " stack=" + stack);
            }
            this.mPinnedStack = stack;
        } else if (windowingMode == 3) {
            if (this.mSplitScreenPrimaryStack != null && this.mSplitScreenPrimaryStack != stack) {
                throw new IllegalArgumentException("addStackReferenceIfNeeded: split-screen-primary stack=" + this.mSplitScreenPrimaryStack + " already exist on display=" + this + " stack=" + stack);
            }
            this.mSplitScreenPrimaryStack = stack;
            this.onSplitScreenModeActivated();
        }
    }

    private void removeStackReferenceIfNeeded(ActivityStack stack) {
        if (stack == this.mHomeStack) {
            this.mHomeStack = null;
        } else if (stack == this.mRecentsStack) {
            this.mRecentsStack = null;
        } else if (stack == this.mPinnedStack) {
            this.mPinnedStack = null;
        } else if (stack == this.mSplitScreenPrimaryStack) {
            this.mSplitScreenPrimaryStack = null;
            this.onSplitScreenModeDismissed();
        }
    }

    private void onSplitScreenModeDismissed() {
        this.mSupervisor.mWindowManager.deferSurfaceLayout();
        try {
            for (int i = this.mStacks.size() - 1; i >= 0; --i) {
                ActivityStack otherStack = this.mStacks.get(i);
                if (!otherStack.inSplitScreenSecondaryWindowingMode()) continue;
                otherStack.setWindowingMode(1);
            }
        }
        finally {
            ActivityStack topFullscreenStack = this.getTopStackInWindowingMode(1);
            if (topFullscreenStack != null && this.mHomeStack != null && !this.isTopStack(this.mHomeStack)) {
                this.mHomeStack.moveToFront("onSplitScreenModeDismissed");
                topFullscreenStack.moveToFront("onSplitScreenModeDismissed");
            }
            this.mSupervisor.mWindowManager.continueSurfaceLayout();
        }
    }

    private void onSplitScreenModeActivated() {
        this.mSupervisor.mWindowManager.deferSurfaceLayout();
        try {
            for (int i = this.mStacks.size() - 1; i >= 0; --i) {
                ActivityStack otherStack = this.mStacks.get(i);
                if (otherStack == this.mSplitScreenPrimaryStack || !otherStack.affectedBySplitScreenResize()) continue;
                otherStack.setWindowingMode(4, false, false, true);
            }
        }
        finally {
            this.mSupervisor.mWindowManager.continueSurfaceLayout();
        }
    }

    private boolean isWindowingModeSupported(int windowingMode, boolean supportsMultiWindow, boolean supportsSplitScreen, boolean supportsFreeform, boolean supportsPip, int activityType) {
        if (windowingMode == 0 || windowingMode == 1) {
            return true;
        }
        if (!supportsMultiWindow) {
            return false;
        }
        if (windowingMode == 3 || windowingMode == 4) {
            return supportsSplitScreen && WindowConfiguration.supportSplitScreenWindowingMode(activityType);
        }
        if (!supportsFreeform && windowingMode == 5) {
            return false;
        }
        return supportsPip || windowingMode != 2;
    }

    int resolveWindowingMode(ActivityRecord r, ActivityOptions options, TaskRecord task, int activityType) {
        boolean inSplitScreenMode;
        int windowingMode;
        int n = windowingMode = options != null ? options.getLaunchWindowingMode() : 0;
        if (windowingMode == 0) {
            if (task != null) {
                windowingMode = task.getWindowingMode();
            }
            if (windowingMode == 0 && r != null) {
                windowingMode = r.getWindowingMode();
            }
            if (windowingMode == 0) {
                windowingMode = this.getWindowingMode();
            }
        }
        ActivityManagerService service = this.mSupervisor.mService;
        boolean supportsMultiWindow = service.mSupportsMultiWindow;
        boolean supportsSplitScreen = service.mSupportsSplitScreenMultiWindow;
        boolean supportsFreeform = service.mSupportsFreeformWindowManagement;
        boolean supportsPip = service.mSupportsPictureInPicture;
        if (supportsMultiWindow) {
            if (task != null) {
                supportsMultiWindow = task.isResizeable();
                supportsSplitScreen = task.supportsSplitScreenWindowingMode();
            } else if (r != null) {
                supportsMultiWindow = r.isResizeable();
                supportsSplitScreen = r.supportsSplitScreenWindowingMode();
                supportsFreeform = r.supportsFreeform();
                supportsPip = r.supportsPictureInPicture();
            }
        }
        if (!(inSplitScreenMode = this.hasSplitScreenPrimaryStack()) && windowingMode == 4) {
            windowingMode = 1;
        } else if (inSplitScreenMode && windowingMode == 1 && supportsSplitScreen) {
            windowingMode = 4;
        }
        if (windowingMode != 0 && this.isWindowingModeSupported(windowingMode, supportsMultiWindow, supportsSplitScreen, supportsFreeform, supportsPip, activityType)) {
            return windowingMode;
        }
        windowingMode = this.getWindowingMode();
        return windowingMode != 0 ? windowingMode : 1;
    }

    ActivityStack getTopStack() {
        return this.mStacks.isEmpty() ? null : this.mStacks.get(this.mStacks.size() - 1);
    }

    boolean isTopStack(ActivityStack stack) {
        return stack == this.getTopStack();
    }

    boolean isTopNotPinnedStack(ActivityStack stack) {
        for (int i = this.mStacks.size() - 1; i >= 0; --i) {
            ActivityStack current = this.mStacks.get(i);
            if (current.inPinnedWindowingMode()) continue;
            return current == stack;
        }
        return false;
    }

    ActivityStack getTopStackInWindowingMode(int windowingMode) {
        for (int i = this.mStacks.size() - 1; i >= 0; --i) {
            ActivityStack current = this.mStacks.get(i);
            if (windowingMode != current.getWindowingMode()) continue;
            return current;
        }
        return null;
    }

    int getIndexOf(ActivityStack stack) {
        return this.mStacks.indexOf(stack);
    }

    void onLockTaskPackagesUpdated() {
        for (int i = this.mStacks.size() - 1; i >= 0; --i) {
            this.mStacks.get(i).onLockTaskPackagesUpdated();
        }
    }

    void onExitingSplitScreenMode() {
        this.mSplitScreenPrimaryStack = null;
    }

    ActivityStack getSplitScreenPrimaryStack() {
        return this.mSplitScreenPrimaryStack;
    }

    boolean hasSplitScreenPrimaryStack() {
        return this.mSplitScreenPrimaryStack != null;
    }

    PinnedActivityStack getPinnedStack() {
        return (PinnedActivityStack)this.mPinnedStack;
    }

    boolean hasPinnedStack() {
        return this.mPinnedStack != null;
    }

    public String toString() {
        return "ActivityDisplay={" + this.mDisplayId + " numStacks=" + this.mStacks.size() + "}";
    }

    @Override
    protected int getChildCount() {
        return this.mStacks.size();
    }

    @Override
    protected ActivityStack getChildAt(int index) {
        return this.mStacks.get(index);
    }

    @Override
    protected ConfigurationContainer getParent() {
        return this.mSupervisor;
    }

    boolean isPrivate() {
        return (this.mDisplay.getFlags() & 4) != 0;
    }

    boolean isUidPresent(int uid) {
        for (ActivityStack stack : this.mStacks) {
            if (!stack.isUidPresent(uid)) continue;
            return true;
        }
        return false;
    }

    IntArray getPresentUIDs() {
        this.mDisplayAccessUIDs.clear();
        for (ActivityStack stack : this.mStacks) {
            stack.getPresentUIDs(this.mDisplayAccessUIDs);
        }
        return this.mDisplayAccessUIDs;
    }

    boolean shouldDestroyContentOnRemove() {
        return this.mDisplay.getRemoveMode() == 1;
    }

    boolean shouldSleep() {
        return (this.mStacks.isEmpty() || !this.mAllSleepTokens.isEmpty()) && this.mSupervisor.mService.mRunningVoice == null;
    }

    ActivityStack getStackAboveHome() {
        if (this.mHomeStack == null) {
            return null;
        }
        int stackIndex = this.mStacks.indexOf(this.mHomeStack) + 1;
        return stackIndex < this.mStacks.size() ? this.mStacks.get(stackIndex) : null;
    }

    void moveHomeStackBehindBottomMostVisibleStack() {
        if (this.mHomeStack == null) {
            return;
        }
        this.positionChildAtBottom(this.mHomeStack);
        int numStacks = this.mStacks.size();
        for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
            boolean isValidWindowingMode;
            ActivityStack stack = this.mStacks.get(stackNdx);
            if (stack == this.mHomeStack) continue;
            int winMode = stack.getWindowingMode();
            boolean bl = isValidWindowingMode = winMode == 1 || winMode == 4;
            if (!stack.shouldBeVisible(null) || !isValidWindowingMode) continue;
            this.positionChildAt(this.mHomeStack, Math.max(0, stackNdx - 1));
            break;
        }
    }

    void moveHomeStackBehindStack(ActivityStack behindStack) {
        if (behindStack == null) {
            return;
        }
        this.positionChildAt(this.mHomeStack, Math.max(0, this.mStacks.indexOf(behindStack) - 1));
    }

    boolean isSleeping() {
        return this.mSleeping;
    }

    void setIsSleeping(boolean asleep) {
        this.mSleeping = asleep;
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "displayId=" + this.mDisplayId + " stacks=" + this.mStacks.size());
        String myPrefix = prefix + " ";
        if (this.mHomeStack != null) {
            pw.println(myPrefix + "mHomeStack=" + this.mHomeStack);
        }
        if (this.mRecentsStack != null) {
            pw.println(myPrefix + "mRecentsStack=" + this.mRecentsStack);
        }
        if (this.mPinnedStack != null) {
            pw.println(myPrefix + "mPinnedStack=" + this.mPinnedStack);
        }
        if (this.mSplitScreenPrimaryStack != null) {
            pw.println(myPrefix + "mSplitScreenPrimaryStack=" + this.mSplitScreenPrimaryStack);
        }
    }

    public void dumpStacks(PrintWriter pw) {
        for (int i = this.mStacks.size() - 1; i >= 0; --i) {
            pw.print(this.mStacks.get((int)i).mStackId);
            if (i <= 0) continue;
            pw.print(",");
        }
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, false);
        proto.write(1120986464258L, this.mDisplayId);
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            stack.writeToProto(proto, 2246267895811L);
        }
        proto.end(token);
    }
}

