/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.PendingIntent;
import android.app.PictureInPictureParams;
import android.app.ResultInfo;
import android.app.WindowConfiguration;
import android.app.servertransaction.ActivityConfigurationChangeItem;
import android.app.servertransaction.MoveToDisplayItem;
import android.app.servertransaction.MultiWindowModeChangeItem;
import android.app.servertransaction.NewIntentItem;
import android.app.servertransaction.PipModeChangeItem;
import android.app.servertransaction.WindowVisibilityItem;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.GraphicBuffer;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.service.voice.IVoiceInteractionSession;
import android.util.EventLog;
import android.util.Log;
import android.util.MergedConfiguration;
import android.util.Slog;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import android.view.AppTransitionAnimationSpec;
import android.view.IAppTransitionAnimationSpecsFuture;
import android.view.IApplicationToken;
import android.view.RemoteAnimationDefinition;
import com.android.internal.R;
import com.android.internal.app.ResolverActivity;
import com.android.internal.content.ReferrerIntent;
import com.android.internal.util.XmlUtils;
import com.android.server.AttributeCache;
import com.android.server.am.ActivityDisplay;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityResult;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.AppTimeTracker;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.TaskPersister;
import com.android.server.am.TaskRecord;
import com.android.server.am.UriPermissionOwner;
import com.android.server.wm.AppWindowContainerController;
import com.android.server.wm.AppWindowContainerListener;
import com.android.server.wm.ConfigurationContainer;
import com.android.server.wm.TaskWindowContainerController;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

final class ActivityRecord
extends ConfigurationContainer
implements AppWindowContainerListener {
    private static final String TAG = "ActivityManager";
    private static final String TAG_CONFIGURATION = "ActivityManager";
    private static final String TAG_SAVED_STATE = "ActivityManager";
    private static final String TAG_STATES = "ActivityManager";
    private static final String TAG_SWITCH = "ActivityManager";
    private static final String TAG_VISIBILITY = "ActivityManager";
    private static final String LEGACY_RECENTS_PACKAGE_NAME = "com.android.systemui.recents";
    private static final boolean SHOW_ACTIVITY_START_TIME = true;
    private static final String ATTR_ID = "id";
    private static final String TAG_INTENT = "intent";
    private static final String ATTR_USERID = "user_id";
    private static final String TAG_PERSISTABLEBUNDLE = "persistable_bundle";
    private static final String ATTR_LAUNCHEDFROMUID = "launched_from_uid";
    private static final String ATTR_LAUNCHEDFROMPACKAGE = "launched_from_package";
    private static final String ATTR_RESOLVEDTYPE = "resolved_type";
    private static final String ATTR_COMPONENTSPECIFIED = "component_specified";
    static final String ACTIVITY_ICON_SUFFIX = "_activity_icon_";
    final ActivityManagerService service;
    final IApplicationToken.Stub appToken;
    AppWindowContainerController mWindowContainerController;
    final ActivityInfo info;
    final ApplicationInfo appInfo;
    final int launchedFromPid;
    final int launchedFromUid;
    final String launchedFromPackage;
    final int userId;
    final Intent intent;
    final ComponentName realActivity;
    final String shortComponentName;
    final String resolvedType;
    final String packageName;
    final String processName;
    final String taskAffinity;
    final boolean stateNotNeeded;
    boolean fullscreen;
    final boolean hasWallpaper;
    final boolean noDisplay;
    private final boolean componentSpecified;
    final boolean rootVoiceInteraction;
    private CharSequence nonLocalizedLabel;
    private int labelRes;
    private int icon;
    private int logo;
    private int theme;
    private int realTheme;
    private int windowFlags;
    private TaskRecord task;
    private long createTime = System.currentTimeMillis();
    long displayStartTime;
    long fullyDrawnStartTime;
    private long startTime;
    long lastVisibleTime;
    long cpuTimeAtResume;
    long pauseTime;
    long launchTickTime;
    private MergedConfiguration mLastReportedConfiguration;
    private int mLastReportedDisplayId;
    private boolean mLastReportedMultiWindowMode;
    private boolean mLastReportedPictureInPictureMode;
    CompatibilityInfo compat;
    ActivityRecord resultTo;
    final String resultWho;
    final int requestCode;
    ArrayList<ResultInfo> results;
    HashSet<WeakReference<PendingIntentRecord>> pendingResults;
    ArrayList<ReferrerIntent> newIntents;
    ActivityOptions pendingOptions;
    ActivityOptions returningOptions;
    AppTimeTracker appTimeTracker;
    HashSet<ConnectionRecord> connections;
    UriPermissionOwner uriPermissions;
    ProcessRecord app;
    ActivityStack.ActivityState state;
    Bundle icicle;
    PersistableBundle persistentState;
    boolean frontOfTask;
    boolean launchFailed;
    boolean haveState;
    boolean stopped;
    boolean delayedResume;
    boolean finishing;
    boolean deferRelaunchUntilPaused;
    boolean preserveWindowOnDeferredRelaunch;
    int configChangeFlags;
    private boolean keysPaused;
    int launchMode;
    int lockTaskLaunchMode;
    boolean visible;
    boolean visibleIgnoringKeyguard;
    private boolean mDeferHidingClient;
    boolean sleeping;
    boolean nowVisible;
    boolean idle;
    boolean hasBeenLaunched;
    boolean frozenBeforeDestroy;
    boolean immersive;
    boolean forceNewConfig;
    boolean supportsEnterPipOnTaskSwitch;
    PictureInPictureParams pictureInPictureArgs = new PictureInPictureParams.Builder().build();
    int launchCount;
    long lastLaunchTime;
    ComponentName requestedVrComponent;
    String stringName;
    private boolean inHistory;
    final ActivityStackSupervisor mStackSupervisor;
    static final int STARTING_WINDOW_NOT_SHOWN = 0;
    static final int STARTING_WINDOW_SHOWN = 1;
    static final int STARTING_WINDOW_REMOVED = 2;
    int mStartingWindowState = 0;
    boolean mTaskOverlay = false;
    ActivityManager.TaskDescription taskDescription;
    boolean mLaunchTaskBehind;
    private int[] mVerticalSizeConfigurations;
    private int[] mHorizontalSizeConfigurations;
    private int[] mSmallestSizeConfigurations;
    boolean pendingVoiceInteractionStart;
    IVoiceInteractionSession voiceSession;
    int mRotationAnimationHint = -1;
    private boolean mShowWhenLocked;
    private boolean mTurnScreenOn;
    private final Configuration mTmpConfig = new Configuration();
    private final Rect mTmpBounds = new Rect();

    private static String startingWindowStateToString(int state) {
        switch (state) {
            case 0: {
                return "STARTING_WINDOW_NOT_SHOWN";
            }
            case 1: {
                return "STARTING_WINDOW_SHOWN";
            }
            case 2: {
                return "STARTING_WINDOW_REMOVED";
            }
        }
        return "unknown state=" + state;
    }

    String getLifecycleDescription(String reason) {
        return "packageName=" + this.packageName + ", state=" + (Object)((Object)this.state) + ", reason=" + reason;
    }

    void dump(PrintWriter pw, String prefix) {
        Object iconFilename;
        long now = SystemClock.uptimeMillis();
        pw.print(prefix);
        pw.print("packageName=");
        pw.print(this.packageName);
        pw.print(" processName=");
        pw.println(this.processName);
        pw.print(prefix);
        pw.print("launchedFromUid=");
        pw.print(this.launchedFromUid);
        pw.print(" launchedFromPackage=");
        pw.print(this.launchedFromPackage);
        pw.print(" userId=");
        pw.println(this.userId);
        pw.print(prefix);
        pw.print("app=");
        pw.println(this.app);
        pw.print(prefix);
        pw.println(this.intent.toInsecureStringWithClip());
        pw.print(prefix);
        pw.print("frontOfTask=");
        pw.print(this.frontOfTask);
        pw.print(" task=");
        pw.println(this.task);
        pw.print(prefix);
        pw.print("taskAffinity=");
        pw.println(this.taskAffinity);
        pw.print(prefix);
        pw.print("realActivity=");
        pw.println(this.realActivity.flattenToShortString());
        if (this.appInfo != null) {
            pw.print(prefix);
            pw.print("baseDir=");
            pw.println(this.appInfo.sourceDir);
            if (!Objects.equals(this.appInfo.sourceDir, this.appInfo.publicSourceDir)) {
                pw.print(prefix);
                pw.print("resDir=");
                pw.println(this.appInfo.publicSourceDir);
            }
            pw.print(prefix);
            pw.print("dataDir=");
            pw.println(this.appInfo.dataDir);
            if (this.appInfo.splitSourceDirs != null) {
                pw.print(prefix);
                pw.print("splitDir=");
                pw.println(Arrays.toString(this.appInfo.splitSourceDirs));
            }
        }
        pw.print(prefix);
        pw.print("stateNotNeeded=");
        pw.print(this.stateNotNeeded);
        pw.print(" componentSpecified=");
        pw.print(this.componentSpecified);
        pw.print(" mActivityType=");
        pw.println(WindowConfiguration.activityTypeToString(this.getActivityType()));
        if (this.rootVoiceInteraction) {
            pw.print(prefix);
            pw.print("rootVoiceInteraction=");
            pw.println(this.rootVoiceInteraction);
        }
        pw.print(prefix);
        pw.print("compat=");
        pw.print(this.compat);
        pw.print(" labelRes=0x");
        pw.print(Integer.toHexString(this.labelRes));
        pw.print(" icon=0x");
        pw.print(Integer.toHexString(this.icon));
        pw.print(" theme=0x");
        pw.println(Integer.toHexString(this.theme));
        pw.println(prefix + "mLastReportedConfigurations:");
        this.mLastReportedConfiguration.dump(pw, prefix + " ");
        pw.print(prefix);
        pw.print("CurrentConfiguration=");
        pw.println(this.getConfiguration());
        if (!this.getOverrideConfiguration().equals(Configuration.EMPTY)) {
            pw.println(prefix + "OverrideConfiguration=" + this.getOverrideConfiguration());
        }
        if (!this.matchParentBounds()) {
            pw.println(prefix + "bounds=" + this.getBounds());
        }
        if (this.resultTo != null || this.resultWho != null) {
            pw.print(prefix);
            pw.print("resultTo=");
            pw.print(this.resultTo);
            pw.print(" resultWho=");
            pw.print(this.resultWho);
            pw.print(" resultCode=");
            pw.println(this.requestCode);
        }
        if (this.taskDescription != null && ((iconFilename = this.taskDescription.getIconFilename()) != null || this.taskDescription.getLabel() != null || this.taskDescription.getPrimaryColor() != 0)) {
            pw.print(prefix);
            pw.print("taskDescription:");
            pw.print(" label=\"");
            pw.print(this.taskDescription.getLabel());
            pw.print("\"");
            pw.print(" icon=");
            pw.print(this.taskDescription.getInMemoryIcon() != null ? this.taskDescription.getInMemoryIcon().getByteCount() + " bytes" : "null");
            pw.print(" iconResource=");
            pw.print(this.taskDescription.getIconResource());
            pw.print(" iconFilename=");
            pw.print(this.taskDescription.getIconFilename());
            pw.print(" primaryColor=");
            pw.println(Integer.toHexString(this.taskDescription.getPrimaryColor()));
            pw.print(prefix + " backgroundColor=");
            pw.println(Integer.toHexString(this.taskDescription.getBackgroundColor()));
            pw.print(prefix + " statusBarColor=");
            pw.println(Integer.toHexString(this.taskDescription.getStatusBarColor()));
            pw.print(prefix + " navigationBarColor=");
            pw.println(Integer.toHexString(this.taskDescription.getNavigationBarColor()));
        }
        if (this.results != null) {
            pw.print(prefix);
            pw.print("results=");
            pw.println(this.results);
        }
        if (this.pendingResults != null && this.pendingResults.size() > 0) {
            pw.print(prefix);
            pw.println("Pending Results:");
            for (WeakReference weakReference : this.pendingResults) {
                PendingIntentRecord pir = weakReference != null ? (PendingIntentRecord)weakReference.get() : null;
                pw.print(prefix);
                pw.print("  - ");
                if (pir == null) {
                    pw.println("null");
                    continue;
                }
                pw.println(pir);
                pir.dump(pw, prefix + "    ");
            }
        }
        if (this.newIntents != null && this.newIntents.size() > 0) {
            pw.print(prefix);
            pw.println("Pending New Intents:");
            for (int i = 0; i < this.newIntents.size(); ++i) {
                Intent intent = this.newIntents.get(i);
                pw.print(prefix);
                pw.print("  - ");
                if (intent == null) {
                    pw.println("null");
                    continue;
                }
                pw.println(intent.toShortString(false, true, false, true));
            }
        }
        if (this.pendingOptions != null) {
            pw.print(prefix);
            pw.print("pendingOptions=");
            pw.println(this.pendingOptions);
        }
        if (this.appTimeTracker != null) {
            this.appTimeTracker.dumpWithHeader(pw, prefix, false);
        }
        if (this.uriPermissions != null) {
            this.uriPermissions.dump(pw, prefix);
        }
        pw.print(prefix);
        pw.print("launchFailed=");
        pw.print(this.launchFailed);
        pw.print(" launchCount=");
        pw.print(this.launchCount);
        pw.print(" lastLaunchTime=");
        if (this.lastLaunchTime == 0L) {
            pw.print("0");
        } else {
            TimeUtils.formatDuration(this.lastLaunchTime, now, pw);
        }
        pw.println();
        pw.print(prefix);
        pw.print("haveState=");
        pw.print(this.haveState);
        pw.print(" icicle=");
        pw.println(this.icicle);
        pw.print(prefix);
        pw.print("state=");
        pw.print((Object)this.state);
        pw.print(" stopped=");
        pw.print(this.stopped);
        pw.print(" delayedResume=");
        pw.print(this.delayedResume);
        pw.print(" finishing=");
        pw.println(this.finishing);
        pw.print(prefix);
        pw.print("keysPaused=");
        pw.print(this.keysPaused);
        pw.print(" inHistory=");
        pw.print(this.inHistory);
        pw.print(" visible=");
        pw.print(this.visible);
        pw.print(" sleeping=");
        pw.print(this.sleeping);
        pw.print(" idle=");
        pw.print(this.idle);
        pw.print(" mStartingWindowState=");
        pw.println(ActivityRecord.startingWindowStateToString(this.mStartingWindowState));
        pw.print(prefix);
        pw.print("fullscreen=");
        pw.print(this.fullscreen);
        pw.print(" noDisplay=");
        pw.print(this.noDisplay);
        pw.print(" immersive=");
        pw.print(this.immersive);
        pw.print(" launchMode=");
        pw.println(this.launchMode);
        pw.print(prefix);
        pw.print("frozenBeforeDestroy=");
        pw.print(this.frozenBeforeDestroy);
        pw.print(" forceNewConfig=");
        pw.println(this.forceNewConfig);
        pw.print(prefix);
        pw.print("mActivityType=");
        pw.println(WindowConfiguration.activityTypeToString(this.getActivityType()));
        if (this.requestedVrComponent != null) {
            pw.print(prefix);
            pw.print("requestedVrComponent=");
            pw.println(this.requestedVrComponent);
        }
        if (this.displayStartTime != 0L || this.startTime != 0L) {
            pw.print(prefix);
            pw.print("displayStartTime=");
            if (this.displayStartTime == 0L) {
                pw.print("0");
            } else {
                TimeUtils.formatDuration(this.displayStartTime, now, pw);
            }
            pw.print(" startTime=");
            if (this.startTime == 0L) {
                pw.print("0");
            } else {
                TimeUtils.formatDuration(this.startTime, now, pw);
            }
            pw.println();
        }
        boolean waitingVisible = this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.contains(this);
        if (this.lastVisibleTime != 0L || waitingVisible || this.nowVisible) {
            pw.print(prefix);
            pw.print("waitingVisible=");
            pw.print(waitingVisible);
            pw.print(" nowVisible=");
            pw.print(this.nowVisible);
            pw.print(" lastVisibleTime=");
            if (this.lastVisibleTime == 0L) {
                pw.print("0");
            } else {
                TimeUtils.formatDuration(this.lastVisibleTime, now, pw);
            }
            pw.println();
        }
        if (this.mDeferHidingClient) {
            pw.println(prefix + "mDeferHidingClient=" + this.mDeferHidingClient);
        }
        if (this.deferRelaunchUntilPaused || this.configChangeFlags != 0) {
            pw.print(prefix);
            pw.print("deferRelaunchUntilPaused=");
            pw.print(this.deferRelaunchUntilPaused);
            pw.print(" configChangeFlags=");
            pw.println(Integer.toHexString(this.configChangeFlags));
        }
        if (this.connections != null) {
            pw.print(prefix);
            pw.print("connections=");
            pw.println(this.connections);
        }
        if (this.info != null) {
            pw.println(prefix + "resizeMode=" + ActivityInfo.resizeModeToString(this.info.resizeMode));
            pw.println(prefix + "mLastReportedMultiWindowMode=" + this.mLastReportedMultiWindowMode + " mLastReportedPictureInPictureMode=" + this.mLastReportedPictureInPictureMode);
            if (this.info.supportsPictureInPicture()) {
                pw.println(prefix + "supportsPictureInPicture=" + this.info.supportsPictureInPicture());
                pw.println(prefix + "supportsEnterPipOnTaskSwitch: " + this.supportsEnterPipOnTaskSwitch);
            }
            if (this.info.maxAspectRatio != 0.0f) {
                pw.println(prefix + "maxAspectRatio=" + this.info.maxAspectRatio);
            }
        }
    }

    private boolean crossesHorizontalSizeThreshold(int firstDp, int secondDp) {
        return ActivityRecord.crossesSizeThreshold(this.mHorizontalSizeConfigurations, firstDp, secondDp);
    }

    private boolean crossesVerticalSizeThreshold(int firstDp, int secondDp) {
        return ActivityRecord.crossesSizeThreshold(this.mVerticalSizeConfigurations, firstDp, secondDp);
    }

    private boolean crossesSmallestSizeThreshold(int firstDp, int secondDp) {
        return ActivityRecord.crossesSizeThreshold(this.mSmallestSizeConfigurations, firstDp, secondDp);
    }

    private static boolean crossesSizeThreshold(int[] thresholds, int firstDp, int secondDp) {
        if (thresholds == null) {
            return false;
        }
        for (int i = thresholds.length - 1; i >= 0; --i) {
            int threshold = thresholds[i];
            if ((firstDp >= threshold || secondDp < threshold) && (firstDp < threshold || secondDp >= threshold)) continue;
            return true;
        }
        return false;
    }

    void setSizeConfigurations(int[] horizontalSizeConfiguration, int[] verticalSizeConfigurations, int[] smallestSizeConfigurations) {
        this.mHorizontalSizeConfigurations = horizontalSizeConfiguration;
        this.mVerticalSizeConfigurations = verticalSizeConfigurations;
        this.mSmallestSizeConfigurations = smallestSizeConfigurations;
    }

    private void scheduleActivityMovedToDisplay(int displayId, Configuration config) {
        if (this.app == null || this.app.thread == null) {
            return;
        }
        try {
            this.service.mLifecycleManager.scheduleTransaction(this.app.thread, (IBinder)this.appToken, MoveToDisplayItem.obtain(displayId, config));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void scheduleConfigurationChanged(Configuration config) {
        if (this.app == null || this.app.thread == null) {
            return;
        }
        try {
            this.service.mLifecycleManager.scheduleTransaction(this.app.thread, (IBinder)this.appToken, ActivityConfigurationChangeItem.obtain(config));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void updateMultiWindowMode() {
        if (this.task == null || this.task.getStack() == null || this.app == null || this.app.thread == null) {
            return;
        }
        if (((ActivityStack)this.task.getStack()).deferScheduleMultiWindowModeChanged()) {
            return;
        }
        boolean inMultiWindowMode = this.inMultiWindowMode();
        if (inMultiWindowMode != this.mLastReportedMultiWindowMode) {
            this.mLastReportedMultiWindowMode = inMultiWindowMode;
            this.scheduleMultiWindowModeChanged(this.getConfiguration());
        }
    }

    private void scheduleMultiWindowModeChanged(Configuration overrideConfig) {
        try {
            this.service.mLifecycleManager.scheduleTransaction(this.app.thread, (IBinder)this.appToken, MultiWindowModeChangeItem.obtain(this.mLastReportedMultiWindowMode, overrideConfig));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void updatePictureInPictureMode(Rect targetStackBounds, boolean forceUpdate) {
        boolean inPictureInPictureMode;
        if (this.task == null || this.task.getStack() == null || this.app == null || this.app.thread == null) {
            return;
        }
        boolean bl = inPictureInPictureMode = this.inPinnedWindowingMode() && targetStackBounds != null;
        if (inPictureInPictureMode != this.mLastReportedPictureInPictureMode || forceUpdate) {
            this.mLastReportedPictureInPictureMode = inPictureInPictureMode;
            this.mLastReportedMultiWindowMode = this.inMultiWindowMode();
            Configuration newConfig = this.task.computeNewOverrideConfigurationForBounds(targetStackBounds, null);
            this.schedulePictureInPictureModeChanged(newConfig);
            this.scheduleMultiWindowModeChanged(newConfig);
        }
    }

    private void schedulePictureInPictureModeChanged(Configuration overrideConfig) {
        try {
            this.service.mLifecycleManager.scheduleTransaction(this.app.thread, (IBinder)this.appToken, PipModeChangeItem.obtain(this.mLastReportedPictureInPictureMode, overrideConfig));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected int getChildCount() {
        return 0;
    }

    protected ConfigurationContainer getChildAt(int index) {
        return null;
    }

    @Override
    protected ConfigurationContainer getParent() {
        return this.getTask();
    }

    TaskRecord getTask() {
        return this.task;
    }

    void setTask(TaskRecord task) {
        this.setTask(task, false);
    }

    void setTask(TaskRecord task, boolean reparenting) {
        if (task != null && task == this.getTask()) {
            return;
        }
        Object stack = this.getStack();
        if (!(reparenting || stack == null || task != null && stack == task.getStack())) {
            ((ActivityStack)stack).onActivityRemovedFromStack(this);
        }
        this.task = task;
        if (!reparenting) {
            this.onParentChanged();
        }
    }

    static ActivityRecord forTokenLocked(IBinder token) {
        try {
            return Token.tokenToActivityRecordLocked((Token)token);
        }
        catch (ClassCastException e) {
            Slog.w("ActivityManager", "Bad activity token: " + token, e);
            return null;
        }
    }

    boolean isResolverActivity() {
        return ResolverActivity.class.getName().equals(this.realActivity.getClassName());
    }

    ActivityRecord(ActivityManagerService _service, ProcessRecord _caller, int _launchedFromPid, int _launchedFromUid, String _launchedFromPackage, Intent _intent, String _resolvedType, ActivityInfo aInfo, Configuration _configuration, ActivityRecord _resultTo, String _resultWho, int _reqCode, boolean _componentSpecified, boolean _rootVoiceInteraction, ActivityStackSupervisor supervisor, ActivityOptions options, ActivityRecord sourceRecord) {
        this.service = _service;
        this.appToken = new Token(this, _intent);
        this.info = aInfo;
        this.launchedFromPid = _launchedFromPid;
        this.launchedFromUid = _launchedFromUid;
        this.launchedFromPackage = _launchedFromPackage;
        this.userId = UserHandle.getUserId(aInfo.applicationInfo.uid);
        this.intent = _intent;
        this.shortComponentName = _intent.getComponent().flattenToShortString();
        this.resolvedType = _resolvedType;
        this.componentSpecified = _componentSpecified;
        this.rootVoiceInteraction = _rootVoiceInteraction;
        this.mLastReportedConfiguration = new MergedConfiguration(_configuration);
        this.resultTo = _resultTo;
        this.resultWho = _resultWho;
        this.requestCode = _reqCode;
        this.state = ActivityStack.ActivityState.INITIALIZING;
        this.frontOfTask = false;
        this.launchFailed = false;
        this.stopped = false;
        this.delayedResume = false;
        this.finishing = false;
        this.deferRelaunchUntilPaused = false;
        this.keysPaused = false;
        this.inHistory = false;
        this.visible = false;
        this.nowVisible = false;
        this.idle = false;
        this.hasBeenLaunched = false;
        this.mStackSupervisor = supervisor;
        this.haveState = true;
        this.realActivity = aInfo.targetActivity == null || aInfo.targetActivity.equals(_intent.getComponent().getClassName()) && (aInfo.launchMode == 0 || aInfo.launchMode == 1) ? _intent.getComponent() : new ComponentName(aInfo.packageName, aInfo.targetActivity);
        this.taskAffinity = aInfo.taskAffinity;
        this.stateNotNeeded = (aInfo.flags & 0x10) != 0;
        this.appInfo = aInfo.applicationInfo;
        this.nonLocalizedLabel = aInfo.nonLocalizedLabel;
        this.labelRes = aInfo.labelRes;
        if (this.nonLocalizedLabel == null && this.labelRes == 0) {
            ApplicationInfo app = aInfo.applicationInfo;
            this.nonLocalizedLabel = app.nonLocalizedLabel;
            this.labelRes = app.labelRes;
        }
        this.icon = aInfo.getIconResource();
        this.logo = aInfo.getLogoResource();
        this.realTheme = this.theme = aInfo.getThemeResource();
        if (this.realTheme == 0) {
            int n = this.realTheme = aInfo.applicationInfo.targetSdkVersion < 11 ? 16973829 : 16973931;
        }
        if ((aInfo.flags & 0x200) != 0) {
            this.windowFlags |= 0x1000000;
        }
        this.processName = (aInfo.flags & 1) != 0 && _caller != null && (aInfo.applicationInfo.uid == 1000 || aInfo.applicationInfo.uid == _caller.info.uid) ? _caller.processName : aInfo.processName;
        if ((aInfo.flags & 0x20) != 0) {
            this.intent.addFlags(0x800000);
        }
        this.packageName = aInfo.applicationInfo.packageName;
        this.launchMode = aInfo.launchMode;
        AttributeCache.Entry ent = AttributeCache.instance().get(this.packageName, this.realTheme, R.styleable.Window, this.userId);
        if (ent != null) {
            this.fullscreen = !ActivityInfo.isTranslucentOrFloating(ent.array);
            this.hasWallpaper = ent.array.getBoolean(14, false);
            this.noDisplay = ent.array.getBoolean(10, false);
        } else {
            this.hasWallpaper = false;
            this.noDisplay = false;
        }
        this.setActivityType(_componentSpecified, _launchedFromUid, _intent, options, sourceRecord);
        this.immersive = (aInfo.flags & 0x800) != 0;
        this.requestedVrComponent = aInfo.requestedVrComponent == null ? null : ComponentName.unflattenFromString(aInfo.requestedVrComponent);
        this.mShowWhenLocked = (aInfo.flags & 0x800000) != 0;
        this.mTurnScreenOn = (aInfo.flags & 0x1000000) != 0;
        this.mRotationAnimationHint = aInfo.rotationAnimation;
        this.lockTaskLaunchMode = aInfo.lockTaskLaunchMode;
        if (this.appInfo.isPrivilegedApp() && (this.lockTaskLaunchMode == 2 || this.lockTaskLaunchMode == 1)) {
            this.lockTaskLaunchMode = 0;
        }
        if (options != null) {
            boolean useLockTask;
            PendingIntent usageReport;
            this.pendingOptions = options;
            this.mLaunchTaskBehind = options.getLaunchTaskBehind();
            int rotationAnimation = this.pendingOptions.getRotationAnimationHint();
            if (rotationAnimation >= 0) {
                this.mRotationAnimationHint = rotationAnimation;
            }
            if ((usageReport = this.pendingOptions.getUsageTimeReport()) != null) {
                this.appTimeTracker = new AppTimeTracker(usageReport);
            }
            if ((useLockTask = this.pendingOptions.getLockTaskMode()) && this.lockTaskLaunchMode == 0) {
                this.lockTaskLaunchMode = 3;
            }
        }
    }

    void setProcess(ProcessRecord proc) {
        ActivityRecord root;
        this.app = proc;
        ActivityRecord activityRecord = root = this.task != null ? this.task.getRootActivity() : null;
        if (root == this) {
            this.task.setRootProcess(proc);
        }
    }

    AppWindowContainerController getWindowContainerController() {
        return this.mWindowContainerController;
    }

    void createWindowContainer() {
        if (this.mWindowContainerController != null) {
            throw new IllegalArgumentException("Window container=" + this.mWindowContainerController + " already created for r=" + this);
        }
        this.inHistory = true;
        TaskWindowContainerController taskController = this.task.getWindowContainerController();
        this.task.updateOverrideConfigurationFromLaunchBounds();
        this.updateOverrideConfiguration();
        this.mWindowContainerController = new AppWindowContainerController(taskController, this.appToken, this, Integer.MAX_VALUE, this.info.screenOrientation, this.fullscreen, (this.info.flags & 0x400) != 0, this.info.configChanges, this.task.voiceSession != null, this.mLaunchTaskBehind, this.isAlwaysFocusable(), this.appInfo.targetSdkVersion, this.mRotationAnimationHint, ActivityManagerService.getInputDispatchingTimeoutLocked(this) * 1000000L);
        this.task.addActivityToTop(this);
        this.mLastReportedMultiWindowMode = this.inMultiWindowMode();
        this.mLastReportedPictureInPictureMode = this.inPinnedWindowingMode();
    }

    void removeWindowContainer() {
        this.resumeKeyDispatchingLocked();
        this.mWindowContainerController.removeContainer(this.getDisplayId());
        this.mWindowContainerController = null;
    }

    void reparent(TaskRecord newTask, int position, String reason) {
        TaskRecord prevTask = this.task;
        if (prevTask == newTask) {
            throw new IllegalArgumentException(reason + ": task=" + newTask + " is already the parent of r=" + this);
        }
        if (prevTask != null && newTask != null && prevTask.getStack() != newTask.getStack()) {
            throw new IllegalArgumentException(reason + ": task=" + newTask + " is in a different stack (" + newTask.getStackId() + ") than the parent of r=" + this + " (" + prevTask.getStackId() + ")");
        }
        this.mWindowContainerController.reparent(newTask.getWindowContainerController(), position);
        prevTask.removeActivity(this, true);
        newTask.addActivityAtIndex(position, this);
    }

    private boolean isHomeIntent(Intent intent) {
        return "android.intent.action.MAIN".equals(intent.getAction()) && intent.hasCategory("android.intent.category.HOME") && intent.getCategories().size() == 1 && intent.getData() == null && intent.getType() == null;
    }

    static boolean isMainIntent(Intent intent) {
        return "android.intent.action.MAIN".equals(intent.getAction()) && intent.hasCategory("android.intent.category.LAUNCHER") && intent.getCategories().size() == 1 && intent.getData() == null && intent.getType() == null;
    }

    private boolean canLaunchHomeActivity(int uid, ActivityRecord sourceRecord) {
        if (uid == Process.myUid() || uid == 0) {
            return true;
        }
        return sourceRecord != null && sourceRecord.isResolverActivity();
    }

    private boolean canLaunchAssistActivity(String packageName) {
        ComponentName assistComponent = this.service.mActiveVoiceInteractionServiceComponent;
        if (assistComponent != null) {
            return assistComponent.getPackageName().equals(packageName);
        }
        return false;
    }

    private void setActivityType(boolean componentSpecified, int launchedFromUid, Intent intent, ActivityOptions options, ActivityRecord sourceRecord) {
        int activityType = 0;
        if ((!componentSpecified || this.canLaunchHomeActivity(launchedFromUid, sourceRecord)) && this.isHomeIntent(intent) && !this.isResolverActivity()) {
            activityType = 2;
            if (this.info.resizeMode == 4 || this.info.resizeMode == 1) {
                this.info.resizeMode = 0;
            }
        } else if (this.realActivity.getClassName().contains(LEGACY_RECENTS_PACKAGE_NAME) || this.service.getRecentTasks().isRecentsComponent(this.realActivity, this.appInfo.uid)) {
            activityType = 3;
        } else if (options != null && options.getLaunchActivityType() == 4 && this.canLaunchAssistActivity(this.launchedFromPackage)) {
            activityType = 4;
        }
        this.setActivityType(activityType);
    }

    void setTaskToAffiliateWith(TaskRecord taskToAffiliateWith) {
        if (this.launchMode != 3 && this.launchMode != 2) {
            this.task.setTaskToAffiliateWith(taskToAffiliateWith);
        }
    }

    <T extends ActivityStack> T getStack() {
        return this.task != null ? (T)this.task.getStack() : null;
    }

    int getStackId() {
        return this.getStack() != null ? ((ActivityStack)this.getStack()).mStackId : -1;
    }

    ActivityDisplay getDisplay() {
        Object stack = this.getStack();
        return stack != null ? ((ActivityStack)stack).getDisplay() : null;
    }

    boolean changeWindowTranslucency(boolean toOpaque) {
        if (this.fullscreen == toOpaque) {
            return false;
        }
        this.task.numFullscreen = this.task.numFullscreen + (toOpaque ? 1 : -1);
        this.fullscreen = toOpaque;
        return true;
    }

    void takeFromHistory() {
        if (this.inHistory) {
            this.inHistory = false;
            if (this.task != null && !this.finishing) {
                this.task = null;
            }
            this.clearOptionsLocked();
        }
    }

    boolean isInHistory() {
        return this.inHistory;
    }

    boolean isInStackLocked() {
        Object stack = this.getStack();
        return stack != null && ((ActivityStack)stack).isInStackLocked(this) != null;
    }

    boolean isPersistable() {
        return !(this.info.persistableMode != 0 && this.info.persistableMode != 2 || this.intent != null && (this.intent.getFlags() & 0x800000) != 0);
    }

    boolean isFocusable() {
        return this.getWindowConfiguration().canReceiveKeys() || this.isAlwaysFocusable();
    }

    boolean isResizeable() {
        return ActivityInfo.isResizeableMode(this.info.resizeMode) || this.info.supportsPictureInPicture();
    }

    boolean isNonResizableOrForcedResizable() {
        return this.info.resizeMode != 2 && this.info.resizeMode != 1;
    }

    boolean supportsPictureInPicture() {
        return this.service.mSupportsPictureInPicture && this.isActivityTypeStandardOrUndefined() && this.info.supportsPictureInPicture();
    }

    @Override
    public boolean supportsSplitScreenWindowingMode() {
        return super.supportsSplitScreenWindowingMode() && this.service.mSupportsSplitScreenMultiWindow && this.supportsResizeableMultiWindow();
    }

    boolean supportsFreeform() {
        return this.service.mSupportsFreeformWindowManagement && this.supportsResizeableMultiWindow();
    }

    private boolean supportsResizeableMultiWindow() {
        return this.service.mSupportsMultiWindow && !this.isActivityTypeHome() && (ActivityInfo.isResizeableMode(this.info.resizeMode) || this.service.mForceResizableActivities);
    }

    boolean canBeLaunchedOnDisplay(int displayId) {
        TaskRecord task = this.getTask();
        boolean resizeable = task != null ? task.isResizeable() : this.supportsResizeableMultiWindow();
        return this.service.mStackSupervisor.canPlaceEntityOnDisplay(displayId, resizeable, this.launchedFromPid, this.launchedFromUid, this.info);
    }

    boolean checkEnterPictureInPictureState(String caller, boolean beforeStopping) {
        boolean isNotLockedOrOnKeyguard;
        if (!this.supportsPictureInPicture()) {
            return false;
        }
        if (!this.checkEnterPictureInPictureAppOpsState()) {
            return false;
        }
        if (this.service.shouldDisableNonVrUiLocked()) {
            return false;
        }
        boolean isKeyguardLocked = this.service.isKeyguardLocked();
        boolean isCurrentAppLocked = this.service.getLockTaskModeState() != 0;
        ActivityDisplay display = this.getDisplay();
        boolean hasPinnedStack = display != null && display.hasPinnedStack();
        boolean bl = isNotLockedOrOnKeyguard = !isKeyguardLocked && !isCurrentAppLocked;
        if (beforeStopping && hasPinnedStack) {
            return false;
        }
        switch (this.state) {
            case RESUMED: {
                return !isCurrentAppLocked && (this.supportsEnterPipOnTaskSwitch || !beforeStopping);
            }
            case PAUSING: 
            case PAUSED: {
                return isNotLockedOrOnKeyguard && !hasPinnedStack && this.supportsEnterPipOnTaskSwitch;
            }
            case STOPPING: {
                if (!this.supportsEnterPipOnTaskSwitch) break;
                return isNotLockedOrOnKeyguard && !hasPinnedStack;
            }
        }
        return false;
    }

    private boolean checkEnterPictureInPictureAppOpsState() {
        try {
            return this.service.getAppOpsService().checkOperation(67, this.appInfo.uid, this.packageName) == 0;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    boolean isAlwaysFocusable() {
        return (this.info.flags & 0x40000) != 0;
    }

    boolean hasDismissKeyguardWindows() {
        return this.service.mWindowManager.containsDismissKeyguardWindow(this.appToken);
    }

    void makeFinishingLocked() {
        if (this.finishing) {
            return;
        }
        this.finishing = true;
        if (this.stopped) {
            this.clearOptionsLocked();
        }
        if (this.service != null) {
            this.service.mTaskChangeNotificationController.notifyTaskStackChanged();
        }
    }

    UriPermissionOwner getUriPermissionsLocked() {
        if (this.uriPermissions == null) {
            this.uriPermissions = new UriPermissionOwner(this.service, this);
        }
        return this.uriPermissions;
    }

    void addResultLocked(ActivityRecord from, String resultWho, int requestCode, int resultCode, Intent resultData) {
        ActivityResult r = new ActivityResult(from, resultWho, requestCode, resultCode, resultData);
        if (this.results == null) {
            this.results = new ArrayList();
        }
        this.results.add(r);
    }

    void removeResultsLocked(ActivityRecord from, String resultWho, int requestCode) {
        if (this.results != null) {
            for (int i = this.results.size() - 1; i >= 0; --i) {
                ActivityResult r = (ActivityResult)this.results.get(i);
                if (r.mFrom != from || (r.mResultWho != null ? !r.mResultWho.equals(resultWho) : resultWho != null) || r.mRequestCode != requestCode) continue;
                this.results.remove(i);
            }
        }
    }

    private void addNewIntentLocked(ReferrerIntent intent) {
        if (this.newIntents == null) {
            this.newIntents = new ArrayList();
        }
        this.newIntents.add(intent);
    }

    final void deliverNewIntentLocked(int callingUid, Intent intent, String referrer) {
        boolean isTopActivityWhileSleeping;
        this.service.grantUriPermissionFromIntentLocked(callingUid, this.packageName, intent, this.getUriPermissionsLocked(), this.userId);
        ReferrerIntent rintent = new ReferrerIntent(intent, referrer);
        boolean unsent = true;
        Object stack = this.getStack();
        boolean bl = this.isTopRunningActivity() && (stack != null ? ((ActivityStack)stack).shouldSleepActivities() : this.service.isSleepingLocked()) ? true : (isTopActivityWhileSleeping = false);
        if ((this.state == ActivityStack.ActivityState.RESUMED || this.state == ActivityStack.ActivityState.PAUSED || isTopActivityWhileSleeping) && this.app != null && this.app.thread != null) {
            try {
                ArrayList<ReferrerIntent> ar = new ArrayList<ReferrerIntent>(1);
                ar.add(rintent);
                this.service.mLifecycleManager.scheduleTransaction(this.app.thread, (IBinder)this.appToken, NewIntentItem.obtain(ar, this.state == ActivityStack.ActivityState.PAUSED));
                unsent = false;
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Exception thrown sending new intent to " + this, e);
            }
            catch (NullPointerException e) {
                Slog.w("ActivityManager", "Exception thrown sending new intent to " + this, e);
            }
        }
        if (unsent) {
            this.addNewIntentLocked(rintent);
        }
    }

    void updateOptionsLocked(ActivityOptions options) {
        if (options != null) {
            if (this.pendingOptions != null) {
                this.pendingOptions.abort();
            }
            this.pendingOptions = options;
        }
    }

    void applyOptionsLocked() {
        if (this.pendingOptions != null && this.pendingOptions.getAnimationType() != 5) {
            int animationType = this.pendingOptions.getAnimationType();
            switch (animationType) {
                case 1: {
                    this.service.mWindowManager.overridePendingAppTransition(this.pendingOptions.getPackageName(), this.pendingOptions.getCustomEnterResId(), this.pendingOptions.getCustomExitResId(), this.pendingOptions.getOnAnimationStartListener());
                    break;
                }
                case 11: {
                    this.service.mWindowManager.overridePendingAppTransitionClipReveal(this.pendingOptions.getStartX(), this.pendingOptions.getStartY(), this.pendingOptions.getWidth(), this.pendingOptions.getHeight());
                    if (this.intent.getSourceBounds() != null) break;
                    this.intent.setSourceBounds(new Rect(this.pendingOptions.getStartX(), this.pendingOptions.getStartY(), this.pendingOptions.getStartX() + this.pendingOptions.getWidth(), this.pendingOptions.getStartY() + this.pendingOptions.getHeight()));
                    break;
                }
                case 2: {
                    this.service.mWindowManager.overridePendingAppTransitionScaleUp(this.pendingOptions.getStartX(), this.pendingOptions.getStartY(), this.pendingOptions.getWidth(), this.pendingOptions.getHeight());
                    if (this.intent.getSourceBounds() != null) break;
                    this.intent.setSourceBounds(new Rect(this.pendingOptions.getStartX(), this.pendingOptions.getStartY(), this.pendingOptions.getStartX() + this.pendingOptions.getWidth(), this.pendingOptions.getStartY() + this.pendingOptions.getHeight()));
                    break;
                }
                case 3: 
                case 4: {
                    boolean scaleUp = animationType == 3;
                    GraphicBuffer buffer = this.pendingOptions.getThumbnail();
                    this.service.mWindowManager.overridePendingAppTransitionThumb(buffer, this.pendingOptions.getStartX(), this.pendingOptions.getStartY(), this.pendingOptions.getOnAnimationStartListener(), scaleUp);
                    if (this.intent.getSourceBounds() != null || buffer == null) break;
                    this.intent.setSourceBounds(new Rect(this.pendingOptions.getStartX(), this.pendingOptions.getStartY(), this.pendingOptions.getStartX() + buffer.getWidth(), this.pendingOptions.getStartY() + buffer.getHeight()));
                    break;
                }
                case 8: 
                case 9: {
                    AppTransitionAnimationSpec[] specs = this.pendingOptions.getAnimSpecs();
                    IAppTransitionAnimationSpecsFuture specsFuture = this.pendingOptions.getSpecsFuture();
                    if (specsFuture != null) {
                        this.service.mWindowManager.overridePendingAppTransitionMultiThumbFuture(specsFuture, this.pendingOptions.getOnAnimationStartListener(), animationType == 8);
                        break;
                    }
                    if (animationType == 9 && specs != null) {
                        this.service.mWindowManager.overridePendingAppTransitionMultiThumb(specs, this.pendingOptions.getOnAnimationStartListener(), this.pendingOptions.getAnimationFinishedListener(), false);
                        break;
                    }
                    this.service.mWindowManager.overridePendingAppTransitionAspectScaledThumb(this.pendingOptions.getThumbnail(), this.pendingOptions.getStartX(), this.pendingOptions.getStartY(), this.pendingOptions.getWidth(), this.pendingOptions.getHeight(), this.pendingOptions.getOnAnimationStartListener(), animationType == 8);
                    if (this.intent.getSourceBounds() != null) break;
                    this.intent.setSourceBounds(new Rect(this.pendingOptions.getStartX(), this.pendingOptions.getStartY(), this.pendingOptions.getStartX() + this.pendingOptions.getWidth(), this.pendingOptions.getStartY() + this.pendingOptions.getHeight()));
                    break;
                }
                case 12: {
                    this.service.mWindowManager.overridePendingAppTransitionStartCrossProfileApps();
                    break;
                }
                case 13: {
                    this.service.mWindowManager.overridePendingAppTransitionRemote(this.pendingOptions.getRemoteAnimationAdapter());
                    break;
                }
                default: {
                    Slog.e("ActivityManager", "applyOptionsLocked: Unknown animationType=" + animationType);
                }
            }
            this.pendingOptions = null;
        }
    }

    ActivityOptions getOptionsForTargetActivityLocked() {
        return this.pendingOptions != null ? this.pendingOptions.forTargetActivity() : null;
    }

    void clearOptionsLocked() {
        if (this.pendingOptions != null) {
            this.pendingOptions.abort();
            this.pendingOptions = null;
        }
    }

    ActivityOptions takeOptionsLocked() {
        ActivityOptions opts = this.pendingOptions;
        this.pendingOptions = null;
        return opts;
    }

    void removeUriPermissionsLocked() {
        if (this.uriPermissions != null) {
            this.uriPermissions.removeUriPermissionsLocked();
            this.uriPermissions = null;
        }
    }

    void pauseKeyDispatchingLocked() {
        if (!this.keysPaused) {
            this.keysPaused = true;
            this.mWindowContainerController.pauseKeyDispatching();
        }
    }

    void resumeKeyDispatchingLocked() {
        if (this.keysPaused) {
            this.keysPaused = false;
            this.mWindowContainerController.resumeKeyDispatching();
        }
    }

    private void updateTaskDescription(CharSequence description) {
        this.task.lastDescription = description;
    }

    void setDeferHidingClient(boolean deferHidingClient) {
        if (this.mDeferHidingClient == deferHidingClient) {
            return;
        }
        this.mDeferHidingClient = deferHidingClient;
        if (!this.mDeferHidingClient && !this.visible) {
            this.setVisibility(false);
        }
    }

    void setVisibility(boolean visible) {
        this.mWindowContainerController.setVisibility(visible, this.mDeferHidingClient);
        this.mStackSupervisor.getActivityMetricsLogger().notifyVisibilityChanged(this);
    }

    void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.mDeferHidingClient = !this.visible && this.mDeferHidingClient;
        this.setVisibility(this.visible);
        this.mStackSupervisor.mAppVisibilitiesChangedSinceLastPause = true;
    }

    void notifyAppResumed(boolean wasStopped) {
        this.mWindowContainerController.notifyAppResumed(wasStopped);
    }

    void notifyUnknownVisibilityLaunched() {
        if (!this.noDisplay) {
            this.mWindowContainerController.notifyUnknownVisibilityLaunched();
        }
    }

    boolean shouldBeVisibleIgnoringKeyguard(boolean behindFullscreenActivity) {
        if (!this.okToShowLocked()) {
            return false;
        }
        return !behindFullscreenActivity || this.mLaunchTaskBehind;
    }

    void makeVisibleIfNeeded(ActivityRecord starting) {
        if (this.state == ActivityStack.ActivityState.RESUMED || this == starting) {
            return;
        }
        Object stack = this.getStack();
        try {
            if (((ActivityStack)stack).mTranslucentActivityWaiting != null) {
                this.updateOptionsLocked(this.returningOptions);
                ((ActivityStack)stack).mUndrawnActivitiesBelowTopTranslucent.add(this);
            }
            this.setVisible(true);
            this.sleeping = false;
            this.app.pendingUiClean = true;
            this.service.mLifecycleManager.scheduleTransaction(this.app.thread, (IBinder)this.appToken, WindowVisibilityItem.obtain(true));
            this.mStackSupervisor.mStoppingActivities.remove(this);
            this.mStackSupervisor.mGoingToSleepActivities.remove(this);
        }
        catch (Exception e) {
            Slog.w("ActivityManager", "Exception thrown making visibile: " + this.intent.getComponent(), e);
        }
        this.handleAlreadyVisible();
    }

    boolean handleAlreadyVisible() {
        this.stopFreezingScreenLocked(false);
        try {
            if (this.returningOptions != null) {
                this.app.thread.scheduleOnNewActivityOptions(this.appToken, this.returningOptions.toBundle());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.state == ActivityStack.ActivityState.RESUMED;
    }

    static void activityResumedLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        if (r != null) {
            r.icicle = null;
            r.haveState = false;
        }
    }

    void completeResumeLocked() {
        ProcessRecord app;
        boolean wasVisible = this.visible;
        this.setVisible(true);
        if (!wasVisible) {
            this.mStackSupervisor.mAppVisibilitiesChangedSinceLastPause = true;
        }
        this.idle = false;
        this.results = null;
        this.newIntents = null;
        this.stopped = false;
        if (this.isActivityTypeHome() && (app = this.task.mActivities.get((int)0).app) != null && app != this.service.mHomeProcess) {
            this.service.mHomeProcess = app;
        }
        if (this.nowVisible) {
            this.mStackSupervisor.reportActivityVisibleLocked(this);
        }
        this.mStackSupervisor.scheduleIdleTimeoutLocked(this);
        this.mStackSupervisor.reportResumedActivityLocked(this);
        this.resumeKeyDispatchingLocked();
        Object stack = this.getStack();
        this.mStackSupervisor.mNoAnimActivities.clear();
        this.cpuTimeAtResume = this.app != null ? this.service.mProcessCpuTracker.getCpuTimeForPid(this.app.pid) : 0L;
        this.returningOptions = null;
        if (this.canTurnScreenOn()) {
            this.mStackSupervisor.wakeUp("turnScreenOnFlag");
        } else {
            ((ActivityStack)stack).checkReadyForSleep();
        }
    }

    final void activityStoppedLocked(Bundle newIcicle, PersistableBundle newPersistentState, CharSequence description) {
        Object stack = this.getStack();
        if (this.state != ActivityStack.ActivityState.STOPPING) {
            Slog.i("ActivityManager", "Activity reported stop, but no longer stopping: " + this);
            ((ActivityStack)stack).mHandler.removeMessages(104, this);
            return;
        }
        if (newPersistentState != null) {
            this.persistentState = newPersistentState;
            this.service.notifyTaskPersisterLocked(this.task, false);
        }
        if (newIcicle != null) {
            this.icicle = newIcicle;
            this.haveState = true;
            this.launchCount = 0;
            this.updateTaskDescription(description);
        }
        if (!this.stopped) {
            ((ActivityStack)stack).mHandler.removeMessages(104, this);
            this.stopped = true;
            this.state = ActivityStack.ActivityState.STOPPED;
            this.mWindowContainerController.notifyAppStopped();
            if (this.finishing) {
                this.clearOptionsLocked();
            } else if (this.deferRelaunchUntilPaused) {
                ((ActivityStack)stack).destroyActivityLocked(this, true, "stop-config");
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
            } else {
                this.mStackSupervisor.updatePreviousProcessLocked(this);
            }
        }
    }

    void startLaunchTickingLocked() {
        if (Build.IS_USER) {
            return;
        }
        if (this.launchTickTime == 0L) {
            this.launchTickTime = SystemClock.uptimeMillis();
            this.continueLaunchTickingLocked();
        }
    }

    boolean continueLaunchTickingLocked() {
        if (this.launchTickTime == 0L) {
            return false;
        }
        Object stack = this.getStack();
        if (stack == null) {
            return false;
        }
        Message msg = ((ActivityStack)stack).mHandler.obtainMessage(103, this);
        ((ActivityStack)stack).mHandler.removeMessages(103);
        ((ActivityStack)stack).mHandler.sendMessageDelayed(msg, 500L);
        return true;
    }

    void finishLaunchTickingLocked() {
        this.launchTickTime = 0L;
        Object stack = this.getStack();
        if (stack != null) {
            ((ActivityStack)stack).mHandler.removeMessages(103);
        }
    }

    public boolean mayFreezeScreenLocked(ProcessRecord app) {
        return app != null && !app.crashing && !app.notResponding;
    }

    public void startFreezingScreenLocked(ProcessRecord app, int configChanges) {
        if (this.mayFreezeScreenLocked(app)) {
            this.mWindowContainerController.startFreezingScreen(configChanges);
        }
    }

    public void stopFreezingScreenLocked(boolean force) {
        if (force || this.frozenBeforeDestroy) {
            this.frozenBeforeDestroy = false;
            this.mWindowContainerController.stopFreezingScreen(force);
        }
    }

    public void reportFullyDrawnLocked(boolean restoredFromBundle) {
        long curTime = SystemClock.uptimeMillis();
        if (this.displayStartTime != 0L) {
            this.reportLaunchTimeLocked(curTime);
        }
        Object stack = this.getStack();
        if (this.fullyDrawnStartTime != 0L && stack != null) {
            long thisTime = curTime - this.fullyDrawnStartTime;
            long totalTime = ((ActivityStack)stack).mFullyDrawnStartTime != 0L ? curTime - ((ActivityStack)stack).mFullyDrawnStartTime : thisTime;
            Trace.asyncTraceEnd(64L, "drawing", 0);
            EventLog.writeEvent(30042, this.userId, System.identityHashCode(this), this.shortComponentName, thisTime, totalTime);
            StringBuilder sb = this.service.mStringBuilder;
            sb.setLength(0);
            sb.append("Fully drawn ");
            sb.append(this.shortComponentName);
            sb.append(": ");
            TimeUtils.formatDuration(thisTime, sb);
            if (thisTime != totalTime) {
                sb.append(" (total ");
                TimeUtils.formatDuration(totalTime, sb);
                sb.append(")");
            }
            Log.i("ActivityManager", sb.toString());
            if (totalTime > 0L) {
                // empty if block
            }
            ((ActivityStack)stack).mFullyDrawnStartTime = 0L;
        }
        this.mStackSupervisor.getActivityMetricsLogger().logAppTransitionReportedDrawn(this, restoredFromBundle);
        this.fullyDrawnStartTime = 0L;
    }

    private void reportLaunchTimeLocked(long curTime) {
        Object stack = this.getStack();
        if (stack == null) {
            return;
        }
        long thisTime = curTime - this.displayStartTime;
        long totalTime = ((ActivityStack)stack).mLaunchStartTime != 0L ? curTime - ((ActivityStack)stack).mLaunchStartTime : thisTime;
        Trace.asyncTraceEnd(64L, "launching: " + this.packageName, 0);
        EventLog.writeEvent(30009, this.userId, System.identityHashCode(this), this.shortComponentName, thisTime, totalTime);
        StringBuilder sb = this.service.mStringBuilder;
        sb.setLength(0);
        sb.append("Displayed ");
        sb.append(this.shortComponentName);
        sb.append(": ");
        TimeUtils.formatDuration(thisTime, sb);
        if (thisTime != totalTime) {
            sb.append(" (total ");
            TimeUtils.formatDuration(totalTime, sb);
            sb.append(")");
        }
        Log.i("ActivityManager", sb.toString());
        this.mStackSupervisor.reportActivityLaunchedLocked(false, this, thisTime, totalTime);
        if (totalTime > 0L) {
            // empty if block
        }
        this.displayStartTime = 0L;
        ((ActivityStack)stack).mLaunchStartTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStartingWindowDrawn(long timestamp) {
        ActivityManagerService activityManagerService = this.service;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mStackSupervisor.getActivityMetricsLogger().notifyStartingWindowDrawn(this.getStackId(), timestamp);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWindowsDrawn(long timestamp) {
        ActivityManagerService activityManagerService = this.service;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mStackSupervisor.getActivityMetricsLogger().notifyWindowsDrawn(this.getStackId(), timestamp);
                if (this.displayStartTime != 0L) {
                    this.reportLaunchTimeLocked(timestamp);
                }
                this.mStackSupervisor.sendWaitingVisibleReportLocked(this);
                this.startTime = 0L;
                this.finishLaunchTickingLocked();
                if (this.task != null) {
                    this.task.hasBeenVisible = true;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var3_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWindowsVisible() {
        ActivityManagerService activityManagerService = this.service;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mStackSupervisor.reportActivityVisibleLocked(this);
                if (!this.nowVisible) {
                    this.nowVisible = true;
                    this.lastVisibleTime = SystemClock.uptimeMillis();
                    if (this.idle || this.mStackSupervisor.isStoppingNoHistoryActivity()) {
                        int size = this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.size();
                        if (size > 0) {
                            for (int i = 0; i < size; ++i) {
                                ActivityRecord activityRecord = this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.get(i);
                            }
                            this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.clear();
                            this.mStackSupervisor.scheduleIdleLocked();
                        }
                    } else {
                        this.mStackSupervisor.processStoppingActivitiesLocked(null, false, true);
                    }
                    this.service.scheduleAppGcsLocked();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl25 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWindowsGone() {
        ActivityManagerService activityManagerService = this.service;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.nowVisible = false;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyDispatchingTimedOut(String reason, int windowPid) {
        boolean windowFromSameProcessAsActivity;
        ProcessRecord anrApp;
        ActivityRecord anrActivity;
        ActivityManagerService activityManagerService = this.service;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                anrActivity = this.getWaitingHistoryRecordLocked();
                anrApp = this.app;
                windowFromSameProcessAsActivity = this.app == null || this.app.pid == windowPid || windowPid == -1;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        if (windowFromSameProcessAsActivity) {
            return this.service.inputDispatchingTimedOut(anrApp, anrActivity, this, false, reason);
        }
        return this.service.inputDispatchingTimedOut(windowPid, false, reason) < 0L;
    }

    private ActivityRecord getWaitingHistoryRecordLocked() {
        if (this.mStackSupervisor.mActivitiesWaitingForVisibleActivity.contains(this) || this.stopped) {
            ActivityStack stack = this.mStackSupervisor.getFocusedStack();
            ActivityRecord r = stack.mResumedActivity;
            if (r == null) {
                r = stack.mPausingActivity;
            }
            if (r != null) {
                return r;
            }
        }
        return this;
    }

    public boolean okToShowLocked() {
        if (!StorageManager.isUserKeyUnlocked(this.userId) && !this.info.applicationInfo.isEncryptionAware()) {
            return false;
        }
        return (this.info.flags & 0x400) != 0 || this.mStackSupervisor.isCurrentProfileLocked(this.userId) && this.service.mUserController.isUserRunning(this.userId, 0);
    }

    public boolean isInterestingToUserLocked() {
        return this.visible || this.nowVisible || this.state == ActivityStack.ActivityState.PAUSING || this.state == ActivityStack.ActivityState.RESUMED;
    }

    void setSleeping(boolean _sleeping) {
        this.setSleeping(_sleeping, false);
    }

    void setSleeping(boolean _sleeping, boolean force) {
        if (!force && this.sleeping == _sleeping) {
            return;
        }
        if (this.app != null && this.app.thread != null) {
            try {
                this.app.thread.scheduleSleeping(this.appToken, _sleeping);
                if (_sleeping && !this.mStackSupervisor.mGoingToSleepActivities.contains(this)) {
                    this.mStackSupervisor.mGoingToSleepActivities.add(this);
                }
                this.sleeping = _sleeping;
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Exception thrown when sleeping: " + this.intent.getComponent(), e);
            }
        }
    }

    static int getTaskForActivityLocked(IBinder token, boolean onlyRoot) {
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        if (r == null) {
            return -1;
        }
        TaskRecord task = r.task;
        int activityNdx = task.mActivities.indexOf(r);
        if (activityNdx < 0 || onlyRoot && activityNdx > task.findEffectiveRootIndex()) {
            return -1;
        }
        return task.taskId;
    }

    static ActivityRecord isInStackLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        return r != null ? ((ActivityStack)r.getStack()).isInStackLocked(r) : null;
    }

    static ActivityStack getStackLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.isInStackLocked(token);
        if (r != null) {
            return r.getStack();
        }
        return null;
    }

    int getDisplayId() {
        Object stack = this.getStack();
        if (stack == null) {
            return -1;
        }
        return ((ActivityStack)stack).mDisplayId;
    }

    final boolean isDestroyable() {
        if (this.finishing || this.app == null || this.state == ActivityStack.ActivityState.DESTROYING || this.state == ActivityStack.ActivityState.DESTROYED) {
            return false;
        }
        Object stack = this.getStack();
        if (stack == null || this == ((ActivityStack)stack).mResumedActivity || this == ((ActivityStack)stack).mPausingActivity || !this.haveState || !this.stopped) {
            return false;
        }
        return !this.visible;
    }

    private static String createImageFilename(long createTime, int taskId) {
        return String.valueOf(taskId) + ACTIVITY_ICON_SUFFIX + createTime + ".png";
    }

    void setTaskDescription(ActivityManager.TaskDescription _taskDescription) {
        Bitmap icon;
        if (_taskDescription.getIconFilename() == null && (icon = _taskDescription.getIcon()) != null) {
            String iconFilename = ActivityRecord.createImageFilename(this.createTime, this.task.taskId);
            File iconFile = new File(TaskPersister.getUserImagesDir(this.task.userId), iconFilename);
            String iconFilePath = iconFile.getAbsolutePath();
            this.service.getRecentTasks().saveImage(icon, iconFilePath);
            _taskDescription.setIconFilename(iconFilePath);
        }
        this.taskDescription = _taskDescription;
    }

    void setVoiceSessionLocked(IVoiceInteractionSession session) {
        this.voiceSession = session;
        this.pendingVoiceInteractionStart = false;
    }

    void clearVoiceSessionLocked() {
        this.voiceSession = null;
        this.pendingVoiceInteractionStart = false;
    }

    void showStartingWindow(ActivityRecord prev, boolean newTask, boolean taskSwitch) {
        this.showStartingWindow(prev, newTask, taskSwitch, false);
    }

    void showStartingWindow(ActivityRecord prev, boolean newTask, boolean taskSwitch, boolean fromRecents) {
        if (this.mWindowContainerController == null) {
            return;
        }
        if (this.mTaskOverlay) {
            return;
        }
        CompatibilityInfo compatInfo = this.service.compatibilityInfoForPackageLocked(this.info.applicationInfo);
        boolean shown = this.mWindowContainerController.addStartingWindow(this.packageName, this.theme, compatInfo, this.nonLocalizedLabel, this.labelRes, this.icon, this.logo, this.windowFlags, prev != null ? prev.appToken : null, newTask, taskSwitch, this.isProcessRunning(), this.allowTaskSnapshot(), this.state.ordinal() >= ActivityStack.ActivityState.RESUMED.ordinal() && this.state.ordinal() <= ActivityStack.ActivityState.STOPPED.ordinal(), fromRecents);
        if (shown) {
            this.mStartingWindowState = 1;
        }
    }

    void removeOrphanedStartingWindow(boolean behindFullscreenActivity) {
        if (this.mStartingWindowState == 1 && behindFullscreenActivity) {
            this.mStartingWindowState = 2;
            this.mWindowContainerController.removeStartingWindow();
        }
    }

    int getRequestedOrientation() {
        return this.mWindowContainerController.getOrientation();
    }

    void setRequestedOrientation(int requestedOrientation) {
        Configuration displayConfig;
        int displayId = this.getDisplayId();
        Configuration config = this.mWindowContainerController.setOrientation(requestedOrientation, displayId, displayConfig = this.mStackSupervisor.getDisplayOverrideConfiguration(displayId), this.mayFreezeScreenLocked(this.app));
        if (config != null) {
            this.frozenBeforeDestroy = true;
            if (!this.service.updateDisplayOverrideConfigurationLocked(config, this, false, displayId)) {
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
            }
        }
        this.service.mTaskChangeNotificationController.notifyActivityRequestedOrientationChanged(this.task.taskId, requestedOrientation);
    }

    void setDisablePreviewScreenshots(boolean disable) {
        this.mWindowContainerController.setDisablePreviewScreenshots(disable);
    }

    void setLastReportedGlobalConfiguration(Configuration config) {
        this.mLastReportedConfiguration.setGlobalConfiguration(config);
    }

    void setLastReportedConfiguration(MergedConfiguration config) {
        this.setLastReportedConfiguration(config.getGlobalConfiguration(), config.getOverrideConfiguration());
    }

    private void setLastReportedConfiguration(Configuration global, Configuration override) {
        this.mLastReportedConfiguration.setConfiguration(global, override);
    }

    private void updateOverrideConfiguration() {
        this.mTmpConfig.unset();
        this.computeBounds(this.mTmpBounds);
        if (this.mTmpBounds.equals(this.getOverrideBounds())) {
            return;
        }
        this.setBounds(this.mTmpBounds);
        Rect updatedBounds = this.getOverrideBounds();
        if (!this.matchParentBounds()) {
            this.task.computeOverrideConfiguration(this.mTmpConfig, updatedBounds, null, false, false);
        }
        this.onOverrideConfigurationChanged(this.mTmpConfig);
    }

    boolean isConfigurationCompatible(Configuration config) {
        int orientation;
        int n = orientation = this.mWindowContainerController != null ? this.mWindowContainerController.getOrientation() : this.info.screenOrientation;
        if (ActivityInfo.isFixedOrientationPortrait(orientation) && config.orientation != 1) {
            return false;
        }
        return !ActivityInfo.isFixedOrientationLandscape(orientation) || config.orientation == 2;
    }

    private void computeBounds(Rect outBounds) {
        outBounds.setEmpty();
        float maxAspectRatio = this.info.maxAspectRatio;
        Object stack = this.getStack();
        if (this.task == null || stack == null || this.task.inMultiWindowMode() || maxAspectRatio == 0.0f || ActivityRecord.isInVrUiMode(this.getConfiguration())) {
            return;
        }
        Rect appBounds = this.getParent().getWindowConfiguration().getAppBounds();
        int containingAppWidth = appBounds.width();
        int containingAppHeight = appBounds.height();
        int maxActivityWidth = containingAppWidth;
        int maxActivityHeight = containingAppHeight;
        if (containingAppWidth < containingAppHeight) {
            maxActivityHeight = (int)((float)maxActivityWidth * maxAspectRatio + 0.5f);
        } else {
            maxActivityWidth = (int)((float)maxActivityHeight * maxAspectRatio + 0.5f);
        }
        if (containingAppWidth <= maxActivityWidth && containingAppHeight <= maxActivityHeight) {
            outBounds.set(this.getOverrideBounds());
            return;
        }
        outBounds.set(0, 0, maxActivityWidth, maxActivityHeight);
        int navBarPosition = this.service.mWindowManager.getNavBarPosition();
        int left = navBarPosition == 1 ? appBounds.right - outBounds.width() : 0;
        outBounds.offsetTo(left, 0);
    }

    boolean ensureActivityConfigurationLocked(int globalChanges, boolean preserveWindow) {
        boolean displayChanged;
        Object stack = this.getStack();
        if (((ActivityStack)stack).mConfigWillChange) {
            return true;
        }
        if (this.finishing) {
            this.stopFreezingScreenLocked(false);
            return true;
        }
        if (this.state == ActivityStack.ActivityState.STOPPING || this.state == ActivityStack.ActivityState.STOPPED) {
            return true;
        }
        if (!((ActivityStack)stack).shouldBeVisible(null)) {
            return true;
        }
        int newDisplayId = this.getDisplayId();
        boolean bl = displayChanged = this.mLastReportedDisplayId != newDisplayId;
        if (displayChanged) {
            this.mLastReportedDisplayId = newDisplayId;
        }
        this.updateOverrideConfiguration();
        this.mTmpConfig.setTo(this.mLastReportedConfiguration.getMergedConfiguration());
        if (this.getConfiguration().equals(this.mTmpConfig) && !this.forceNewConfig && !displayChanged) {
            return true;
        }
        int changes = this.getConfigurationChanges(this.mTmpConfig);
        Configuration newMergedOverrideConfig = this.getMergedOverrideConfiguration();
        this.setLastReportedConfiguration(this.service.getGlobalConfiguration(), newMergedOverrideConfig);
        if (changes == 0 && !this.forceNewConfig) {
            if (displayChanged) {
                this.scheduleActivityMovedToDisplay(newDisplayId, newMergedOverrideConfig);
            } else {
                this.scheduleConfigurationChanged(newMergedOverrideConfig);
            }
            return true;
        }
        if (this.app == null || this.app.thread == null) {
            this.stopFreezingScreenLocked(false);
            this.forceNewConfig = false;
            return true;
        }
        if (this.shouldRelaunchLocked(changes, this.mTmpConfig) || this.forceNewConfig) {
            this.configChangeFlags |= changes;
            this.startFreezingScreenLocked(this.app, globalChanges);
            this.forceNewConfig = false;
            preserveWindow &= ActivityRecord.isResizeOnlyChange(changes);
            if (this.app == null || this.app.thread == null) {
                ((ActivityStack)stack).destroyActivityLocked(this, true, "config");
            } else {
                if (this.state == ActivityStack.ActivityState.PAUSING) {
                    this.deferRelaunchUntilPaused = true;
                    this.preserveWindowOnDeferredRelaunch = preserveWindow;
                    return true;
                }
                if (this.state == ActivityStack.ActivityState.RESUMED) {
                    this.relaunchActivityLocked(true, preserveWindow);
                } else {
                    this.relaunchActivityLocked(false, preserveWindow);
                }
            }
            return false;
        }
        if (displayChanged) {
            this.scheduleActivityMovedToDisplay(newDisplayId, newMergedOverrideConfig);
        } else {
            this.scheduleConfigurationChanged(newMergedOverrideConfig);
        }
        this.stopFreezingScreenLocked(false);
        return true;
    }

    private boolean shouldRelaunchLocked(int changes, Configuration changesConfig) {
        int configChanged = this.info.getRealConfigChanged();
        boolean onlyVrUiModeChanged = this.onlyVrUiModeChanged(changes, changesConfig);
        if (this.appInfo.targetSdkVersion < 26 && this.requestedVrComponent != null && onlyVrUiModeChanged) {
            configChanged |= 0x200;
        }
        return (changes & ~configChanged) != 0;
    }

    private boolean onlyVrUiModeChanged(int changes, Configuration lastReportedConfig) {
        Configuration currentConfig = this.getConfiguration();
        return changes == 512 && ActivityRecord.isInVrUiMode(currentConfig) != ActivityRecord.isInVrUiMode(lastReportedConfig);
    }

    private int getConfigurationChanges(Configuration lastReportedConfig) {
        int newSmallest;
        int oldSmallest;
        Configuration currentConfig = this.getConfiguration();
        int changes = lastReportedConfig.diff(currentConfig);
        if ((changes & 0x400) != 0) {
            boolean crosses;
            boolean bl = crosses = this.crossesHorizontalSizeThreshold(lastReportedConfig.screenWidthDp, currentConfig.screenWidthDp) || this.crossesVerticalSizeThreshold(lastReportedConfig.screenHeightDp, currentConfig.screenHeightDp);
            if (!crosses) {
                changes &= 0xFFFFFBFF;
            }
        }
        if ((changes & 0x800) != 0 && !this.crossesSmallestSizeThreshold(oldSmallest = lastReportedConfig.smallestScreenWidthDp, newSmallest = currentConfig.smallestScreenWidthDp)) {
            changes &= 0xFFFFF7FF;
        }
        if ((changes & 0x20000000) != 0) {
            changes &= 0xDFFFFFFF;
        }
        return changes;
    }

    private static boolean isResizeOnlyChange(int change) {
        return (change & 0xFFFFF27F) == 0;
    }

    void relaunchActivityLocked(boolean andResume, boolean preserveWindow) {
        if (this.service.mSuppressResizeConfigChanges && preserveWindow) {
            this.configChangeFlags = 0;
            return;
        }
        ArrayList<ResultInfo> pendingResults = null;
        ArrayList<ReferrerIntent> pendingNewIntents = null;
        if (andResume) {
            pendingResults = this.results;
            pendingNewIntents = this.newIntents;
        }
        EventLog.writeEvent(andResume ? 30019 : 30020, this.userId, System.identityHashCode(this), this.task.taskId, this.shortComponentName);
        this.startFreezingScreenLocked(this.app, 0);
        try {
            this.forceNewConfig = false;
            this.mStackSupervisor.activityRelaunchingLocked(this);
            this.app.thread.scheduleRelaunchActivity(this.appToken, pendingResults, pendingNewIntents, this.configChangeFlags, !andResume, new Configuration(this.service.getGlobalConfiguration()), new Configuration(this.getMergedOverrideConfiguration()), preserveWindow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (andResume) {
            this.results = null;
            this.newIntents = null;
            this.service.getAppWarningsLocked().onResumeActivity(this);
            this.service.showAskCompatModeDialogLocked(this);
        } else {
            this.service.mHandler.removeMessages(101, this);
            this.state = ActivityStack.ActivityState.PAUSED;
            if (this.stopped) {
                ((ActivityStack)this.getStack()).addToStopping(this, true, false);
            }
        }
        this.configChangeFlags = 0;
        this.deferRelaunchUntilPaused = false;
        this.preserveWindowOnDeferredRelaunch = false;
    }

    private boolean isProcessRunning() {
        ProcessRecord proc = this.app;
        if (proc == null) {
            proc = this.service.mProcessNames.get(this.processName, this.info.applicationInfo.uid);
        }
        return proc != null && proc.thread != null;
    }

    private boolean allowTaskSnapshot() {
        if (this.newIntents == null) {
            return true;
        }
        for (int i = this.newIntents.size() - 1; i >= 0; --i) {
            Intent intent = this.newIntents.get(i);
            if (intent == null || ActivityRecord.isMainIntent(intent)) continue;
            return false;
        }
        return true;
    }

    boolean isNoHistory() {
        return (this.intent.getFlags() & 0x40000000) != 0 || (this.info.flags & 0x80) != 0;
    }

    void saveToXml(XmlSerializer out) throws IOException, XmlPullParserException {
        out.attribute(null, ATTR_ID, String.valueOf(this.createTime));
        out.attribute(null, ATTR_LAUNCHEDFROMUID, String.valueOf(this.launchedFromUid));
        if (this.launchedFromPackage != null) {
            out.attribute(null, ATTR_LAUNCHEDFROMPACKAGE, this.launchedFromPackage);
        }
        if (this.resolvedType != null) {
            out.attribute(null, ATTR_RESOLVEDTYPE, this.resolvedType);
        }
        out.attribute(null, ATTR_COMPONENTSPECIFIED, String.valueOf(this.componentSpecified));
        out.attribute(null, ATTR_USERID, String.valueOf(this.userId));
        if (this.taskDescription != null) {
            this.taskDescription.saveToXml(out);
        }
        out.startTag(null, TAG_INTENT);
        this.intent.saveToXml(out);
        out.endTag(null, TAG_INTENT);
        if (this.isPersistable() && this.persistentState != null) {
            out.startTag(null, TAG_PERSISTABLEBUNDLE);
            this.persistentState.saveToXml(out);
            out.endTag(null, TAG_PERSISTABLEBUNDLE);
        }
    }

    static ActivityRecord restoreFromXml(XmlPullParser in, ActivityStackSupervisor stackSupervisor) throws IOException, XmlPullParserException {
        int event;
        Intent intent = null;
        PersistableBundle persistentState = null;
        int launchedFromUid = 0;
        String launchedFromPackage = null;
        String resolvedType = null;
        boolean componentSpecified = false;
        int userId = 0;
        long createTime = -1L;
        int outerDepth = in.getDepth();
        ActivityManager.TaskDescription taskDescription = new ActivityManager.TaskDescription();
        for (int attrNdx = in.getAttributeCount() - 1; attrNdx >= 0; --attrNdx) {
            String attrName = in.getAttributeName(attrNdx);
            String attrValue = in.getAttributeValue(attrNdx);
            if (ATTR_ID.equals(attrName)) {
                createTime = Long.parseLong(attrValue);
                continue;
            }
            if (ATTR_LAUNCHEDFROMUID.equals(attrName)) {
                launchedFromUid = Integer.parseInt(attrValue);
                continue;
            }
            if (ATTR_LAUNCHEDFROMPACKAGE.equals(attrName)) {
                launchedFromPackage = attrValue;
                continue;
            }
            if (ATTR_RESOLVEDTYPE.equals(attrName)) {
                resolvedType = attrValue;
                continue;
            }
            if (ATTR_COMPONENTSPECIFIED.equals(attrName)) {
                componentSpecified = Boolean.parseBoolean(attrValue);
                continue;
            }
            if (ATTR_USERID.equals(attrName)) {
                userId = Integer.parseInt(attrValue);
                continue;
            }
            if (attrName.startsWith("task_description_")) {
                taskDescription.restoreFromXml(attrName, attrValue);
                continue;
            }
            Log.d("ActivityManager", "Unknown ActivityRecord attribute=" + attrName);
        }
        while ((event = in.next()) != 1 && (event != 3 || in.getDepth() >= outerDepth)) {
            if (event != 2) continue;
            String name = in.getName();
            if (TAG_INTENT.equals(name)) {
                intent = Intent.restoreFromXml(in);
                continue;
            }
            if (TAG_PERSISTABLEBUNDLE.equals(name)) {
                persistentState = PersistableBundle.restoreFromXml(in);
                continue;
            }
            Slog.w("ActivityManager", "restoreActivity: unexpected name=" + name);
            XmlUtils.skipCurrentTag(in);
        }
        if (intent == null) {
            throw new XmlPullParserException("restoreActivity error intent=" + intent);
        }
        ActivityManagerService service = stackSupervisor.mService;
        ActivityInfo aInfo = stackSupervisor.resolveActivity(intent, resolvedType, 0, null, userId);
        if (aInfo == null) {
            throw new XmlPullParserException("restoreActivity resolver error. Intent=" + intent + " resolvedType=" + resolvedType);
        }
        ActivityRecord r = new ActivityRecord(service, null, 0, launchedFromUid, launchedFromPackage, intent, resolvedType, aInfo, service.getConfiguration(), null, null, 0, componentSpecified, false, stackSupervisor, null, null);
        r.persistentState = persistentState;
        r.taskDescription = taskDescription;
        r.createTime = createTime;
        return r;
    }

    private static boolean isInVrUiMode(Configuration config) {
        return (config.uiMode & 0xF) == 7;
    }

    int getUid() {
        return this.info.applicationInfo.uid;
    }

    void setShowWhenLocked(boolean showWhenLocked) {
        this.mShowWhenLocked = showWhenLocked;
        this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
    }

    boolean canShowWhenLocked() {
        return !this.inPinnedWindowingMode() && (this.mShowWhenLocked || this.service.mWindowManager.containsShowWhenLockedWindow(this.appToken));
    }

    void setTurnScreenOn(boolean turnScreenOn) {
        this.mTurnScreenOn = turnScreenOn;
    }

    boolean canTurnScreenOn() {
        Object stack = this.getStack();
        return this.mTurnScreenOn && stack != null && ((ActivityStack)stack).checkKeyguardVisibility(this, true, true);
    }

    boolean getTurnScreenOnFlag() {
        return this.mTurnScreenOn;
    }

    boolean isTopRunningActivity() {
        return this.mStackSupervisor.topRunningActivityLocked() == this;
    }

    void registerRemoteAnimations(RemoteAnimationDefinition definition) {
        this.mWindowContainerController.registerRemoteAnimations(definition);
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName + " t" + (this.task == null ? -1 : this.task.taskId) + (this.finishing ? " f}" : "}");
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("ActivityRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" u");
        sb.append(this.userId);
        sb.append(' ');
        sb.append(this.intent.getComponent().flattenToShortString());
        this.stringName = sb.toString();
        return this.toString();
    }

    void writeIdentifierToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10500000001L, System.identityHashCode(this));
        proto.write(1120986464258L, this.userId);
        proto.write(1138166333443L, this.intent.getComponent().flattenToShortString());
        proto.end(token);
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, false);
        this.writeIdentifierToProto(proto, 1146756268034L);
        proto.write(1138166333443L, this.state.toString());
        proto.write(1133871366148L, this.visible);
        proto.write(1133871366149L, this.frontOfTask);
        if (this.app != null) {
            proto.write(1120986464262L, this.app.pid);
        }
        proto.end(token);
    }

    static class Token
    extends IApplicationToken.Stub {
        private final WeakReference<ActivityRecord> weakActivity;
        private final String name;

        Token(ActivityRecord activity, Intent intent) {
            this.weakActivity = new WeakReference<ActivityRecord>(activity);
            this.name = intent.getComponent().flattenToShortString();
        }

        private static ActivityRecord tokenToActivityRecordLocked(Token token) {
            if (token == null) {
                return null;
            }
            ActivityRecord r = (ActivityRecord)token.weakActivity.get();
            if (r == null || r.getStack() == null) {
                return null;
            }
            return r;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Token{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            sb.append(this.weakActivity.get());
            sb.append('}');
            return sb.toString();
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

