/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.IAppTask;
import android.app.IApplicationThread;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.UserHandle;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.TaskRecord;

class AppTaskImpl
extends IAppTask.Stub {
    private ActivityManagerService mService;
    private int mTaskId;
    private int mCallingUid;

    public AppTaskImpl(ActivityManagerService service, int taskId, int callingUid) {
        this.mService = service;
        this.mTaskId = taskId;
        this.mCallingUid = callingUid;
    }

    private void checkCaller() {
        if (this.mCallingUid != Binder.getCallingUid()) {
            throw new SecurityException("Caller " + this.mCallingUid + " does not match caller of getAppTasks(): " + Binder.getCallingUid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishAndRemoveTask() {
        this.checkCaller();
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                long origId = Binder.clearCallingIdentity();
                try {
                    if (!this.mService.mStackSupervisor.removeTaskByIdLocked(this.mTaskId, false, true, "finish-and-remove-task")) {
                        throw new IllegalArgumentException("Unable to find task ID " + this.mTaskId);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl17 : MonitorExitStatement: MONITOREXIT : var1_1
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * Exception decompiling
     */
    @Override
    public ActivityManager.RecentTaskInfo getTaskInfo() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToFront() {
        this.checkCaller();
        int callingPid = Binder.getCallingPid();
        int callingUid = Binder.getCallingUid();
        long origId = Binder.clearCallingIdentity();
        try {
            AppTaskImpl appTaskImpl = this;
            synchronized (appTaskImpl) {
                this.mService.mStackSupervisor.startActivityFromRecents(callingPid, callingUid, this.mTaskId, null);
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startActivity(IBinder whoThread, String callingPackage, Intent intent, String resolvedType, Bundle bOptions) {
        IApplicationThread appThread;
        TaskRecord tr;
        this.checkCaller();
        int callingUser = UserHandle.getCallingUserId();
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                tr = this.mService.mStackSupervisor.anyTaskForIdLocked(this.mTaskId, 1);
                if (tr == null) {
                    throw new IllegalArgumentException("Unable to find task ID " + this.mTaskId);
                }
                appThread = IApplicationThread.Stub.asInterface(whoThread);
                if (appThread == null) {
                    throw new IllegalArgumentException("Bad app thread " + appThread);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var7_7
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
        return this.mService.getActivityStartController().obtainStarter(intent, "AppTaskImpl").setCaller(appThread).setCallingPackage(callingPackage).setResolvedType(resolvedType).setActivityOptions(bOptions).setMayWait(callingUser).setInTask(tr).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExcludeFromRecents(boolean exclude) {
        this.checkCaller();
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                long origId = Binder.clearCallingIdentity();
                try {
                    TaskRecord tr = this.mService.mStackSupervisor.anyTaskForIdLocked(this.mTaskId, 1);
                    if (tr == null) {
                        throw new IllegalArgumentException("Unable to find task ID " + this.mTaskId);
                    }
                    Intent intent = tr.getBaseIntent();
                    if (exclude) {
                        intent.addFlags(0x800000);
                    } else {
                        intent.setFlags(intent.getFlags() & 0xFF7FFFFF);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl25 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }
}

