/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.WindowManager;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.BaseErrorDialog;
import com.android.server.am.ProcessRecord;

final class AppWaitingForDebuggerDialog
extends BaseErrorDialog {
    final ActivityManagerService mService;
    final ProcessRecord mProc;
    private CharSequence mAppName;
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AppWaitingForDebuggerDialog.this.mService.killAppAtUsersRequest(AppWaitingForDebuggerDialog.this.mProc, AppWaitingForDebuggerDialog.this);
                }
            }
        }
    };

    public AppWaitingForDebuggerDialog(ActivityManagerService service, Context context, ProcessRecord app) {
        super(context);
        this.mService = service;
        this.mProc = app;
        this.mAppName = context.getPackageManager().getApplicationLabel(app.info);
        this.setCancelable(false);
        StringBuilder text = new StringBuilder();
        if (this.mAppName != null && this.mAppName.length() > 0) {
            text.append("Application ");
            text.append(this.mAppName);
            text.append(" (process ");
            text.append(app.processName);
            text.append(")");
        } else {
            text.append("Process ");
            text.append(app.processName);
        }
        text.append(" is waiting for the debugger to attach.");
        this.setMessage(text.toString());
        this.setButton(-1, (CharSequence)"Force Close", this.mHandler.obtainMessage(1, app));
        this.setTitle("Waiting For Debugger");
        WindowManager.LayoutParams attrs = this.getWindow().getAttributes();
        attrs.setTitle("Waiting For Debugger: " + app.info.processName);
        this.getWindow().setAttributes(attrs);
    }

    @Override
    public void onStop() {
    }
}

