/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PermissionInfo;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.util.EventLog;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.BroadcastFilter;
import com.android.server.am.BroadcastRecord;
import com.android.server.am.ProcessRecord;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;

public final class BroadcastQueue {
    private static final String TAG = "BroadcastQueue";
    private static final String TAG_MU = "BroadcastQueue_MU";
    private static final String TAG_BROADCAST = "BroadcastQueue";
    static final int MAX_BROADCAST_HISTORY = ActivityManager.isLowRamDeviceStatic() ? 10 : 50;
    static final int MAX_BROADCAST_SUMMARY_HISTORY = ActivityManager.isLowRamDeviceStatic() ? 25 : 300;
    final ActivityManagerService mService;
    final String mQueueName;
    final long mTimeoutPeriod;
    final boolean mDelayBehindServices;
    final ArrayList<BroadcastRecord> mParallelBroadcasts = new ArrayList();
    final ArrayList<BroadcastRecord> mOrderedBroadcasts = new ArrayList();
    final BroadcastRecord[] mBroadcastHistory = new BroadcastRecord[MAX_BROADCAST_HISTORY];
    int mHistoryNext = 0;
    final Intent[] mBroadcastSummaryHistory = new Intent[MAX_BROADCAST_SUMMARY_HISTORY];
    int mSummaryHistoryNext = 0;
    final long[] mSummaryHistoryEnqueueTime = new long[MAX_BROADCAST_SUMMARY_HISTORY];
    final long[] mSummaryHistoryDispatchTime = new long[MAX_BROADCAST_SUMMARY_HISTORY];
    final long[] mSummaryHistoryFinishTime = new long[MAX_BROADCAST_SUMMARY_HISTORY];
    boolean mBroadcastsScheduled = false;
    boolean mPendingBroadcastTimeoutMessage;
    BroadcastRecord mPendingBroadcast = null;
    int mPendingBroadcastRecvIndex;
    static final int BROADCAST_INTENT_MSG = 200;
    static final int BROADCAST_TIMEOUT_MSG = 201;
    final BroadcastHandler mHandler;

    BroadcastQueue(ActivityManagerService service, Handler handler, String name, long timeoutPeriod, boolean allowDelayBehindServices) {
        this.mService = service;
        this.mHandler = new BroadcastHandler(handler.getLooper());
        this.mQueueName = name;
        this.mTimeoutPeriod = timeoutPeriod;
        this.mDelayBehindServices = allowDelayBehindServices;
    }

    public String toString() {
        return this.mQueueName;
    }

    public boolean isPendingBroadcastProcessLocked(int pid) {
        return this.mPendingBroadcast != null && this.mPendingBroadcast.curApp.pid == pid;
    }

    public void enqueueParallelBroadcastLocked(BroadcastRecord r) {
        this.mParallelBroadcasts.add(r);
        this.enqueueBroadcastHelper(r);
    }

    public void enqueueOrderedBroadcastLocked(BroadcastRecord r) {
        this.mOrderedBroadcasts.add(r);
        this.enqueueBroadcastHelper(r);
    }

    private void enqueueBroadcastHelper(BroadcastRecord r) {
        r.enqueueClockTime = System.currentTimeMillis();
        if (Trace.isTagEnabled(64L)) {
            Trace.asyncTraceBegin(64L, this.createBroadcastTraceTitle(r, 0), System.identityHashCode(r));
        }
    }

    public final BroadcastRecord replaceParallelBroadcastLocked(BroadcastRecord r) {
        return this.replaceBroadcastLocked(this.mParallelBroadcasts, r, "PARALLEL");
    }

    public final BroadcastRecord replaceOrderedBroadcastLocked(BroadcastRecord r) {
        return this.replaceBroadcastLocked(this.mOrderedBroadcasts, r, "ORDERED");
    }

    private BroadcastRecord replaceBroadcastLocked(ArrayList<BroadcastRecord> queue, BroadcastRecord r, String typeForLogging) {
        Intent intent = r.intent;
        for (int i = queue.size() - 1; i > 0; --i) {
            BroadcastRecord old = queue.get(i);
            if (old.userId != r.userId || !intent.filterEquals(old.intent)) continue;
            queue.set(i, r);
            return old;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processCurBroadcastLocked(BroadcastRecord r, ProcessRecord app) throws RemoteException {
        if (app.thread == null) {
            throw new RemoteException();
        }
        if (app.inFullBackup) {
            this.skipReceiverLocked(r);
            return;
        }
        r.receiver = app.thread.asBinder();
        r.curApp = app;
        app.curReceivers.add(r);
        app.forceProcessStateUpTo(10);
        this.mService.updateLruProcessLocked(app, false, null);
        this.mService.updateOomAdjLocked();
        r.intent.setComponent(r.curComponent);
        boolean started = false;
        try {
            this.mService.notifyPackageUse(r.intent.getComponent().getPackageName(), 3);
            app.thread.scheduleReceiver(new Intent(r.intent), r.curReceiver, this.mService.compatibilityInfoForPackageLocked(r.curReceiver.applicationInfo), r.resultCode, r.resultData, r.resultExtras, r.ordered, r.userId, app.repProcState);
            started = true;
        }
        finally {
            if (!started) {
                r.receiver = null;
                r.curApp = null;
                app.curReceivers.remove(r);
            }
        }
    }

    public boolean sendPendingBroadcastsLocked(ProcessRecord app) {
        boolean didSomething = false;
        BroadcastRecord br = this.mPendingBroadcast;
        if (br != null && br.curApp.pid > 0 && br.curApp.pid == app.pid) {
            if (br.curApp != app) {
                Slog.e("BroadcastQueue", "App mismatch when sending pending broadcast to " + app.processName + ", intended target is " + br.curApp.processName);
                return false;
            }
            try {
                this.mPendingBroadcast = null;
                this.processCurBroadcastLocked(br, app);
                didSomething = true;
            }
            catch (Exception e) {
                Slog.w("BroadcastQueue", "Exception in new application when starting receiver " + br.curComponent.flattenToShortString(), e);
                this.logBroadcastReceiverDiscardLocked(br);
                this.finishReceiverLocked(br, br.resultCode, br.resultData, br.resultExtras, br.resultAbort, false);
                this.scheduleBroadcastsLocked();
                br.state = 0;
                throw new RuntimeException(e.getMessage());
            }
        }
        return didSomething;
    }

    public void skipPendingBroadcastLocked(int pid) {
        BroadcastRecord br = this.mPendingBroadcast;
        if (br != null && br.curApp.pid == pid) {
            br.state = 0;
            br.nextReceiver = this.mPendingBroadcastRecvIndex;
            this.mPendingBroadcast = null;
            this.scheduleBroadcastsLocked();
        }
    }

    public void skipCurrentReceiverLocked(ProcessRecord app) {
        BroadcastRecord r = null;
        if (this.mOrderedBroadcasts.size() > 0) {
            BroadcastRecord br = this.mOrderedBroadcasts.get(0);
            if (br.curApp == app) {
                r = br;
            }
        }
        if (r == null && this.mPendingBroadcast != null && this.mPendingBroadcast.curApp == app) {
            r = this.mPendingBroadcast;
        }
        if (r != null) {
            this.skipReceiverLocked(r);
        }
    }

    private void skipReceiverLocked(BroadcastRecord r) {
        this.logBroadcastReceiverDiscardLocked(r);
        this.finishReceiverLocked(r, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, false);
        this.scheduleBroadcastsLocked();
    }

    public void scheduleBroadcastsLocked() {
        if (this.mBroadcastsScheduled) {
            return;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(200, this));
        this.mBroadcastsScheduled = true;
    }

    public BroadcastRecord getMatchingOrderedReceiver(IBinder receiver) {
        BroadcastRecord r;
        if (this.mOrderedBroadcasts.size() > 0 && (r = this.mOrderedBroadcasts.get(0)) != null && r.receiver == receiver) {
            return r;
        }
        return null;
    }

    public boolean finishReceiverLocked(BroadcastRecord r, int resultCode, String resultData, Bundle resultExtras, boolean resultAbort, boolean waitForServices) {
        int state = r.state;
        ActivityInfo receiver = r.curReceiver;
        r.state = 0;
        if (state == 0) {
            Slog.w("BroadcastQueue", "finishReceiver [" + this.mQueueName + "] called but state is IDLE");
        }
        r.receiver = null;
        r.intent.setComponent(null);
        if (r.curApp != null && r.curApp.curReceivers.contains(r)) {
            r.curApp.curReceivers.remove(r);
        }
        if (r.curFilter != null) {
            r.curFilter.receiverList.curBroadcast = null;
        }
        r.curFilter = null;
        r.curReceiver = null;
        r.curApp = null;
        this.mPendingBroadcast = null;
        r.resultCode = resultCode;
        r.resultData = resultData;
        r.resultExtras = resultExtras;
        r.resultAbort = resultAbort && (r.intent.getFlags() & 0x8000000) == 0 ? resultAbort : false;
        if (waitForServices && r.curComponent != null && r.queue.mDelayBehindServices && r.queue.mOrderedBroadcasts.size() > 0 && r.queue.mOrderedBroadcasts.get(0) == r) {
            Object obj;
            ActivityInfo nextReceiver = r.nextReceiver < r.receivers.size() ? ((obj = r.receivers.get(r.nextReceiver)) instanceof ActivityInfo ? (ActivityInfo)obj : null) : null;
            if ((receiver == null || nextReceiver == null || receiver.applicationInfo.uid != nextReceiver.applicationInfo.uid || !receiver.processName.equals(nextReceiver.processName)) && this.mService.mServices.hasBackgroundServicesLocked(r.userId)) {
                Slog.i("BroadcastQueue", "Delay finish: " + r.curComponent.flattenToShortString());
                r.state = 4;
                return false;
            }
        }
        r.curComponent = null;
        return state == 1 || state == 3;
    }

    public void backgroundServicesFinishedLocked(int userId) {
        if (this.mOrderedBroadcasts.size() > 0) {
            BroadcastRecord br = this.mOrderedBroadcasts.get(0);
            if (br.userId == userId && br.state == 4) {
                Slog.i("BroadcastQueue", "Resuming delayed broadcast");
                br.curComponent = null;
                br.state = 0;
                this.processNextBroadcast(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performReceiveLocked(ProcessRecord app, IIntentReceiver receiver, Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
        block5: {
            block6: {
                if (app == null) break block5;
                if (app.thread == null) break block6;
                try {
                    app.thread.scheduleRegisteredReceiver(receiver, intent, resultCode, data, extras, ordered, sticky, sendingUser, app.repProcState);
                }
                catch (RemoteException ex) {
                    ActivityManagerService activityManagerService = this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            Slog.w("BroadcastQueue", "Can't deliver broadcast to " + app.processName + " (pid " + app.pid + "). Crashing it.");
                            app.scheduleCrash("can't deliver broadcast");
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[2, 3, 4] lbl17 : MonitorExitStatement: MONITOREXIT : var11_11
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw ex;
                }
            }
            throw new RemoteException("app.thread must not be null");
        }
        receiver.performReceive(intent, resultCode, data, extras, ordered, sticky, sendingUser);
    }

    private void deliverToRegisteredReceiverLocked(BroadcastRecord r, BroadcastFilter filter, boolean ordered, int index) {
        block23: {
            boolean visibleToInstantApps;
            int perm;
            boolean skip = false;
            if (filter.requiredPermission != null) {
                perm = this.mService.checkComponentPermission(filter.requiredPermission, r.callingPid, r.callingUid, -1, true);
                if (perm != 0) {
                    Slog.w("BroadcastQueue", "Permission Denial: broadcasting " + r.intent.toString() + " from " + r.callerPackage + " (pid=" + r.callingPid + ", uid=" + r.callingUid + ") requires " + filter.requiredPermission + " due to registered receiver " + filter);
                    skip = true;
                } else {
                    int opCode = AppOpsManager.permissionToOpCode(filter.requiredPermission);
                    if (opCode != -1 && this.mService.mAppOpsService.noteOperation(opCode, r.callingUid, r.callerPackage) != 0) {
                        Slog.w("BroadcastQueue", "Appop Denial: broadcasting " + r.intent.toString() + " from " + r.callerPackage + " (pid=" + r.callingPid + ", uid=" + r.callingUid + ") requires appop " + AppOpsManager.permissionToOp(filter.requiredPermission) + " due to registered receiver " + filter);
                        skip = true;
                    }
                }
            }
            if (!skip && r.requiredPermissions != null && r.requiredPermissions.length > 0) {
                for (int i = 0; i < r.requiredPermissions.length; ++i) {
                    String requiredPermission = r.requiredPermissions[i];
                    int perm2 = this.mService.checkComponentPermission(requiredPermission, filter.receiverList.pid, filter.receiverList.uid, -1, true);
                    if (perm2 != 0) {
                        Slog.w("BroadcastQueue", "Permission Denial: receiving " + r.intent.toString() + " to " + filter.receiverList.app + " (pid=" + filter.receiverList.pid + ", uid=" + filter.receiverList.uid + ") requires " + requiredPermission + " due to sender " + r.callerPackage + " (uid " + r.callingUid + ")");
                        skip = true;
                        break;
                    }
                    int appOp = AppOpsManager.permissionToOpCode(requiredPermission);
                    if (appOp == -1 || appOp == r.appOp || this.mService.mAppOpsService.noteOperation(appOp, filter.receiverList.uid, filter.packageName) == 0) continue;
                    Slog.w("BroadcastQueue", "Appop Denial: receiving " + r.intent.toString() + " to " + filter.receiverList.app + " (pid=" + filter.receiverList.pid + ", uid=" + filter.receiverList.uid + ") requires appop " + AppOpsManager.permissionToOp(requiredPermission) + " due to sender " + r.callerPackage + " (uid " + r.callingUid + ")");
                    skip = true;
                    break;
                }
            }
            if (!(skip || r.requiredPermissions != null && r.requiredPermissions.length != 0 || (perm = this.mService.checkComponentPermission(null, filter.receiverList.pid, filter.receiverList.uid, -1, true)) == 0)) {
                Slog.w("BroadcastQueue", "Permission Denial: security check failed when receiving " + r.intent.toString() + " to " + filter.receiverList.app + " (pid=" + filter.receiverList.pid + ", uid=" + filter.receiverList.uid + ") due to sender " + r.callerPackage + " (uid " + r.callingUid + ")");
                skip = true;
            }
            if (!skip && r.appOp != -1 && this.mService.mAppOpsService.noteOperation(r.appOp, filter.receiverList.uid, filter.packageName) != 0) {
                Slog.w("BroadcastQueue", "Appop Denial: receiving " + r.intent.toString() + " to " + filter.receiverList.app + " (pid=" + filter.receiverList.pid + ", uid=" + filter.receiverList.uid + ") requires appop " + AppOpsManager.opToName(r.appOp) + " due to sender " + r.callerPackage + " (uid " + r.callingUid + ")");
                skip = true;
            }
            if (!this.mService.mIntentFirewall.checkBroadcast(r.intent, r.callingUid, r.callingPid, r.resolvedType, filter.receiverList.uid)) {
                skip = true;
            }
            if (!skip && (filter.receiverList.app == null || filter.receiverList.app.killed || filter.receiverList.app.crashing)) {
                Slog.w("BroadcastQueue", "Skipping deliver [" + this.mQueueName + "] " + r + " to " + filter.receiverList + ": process gone or crashing");
                skip = true;
            }
            boolean bl = visibleToInstantApps = (r.intent.getFlags() & 0x200000) != 0;
            if (!skip && !visibleToInstantApps && filter.instantApp && filter.receiverList.uid != r.callingUid) {
                Slog.w("BroadcastQueue", "Instant App Denial: receiving " + r.intent.toString() + " to " + filter.receiverList.app + " (pid=" + filter.receiverList.pid + ", uid=" + filter.receiverList.uid + ") due to sender " + r.callerPackage + " (uid " + r.callingUid + ") not specifying FLAG_RECEIVER_VISIBLE_TO_INSTANT_APPS");
                skip = true;
            }
            if (!skip && !filter.visibleToInstantApp && r.callerInstantApp && filter.receiverList.uid != r.callingUid) {
                Slog.w("BroadcastQueue", "Instant App Denial: receiving " + r.intent.toString() + " to " + filter.receiverList.app + " (pid=" + filter.receiverList.pid + ", uid=" + filter.receiverList.uid + ") requires receiver be visible to instant apps due to sender " + r.callerPackage + " (uid " + r.callingUid + ")");
                skip = true;
            }
            if (skip) {
                r.delivery[index] = 2;
                return;
            }
            if (this.mService.mPermissionReviewRequired && !this.requestStartTargetPermissionsReviewIfNeededLocked(r, filter.packageName, filter.owningUserId)) {
                r.delivery[index] = 2;
                return;
            }
            r.delivery[index] = 1;
            if (ordered) {
                r.receiver = filter.receiverList.receiver.asBinder();
                r.curFilter = filter;
                filter.receiverList.curBroadcast = r;
                r.state = 2;
                if (filter.receiverList.app != null) {
                    r.curApp = filter.receiverList.app;
                    filter.receiverList.app.curReceivers.add(r);
                    this.mService.updateOomAdjLocked(r.curApp, true);
                }
            }
            try {
                if (filter.receiverList.app != null && filter.receiverList.app.inFullBackup) {
                    if (ordered) {
                        this.skipReceiverLocked(r);
                    }
                } else {
                    this.performReceiveLocked(filter.receiverList.app, filter.receiverList.receiver, new Intent(r.intent), r.resultCode, r.resultData, r.resultExtras, r.ordered, r.initialSticky, r.userId);
                }
                if (ordered) {
                    r.state = 3;
                }
            }
            catch (RemoteException e) {
                Slog.w("BroadcastQueue", "Failure sending broadcast " + r.intent, e);
                if (!ordered) break block23;
                r.receiver = null;
                r.curFilter = null;
                filter.receiverList.curBroadcast = null;
                if (filter.receiverList.app == null) break block23;
                filter.receiverList.app.curReceivers.remove(r);
            }
        }
    }

    private boolean requestStartTargetPermissionsReviewIfNeededLocked(BroadcastRecord receiverRecord, String receivingPackageName, final int receivingUserId) {
        boolean callerForeground;
        if (!this.mService.getPackageManagerInternalLocked().isPermissionsReviewRequired(receivingPackageName, receivingUserId)) {
            return true;
        }
        boolean bl = receiverRecord.callerApp != null ? receiverRecord.callerApp.setSchedGroup != 0 : (callerForeground = true);
        if (callerForeground && receiverRecord.intent.getComponent() != null) {
            IIntentSender target = this.mService.getIntentSenderLocked(1, receiverRecord.callerPackage, receiverRecord.callingUid, receiverRecord.userId, null, null, 0, new Intent[]{receiverRecord.intent}, new String[]{receiverRecord.intent.resolveType(this.mService.mContext.getContentResolver())}, 0x54000000, null);
            final Intent intent = new Intent("android.intent.action.REVIEW_PERMISSIONS");
            intent.addFlags(0x10800000);
            intent.putExtra("android.intent.extra.PACKAGE_NAME", receivingPackageName);
            intent.putExtra("android.intent.extra.INTENT", new IntentSender(target));
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    BroadcastQueue.this.mService.mContext.startActivityAsUser(intent, new UserHandle(receivingUserId));
                }
            });
        } else {
            Slog.w("BroadcastQueue", "u" + receivingUserId + " Receiving a broadcast in package" + receivingPackageName + " requires a permissions review");
        }
        return false;
    }

    final void scheduleTempWhitelistLocked(int uid, long duration, BroadcastRecord r) {
        if (duration > Integer.MAX_VALUE) {
            duration = Integer.MAX_VALUE;
        }
        StringBuilder b = new StringBuilder();
        b.append("broadcast:");
        UserHandle.formatUid(b, r.callingUid);
        b.append(":");
        if (r.intent.getAction() != null) {
            b.append(r.intent.getAction());
        } else if (r.intent.getComponent() != null) {
            r.intent.getComponent().appendShortString(b);
        } else if (r.intent.getData() != null) {
            b.append(r.intent.getData());
        }
        this.mService.tempWhitelistUidLocked(uid, duration, b.toString());
    }

    final boolean isSignaturePerm(String[] perms) {
        if (perms == null) {
            return false;
        }
        IPackageManager pm = AppGlobals.getPackageManager();
        for (int i = perms.length - 1; i >= 0; --i) {
            try {
                PermissionInfo pi = pm.getPermissionInfo(perms[i], "android", 0);
                if ((pi.protectionLevel & 0x1F) == 2) continue;
                return false;
            }
            catch (RemoteException e) {
                return false;
            }
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    final void processNextBroadcast(boolean fromMsg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 30[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final void setBroadcastTimeoutLocked(long timeoutTime) {
        if (!this.mPendingBroadcastTimeoutMessage) {
            Message msg = this.mHandler.obtainMessage(201, this);
            this.mHandler.sendMessageAtTime(msg, timeoutTime);
            this.mPendingBroadcastTimeoutMessage = true;
        }
    }

    final void cancelBroadcastTimeoutLocked() {
        if (this.mPendingBroadcastTimeoutMessage) {
            this.mHandler.removeMessages(201, this);
            this.mPendingBroadcastTimeoutMessage = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void broadcastTimeoutLocked(boolean fromMsg) {
        ActivityInfo curReceiver;
        if (fromMsg) {
            this.mPendingBroadcastTimeoutMessage = false;
        }
        if (this.mOrderedBroadcasts.size() == 0) {
            return;
        }
        long now = SystemClock.uptimeMillis();
        BroadcastRecord r = this.mOrderedBroadcasts.get(0);
        if (fromMsg) {
            if (!this.mService.mProcessesReady) {
                return;
            }
            long timeoutTime = r.receiverTime + this.mTimeoutPeriod;
            if (timeoutTime > now) {
                this.setBroadcastTimeoutLocked(timeoutTime);
                return;
            }
        }
        BroadcastRecord br = this.mOrderedBroadcasts.get(0);
        if (br.state == 4) {
            Slog.i("BroadcastQueue", "Waited long enough for: " + (br.curComponent != null ? br.curComponent.flattenToShortString() : "(null)"));
            br.curComponent = null;
            br.state = 0;
            this.processNextBroadcast(false);
            return;
        }
        Slog.w("BroadcastQueue", "Timeout of broadcast " + r + " - receiver=" + r.receiver + ", started " + (now - r.receiverTime) + "ms ago");
        r.receiverTime = now;
        ++r.anrCount;
        ProcessRecord app = null;
        String anrMessage = null;
        if (r.nextReceiver > 0) {
            curReceiver = r.receivers.get(r.nextReceiver - 1);
            r.delivery[r.nextReceiver - 1] = 3;
        } else {
            curReceiver = r.curReceiver;
        }
        Slog.w("BroadcastQueue", "Receiver during timeout of " + r + " : " + curReceiver);
        this.logBroadcastReceiverDiscardLocked(r);
        if (curReceiver != null && curReceiver instanceof BroadcastFilter) {
            BroadcastFilter bf = (BroadcastFilter)((Object)curReceiver);
            if (bf.receiverList.pid != 0 && bf.receiverList.pid != ActivityManagerService.MY_PID) {
                SparseArray<ProcessRecord> sparseArray = this.mService.mPidsSelfLocked;
                synchronized (sparseArray) {
                    app = this.mService.mPidsSelfLocked.get(bf.receiverList.pid);
                }
            }
        } else {
            app = r.curApp;
        }
        if (app != null) {
            anrMessage = "Broadcast of " + r.intent.toString();
        }
        if (this.mPendingBroadcast == r) {
            this.mPendingBroadcast = null;
        }
        this.finishReceiverLocked(r, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, false);
        this.scheduleBroadcastsLocked();
        if (anrMessage != null) {
            this.mHandler.post(new AppNotResponding(app, anrMessage));
        }
    }

    private final int ringAdvance(int x, int increment, int ringSize) {
        if ((x += increment) < 0) {
            return ringSize - 1;
        }
        if (x >= ringSize) {
            return 0;
        }
        return x;
    }

    private final void addBroadcastToHistoryLocked(BroadcastRecord original) {
        BroadcastRecord historyRecord;
        if (original.callingUid < 0) {
            return;
        }
        original.finishTime = SystemClock.uptimeMillis();
        if (Trace.isTagEnabled(64L)) {
            Trace.asyncTraceEnd(64L, this.createBroadcastTraceTitle(original, 1), System.identityHashCode(original));
        }
        this.mBroadcastHistory[this.mHistoryNext] = historyRecord = original.maybeStripForHistory();
        this.mHistoryNext = this.ringAdvance(this.mHistoryNext, 1, MAX_BROADCAST_HISTORY);
        this.mBroadcastSummaryHistory[this.mSummaryHistoryNext] = historyRecord.intent;
        this.mSummaryHistoryEnqueueTime[this.mSummaryHistoryNext] = historyRecord.enqueueClockTime;
        this.mSummaryHistoryDispatchTime[this.mSummaryHistoryNext] = historyRecord.dispatchClockTime;
        this.mSummaryHistoryFinishTime[this.mSummaryHistoryNext] = System.currentTimeMillis();
        this.mSummaryHistoryNext = this.ringAdvance(this.mSummaryHistoryNext, 1, MAX_BROADCAST_SUMMARY_HISTORY);
    }

    boolean cleanupDisabledPackageReceiversLocked(String packageName, Set<String> filterByClasses, int userId, boolean doit) {
        int i;
        boolean didSomething = false;
        for (i = this.mParallelBroadcasts.size() - 1; i >= 0; --i) {
            if (doit || !(didSomething |= this.mParallelBroadcasts.get(i).cleanupDisabledPackageReceiversLocked(packageName, filterByClasses, userId, doit))) continue;
            return true;
        }
        for (i = this.mOrderedBroadcasts.size() - 1; i >= 0; --i) {
            if (doit || !(didSomething |= this.mOrderedBroadcasts.get(i).cleanupDisabledPackageReceiversLocked(packageName, filterByClasses, userId, doit))) continue;
            return true;
        }
        return didSomething;
    }

    final void logBroadcastReceiverDiscardLocked(BroadcastRecord r) {
        int logIndex = r.nextReceiver - 1;
        if (logIndex >= 0 && logIndex < r.receivers.size()) {
            Object curReceiver = r.receivers.get(logIndex);
            if (curReceiver instanceof BroadcastFilter) {
                BroadcastFilter bf = (BroadcastFilter)curReceiver;
                EventLog.writeEvent(30024, bf.owningUserId, System.identityHashCode(r), r.intent.getAction(), logIndex, System.identityHashCode(bf));
            } else {
                ResolveInfo ri = (ResolveInfo)curReceiver;
                EventLog.writeEvent(30025, UserHandle.getUserId(ri.activityInfo.applicationInfo.uid), System.identityHashCode(r), r.intent.getAction(), logIndex, ri.toString());
            }
        } else {
            if (logIndex < 0) {
                Slog.w("BroadcastQueue", "Discarding broadcast before first receiver is invoked: " + r);
            }
            EventLog.writeEvent(30025, -1, System.identityHashCode(r), r.intent.getAction(), r.nextReceiver, "NONE");
        }
    }

    private String createBroadcastTraceTitle(BroadcastRecord record, int state) {
        return String.format("Broadcast %s from %s (%s) %s", state == 0 ? "in queue" : "dispatched", record.callerPackage == null ? "" : record.callerPackage, record.callerApp == null ? "process unknown" : record.callerApp.toShortString(), record.intent == null ? "" : record.intent.getAction());
    }

    final boolean isIdle() {
        return this.mParallelBroadcasts.isEmpty() && this.mOrderedBroadcasts.isEmpty() && this.mPendingBroadcast == null;
    }

    void writeToProto(ProtoOutputStream proto, long fieldId) {
        int lastIndex;
        int i;
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, this.mQueueName);
        int N = this.mParallelBroadcasts.size();
        for (i = N - 1; i >= 0; --i) {
            this.mParallelBroadcasts.get(i).writeToProto(proto, 0x20B00000002L);
        }
        N = this.mOrderedBroadcasts.size();
        for (i = N - 1; i >= 0; --i) {
            this.mOrderedBroadcasts.get(i).writeToProto(proto, 2246267895811L);
        }
        if (this.mPendingBroadcast != null) {
            this.mPendingBroadcast.writeToProto(proto, 1146756268036L);
        }
        int ringIndex = lastIndex = this.mHistoryNext;
        do {
            BroadcastRecord r;
            if ((r = this.mBroadcastHistory[ringIndex = this.ringAdvance(ringIndex, -1, MAX_BROADCAST_HISTORY)]) == null) continue;
            r.writeToProto(proto, 2246267895813L);
        } while (ringIndex != lastIndex);
        lastIndex = ringIndex = this.mSummaryHistoryNext;
        do {
            Intent intent;
            if ((intent = this.mBroadcastSummaryHistory[ringIndex = this.ringAdvance(ringIndex, -1, MAX_BROADCAST_SUMMARY_HISTORY)]) == null) continue;
            long summaryToken = proto.start(2246267895814L);
            intent.writeToProto(proto, 0x10B00000001L, false, true, true, false);
            proto.write(1112396529666L, this.mSummaryHistoryEnqueueTime[ringIndex]);
            proto.write(0x10300000003L, this.mSummaryHistoryDispatchTime[ringIndex]);
            proto.write(1112396529668L, this.mSummaryHistoryFinishTime[ringIndex]);
            proto.end(summaryToken);
        } while (ringIndex != lastIndex);
        proto.end(token);
    }

    final boolean dumpLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage, boolean needSep) {
        Bundle bundle;
        int lastIndex;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.mParallelBroadcasts.size() > 0 || this.mOrderedBroadcasts.size() > 0 || this.mPendingBroadcast != null) {
            BroadcastRecord br;
            int i;
            boolean printed = false;
            for (i = this.mParallelBroadcasts.size() - 1; i >= 0; --i) {
                br = this.mParallelBroadcasts.get(i);
                if (dumpPackage != null && !dumpPackage.equals(br.callerPackage)) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    printed = true;
                    pw.println("  Active broadcasts [" + this.mQueueName + "]:");
                }
                pw.println("  Active Broadcast " + this.mQueueName + " #" + i + ":");
                br.dump(pw, "    ", sdf);
            }
            printed = false;
            needSep = true;
            for (i = this.mOrderedBroadcasts.size() - 1; i >= 0; --i) {
                br = this.mOrderedBroadcasts.get(i);
                if (dumpPackage != null && !dumpPackage.equals(br.callerPackage)) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    printed = true;
                    pw.println("  Active ordered broadcasts [" + this.mQueueName + "]:");
                }
                pw.println("  Active Ordered Broadcast " + this.mQueueName + " #" + i + ":");
                this.mOrderedBroadcasts.get(i).dump(pw, "    ", sdf);
            }
            if (dumpPackage == null || this.mPendingBroadcast != null && dumpPackage.equals(this.mPendingBroadcast.callerPackage)) {
                if (needSep) {
                    pw.println();
                }
                pw.println("  Pending broadcast [" + this.mQueueName + "]:");
                if (this.mPendingBroadcast != null) {
                    this.mPendingBroadcast.dump(pw, "    ", sdf);
                } else {
                    pw.println("    (null)");
                }
                needSep = true;
            }
        }
        boolean printed = false;
        int i = -1;
        int ringIndex = lastIndex = this.mHistoryNext;
        do {
            BroadcastRecord r;
            if ((r = this.mBroadcastHistory[ringIndex = this.ringAdvance(ringIndex, -1, MAX_BROADCAST_HISTORY)]) == null) continue;
            ++i;
            if (dumpPackage != null && !dumpPackage.equals(r.callerPackage)) continue;
            if (!printed) {
                if (needSep) {
                    pw.println();
                }
                needSep = true;
                pw.println("  Historical broadcasts [" + this.mQueueName + "]:");
                printed = true;
            }
            if (dumpAll) {
                pw.print("  Historical Broadcast " + this.mQueueName + " #");
                pw.print(i);
                pw.println(":");
                r.dump(pw, "    ", sdf);
                continue;
            }
            pw.print("  #");
            pw.print(i);
            pw.print(": ");
            pw.println(r);
            pw.print("    ");
            pw.println(r.intent.toShortString(false, true, true, false));
            if (r.targetComp != null && r.targetComp != r.intent.getComponent()) {
                pw.print("    targetComp: ");
                pw.println(r.targetComp.toShortString());
            }
            if ((bundle = r.intent.getExtras()) == null) continue;
            pw.print("    extras: ");
            pw.println(bundle.toString());
        } while (ringIndex != lastIndex);
        if (dumpPackage == null) {
            lastIndex = ringIndex = this.mSummaryHistoryNext;
            if (dumpAll) {
                printed = false;
                i = -1;
            } else {
                int j = i;
                while (j > 0 && ringIndex != lastIndex) {
                    BroadcastRecord r = this.mBroadcastHistory[ringIndex = this.ringAdvance(ringIndex, -1, MAX_BROADCAST_SUMMARY_HISTORY)];
                    if (r == null) continue;
                    --j;
                }
            }
            do {
                Intent intent;
                if ((intent = this.mBroadcastSummaryHistory[ringIndex = this.ringAdvance(ringIndex, -1, MAX_BROADCAST_SUMMARY_HISTORY)]) == null) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    pw.println("  Historical broadcasts summary [" + this.mQueueName + "]:");
                    printed = true;
                }
                if (!dumpAll && i >= 50) {
                    pw.println("  ...");
                    break;
                }
                pw.print("  #");
                pw.print(++i);
                pw.print(": ");
                pw.println(intent.toShortString(false, true, true, false));
                pw.print("    ");
                TimeUtils.formatDuration(this.mSummaryHistoryDispatchTime[ringIndex] - this.mSummaryHistoryEnqueueTime[ringIndex], pw);
                pw.print(" dispatch ");
                TimeUtils.formatDuration(this.mSummaryHistoryFinishTime[ringIndex] - this.mSummaryHistoryDispatchTime[ringIndex], pw);
                pw.println(" finish");
                pw.print("    enq=");
                pw.print(sdf.format(new Date(this.mSummaryHistoryEnqueueTime[ringIndex])));
                pw.print(" disp=");
                pw.print(sdf.format(new Date(this.mSummaryHistoryDispatchTime[ringIndex])));
                pw.print(" fin=");
                pw.println(sdf.format(new Date(this.mSummaryHistoryFinishTime[ringIndex])));
                bundle = intent.getExtras();
                if (bundle == null) continue;
                pw.print("    extras: ");
                pw.println(bundle.toString());
            } while (ringIndex != lastIndex);
        }
        return needSep;
    }

    private final class AppNotResponding
    implements Runnable {
        private final ProcessRecord mApp;
        private final String mAnnotation;

        public AppNotResponding(ProcessRecord app, String annotation) {
            this.mApp = app;
            this.mAnnotation = annotation;
        }

        @Override
        public void run() {
            BroadcastQueue.this.mService.mAppErrors.appNotResponding(this.mApp, null, null, false, this.mAnnotation);
        }
    }

    private final class BroadcastHandler
    extends Handler {
        public BroadcastHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 200: {
                    BroadcastQueue.this.processNextBroadcast(true);
                    return;
                }
                case 201: {
                    ActivityManagerService activityManagerService = BroadcastQueue.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            BroadcastQueue.this.broadcastTimeoutLocked(true);
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[1, 2, 4, 6] lbl14 : MonitorExitStatement: MONITOREXIT : activityManagerService
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
            }
        }
    }
}

