/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.Intent;
import android.os.IBinder;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.proto.ProtoOutputStream;
import com.android.server.am.AppBindRecord;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.ServiceRecord;
import java.io.PrintWriter;

final class IntentBindRecord {
    final ServiceRecord service;
    final Intent.FilterComparison intent;
    final ArrayMap<ProcessRecord, AppBindRecord> apps = new ArrayMap();
    IBinder binder;
    boolean requested;
    boolean received;
    boolean hasBound;
    boolean doRebind;
    String stringName;

    void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("service=");
        pw.println(this.service);
        this.dumpInService(pw, prefix);
    }

    void dumpInService(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("intent={");
        pw.print(this.intent.getIntent().toShortString(false, true, false, false));
        pw.println('}');
        pw.print(prefix);
        pw.print("binder=");
        pw.println(this.binder);
        pw.print(prefix);
        pw.print("requested=");
        pw.print(this.requested);
        pw.print(" received=");
        pw.print(this.received);
        pw.print(" hasBound=");
        pw.print(this.hasBound);
        pw.print(" doRebind=");
        pw.println(this.doRebind);
        for (int i = 0; i < this.apps.size(); ++i) {
            AppBindRecord a = this.apps.valueAt(i);
            pw.print(prefix);
            pw.print("* Client AppBindRecord{");
            pw.print(Integer.toHexString(System.identityHashCode(a)));
            pw.print(' ');
            pw.print(a.client);
            pw.println('}');
            a.dumpInIntentBind(pw, prefix + "  ");
        }
    }

    IntentBindRecord(ServiceRecord _service, Intent.FilterComparison _intent) {
        this.service = _service;
        this.intent = _intent;
    }

    int collectFlags() {
        int flags = 0;
        for (int i = this.apps.size() - 1; i >= 0; --i) {
            ArraySet<ConnectionRecord> connections = this.apps.valueAt((int)i).connections;
            for (int j = connections.size() - 1; j >= 0; --j) {
                flags |= connections.valueAt((int)j).flags;
            }
        }
        return flags;
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("IntentBindRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        if ((this.collectFlags() & 1) != 0) {
            sb.append("CR ");
        }
        sb.append(this.service.shortName);
        sb.append(':');
        if (this.intent != null) {
            this.intent.getIntent().toShortString(sb, false, false, false, false);
        }
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, Integer.toHexString(System.identityHashCode(this)));
        proto.write(1133871366146L, (this.collectFlags() & 1) != 0);
        if (this.intent != null) {
            this.intent.getIntent().writeToProto(proto, 1146756268035L, false, true, false, false);
        }
        if (this.binder != null) {
            proto.write(1138166333444L, this.binder.toString());
        }
        proto.write(1133871366149L, this.requested);
        proto.write(1133871366150L, this.received);
        proto.write(1133871366151L, this.hasBound);
        proto.write(0x10800000008L, this.doRebind);
        int N = this.apps.size();
        for (int i = 0; i < N; ++i) {
            AppBindRecord a = this.apps.valueAt(i);
            if (a == null) continue;
            a.writeToProto(proto, 2246267895817L);
        }
        proto.end(token);
    }
}

