/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.RemoteAction;
import android.content.res.Configuration;
import android.graphics.Rect;
import com.android.server.am.ActivityDisplay;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.TaskRecord;
import com.android.server.wm.PinnedStackWindowController;
import com.android.server.wm.PinnedStackWindowListener;
import java.util.ArrayList;
import java.util.List;

class PinnedActivityStack
extends ActivityStack<PinnedStackWindowController>
implements PinnedStackWindowListener {
    PinnedActivityStack(ActivityDisplay display, int stackId, ActivityStackSupervisor supervisor, boolean onTop) {
        super(display, stackId, supervisor, 2, 1, onTop);
    }

    @Override
    PinnedStackWindowController createStackWindowController(int displayId, boolean onTop, Rect outBounds) {
        return new PinnedStackWindowController(this.mStackId, this, displayId, onTop, outBounds, this.mStackSupervisor.mWindowManager);
    }

    Rect getDefaultPictureInPictureBounds(float aspectRatio) {
        return ((PinnedStackWindowController)this.getWindowContainerController()).getPictureInPictureBounds(aspectRatio, null);
    }

    void animateResizePinnedStack(Rect sourceHintBounds, Rect toBounds, int animationDuration, boolean fromFullscreen) {
        if (this.skipResizeAnimation(toBounds == null)) {
            this.mService.moveTasksToFullscreenStack(this.mStackId, true);
        } else {
            ((PinnedStackWindowController)this.getWindowContainerController()).animateResizePinnedStack(toBounds, sourceHintBounds, animationDuration, fromFullscreen);
        }
    }

    private boolean skipResizeAnimation(boolean toFullscreen) {
        if (!toFullscreen) {
            return false;
        }
        Configuration parentConfig = this.getParent().getConfiguration();
        ActivityRecord top = this.topRunningNonOverlayTaskActivity();
        return top != null && !top.isConfigurationCompatible(parentConfig);
    }

    void setPictureInPictureAspectRatio(float aspectRatio) {
        ((PinnedStackWindowController)this.getWindowContainerController()).setPictureInPictureAspectRatio(aspectRatio);
    }

    void setPictureInPictureActions(List<RemoteAction> actions) {
        ((PinnedStackWindowController)this.getWindowContainerController()).setPictureInPictureActions(actions);
    }

    boolean isAnimatingBoundsToFullscreen() {
        return ((PinnedStackWindowController)this.getWindowContainerController()).isAnimatingBoundsToFullscreen();
    }

    @Override
    boolean deferScheduleMultiWindowModeChanged() {
        return ((PinnedStackWindowController)this.mWindowContainerController).deferScheduleMultiWindowModeChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePictureInPictureModeForPinnedStackAnimation(Rect targetStackBounds, boolean forceUpdate) {
        PinnedActivityStack pinnedActivityStack = this;
        synchronized (pinnedActivityStack) {
            ArrayList<TaskRecord> tasks = this.getAllTasks();
            for (int i = 0; i < tasks.size(); ++i) {
                this.mStackSupervisor.updatePictureInPictureMode(tasks.get(i), targetStackBounds, forceUpdate);
            }
        }
    }
}

