/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityOptions;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Handler;
import android.view.IRecentsAnimationRunner;
import com.android.server.am.ActivityDisplay;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.ActivityStartController;
import com.android.server.am.SafeActivityOptions;
import com.android.server.am.UserController;
import com.android.server.wm.RecentsAnimationController;
import com.android.server.wm.WindowManagerService;

class RecentsAnimation
implements RecentsAnimationController.RecentsAnimationCallbacks {
    private static final String TAG = RecentsAnimation.class.getSimpleName();
    private static final int RECENTS_ANIMATION_TIMEOUT = 10000;
    private final ActivityManagerService mService;
    private final ActivityStackSupervisor mStackSupervisor;
    private final ActivityStartController mActivityStartController;
    private final WindowManagerService mWindowManager;
    private final UserController mUserController;
    private final Handler mHandler;
    private final Runnable mCancelAnimationRunnable;
    private ActivityStack mRestoreHomeBehindStack;

    RecentsAnimation(ActivityManagerService am, ActivityStackSupervisor stackSupervisor, ActivityStartController activityStartController, WindowManagerService wm, UserController userController) {
        this.mService = am;
        this.mStackSupervisor = stackSupervisor;
        this.mActivityStartController = activityStartController;
        this.mHandler = new Handler(this.mStackSupervisor.mLooper);
        this.mWindowManager = wm;
        this.mUserController = userController;
        this.mCancelAnimationRunnable = () -> this.mWindowManager.cancelRecentsAnimation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startRecentsActivity(Intent intent, IRecentsAnimationRunner recentsAnimationRunner, ComponentName recentsComponent, int recentsUid) {
        this.mWindowManager.deferSurfaceLayout();
        try {
            boolean hasExistingHomeActivity;
            this.mWindowManager.cancelRecentsAnimation();
            boolean bl = hasExistingHomeActivity = this.mStackSupervisor.getHomeActivity() != null;
            if (!hasExistingHomeActivity) {
                ActivityOptions opts = ActivityOptions.makeBasic();
                opts.setLaunchActivityType(2);
                opts.setAvoidMoveToFront();
                intent.addFlags(0x10010000);
                this.mActivityStartController.obtainStarter(intent, "startRecentsActivity_noHomeActivity").setCallingUid(recentsUid).setCallingPackage(recentsComponent.getPackageName()).setActivityOptions(SafeActivityOptions.fromBundle(opts.toBundle())).setMayWait(this.mUserController.getCurrentUserId()).execute();
                this.mWindowManager.prepareAppTransition(0, false);
            }
            ActivityRecord homeActivity = this.mStackSupervisor.getHomeActivity();
            ActivityDisplay display = homeActivity.getDisplay();
            this.mRestoreHomeBehindStack = hasExistingHomeActivity ? display.getStackAboveHome() : null;
            display.moveHomeStackBehindBottomMostVisibleStack();
            homeActivity.mLaunchTaskBehind = true;
            this.mWindowManager.initializeRecentsAnimation(recentsAnimationRunner, this, display.mDisplayId);
            this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, true);
            this.mHandler.postDelayed(this.mCancelAnimationRunnable, 10000L);
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onAnimationFinished(boolean moveHomeToTop) {
        block4: {
            this.mHandler.removeCallbacks(this.mCancelAnimationRunnable);
            ActivityManagerService activityManagerService = this.mService;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (this.mWindowManager.getRecentsAnimationController() != null) break block4;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        this.mWindowManager.inSurfaceTransaction(() -> {
            this.mWindowManager.deferSurfaceLayout();
            try {
                this.mWindowManager.cleanupRecentsAnimation();
                ActivityRecord homeActivity = this.mStackSupervisor.getHomeActivity();
                if (homeActivity == null) {
                    return;
                }
                homeActivity.mLaunchTaskBehind = false;
                if (moveHomeToTop) {
                    Object homeStack = homeActivity.getStack();
                    this.mStackSupervisor.mNoAnimActivities.add(homeActivity);
                    ((ActivityStack)homeStack).moveToFront("RecentsAnimation.onAnimationFinished()");
                } else {
                    ActivityDisplay display = homeActivity.getDisplay();
                    display.moveHomeStackBehindStack(this.mRestoreHomeBehindStack);
                }
                this.mWindowManager.prepareAppTransition(0, false);
                this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
                this.mWindowManager.executeAppTransition();
            }
            finally {
                this.mWindowManager.continueSurfaceLayout();
            }
        });
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }
}

