/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.view.Window;
import android.widget.CheckBox;
import com.android.server.am.AppWarnings;
import com.android.server.utils.AppInstallerUtil;

public class UnsupportedCompileSdkDialog {
    private final AlertDialog mDialog;
    private final String mPackageName;

    public UnsupportedCompileSdkDialog(AppWarnings manager, Context context, ApplicationInfo appInfo) {
        this.mPackageName = appInfo.packageName;
        PackageManager pm = context.getPackageManager();
        CharSequence label = appInfo.loadSafeLabel(pm);
        String message = context.getString(17040954, label);
        AlertDialog.Builder builder = new AlertDialog.Builder(context).setPositiveButton(17039370, null).setMessage(message).setView(17367316);
        Intent installerIntent = AppInstallerUtil.createIntent(context, appInfo.packageName);
        if (installerIntent != null) {
            builder.setNeutralButton(17040953, (dialog, which) -> context.startActivity(installerIntent));
        }
        this.mDialog = builder.create();
        this.mDialog.create();
        Window window = this.mDialog.getWindow();
        window.setType(2002);
        window.getAttributes().setTitle("UnsupportedCompileSdkDialog");
        CheckBox alwaysShow = (CheckBox)this.mDialog.findViewById(16908722);
        alwaysShow.setChecked(true);
        alwaysShow.setOnCheckedChangeListener((buttonView, isChecked) -> manager.setPackageFlag(this.mPackageName, 2, !isChecked));
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public void show() {
        this.mDialog.show();
    }

    public void dismiss() {
        this.mDialog.dismiss();
    }
}

