/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.app.ActivityManager;
import android.app.ActivityThread;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.UserManagerInternal;
import android.provider.Settings;
import android.service.autofill.FillEventHistory;
import android.service.autofill.UserData;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.LocalLog;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillManagerInternal;
import android.view.autofill.AutofillValue;
import android.view.autofill.IAutoFillManager;
import android.view.autofill.IAutoFillManagerClient;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.IResultReceiver;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.Preconditions;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.autofill.AutofillManagerServiceImpl;
import com.android.server.autofill.AutofillManagerServiceShellCommand;
import com.android.server.autofill.FieldClassificationStrategy;
import com.android.server.autofill.Helper;
import com.android.server.autofill.ui.AutoFillUI;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class AutofillManagerService
extends SystemService {
    private static final String TAG = "AutofillManagerService";
    static final String RECEIVER_BUNDLE_EXTRA_SESSIONS = "sessions";
    private static final char COMPAT_PACKAGE_DELIMITER = ':';
    private final Context mContext;
    private final AutoFillUI mUi;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private SparseArray<AutofillManagerServiceImpl> mServicesCache = new SparseArray();
    @GuardedBy(value="mLock")
    private final SparseBooleanArray mDisabledUsers = new SparseBooleanArray();
    private final LocalLog mRequestsHistory = new LocalLog(20);
    private final LocalLog mUiLatencyHistory = new LocalLog(20);
    private final LocalLog mWtfHistory = new LocalLog(50);
    private final AutofillCompatState mAutofillCompatState = new AutofillCompatState();
    private final LocalService mLocalService = new LocalService();
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(intent.getAction())) {
                if (Helper.sDebug) {
                    Slog.d(AutofillManagerService.TAG, "Close system dialogs");
                }
                Object object = AutofillManagerService.this.mLock;
                synchronized (object) {
                    for (int i = 0; i < AutofillManagerService.this.mServicesCache.size(); ++i) {
                        ((AutofillManagerServiceImpl)AutofillManagerService.this.mServicesCache.valueAt(i)).destroyFinishedSessionsLocked();
                    }
                }
                AutofillManagerService.this.mUi.hideAll(null);
            }
        }
    };

    public AutofillManagerService(Context context) {
        super(context);
        this.mContext = context;
        this.mUi = new AutoFillUI(ActivityThread.currentActivityThread().getSystemUiContext());
        boolean debug = Build.IS_DEBUGGABLE;
        Slog.i(TAG, "Setting debug to " + debug);
        this.setDebugLocked(debug);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter, null, FgThread.getHandler());
        UserManager um = context.getSystemService(UserManager.class);
        UserManagerInternal umi = LocalServices.getService(UserManagerInternal.class);
        List<UserInfo> users = um.getUsers();
        for (int i = 0; i < users.size(); ++i) {
            int userId2 = users.get((int)i).id;
            boolean disabled = umi.getUserRestriction(userId2, "no_autofill");
            if (!disabled) continue;
            if (disabled) {
                Slog.i(TAG, "Disabling Autofill for user " + userId2);
            }
            this.mDisabledUsers.put(userId2, disabled);
        }
        umi.addUserRestrictionsListener((userId, newRestrictions, prevRestrictions) -> {
            boolean disabledNow = newRestrictions.getBoolean("no_autofill", false);
            Object object = this.mLock;
            synchronized (object) {
                boolean disabledBefore = this.mDisabledUsers.get(userId);
                if (disabledBefore == disabledNow && Helper.sDebug) {
                    Slog.d(TAG, "Autofill restriction did not change for user " + userId + ": " + Helper.bundleToString(newRestrictions));
                    return;
                }
                Slog.i(TAG, "Updating Autofill for user " + userId + ": disabled=" + disabledNow);
                this.mDisabledUsers.put(userId, disabledNow);
                this.updateCachedServiceLocked(userId, disabledNow);
            }
        });
        this.startTrackingPackageChanges();
    }

    private void startTrackingPackageChanges() {
        PackageMonitor monitor = new PackageMonitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSomePackagesChanged() {
                Object object = AutofillManagerService.this.mLock;
                synchronized (object) {
                    AutofillManagerService.this.updateCachedServiceLocked(this.getChangingUserId());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageUpdateFinished(String packageName, int uid) {
                Object object = AutofillManagerService.this.mLock;
                synchronized (object) {
                    String activePackageName = this.getActiveAutofillServicePackageName();
                    if (packageName.equals(activePackageName)) {
                        AutofillManagerService.this.removeCachedServiceLocked(this.getChangingUserId());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageRemoved(String packageName, int uid) {
                Object object = AutofillManagerService.this.mLock;
                synchronized (object) {
                    ComponentName componentName;
                    int userId = this.getChangingUserId();
                    AutofillManagerServiceImpl userState = AutofillManagerService.this.peekServiceForUserLocked(userId);
                    if (userState != null && (componentName = userState.getServiceComponentName()) != null && packageName.equals(componentName.getPackageName())) {
                        this.handleActiveAutofillServiceRemoved(userId);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
                Object object = AutofillManagerService.this.mLock;
                synchronized (object) {
                    String activePackageName = this.getActiveAutofillServicePackageName();
                    for (String pkg : packages) {
                        if (!pkg.equals(activePackageName)) continue;
                        if (!doit) {
                            return true;
                        }
                        AutofillManagerService.this.removeCachedServiceLocked(this.getChangingUserId());
                    }
                }
                return false;
            }

            private void handleActiveAutofillServiceRemoved(int userId) {
                AutofillManagerService.this.removeCachedServiceLocked(userId);
                Settings.Secure.putStringForUser(AutofillManagerService.this.mContext.getContentResolver(), "autofill_service", null, userId);
            }

            private String getActiveAutofillServicePackageName() {
                int userId = this.getChangingUserId();
                AutofillManagerServiceImpl userState = AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (userState == null) {
                    return null;
                }
                ComponentName serviceComponent = userState.getServiceComponentName();
                if (serviceComponent == null) {
                    return null;
                }
                return serviceComponent.getPackageName();
            }
        };
        monitor.register(this.mContext, null, UserHandle.ALL, true);
    }

    @Override
    public void onStart() {
        this.publishBinderService("autofill", new AutoFillManagerServiceStub());
        this.publishLocalService(AutofillManagerInternal.class, this.mLocalService);
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 600) {
            new SettingsObserver(BackgroundThread.getHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUnlockUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateCachedServiceLocked(userId);
        }
    }

    @Override
    public void onSwitchUser(int userHandle) {
        if (Helper.sDebug) {
            Slog.d(TAG, "Hiding UI when user switched");
        }
        this.mUi.hideAll(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCleanupUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.removeCachedServiceLocked(userId);
        }
    }

    @GuardedBy(value="mLock")
    AutofillManagerServiceImpl getServiceForUserLocked(int userId) {
        int resolvedUserId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, false, null, null);
        AutofillManagerServiceImpl service = this.mServicesCache.get(resolvedUserId);
        if (service == null) {
            service = new AutofillManagerServiceImpl(this.mContext, this.mLock, this.mRequestsHistory, this.mUiLatencyHistory, this.mWtfHistory, resolvedUserId, this.mUi, this.mDisabledUsers.get(resolvedUserId));
            this.mServicesCache.put(userId, service);
            ArrayMap<String, Pair<Long, String>> compatPackages = service.getCompatibilityPackagesLocked();
            if (compatPackages != null) {
                this.addCompatibilityModeRequests(compatPackages, userId);
            }
        }
        return service;
    }

    @GuardedBy(value="mLock")
    AutofillManagerServiceImpl peekServiceForUserLocked(int userId) {
        int resolvedUserId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, false, null, null);
        return this.mServicesCache.get(resolvedUserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroySessions(int userId, IResultReceiver receiver) {
        Slog.i(TAG, "destroySessions() for userId " + userId);
        this.mContext.enforceCallingPermission("android.permission.MANAGE_AUTO_FILL", TAG);
        Object object = this.mLock;
        synchronized (object) {
            if (userId != -1) {
                AutofillManagerServiceImpl service = this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.destroySessionsLocked();
                }
            } else {
                int size = this.mServicesCache.size();
                for (int i = 0; i < size; ++i) {
                    this.mServicesCache.valueAt(i).destroySessionsLocked();
                }
            }
        }
        try {
            receiver.send(0, new Bundle());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void listSessions(int userId, IResultReceiver receiver) {
        Slog.i(TAG, "listSessions() for userId " + userId);
        this.mContext.enforceCallingPermission("android.permission.MANAGE_AUTO_FILL", TAG);
        Bundle resultData = new Bundle();
        ArrayList<String> sessions = new ArrayList<String>();
        Object object = this.mLock;
        synchronized (object) {
            if (userId != -1) {
                AutofillManagerServiceImpl service = this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.listSessionsLocked(sessions);
                }
            } else {
                int size = this.mServicesCache.size();
                for (int i = 0; i < size; ++i) {
                    this.mServicesCache.valueAt(i).listSessionsLocked(sessions);
                }
            }
        }
        resultData.putStringArrayList(RECEIVER_BUNDLE_EXTRA_SESSIONS, sessions);
        try {
            receiver.send(0, resultData);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Slog.i(TAG, "reset()");
        this.mContext.enforceCallingPermission("android.permission.MANAGE_AUTO_FILL", TAG);
        Object object = this.mLock;
        synchronized (object) {
            int size = this.mServicesCache.size();
            for (int i = 0; i < size; ++i) {
                this.mServicesCache.valueAt(i).destroyLocked();
            }
            this.mServicesCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLogLevel(int level) {
        Slog.i(TAG, "setLogLevel(): " + level);
        this.mContext.enforceCallingPermission("android.permission.MANAGE_AUTO_FILL", TAG);
        boolean debug = false;
        boolean verbose = false;
        if (level == 4) {
            verbose = true;
            debug = true;
        } else if (level == 2) {
            debug = true;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.setDebugLocked(debug);
            this.setVerboseLocked(verbose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getLogLevel() {
        this.mContext.enforceCallingPermission("android.permission.MANAGE_AUTO_FILL", TAG);
        Object object = this.mLock;
        synchronized (object) {
            if (Helper.sVerbose) {
                return 4;
            }
            if (Helper.sDebug) {
                return 2;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxPartitions() {
        this.mContext.enforceCallingPermission("android.permission.MANAGE_AUTO_FILL", TAG);
        Object object = this.mLock;
        synchronized (object) {
            return Helper.sPartitionMaxCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxPartitions(int max) {
        this.mContext.enforceCallingPermission("android.permission.MANAGE_AUTO_FILL", TAG);
        Slog.i(TAG, "setMaxPartitions(): " + max);
        Object object = this.mLock;
        synchronized (object) {
            Helper.sPartitionMaxCount = max;
        }
    }

    public void getScore(String algorithmName, String value1, String value2, RemoteCallback callback) {
        this.mContext.enforceCallingPermission("android.permission.MANAGE_AUTO_FILL", TAG);
        FieldClassificationStrategy strategy = new FieldClassificationStrategy(this.mContext, -2);
        strategy.getScores(callback, algorithmName, null, Arrays.asList(AutofillValue.forText(value1)), new String[]{value2});
    }

    private void setDebugLocked(boolean debug) {
        Helper.sDebug = debug;
        android.view.autofill.Helper.sDebug = debug;
    }

    private void setVerboseLocked(boolean verbose) {
        Helper.sVerbose = verbose;
        android.view.autofill.Helper.sVerbose = verbose;
    }

    @GuardedBy(value="mLock")
    private void removeCachedServiceLocked(int userId) {
        AutofillManagerServiceImpl service = this.peekServiceForUserLocked(userId);
        if (service != null) {
            this.mServicesCache.delete(userId);
            service.destroyLocked();
            this.mAutofillCompatState.removeCompatibilityModeRequests(userId);
        }
    }

    @GuardedBy(value="mLock")
    private void updateCachedServiceLocked(int userId) {
        this.updateCachedServiceLocked(userId, this.mDisabledUsers.get(userId));
    }

    @GuardedBy(value="mLock")
    private void updateCachedServiceLocked(int userId, boolean disabled) {
        AutofillManagerServiceImpl service = this.peekServiceForUserLocked(userId);
        if (service != null) {
            service.destroySessionsLocked();
            service.updateLocked(disabled);
            if (!service.isEnabledLocked()) {
                this.removeCachedServiceLocked(userId);
            } else {
                ArrayMap<String, Pair<Long, String>> compatPackages = service.getCompatibilityPackagesLocked();
                if (compatPackages != null) {
                    this.addCompatibilityModeRequests(compatPackages, userId);
                }
            }
        }
    }

    private void addCompatibilityModeRequests(ArrayMap<String, Pair<Long, String>> compatPackages, int userId) {
        Set<String> whiteListedPackages = Build.IS_ENG ? null : this.getWhitelistedCompatModePackages();
        int compatPackageCount = compatPackages.size();
        for (int i = 0; i < compatPackageCount; ++i) {
            String packageName = compatPackages.keyAt(i);
            if (!(Build.IS_ENG || whiteListedPackages != null && whiteListedPackages.contains(packageName))) {
                Slog.w(TAG, "Ignoring not whitelisted compat package " + packageName);
                continue;
            }
            Long maxVersionCode = (Long)compatPackages.valueAt((int)i).first;
            if (maxVersionCode == null) continue;
            this.mAutofillCompatState.addCompatibilityModeRequest(packageName, maxVersionCode, userId);
        }
    }

    private Set<String> getWhitelistedCompatModePackages() {
        String compatPackagesSetting = Settings.Global.getString(this.mContext.getContentResolver(), "autofill_compat_allowed_packages");
        if (TextUtils.isEmpty(compatPackagesSetting)) {
            return null;
        }
        ArraySet<String> compatPackages = new ArraySet<String>();
        TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(':');
        splitter.setString(compatPackagesSetting);
        while (splitter.hasNext()) {
            compatPackages.add(splitter.next());
        }
        return compatPackages;
    }

    private final class SettingsObserver
    extends ContentObserver {
        SettingsObserver(Handler handler) {
            super(handler);
            ContentResolver resolver = AutofillManagerService.this.mContext.getContentResolver();
            resolver.registerContentObserver(Settings.Secure.getUriFor("autofill_service"), false, this, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("user_setup_complete"), false, this, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri, int userId) {
            if (Helper.sVerbose) {
                Slog.v(AutofillManagerService.TAG, "onChange(): uri=" + uri + ", userId=" + userId);
            }
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerService.this.updateCachedServiceLocked(userId);
            }
        }
    }

    final class AutoFillManagerServiceStub
    extends IAutoFillManager.Stub {
        AutoFillManagerServiceStub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addClient(IAutoFillManagerClient client, int userId) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                int flags = 0;
                if (AutofillManagerService.this.getServiceForUserLocked(userId).addClientLocked(client)) {
                    flags |= 1;
                }
                if (Helper.sDebug) {
                    flags |= 2;
                }
                if (Helper.sVerbose) {
                    flags |= 4;
                }
                return flags;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeClient(IAutoFillManagerClient client, int userId) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.removeClientLocked(client);
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "removeClient(): no service for " + userId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAuthenticationResult(Bundle data, int sessionId, int authenticationId, int userId) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.getServiceForUserLocked(userId);
                service.setAuthenticationResultLocked(data, sessionId, authenticationId, AutoFillManagerServiceStub.getCallingUid());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setHasCallback(int sessionId, int userId, boolean hasIt) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.getServiceForUserLocked(userId);
                service.setHasCallback(sessionId, AutoFillManagerServiceStub.getCallingUid(), hasIt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int startSession(IBinder activityToken, IBinder appCallback, AutofillId autofillId, Rect bounds, AutofillValue value, int userId, boolean hasCallback, int flags, ComponentName componentName, boolean compatMode) {
            activityToken = Preconditions.checkNotNull(activityToken, "activityToken");
            appCallback = Preconditions.checkNotNull(appCallback, "appCallback");
            autofillId = Preconditions.checkNotNull(autofillId, "autoFillId");
            componentName = Preconditions.checkNotNull(componentName, "componentName");
            String packageName = Preconditions.checkNotNull(componentName.getPackageName());
            Preconditions.checkArgument(userId == UserHandle.getUserId(AutoFillManagerServiceStub.getCallingUid()), "userId");
            try {
                AutofillManagerService.this.mContext.getPackageManager().getPackageInfoAsUser(packageName, 0, userId);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new IllegalArgumentException(packageName + " is not a valid package", e);
            }
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.getServiceForUserLocked(userId);
                return service.startSessionLocked(activityToken, AutoFillManagerServiceStub.getCallingUid(), appCallback, autofillId, bounds, value, hasCallback, flags, componentName, compatMode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FillEventHistory getFillEventHistory() throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    return service.getFillEventHistory(AutoFillManagerServiceStub.getCallingUid());
                }
                if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "getFillEventHistory(): no service for " + userId);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UserData getUserData() throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    return service.getUserData(AutoFillManagerServiceStub.getCallingUid());
                }
                if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "getUserData(): no service for " + userId);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getUserDataId() throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    UserData userData = service.getUserData(AutoFillManagerServiceStub.getCallingUid());
                    String string2 = userData == null ? null : userData.getId();
                    return string2;
                }
                if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "getUserDataId(): no service for " + userId);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setUserData(UserData userData) throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.setUserData(AutoFillManagerServiceStub.getCallingUid(), userData);
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "setUserData(): no service for " + userId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFieldClassificationEnabled() throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    return service.isFieldClassificationEnabled(AutoFillManagerServiceStub.getCallingUid());
                }
                if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "isFieldClassificationEnabled(): no service for " + userId);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getDefaultFieldClassificationAlgorithm() throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    return service.getDefaultFieldClassificationAlgorithm(AutoFillManagerServiceStub.getCallingUid());
                }
                if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "getDefaultFcAlgorithm(): no service for " + userId);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] getAvailableFieldClassificationAlgorithms() throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    return service.getAvailableFieldClassificationAlgorithms(AutoFillManagerServiceStub.getCallingUid());
                }
                if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "getAvailableFcAlgorithms(): no service for " + userId);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ComponentName getAutofillServiceComponentName() throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    return service.getServiceComponentName();
                }
                if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "getAutofillServiceComponentName(): no service for " + userId);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean restoreSession(int sessionId, IBinder activityToken, IBinder appCallback) throws RemoteException {
            int userId = UserHandle.getCallingUserId();
            activityToken = Preconditions.checkNotNull(activityToken, "activityToken");
            appCallback = Preconditions.checkNotNull(appCallback, "appCallback");
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = (AutofillManagerServiceImpl)AutofillManagerService.this.mServicesCache.get(userId);
                if (service != null) {
                    return service.restoreSession(sessionId, AutoFillManagerServiceStub.getCallingUid(), activityToken, appCallback);
                }
                if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "restoreSession(): no service for " + userId);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateSession(int sessionId, AutofillId autoFillId, Rect bounds, AutofillValue value, int action, int flags, int userId) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.updateSessionLocked(sessionId, AutoFillManagerServiceStub.getCallingUid(), autoFillId, bounds, value, action, flags);
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "updateSession(): no service for " + userId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int updateOrRestartSession(IBinder activityToken, IBinder appCallback, AutofillId autoFillId, Rect bounds, AutofillValue value, int userId, boolean hasCallback, int flags, ComponentName componentName, int sessionId, int action, boolean compatMode) {
            boolean restart = false;
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    restart = service.updateSessionLocked(sessionId, AutoFillManagerServiceStub.getCallingUid(), autoFillId, bounds, value, action, flags);
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "updateOrRestartSession(): no service for " + userId);
                }
            }
            if (restart) {
                return this.startSession(activityToken, appCallback, autoFillId, bounds, value, userId, hasCallback, flags, componentName, compatMode);
            }
            return sessionId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishSession(int sessionId, int userId) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.finishSessionLocked(sessionId, AutoFillManagerServiceStub.getCallingUid());
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "finishSession(): no service for " + userId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelSession(int sessionId, int userId) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.cancelSessionLocked(sessionId, AutoFillManagerServiceStub.getCallingUid());
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "cancelSession(): no service for " + userId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disableOwnedAutofillServices(int userId) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.disableOwnedAutofillServicesLocked(Binder.getCallingUid());
                } else if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "cancelSession(): no service for " + userId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isServiceSupported(int userId) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                return !AutofillManagerService.this.mDisabledUsers.get(userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isServiceEnabled(int userId, String packageName) {
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    return Objects.equals(packageName, service.getServicePackageName());
                }
                if (Helper.sVerbose) {
                    Slog.v(AutofillManagerService.TAG, "isServiceEnabled(): no service for " + userId);
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPendingSaveUi(int operation, IBinder token) {
            Preconditions.checkNotNull(token, "token");
            Preconditions.checkArgument(operation == 1 || operation == 2, "invalid operation: %d", operation);
            Object object = AutofillManagerService.this.mLock;
            synchronized (object) {
                AutofillManagerServiceImpl service = AutofillManagerService.this.peekServiceForUserLocked(UserHandle.getCallingUserId());
                if (service != null) {
                    service.onPendingSaveUi(operation, token);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(AutofillManagerService.this.mContext, AutofillManagerService.TAG, pw)) {
                return;
            }
            boolean showHistory = true;
            boolean uiOnly = false;
            if (args != null) {
                String[] stringArray = args;
                int n = stringArray.length;
                block16: for (int i = 0; i < n; ++i) {
                    String arg;
                    switch (arg = stringArray[i]) {
                        case "--no-history": {
                            showHistory = false;
                            continue block16;
                        }
                        case "--ui-only": {
                            uiOnly = true;
                            continue block16;
                        }
                        case "--help": {
                            pw.println("Usage: dumpsys autofill [--ui-only|--no-history]");
                            return;
                        }
                        default: {
                            Slog.w(AutofillManagerService.TAG, "Ignoring invalid dump arg: " + arg);
                        }
                    }
                }
            }
            if (uiOnly) {
                AutofillManagerService.this.mUi.dump(pw);
                return;
            }
            boolean oldDebug = Helper.sDebug;
            String prefix = "  ";
            try {
                Object object = AutofillManagerService.this.mLock;
                synchronized (object) {
                    oldDebug = Helper.sDebug;
                    AutofillManagerService.this.setDebugLocked(true);
                    pw.print("Debug mode: ");
                    pw.println(oldDebug);
                    pw.print("Verbose mode: ");
                    pw.println(Helper.sVerbose);
                    pw.print("Disabled users: ");
                    pw.println(AutofillManagerService.this.mDisabledUsers);
                    pw.print("Max partitions per session: ");
                    pw.println(Helper.sPartitionMaxCount);
                    pw.println("User data constraints: ");
                    UserData.dumpConstraints("  ", pw);
                    int size = AutofillManagerService.this.mServicesCache.size();
                    pw.print("Cached services: ");
                    if (size == 0) {
                        pw.println("none");
                    } else {
                        pw.println(size);
                        for (int i = 0; i < size; ++i) {
                            pw.print("\nService at index ");
                            pw.println(i);
                            AutofillManagerServiceImpl impl = (AutofillManagerServiceImpl)AutofillManagerService.this.mServicesCache.valueAt(i);
                            impl.dumpLocked("  ", pw);
                        }
                    }
                    AutofillManagerService.this.mUi.dump(pw);
                }
                if (showHistory) {
                    pw.println();
                    pw.println("Requests history:");
                    pw.println();
                    AutofillManagerService.this.mRequestsHistory.reverseDump(fd, pw, args);
                    pw.println();
                    pw.println("UI latency history:");
                    pw.println();
                    AutofillManagerService.this.mUiLatencyHistory.reverseDump(fd, pw, args);
                    pw.println();
                    pw.println("WTF history:");
                    pw.println();
                    AutofillManagerService.this.mWtfHistory.reverseDump(fd, pw, args);
                }
            }
            finally {
                AutofillManagerService.this.setDebugLocked(oldDebug);
            }
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
            new AutofillManagerServiceShellCommand(AutofillManagerService.this).exec(this, in, out, err, args, callback, resultReceiver);
        }
    }

    private static class AutofillCompatState {
        private final Object mLock = new Object();
        @GuardedBy(value="mLock")
        private SparseArray<ArrayMap<String, Long>> mUserSpecs;

        private AutofillCompatState() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isCompatibilityModeRequested(String packageName, long versionCode, int userId) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mUserSpecs == null) {
                    return false;
                }
                ArrayMap<String, Long> userSpec = this.mUserSpecs.get(userId);
                if (userSpec == null) {
                    return false;
                }
                Long maxVersionCode = userSpec.get(packageName);
                if (maxVersionCode == null) {
                    return false;
                }
                return versionCode <= maxVersionCode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addCompatibilityModeRequest(String packageName, long versionCode, int userId) {
            Object object = this.mLock;
            synchronized (object) {
                ArrayMap<String, Long> userSpec;
                if (this.mUserSpecs == null) {
                    this.mUserSpecs = new SparseArray();
                }
                if ((userSpec = this.mUserSpecs.get(userId)) == null) {
                    userSpec = new ArrayMap();
                    this.mUserSpecs.put(userId, userSpec);
                }
                userSpec.put(packageName, versionCode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeCompatibilityModeRequests(int userId) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mUserSpecs != null) {
                    this.mUserSpecs.remove(userId);
                    if (this.mUserSpecs.size() <= 0) {
                        this.mUserSpecs = null;
                    }
                }
            }
        }
    }

    private final class LocalService
    extends AutofillManagerInternal {
        private LocalService() {
        }

        @Override
        public void onBackKeyPressed() {
            if (Helper.sDebug) {
                Slog.d(AutofillManagerService.TAG, "onBackKeyPressed()");
            }
            AutofillManagerService.this.mUi.hideAll(null);
        }

        @Override
        public boolean isCompatibilityModeRequested(String packageName, long versionCode, int userId) {
            return AutofillManagerService.this.mAutofillCompatState.isCompatibilityModeRequested(packageName, versionCode, userId);
        }
    }
}

