/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.app.assist.AssistStructure;
import android.metrics.LogMaker;
import android.os.Bundle;
import android.service.autofill.Dataset;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;

public final class Helper {
    private static final String TAG = "AutofillHelper";
    public static boolean sDebug = false;
    public static boolean sVerbose = false;
    static int sPartitionMaxCount = 10;

    private Helper() {
        throw new UnsupportedOperationException("contains static members only");
    }

    static void append(StringBuilder builder, Bundle bundle) {
        if (bundle == null || !sVerbose) {
            builder.append("null");
            return;
        }
        Set<String> keySet = bundle.keySet();
        builder.append("[Bundle with ").append(keySet.size()).append(" extras:");
        for (String key : keySet) {
            Object value = bundle.get(key);
            builder.append(' ').append(key).append('=');
            builder.append(value instanceof Object[] ? Arrays.toString((Objects[])value) : value);
        }
        builder.append(']');
    }

    static String bundleToString(Bundle bundle) {
        StringBuilder builder = new StringBuilder();
        Helper.append(builder, bundle);
        return builder.toString();
    }

    static AutofillId[] toArray(ArraySet<AutofillId> set) {
        if (set == null) {
            return null;
        }
        AutofillId[] array2 = new AutofillId[set.size()];
        for (int i = 0; i < set.size(); ++i) {
            array2[i] = set.valueAt(i);
        }
        return array2;
    }

    static ArrayMap<AutofillId, AutofillValue> getFields(Dataset dataset) {
        ArrayList<AutofillId> ids = dataset.getFieldIds();
        ArrayList<AutofillValue> values = dataset.getFieldValues();
        int size = ids == null ? 0 : ids.size();
        ArrayMap<AutofillId, AutofillValue> fields = new ArrayMap<AutofillId, AutofillValue>(size);
        for (int i = 0; i < size; ++i) {
            fields.put(ids.get(i), values.get(i));
        }
        return fields;
    }

    public static LogMaker newLogMaker(int category, String packageName, String servicePackageName) {
        LogMaker log = new LogMaker(category).setPackageName(packageName);
        if (servicePackageName != null) {
            log.addTaggedData(908, servicePackageName);
        }
        return log;
    }

    public static void printlnRedactedText(PrintWriter pw, String text) {
        if (text == null) {
            pw.println("null");
        } else {
            pw.print(text.length());
            pw.println("_chars");
        }
    }

    public static AssistStructure.ViewNode findViewNodeByAutofillId(AssistStructure structure, AutofillId autofillId) {
        return Helper.findViewNode(structure, node -> autofillId.equals(node.getAutofillId()));
    }

    private static AssistStructure.ViewNode findViewNode(AssistStructure structure, ViewNodeFilter filter) {
        LinkedList<AssistStructure.ViewNode> nodesToProcess = new LinkedList<AssistStructure.ViewNode>();
        int numWindowNodes = structure.getWindowNodeCount();
        for (int i = 0; i < numWindowNodes; ++i) {
            nodesToProcess.add(structure.getWindowNodeAt(i).getRootViewNode());
        }
        while (!nodesToProcess.isEmpty()) {
            AssistStructure.ViewNode node = (AssistStructure.ViewNode)nodesToProcess.removeFirst();
            if (filter.matches(node)) {
                return node;
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                nodesToProcess.addLast(node.getChildAt(i));
            }
        }
        return null;
    }

    public static void sanitizeUrlBar(AssistStructure structure, String urlBarId) {
        AssistStructure.ViewNode urlBarNode = Helper.findViewNode(structure, node -> urlBarId.equals(node.getIdEntry()));
        if (urlBarNode != null) {
            String domain = urlBarNode.getText().toString();
            if (domain.isEmpty()) {
                if (sDebug) {
                    Slog.d(TAG, "sanitizeUrlBar(): empty on " + urlBarId);
                }
                return;
            }
            urlBarNode.setWebDomain(domain);
            if (sDebug) {
                Slog.d(TAG, "sanitizeUrlBar(): id=" + urlBarId + ", domain=" + urlBarNode.getWebDomain());
            }
        }
    }

    private static interface ViewNodeFilter {
        public boolean matches(AssistStructure.ViewNode var1);
    }
}

