/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.service.autofill.FillRequest;
import android.service.autofill.FillResponse;
import android.service.autofill.IAutoFillService;
import android.service.autofill.IFillCallback;
import android.service.autofill.ISaveCallback;
import android.service.autofill.SaveRequest;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.HandlerCaller;
import com.android.server.FgThread;
import com.android.server.autofill.Helper;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;

final class RemoteFillService
implements IBinder.DeathRecipient {
    private static final String LOG_TAG = "RemoteFillService";
    private static final long TIMEOUT_IDLE_BIND_MILLIS = 5000L;
    private static final long TIMEOUT_REMOTE_REQUEST_MILLIS = 5000L;
    private final Context mContext;
    private final ComponentName mComponentName;
    private final Intent mIntent;
    private final FillServiceCallbacks mCallbacks;
    private final int mUserId;
    private final ServiceConnection mServiceConnection = new RemoteServiceConnection();
    private final HandlerCaller mHandler;
    private IAutoFillService mAutoFillService;
    private boolean mBinding;
    private boolean mDestroyed;
    private boolean mServiceDied;
    private boolean mCompleted;
    private PendingRequest mPendingRequest;

    public RemoteFillService(Context context, ComponentName componentName, int userId, FillServiceCallbacks callbacks) {
        this.mContext = context;
        this.mCallbacks = callbacks;
        this.mComponentName = componentName;
        this.mIntent = new Intent("android.service.autofill.AutofillService").setComponent(this.mComponentName);
        this.mUserId = userId;
        this.mHandler = new MyHandler(context);
    }

    public void destroy() {
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    private void handleDestroy() {
        if (this.mPendingRequest != null) {
            this.mPendingRequest.cancel();
            this.mPendingRequest = null;
        }
        this.ensureUnbound();
        this.mDestroyed = true;
    }

    @Override
    public void binderDied() {
        this.mHandler.obtainMessage(2).sendToTarget();
    }

    private void handleBinderDied() {
        if (this.mAutoFillService != null) {
            this.mAutoFillService.asBinder().unlinkToDeath(this, 0);
        }
        this.mAutoFillService = null;
        this.mServiceDied = true;
        this.mCallbacks.onServiceDied(this);
    }

    public int cancelCurrentRequest() {
        if (this.mDestroyed) {
            return Integer.MIN_VALUE;
        }
        int requestId = Integer.MIN_VALUE;
        if (this.mPendingRequest != null) {
            if (this.mPendingRequest instanceof PendingFillRequest) {
                requestId = ((PendingFillRequest)this.mPendingRequest).mRequest.getId();
            }
            this.mPendingRequest.cancel();
            this.mPendingRequest = null;
        }
        return requestId;
    }

    public void onFillRequest(FillRequest request) {
        this.cancelScheduledUnbind();
        PendingFillRequest pendingRequest = new PendingFillRequest(request, this);
        this.mHandler.obtainMessageO(4, pendingRequest).sendToTarget();
    }

    public void onSaveRequest(SaveRequest request) {
        this.cancelScheduledUnbind();
        PendingSaveRequest pendingRequest = new PendingSaveRequest(request, this);
        this.mHandler.obtainMessageO(4, pendingRequest).sendToTarget();
    }

    public void dump(String prefix, PrintWriter pw) {
        String tab = "  ";
        pw.append(prefix).append("service:").println();
        pw.append(prefix).append(tab).append("userId=").append(String.valueOf(this.mUserId)).println();
        pw.append(prefix).append(tab).append("componentName=").append(this.mComponentName.flattenToString()).println();
        pw.append(prefix).append(tab).append("destroyed=").append(String.valueOf(this.mDestroyed)).println();
        pw.append(prefix).append(tab).append("bound=").append(String.valueOf(this.isBound())).println();
        pw.append(prefix).append(tab).append("hasPendingRequest=").append(String.valueOf(this.mPendingRequest != null)).println();
        pw.println();
    }

    private void cancelScheduledUnbind() {
        this.mHandler.removeMessages(3);
    }

    private void scheduleUnbind() {
        this.cancelScheduledUnbind();
        Message message = this.mHandler.obtainMessage(3);
        this.mHandler.sendMessageDelayed(message, 5000L);
    }

    private void handleUnbind() {
        this.ensureUnbound();
    }

    private void handlePendingRequest(PendingRequest pendingRequest) {
        if (this.mDestroyed || this.mCompleted) {
            return;
        }
        if (!this.isBound()) {
            if (this.mPendingRequest != null) {
                this.mPendingRequest.cancel();
            }
            this.mPendingRequest = pendingRequest;
            this.ensureBound();
        } else {
            if (Helper.sVerbose) {
                Slog.v(LOG_TAG, "[user: " + this.mUserId + "] handlePendingRequest()");
            }
            pendingRequest.run();
            if (pendingRequest.isFinal()) {
                this.mCompleted = true;
            }
        }
    }

    private boolean isBound() {
        return this.mAutoFillService != null;
    }

    private void ensureBound() {
        if (this.isBound() || this.mBinding) {
            return;
        }
        if (Helper.sVerbose) {
            Slog.v(LOG_TAG, "[user: " + this.mUserId + "] ensureBound()");
        }
        this.mBinding = true;
        boolean willBind = this.mContext.bindServiceAsUser(this.mIntent, this.mServiceConnection, 0x4000001, new UserHandle(this.mUserId));
        if (!willBind) {
            if (Helper.sDebug) {
                Slog.d(LOG_TAG, "[user: " + this.mUserId + "] could not bind to " + this.mIntent);
            }
            this.mBinding = false;
            if (!this.mServiceDied) {
                this.handleBinderDied();
            }
        }
    }

    private void ensureUnbound() {
        if (!this.isBound() && !this.mBinding) {
            return;
        }
        if (Helper.sVerbose) {
            Slog.v(LOG_TAG, "[user: " + this.mUserId + "] ensureUnbound()");
        }
        this.mBinding = false;
        if (this.isBound()) {
            try {
                this.mAutoFillService.onConnectedStateChanged(false);
            }
            catch (Exception e) {
                Slog.w(LOG_TAG, "Exception calling onDisconnected(): " + e);
            }
            if (this.mAutoFillService != null) {
                this.mAutoFillService.asBinder().unlinkToDeath(this, 0);
                this.mAutoFillService = null;
            }
        }
        this.mContext.unbindService(this.mServiceConnection);
    }

    private void dispatchOnFillRequestSuccess(PendingRequest pendingRequest, int requestFlags, FillResponse response) {
        this.mHandler.getHandler().post(() -> {
            if (this.handleResponseCallbackCommon(pendingRequest)) {
                this.mCallbacks.onFillRequestSuccess(requestFlags, response, this.mComponentName.getPackageName());
            }
        });
    }

    private void dispatchOnFillRequestFailure(PendingRequest pendingRequest, CharSequence message) {
        this.mHandler.getHandler().post(() -> {
            if (this.handleResponseCallbackCommon(pendingRequest)) {
                this.mCallbacks.onFillRequestFailure(message, this.mComponentName.getPackageName());
            }
        });
    }

    private void dispatchOnFillTimeout(ICancellationSignal cancellationSignal) {
        this.mHandler.getHandler().post(() -> {
            try {
                cancellationSignal.cancel();
            }
            catch (RemoteException e) {
                Slog.w(LOG_TAG, "Error calling cancellation signal: " + e);
            }
        });
    }

    private void dispatchOnSaveRequestSuccess(PendingRequest pendingRequest, IntentSender intentSender) {
        this.mHandler.getHandler().post(() -> {
            if (this.handleResponseCallbackCommon(pendingRequest)) {
                this.mCallbacks.onSaveRequestSuccess(this.mComponentName.getPackageName(), intentSender);
            }
        });
    }

    private void dispatchOnSaveRequestFailure(PendingRequest pendingRequest, CharSequence message) {
        this.mHandler.getHandler().post(() -> {
            if (this.handleResponseCallbackCommon(pendingRequest)) {
                this.mCallbacks.onSaveRequestFailure(message, this.mComponentName.getPackageName());
            }
        });
    }

    private boolean handleResponseCallbackCommon(PendingRequest pendingRequest) {
        if (this.mDestroyed) {
            return false;
        }
        if (this.mPendingRequest == pendingRequest) {
            this.mPendingRequest = null;
        }
        if (this.mPendingRequest == null) {
            this.scheduleUnbind();
        }
        return true;
    }

    private static final class PendingSaveRequest
    extends PendingRequest {
        private final SaveRequest mRequest;
        private final ISaveCallback mCallback;

        public PendingSaveRequest(SaveRequest request, RemoteFillService service) {
            super(service);
            this.mRequest = request;
            this.mCallback = new ISaveCallback.Stub(){

                @Override
                public void onSuccess(IntentSender intentSender) {
                    if (!this.finish()) {
                        return;
                    }
                    RemoteFillService remoteService = this.getService();
                    if (remoteService != null) {
                        remoteService.dispatchOnSaveRequestSuccess(this, intentSender);
                    }
                }

                @Override
                public void onFailure(CharSequence message) {
                    if (!this.finish()) {
                        return;
                    }
                    RemoteFillService remoteService = this.getService();
                    if (remoteService != null) {
                        remoteService.dispatchOnSaveRequestFailure(this, message);
                    }
                }
            };
        }

        @Override
        void onTimeout(RemoteFillService remoteService) {
            remoteService.dispatchOnSaveRequestFailure(this, null);
        }

        @Override
        public void run() {
            RemoteFillService remoteService = this.getService();
            if (remoteService != null) {
                try {
                    remoteService.mAutoFillService.onSaveRequest(this.mRequest, this.mCallback);
                }
                catch (RemoteException e) {
                    Slog.e(RemoteFillService.LOG_TAG, "Error calling on save request", e);
                    remoteService.dispatchOnSaveRequestFailure(this, null);
                }
            }
        }

        @Override
        public boolean isFinal() {
            return true;
        }
    }

    private static final class PendingFillRequest
    extends PendingRequest {
        private final FillRequest mRequest;
        private final IFillCallback mCallback;
        private ICancellationSignal mCancellation;

        public PendingFillRequest(final FillRequest request, RemoteFillService service) {
            super(service);
            this.mRequest = request;
            this.mCallback = new IFillCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCancellable(ICancellationSignal cancellation) {
                    Object object = mLock;
                    synchronized (object) {
                        boolean cancelled;
                        Object object2 = mLock;
                        synchronized (object2) {
                            mCancellation = cancellation;
                            cancelled = this.isCancelledLocked();
                        }
                        if (cancelled) {
                            try {
                                cancellation.cancel();
                            }
                            catch (RemoteException e) {
                                Slog.e(RemoteFillService.LOG_TAG, "Error requesting a cancellation", e);
                            }
                        }
                    }
                }

                @Override
                public void onSuccess(FillResponse response) {
                    if (!this.finish()) {
                        return;
                    }
                    RemoteFillService remoteService = this.getService();
                    if (remoteService != null) {
                        remoteService.dispatchOnFillRequestSuccess(this, request.getFlags(), response);
                    }
                }

                @Override
                public void onFailure(CharSequence message) {
                    if (!this.finish()) {
                        return;
                    }
                    RemoteFillService remoteService = this.getService();
                    if (remoteService != null) {
                        remoteService.dispatchOnFillRequestFailure(this, message);
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void onTimeout(RemoteFillService remoteService) {
            ICancellationSignal cancellation;
            Object object = this.mLock;
            synchronized (object) {
                cancellation = this.mCancellation;
            }
            if (cancellation != null) {
                remoteService.dispatchOnFillTimeout(cancellation);
            }
            remoteService.dispatchOnFillRequestFailure(this, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.isCancelledLocked()) {
                    if (Helper.sDebug) {
                        Slog.d(RemoteFillService.LOG_TAG, "run() called after canceled: " + this.mRequest);
                    }
                    return;
                }
            }
            RemoteFillService remoteService = this.getService();
            if (remoteService != null) {
                try {
                    remoteService.mAutoFillService.onFillRequest(this.mRequest, this.mCallback);
                }
                catch (RemoteException e) {
                    Slog.e(RemoteFillService.LOG_TAG, "Error calling on fill request", e);
                    remoteService.dispatchOnFillRequestFailure(this, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            ICancellationSignal cancellation;
            if (!super.cancel()) {
                return false;
            }
            Object object = this.mLock;
            synchronized (object) {
                cancellation = this.mCancellation;
            }
            if (cancellation != null) {
                try {
                    cancellation.cancel();
                }
                catch (RemoteException e) {
                    Slog.e(RemoteFillService.LOG_TAG, "Error cancelling a fill request", e);
                }
            }
            return true;
        }
    }

    private static abstract class PendingRequest
    implements Runnable {
        protected final Object mLock = new Object();
        private final WeakReference<RemoteFillService> mWeakService;
        private final Runnable mTimeoutTrigger;
        private final Handler mServiceHandler;
        @GuardedBy(value="mLock")
        private boolean mCancelled;
        @GuardedBy(value="mLock")
        private boolean mCompleted;

        PendingRequest(RemoteFillService service) {
            this.mWeakService = new WeakReference<RemoteFillService>(service);
            this.mServiceHandler = service.mHandler.getHandler();
            this.mTimeoutTrigger = () -> {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mCancelled) {
                        return;
                    }
                    this.mCompleted = true;
                }
                Slog.w(RemoteFillService.LOG_TAG, this.getClass().getSimpleName() + " timed out");
                RemoteFillService remoteService = (RemoteFillService)this.mWeakService.get();
                if (remoteService != null) {
                    Slog.w(RemoteFillService.LOG_TAG, this.getClass().getSimpleName() + " timed out after " + 5000L + " ms");
                    this.onTimeout(remoteService);
                }
            };
            this.mServiceHandler.postAtTime(this.mTimeoutTrigger, SystemClock.uptimeMillis() + 5000L);
        }

        protected RemoteFillService getService() {
            return (RemoteFillService)this.mWeakService.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final boolean finish() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mCompleted || this.mCancelled) {
                    return false;
                }
                this.mCompleted = true;
            }
            this.mServiceHandler.removeCallbacks(this.mTimeoutTrigger);
            return true;
        }

        @GuardedBy(value="mLock")
        protected boolean isCancelledLocked() {
            return this.mCancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cancel() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mCancelled || this.mCompleted) {
                    return false;
                }
                this.mCancelled = true;
            }
            this.mServiceHandler.removeCallbacks(this.mTimeoutTrigger);
            return true;
        }

        abstract void onTimeout(RemoteFillService var1);

        boolean isFinal() {
            return false;
        }
    }

    private final class MyHandler
    extends HandlerCaller {
        public static final int MSG_DESTROY = 1;
        public static final int MSG_BINDER_DIED = 2;
        public static final int MSG_UNBIND = 3;
        public static final int MSG_ON_PENDING_REQUEST = 4;

        public MyHandler(Context context) {
            super(context, FgThread.getHandler().getLooper(), new HandlerCaller.Callback(){

                @Override
                public void executeMessage(Message message) {
                    if (RemoteFillService.this.mDestroyed) {
                        if (Helper.sVerbose) {
                            Slog.v(RemoteFillService.LOG_TAG, "Not handling " + message + " as service for " + RemoteFillService.this.mComponentName + " is already destroyed");
                        }
                        return;
                    }
                    switch (message.what) {
                        case 1: {
                            RemoteFillService.this.handleDestroy();
                            break;
                        }
                        case 2: {
                            RemoteFillService.this.handleBinderDied();
                            break;
                        }
                        case 3: {
                            RemoteFillService.this.handleUnbind();
                            break;
                        }
                        case 4: {
                            RemoteFillService.this.handlePendingRequest((PendingRequest)message.obj);
                        }
                    }
                }
            }, false);
        }
    }

    private class RemoteServiceConnection
    implements ServiceConnection {
        private RemoteServiceConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            if (RemoteFillService.this.mDestroyed || !RemoteFillService.this.mBinding) {
                RemoteFillService.this.mContext.unbindService(RemoteFillService.this.mServiceConnection);
                return;
            }
            RemoteFillService.this.mBinding = false;
            RemoteFillService.this.mAutoFillService = IAutoFillService.Stub.asInterface(service);
            try {
                service.linkToDeath(RemoteFillService.this, 0);
            }
            catch (RemoteException re) {
                RemoteFillService.this.handleBinderDied();
                return;
            }
            try {
                RemoteFillService.this.mAutoFillService.onConnectedStateChanged(true);
            }
            catch (RemoteException e) {
                Slog.w(RemoteFillService.LOG_TAG, "Exception calling onConnected(): " + e);
            }
            if (RemoteFillService.this.mPendingRequest != null) {
                PendingRequest pendingRequest = RemoteFillService.this.mPendingRequest;
                RemoteFillService.this.mPendingRequest = null;
                RemoteFillService.this.handlePendingRequest(pendingRequest);
            }
            RemoteFillService.this.mServiceDied = false;
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            RemoteFillService.this.mBinding = true;
            RemoteFillService.this.mAutoFillService = null;
        }
    }

    public static interface FillServiceCallbacks {
        public void onFillRequestSuccess(int var1, FillResponse var2, String var3);

        public void onFillRequestFailure(CharSequence var1, String var2);

        public void onSaveRequestSuccess(String var1, IntentSender var2);

        public void onSaveRequestFailure(CharSequence var1, String var2);

        public void onServiceDied(RemoteFillService var1);
    }
}

