/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill.ui;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.graphics.Point;
import android.graphics.Rect;
import android.service.autofill.Dataset;
import android.service.autofill.FillResponse;
import android.text.TextUtils;
import android.util.Slog;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.IAutofillWindowPresenter;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListView;
import android.widget.RemoteViews;
import com.android.server.UiThread;
import com.android.server.autofill.Helper;
import com.android.server.autofill.ui.OverlayControl;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import libcore.util.Objects;

final class FillUi {
    private static final String TAG = "FillUi";
    private static final int VISIBLE_OPTIONS_MAX_COUNT = 3;
    private static final TypedValue sTempTypedValue = new TypedValue();
    private final Point mTempPoint = new Point();
    private final AutofillWindowPresenter mWindowPresenter = new AutofillWindowPresenter();
    private final Context mContext;
    private final AnchoredWindow mWindow;
    private final Callback mCallback;
    private final ListView mListView;
    private final ItemsAdapter mAdapter;
    private String mFilterText;
    private AnnounceFilterResult mAnnounceFilterResult;
    private int mContentWidth;
    private int mContentHeight;
    private boolean mDestroyed;

    FillUi(Context context, FillResponse response, AutofillId focusedViewId, String filterText, OverlayControl overlayControl, Callback callback) {
        this.mContext = context;
        this.mCallback = callback;
        LayoutInflater inflater = LayoutInflater.from(context);
        ViewGroup decor = (ViewGroup)inflater.inflate(17367100, null);
        RemoteViews.OnClickHandler interceptionHandler = new RemoteViews.OnClickHandler(){

            @Override
            public boolean onClickHandler(View view, PendingIntent pendingIntent, Intent fillInIntent) {
                if (pendingIntent != null) {
                    FillUi.this.mCallback.startIntentSender(pendingIntent.getIntentSender());
                }
                return true;
            }
        };
        if (response.getAuthentication() != null) {
            View content;
            this.mListView = null;
            this.mAdapter = null;
            try {
                content = response.getPresentation().apply(context, decor, interceptionHandler);
                decor.addView(content);
            }
            catch (RuntimeException e) {
                callback.onCanceled();
                Slog.e(TAG, "Error inflating remote views", e);
                this.mWindow = null;
                return;
            }
            Point maxSize = this.mTempPoint;
            FillUi.resolveMaxWindowSize(context, maxSize);
            int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(maxSize.x, Integer.MIN_VALUE);
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(maxSize.y, Integer.MIN_VALUE);
            decor.measure(widthMeasureSpec, heightMeasureSpec);
            decor.setOnClickListener(v -> this.mCallback.onResponsePicked(response));
            this.mContentWidth = content.getMeasuredWidth();
            this.mContentHeight = content.getMeasuredHeight();
            this.mWindow = new AnchoredWindow(decor, overlayControl);
            this.mCallback.requestShowFillUi(this.mContentWidth, this.mContentHeight, this.mWindowPresenter);
        } else {
            int datasetCount;
            int totalItems = datasetCount = response.getDatasets().size();
            RemoteViews.OnClickHandler clickBlocker = null;
            RemoteViews headerPresentation = response.getHeader();
            View header = null;
            if (headerPresentation != null) {
                clickBlocker = this.newClickBlocker();
                header = headerPresentation.apply(context, null, clickBlocker);
                ++totalItems;
            }
            RemoteViews footerPresentation = response.getFooter();
            View footer = null;
            if (footerPresentation != null) {
                if (clickBlocker == null) {
                    clickBlocker = this.newClickBlocker();
                }
                footer = footerPresentation.apply(context, null, clickBlocker);
                ++totalItems;
            }
            if (Helper.sVerbose) {
                Slog.v(TAG, "Number datasets: " + datasetCount + " Total items: " + totalItems);
            }
            ArrayList<ViewItem> items = new ArrayList<ViewItem>(totalItems);
            if (header != null) {
                if (Helper.sVerbose) {
                    Slog.v(TAG, "adding header");
                }
                items.add(new ViewItem(null, null, false, null, header));
            }
            for (int i = 0; i < datasetCount; ++i) {
                View view2;
                Dataset dataset = response.getDatasets().get(i);
                int index = dataset.getFieldIds().indexOf(focusedViewId);
                if (index < 0) continue;
                RemoteViews presentation = dataset.getFieldPresentation(index);
                if (presentation == null) {
                    Slog.w(TAG, "not displaying UI on field " + focusedViewId + " because service didn't provide a presentation for it on " + dataset);
                    continue;
                }
                try {
                    if (Helper.sVerbose) {
                        Slog.v(TAG, "setting remote view for " + focusedViewId);
                    }
                    view2 = presentation.apply(context, null, interceptionHandler);
                }
                catch (RuntimeException e) {
                    Slog.e(TAG, "Error inflating remote views", e);
                    continue;
                }
                Dataset.DatasetFieldFilter filter = dataset.getFilter(index);
                Pattern filterPattern = null;
                String valueText = null;
                boolean filterable = true;
                if (filter == null) {
                    AutofillValue value = dataset.getFieldValues().get(index);
                    if (value != null && value.isText()) {
                        valueText = value.getTextValue().toString().toLowerCase();
                    }
                } else {
                    filterPattern = filter.pattern;
                    if (filterPattern == null) {
                        if (Helper.sVerbose) {
                            Slog.v(TAG, "Explicitly disabling filter at id " + focusedViewId + " for dataset #" + index);
                        }
                        filterable = false;
                    }
                }
                items.add(new ViewItem(dataset, filterPattern, filterable, valueText, view2));
            }
            if (footer != null) {
                if (Helper.sVerbose) {
                    Slog.v(TAG, "adding footer");
                }
                items.add(new ViewItem(null, null, false, null, footer));
            }
            this.mAdapter = new ItemsAdapter(items);
            this.mListView = (ListView)decor.findViewById(16908729);
            this.mListView.setAdapter(this.mAdapter);
            this.mListView.setVisibility(0);
            this.mListView.setOnItemClickListener((adapter, view, position, id2) -> {
                ViewItem vi = this.mAdapter.getItem(position);
                if (vi.dataset == null) {
                    if (Helper.sDebug) {
                        Slog.d(TAG, "Ignoring click on item " + position + ": " + view);
                    }
                    return;
                }
                this.mCallback.onDatasetPicked(vi.dataset);
            });
            this.mFilterText = filterText == null ? null : filterText.toLowerCase();
            this.applyNewFilterText();
            this.mWindow = new AnchoredWindow(decor, overlayControl);
        }
    }

    private RemoteViews.OnClickHandler newClickBlocker() {
        return new RemoteViews.OnClickHandler(){

            @Override
            public boolean onClickHandler(View view, PendingIntent pendingIntent, Intent fillInIntent) {
                if (Helper.sVerbose) {
                    Slog.v(FillUi.TAG, "Ignoring click on " + view);
                }
                return true;
            }
        };
    }

    private void applyNewFilterText() {
        int oldCount = this.mAdapter.getCount();
        this.mAdapter.getFilter().filter(this.mFilterText, count -> {
            if (this.mDestroyed) {
                return;
            }
            if (count <= 0) {
                if (Helper.sDebug) {
                    int size = this.mFilterText == null ? 0 : this.mFilterText.length();
                    Slog.d(TAG, "No dataset matches filter with " + size + " chars");
                }
                this.mCallback.requestHideFillUi();
            } else {
                if (this.updateContentSize()) {
                    this.mCallback.requestShowFillUi(this.mContentWidth, this.mContentHeight, this.mWindowPresenter);
                }
                if (this.mAdapter.getCount() > 3) {
                    this.mListView.setVerticalScrollBarEnabled(true);
                    this.mListView.onVisibilityAggregated(true);
                } else {
                    this.mListView.setVerticalScrollBarEnabled(false);
                }
                if (this.mAdapter.getCount() != oldCount) {
                    this.mListView.requestLayout();
                }
            }
        });
    }

    public void setFilterText(String filterText) {
        this.throwIfDestroyed();
        if (this.mAdapter == null) {
            if (TextUtils.isEmpty(filterText)) {
                this.mCallback.requestShowFillUi(this.mContentWidth, this.mContentHeight, this.mWindowPresenter);
            } else {
                this.mCallback.requestHideFillUi();
            }
            return;
        }
        if (Objects.equal(this.mFilterText, filterText = filterText == null ? null : filterText.toLowerCase())) {
            return;
        }
        this.mFilterText = filterText;
        this.applyNewFilterText();
    }

    public void destroy() {
        this.throwIfDestroyed();
        this.mCallback.onDestroy();
        this.mCallback.requestHideFillUi();
        this.mDestroyed = true;
    }

    private boolean updateContentSize() {
        if (this.mAdapter == null) {
            return false;
        }
        boolean changed = false;
        if (this.mAdapter.getCount() <= 0) {
            if (this.mContentWidth != 0) {
                this.mContentWidth = 0;
                changed = true;
            }
            if (this.mContentHeight != 0) {
                this.mContentHeight = 0;
                changed = true;
            }
            return changed;
        }
        Point maxSize = this.mTempPoint;
        FillUi.resolveMaxWindowSize(this.mContext, maxSize);
        this.mContentWidth = 0;
        this.mContentHeight = 0;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(maxSize.x, Integer.MIN_VALUE);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(maxSize.y, Integer.MIN_VALUE);
        int itemCount = this.mAdapter.getCount();
        for (int i = 0; i < itemCount; ++i) {
            int clampedMeasuredHeight;
            int newContentHeight;
            View view = this.mAdapter.getItem((int)i).view;
            view.measure(widthMeasureSpec, heightMeasureSpec);
            int clampedMeasuredWidth = Math.min(view.getMeasuredWidth(), maxSize.x);
            int newContentWidth = Math.max(this.mContentWidth, clampedMeasuredWidth);
            if (newContentWidth != this.mContentWidth) {
                this.mContentWidth = newContentWidth;
                changed = true;
            }
            if (i >= 3 || (newContentHeight = this.mContentHeight + (clampedMeasuredHeight = Math.min(view.getMeasuredHeight(), maxSize.y))) == this.mContentHeight) continue;
            this.mContentHeight = newContentHeight;
            changed = true;
        }
        return changed;
    }

    private void throwIfDestroyed() {
        if (this.mDestroyed) {
            throw new IllegalStateException("cannot interact with a destroyed instance");
        }
    }

    private static void resolveMaxWindowSize(Context context, Point outPoint) {
        context.getDisplay().getSize(outPoint);
        TypedValue typedValue = sTempTypedValue;
        context.getTheme().resolveAttribute(0x1110010, typedValue, true);
        outPoint.x = (int)typedValue.getFraction(outPoint.x, outPoint.x);
        context.getTheme().resolveAttribute(0x111000F, typedValue, true);
        outPoint.y = (int)typedValue.getFraction(outPoint.y, outPoint.y);
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mCallback: ");
        pw.println(this.mCallback != null);
        pw.print(prefix);
        pw.print("mListView: ");
        pw.println(this.mListView);
        pw.print(prefix);
        pw.print("mAdapter: ");
        pw.println(this.mAdapter);
        pw.print(prefix);
        pw.print("mFilterText: ");
        Helper.printlnRedactedText(pw, this.mFilterText);
        pw.print(prefix);
        pw.print("mContentWidth: ");
        pw.println(this.mContentWidth);
        pw.print(prefix);
        pw.print("mContentHeight: ");
        pw.println(this.mContentHeight);
        pw.print(prefix);
        pw.print("mDestroyed: ");
        pw.println(this.mDestroyed);
        pw.print(prefix);
        pw.print("mWindow: ");
        if (this.mWindow == null) {
            pw.println("N/A");
        } else {
            String prefix2 = prefix + "  ";
            pw.println();
            pw.print(prefix2);
            pw.print("showing: ");
            pw.println(this.mWindow.mShowing);
            pw.print(prefix2);
            pw.print("view: ");
            pw.println(this.mWindow.mContentView);
            pw.print(prefix2);
            pw.print("screen coordinates: ");
            if (this.mWindow.mContentView == null) {
                pw.println("N/A");
            } else {
                int[] coordinates = this.mWindow.mContentView.getLocationOnScreen();
                pw.print(coordinates[0]);
                pw.print("x");
                pw.println(coordinates[1]);
            }
        }
    }

    private void announceSearchResultIfNeeded() {
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            if (this.mAnnounceFilterResult == null) {
                this.mAnnounceFilterResult = new AnnounceFilterResult();
            }
            this.mAnnounceFilterResult.post();
        }
    }

    private final class AnnounceFilterResult
    implements Runnable {
        private static final int SEARCH_RESULT_ANNOUNCEMENT_DELAY = 1000;

        private AnnounceFilterResult() {
        }

        public void post() {
            this.remove();
            FillUi.this.mListView.postDelayed(this, 1000L);
        }

        public void remove() {
            FillUi.this.mListView.removeCallbacks(this);
        }

        @Override
        public void run() {
            int count = FillUi.this.mListView.getAdapter().getCount();
            String text = count <= 0 ? FillUi.this.mContext.getString(17039544) : FillUi.this.mContext.getResources().getQuantityString(0x1150000, count, count);
            FillUi.this.mListView.announceForAccessibility(text);
        }
    }

    private final class ItemsAdapter
    extends BaseAdapter
    implements Filterable {
        private final List<ViewItem> mAllItems;
        private final List<ViewItem> mFilteredItems = new ArrayList<ViewItem>();

        ItemsAdapter(List<ViewItem> items) {
            this.mAllItems = Collections.unmodifiableList(new ArrayList<ViewItem>(items));
            this.mFilteredItems.addAll(items);
        }

        @Override
        public Filter getFilter() {
            return new Filter(){

                @Override
                protected Filter.FilterResults performFiltering(CharSequence filterText) {
                    List filtered = ItemsAdapter.this.mAllItems.stream().filter((? super T item) -> item.matches(filterText)).collect(Collectors.toList());
                    Filter.FilterResults results = new Filter.FilterResults();
                    results.values = filtered;
                    results.count = filtered.size();
                    return results;
                }

                @Override
                protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                    boolean resultCountChanged;
                    int oldItemCount = ItemsAdapter.this.mFilteredItems.size();
                    ItemsAdapter.this.mFilteredItems.clear();
                    if (results.count > 0) {
                        List items = (List)results.values;
                        ItemsAdapter.this.mFilteredItems.addAll(items);
                    }
                    boolean bl = resultCountChanged = oldItemCount != ItemsAdapter.this.mFilteredItems.size();
                    if (resultCountChanged) {
                        FillUi.this.announceSearchResultIfNeeded();
                    }
                    ItemsAdapter.this.notifyDataSetChanged();
                }
            };
        }

        @Override
        public int getCount() {
            return this.mFilteredItems.size();
        }

        @Override
        public ViewItem getItem(int position) {
            return this.mFilteredItems.get(position);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            return this.getItem((int)position).view;
        }

        public String toString() {
            return "ItemsAdapter: [all=" + this.mAllItems + ", filtered=" + this.mFilteredItems + "]";
        }
    }

    final class AnchoredWindow
    implements View.OnTouchListener {
        private final OverlayControl mOverlayControl;
        private final WindowManager mWm;
        private final View mContentView;
        private boolean mShowing;

        AnchoredWindow(View contentView, OverlayControl overlayControl) {
            this.mWm = contentView.getContext().getSystemService(WindowManager.class);
            this.mContentView = contentView;
            this.mOverlayControl = overlayControl;
        }

        public void show(WindowManager.LayoutParams params) {
            if (Helper.sVerbose) {
                Slog.v(FillUi.TAG, "show(): showing=" + this.mShowing + ", params=" + params);
            }
            try {
                params.type = 2008;
                params.token = null;
                params.packageName = "android";
                params.flags |= 0x100;
                if (!this.mShowing) {
                    params.accessibilityTitle = this.mContentView.getContext().getString(17039543);
                    this.mWm.addView(this.mContentView, params);
                    this.mContentView.setOnTouchListener(this);
                    this.mOverlayControl.hideOverlays();
                    this.mShowing = true;
                } else {
                    this.mWm.updateViewLayout(this.mContentView, params);
                }
            }
            catch (WindowManager.BadTokenException e) {
                if (Helper.sDebug) {
                    Slog.d(FillUi.TAG, "Filed with with token " + params.token + " gone.");
                }
                FillUi.this.mCallback.onDestroy();
            }
            catch (IllegalStateException e) {
                Slog.e(FillUi.TAG, "Exception showing window " + params, e);
                FillUi.this.mCallback.onDestroy();
            }
        }

        void hide() {
            try {
                if (this.mShowing) {
                    this.mContentView.setOnTouchListener(null);
                    this.mWm.removeView(this.mContentView);
                    this.mShowing = false;
                }
            }
            catch (IllegalStateException e) {
                Slog.e(FillUi.TAG, "Exception hiding window ", e);
                FillUi.this.mCallback.onDestroy();
            }
            finally {
                this.mOverlayControl.showOverlays();
            }
        }

        @Override
        public boolean onTouch(View view, MotionEvent event) {
            if (view == this.mContentView && event.getAction() == 4) {
                FillUi.this.mCallback.onCanceled();
                return true;
            }
            return false;
        }
    }

    private final class AutofillWindowPresenter
    extends IAutofillWindowPresenter.Stub {
        private AutofillWindowPresenter() {
        }

        @Override
        public void show(WindowManager.LayoutParams p, Rect transitionEpicenter, boolean fitsSystemWindows, int layoutDirection) {
            if (Helper.sVerbose) {
                Slog.v(FillUi.TAG, "AutofillWindowPresenter.show(): fit=" + fitsSystemWindows + ", epicenter=" + transitionEpicenter + ", dir=" + layoutDirection + ", params=" + p);
            }
            UiThread.getHandler().post(() -> FillUi.this.mWindow.show(p));
        }

        @Override
        public void hide(Rect transitionEpicenter) {
            UiThread.getHandler().post(FillUi.this.mWindow::hide);
        }
    }

    private static class ViewItem {
        public final String value;
        public final Dataset dataset;
        public final View view;
        public final Pattern filter;
        public final boolean filterable;

        ViewItem(Dataset dataset, Pattern filter, boolean filterable, String value, View view) {
            this.dataset = dataset;
            this.value = value;
            this.view = view;
            this.filter = filter;
            this.filterable = filterable;
        }

        public boolean matches(CharSequence filterText) {
            if (TextUtils.isEmpty(filterText)) {
                return true;
            }
            if (!this.filterable) {
                return false;
            }
            String constraintLowerCase = filterText.toString().toLowerCase();
            if (this.filter != null) {
                return this.filter.matcher(constraintLowerCase).matches();
            }
            return this.value == null ? this.dataset.getAuthentication() == null : this.value.toLowerCase().startsWith(constraintLowerCase);
        }

        public String toString() {
            return "ViewItem: [dataset=" + (this.dataset == null ? "null" : this.dataset.getId()) + ", value=" + (this.value == null ? "null" : this.value.length() + "_chars") + ", filterable=" + this.filterable + ", filter=" + (this.filter == null ? "null" : this.filter.pattern().length() + "_chars") + ", view=" + this.view.getAutofillId() + "]";
        }
    }

    static interface Callback {
        public void onResponsePicked(FillResponse var1);

        public void onDatasetPicked(Dataset var1);

        public void onCanceled();

        public void onDestroy();

        public void requestShowFillUi(int var1, int var2, IAutofillWindowPresenter var3);

        public void requestHideFillUi();

        public void startIntentSender(IntentSender var1);
    }
}

