/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.KeyValueListParser;
import android.util.Slog;

class BackupManagerConstants
extends ContentObserver {
    private static final String TAG = "BackupManagerConstants";
    private static final String KEY_VALUE_BACKUP_INTERVAL_MILLISECONDS = "key_value_backup_interval_milliseconds";
    private static final String KEY_VALUE_BACKUP_FUZZ_MILLISECONDS = "key_value_backup_fuzz_milliseconds";
    private static final String KEY_VALUE_BACKUP_REQUIRE_CHARGING = "key_value_backup_require_charging";
    private static final String KEY_VALUE_BACKUP_REQUIRED_NETWORK_TYPE = "key_value_backup_required_network_type";
    private static final String FULL_BACKUP_INTERVAL_MILLISECONDS = "full_backup_interval_milliseconds";
    private static final String FULL_BACKUP_REQUIRE_CHARGING = "full_backup_require_charging";
    private static final String FULL_BACKUP_REQUIRED_NETWORK_TYPE = "full_backup_required_network_type";
    private static final String BACKUP_FINISHED_NOTIFICATION_RECEIVERS = "backup_finished_notification_receivers";
    private static final long DEFAULT_KEY_VALUE_BACKUP_INTERVAL_MILLISECONDS = 14400000L;
    private static final long DEFAULT_KEY_VALUE_BACKUP_FUZZ_MILLISECONDS = 600000L;
    private static final boolean DEFAULT_KEY_VALUE_BACKUP_REQUIRE_CHARGING = true;
    private static final int DEFAULT_KEY_VALUE_BACKUP_REQUIRED_NETWORK_TYPE = 1;
    private static final long DEFAULT_FULL_BACKUP_INTERVAL_MILLISECONDS = 86400000L;
    private static final boolean DEFAULT_FULL_BACKUP_REQUIRE_CHARGING = true;
    private static final int DEFAULT_FULL_BACKUP_REQUIRED_NETWORK_TYPE = 2;
    private static final String DEFAULT_BACKUP_FINISHED_NOTIFICATION_RECEIVERS = "";
    private long mKeyValueBackupIntervalMilliseconds;
    private long mKeyValueBackupFuzzMilliseconds;
    private boolean mKeyValueBackupRequireCharging;
    private int mKeyValueBackupRequiredNetworkType;
    private long mFullBackupIntervalMilliseconds;
    private boolean mFullBackupRequireCharging;
    private int mFullBackupRequiredNetworkType;
    private String[] mBackupFinishedNotificationReceivers;
    private ContentResolver mResolver;
    private final KeyValueListParser mParser = new KeyValueListParser(',');

    public BackupManagerConstants(Handler handler, ContentResolver resolver) {
        super(handler);
        this.mResolver = resolver;
        this.updateSettings();
        this.mResolver.registerContentObserver(Settings.Secure.getUriFor("backup_manager_constants"), false, this);
    }

    @Override
    public void onChange(boolean selfChange, Uri uri) {
        this.updateSettings();
    }

    private synchronized void updateSettings() {
        try {
            this.mParser.setString(Settings.Secure.getString(this.mResolver, "backup_manager_constants"));
        }
        catch (IllegalArgumentException e) {
            Slog.e(TAG, "Bad backup manager constants: " + e.getMessage());
        }
        this.mKeyValueBackupIntervalMilliseconds = this.mParser.getLong(KEY_VALUE_BACKUP_INTERVAL_MILLISECONDS, 14400000L);
        this.mKeyValueBackupFuzzMilliseconds = this.mParser.getLong(KEY_VALUE_BACKUP_FUZZ_MILLISECONDS, 600000L);
        this.mKeyValueBackupRequireCharging = this.mParser.getBoolean(KEY_VALUE_BACKUP_REQUIRE_CHARGING, true);
        this.mKeyValueBackupRequiredNetworkType = this.mParser.getInt(KEY_VALUE_BACKUP_REQUIRED_NETWORK_TYPE, 1);
        this.mFullBackupIntervalMilliseconds = this.mParser.getLong(FULL_BACKUP_INTERVAL_MILLISECONDS, 86400000L);
        this.mFullBackupRequireCharging = this.mParser.getBoolean(FULL_BACKUP_REQUIRE_CHARGING, true);
        this.mFullBackupRequiredNetworkType = this.mParser.getInt(FULL_BACKUP_REQUIRED_NETWORK_TYPE, 2);
        String backupFinishedNotificationReceivers = this.mParser.getString(BACKUP_FINISHED_NOTIFICATION_RECEIVERS, DEFAULT_BACKUP_FINISHED_NOTIFICATION_RECEIVERS);
        this.mBackupFinishedNotificationReceivers = backupFinishedNotificationReceivers.isEmpty() ? new String[0] : backupFinishedNotificationReceivers.split(":");
    }

    public synchronized long getKeyValueBackupIntervalMilliseconds() {
        Slog.v(TAG, "getKeyValueBackupIntervalMilliseconds(...) returns " + this.mKeyValueBackupIntervalMilliseconds);
        return this.mKeyValueBackupIntervalMilliseconds;
    }

    public synchronized long getKeyValueBackupFuzzMilliseconds() {
        Slog.v(TAG, "getKeyValueBackupFuzzMilliseconds(...) returns " + this.mKeyValueBackupFuzzMilliseconds);
        return this.mKeyValueBackupFuzzMilliseconds;
    }

    public synchronized boolean getKeyValueBackupRequireCharging() {
        Slog.v(TAG, "getKeyValueBackupRequireCharging(...) returns " + this.mKeyValueBackupRequireCharging);
        return this.mKeyValueBackupRequireCharging;
    }

    public synchronized int getKeyValueBackupRequiredNetworkType() {
        Slog.v(TAG, "getKeyValueBackupRequiredNetworkType(...) returns " + this.mKeyValueBackupRequiredNetworkType);
        return this.mKeyValueBackupRequiredNetworkType;
    }

    public synchronized long getFullBackupIntervalMilliseconds() {
        Slog.v(TAG, "getFullBackupIntervalMilliseconds(...) returns " + this.mFullBackupIntervalMilliseconds);
        return this.mFullBackupIntervalMilliseconds;
    }

    public synchronized boolean getFullBackupRequireCharging() {
        Slog.v(TAG, "getFullBackupRequireCharging(...) returns " + this.mFullBackupRequireCharging);
        return this.mFullBackupRequireCharging;
    }

    public synchronized int getFullBackupRequiredNetworkType() {
        Slog.v(TAG, "getFullBackupRequiredNetworkType(...) returns " + this.mFullBackupRequiredNetworkType);
        return this.mFullBackupRequiredNetworkType;
    }

    public synchronized String[] getBackupFinishedNotificationReceivers() {
        Slog.v(TAG, "getBackupFinishedNotificationReceivers(...) returns " + TextUtils.join((CharSequence)", ", this.mBackupFinishedNotificationReceivers));
        return this.mBackupFinishedNotificationReceivers;
    }
}

