/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.AppGlobals;
import android.app.backup.BlobBackupHelper;
import android.content.pm.IPackageManager;
import android.util.Slog;

public class PermissionBackupHelper
extends BlobBackupHelper {
    private static final String TAG = "PermissionBackup";
    private static final boolean DEBUG = false;
    private static final int STATE_VERSION = 1;
    private static final String KEY_PERMISSIONS = "permissions";

    public PermissionBackupHelper() {
        super(1, KEY_PERMISSIONS);
    }

    @Override
    protected byte[] getBackupPayload(String key) {
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            switch (key) {
                case "permissions": {
                    return pm.getPermissionGrantBackup(0);
                }
            }
            Slog.w(TAG, "Unexpected backup key " + key);
        }
        catch (Exception e) {
            Slog.e(TAG, "Unable to store payload " + key);
        }
        return null;
    }

    @Override
    protected void applyRestoredPayload(String key, byte[] payload) {
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            switch (key) {
                case "permissions": {
                    pm.restorePermissionGrants(payload, 0);
                    break;
                }
                default: {
                    Slog.w(TAG, "Unexpected restore key " + key);
                    break;
                }
            }
        }
        catch (Exception e) {
            Slog.w(TAG, "Unable to restore key " + key);
        }
    }
}

