/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.fullbackup;

import android.app.IBackupAgent;
import android.app.backup.FullBackup;
import android.app.backup.FullBackupDataOutput;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Slog;
import android.util.StringBuilderPrinter;
import com.android.server.AppWidgetBackupBridge;
import com.android.server.backup.BackupManagerService;
import com.android.server.backup.BackupRestoreTask;
import com.android.server.backup.fullbackup.FullBackupPreflight;
import com.android.server.backup.utils.FullBackupUtils;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FullBackupEngine {
    private BackupManagerService backupManagerService;
    OutputStream mOutput;
    FullBackupPreflight mPreflightHook;
    BackupRestoreTask mTimeoutMonitor;
    IBackupAgent mAgent;
    File mFilesDir;
    File mManifestFile;
    File mMetadataFile;
    boolean mIncludeApks;
    PackageInfo mPkg;
    private final long mQuota;
    private final int mOpToken;
    private final int mTransportFlags;

    public FullBackupEngine(BackupManagerService backupManagerService, OutputStream output, FullBackupPreflight preflightHook, PackageInfo pkg, boolean alsoApks, BackupRestoreTask timeoutMonitor, long quota, int opToken, int transportFlags) {
        this.backupManagerService = backupManagerService;
        this.mOutput = output;
        this.mPreflightHook = preflightHook;
        this.mPkg = pkg;
        this.mIncludeApks = alsoApks;
        this.mTimeoutMonitor = timeoutMonitor;
        this.mFilesDir = new File("/data/system");
        this.mManifestFile = new File(this.mFilesDir, "_manifest");
        this.mMetadataFile = new File(this.mFilesDir, "_meta");
        this.mQuota = quota;
        this.mOpToken = opToken;
        this.mTransportFlags = transportFlags;
    }

    public int preflightCheck() throws RemoteException {
        if (this.mPreflightHook == null) {
            return 0;
        }
        if (this.initializeAgent()) {
            int result = this.mPreflightHook.preflightFullBackup(this.mPkg, this.mAgent);
            return result;
        }
        Slog.w("BackupManagerService", "Unable to bind to full agent for " + this.mPkg.packageName);
        return -1003;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int backupOnePackage() throws RemoteException {
        int result = -1003;
        if (this.initializeAgent()) {
            ParcelFileDescriptor[] pipes = null;
            try {
                pipes = ParcelFileDescriptor.createPipe();
                ApplicationInfo app = this.mPkg.applicationInfo;
                boolean isSharedStorage = this.mPkg.packageName.equals("com.android.sharedstoragebackup");
                boolean sendApk = this.mIncludeApks && !isSharedStorage && (app.privateFlags & 4) == 0 && ((app.flags & 1) == 0 || (app.flags & 0x80) != 0);
                byte[] widgetBlob = AppWidgetBackupBridge.getWidgetState(this.mPkg.packageName, 0);
                FullBackupRunner runner = new FullBackupRunner(this.mPkg, this.mAgent, pipes[1], this.mOpToken, sendApk, !isSharedStorage, widgetBlob);
                pipes[1].close();
                pipes[1] = null;
                Thread t = new Thread((Runnable)runner, "app-data-runner");
                t.start();
                FullBackupUtils.routeSocketDataToOutput(pipes[0], this.mOutput);
                if (!this.backupManagerService.waitUntilOperationComplete(this.mOpToken)) {
                    Slog.e("BackupManagerService", "Full backup failed on package " + this.mPkg.packageName);
                }
                result = 0;
            }
            catch (IOException e) {
                Slog.e("BackupManagerService", "Error backing up " + this.mPkg.packageName + ": " + e.getMessage());
                result = -1003;
            }
            finally {
                try {
                    this.mOutput.flush();
                    if (pipes != null) {
                        if (pipes[0] != null) {
                            pipes[0].close();
                        }
                        if (pipes[1] != null) {
                            pipes[1].close();
                        }
                    }
                }
                catch (IOException e) {
                    Slog.w("BackupManagerService", "Error bringing down backup stack");
                    result = -1000;
                }
            }
        } else {
            Slog.w("BackupManagerService", "Unable to bind to full agent for " + this.mPkg.packageName);
        }
        this.tearDown();
        return result;
    }

    public void sendQuotaExceeded(long backupDataBytes, long quotaBytes) {
        if (this.initializeAgent()) {
            try {
                this.mAgent.doQuotaExceeded(backupDataBytes, quotaBytes);
            }
            catch (RemoteException e) {
                Slog.e("BackupManagerService", "Remote exception while telling agent about quota exceeded");
            }
        }
    }

    private boolean initializeAgent() {
        if (this.mAgent == null) {
            this.mAgent = this.backupManagerService.bindToAgentSynchronous(this.mPkg.applicationInfo, 1);
        }
        return this.mAgent != null;
    }

    private void writeApkToBackup(PackageInfo pkg, FullBackupDataOutput output) {
        File[] obbFiles;
        String appSourceDir = pkg.applicationInfo.getBaseCodePath();
        String apkDir = new File(appSourceDir).getParent();
        FullBackup.backupToTar(pkg.packageName, "a", null, apkDir, appSourceDir, output);
        Environment.UserEnvironment userEnv = new Environment.UserEnvironment(0);
        File obbDir = userEnv.buildExternalStorageAppObbDirs(pkg.packageName)[0];
        if (obbDir != null && (obbFiles = obbDir.listFiles()) != null) {
            String obbDirName = obbDir.getAbsolutePath();
            for (File obb : obbFiles) {
                FullBackup.backupToTar(pkg.packageName, "obb", null, obbDirName, obb.getAbsolutePath(), output);
            }
        }
    }

    private void writeMetadata(PackageInfo pkg, File destination, byte[] widgetData) throws IOException {
        StringBuilder b = new StringBuilder(512);
        StringBuilderPrinter printer = new StringBuilderPrinter(b);
        printer.println(Integer.toString(1));
        printer.println(pkg.packageName);
        FileOutputStream fout = new FileOutputStream(destination);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        DataOutputStream out = new DataOutputStream(bout);
        bout.write(b.toString().getBytes());
        if (widgetData != null && widgetData.length > 0) {
            out.writeInt(33549569);
            out.writeInt(widgetData.length);
            out.write(widgetData);
        }
        bout.flush();
        out.close();
        destination.setLastModified(0L);
    }

    private void tearDown() {
        if (this.mPkg != null) {
            this.backupManagerService.tearDownAgentAndKill(this.mPkg.applicationInfo);
        }
    }

    class FullBackupRunner
    implements Runnable {
        PackageInfo mPackage;
        byte[] mWidgetData;
        IBackupAgent mAgent;
        ParcelFileDescriptor mPipe;
        int mToken;
        boolean mSendApk;
        boolean mWriteManifest;

        FullBackupRunner(PackageInfo pack, IBackupAgent agent, ParcelFileDescriptor pipe, int token, boolean sendApk, boolean writeManifest, byte[] widgetData) throws IOException {
            this.mPackage = pack;
            this.mWidgetData = widgetData;
            this.mAgent = agent;
            this.mPipe = ParcelFileDescriptor.dup(pipe.getFileDescriptor());
            this.mToken = token;
            this.mSendApk = sendApk;
            this.mWriteManifest = writeManifest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean isSharedStorage;
                FullBackupDataOutput output = new FullBackupDataOutput(this.mPipe, -1L, FullBackupEngine.this.mTransportFlags);
                if (this.mWriteManifest) {
                    boolean writeWidgetData = this.mWidgetData != null;
                    FullBackupUtils.writeAppManifest(this.mPackage, FullBackupEngine.this.backupManagerService.getPackageManager(), FullBackupEngine.this.mManifestFile, this.mSendApk, writeWidgetData);
                    FullBackup.backupToTar(this.mPackage.packageName, null, null, FullBackupEngine.this.mFilesDir.getAbsolutePath(), FullBackupEngine.this.mManifestFile.getAbsolutePath(), output);
                    FullBackupEngine.this.mManifestFile.delete();
                    if (writeWidgetData) {
                        FullBackupEngine.this.writeMetadata(this.mPackage, FullBackupEngine.this.mMetadataFile, this.mWidgetData);
                        FullBackup.backupToTar(this.mPackage.packageName, null, null, FullBackupEngine.this.mFilesDir.getAbsolutePath(), FullBackupEngine.this.mMetadataFile.getAbsolutePath(), output);
                        FullBackupEngine.this.mMetadataFile.delete();
                    }
                }
                if (this.mSendApk) {
                    FullBackupEngine.this.writeApkToBackup(this.mPackage, output);
                }
                long timeout = (isSharedStorage = this.mPackage.packageName.equals("com.android.sharedstoragebackup")) ? 1800000L : 300000L;
                Slog.d("BackupManagerService", "Calling doFullBackup() on " + this.mPackage.packageName);
                FullBackupEngine.this.backupManagerService.prepareOperationTimeout(this.mToken, timeout, FullBackupEngine.this.mTimeoutMonitor, 0);
                this.mAgent.doFullBackup(this.mPipe, FullBackupEngine.this.mQuota, this.mToken, FullBackupEngine.this.backupManagerService.getBackupManagerBinder(), FullBackupEngine.this.mTransportFlags);
            }
            catch (IOException e) {
                Slog.e("BackupManagerService", "Error running full backup for " + this.mPackage.packageName);
            }
            catch (RemoteException e) {
                Slog.e("BackupManagerService", "Remote agent vanished during full backup of " + this.mPackage.packageName);
            }
            finally {
                try {
                    this.mPipe.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

