/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.fullbackup;

import android.app.backup.IFullBackupRestoreObserver;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.AppWidgetBackupBridge;
import com.android.server.backup.BackupManagerService;
import com.android.server.backup.BackupRestoreTask;
import com.android.server.backup.KeyValueAdbBackupEngine;
import com.android.server.backup.fullbackup.FullBackupEngine;
import com.android.server.backup.fullbackup.FullBackupObbConnection;
import com.android.server.backup.fullbackup.FullBackupTask;
import com.android.server.backup.utils.AppBackupUtils;
import com.android.server.backup.utils.PasswordUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class PerformAdbBackupTask
extends FullBackupTask
implements BackupRestoreTask {
    private BackupManagerService backupManagerService;
    FullBackupEngine mBackupEngine;
    final AtomicBoolean mLatch;
    ParcelFileDescriptor mOutputFile;
    DeflaterOutputStream mDeflater;
    boolean mIncludeApks;
    boolean mIncludeObbs;
    boolean mIncludeShared;
    boolean mDoWidgets;
    boolean mAllApps;
    boolean mIncludeSystem;
    boolean mCompress;
    boolean mKeyValue;
    ArrayList<String> mPackages;
    PackageInfo mCurrentTarget;
    String mCurrentPassword;
    String mEncryptPassword;
    private final int mCurrentOpToken;

    public PerformAdbBackupTask(BackupManagerService backupManagerService, ParcelFileDescriptor fd, IFullBackupRestoreObserver observer, boolean includeApks, boolean includeObbs, boolean includeShared, boolean doWidgets, String curPassword, String encryptPassword, boolean doAllApps, boolean doSystem, boolean doCompress, boolean doKeyValue, String[] packages, AtomicBoolean latch) {
        super(observer);
        this.backupManagerService = backupManagerService;
        this.mCurrentOpToken = backupManagerService.generateRandomIntegerToken();
        this.mLatch = latch;
        this.mOutputFile = fd;
        this.mIncludeApks = includeApks;
        this.mIncludeObbs = includeObbs;
        this.mIncludeShared = includeShared;
        this.mDoWidgets = doWidgets;
        this.mAllApps = doAllApps;
        this.mIncludeSystem = doSystem;
        this.mPackages = packages == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(packages));
        this.mCurrentPassword = curPassword;
        this.mEncryptPassword = encryptPassword == null || "".equals(encryptPassword) ? curPassword : encryptPassword;
        this.mCompress = doCompress;
        this.mKeyValue = doKeyValue;
    }

    void addPackagesToSet(TreeMap<String, PackageInfo> set, List<String> pkgNames) {
        for (String pkgName : pkgNames) {
            if (set.containsKey(pkgName)) continue;
            try {
                PackageInfo info = this.backupManagerService.getPackageManager().getPackageInfo(pkgName, 64);
                set.put(pkgName, info);
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.w("BackupManagerService", "Unknown package " + pkgName + ", skipping");
            }
        }
    }

    private OutputStream emitAesBackupHeader(StringBuilder headerbuf, OutputStream ofstream) throws Exception {
        byte[] newUserSalt = this.backupManagerService.randomBytes(512);
        SecretKey userKey = PasswordUtils.buildPasswordKey("PBKDF2WithHmacSHA1", this.mEncryptPassword, newUserSalt, 10000);
        byte[] masterPw = new byte[32];
        this.backupManagerService.getRng().nextBytes(masterPw);
        byte[] checksumSalt = this.backupManagerService.randomBytes(512);
        Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec masterKeySpec = new SecretKeySpec(masterPw, "AES");
        c.init(1, masterKeySpec);
        CipherOutputStream finalOutput = new CipherOutputStream(ofstream, c);
        headerbuf.append("AES-256");
        headerbuf.append('\n');
        headerbuf.append(PasswordUtils.byteArrayToHex(newUserSalt));
        headerbuf.append('\n');
        headerbuf.append(PasswordUtils.byteArrayToHex(checksumSalt));
        headerbuf.append('\n');
        headerbuf.append(10000);
        headerbuf.append('\n');
        Cipher mkC = Cipher.getInstance("AES/CBC/PKCS5Padding");
        mkC.init(1, userKey);
        byte[] IV = mkC.getIV();
        headerbuf.append(PasswordUtils.byteArrayToHex(IV));
        headerbuf.append('\n');
        IV = c.getIV();
        byte[] mk = masterKeySpec.getEncoded();
        byte[] checksum = PasswordUtils.makeKeyChecksum("PBKDF2WithHmacSHA1", masterKeySpec.getEncoded(), checksumSalt, 10000);
        ByteArrayOutputStream blob = new ByteArrayOutputStream(IV.length + mk.length + checksum.length + 3);
        DataOutputStream mkOut = new DataOutputStream(blob);
        mkOut.writeByte(IV.length);
        mkOut.write(IV);
        mkOut.writeByte(mk.length);
        mkOut.write(mk);
        mkOut.writeByte(checksum.length);
        mkOut.write(checksum);
        mkOut.flush();
        byte[] encryptedMk = mkC.doFinal(blob.toByteArray());
        headerbuf.append(PasswordUtils.byteArrayToHex(encryptedMk));
        headerbuf.append('\n');
        return finalOutput;
    }

    private void finalizeBackup(OutputStream out) {
        try {
            byte[] eof = new byte[1024];
            out.write(eof);
        }
        catch (IOException e) {
            Slog.w("BackupManagerService", "Error attempting to finalize backup stream");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<String> pkgs;
        PackageInfo pkg;
        String includeKeyValue = this.mKeyValue ? ", including key-value backups" : "";
        Slog.i("BackupManagerService", "--- Performing adb backup" + includeKeyValue + " ---");
        TreeMap<String, PackageInfo> packagesToBackup = new TreeMap<String, PackageInfo>();
        FullBackupObbConnection obbConnection = new FullBackupObbConnection(this.backupManagerService);
        obbConnection.establish();
        this.sendStartBackup();
        PackageManager pm = this.backupManagerService.getPackageManager();
        if (this.mAllApps) {
            List<PackageInfo> allPackages = pm.getInstalledPackages(64);
            for (int i = 0; i < allPackages.size(); ++i) {
                pkg = allPackages.get(i);
                if (!this.mIncludeSystem && (pkg.applicationInfo.flags & 1) != 0) continue;
                packagesToBackup.put(pkg.packageName, pkg);
            }
        }
        if (this.mDoWidgets && (pkgs = AppWidgetBackupBridge.getWidgetParticipants(0)) != null) {
            this.addPackagesToSet(packagesToBackup, pkgs);
        }
        if (this.mPackages != null) {
            this.addPackagesToSet(packagesToBackup, this.mPackages);
        }
        ArrayList<PackageInfo> keyValueBackupQueue = new ArrayList<PackageInfo>();
        Iterator<Map.Entry<String, PackageInfo>> iter = packagesToBackup.entrySet().iterator();
        while (iter.hasNext()) {
            pkg = iter.next().getValue();
            if (!AppBackupUtils.appIsEligibleForBackup(pkg.applicationInfo, pm) || AppBackupUtils.appIsStopped(pkg.applicationInfo)) {
                iter.remove();
                Slog.i("BackupManagerService", "Package " + pkg.packageName + " is not eligible for backup, removing.");
                continue;
            }
            if (!AppBackupUtils.appIsKeyValueOnly(pkg)) continue;
            iter.remove();
            Slog.i("BackupManagerService", "Package " + pkg.packageName + " is key-value.");
            keyValueBackupQueue.add(pkg);
        }
        ArrayList<PackageInfo> backupQueue = new ArrayList<PackageInfo>(packagesToBackup.values());
        FileOutputStream ofstream = new FileOutputStream(this.mOutputFile.getFileDescriptor());
        OutputStream out = null;
        PackageInfo pkg2 = null;
        try {
            boolean encrypting;
            boolean bl = encrypting = this.mEncryptPassword != null && this.mEncryptPassword.length() > 0;
            if (this.backupManagerService.deviceIsEncrypted() && !encrypting) {
                Slog.e("BackupManagerService", "Unencrypted backup of encrypted device; aborting");
                return;
            }
            OutputStream finalOutput = ofstream;
            if (!this.backupManagerService.backupPasswordMatches(this.mCurrentPassword)) {
                Slog.w("BackupManagerService", "Backup password mismatch; aborting");
                return;
            }
            StringBuilder headerbuf = new StringBuilder(1024);
            headerbuf.append("ANDROID BACKUP\n");
            headerbuf.append(5);
            headerbuf.append(this.mCompress ? "\n1\n" : "\n0\n");
            try {
                if (encrypting) {
                    finalOutput = this.emitAesBackupHeader(headerbuf, finalOutput);
                } else {
                    headerbuf.append("none\n");
                }
                byte[] header = headerbuf.toString().getBytes("UTF-8");
                ofstream.write(header);
                if (this.mCompress) {
                    Deflater deflater = new Deflater(9);
                    finalOutput = new DeflaterOutputStream(finalOutput, deflater, true);
                }
                out = finalOutput;
            }
            catch (Exception e) {
                Slog.e("BackupManagerService", "Unable to emit archive header", e);
                try {
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                    this.mOutputFile.close();
                }
                catch (IOException e2) {
                    Slog.e("BackupManagerService", "IO error closing adb backup file: " + e2.getMessage());
                }
                AtomicBoolean e2 = this.mLatch;
                synchronized (e2) {
                    this.mLatch.set(true);
                    this.mLatch.notifyAll();
                }
                this.sendEndBackup();
                obbConnection.tearDown();
                Slog.d("BackupManagerService", "Full backup pass complete.");
                this.backupManagerService.getWakelock().release();
                return;
            }
            if (this.mIncludeShared) {
                try {
                    pkg2 = this.backupManagerService.getPackageManager().getPackageInfo("com.android.sharedstoragebackup", 0);
                    backupQueue.add(pkg2);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Slog.e("BackupManagerService", "Unable to find shared-storage backup handler");
                }
            }
            int N = backupQueue.size();
            for (int i = 0; i < N; ++i) {
                boolean obbOkay;
                pkg2 = backupQueue.get(i);
                Slog.i("BackupManagerService", "--- Performing full backup for package " + pkg2.packageName + " ---");
                boolean isSharedStorage = pkg2.packageName.equals("com.android.sharedstoragebackup");
                this.mBackupEngine = new FullBackupEngine(this.backupManagerService, out, null, pkg2, this.mIncludeApks, this, Long.MAX_VALUE, this.mCurrentOpToken, 0);
                this.sendOnBackupPackage(isSharedStorage ? "Shared storage" : pkg2.packageName);
                this.mCurrentTarget = pkg2;
                this.mBackupEngine.backupOnePackage();
                if (!this.mIncludeObbs || (obbOkay = obbConnection.backupObbs(pkg2, out))) continue;
                throw new RuntimeException("Failure writing OBB stack for " + pkg2);
            }
            if (this.mKeyValue) {
                for (PackageInfo keyValuePackage : keyValueBackupQueue) {
                    Slog.i("BackupManagerService", "--- Performing key-value backup for package " + keyValuePackage.packageName + " ---");
                    KeyValueAdbBackupEngine kvBackupEngine = new KeyValueAdbBackupEngine(out, keyValuePackage, this.backupManagerService, this.backupManagerService.getPackageManager(), this.backupManagerService.getBaseStateDir(), this.backupManagerService.getDataDir());
                    this.sendOnBackupPackage(keyValuePackage.packageName);
                    kvBackupEngine.backupOnePackage();
                }
            }
            this.finalizeBackup(out);
        }
        catch (RemoteException e) {
            Slog.e("BackupManagerService", "App died during full backup");
        }
        catch (Exception e) {
            Slog.e("BackupManagerService", "Internal exception during full backup", e);
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
                this.mOutputFile.close();
            }
            catch (IOException e) {
                Slog.e("BackupManagerService", "IO error closing adb backup file: " + e.getMessage());
            }
            AtomicBoolean e = this.mLatch;
            synchronized (e) {
                this.mLatch.set(true);
                this.mLatch.notifyAll();
            }
            this.sendEndBackup();
            obbConnection.tearDown();
            Slog.d("BackupManagerService", "Full backup pass complete.");
            this.backupManagerService.getWakelock().release();
        }
    }

    @Override
    public void execute() {
    }

    @Override
    public void operationComplete(long result) {
    }

    @Override
    public void handleCancel(boolean cancelAll) {
        PackageInfo target = this.mCurrentTarget;
        Slog.w("BackupManagerService", "adb backup cancel of " + target);
        if (target != null) {
            this.backupManagerService.tearDownAgentAndKill(this.mCurrentTarget.applicationInfo);
        }
        this.backupManagerService.removeOperation(this.mCurrentOpToken);
    }
}

