/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.internal;

import android.app.backup.IBackupObserver;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.EventLog;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.backup.IBackupTransport;
import com.android.server.backup.BackupManagerService;
import com.android.server.backup.TransportManager;
import com.android.server.backup.internal.OnTaskFinishedListener;
import com.android.server.backup.transport.TransportClient;
import java.io.File;
import java.util.ArrayList;

public class PerformInitializeTask
implements Runnable {
    private final BackupManagerService mBackupManagerService;
    private final TransportManager mTransportManager;
    private final String[] mQueue;
    private final File mBaseStateDir;
    private final OnTaskFinishedListener mListener;
    private IBackupObserver mObserver;

    public PerformInitializeTask(BackupManagerService backupManagerService, String[] transportNames, IBackupObserver observer, OnTaskFinishedListener listener) {
        this(backupManagerService, backupManagerService.getTransportManager(), transportNames, observer, listener, backupManagerService.getBaseStateDir());
    }

    @VisibleForTesting
    PerformInitializeTask(BackupManagerService backupManagerService, TransportManager transportManager, String[] transportNames, IBackupObserver observer, OnTaskFinishedListener listener, File baseStateDir) {
        this.mBackupManagerService = backupManagerService;
        this.mTransportManager = transportManager;
        this.mQueue = transportNames;
        this.mObserver = observer;
        this.mListener = listener;
        this.mBaseStateDir = baseStateDir;
    }

    private void notifyResult(String target, int status) {
        try {
            if (this.mObserver != null) {
                this.mObserver.onResult(target, status);
            }
        }
        catch (RemoteException ignored) {
            this.mObserver = null;
        }
    }

    private void notifyFinished(int status) {
        try {
            if (this.mObserver != null) {
                this.mObserver.backupFinished(status);
            }
        }
        catch (RemoteException ignored) {
            this.mObserver = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String callerLogString = "PerformInitializeTask.run()";
        ArrayList<TransportClient> transportClientsToDisposeOf = new ArrayList<TransportClient>(this.mQueue.length);
        int result = 0;
        try {
            for (String transportName : this.mQueue) {
                TransportClient transportClient = this.mTransportManager.getTransportClient(transportName, callerLogString);
                if (transportClient == null) {
                    Slog.e("BackupManagerService", "Requested init for " + transportName + " but not found");
                    continue;
                }
                transportClientsToDisposeOf.add(transportClient);
                Slog.i("BackupManagerService", "Initializing (wiping) backup transport storage: " + transportName);
                String transportDirName = this.mTransportManager.getTransportDirName(transportClient.getTransportComponent());
                EventLog.writeEvent(2821, transportDirName);
                long startRealtime = SystemClock.elapsedRealtime();
                IBackupTransport transport = transportClient.connectOrThrow(callerLogString);
                int status = transport.initializeDevice();
                if (status == 0) {
                    status = transport.finishBackup();
                }
                if (status == 0) {
                    Slog.i("BackupManagerService", "Device init successful");
                    int millis = (int)(SystemClock.elapsedRealtime() - startRealtime);
                    EventLog.writeEvent(2827, new Object[0]);
                    File stateFileDir = new File(this.mBaseStateDir, transportDirName);
                    this.mBackupManagerService.resetBackupState(stateFileDir);
                    EventLog.writeEvent(2825, 0, millis);
                    this.mBackupManagerService.recordInitPending(false, transportName, transportDirName);
                    this.notifyResult(transportName, 0);
                    continue;
                }
                Slog.e("BackupManagerService", "Transport error in initializeDevice()");
                EventLog.writeEvent(2822, "(initialize)");
                this.mBackupManagerService.recordInitPending(true, transportName, transportDirName);
                this.notifyResult(transportName, status);
                result = status;
                long delay = transport.requestBackupTime();
                Slog.w("BackupManagerService", "Init failed on " + transportName + " resched in " + delay);
                this.mBackupManagerService.getAlarmManager().set(0, System.currentTimeMillis() + delay, this.mBackupManagerService.getRunInitIntent());
            }
        }
        catch (Exception e) {
            Slog.e("BackupManagerService", "Unexpected error performing init", e);
            result = -1000;
        }
        finally {
            for (TransportClient transportClient : transportClientsToDisposeOf) {
                this.mTransportManager.disposeOfTransportClient(transportClient, callerLogString);
            }
            this.notifyFinished(result);
            this.mListener.onFinished(callerLogString);
        }
    }
}

