/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.restore;

import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreSet;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.util.Slog;
import com.android.server.backup.BackupManagerService;
import com.android.server.backup.TransportManager;
import com.android.server.backup.internal.OnTaskFinishedListener;
import com.android.server.backup.params.RestoreGetSetsParams;
import com.android.server.backup.params.RestoreParams;
import com.android.server.backup.transport.TransportClient;
import java.util.function.BiFunction;

public class ActiveRestoreSession
extends IRestoreSession.Stub {
    private static final String TAG = "RestoreSession";
    private final TransportManager mTransportManager;
    private final String mTransportName;
    private final BackupManagerService mBackupManagerService;
    private final String mPackageName;
    public RestoreSet[] mRestoreSets = null;
    boolean mEnded = false;
    boolean mTimedOut = false;

    public ActiveRestoreSession(BackupManagerService backupManagerService, String packageName, String transportName) {
        this.mBackupManagerService = backupManagerService;
        this.mPackageName = packageName;
        this.mTransportManager = backupManagerService.getTransportManager();
        this.mTransportName = transportName;
    }

    public void markTimedOut() {
        this.mTimedOut = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getAvailableRestoreSets(IRestoreObserver observer, IBackupManagerMonitor monitor) {
        this.mBackupManagerService.getContext().enforceCallingOrSelfPermission("android.permission.BACKUP", "getAvailableRestoreSets");
        if (observer == null) {
            throw new IllegalArgumentException("Observer must not be null");
        }
        if (this.mEnded) {
            throw new IllegalStateException("Restore session already ended");
        }
        if (this.mTimedOut) {
            Slog.i(TAG, "Session already timed out");
            return -1;
        }
        long oldId = Binder.clearCallingIdentity();
        try {
            TransportClient transportClient = this.mTransportManager.getTransportClient(this.mTransportName, "RestoreSession.getAvailableRestoreSets()");
            if (transportClient == null) {
                Slog.w(TAG, "Null transport client getting restore sets");
                int n = -1;
                return n;
            }
            this.mBackupManagerService.getBackupHandler().removeMessages(8);
            PowerManager.WakeLock wakelock = this.mBackupManagerService.getWakelock();
            wakelock.acquire();
            TransportManager transportManager = this.mTransportManager;
            OnTaskFinishedListener listener = caller -> {
                transportManager.disposeOfTransportClient(transportClient, caller);
                wakelock.release();
            };
            Message msg = this.mBackupManagerService.getBackupHandler().obtainMessage(6, new RestoreGetSetsParams(transportClient, this, observer, monitor, listener));
            this.mBackupManagerService.getBackupHandler().sendMessage(msg);
            int n = 0;
            return n;
        }
        catch (Exception e) {
            Slog.e(TAG, "Error in getAvailableRestoreSets", e);
            int n = -1;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized int restoreAll(long token, IRestoreObserver observer, IBackupManagerMonitor monitor) {
        this.mBackupManagerService.getContext().enforceCallingOrSelfPermission("android.permission.BACKUP", "performRestore");
        Slog.d(TAG, "restoreAll token=" + Long.toHexString(token) + " observer=" + observer);
        if (this.mEnded) {
            throw new IllegalStateException("Restore session already ended");
        }
        if (this.mTimedOut) {
            Slog.i(TAG, "Session already timed out");
            return -1;
        }
        if (this.mRestoreSets == null) {
            Slog.e(TAG, "Ignoring restoreAll() with no restore set");
            return -1;
        }
        if (this.mPackageName != null) {
            Slog.e(TAG, "Ignoring restoreAll() on single-package session");
            return -1;
        }
        if (!this.mTransportManager.isTransportRegistered(this.mTransportName)) {
            Slog.e(TAG, "Transport " + this.mTransportName + " not registered");
            return -1;
        }
        Object object = this.mBackupManagerService.getQueueLock();
        synchronized (object) {
            int i = 0;
            while (true) {
                if (i >= this.mRestoreSets.length) {
                    // MONITOREXIT @DISABLED, blocks:[2, 5, 7] lbl27 : MonitorExitStatement: MONITOREXIT : var5_4
                    Slog.w(TAG, "Restore token " + Long.toHexString(token) + " not found");
                    return -1;
                }
                if (token == this.mRestoreSets[i].token) {
                    long oldId = Binder.clearCallingIdentity();
                    try {
                        int n = this.sendRestoreToHandlerLocked((transportClient, listener) -> RestoreParams.createForRestoreAll(transportClient, observer, monitor, token, listener), "RestoreSession.restoreAll()");
                        return n;
                    }
                    finally {
                        Binder.restoreCallingIdentity(oldId);
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized int restoreSome(long token, IRestoreObserver observer, IBackupManagerMonitor monitor, String[] packages) {
        this.mBackupManagerService.getContext().enforceCallingOrSelfPermission("android.permission.BACKUP", "performRestore");
        StringBuilder b = new StringBuilder(128);
        b.append("restoreSome token=");
        b.append(Long.toHexString(token));
        b.append(" observer=");
        b.append(observer.toString());
        b.append(" monitor=");
        if (monitor == null) {
            b.append("null");
        } else {
            b.append(monitor.toString());
        }
        b.append(" packages=");
        if (packages == null) {
            b.append("null");
        } else {
            b.append('{');
            boolean first = true;
            for (String s : packages) {
                if (!first) {
                    b.append(", ");
                } else {
                    first = false;
                }
                b.append(s);
            }
            b.append('}');
        }
        Slog.d(TAG, b.toString());
        if (this.mEnded) {
            throw new IllegalStateException("Restore session already ended");
        }
        if (this.mTimedOut) {
            Slog.i(TAG, "Session already timed out");
            return -1;
        }
        if (this.mRestoreSets == null) {
            Slog.e(TAG, "Ignoring restoreAll() with no restore set");
            return -1;
        }
        if (this.mPackageName != null) {
            Slog.e(TAG, "Ignoring restoreAll() on single-package session");
            return -1;
        }
        if (!this.mTransportManager.isTransportRegistered(this.mTransportName)) {
            Slog.e(TAG, "Transport " + this.mTransportName + " not registered");
            return -1;
        }
        Object object = this.mBackupManagerService.getQueueLock();
        synchronized (object) {
            int i = 0;
            while (true) {
                if (i >= this.mRestoreSets.length) {
                    // MONITOREXIT @DISABLED, blocks:[2, 6, 8] lbl67 : MonitorExitStatement: MONITOREXIT : var6_5
                    Slog.w(TAG, "Restore token " + Long.toHexString(token) + " not found");
                    return -1;
                }
                if (token == this.mRestoreSets[i].token) {
                    long oldId = Binder.clearCallingIdentity();
                    try {
                        int n = this.sendRestoreToHandlerLocked((transportClient, listener) -> RestoreParams.createForRestoreSome(transportClient, observer, monitor, token, packages, packages.length > 1, listener), "RestoreSession.restoreSome(" + packages.length + " packages)");
                        return n;
                    }
                    finally {
                        Binder.restoreCallingIdentity(oldId);
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int restorePackage(String packageName, IRestoreObserver observer, IBackupManagerMonitor monitor) {
        PackageInfo app;
        Slog.v(TAG, "restorePackage pkg=" + packageName + " obs=" + observer + "monitor=" + monitor);
        if (this.mEnded) {
            throw new IllegalStateException("Restore session already ended");
        }
        if (this.mTimedOut) {
            Slog.i(TAG, "Session already timed out");
            return -1;
        }
        if (this.mPackageName != null && !this.mPackageName.equals(packageName)) {
            Slog.e(TAG, "Ignoring attempt to restore pkg=" + packageName + " on session for package " + this.mPackageName);
            return -1;
        }
        try {
            app = this.mBackupManagerService.getPackageManager().getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nnf) {
            Slog.w(TAG, "Asked to restore nonexistent pkg " + packageName);
            return -1;
        }
        int perm = this.mBackupManagerService.getContext().checkPermission("android.permission.BACKUP", Binder.getCallingPid(), Binder.getCallingUid());
        if (perm == -1 && app.applicationInfo.uid != Binder.getCallingUid()) {
            Slog.w(TAG, "restorePackage: bad packageName=" + packageName + " or calling uid=" + Binder.getCallingUid());
            throw new SecurityException("No permission to restore other packages");
        }
        if (!this.mTransportManager.isTransportRegistered(this.mTransportName)) {
            Slog.e(TAG, "Transport " + this.mTransportName + " not registered");
            return -1;
        }
        long oldId = Binder.clearCallingIdentity();
        try {
            long token = this.mBackupManagerService.getAvailableRestoreToken(packageName);
            Slog.v(TAG, "restorePackage pkg=" + packageName + " token=" + Long.toHexString(token));
            if (token == 0L) {
                Slog.w(TAG, "No data available for this package; not restoring");
                int n = -1;
                return n;
            }
            int n = this.sendRestoreToHandlerLocked((transportClient, listener) -> RestoreParams.createForSinglePackage(transportClient, observer, monitor, token, app, listener), "RestoreSession.restorePackage(" + packageName + ")");
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    private int sendRestoreToHandlerLocked(BiFunction<TransportClient, OnTaskFinishedListener, RestoreParams> restoreParamsBuilder, String callerLogString) {
        TransportClient transportClient = this.mTransportManager.getTransportClient(this.mTransportName, callerLogString);
        if (transportClient == null) {
            Slog.e(TAG, "Transport " + this.mTransportName + " got unregistered");
            return -1;
        }
        Handler backupHandler = this.mBackupManagerService.getBackupHandler();
        backupHandler.removeMessages(8);
        PowerManager.WakeLock wakelock = this.mBackupManagerService.getWakelock();
        wakelock.acquire();
        TransportManager transportManager = this.mTransportManager;
        OnTaskFinishedListener listener = caller -> {
            transportManager.disposeOfTransportClient(transportClient, caller);
            wakelock.release();
        };
        Message msg = backupHandler.obtainMessage(3);
        msg.obj = restoreParamsBuilder.apply(transportClient, listener);
        backupHandler.sendMessage(msg);
        return 0;
    }

    @Override
    public synchronized void endRestoreSession() {
        Slog.d(TAG, "endRestoreSession");
        if (this.mTimedOut) {
            Slog.i(TAG, "Session already timed out");
            return;
        }
        if (this.mEnded) {
            throw new IllegalStateException("Restore session already ended");
        }
        this.mBackupManagerService.getBackupHandler().post(new EndRestoreRunnable(this.mBackupManagerService, this));
    }

    public class EndRestoreRunnable
    implements Runnable {
        BackupManagerService mBackupManager;
        ActiveRestoreSession mSession;

        public EndRestoreRunnable(BackupManagerService manager, ActiveRestoreSession session) {
            this.mBackupManager = manager;
            this.mSession = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ActiveRestoreSession activeRestoreSession = this.mSession;
            synchronized (activeRestoreSession) {
                this.mSession.mEnded = true;
            }
            this.mBackupManager.clearRestoreSession(this.mSession);
        }
    }
}

