/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.restore;

import android.app.IBackupAgent;
import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IFullBackupRestoreObserver;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.backup.BackupManagerService;
import com.android.server.backup.FileMetadata;
import com.android.server.backup.KeyValueAdbRestoreEngine;
import com.android.server.backup.PackageManagerBackupAgent;
import com.android.server.backup.fullbackup.FullBackupObbConnection;
import com.android.server.backup.restore.AdbRestoreFinishedLatch;
import com.android.server.backup.restore.RestoreDeleteObserver;
import com.android.server.backup.restore.RestoreFileRunnable;
import com.android.server.backup.restore.RestorePolicy;
import com.android.server.backup.utils.BytesReadListener;
import com.android.server.backup.utils.FullBackupRestoreObserverUtils;
import com.android.server.backup.utils.PasswordUtils;
import com.android.server.backup.utils.RestoreUtils;
import com.android.server.backup.utils.TarBackupReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.InflaterInputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PerformAdbRestoreTask
implements Runnable {
    private final BackupManagerService mBackupManagerService;
    private final ParcelFileDescriptor mInputFile;
    private final String mCurrentPassword;
    private final String mDecryptPassword;
    private final AtomicBoolean mLatchObject;
    private final PackageManagerBackupAgent mPackageManagerBackupAgent;
    private final RestoreDeleteObserver mDeleteObserver = new RestoreDeleteObserver();
    private IFullBackupRestoreObserver mObserver;
    private IBackupAgent mAgent;
    private String mAgentPackage;
    private ApplicationInfo mTargetApp;
    private FullBackupObbConnection mObbConnection = null;
    private ParcelFileDescriptor[] mPipes = null;
    private byte[] mWidgetData = null;
    private long mBytes;
    private final HashMap<String, RestorePolicy> mPackagePolicies = new HashMap();
    private final HashMap<String, String> mPackageInstallers = new HashMap();
    private final HashMap<String, Signature[]> mManifestSignatures = new HashMap();
    private final HashSet<String> mClearedPackages = new HashSet();

    public PerformAdbRestoreTask(BackupManagerService backupManagerService, ParcelFileDescriptor fd, String curPassword, String decryptPassword, IFullBackupRestoreObserver observer, AtomicBoolean latch) {
        this.mBackupManagerService = backupManagerService;
        this.mInputFile = fd;
        this.mCurrentPassword = curPassword;
        this.mDecryptPassword = decryptPassword;
        this.mObserver = observer;
        this.mLatchObject = latch;
        this.mAgent = null;
        this.mPackageManagerBackupAgent = backupManagerService.makeMetadataAgent();
        this.mAgentPackage = null;
        this.mTargetApp = null;
        this.mObbConnection = new FullBackupObbConnection(backupManagerService);
        this.mClearedPackages.add("android");
        this.mClearedPackages.add("com.android.providers.settings");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Slog.i("BackupManagerService", "--- Performing full-dataset restore ---");
        this.mObbConnection.establish();
        this.mObserver = FullBackupRestoreObserverUtils.sendStartRestore(this.mObserver);
        if (Environment.getExternalStorageState().equals("mounted")) {
            this.mPackagePolicies.put("com.android.sharedstoragebackup", RestorePolicy.ACCEPT);
        }
        FileInputStream rawInStream = null;
        try {
            boolean didRestore;
            if (!this.mBackupManagerService.backupPasswordMatches(this.mCurrentPassword)) {
                Slog.w("BackupManagerService", "Backup password mismatch; aborting");
                return;
            }
            this.mBytes = 0L;
            rawInStream = new FileInputStream(this.mInputFile.getFileDescriptor());
            InputStream tarInputStream = PerformAdbRestoreTask.parseBackupFileHeaderAndReturnTarStream(rawInStream, this.mDecryptPassword);
            if (tarInputStream == null) {
                return;
            }
            byte[] buffer = new byte[32768];
            while (didRestore = this.restoreOneFile(tarInputStream, false, buffer, null, true, this.mBackupManagerService.generateRandomIntegerToken(), null)) {
            }
        }
        catch (IOException e) {
            Slog.e("BackupManagerService", "Unable to read restore input");
        }
        finally {
            this.tearDownPipes();
            this.tearDownAgent(this.mTargetApp, true);
            try {
                if (rawInStream != null) {
                    rawInStream.close();
                }
                this.mInputFile.close();
            }
            catch (IOException e) {
                Slog.w("BackupManagerService", "Close of restore data pipe threw", e);
            }
            AtomicBoolean atomicBoolean = this.mLatchObject;
            synchronized (atomicBoolean) {
                this.mLatchObject.set(true);
                this.mLatchObject.notifyAll();
            }
            this.mObbConnection.tearDown();
            this.mObserver = FullBackupRestoreObserverUtils.sendEndRestore(this.mObserver);
            Slog.d("BackupManagerService", "Full restore pass complete.");
            this.mBackupManagerService.getWakelock().release();
        }
    }

    private static void readFullyOrThrow(InputStream in, byte[] buffer) throws IOException {
        int bytesRead;
        for (int offset = 0; offset < buffer.length; offset += bytesRead) {
            bytesRead = in.read(buffer, offset, buffer.length - offset);
            if (bytesRead > 0) continue;
            throw new IOException("Couldn't fully read data");
        }
    }

    @VisibleForTesting
    public static InputStream parseBackupFileHeaderAndReturnTarStream(InputStream rawInputStream, String decryptPassword) throws IOException {
        boolean compressed = false;
        InputStream preCompressStream = rawInputStream;
        boolean okay = false;
        int headerLen = "ANDROID BACKUP\n".length();
        byte[] streamHeader = new byte[headerLen];
        PerformAdbRestoreTask.readFullyOrThrow(rawInputStream, streamHeader);
        byte[] magicBytes = "ANDROID BACKUP\n".getBytes("UTF-8");
        if (Arrays.equals(magicBytes, streamHeader)) {
            String s = PerformAdbRestoreTask.readHeaderLine(rawInputStream);
            int archiveVersion = Integer.parseInt(s);
            if (archiveVersion <= 5) {
                boolean pbkdf2Fallback = archiveVersion == 1;
                s = PerformAdbRestoreTask.readHeaderLine(rawInputStream);
                compressed = Integer.parseInt(s) != 0;
                s = PerformAdbRestoreTask.readHeaderLine(rawInputStream);
                if (s.equals("none")) {
                    okay = true;
                } else if (decryptPassword != null && decryptPassword.length() > 0) {
                    preCompressStream = PerformAdbRestoreTask.decodeAesHeaderAndInitialize(decryptPassword, s, pbkdf2Fallback, rawInputStream);
                    if (preCompressStream != null) {
                        okay = true;
                    }
                } else {
                    Slog.w("BackupManagerService", "Archive is encrypted but no password given");
                }
            } else {
                Slog.w("BackupManagerService", "Wrong header version: " + s);
            }
        } else {
            Slog.w("BackupManagerService", "Didn't read the right header magic");
        }
        if (!okay) {
            Slog.w("BackupManagerService", "Invalid restore data; aborting.");
            return null;
        }
        return compressed ? new InflaterInputStream(preCompressStream) : preCompressStream;
    }

    private static String readHeaderLine(InputStream in) throws IOException {
        int c;
        StringBuilder buffer = new StringBuilder(80);
        while ((c = in.read()) >= 0 && c != 10) {
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    private static InputStream attemptMasterKeyDecryption(String decryptPassword, String algorithm, byte[] userSalt, byte[] ckSalt, int rounds, String userIvHex, String masterKeyBlobHex, InputStream rawInStream, boolean doLog) {
        CipherInputStream result;
        block15: {
            result = null;
            try {
                Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
                SecretKey userKey = PasswordUtils.buildPasswordKey(algorithm, decryptPassword, userSalt, rounds);
                byte[] IV = PasswordUtils.hexToByteArray(userIvHex);
                IvParameterSpec ivSpec = new IvParameterSpec(IV);
                c.init(2, (Key)new SecretKeySpec(userKey.getEncoded(), "AES"), ivSpec);
                byte[] mkCipher = PasswordUtils.hexToByteArray(masterKeyBlobHex);
                byte[] mkBlob = c.doFinal(mkCipher);
                int offset = 0;
                byte len = mkBlob[offset++];
                IV = Arrays.copyOfRange(mkBlob, offset, offset + len);
                offset += len;
                len = mkBlob[offset++];
                byte[] mk = Arrays.copyOfRange(mkBlob, offset, offset + len);
                offset += len;
                len = mkBlob[offset++];
                byte[] mkChecksum = Arrays.copyOfRange(mkBlob, offset, offset + len);
                byte[] calculatedCk = PasswordUtils.makeKeyChecksum(algorithm, mk, ckSalt, rounds);
                if (Arrays.equals(calculatedCk, mkChecksum)) {
                    ivSpec = new IvParameterSpec(IV);
                    c.init(2, (Key)new SecretKeySpec(mk, "AES"), ivSpec);
                    result = new CipherInputStream(rawInStream, c);
                } else if (doLog) {
                    Slog.w("BackupManagerService", "Incorrect password");
                }
            }
            catch (InvalidAlgorithmParameterException e) {
                if (doLog) {
                    Slog.e("BackupManagerService", "Needed parameter spec unavailable!", e);
                }
            }
            catch (BadPaddingException e) {
                if (doLog) {
                    Slog.w("BackupManagerService", "Incorrect password");
                }
            }
            catch (IllegalBlockSizeException e) {
                if (doLog) {
                    Slog.w("BackupManagerService", "Invalid block size in master key");
                }
            }
            catch (NoSuchAlgorithmException e) {
                if (doLog) {
                    Slog.e("BackupManagerService", "Needed decryption algorithm unavailable!");
                }
            }
            catch (NoSuchPaddingException e) {
                if (doLog) {
                    Slog.e("BackupManagerService", "Needed padding mechanism unavailable!");
                }
            }
            catch (InvalidKeyException e) {
                if (!doLog) break block15;
                Slog.w("BackupManagerService", "Illegal password; aborting");
            }
        }
        return result;
    }

    private static InputStream decodeAesHeaderAndInitialize(String decryptPassword, String encryptionName, boolean pbkdf2Fallback, InputStream rawInStream) {
        InputStream result = null;
        try {
            if (encryptionName.equals("AES-256")) {
                String masterKeyBlobHex;
                String userIvHex;
                int rounds;
                String ckSaltHex;
                byte[] ckSalt;
                String userSaltHex = PerformAdbRestoreTask.readHeaderLine(rawInStream);
                byte[] userSalt = PasswordUtils.hexToByteArray(userSaltHex);
                result = PerformAdbRestoreTask.attemptMasterKeyDecryption(decryptPassword, "PBKDF2WithHmacSHA1", userSalt, ckSalt = PasswordUtils.hexToByteArray(ckSaltHex = PerformAdbRestoreTask.readHeaderLine(rawInStream)), rounds = Integer.parseInt(PerformAdbRestoreTask.readHeaderLine(rawInStream)), userIvHex = PerformAdbRestoreTask.readHeaderLine(rawInStream), masterKeyBlobHex = PerformAdbRestoreTask.readHeaderLine(rawInStream), rawInStream, false);
                if (result == null && pbkdf2Fallback) {
                    result = PerformAdbRestoreTask.attemptMasterKeyDecryption(decryptPassword, "PBKDF2WithHmacSHA1And8bit", userSalt, ckSalt, rounds, userIvHex, masterKeyBlobHex, rawInStream, true);
                }
            } else {
                Slog.w("BackupManagerService", "Unsupported encryption method: " + encryptionName);
            }
        }
        catch (NumberFormatException e) {
            Slog.w("BackupManagerService", "Can't parse restore data header");
        }
        catch (IOException e) {
            Slog.w("BackupManagerService", "Can't read input header");
        }
        return result;
    }

    boolean restoreOneFile(InputStream instream, boolean mustKillAgent, byte[] buffer, PackageInfo onlyPackage, boolean allowApks, int token, IBackupManagerMonitor monitor) {
        FileMetadata info;
        block44: {
            BytesReadListener bytesReadListener = new BytesReadListener(){

                @Override
                public void onBytesRead(long bytesRead) {
                    PerformAdbRestoreTask.this.mBytes += bytesRead;
                }
            };
            TarBackupReader tarBackupReader = new TarBackupReader(instream, bytesReadListener, monitor);
            try {
                long nRead;
                info = tarBackupReader.readTarHeaders();
                if (info == null) break block44;
                String pkg = info.packageName;
                if (!pkg.equals(this.mAgentPackage)) {
                    if (!this.mPackagePolicies.containsKey(pkg)) {
                        this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                    }
                    if (this.mAgent != null) {
                        Slog.d("BackupManagerService", "Saw new package; finalizing old one");
                        this.tearDownPipes();
                        this.tearDownAgent(this.mTargetApp, true);
                        this.mTargetApp = null;
                        this.mAgentPackage = null;
                    }
                }
                if (info.path.equals("_manifest")) {
                    Signature[] signatures = tarBackupReader.readAppManifestAndReturnSignatures(info);
                    RestorePolicy restorePolicy = tarBackupReader.chooseRestorePolicy(this.mBackupManagerService.getPackageManager(), allowApks, info, signatures);
                    this.mManifestSignatures.put(info.packageName, signatures);
                    this.mPackagePolicies.put(pkg, restorePolicy);
                    this.mPackageInstallers.put(pkg, info.installerPackageName);
                    tarBackupReader.skipTarPadding(info.size);
                    this.mObserver = FullBackupRestoreObserverUtils.sendOnRestorePackage(this.mObserver, pkg);
                    break block44;
                }
                if (info.path.equals("_meta")) {
                    tarBackupReader.readMetadata(info);
                    this.mWidgetData = tarBackupReader.getWidgetData();
                    monitor = tarBackupReader.getMonitor();
                    tarBackupReader.skipTarPadding(info.size);
                    break block44;
                }
                boolean okay = true;
                RestorePolicy policy = this.mPackagePolicies.get(pkg);
                switch (policy) {
                    case IGNORE: {
                        okay = false;
                        break;
                    }
                    case ACCEPT_IF_APK: {
                        if (info.domain.equals("a")) {
                            Slog.d("BackupManagerService", "APK file; installing");
                            String installerPackageName = this.mPackageInstallers.get(pkg);
                            boolean isSuccessfullyInstalled = RestoreUtils.installApk(instream, this.mBackupManagerService.getContext(), this.mDeleteObserver, this.mManifestSignatures, this.mPackagePolicies, info, installerPackageName, bytesReadListener);
                            this.mPackagePolicies.put(pkg, isSuccessfullyInstalled ? RestorePolicy.ACCEPT : RestorePolicy.IGNORE);
                            tarBackupReader.skipTarPadding(info.size);
                            return true;
                        }
                        this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                        okay = false;
                        break;
                    }
                    case ACCEPT: {
                        if (!info.domain.equals("a")) break;
                        Slog.d("BackupManagerService", "apk present but ACCEPT");
                        okay = false;
                        break;
                    }
                    default: {
                        Slog.e("BackupManagerService", "Invalid policy from manifest");
                        okay = false;
                        this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                    }
                }
                if (!PerformAdbRestoreTask.isCanonicalFilePath(info.path)) {
                    okay = false;
                }
                if (okay && this.mAgent != null) {
                    Slog.i("BackupManagerService", "Reusing existing agent instance");
                }
                if (okay && this.mAgent == null) {
                    Slog.d("BackupManagerService", "Need to launch agent for " + pkg);
                    try {
                        this.mTargetApp = this.mBackupManagerService.getPackageManager().getApplicationInfo(pkg, 0);
                        if (!this.mClearedPackages.contains(pkg)) {
                            if (this.mTargetApp.backupAgentName == null) {
                                Slog.d("BackupManagerService", "Clearing app data preparatory to full restore");
                                this.mBackupManagerService.clearApplicationDataSynchronous(pkg, true);
                            } else {
                                Slog.d("BackupManagerService", "backup agent (" + this.mTargetApp.backupAgentName + ") => no clear");
                            }
                            this.mClearedPackages.add(pkg);
                        } else {
                            Slog.d("BackupManagerService", "We've initialized this app already; no clear required");
                        }
                        this.setUpPipes();
                        this.mAgent = this.mBackupManagerService.bindToAgentSynchronous(this.mTargetApp, "k".equals(info.domain) ? 0 : 3);
                        this.mAgentPackage = pkg;
                    }
                    catch (IOException installerPackageName) {
                    }
                    catch (PackageManager.NameNotFoundException installerPackageName) {
                        // empty catch block
                    }
                    if (this.mAgent == null) {
                        Slog.e("BackupManagerService", "Unable to create agent for " + pkg);
                        okay = false;
                        this.tearDownPipes();
                        this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                    }
                }
                if (okay && !pkg.equals(this.mAgentPackage)) {
                    Slog.e("BackupManagerService", "Restoring data for " + pkg + " but agent is for " + this.mAgentPackage);
                    okay = false;
                }
                if (okay) {
                    boolean agentSuccess = true;
                    long toCopy = info.size;
                    try {
                        this.mBackupManagerService.prepareOperationTimeout(token, 60000L, null, 1);
                        if ("obb".equals(info.domain)) {
                            Slog.d("BackupManagerService", "Restoring OBB file for " + pkg + " : " + info.path);
                            this.mObbConnection.restoreObbFile(pkg, this.mPipes[0], info.size, info.type, info.path, info.mode, info.mtime, token, this.mBackupManagerService.getBackupManagerBinder());
                        } else if ("k".equals(info.domain)) {
                            Slog.d("BackupManagerService", "Restoring key-value file for " + pkg + " : " + info.path);
                            KeyValueAdbRestoreEngine restoreEngine = new KeyValueAdbRestoreEngine(this.mBackupManagerService, this.mBackupManagerService.getDataDir(), info, this.mPipes[0], this.mAgent, token);
                            new Thread((Runnable)restoreEngine, "restore-key-value-runner").start();
                        } else {
                            Slog.d("BackupManagerService", "Invoking agent to restore file " + info.path);
                            if (this.mTargetApp.processName.equals("system")) {
                                Slog.d("BackupManagerService", "system process agent - spinning a thread");
                                RestoreFileRunnable runner = new RestoreFileRunnable(this.mBackupManagerService, this.mAgent, info, this.mPipes[0], token);
                                new Thread((Runnable)runner, "restore-sys-runner").start();
                            } else {
                                this.mAgent.doRestoreFile(this.mPipes[0], info.size, info.type, info.domain, info.path, info.mode, info.mtime, token, this.mBackupManagerService.getBackupManagerBinder());
                            }
                        }
                    }
                    catch (IOException e) {
                        Slog.d("BackupManagerService", "Couldn't establish restore");
                        agentSuccess = false;
                        okay = false;
                    }
                    catch (RemoteException e) {
                        Slog.e("BackupManagerService", "Agent crashed during full restore");
                        agentSuccess = false;
                        okay = false;
                    }
                    if (okay) {
                        boolean pipeOkay = true;
                        FileOutputStream pipe = new FileOutputStream(this.mPipes[1].getFileDescriptor());
                        while (toCopy > 0L) {
                            int toRead = toCopy > (long)buffer.length ? buffer.length : (int)toCopy;
                            int nRead2 = instream.read(buffer, 0, toRead);
                            if (nRead2 >= 0) {
                                this.mBytes += (long)nRead2;
                            }
                            if (nRead2 <= 0) break;
                            toCopy -= (long)nRead2;
                            if (!pipeOkay) continue;
                            try {
                                pipe.write(buffer, 0, nRead2);
                            }
                            catch (IOException e) {
                                Slog.e("BackupManagerService", "Failed to write to restore pipe", e);
                                pipeOkay = false;
                            }
                        }
                        tarBackupReader.skipTarPadding(info.size);
                        agentSuccess = this.mBackupManagerService.waitUntilOperationComplete(token);
                    }
                    if (!agentSuccess) {
                        Slog.d("BackupManagerService", "Agent failure restoring " + pkg + "; now ignoring");
                        this.mBackupManagerService.getBackupHandler().removeMessages(18);
                        this.tearDownPipes();
                        this.tearDownAgent(this.mTargetApp, false);
                        this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                    }
                }
                if (okay) break block44;
                Slog.d("BackupManagerService", "[discarding file content]");
                for (long bytesToConsume = info.size + 511L & 0xFFFFFFFFFFFFFE00L; bytesToConsume > 0L; bytesToConsume -= nRead) {
                    int toRead = bytesToConsume > (long)buffer.length ? buffer.length : (int)bytesToConsume;
                    nRead = instream.read(buffer, 0, toRead);
                    if (nRead >= 0L) {
                        this.mBytes += nRead;
                    }
                    if (nRead > 0L) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                Slog.w("BackupManagerService", "io exception on restore socket read", e);
                info = null;
            }
        }
        return info != null;
    }

    private static boolean isCanonicalFilePath(String path) {
        return !path.contains("..") && !path.contains("//");
    }

    private void setUpPipes() throws IOException {
        this.mPipes = ParcelFileDescriptor.createPipe();
    }

    private void tearDownPipes() {
        if (this.mPipes != null) {
            try {
                this.mPipes[0].close();
                this.mPipes[0] = null;
                this.mPipes[1].close();
                this.mPipes[1] = null;
            }
            catch (IOException e) {
                Slog.w("BackupManagerService", "Couldn't close agent pipes", e);
            }
            this.mPipes = null;
        }
    }

    private void tearDownAgent(ApplicationInfo app, boolean doRestoreFinished) {
        if (this.mAgent != null) {
            try {
                if (doRestoreFinished) {
                    int token = this.mBackupManagerService.generateRandomIntegerToken();
                    AdbRestoreFinishedLatch latch = new AdbRestoreFinishedLatch(this.mBackupManagerService, token);
                    this.mBackupManagerService.prepareOperationTimeout(token, 300000L, latch, 1);
                    if (this.mTargetApp.processName.equals("system")) {
                        RestoreFinishedRunnable runner = new RestoreFinishedRunnable(this.mAgent, token, this.mBackupManagerService);
                        new Thread((Runnable)runner, "restore-sys-finished-runner").start();
                    } else {
                        this.mAgent.doRestoreFinished(token, this.mBackupManagerService.getBackupManagerBinder());
                    }
                    latch.await();
                }
                this.mBackupManagerService.tearDownAgentAndKill(app);
            }
            catch (RemoteException e) {
                Slog.d("BackupManagerService", "Lost app trying to shut down");
            }
            this.mAgent = null;
        }
    }

    private static class RestoreFinishedRunnable
    implements Runnable {
        private final IBackupAgent mAgent;
        private final int mToken;
        private final BackupManagerService mBackupManagerService;

        RestoreFinishedRunnable(IBackupAgent agent, int token, BackupManagerService backupManagerService) {
            this.mAgent = agent;
            this.mToken = token;
            this.mBackupManagerService = backupManagerService;
        }

        @Override
        public void run() {
            try {
                this.mAgent.doRestoreFinished(this.mToken, this.mBackupManagerService.getBackupManagerBinder());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

