/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.utils;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Slog;
import com.android.internal.backup.IBackupTransport;
import com.android.internal.util.ArrayUtils;
import com.android.server.backup.transport.TransportClient;

public class AppBackupUtils {
    public static boolean appIsEligibleForBackup(ApplicationInfo app, PackageManager pm) {
        if ((app.flags & 0x8000) == 0) {
            return false;
        }
        if (app.uid < 10000 && app.backupAgentName == null) {
            return false;
        }
        if (app.packageName.equals("com.android.sharedstoragebackup")) {
            return false;
        }
        if (app.isInstantApp()) {
            return false;
        }
        return !AppBackupUtils.appIsDisabled(app, pm);
    }

    public static boolean appIsRunningAndEligibleForBackupWithTransport(TransportClient transportClient, String packageName, PackageManager pm) {
        try {
            PackageInfo packageInfo = pm.getPackageInfo(packageName, 64);
            ApplicationInfo applicationInfo = packageInfo.applicationInfo;
            if (!AppBackupUtils.appIsEligibleForBackup(applicationInfo, pm) || AppBackupUtils.appIsStopped(applicationInfo) || AppBackupUtils.appIsDisabled(applicationInfo, pm)) {
                return false;
            }
            if (transportClient != null) {
                try {
                    IBackupTransport transport = transportClient.connectOrThrow("AppBackupUtils.appIsEligibleForBackupAtRuntime");
                    return transport.isAppEligibleForBackup(packageInfo, AppBackupUtils.appGetsFullBackup(packageInfo));
                }
                catch (Exception e) {
                    Slog.e("BackupManagerService", "Unable to ask about eligibility: " + e.getMessage());
                }
            }
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static boolean appIsDisabled(ApplicationInfo app, PackageManager pm) {
        switch (pm.getApplicationEnabledSetting(app.packageName)) {
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static boolean appIsStopped(ApplicationInfo app) {
        return (app.flags & 0x200000) != 0;
    }

    public static boolean appGetsFullBackup(PackageInfo pkg) {
        if (pkg.applicationInfo.backupAgentName != null) {
            return (pkg.applicationInfo.flags & 0x4000000) != 0;
        }
        return true;
    }

    public static boolean appIsKeyValueOnly(PackageInfo pkg) {
        return !AppBackupUtils.appGetsFullBackup(pkg);
    }

    public static boolean signaturesMatch(Signature[] storedSigs, PackageInfo target) {
        if (target == null) {
            return false;
        }
        if ((target.applicationInfo.flags & 1) != 0) {
            return true;
        }
        Signature[] deviceSigs = target.signatures;
        if (ArrayUtils.isEmpty(storedSigs) || ArrayUtils.isEmpty(deviceSigs)) {
            return false;
        }
        int nStored = storedSigs.length;
        int nDevice = deviceSigs.length;
        for (int i = 0; i < nStored; ++i) {
            boolean match = false;
            for (int j = 0; j < nDevice; ++j) {
                if (!storedSigs[i].equals(deviceSigs[j])) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }
}

