/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.utils;

import android.app.backup.IBackupManagerMonitor;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Bundle;
import android.util.Slog;
import com.android.server.backup.FileMetadata;
import com.android.server.backup.restore.RestorePolicy;
import com.android.server.backup.utils.AppBackupUtils;
import com.android.server.backup.utils.BackupManagerMonitorUtils;
import com.android.server.backup.utils.BytesReadListener;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TarBackupReader {
    private static final int TAR_HEADER_OFFSET_TYPE_CHAR = 156;
    private static final int TAR_HEADER_LENGTH_PATH = 100;
    private static final int TAR_HEADER_OFFSET_PATH = 0;
    private static final int TAR_HEADER_LENGTH_PATH_PREFIX = 155;
    private static final int TAR_HEADER_OFFSET_PATH_PREFIX = 345;
    private static final int TAR_HEADER_LENGTH_MODE = 8;
    private static final int TAR_HEADER_OFFSET_MODE = 100;
    private static final int TAR_HEADER_LENGTH_MODTIME = 12;
    private static final int TAR_HEADER_OFFSET_MODTIME = 136;
    private static final int TAR_HEADER_LENGTH_FILESIZE = 12;
    private static final int TAR_HEADER_OFFSET_FILESIZE = 124;
    private static final int TAR_HEADER_LONG_RADIX = 8;
    private final InputStream mInputStream;
    private final BytesReadListener mBytesReadListener;
    private IBackupManagerMonitor mMonitor;
    private byte[] mWidgetData = null;

    public TarBackupReader(InputStream inputStream, BytesReadListener bytesReadListener, IBackupManagerMonitor monitor) {
        this.mInputStream = inputStream;
        this.mBytesReadListener = bytesReadListener;
        this.mMonitor = monitor;
    }

    public FileMetadata readTarHeaders() throws IOException {
        byte[] block = new byte[512];
        FileMetadata info = null;
        boolean gotHeader = this.readTarHeader(block);
        if (gotHeader) {
            try {
                byte typeChar;
                info = new FileMetadata();
                info.size = TarBackupReader.extractRadix(block, 124, 12, 8);
                info.mtime = TarBackupReader.extractRadix(block, 136, 12, 8);
                info.mode = TarBackupReader.extractRadix(block, 100, 8, 8);
                info.path = TarBackupReader.extractString(block, 345, 155);
                String path = TarBackupReader.extractString(block, 0, 100);
                if (path.length() > 0) {
                    if (info.path.length() > 0) {
                        info.path = info.path + '/';
                    }
                    info.path = info.path + path;
                }
                if ((typeChar = block[156]) == 120) {
                    gotHeader = this.readPaxExtendedHeader(info);
                    if (gotHeader) {
                        gotHeader = this.readTarHeader(block);
                    }
                    if (!gotHeader) {
                        throw new IOException("Bad or missing pax header");
                    }
                    typeChar = block[156];
                }
                switch (typeChar) {
                    case 48: {
                        info.type = 1;
                        break;
                    }
                    case 53: {
                        info.type = 2;
                        if (info.size == 0L) break;
                        Slog.w("BackupManagerService", "Directory entry with nonzero size in header");
                        info.size = 0L;
                        break;
                    }
                    case 0: {
                        return null;
                    }
                    default: {
                        Slog.e("BackupManagerService", "Unknown tar entity type: " + typeChar);
                        throw new IOException("Unknown entity type " + typeChar);
                    }
                }
                if ("shared/".regionMatches(0, info.path, 0, "shared/".length())) {
                    info.path = info.path.substring("shared/".length());
                    info.packageName = "com.android.sharedstoragebackup";
                    info.domain = "shared";
                    Slog.i("BackupManagerService", "File in shared storage: " + info.path);
                } else if ("apps/".regionMatches(0, info.path, 0, "apps/".length())) {
                    info.path = info.path.substring("apps/".length());
                    int slash = info.path.indexOf(47);
                    if (slash < 0) {
                        throw new IOException("Illegal semantic path in " + info.path);
                    }
                    info.packageName = info.path.substring(0, slash);
                    info.path = info.path.substring(slash + 1);
                    if (!info.path.equals("_manifest") && !info.path.equals("_meta")) {
                        slash = info.path.indexOf(47);
                        if (slash < 0) {
                            throw new IOException("Illegal semantic path in non-manifest " + info.path);
                        }
                        info.domain = info.path.substring(0, slash);
                        info.path = info.path.substring(slash + 1);
                    }
                }
            }
            catch (IOException e) {
                Slog.e("BackupManagerService", "Parse error in header: " + e.getMessage());
                throw e;
            }
        }
        return info;
    }

    private static int readExactly(InputStream in, byte[] buffer, int offset, int size) throws IOException {
        int soFar;
        int nRead;
        if (size <= 0) {
            throw new IllegalArgumentException("size must be > 0");
        }
        for (soFar = 0; soFar < size && (nRead = in.read(buffer, offset + soFar, size - soFar)) > 0; soFar += nRead) {
        }
        return soFar;
    }

    public Signature[] readAppManifestAndReturnSignatures(FileMetadata info) throws IOException {
        if (info.size > 65536L) {
            throw new IOException("Restore manifest too big; corrupt? size=" + info.size);
        }
        byte[] buffer = new byte[(int)info.size];
        if ((long)TarBackupReader.readExactly(this.mInputStream, buffer, 0, (int)info.size) != info.size) {
            throw new IOException("Unexpected EOF in manifest");
        }
        this.mBytesReadListener.onBytesRead(info.size);
        String[] str = new String[1];
        int offset = 0;
        try {
            offset = TarBackupReader.extractLine(buffer, offset, str);
            int version = Integer.parseInt(str[0]);
            if (version == 1) {
                offset = TarBackupReader.extractLine(buffer, offset, str);
                String manifestPackage = str[0];
                if (manifestPackage.equals(info.packageName)) {
                    offset = TarBackupReader.extractLine(buffer, offset, str);
                    info.version = Integer.parseInt(str[0]);
                    offset = TarBackupReader.extractLine(buffer, offset, str);
                    Integer.parseInt(str[0]);
                    offset = TarBackupReader.extractLine(buffer, offset, str);
                    info.installerPackageName = str[0].length() > 0 ? str[0] : null;
                    offset = TarBackupReader.extractLine(buffer, offset, str);
                    info.hasApk = str[0].equals("1");
                    offset = TarBackupReader.extractLine(buffer, offset, str);
                    int numSigs = Integer.parseInt(str[0]);
                    if (numSigs > 0) {
                        Signature[] sigs = new Signature[numSigs];
                        for (int i = 0; i < numSigs; ++i) {
                            offset = TarBackupReader.extractLine(buffer, offset, str);
                            sigs[i] = new Signature(str[0]);
                        }
                        return sigs;
                    }
                    Slog.i("BackupManagerService", "Missing signature on backed-up package " + info.packageName);
                    this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 42, null, 3, BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_EVENT_PACKAGE_NAME", info.packageName));
                } else {
                    Slog.i("BackupManagerService", "Expected package " + info.packageName + " but restore manifest claims " + manifestPackage);
                    Bundle monitoringExtras = BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_EVENT_PACKAGE_NAME", info.packageName);
                    monitoringExtras = BackupManagerMonitorUtils.putMonitoringExtra(monitoringExtras, "android.app.backup.extra.LOG_MANIFEST_PACKAGE_NAME", manifestPackage);
                    this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 43, null, 3, monitoringExtras);
                }
            } else {
                Slog.i("BackupManagerService", "Unknown restore manifest version " + version + " for package " + info.packageName);
                Bundle monitoringExtras = BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_EVENT_PACKAGE_NAME", info.packageName);
                monitoringExtras = BackupManagerMonitorUtils.putMonitoringExtra(monitoringExtras, "android.app.backup.extra.LOG_EVENT_PACKAGE_VERSION", version);
                this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 44, null, 3, monitoringExtras);
            }
        }
        catch (NumberFormatException e) {
            Slog.w("BackupManagerService", "Corrupt restore manifest for package " + info.packageName);
            this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 46, null, 3, BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_EVENT_PACKAGE_NAME", info.packageName));
        }
        catch (IllegalArgumentException e) {
            Slog.w("BackupManagerService", e.getMessage());
        }
        return null;
    }

    public RestorePolicy chooseRestorePolicy(PackageManager packageManager, boolean allowApks, FileMetadata info, Signature[] signatures) {
        if (signatures == null) {
            return RestorePolicy.IGNORE;
        }
        RestorePolicy policy = RestorePolicy.IGNORE;
        try {
            PackageInfo pkgInfo = packageManager.getPackageInfo(info.packageName, 64);
            int flags = pkgInfo.applicationInfo.flags;
            if ((flags & 0x8000) != 0) {
                if (pkgInfo.applicationInfo.uid >= 10000 || pkgInfo.applicationInfo.backupAgentName != null) {
                    if (AppBackupUtils.signaturesMatch(signatures, pkgInfo)) {
                        if ((pkgInfo.applicationInfo.flags & 0x20000) != 0) {
                            Slog.i("BackupManagerService", "Package has restoreAnyVersion; taking data");
                            this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 34, pkgInfo, 3, null);
                            policy = RestorePolicy.ACCEPT;
                        } else if (pkgInfo.getLongVersionCode() >= info.version) {
                            Slog.i("BackupManagerService", "Sig + version match; taking data");
                            policy = RestorePolicy.ACCEPT;
                            this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 35, pkgInfo, 3, null);
                        } else if (allowApks) {
                            Slog.i("BackupManagerService", "Data version " + info.version + " is newer than installed version " + pkgInfo.getLongVersionCode() + " - requiring apk");
                            policy = RestorePolicy.ACCEPT_IF_APK;
                        } else {
                            Slog.i("BackupManagerService", "Data requires newer version " + info.version + "; ignoring");
                            this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 36, pkgInfo, 3, BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_OLD_VERSION", info.version));
                            policy = RestorePolicy.IGNORE;
                        }
                    } else {
                        Slog.w("BackupManagerService", "Restore manifest signatures do not match installed application for " + info.packageName);
                        this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 37, pkgInfo, 3, null);
                    }
                } else {
                    Slog.w("BackupManagerService", "Package " + info.packageName + " is system level with no agent");
                    this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 38, pkgInfo, 2, null);
                }
            } else {
                Slog.i("BackupManagerService", "Restore manifest from " + info.packageName + " but allowBackup=false");
                this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 39, pkgInfo, 3, null);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            if (allowApks) {
                Slog.i("BackupManagerService", "Package " + info.packageName + " not installed; requiring apk in dataset");
                policy = RestorePolicy.ACCEPT_IF_APK;
            } else {
                policy = RestorePolicy.IGNORE;
            }
            Bundle monitoringExtras = BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_EVENT_PACKAGE_NAME", info.packageName);
            monitoringExtras = BackupManagerMonitorUtils.putMonitoringExtra(monitoringExtras, "android.app.backup.extra.LOG_POLICY_ALLOW_APKS", allowApks);
            this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 40, null, 3, monitoringExtras);
        }
        if (policy == RestorePolicy.ACCEPT_IF_APK && !info.hasApk) {
            Slog.i("BackupManagerService", "Cannot restore package " + info.packageName + " without the matching .apk");
            this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 41, null, 3, BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_EVENT_PACKAGE_NAME", info.packageName));
        }
        return policy;
    }

    public void skipTarPadding(long size) throws IOException {
        long partial = (size + 512L) % 512L;
        if (partial > 0L) {
            int needed = 512 - (int)partial;
            byte[] buffer = new byte[needed];
            if (TarBackupReader.readExactly(this.mInputStream, buffer, 0, needed) == needed) {
                this.mBytesReadListener.onBytesRead(needed);
            } else {
                throw new IOException("Unexpected EOF in padding");
            }
        }
    }

    public void readMetadata(FileMetadata info) throws IOException {
        if (info.size > 65536L) {
            throw new IOException("Metadata too big; corrupt? size=" + info.size);
        }
        byte[] buffer = new byte[(int)info.size];
        if ((long)TarBackupReader.readExactly(this.mInputStream, buffer, 0, (int)info.size) != info.size) {
            throw new IOException("Unexpected EOF in widget data");
        }
        this.mBytesReadListener.onBytesRead(info.size);
        String[] str = new String[1];
        int offset = TarBackupReader.extractLine(buffer, 0, str);
        int version = Integer.parseInt(str[0]);
        if (version == 1) {
            offset = TarBackupReader.extractLine(buffer, offset, str);
            String pkg = str[0];
            if (info.packageName.equals(pkg)) {
                ByteArrayInputStream bin = new ByteArrayInputStream(buffer, offset, buffer.length - offset);
                DataInputStream in = new DataInputStream(bin);
                block3: while (bin.available() > 0) {
                    int token = in.readInt();
                    int size = in.readInt();
                    if (size > 65536) {
                        throw new IOException("Datum " + Integer.toHexString(token) + " too big; corrupt? size=" + info.size);
                    }
                    switch (token) {
                        case 33549569: {
                            this.mWidgetData = new byte[size];
                            in.read(this.mWidgetData);
                            continue block3;
                        }
                    }
                    Slog.i("BackupManagerService", "Ignoring metadata blob " + Integer.toHexString(token) + " for " + info.packageName);
                    in.skipBytes(size);
                }
            } else {
                Slog.w("BackupManagerService", "Metadata mismatch: package " + info.packageName + " but widget data for " + pkg);
                Bundle monitoringExtras = BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_EVENT_PACKAGE_NAME", info.packageName);
                monitoringExtras = BackupManagerMonitorUtils.putMonitoringExtra(monitoringExtras, "android.app.backup.extra.LOG_WIDGET_PACKAGE_NAME", pkg);
                this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 47, null, 3, monitoringExtras);
            }
        } else {
            Slog.w("BackupManagerService", "Unsupported metadata version " + version);
            Bundle monitoringExtras = BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_EVENT_PACKAGE_NAME", info.packageName);
            monitoringExtras = BackupManagerMonitorUtils.putMonitoringExtra(monitoringExtras, "android.app.backup.extra.LOG_EVENT_PACKAGE_VERSION", version);
            this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 48, null, 3, monitoringExtras);
        }
    }

    private static int extractLine(byte[] buffer, int offset, String[] outStr) throws IOException {
        byte c;
        int pos;
        int end = buffer.length;
        if (offset >= end) {
            throw new IOException("Incomplete data");
        }
        for (pos = offset; pos < end && (c = buffer[pos]) != 10; ++pos) {
        }
        outStr[0] = new String(buffer, offset, pos - offset);
        return ++pos;
    }

    private boolean readTarHeader(byte[] block) throws IOException {
        int got = TarBackupReader.readExactly(this.mInputStream, block, 0, 512);
        if (got == 0) {
            return false;
        }
        if (got < 512) {
            throw new IOException("Unable to read full block header");
        }
        this.mBytesReadListener.onBytesRead(512L);
        return true;
    }

    private boolean readPaxExtendedHeader(FileMetadata info) throws IOException {
        int linelen;
        if (info.size > 32768L) {
            Slog.w("BackupManagerService", "Suspiciously large pax header size " + info.size + " - aborting");
            throw new IOException("Sanity failure: pax header size " + info.size);
        }
        int numBlocks = (int)(info.size + 511L >> 9);
        byte[] data = new byte[numBlocks * 512];
        if (TarBackupReader.readExactly(this.mInputStream, data, 0, data.length) < data.length) {
            throw new IOException("Unable to read full pax header");
        }
        this.mBytesReadListener.onBytesRead(data.length);
        int contentSize = (int)info.size;
        int offset = 0;
        do {
            int value;
            int eol;
            for (eol = offset + 1; eol < contentSize && data[eol] != 32; ++eol) {
            }
            if (eol >= contentSize) {
                throw new IOException("Invalid pax data");
            }
            linelen = (int)TarBackupReader.extractRadix(data, offset, eol - offset, 10);
            int key = eol + 1;
            eol = offset + linelen - 1;
            for (value = key + 1; data[value] != 61 && value <= eol; ++value) {
            }
            if (value > eol) {
                throw new IOException("Invalid pax declaration");
            }
            String keyStr = new String(data, key, value - key, "UTF-8");
            String valStr = new String(data, value + 1, eol - value - 1, "UTF-8");
            if ("path".equals(keyStr)) {
                info.path = valStr;
                continue;
            }
            if ("size".equals(keyStr)) {
                info.size = Long.parseLong(valStr);
                continue;
            }
            Slog.i("BackupManagerService", "Unhandled pax key: " + key);
        } while ((offset += linelen) < contentSize);
        return true;
    }

    private static long extractRadix(byte[] data, int offset, int maxChars, int radix) throws IOException {
        byte b;
        long value = 0L;
        int end = offset + maxChars;
        for (int i = offset; i < end && (b = data[i]) != 0 && b != 32; ++i) {
            if (b < 48 || b > 48 + radix - 1) {
                throw new IOException("Invalid number in header: '" + (char)b + "' for radix " + radix);
            }
            value = (long)radix * value + (long)(b - 48);
        }
        return value;
    }

    private static String extractString(byte[] data, int offset, int maxChars) throws IOException {
        int eos;
        int end = offset + maxChars;
        for (eos = offset; eos < end && data[eos] != 0; ++eos) {
        }
        return new String(data, offset, eos - offset, "US-ASCII");
    }

    private static void hexLog(byte[] block) {
        int offset = 0;
        int todo = block.length;
        StringBuilder buf = new StringBuilder(64);
        while (todo > 0) {
            buf.append(String.format("%04x   ", offset));
            int numThisLine = todo > 16 ? 16 : todo;
            for (int i = 0; i < numThisLine; ++i) {
                buf.append(String.format("%02x ", block[offset + i]));
            }
            Slog.i("hexdump", buf.toString());
            buf.setLength(0);
            todo -= numThisLine;
            offset += numThisLine;
        }
    }

    public IBackupManagerMonitor getMonitor() {
        return this.mMonitor;
    }

    public byte[] getWidgetData() {
        return this.mWidgetData;
    }
}

