/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkUtils;
import android.net.Uri;
import android.os.Binder;
import android.os.INetworkManagementService;
import android.os.UserHandle;
import android.provider.Settings;
import android.system.GaiException;
import android.system.OsConstants;
import android.system.StructAddrinfo;
import android.text.TextUtils;
import android.util.Slog;
import com.android.server.connectivity.MockableSystemProperties;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import libcore.io.Libcore;

public class DnsManager {
    private static final String TAG = DnsManager.class.getSimpleName();
    private static final int DNS_RESOLVER_DEFAULT_SAMPLE_VALIDITY_SECONDS = 1800;
    private static final int DNS_RESOLVER_DEFAULT_SUCCESS_THRESHOLD_PERCENT = 25;
    private static final int DNS_RESOLVER_DEFAULT_MIN_SAMPLES = 8;
    private static final int DNS_RESOLVER_DEFAULT_MAX_SAMPLES = 64;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private final INetworkManagementService mNMS;
    private final MockableSystemProperties mSystemProperties;
    private final Map<Integer, PrivateDnsConfig> mPrivateDnsMap;
    private int mNumDnsEntries;
    private int mSampleValidity;
    private int mSuccessThreshold;
    private int mMinSamples;
    private int mMaxSamples;
    private String mPrivateDnsMode;
    private String mPrivateDnsSpecifier;

    public static PrivateDnsConfig getPrivateDnsConfig(ContentResolver cr) {
        boolean useTls;
        String mode = DnsManager.getPrivateDnsMode(cr);
        boolean bl = useTls = !TextUtils.isEmpty(mode) && !"off".equals(mode);
        if ("hostname".equals(mode)) {
            String specifier = DnsManager.getStringSetting(cr, "private_dns_specifier");
            return new PrivateDnsConfig(specifier, null);
        }
        return new PrivateDnsConfig(useTls);
    }

    public static PrivateDnsConfig tryBlockingResolveOf(Network network, String name) {
        StructAddrinfo hints = new StructAddrinfo();
        hints.ai_flags = 0;
        hints.ai_family = OsConstants.AF_UNSPEC;
        hints.ai_socktype = OsConstants.SOCK_DGRAM;
        try {
            InetAddress[] ips = Libcore.os.android_getaddrinfo(name, hints, network.netId);
            if (ips != null && ips.length > 0) {
                return new PrivateDnsConfig(name, ips);
            }
        }
        catch (GaiException gaiException) {
            // empty catch block
        }
        return null;
    }

    public static Uri[] getPrivateDnsSettingsUris() {
        Uri[] uris = new Uri[]{Settings.Global.getUriFor("private_dns_mode"), Settings.Global.getUriFor("private_dns_specifier")};
        return uris;
    }

    public DnsManager(Context ctx, INetworkManagementService nms, MockableSystemProperties sp) {
        this.mContext = ctx;
        this.mContentResolver = this.mContext.getContentResolver();
        this.mNMS = nms;
        this.mSystemProperties = sp;
        this.mPrivateDnsMap = new HashMap<Integer, PrivateDnsConfig>();
    }

    public PrivateDnsConfig getPrivateDnsConfig() {
        return DnsManager.getPrivateDnsConfig(this.mContentResolver);
    }

    public void removeNetwork(Network network) {
        this.mPrivateDnsMap.remove(network.netId);
    }

    public PrivateDnsConfig updatePrivateDns(Network network, PrivateDnsConfig cfg) {
        Slog.w(TAG, "updatePrivateDns(" + network + ", " + cfg + ")");
        return cfg != null ? this.mPrivateDnsMap.put(network.netId, cfg) : this.mPrivateDnsMap.remove(network);
    }

    public void setDnsConfigurationForNetwork(int netId, LinkProperties lp, boolean isDefaultNetwork) {
        PrivateDnsConfig privateDnsCfg = this.mPrivateDnsMap.get(netId);
        boolean useTls = privateDnsCfg != null && privateDnsCfg.useTls;
        boolean strictMode = privateDnsCfg != null && privateDnsCfg.inStrictMode();
        String tlsHostname = strictMode ? privateDnsCfg.hostname : "";
        Object[] serverStrs = NetworkUtils.makeStrings(strictMode ? (Collection)Arrays.stream(privateDnsCfg.ips).filter(ip -> lp.isReachable((InetAddress)ip)).collect(Collectors.toList()) : lp.getDnsServers());
        Object[] domainStrs = DnsManager.getDomainStrings(lp.getDomains());
        this.updateParametersSettings();
        int[] params = new int[]{this.mSampleValidity, this.mSuccessThreshold, this.mMinSamples, this.mMaxSamples};
        Slog.d(TAG, String.format("setDnsConfigurationForNetwork(%d, %s, %s, %s, %s, %s)", netId, Arrays.toString(serverStrs), Arrays.toString(domainStrs), Arrays.toString(params), useTls, tlsHostname));
        try {
            this.mNMS.setDnsConfigurationForNetwork(netId, (String[])serverStrs, (String[])domainStrs, params, useTls, tlsHostname);
        }
        catch (Exception e) {
            Slog.e(TAG, "Error setting DNS configuration: " + e);
            return;
        }
        if (isDefaultNetwork) {
            this.setDefaultDnsSystemProperties(lp.getDnsServers());
        }
        this.flushVmDnsCache();
    }

    public void setDefaultDnsSystemProperties(Collection<InetAddress> dnses) {
        int last = 0;
        for (InetAddress dns : dnses) {
            this.setNetDnsProperty(++last, dns.getHostAddress());
        }
        for (int i = last + 1; i <= this.mNumDnsEntries; ++i) {
            this.setNetDnsProperty(i, "");
        }
        this.mNumDnsEntries = last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushVmDnsCache() {
        Intent intent = new Intent("android.intent.action.CLEAR_DNS_CACHE");
        intent.addFlags(0x20000000);
        intent.addFlags(0x4000000);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void updateParametersSettings() {
        this.mSampleValidity = this.getIntSetting("dns_resolver_sample_validity_seconds", 1800);
        if (this.mSampleValidity < 0 || this.mSampleValidity > 65535) {
            Slog.w(TAG, "Invalid sampleValidity=" + this.mSampleValidity + ", using default=" + 1800);
            this.mSampleValidity = 1800;
        }
        this.mSuccessThreshold = this.getIntSetting("dns_resolver_success_threshold_percent", 25);
        if (this.mSuccessThreshold < 0 || this.mSuccessThreshold > 100) {
            Slog.w(TAG, "Invalid successThreshold=" + this.mSuccessThreshold + ", using default=" + 25);
            this.mSuccessThreshold = 25;
        }
        this.mMinSamples = this.getIntSetting("dns_resolver_min_samples", 8);
        this.mMaxSamples = this.getIntSetting("dns_resolver_max_samples", 64);
        if (this.mMinSamples < 0 || this.mMinSamples > this.mMaxSamples || this.mMaxSamples > 64) {
            Slog.w(TAG, "Invalid sample count (min, max)=(" + this.mMinSamples + ", " + this.mMaxSamples + "), using default=(" + 8 + ", " + 64 + ")");
            this.mMinSamples = 8;
            this.mMaxSamples = 64;
        }
    }

    private int getIntSetting(String which, int dflt) {
        return Settings.Global.getInt(this.mContentResolver, which, dflt);
    }

    private void setNetDnsProperty(int which, String value) {
        String key = "net.dns" + which;
        try {
            this.mSystemProperties.set(key, value);
        }
        catch (Exception e) {
            Slog.e(TAG, "Error setting unsupported net.dns property: ", e);
        }
    }

    private static String getPrivateDnsMode(ContentResolver cr) {
        String mode = DnsManager.getStringSetting(cr, "private_dns_mode");
        return !TextUtils.isEmpty(mode) ? mode : "opportunistic";
    }

    private static String getStringSetting(ContentResolver cr, String which) {
        return Settings.Global.getString(cr, which);
    }

    private static String[] getDomainStrings(String domains) {
        return TextUtils.isEmpty(domains) ? new String[]{} : domains.split(" ");
    }

    public static class PrivateDnsConfig {
        public final boolean useTls;
        public final String hostname;
        public final InetAddress[] ips;

        public PrivateDnsConfig() {
            this(false);
        }

        public PrivateDnsConfig(boolean useTls) {
            this.useTls = useTls;
            this.hostname = "";
            this.ips = new InetAddress[0];
        }

        public PrivateDnsConfig(String hostname, InetAddress[] ips) {
            this.useTls = !TextUtils.isEmpty(hostname);
            this.hostname = this.useTls ? hostname : "";
            this.ips = ips != null ? ips : new InetAddress[]{};
        }

        public PrivateDnsConfig(PrivateDnsConfig cfg) {
            this.useTls = cfg.useTls;
            this.hostname = cfg.hostname;
            this.ips = cfg.ips;
        }

        public boolean inStrictMode() {
            return this.useTls && !TextUtils.isEmpty(this.hostname);
        }

        public String toString() {
            return PrivateDnsConfig.class.getSimpleName() + "{" + this.useTls + ":" + this.hostname + "/" + Arrays.toString(this.ips) + "}";
        }
    }
}

