/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.app.usage.NetworkStatsManager;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.INetworkStatsService;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkPolicyManager;
import android.net.NetworkRequest;
import android.net.NetworkTemplate;
import android.net.StringNetworkSpecifier;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.TelephonyManager;
import android.util.DebugUtils;
import android.util.Slog;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.LocalServices;
import com.android.server.net.NetworkPolicyManagerInternal;
import java.util.Calendar;
import java.util.concurrent.ConcurrentHashMap;

public class MultipathPolicyTracker {
    private static String TAG = MultipathPolicyTracker.class.getSimpleName();
    private static final boolean DBG = false;
    private final Context mContext;
    private final Handler mHandler;
    private ConnectivityManager mCM;
    private NetworkStatsManager mStatsManager;
    private NetworkPolicyManager mNPM;
    private TelephonyManager mTelephonyManager;
    private INetworkStatsService mStatsService;
    private ConnectivityManager.NetworkCallback mMobileNetworkCallback;
    private NetworkPolicyManager.Listener mPolicyListener;
    private static final long DEFAULT_DAILY_MULTIPATH_QUOTA = 2500000L;
    private volatile int mMeteredMultipathPreference;
    private final ConcurrentHashMap<Network, MultipathTracker> mMultipathTrackers = new ConcurrentHashMap();

    public MultipathPolicyTracker(Context ctx, Handler handler) {
        this.mContext = ctx;
        this.mHandler = handler;
    }

    public void start() {
        this.mCM = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        this.mNPM = (NetworkPolicyManager)this.mContext.getSystemService("netpolicy");
        this.mStatsManager = (NetworkStatsManager)this.mContext.getSystemService("netstats");
        this.mStatsService = INetworkStatsService.Stub.asInterface(ServiceManager.getService("netstats"));
        this.registerTrackMobileCallback();
        this.registerNetworkPolicyListener();
    }

    public void shutdown() {
        this.maybeUnregisterTrackMobileCallback();
        this.unregisterNetworkPolicyListener();
        for (MultipathTracker t : this.mMultipathTrackers.values()) {
            t.shutdown();
        }
        this.mMultipathTrackers.clear();
    }

    public Integer getMultipathPreference(Network network) {
        MultipathTracker t = this.mMultipathTrackers.get(network);
        if (t != null) {
            return t.getMultipathPreference();
        }
        return null;
    }

    private void registerTrackMobileCallback() {
        NetworkRequest request = new NetworkRequest.Builder().addCapability(12).addTransportType(0).build();
        this.mMobileNetworkCallback = new ConnectivityManager.NetworkCallback(){

            @Override
            public void onCapabilitiesChanged(Network network, NetworkCapabilities nc) {
                MultipathTracker existing = (MultipathTracker)MultipathPolicyTracker.this.mMultipathTrackers.get(network);
                if (existing != null) {
                    existing.updateMultipathBudget();
                    return;
                }
                try {
                    MultipathPolicyTracker.this.mMultipathTrackers.put(network, new MultipathTracker(network, nc));
                }
                catch (IllegalStateException e) {
                    Slog.e(TAG, "Can't track mobile network " + network + ": " + e.getMessage());
                }
            }

            @Override
            public void onLost(Network network) {
                MultipathTracker existing = (MultipathTracker)MultipathPolicyTracker.this.mMultipathTrackers.get(network);
                if (existing != null) {
                    existing.shutdown();
                    MultipathPolicyTracker.this.mMultipathTrackers.remove(network);
                }
            }
        };
        this.mCM.registerNetworkCallback(request, this.mMobileNetworkCallback, this.mHandler);
    }

    private void maybeUnregisterTrackMobileCallback() {
        if (this.mMobileNetworkCallback != null) {
            this.mCM.unregisterNetworkCallback(this.mMobileNetworkCallback);
        }
        this.mMobileNetworkCallback = null;
    }

    private void registerNetworkPolicyListener() {
        this.mPolicyListener = new NetworkPolicyManager.Listener(){

            @Override
            public void onMeteredIfacesChanged(String[] meteredIfaces) {
                MultipathPolicyTracker.this.mHandler.post(() -> {
                    for (MultipathTracker t : MultipathPolicyTracker.this.mMultipathTrackers.values()) {
                        t.updateMultipathBudget();
                    }
                });
            }
        };
        this.mNPM.registerListener(this.mPolicyListener);
    }

    private void unregisterNetworkPolicyListener() {
        this.mNPM.unregisterListener(this.mPolicyListener);
    }

    public void dump(IndentingPrintWriter pw) {
        pw.println("MultipathPolicyTracker:");
        pw.increaseIndent();
        for (MultipathTracker t : this.mMultipathTrackers.values()) {
            pw.println(String.format("Network %s: quota %d, budget %d. Preference: %s", t.network, t.getQuota(), t.getMultipathBudget(), DebugUtils.flagsToString(ConnectivityManager.class, "MULTIPATH_PREFERENCE_", t.getMultipathPreference())));
        }
        pw.decreaseIndent();
    }

    class MultipathTracker {
        final Network network;
        final int subId;
        final String subscriberId;
        private long mQuota;
        private long mMultipathBudget;
        private final NetworkTemplate mNetworkTemplate;
        private final NetworkStatsManager.UsageCallback mUsageCallback;

        public MultipathTracker(final Network network, NetworkCapabilities nc) {
            this.network = network;
            try {
                this.subId = Integer.parseInt(((StringNetworkSpecifier)nc.getNetworkSpecifier()).toString());
            }
            catch (ClassCastException | NullPointerException | NumberFormatException e) {
                throw new IllegalStateException(String.format("Can't get subId from mobile network %s (%s): %s", network, nc, e.getMessage()));
            }
            TelephonyManager tele = (TelephonyManager)MultipathPolicyTracker.this.mContext.getSystemService("phone");
            if (tele == null) {
                throw new IllegalStateException(String.format("Missing TelephonyManager", new Object[0]));
            }
            if ((tele = tele.createForSubscriptionId(this.subId)) == null) {
                throw new IllegalStateException(String.format("Can't get TelephonyManager for subId %d", this.subId));
            }
            this.subscriberId = tele.getSubscriberId();
            this.mNetworkTemplate = new NetworkTemplate(1, this.subscriberId, new String[]{this.subscriberId}, null, -1, -1, 0);
            this.mUsageCallback = new NetworkStatsManager.UsageCallback(){

                @Override
                public void onThresholdReached(int networkType, String subscriberId) {
                    MultipathTracker.this.mMultipathBudget = 0L;
                    MultipathTracker.this.updateMultipathBudget();
                }
            };
            this.updateMultipathBudget();
        }

        private long getDailyNonDefaultDataUsage() {
            long bytes;
            Calendar start = Calendar.getInstance();
            Calendar end = (Calendar)start.clone();
            start.set(11, 0);
            start.set(12, 0);
            start.set(13, 0);
            start.set(14, 0);
            try {
                bytes = MultipathPolicyTracker.this.mStatsService.getNetworkTotalBytes(this.mNetworkTemplate, start.getTimeInMillis(), end.getTimeInMillis());
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Can't fetch daily data usage: " + e);
                bytes = -1L;
            }
            catch (IllegalStateException e) {
                bytes = -1L;
            }
            return bytes;
        }

        void updateMultipathBudget() {
            NetworkPolicyManagerInternal npms = LocalServices.getService(NetworkPolicyManagerInternal.class);
            long quota = npms.getSubscriptionOpportunisticQuota(this.network, 2);
            if (quota == 0L) {
                quota = 2500000L;
            }
            if (this.haveMultipathBudget() && quota == this.mQuota) {
                return;
            }
            this.mQuota = quota;
            long usage = this.getDailyNonDefaultDataUsage();
            long budget = Math.max(0L, quota - usage);
            if (budget > 0L) {
                this.registerUsageCallback(budget);
            } else {
                this.maybeUnregisterUsageCallback();
            }
        }

        public int getMultipathPreference() {
            if (this.haveMultipathBudget()) {
                return 3;
            }
            return 0;
        }

        public long getQuota() {
            return this.mQuota;
        }

        public long getMultipathBudget() {
            return this.mMultipathBudget;
        }

        private boolean haveMultipathBudget() {
            return this.mMultipathBudget > 0L;
        }

        private void registerUsageCallback(long budget) {
            this.maybeUnregisterUsageCallback();
            MultipathPolicyTracker.this.mStatsManager.registerUsageCallback(this.mNetworkTemplate, 0, budget, this.mUsageCallback, MultipathPolicyTracker.this.mHandler);
            this.mMultipathBudget = budget;
        }

        private void maybeUnregisterUsageCallback() {
            if (this.haveMultipathBudget()) {
                MultipathPolicyTracker.this.mStatsManager.unregisterUsageCallback(this.mUsageCallback);
                this.mMultipathBudget = 0L;
            }
        }

        void shutdown() {
            this.maybeUnregisterUsageCallback();
        }
    }
}

