/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.net.InterfaceConfiguration;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.net.RouteInfo;
import android.os.INetworkManagementService;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.util.ArrayUtils;
import com.android.server.connectivity.NetworkAgentInfo;
import com.android.server.net.BaseNetworkObserver;
import java.net.Inet4Address;
import java.util.Objects;

public class Nat464Xlat
extends BaseNetworkObserver {
    private static final String TAG = Nat464Xlat.class.getSimpleName();
    private static final String CLAT_PREFIX = "v4-";
    private static final int[] NETWORK_TYPES = new int[]{0, 1, 9};
    private static final NetworkInfo.State[] NETWORK_STATES = new NetworkInfo.State[]{NetworkInfo.State.CONNECTED, NetworkInfo.State.SUSPENDED};
    private final INetworkManagementService mNMService;
    private final NetworkAgentInfo mNetwork;
    private String mBaseIface;
    private String mIface;
    private State mState = State.IDLE;

    public Nat464Xlat(INetworkManagementService nmService, NetworkAgentInfo nai) {
        this.mNMService = nmService;
        this.mNetwork = nai;
    }

    public static boolean requiresClat(NetworkAgentInfo nai) {
        boolean supported = ArrayUtils.contains(NETWORK_TYPES, nai.networkInfo.getType());
        boolean connected = ArrayUtils.contains(NETWORK_STATES, nai.networkInfo.getState());
        boolean hasIPv4Address = nai.linkProperties != null && nai.linkProperties.hasIPv4Address();
        return supported && connected && !hasIPv4Address;
    }

    public boolean isStarted() {
        return this.mState != State.IDLE;
    }

    public boolean isStarting() {
        return this.mState == State.STARTING;
    }

    public boolean isRunning() {
        return this.mState == State.RUNNING;
    }

    public boolean isStopping() {
        return this.mState == State.STOPPING;
    }

    private void enterStartingState(String baseIface) {
        try {
            this.mNMService.registerObserver(this);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "startClat: Can't register interface observer for clat on " + this.mNetwork.name());
            return;
        }
        try {
            this.mNMService.startClatd(baseIface);
        }
        catch (RemoteException | IllegalStateException e) {
            Slog.e(TAG, "Error starting clatd on " + baseIface, e);
        }
        this.mIface = CLAT_PREFIX + baseIface;
        this.mBaseIface = baseIface;
        this.mState = State.STARTING;
    }

    private void enterRunningState() {
        this.mState = State.RUNNING;
    }

    private void enterStoppingState() {
        try {
            this.mNMService.stopClatd(this.mBaseIface);
        }
        catch (RemoteException | IllegalStateException e) {
            Slog.e(TAG, "Error stopping clatd on " + this.mBaseIface, e);
        }
        this.mState = State.STOPPING;
    }

    private void enterIdleState() {
        try {
            this.mNMService.unregisterObserver(this);
        }
        catch (RemoteException | IllegalStateException e) {
            Slog.e(TAG, "Error unregistering clatd observer on " + this.mBaseIface, e);
        }
        this.mIface = null;
        this.mBaseIface = null;
        this.mState = State.IDLE;
    }

    public void start() {
        if (this.isStarted()) {
            Slog.e(TAG, "startClat: already started");
            return;
        }
        if (this.mNetwork.linkProperties == null) {
            Slog.e(TAG, "startClat: Can't start clat with null LinkProperties");
            return;
        }
        String baseIface = this.mNetwork.linkProperties.getInterfaceName();
        if (baseIface == null) {
            Slog.e(TAG, "startClat: Can't start clat on null interface");
            return;
        }
        Slog.i(TAG, "Starting clatd on " + baseIface);
        this.enterStartingState(baseIface);
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        Slog.i(TAG, "Stopping clatd on " + this.mBaseIface);
        boolean wasStarting = this.isStarting();
        this.enterStoppingState();
        if (wasStarting) {
            this.enterIdleState();
        }
    }

    public void fixupLinkProperties(LinkProperties oldLp) {
        if (!this.isRunning()) {
            return;
        }
        LinkProperties lp = this.mNetwork.linkProperties;
        if (lp == null || lp.getAllInterfaceNames().contains(this.mIface)) {
            return;
        }
        Slog.d(TAG, "clatd running, updating NAI for " + this.mIface);
        for (LinkProperties stacked : oldLp.getStackedLinks()) {
            if (!Objects.equals(this.mIface, stacked.getInterfaceName())) continue;
            lp.addStackedLink(stacked);
            return;
        }
    }

    private LinkProperties makeLinkProperties(LinkAddress clatAddress) {
        LinkProperties stacked = new LinkProperties();
        stacked.setInterfaceName(this.mIface);
        RouteInfo ipv4Default = new RouteInfo(new LinkAddress(Inet4Address.ANY, 0), clatAddress.getAddress(), this.mIface);
        stacked.addRoute(ipv4Default);
        stacked.addLinkAddress(clatAddress);
        return stacked;
    }

    private LinkAddress getLinkAddress(String iface) {
        try {
            InterfaceConfiguration config = this.mNMService.getInterfaceConfig(iface);
            return config.getLinkAddress();
        }
        catch (RemoteException | IllegalStateException e) {
            Slog.e(TAG, "Error getting link properties: " + e);
            return null;
        }
    }

    private void handleInterfaceLinkStateChanged(String iface, boolean up) {
        if (!(this.isStarting() && up && Objects.equals(this.mIface, iface))) {
            return;
        }
        LinkAddress clatAddress = this.getLinkAddress(iface);
        if (clatAddress == null) {
            Slog.e(TAG, "clatAddress was null for stacked iface " + iface);
            return;
        }
        Slog.i(TAG, String.format("interface %s is up, adding stacked link %s on top of %s", this.mIface, this.mIface, this.mBaseIface));
        this.enterRunningState();
        LinkProperties lp = new LinkProperties(this.mNetwork.linkProperties);
        lp.addStackedLink(this.makeLinkProperties(clatAddress));
        this.mNetwork.connService().handleUpdateLinkProperties(this.mNetwork, lp);
    }

    private void handleInterfaceRemoved(String iface) {
        if (!Objects.equals(this.mIface, iface)) {
            return;
        }
        if (!this.isRunning() && !this.isStopping()) {
            return;
        }
        Slog.i(TAG, "interface " + iface + " removed");
        if (!this.isStopping()) {
            this.enterStoppingState();
        }
        this.enterIdleState();
        LinkProperties lp = new LinkProperties(this.mNetwork.linkProperties);
        lp.removeStackedLink(iface);
        this.mNetwork.connService().handleUpdateLinkProperties(this.mNetwork, lp);
    }

    @Override
    public void interfaceLinkStateChanged(String iface, boolean up) {
        this.mNetwork.handler().post(() -> this.handleInterfaceLinkStateChanged(iface, up));
    }

    @Override
    public void interfaceRemoved(String iface) {
        this.mNetwork.handler().post(() -> this.handleInterfaceRemoved(iface));
    }

    public String toString() {
        return "mBaseIface: " + this.mBaseIface + ", mIface: " + this.mIface + ", mState: " + (Object)((Object)this.mState);
    }

    private static enum State {
        IDLE,
        STARTING,
        RUNNING,
        STOPPING;

    }
}

