/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.content;

import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.Intent;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseLongArray;
import com.android.internal.annotations.GuardedBy;
import com.android.server.content.SyncLogger;
import com.android.server.content.SyncOperation;

public class SyncJobService
extends JobService {
    private static final String TAG = "SyncManager";
    public static final String EXTRA_MESSENGER = "messenger";
    private Messenger mMessenger;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private final SparseArray<JobParameters> mJobParamsMap = new SparseArray();
    @GuardedBy(value="mLock")
    private final SparseBooleanArray mStartedSyncs = new SparseBooleanArray();
    @GuardedBy(value="mLock")
    private final SparseLongArray mJobStartUptimes = new SparseLongArray();
    private final SyncLogger mLogger = SyncLogger.getInstance();

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        this.mMessenger = (Messenger)intent.getParcelableExtra(EXTRA_MESSENGER);
        Message m = Message.obtain();
        m.what = 7;
        m.obj = this;
        this.sendMessage(m);
        return 2;
    }

    private void sendMessage(Message message) {
        if (this.mMessenger == null) {
            Slog.e(TAG, "Messenger not initialized.");
            return;
        }
        try {
            this.mMessenger.send(message);
        }
        catch (RemoteException e) {
            Slog.e(TAG, e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onStartJob(JobParameters params) {
        this.mLogger.purgeOldLogs();
        boolean isLoggable = Log.isLoggable(TAG, 2);
        Object object = this.mLock;
        synchronized (object) {
            int jobId = params.getJobId();
            this.mJobParamsMap.put(jobId, params);
            this.mStartedSyncs.delete(jobId);
            this.mJobStartUptimes.put(jobId, SystemClock.uptimeMillis());
        }
        Message m = Message.obtain();
        m.what = 10;
        SyncOperation op = SyncOperation.maybeCreateFromJobExtras(params.getExtras());
        this.mLogger.log("onStartJob() jobid=", params.getJobId(), " op=", op);
        if (op == null) {
            Slog.e(TAG, "Got invalid job " + params.getJobId());
            return false;
        }
        if (isLoggable) {
            Slog.v(TAG, "Got start job message " + op.target);
        }
        m.obj = op;
        this.sendMessage(m);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onStopJob(JobParameters params) {
        if (Log.isLoggable(TAG, 2)) {
            Slog.v(TAG, "onStopJob called " + params.getJobId() + ", reason: " + params.getStopReason());
        }
        this.mLogger.log("onStopJob() ", this.mLogger.jobParametersToString(params));
        Object object = this.mLock;
        synchronized (object) {
            int jobId = params.getJobId();
            this.mJobParamsMap.remove(jobId);
            long startUptime = this.mJobStartUptimes.get(jobId);
            long nowUptime = SystemClock.uptimeMillis();
            long runtime = nowUptime - startUptime;
            if (startUptime == 0L) {
                this.wtf("Job " + jobId + " start uptime not found:  params=" + SyncJobService.jobParametersToString(params));
            } else if (runtime > 60000L) {
                if (!this.mStartedSyncs.get(jobId)) {
                    this.wtf("Job " + jobId + " didn't start:  startUptime=" + startUptime + " nowUptime=" + nowUptime + " params=" + SyncJobService.jobParametersToString(params));
                }
            } else if (runtime < 10000L) {
                // empty if block
            }
            this.mStartedSyncs.delete(jobId);
            this.mJobStartUptimes.delete(jobId);
        }
        Message m = Message.obtain();
        m.what = 11;
        m.obj = SyncOperation.maybeCreateFromJobExtras(params.getExtras());
        if (m.obj == null) {
            return false;
        }
        m.arg1 = params.getStopReason() != 0 ? 1 : 0;
        m.arg2 = params.getStopReason() == 3 ? 1 : 0;
        this.sendMessage(m);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callJobFinished(int jobId, boolean needsReschedule, String why) {
        Object object = this.mLock;
        synchronized (object) {
            JobParameters params = this.mJobParamsMap.get(jobId);
            this.mLogger.log("callJobFinished()", " jobid=", jobId, " needsReschedule=", needsReschedule, " ", this.mLogger.jobParametersToString(params), " why=", why);
            if (params != null) {
                this.jobFinished(params, needsReschedule);
                this.mJobParamsMap.remove(jobId);
            } else {
                Slog.e(TAG, "Job params not found for " + String.valueOf(jobId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markSyncStarted(int jobId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mStartedSyncs.put(jobId, true);
        }
    }

    public static String jobParametersToString(JobParameters params) {
        if (params == null) {
            return "job:null";
        }
        return "job:#" + params.getJobId() + ":sr=[" + params.getStopReason() + "/" + params.getDebugStopReason() + "]:" + SyncOperation.maybeCreateFromJobExtras(params.getExtras());
    }

    private void wtf(String message) {
        this.mLogger.log(message);
        Slog.wtf(TAG, message);
    }
}

