/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.util.AtomicFile;
import android.util.Slog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

public class PasswordBlacklist {
    private static final String TAG = "PasswordBlacklist";
    private final AtomicFile mFile;

    public PasswordBlacklist(File file) {
        this.mFile = new AtomicFile(file, "device-policy");
    }

    public boolean savePasswordBlacklist(String name, List<String> blacklist) {
        FileOutputStream fos = null;
        try {
            fos = this.mFile.startWrite();
            DataOutputStream out = this.buildStreamForWriting(fos);
            Header header = new Header(1, name, blacklist.size());
            header.write(out);
            int blacklistSize = blacklist.size();
            for (int i = 0; i < blacklistSize; ++i) {
                out.writeUTF(blacklist.get(i));
            }
            out.flush();
            this.mFile.finishWrite(fos);
            return true;
        }
        catch (IOException e) {
            this.mFile.failWrite(fos);
            return false;
        }
    }

    public String getName() {
        String string2;
        block8: {
            DataInputStream in = this.openForReading();
            Throwable throwable = null;
            try {
                string2 = Header.read((DataInputStream)in).mName;
                if (in == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (in != null) {
                            PasswordBlacklist.$closeResource(throwable, in);
                        }
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    Slog.wtf(TAG, "Failed to read blacklist file", e);
                    return null;
                }
            }
            PasswordBlacklist.$closeResource(throwable, in);
        }
        return string2;
    }

    public int getSize() {
        int n;
        block8: {
            DataInputStream in = this.openForReading();
            Throwable throwable = null;
            try {
                n = Header.read((DataInputStream)in).mSize;
                if (in == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (in != null) {
                            PasswordBlacklist.$closeResource(throwable, in);
                        }
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    Slog.wtf(TAG, "Failed to read blacklist file", e);
                    return 0;
                }
            }
            PasswordBlacklist.$closeResource(throwable, in);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isPasswordBlacklisted(String password) {
        try (DataInputStream in = this.openForReading();){
            Header header = Header.read(in);
            int i = 0;
            while (i < header.mSize) {
                if (in.readUTF().equals(password)) {
                    boolean bl = true;
                    return bl;
                }
                ++i;
            }
            return false;
        }
        catch (IOException e) {
            Slog.wtf(TAG, "Failed to read blacklist file", e);
            return true;
        }
    }

    public void delete() {
        this.mFile.delete();
    }

    public File getFile() {
        return this.mFile.getBaseFile();
    }

    private DataOutputStream buildStreamForWriting(FileOutputStream fos) {
        return new DataOutputStream(new BufferedOutputStream(fos));
    }

    private DataInputStream openForReading() throws IOException {
        return new DataInputStream(new BufferedInputStream(this.mFile.openRead()));
    }

    private static class Header {
        static final int VERSION_1 = 1;
        final int mVersion;
        final String mName;
        final int mSize;

        Header(int version, String name, int size) {
            this.mVersion = version;
            this.mName = name;
            this.mSize = size;
        }

        void write(DataOutputStream out) throws IOException {
            out.writeInt(this.mVersion);
            out.writeUTF(this.mName);
            out.writeInt(this.mSize);
        }

        static Header read(DataInputStream in) throws IOException {
            int version = in.readInt();
            String name = in.readUTF();
            int size = in.readInt();
            return new Header(version, name, size);
        }
    }
}

