/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.hardware.display.BrightnessConfiguration;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.Trace;
import android.util.EventLog;
import android.util.MathUtils;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.server.display.BrightnessMappingStrategy;
import com.android.server.display.HysteresisLevels;
import java.io.PrintWriter;

class AutomaticBrightnessController {
    private static final String TAG = "AutomaticBrightnessController";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_PRETEND_LIGHT_SENSOR_ABSENT = false;
    private static final boolean USE_SCREEN_AUTO_BRIGHTNESS_ADJUSTMENT = true;
    private static final long AMBIENT_LIGHT_PREDICTION_TIME_MILLIS = 100L;
    private static final int BRIGHTNESS_ADJUSTMENT_SAMPLE_DEBOUNCE_MILLIS = 10000;
    private static final int SHORT_TERM_MODEL_TIMEOUT_MILLIS = 30000;
    private static final int MSG_UPDATE_AMBIENT_LUX = 1;
    private static final int MSG_BRIGHTNESS_ADJUSTMENT_SAMPLE = 2;
    private static final int MSG_RESET_SHORT_TERM_MODEL = 3;
    private static final int AMBIENT_LIGHT_LONG_HORIZON_MILLIS = 10000;
    private static final int AMBIENT_LIGHT_SHORT_HORIZON_MILLIS = 2000;
    private final Callbacks mCallbacks;
    private final SensorManager mSensorManager;
    private final Sensor mLightSensor;
    private final BrightnessMappingStrategy mBrightnessMapper;
    private final int mScreenBrightnessRangeMinimum;
    private final int mScreenBrightnessRangeMaximum;
    private final float mDozeScaleFactor;
    private final int mInitialLightSensorRate;
    private final int mNormalLightSensorRate;
    private int mCurrentLightSensorRate;
    private final long mBrighteningLightDebounceConfig;
    private final long mDarkeningLightDebounceConfig;
    private final boolean mResetAmbientLuxAfterWarmUpConfig;
    private final int mAmbientLightHorizon;
    private final int mWeightingIntercept;
    private final HysteresisLevels mDynamicHysteresis;
    private int mLightSensorWarmUpTimeConfig;
    private boolean mLightSensorEnabled;
    private long mLightSensorEnableTime;
    private float mAmbientLux;
    private boolean mAmbientLuxValid;
    private float mBrighteningLuxThreshold;
    private float mDarkeningLuxThreshold;
    private float mLastObservedLux;
    private long mLastObservedLuxTime;
    private int mRecentLightSamples;
    private AmbientLightRingBuffer mAmbientLightRingBuffer;
    private AmbientLightRingBuffer mInitialHorizonAmbientLightRingBuffer;
    private AutomaticBrightnessHandler mHandler;
    private int mScreenAutoBrightness = -1;
    private float mScreenAutoBrightnessAdjustment = 0.0f;
    private float mScreenAutoBrightnessAdjustmentMaxGamma;
    private float mLastScreenAutoBrightnessGamma = 1.0f;
    private int mDisplayPolicy = 0;
    private boolean mBrightnessAdjustmentSamplePending;
    private float mBrightnessAdjustmentSampleOldAdjustment;
    private float mBrightnessAdjustmentSampleOldLux;
    private int mBrightnessAdjustmentSampleOldBrightness;
    private float mBrightnessAdjustmentSampleOldGamma;
    private final SensorEventListener mLightSensorListener = new SensorEventListener(){

        @Override
        public void onSensorChanged(SensorEvent event) {
            if (AutomaticBrightnessController.this.mLightSensorEnabled) {
                long time = SystemClock.uptimeMillis();
                float lux = event.values[0];
                AutomaticBrightnessController.this.handleLightSensorEvent(time, lux);
            }
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };

    public AutomaticBrightnessController(Callbacks callbacks, Looper looper, SensorManager sensorManager, BrightnessMappingStrategy mapper, int lightSensorWarmUpTime, int brightnessMin, int brightnessMax, float dozeScaleFactor, int lightSensorRate, int initialLightSensorRate, long brighteningLightDebounceConfig, long darkeningLightDebounceConfig, boolean resetAmbientLuxAfterWarmUpConfig, int ambientLightHorizon, float autoBrightnessAdjustmentMaxGamma, HysteresisLevels dynamicHysteresis) {
        this.mCallbacks = callbacks;
        this.mSensorManager = sensorManager;
        this.mBrightnessMapper = mapper;
        this.mScreenBrightnessRangeMinimum = brightnessMin;
        this.mScreenBrightnessRangeMaximum = brightnessMax;
        this.mLightSensorWarmUpTimeConfig = lightSensorWarmUpTime;
        this.mDozeScaleFactor = dozeScaleFactor;
        this.mNormalLightSensorRate = lightSensorRate;
        this.mInitialLightSensorRate = initialLightSensorRate;
        this.mCurrentLightSensorRate = -1;
        this.mBrighteningLightDebounceConfig = brighteningLightDebounceConfig;
        this.mDarkeningLightDebounceConfig = darkeningLightDebounceConfig;
        this.mResetAmbientLuxAfterWarmUpConfig = resetAmbientLuxAfterWarmUpConfig;
        this.mAmbientLightHorizon = ambientLightHorizon;
        this.mWeightingIntercept = ambientLightHorizon;
        this.mScreenAutoBrightnessAdjustmentMaxGamma = autoBrightnessAdjustmentMaxGamma;
        this.mDynamicHysteresis = dynamicHysteresis;
        this.mHandler = new AutomaticBrightnessHandler(looper);
        this.mAmbientLightRingBuffer = new AmbientLightRingBuffer(this.mNormalLightSensorRate, this.mAmbientLightHorizon);
        this.mInitialHorizonAmbientLightRingBuffer = new AmbientLightRingBuffer(this.mNormalLightSensorRate, this.mAmbientLightHorizon);
        this.mLightSensor = this.mSensorManager.getDefaultSensor(5);
    }

    public int getAutomaticScreenBrightness() {
        if (this.mDisplayPolicy == 1) {
            return (int)((float)this.mScreenAutoBrightness * this.mDozeScaleFactor);
        }
        return this.mScreenAutoBrightness;
    }

    public float getAutomaticScreenBrightnessAdjustment() {
        return this.mScreenAutoBrightnessAdjustment;
    }

    public void configure(boolean enable, BrightnessConfiguration configuration, float brightness, boolean userChangedBrightness, float adjustment, boolean userChangedAutoBrightnessAdjustment, int displayPolicy) {
        boolean userInitiatedChange;
        boolean dozing = displayPolicy == 1;
        boolean changed = this.setBrightnessConfiguration(configuration);
        changed |= this.setDisplayPolicy(displayPolicy);
        changed |= this.setScreenAutoBrightnessAdjustment(adjustment);
        if (userChangedBrightness && enable) {
            changed |= this.setScreenBrightnessByUser(brightness);
        }
        boolean bl = userInitiatedChange = userChangedBrightness || userChangedAutoBrightnessAdjustment;
        if (userInitiatedChange && enable && !dozing) {
            this.prepareBrightnessAdjustmentSample();
        }
        if (changed |= this.setLightSensorEnabled(enable && !dozing)) {
            this.updateAutoBrightness(false);
        }
    }

    public boolean hasUserDataPoints() {
        return this.mBrightnessMapper.hasUserDataPoints();
    }

    public boolean isDefaultConfig() {
        return this.mBrightnessMapper.isDefaultConfig();
    }

    private boolean setDisplayPolicy(int policy) {
        if (this.mDisplayPolicy == policy) {
            return false;
        }
        int oldPolicy = this.mDisplayPolicy;
        this.mDisplayPolicy = policy;
        if (!AutomaticBrightnessController.isInteractivePolicy(policy) && AutomaticBrightnessController.isInteractivePolicy(oldPolicy)) {
            this.mHandler.sendEmptyMessageDelayed(3, 30000L);
        } else if (AutomaticBrightnessController.isInteractivePolicy(policy) && !AutomaticBrightnessController.isInteractivePolicy(oldPolicy)) {
            this.mHandler.removeMessages(3);
        }
        return true;
    }

    private static boolean isInteractivePolicy(int policy) {
        return policy == 3 || policy == 2 || policy == 4;
    }

    private boolean setScreenBrightnessByUser(float brightness) {
        if (!this.mAmbientLuxValid) {
            return false;
        }
        this.mBrightnessMapper.addUserDataPoint(this.mAmbientLux, brightness);
        this.mScreenAutoBrightnessAdjustment = 0.0f;
        return true;
    }

    private void resetShortTermModel() {
        this.mBrightnessMapper.clearUserDataPoints();
    }

    public boolean setBrightnessConfiguration(BrightnessConfiguration configuration) {
        return this.mBrightnessMapper.setBrightnessConfiguration(configuration);
    }

    public void dump(PrintWriter pw) {
        pw.println();
        pw.println("Automatic Brightness Controller Configuration:");
        pw.println("  mScreenBrightnessRangeMinimum=" + this.mScreenBrightnessRangeMinimum);
        pw.println("  mScreenBrightnessRangeMaximum=" + this.mScreenBrightnessRangeMaximum);
        pw.println("  mLightSensorWarmUpTimeConfig=" + this.mLightSensorWarmUpTimeConfig);
        pw.println("  mBrighteningLightDebounceConfig=" + this.mBrighteningLightDebounceConfig);
        pw.println("  mDarkeningLightDebounceConfig=" + this.mDarkeningLightDebounceConfig);
        pw.println("  mResetAmbientLuxAfterWarmUpConfig=" + this.mResetAmbientLuxAfterWarmUpConfig);
        pw.println();
        pw.println("Automatic Brightness Controller State:");
        pw.println("  mLightSensor=" + this.mLightSensor);
        pw.println("  mLightSensorEnabled=" + this.mLightSensorEnabled);
        pw.println("  mLightSensorEnableTime=" + TimeUtils.formatUptime(this.mLightSensorEnableTime));
        pw.println("  mAmbientLux=" + this.mAmbientLux);
        pw.println("  mAmbientLightHorizon=" + this.mAmbientLightHorizon);
        pw.println("  mBrighteningLuxThreshold=" + this.mBrighteningLuxThreshold);
        pw.println("  mDarkeningLuxThreshold=" + this.mDarkeningLuxThreshold);
        pw.println("  mLastObservedLux=" + this.mLastObservedLux);
        pw.println("  mLastObservedLuxTime=" + TimeUtils.formatUptime(this.mLastObservedLuxTime));
        pw.println("  mRecentLightSamples=" + this.mRecentLightSamples);
        pw.println("  mAmbientLightRingBuffer=" + this.mAmbientLightRingBuffer);
        pw.println("  mInitialHorizonAmbientLightRingBuffer=" + this.mInitialHorizonAmbientLightRingBuffer);
        pw.println("  mScreenAutoBrightness=" + this.mScreenAutoBrightness);
        pw.println("  mScreenAutoBrightnessAdjustment=" + this.mScreenAutoBrightnessAdjustment);
        pw.println("  mScreenAutoBrightnessAdjustmentMaxGamma=" + this.mScreenAutoBrightnessAdjustmentMaxGamma);
        pw.println("  mLastScreenAutoBrightnessGamma=" + this.mLastScreenAutoBrightnessGamma);
        pw.println("  mDisplayPolicy=" + this.mDisplayPolicy);
        pw.println();
        this.mBrightnessMapper.dump(pw);
    }

    private boolean setLightSensorEnabled(boolean enable) {
        if (enable) {
            if (!this.mLightSensorEnabled) {
                this.mLightSensorEnabled = true;
                this.mLightSensorEnableTime = SystemClock.uptimeMillis();
                this.mCurrentLightSensorRate = this.mInitialLightSensorRate;
                this.mSensorManager.registerListener(this.mLightSensorListener, this.mLightSensor, this.mCurrentLightSensorRate * 1000, this.mHandler);
                return true;
            }
        } else if (this.mLightSensorEnabled) {
            this.mLightSensorEnabled = false;
            this.mAmbientLuxValid = !this.mResetAmbientLuxAfterWarmUpConfig;
            this.mRecentLightSamples = 0;
            this.mAmbientLightRingBuffer.clear();
            this.mInitialHorizonAmbientLightRingBuffer.clear();
            this.mCurrentLightSensorRate = -1;
            this.mHandler.removeMessages(1);
            this.mSensorManager.unregisterListener(this.mLightSensorListener);
        }
        return false;
    }

    private void handleLightSensorEvent(long time, float lux) {
        Trace.traceCounter(131072L, "ALS", (int)lux);
        this.mHandler.removeMessages(1);
        if (this.mAmbientLightRingBuffer.size() == 0) {
            this.adjustLightSensorRate(this.mNormalLightSensorRate);
        }
        this.applyLightSensorMeasurement(time, lux);
        this.updateAmbientLux(time);
    }

    private void applyLightSensorMeasurement(long time, float lux) {
        ++this.mRecentLightSamples;
        if (time <= this.mLightSensorEnableTime + (long)this.mAmbientLightHorizon) {
            this.mInitialHorizonAmbientLightRingBuffer.push(time, lux);
        }
        this.mAmbientLightRingBuffer.prune(time - (long)this.mAmbientLightHorizon);
        this.mAmbientLightRingBuffer.push(time, lux);
        this.mLastObservedLux = lux;
        this.mLastObservedLuxTime = time;
    }

    private void adjustLightSensorRate(int lightSensorRate) {
        if (lightSensorRate != this.mCurrentLightSensorRate) {
            this.mCurrentLightSensorRate = lightSensorRate;
            this.mSensorManager.unregisterListener(this.mLightSensorListener);
            this.mSensorManager.registerListener(this.mLightSensorListener, this.mLightSensor, lightSensorRate * 1000, this.mHandler);
        }
    }

    private boolean setScreenAutoBrightnessAdjustment(float adjustment) {
        if (adjustment != this.mScreenAutoBrightnessAdjustment) {
            this.mScreenAutoBrightnessAdjustment = adjustment;
            return true;
        }
        return false;
    }

    private void setAmbientLux(float lux) {
        if (lux < 0.0f) {
            Slog.w(TAG, "Ambient lux was negative, ignoring and setting to 0.");
            lux = 0.0f;
        }
        this.mAmbientLux = lux;
        this.mBrighteningLuxThreshold = this.mDynamicHysteresis.getBrighteningThreshold(lux);
        this.mDarkeningLuxThreshold = this.mDynamicHysteresis.getDarkeningThreshold(lux);
    }

    private float calculateAmbientLux(long now, long horizon) {
        int N = this.mAmbientLightRingBuffer.size();
        if (N == 0) {
            Slog.e(TAG, "calculateAmbientLux: No ambient light readings available");
            return -1.0f;
        }
        int endIndex = 0;
        long horizonStartTime = now - horizon;
        for (int i = 0; i < N - 1 && this.mAmbientLightRingBuffer.getTime(i + 1) <= horizonStartTime; ++i) {
            ++endIndex;
        }
        float sum = 0.0f;
        float totalWeight = 0.0f;
        long endTime = 100L;
        for (int i = N - 1; i >= endIndex; --i) {
            long eventTime = this.mAmbientLightRingBuffer.getTime(i);
            if (i == endIndex && eventTime < horizonStartTime) {
                eventTime = horizonStartTime;
            }
            long startTime = eventTime - now;
            float weight = this.calculateWeight(startTime, endTime);
            float lux = this.mAmbientLightRingBuffer.getLux(i);
            totalWeight += weight;
            sum += this.mAmbientLightRingBuffer.getLux(i) * weight;
            endTime = startTime;
        }
        return sum / totalWeight;
    }

    private float calculateWeight(long startDelta, long endDelta) {
        return this.weightIntegral(endDelta) - this.weightIntegral(startDelta);
    }

    private float weightIntegral(long x) {
        return (float)x * ((float)x * 0.5f + (float)this.mWeightingIntercept);
    }

    private long nextAmbientLightBrighteningTransition(long time) {
        int N = this.mAmbientLightRingBuffer.size();
        long earliestValidTime = time;
        for (int i = N - 1; i >= 0 && !(this.mAmbientLightRingBuffer.getLux(i) <= this.mBrighteningLuxThreshold); --i) {
            earliestValidTime = this.mAmbientLightRingBuffer.getTime(i);
        }
        return earliestValidTime + this.mBrighteningLightDebounceConfig;
    }

    private long nextAmbientLightDarkeningTransition(long time) {
        int N = this.mAmbientLightRingBuffer.size();
        long earliestValidTime = time;
        for (int i = N - 1; i >= 0 && !(this.mAmbientLightRingBuffer.getLux(i) >= this.mDarkeningLuxThreshold); --i) {
            earliestValidTime = this.mAmbientLightRingBuffer.getTime(i);
        }
        return earliestValidTime + this.mDarkeningLightDebounceConfig;
    }

    private void updateAmbientLux() {
        long time = SystemClock.uptimeMillis();
        this.mAmbientLightRingBuffer.prune(time - (long)this.mAmbientLightHorizon);
        this.updateAmbientLux(time);
    }

    private void updateAmbientLux(long time) {
        long nextTransitionTime;
        if (!this.mAmbientLuxValid) {
            long timeWhenSensorWarmedUp = (long)this.mLightSensorWarmUpTimeConfig + this.mLightSensorEnableTime;
            if (time < timeWhenSensorWarmedUp) {
                this.mHandler.sendEmptyMessageAtTime(1, timeWhenSensorWarmedUp);
                return;
            }
            this.setAmbientLux(this.calculateAmbientLux(time, 2000L));
            this.mAmbientLuxValid = true;
            this.updateAutoBrightness(true);
        }
        long nextBrightenTransition = this.nextAmbientLightBrighteningTransition(time);
        long nextDarkenTransition = this.nextAmbientLightDarkeningTransition(time);
        float slowAmbientLux = this.calculateAmbientLux(time, 10000L);
        float fastAmbientLux = this.calculateAmbientLux(time, 2000L);
        if (slowAmbientLux >= this.mBrighteningLuxThreshold && fastAmbientLux >= this.mBrighteningLuxThreshold && nextBrightenTransition <= time || slowAmbientLux <= this.mDarkeningLuxThreshold && fastAmbientLux <= this.mDarkeningLuxThreshold && nextDarkenTransition <= time) {
            this.setAmbientLux(fastAmbientLux);
            this.updateAutoBrightness(true);
            nextBrightenTransition = this.nextAmbientLightBrighteningTransition(time);
            nextDarkenTransition = this.nextAmbientLightDarkeningTransition(time);
        }
        nextTransitionTime = (nextTransitionTime = Math.min(nextDarkenTransition, nextBrightenTransition)) > time ? nextTransitionTime : time + (long)this.mNormalLightSensorRate;
        this.mHandler.sendEmptyMessageAtTime(1, nextTransitionTime);
    }

    private void updateAutoBrightness(boolean sendUpdate) {
        int newScreenAutoBrightness;
        if (!this.mAmbientLuxValid) {
            return;
        }
        float value = this.mBrightnessMapper.getBrightness(this.mAmbientLux);
        float gamma = 1.0f;
        if (this.mScreenAutoBrightnessAdjustment != 0.0f) {
            float adjGamma = MathUtils.pow(this.mScreenAutoBrightnessAdjustmentMaxGamma, Math.min(1.0f, Math.max(-1.0f, -this.mScreenAutoBrightnessAdjustment)));
            gamma *= adjGamma;
        }
        if (gamma != 1.0f) {
            float in = value;
            value = MathUtils.pow(value, gamma);
        }
        if (this.mScreenAutoBrightness != (newScreenAutoBrightness = this.clampScreenBrightness(Math.round(value * 255.0f)))) {
            this.mScreenAutoBrightness = newScreenAutoBrightness;
            this.mLastScreenAutoBrightnessGamma = gamma;
            if (sendUpdate) {
                this.mCallbacks.updateBrightness();
            }
        }
    }

    private int clampScreenBrightness(int value) {
        return MathUtils.constrain(value, this.mScreenBrightnessRangeMinimum, this.mScreenBrightnessRangeMaximum);
    }

    private void prepareBrightnessAdjustmentSample() {
        if (!this.mBrightnessAdjustmentSamplePending) {
            this.mBrightnessAdjustmentSamplePending = true;
            this.mBrightnessAdjustmentSampleOldAdjustment = this.mScreenAutoBrightnessAdjustment;
            this.mBrightnessAdjustmentSampleOldLux = this.mAmbientLuxValid ? this.mAmbientLux : -1.0f;
            this.mBrightnessAdjustmentSampleOldBrightness = this.mScreenAutoBrightness;
            this.mBrightnessAdjustmentSampleOldGamma = this.mLastScreenAutoBrightnessGamma;
        } else {
            this.mHandler.removeMessages(2);
        }
        this.mHandler.sendEmptyMessageDelayed(2, 10000L);
    }

    private void cancelBrightnessAdjustmentSample() {
        if (this.mBrightnessAdjustmentSamplePending) {
            this.mBrightnessAdjustmentSamplePending = false;
            this.mHandler.removeMessages(2);
        }
    }

    private void collectBrightnessAdjustmentSample() {
        if (this.mBrightnessAdjustmentSamplePending) {
            this.mBrightnessAdjustmentSamplePending = false;
            if (this.mAmbientLuxValid && this.mScreenAutoBrightness >= 0) {
                EventLog.writeEvent(35000, Float.valueOf(this.mBrightnessAdjustmentSampleOldAdjustment), Float.valueOf(this.mBrightnessAdjustmentSampleOldLux), this.mBrightnessAdjustmentSampleOldBrightness, Float.valueOf(this.mBrightnessAdjustmentSampleOldGamma), Float.valueOf(this.mScreenAutoBrightnessAdjustment), Float.valueOf(this.mAmbientLux), this.mScreenAutoBrightness, Float.valueOf(this.mLastScreenAutoBrightnessGamma));
            }
        }
    }

    private static final class AmbientLightRingBuffer {
        private static final float BUFFER_SLACK = 1.5f;
        private float[] mRingLux;
        private long[] mRingTime;
        private int mCapacity;
        private int mStart;
        private int mEnd;
        private int mCount;

        public AmbientLightRingBuffer(long lightSensorRate, int ambientLightHorizon) {
            this.mCapacity = (int)Math.ceil((float)ambientLightHorizon * 1.5f / (float)lightSensorRate);
            this.mRingLux = new float[this.mCapacity];
            this.mRingTime = new long[this.mCapacity];
        }

        public float getLux(int index) {
            return this.mRingLux[this.offsetOf(index)];
        }

        public long getTime(int index) {
            return this.mRingTime[this.offsetOf(index)];
        }

        public void push(long time, float lux) {
            int next = this.mEnd;
            if (this.mCount == this.mCapacity) {
                int newSize = this.mCapacity * 2;
                float[] newRingLux = new float[newSize];
                long[] newRingTime = new long[newSize];
                int length = this.mCapacity - this.mStart;
                System.arraycopy((float[])this.mRingLux, (int)this.mStart, (float[])newRingLux, (int)0, (int)length);
                System.arraycopy((long[])this.mRingTime, (int)this.mStart, (long[])newRingTime, (int)0, (int)length);
                if (this.mStart != 0) {
                    System.arraycopy((float[])this.mRingLux, (int)0, (float[])newRingLux, (int)length, (int)this.mStart);
                    System.arraycopy((long[])this.mRingTime, (int)0, (long[])newRingTime, (int)length, (int)this.mStart);
                }
                this.mRingLux = newRingLux;
                this.mRingTime = newRingTime;
                next = this.mCapacity;
                this.mCapacity = newSize;
                this.mStart = 0;
            }
            this.mRingTime[next] = time;
            this.mRingLux[next] = lux;
            this.mEnd = next + 1;
            if (this.mEnd == this.mCapacity) {
                this.mEnd = 0;
            }
            ++this.mCount;
        }

        public void prune(long horizon) {
            if (this.mCount == 0) {
                return;
            }
            while (this.mCount > 1) {
                int next = this.mStart + 1;
                if (next >= this.mCapacity) {
                    next -= this.mCapacity;
                }
                if (this.mRingTime[next] > horizon) break;
                this.mStart = next;
                --this.mCount;
            }
            if (this.mRingTime[this.mStart] < horizon) {
                this.mRingTime[this.mStart] = horizon;
            }
        }

        public int size() {
            return this.mCount;
        }

        public void clear() {
            this.mStart = 0;
            this.mEnd = 0;
            this.mCount = 0;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append('[');
            for (int i = 0; i < this.mCount; ++i) {
                long next;
                long l = next = i + 1 < this.mCount ? this.getTime(i + 1) : SystemClock.uptimeMillis();
                if (i != 0) {
                    buf.append(", ");
                }
                buf.append(this.getLux(i));
                buf.append(" / ");
                buf.append(next - this.getTime(i));
                buf.append("ms");
            }
            buf.append(']');
            return buf.toString();
        }

        private int offsetOf(int index) {
            if (index >= this.mCount || index < 0) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            if ((index += this.mStart) >= this.mCapacity) {
                index -= this.mCapacity;
            }
            return index;
        }
    }

    static interface Callbacks {
        public void updateBrightness();
    }

    private final class AutomaticBrightnessHandler
    extends Handler {
        public AutomaticBrightnessHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AutomaticBrightnessController.this.updateAmbientLux();
                    break;
                }
                case 2: {
                    AutomaticBrightnessController.this.collectBrightnessAdjustmentSample();
                    break;
                }
                case 3: {
                    AutomaticBrightnessController.this.resetShortTermModel();
                }
            }
        }
    }
}

