/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ParceledListSlice;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.hardware.display.AmbientBrightnessDayStats;
import android.hardware.display.BrightnessChangeEvent;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserManager;
import android.provider.Settings;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.RingBuffer;
import com.android.server.display.AmbientBrightnessStatsTracker;
import com.android.server.display.BrightnessIdleJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BrightnessTracker {
    static final String TAG = "BrightnessTracker";
    static final boolean DEBUG = false;
    private static final String EVENTS_FILE = "brightness_events.xml";
    private static final String AMBIENT_BRIGHTNESS_STATS_FILE = "ambient_brightness_stats.xml";
    private static final int MAX_EVENTS = 100;
    private static final long MAX_EVENT_AGE = TimeUnit.DAYS.toMillis(30L);
    private static final long LUX_EVENT_HORIZON = TimeUnit.SECONDS.toNanos(10L);
    private static final String TAG_EVENTS = "events";
    private static final String TAG_EVENT = "event";
    private static final String ATTR_NITS = "nits";
    private static final String ATTR_TIMESTAMP = "timestamp";
    private static final String ATTR_PACKAGE_NAME = "packageName";
    private static final String ATTR_USER = "user";
    private static final String ATTR_LUX = "lux";
    private static final String ATTR_LUX_TIMESTAMPS = "luxTimestamps";
    private static final String ATTR_BATTERY_LEVEL = "batteryLevel";
    private static final String ATTR_NIGHT_MODE = "nightMode";
    private static final String ATTR_COLOR_TEMPERATURE = "colorTemperature";
    private static final String ATTR_LAST_NITS = "lastNits";
    private static final String ATTR_DEFAULT_CONFIG = "defaultConfig";
    private static final String ATTR_POWER_SAVE = "powerSaveFactor";
    private static final String ATTR_USER_POINT = "userPoint";
    private static final int MSG_BACKGROUND_START = 0;
    private static final int MSG_BRIGHTNESS_CHANGED = 1;
    private final Object mEventsLock = new Object();
    @GuardedBy(value="mEventsLock")
    private RingBuffer<BrightnessChangeEvent> mEvents = new RingBuffer<BrightnessChangeEvent>(BrightnessChangeEvent.class, 100);
    @GuardedBy(value="mEventsLock")
    private boolean mEventsDirty;
    private final Runnable mEventsWriter = () -> this.writeEvents();
    private volatile boolean mWriteEventsScheduled;
    private AmbientBrightnessStatsTracker mAmbientBrightnessStatsTracker;
    private final Runnable mAmbientBrightnessStatsWriter = () -> this.writeAmbientBrightnessStats();
    private volatile boolean mWriteBrightnessStatsScheduled;
    private UserManager mUserManager;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private Handler mBgHandler;
    private BroadcastReceiver mBroadcastReceiver;
    private SensorListener mSensorListener;
    private int mCurrentUserId = -10000;
    private final Object mDataCollectionLock = new Object();
    @GuardedBy(value="mDataCollectionLock")
    private Deque<LightData> mLastSensorReadings = new ArrayDeque<LightData>();
    @GuardedBy(value="mDataCollectionLock")
    private float mLastBatteryLevel = Float.NaN;
    @GuardedBy(value="mDataCollectionLock")
    private float mLastBrightness = -1.0f;
    @GuardedBy(value="mDataCollectionLock")
    private boolean mStarted;
    private final Injector mInjector;

    public BrightnessTracker(Context context, Injector injector) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mInjector = injector != null ? injector : new Injector();
    }

    public void start(float initialBrightness) {
        this.mBgHandler = new TrackerHandler(this.mInjector.getBackgroundHandler().getLooper());
        this.mUserManager = this.mContext.getSystemService(UserManager.class);
        try {
            ActivityManager.StackInfo focusedStack = this.mInjector.getFocusedStack();
            this.mCurrentUserId = focusedStack.userId;
        }
        catch (RemoteException e) {
            return;
        }
        this.mBgHandler.obtainMessage(0, Float.valueOf(initialBrightness)).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backgroundStart(float initialBrightness) {
        this.readEvents();
        this.readAmbientBrightnessStats();
        this.mSensorListener = new SensorListener();
        if (this.mInjector.isInteractive(this.mContext)) {
            this.mInjector.registerSensorListener(this.mContext, this.mSensorListener, this.mBgHandler);
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.ACTION_SHUTDOWN");
        intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        this.mBroadcastReceiver = new Receiver();
        this.mInjector.registerReceiver(this.mContext, this.mBroadcastReceiver, intentFilter);
        this.mInjector.scheduleIdleJob(this.mContext);
        Object object = this.mDataCollectionLock;
        synchronized (object) {
            this.mLastBrightness = initialBrightness;
            this.mStarted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void stop() {
        this.mBgHandler.removeMessages(0);
        this.mInjector.unregisterSensorListener(this.mContext, this.mSensorListener);
        this.mInjector.unregisterReceiver(this.mContext, this.mBroadcastReceiver);
        this.mInjector.cancelIdleJob(this.mContext);
        this.mAmbientBrightnessStatsTracker.stop();
        Object object = this.mDataCollectionLock;
        synchronized (object) {
            this.mStarted = false;
        }
    }

    public void onSwitchUser(int newUserId) {
        this.mCurrentUserId = newUserId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParceledListSlice<BrightnessChangeEvent> getEvents(int userId, boolean includePackage) {
        BrightnessChangeEvent[] events;
        Object object = this.mEventsLock;
        synchronized (object) {
            events = this.mEvents.toArray();
        }
        ArrayList<BrightnessChangeEvent> out = new ArrayList<BrightnessChangeEvent>(events.length);
        for (int i = 0; i < events.length; ++i) {
            if (events[i].userId != userId) continue;
            if (includePackage) {
                out.add(events[i]);
                continue;
            }
            BrightnessChangeEvent event = new BrightnessChangeEvent(events[i], true);
            out.add(event);
        }
        return new ParceledListSlice<BrightnessChangeEvent>(out);
    }

    public void persistBrightnessTrackerState() {
        this.scheduleWriteBrightnessTrackerState();
    }

    public void notifyBrightnessChanged(float brightness, boolean userInitiated, float powerBrightnessFactor, boolean isUserSetBrightness, boolean isDefaultBrightnessConfig) {
        Message m = this.mBgHandler.obtainMessage(1, userInitiated ? 1 : 0, 0, new BrightnessChangeValues(brightness, powerBrightnessFactor, isUserSetBrightness, isDefaultBrightnessConfig));
        m.sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBrightnessChanged(float brightness, boolean userInitiated, float powerBrightnessFactor, boolean isUserSetBrightness, boolean isDefaultBrightnessConfig) {
        BrightnessChangeEvent.Builder builder;
        Object object = this.mDataCollectionLock;
        synchronized (object) {
            if (!this.mStarted) {
                return;
            }
            float previousBrightness = this.mLastBrightness;
            this.mLastBrightness = brightness;
            if (!userInitiated) {
                return;
            }
            builder = new BrightnessChangeEvent.Builder();
            builder.setBrightness(brightness);
            builder.setTimeStamp(this.mInjector.currentTimeMillis());
            builder.setPowerBrightnessFactor(powerBrightnessFactor);
            builder.setUserBrightnessPoint(isUserSetBrightness);
            builder.setIsDefaultBrightnessConfig(isDefaultBrightnessConfig);
            int readingCount = this.mLastSensorReadings.size();
            if (readingCount == 0) {
                return;
            }
            float[] luxValues = new float[readingCount];
            long[] luxTimestamps = new long[readingCount];
            int pos = 0;
            long currentTimeMillis = this.mInjector.currentTimeMillis();
            long elapsedTimeNanos = this.mInjector.elapsedRealtimeNanos();
            for (LightData reading : this.mLastSensorReadings) {
                luxValues[pos] = reading.lux;
                luxTimestamps[pos] = currentTimeMillis - TimeUnit.NANOSECONDS.toMillis(elapsedTimeNanos - reading.timestamp);
                ++pos;
            }
            builder.setLuxValues(luxValues);
            builder.setLuxTimestamps(luxTimestamps);
            builder.setBatteryLevel(this.mLastBatteryLevel);
            builder.setLastBrightness(previousBrightness);
        }
        try {
            ActivityManager.StackInfo focusedStack = this.mInjector.getFocusedStack();
            builder.setUserId(focusedStack.userId);
            builder.setPackageName(focusedStack.topActivity.getPackageName());
        }
        catch (RemoteException e) {
            return;
        }
        builder.setNightMode(this.mInjector.getSecureIntForUser(this.mContentResolver, "night_display_activated", 0, -2) == 1);
        builder.setColorTemperature(this.mInjector.getSecureIntForUser(this.mContentResolver, "night_display_color_temperature", 0, -2));
        BrightnessChangeEvent event = builder.build();
        Object object2 = this.mEventsLock;
        synchronized (object2) {
            this.mEventsDirty = true;
            this.mEvents.append(event);
        }
    }

    private void scheduleWriteBrightnessTrackerState() {
        if (!this.mWriteEventsScheduled) {
            this.mBgHandler.post(this.mEventsWriter);
            this.mWriteEventsScheduled = true;
        }
        if (!this.mWriteBrightnessStatsScheduled) {
            this.mBgHandler.post(this.mAmbientBrightnessStatsWriter);
            this.mWriteBrightnessStatsScheduled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEvents() {
        this.mWriteEventsScheduled = false;
        Object object = this.mEventsLock;
        synchronized (object) {
            if (!this.mEventsDirty) {
                return;
            }
            AtomicFile writeTo = this.mInjector.getFile(EVENTS_FILE);
            if (writeTo == null) {
                return;
            }
            if (this.mEvents.isEmpty()) {
                if (writeTo.exists()) {
                    writeTo.delete();
                }
                this.mEventsDirty = false;
            } else {
                FileOutputStream output = null;
                try {
                    output = writeTo.startWrite();
                    this.writeEventsLocked(output);
                    writeTo.finishWrite(output);
                    this.mEventsDirty = false;
                }
                catch (IOException e) {
                    writeTo.failWrite(output);
                    Slog.e(TAG, "Failed to write change mEvents.", e);
                }
            }
        }
    }

    private void writeAmbientBrightnessStats() {
        this.mWriteBrightnessStatsScheduled = false;
        AtomicFile writeTo = this.mInjector.getFile(AMBIENT_BRIGHTNESS_STATS_FILE);
        if (writeTo == null) {
            return;
        }
        FileOutputStream output = null;
        try {
            output = writeTo.startWrite();
            this.mAmbientBrightnessStatsTracker.writeStats(output);
            writeTo.finishWrite(output);
        }
        catch (IOException e) {
            writeTo.failWrite(output);
            Slog.e(TAG, "Failed to write ambient brightness stats.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readEvents() {
        Object object = this.mEventsLock;
        synchronized (object) {
            this.mEventsDirty = true;
            this.mEvents.clear();
            AtomicFile readFrom = this.mInjector.getFile(EVENTS_FILE);
            if (readFrom != null && readFrom.exists()) {
                FileInputStream input = null;
                try {
                    input = readFrom.openRead();
                    this.readEventsLocked(input);
                }
                catch (IOException e) {
                    readFrom.delete();
                    Slog.e(TAG, "Failed to read change mEvents.", e);
                }
                finally {
                    IoUtils.closeQuietly(input);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAmbientBrightnessStats() {
        this.mAmbientBrightnessStatsTracker = new AmbientBrightnessStatsTracker(this.mUserManager, null);
        AtomicFile readFrom = this.mInjector.getFile(AMBIENT_BRIGHTNESS_STATS_FILE);
        if (readFrom != null && readFrom.exists()) {
            FileInputStream input = null;
            try {
                input = readFrom.openRead();
                this.mAmbientBrightnessStatsTracker.readStats(input);
            }
            catch (IOException e) {
                readFrom.delete();
                Slog.e(TAG, "Failed to read ambient brightness stats.", e);
            }
            finally {
                IoUtils.closeQuietly(input);
            }
        }
    }

    @VisibleForTesting
    @GuardedBy(value="mEventsLock")
    void writeEventsLocked(OutputStream stream) throws IOException {
        FastXmlSerializer out = new FastXmlSerializer();
        out.setOutput(stream, StandardCharsets.UTF_8.name());
        out.startDocument(null, true);
        out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        out.startTag(null, TAG_EVENTS);
        BrightnessChangeEvent[] toWrite = this.mEvents.toArray();
        this.mEvents.clear();
        long timeCutOff = this.mInjector.currentTimeMillis() - MAX_EVENT_AGE;
        for (int i = 0; i < toWrite.length; ++i) {
            int userSerialNo = this.mInjector.getUserSerialNumber(this.mUserManager, toWrite[i].userId);
            if (userSerialNo == -1 || toWrite[i].timeStamp <= timeCutOff) continue;
            this.mEvents.append(toWrite[i]);
            out.startTag(null, TAG_EVENT);
            out.attribute(null, ATTR_NITS, Float.toString(toWrite[i].brightness));
            out.attribute(null, ATTR_TIMESTAMP, Long.toString(toWrite[i].timeStamp));
            out.attribute(null, ATTR_PACKAGE_NAME, toWrite[i].packageName);
            out.attribute(null, ATTR_USER, Integer.toString(userSerialNo));
            out.attribute(null, ATTR_BATTERY_LEVEL, Float.toString(toWrite[i].batteryLevel));
            out.attribute(null, ATTR_NIGHT_MODE, Boolean.toString(toWrite[i].nightMode));
            out.attribute(null, ATTR_COLOR_TEMPERATURE, Integer.toString(toWrite[i].colorTemperature));
            out.attribute(null, ATTR_LAST_NITS, Float.toString(toWrite[i].lastBrightness));
            out.attribute(null, ATTR_DEFAULT_CONFIG, Boolean.toString(toWrite[i].isDefaultBrightnessConfig));
            out.attribute(null, ATTR_POWER_SAVE, Float.toString(toWrite[i].powerBrightnessFactor));
            out.attribute(null, ATTR_USER_POINT, Boolean.toString(toWrite[i].isUserSetBrightness));
            StringBuilder luxValues = new StringBuilder();
            StringBuilder luxTimestamps = new StringBuilder();
            for (int j = 0; j < toWrite[i].luxValues.length; ++j) {
                if (j > 0) {
                    luxValues.append(',');
                    luxTimestamps.append(',');
                }
                luxValues.append(Float.toString(toWrite[i].luxValues[j]));
                luxTimestamps.append(Long.toString(toWrite[i].luxTimestamps[j]));
            }
            out.attribute(null, ATTR_LUX, luxValues.toString());
            out.attribute(null, ATTR_LUX_TIMESTAMPS, luxTimestamps.toString());
            out.endTag(null, TAG_EVENT);
        }
        out.endTag(null, TAG_EVENTS);
        out.endDocument();
        stream.flush();
    }

    @VisibleForTesting
    @GuardedBy(value="mEventsLock")
    void readEventsLocked(InputStream stream) throws IOException {
        try {
            int type;
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String tag = parser.getName();
            if (!TAG_EVENTS.equals(tag)) {
                throw new XmlPullParserException("Events not found in brightness tracker file " + tag);
            }
            long timeCutOff = this.mInjector.currentTimeMillis() - MAX_EVENT_AGE;
            parser.next();
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                String powerSave;
                if (type == 3 || type == 4 || !TAG_EVENT.equals(tag = parser.getName())) continue;
                BrightnessChangeEvent.Builder builder = new BrightnessChangeEvent.Builder();
                String brightness = parser.getAttributeValue(null, ATTR_NITS);
                builder.setBrightness(Float.parseFloat(brightness));
                String timestamp = parser.getAttributeValue(null, ATTR_TIMESTAMP);
                builder.setTimeStamp(Long.parseLong(timestamp));
                builder.setPackageName(parser.getAttributeValue(null, ATTR_PACKAGE_NAME));
                String user = parser.getAttributeValue(null, ATTR_USER);
                builder.setUserId(this.mInjector.getUserId(this.mUserManager, Integer.parseInt(user)));
                String batteryLevel = parser.getAttributeValue(null, ATTR_BATTERY_LEVEL);
                builder.setBatteryLevel(Float.parseFloat(batteryLevel));
                String nightMode = parser.getAttributeValue(null, ATTR_NIGHT_MODE);
                builder.setNightMode(Boolean.parseBoolean(nightMode));
                String colorTemperature = parser.getAttributeValue(null, ATTR_COLOR_TEMPERATURE);
                builder.setColorTemperature(Integer.parseInt(colorTemperature));
                String lastBrightness = parser.getAttributeValue(null, ATTR_LAST_NITS);
                builder.setLastBrightness(Float.parseFloat(lastBrightness));
                String luxValue = parser.getAttributeValue(null, ATTR_LUX);
                String luxTimestamp = parser.getAttributeValue(null, ATTR_LUX_TIMESTAMPS);
                String[] luxValuesStrings = luxValue.split(",");
                String[] luxTimestampsStrings = luxTimestamp.split(",");
                if (luxValuesStrings.length != luxTimestampsStrings.length) continue;
                float[] luxValues = new float[luxValuesStrings.length];
                long[] luxTimestamps = new long[luxValuesStrings.length];
                for (int i = 0; i < luxValues.length; ++i) {
                    luxValues[i] = Float.parseFloat(luxValuesStrings[i]);
                    luxTimestamps[i] = Long.parseLong(luxTimestampsStrings[i]);
                }
                builder.setLuxValues(luxValues);
                builder.setLuxTimestamps(luxTimestamps);
                String defaultConfig = parser.getAttributeValue(null, ATTR_DEFAULT_CONFIG);
                if (defaultConfig != null) {
                    builder.setIsDefaultBrightnessConfig(Boolean.parseBoolean(defaultConfig));
                }
                if ((powerSave = parser.getAttributeValue(null, ATTR_POWER_SAVE)) != null) {
                    builder.setPowerBrightnessFactor(Float.parseFloat(powerSave));
                } else {
                    builder.setPowerBrightnessFactor(1.0f);
                }
                String userPoint = parser.getAttributeValue(null, ATTR_USER_POINT);
                if (userPoint != null) {
                    builder.setUserBrightnessPoint(Boolean.parseBoolean(userPoint));
                }
                BrightnessChangeEvent event = builder.build();
                if (event.userId == -1 || event.timeStamp <= timeCutOff || event.luxValues.length <= 0) continue;
                this.mEvents.append(event);
            }
        }
        catch (IOException | NullPointerException | NumberFormatException | XmlPullParserException e) {
            this.mEvents = new RingBuffer<BrightnessChangeEvent>(BrightnessChangeEvent.class, 100);
            Slog.e(TAG, "Failed to parse brightness event", e);
            throw new IOException("failed to parse file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        pw.println("BrightnessTracker state:");
        Object object = this.mDataCollectionLock;
        synchronized (object) {
            pw.println("  mStarted=" + this.mStarted);
            pw.println("  mLastSensorReadings.size=" + this.mLastSensorReadings.size());
            if (!this.mLastSensorReadings.isEmpty()) {
                pw.println("  mLastSensorReadings time span " + this.mLastSensorReadings.peekFirst().timestamp + "->" + this.mLastSensorReadings.peekLast().timestamp);
            }
        }
        object = this.mEventsLock;
        synchronized (object) {
            pw.println("  mEventsDirty=" + this.mEventsDirty);
            pw.println("  mEvents.size=" + this.mEvents.size());
            BrightnessChangeEvent[] events = this.mEvents.toArray();
            for (int i = 0; i < events.length; ++i) {
                pw.print("    " + events[i].timeStamp + ", " + events[i].userId);
                pw.print(", " + events[i].lastBrightness + "->" + events[i].brightness);
                pw.print(", isUserSetBrightness=" + events[i].isUserSetBrightness);
                pw.print(", powerBrightnessFactor=" + events[i].powerBrightnessFactor);
                pw.print(", isDefaultBrightnessConfig=" + events[i].isDefaultBrightnessConfig);
                pw.print(" {");
                for (int j = 0; j < events[i].luxValues.length; ++j) {
                    if (j != 0) {
                        pw.print(", ");
                    }
                    pw.print("(" + events[i].luxValues[j] + "," + events[i].luxTimestamps[j] + ")");
                }
                pw.println("}");
            }
        }
        if (this.mAmbientBrightnessStatsTracker != null) {
            this.mAmbientBrightnessStatsTracker.dump(pw);
        }
    }

    public ParceledListSlice<AmbientBrightnessDayStats> getAmbientBrightnessStats(int userId) {
        return new ParceledListSlice<AmbientBrightnessDayStats>(this.mAmbientBrightnessStatsTracker.getUserStats(userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordSensorEvent(SensorEvent event) {
        long horizon = this.mInjector.elapsedRealtimeNanos() - LUX_EVENT_HORIZON;
        Object object = this.mDataCollectionLock;
        synchronized (object) {
            if (!this.mLastSensorReadings.isEmpty() && event.timestamp < this.mLastSensorReadings.getLast().timestamp) {
                return;
            }
            LightData data = null;
            while (!this.mLastSensorReadings.isEmpty() && this.mLastSensorReadings.getFirst().timestamp < horizon) {
                data = this.mLastSensorReadings.removeFirst();
            }
            if (data != null) {
                this.mLastSensorReadings.addFirst(data);
            }
            data = new LightData();
            data.timestamp = event.timestamp;
            data.lux = event.values[0];
            this.mLastSensorReadings.addLast(data);
        }
    }

    private void recordAmbientBrightnessStats(SensorEvent event) {
        this.mAmbientBrightnessStatsTracker.add(this.mCurrentUserId, event.values[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batteryLevelChanged(int level, int scale) {
        Object object = this.mDataCollectionLock;
        synchronized (object) {
            this.mLastBatteryLevel = (float)level / (float)scale;
        }
    }

    @VisibleForTesting
    static class Injector {
        Injector() {
        }

        public void registerSensorListener(Context context, SensorEventListener sensorListener, Handler handler) {
            SensorManager sensorManager = context.getSystemService(SensorManager.class);
            Sensor lightSensor = sensorManager.getDefaultSensor(5);
            sensorManager.registerListener(sensorListener, lightSensor, 3, handler);
        }

        public void unregisterSensorListener(Context context, SensorEventListener sensorListener) {
            SensorManager sensorManager = context.getSystemService(SensorManager.class);
            sensorManager.unregisterListener(sensorListener);
        }

        public void registerReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter) {
            context.registerReceiver(receiver, filter);
        }

        public void unregisterReceiver(Context context, BroadcastReceiver receiver) {
            context.unregisterReceiver(receiver);
        }

        public Handler getBackgroundHandler() {
            return BackgroundThread.getHandler();
        }

        public int getSecureIntForUser(ContentResolver resolver, String setting, int defaultValue, int userId) {
            return Settings.Secure.getIntForUser(resolver, setting, defaultValue, userId);
        }

        public AtomicFile getFile(String filename) {
            return new AtomicFile(new File(Environment.getDataSystemDeDirectory(), filename));
        }

        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        public long elapsedRealtimeNanos() {
            return SystemClock.elapsedRealtimeNanos();
        }

        public int getUserSerialNumber(UserManager userManager, int userId) {
            return userManager.getUserSerialNumber(userId);
        }

        public int getUserId(UserManager userManager, int userSerialNumber) {
            return userManager.getUserHandle(userSerialNumber);
        }

        public ActivityManager.StackInfo getFocusedStack() throws RemoteException {
            return ActivityManager.getService().getFocusedStackInfo();
        }

        public void scheduleIdleJob(Context context) {
            BrightnessIdleJob.scheduleJob(context);
        }

        public void cancelIdleJob(Context context) {
            BrightnessIdleJob.cancelJob(context);
        }

        public boolean isInteractive(Context context) {
            return context.getSystemService(PowerManager.class).isInteractive();
        }
    }

    private static class BrightnessChangeValues {
        final float brightness;
        final float powerBrightnessFactor;
        final boolean isUserSetBrightness;
        final boolean isDefaultBrightnessConfig;

        BrightnessChangeValues(float brightness, float powerBrightnessFactor, boolean isUserSetBrightness, boolean isDefaultBrightnessConfig) {
            this.brightness = brightness;
            this.powerBrightnessFactor = powerBrightnessFactor;
            this.isUserSetBrightness = isUserSetBrightness;
            this.isDefaultBrightnessConfig = isDefaultBrightnessConfig;
        }
    }

    private final class TrackerHandler
    extends Handler {
        public TrackerHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    BrightnessTracker.this.backgroundStart(((Float)msg.obj).floatValue());
                    break;
                }
                case 1: {
                    BrightnessChangeValues values = (BrightnessChangeValues)msg.obj;
                    boolean userInitiatedChange = msg.arg1 == 1;
                    BrightnessTracker.this.handleBrightnessChanged(values.brightness, userInitiatedChange, values.powerBrightnessFactor, values.isUserSetBrightness, values.isDefaultBrightnessConfig);
                }
            }
        }
    }

    private final class Receiver
    extends BroadcastReceiver {
        private Receiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.ACTION_SHUTDOWN".equals(action)) {
                BrightnessTracker.this.stop();
                BrightnessTracker.this.scheduleWriteBrightnessTrackerState();
            } else if ("android.intent.action.BATTERY_CHANGED".equals(action)) {
                int level = intent.getIntExtra("level", -1);
                int scale = intent.getIntExtra("scale", 0);
                if (level != -1 && scale != 0) {
                    BrightnessTracker.this.batteryLevelChanged(level, scale);
                }
            } else if ("android.intent.action.SCREEN_OFF".equals(action)) {
                BrightnessTracker.this.mAmbientBrightnessStatsTracker.stop();
                BrightnessTracker.this.mInjector.unregisterSensorListener(BrightnessTracker.this.mContext, BrightnessTracker.this.mSensorListener);
            } else if ("android.intent.action.SCREEN_ON".equals(action)) {
                BrightnessTracker.this.mAmbientBrightnessStatsTracker.start();
                BrightnessTracker.this.mInjector.registerSensorListener(BrightnessTracker.this.mContext, BrightnessTracker.this.mSensorListener, BrightnessTracker.this.mInjector.getBackgroundHandler());
            }
        }
    }

    private final class SensorListener
    implements SensorEventListener {
        private SensorListener() {
        }

        @Override
        public void onSensorChanged(SensorEvent event) {
            BrightnessTracker.this.recordSensorEvent(event);
            BrightnessTracker.this.recordAmbientBrightnessStats(event);
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }

    private static class LightData {
        public float lux;
        public long timestamp;

        private LightData() {
        }
    }
}

