/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.util.SparseArray;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecLocalDeviceTv;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiControlService;

public final class HdmiCecStandbyModeHandler {
    private final HdmiControlService mService;
    private final HdmiCecLocalDeviceTv mTv;
    private final SparseArray<CecMessageHandler> mCecMessageHandlers = new SparseArray();
    private final CecMessageHandler mDefaultHandler = new Aborter(0);
    private final CecMessageHandler mAborterIncorrectMode = new Aborter(1);
    private final CecMessageHandler mAborterRefused = new Aborter(4);
    private final CecMessageHandler mAutoOnHandler = new AutoOnHandler();
    private final CecMessageHandler mBypasser = new Bypasser();
    private final CecMessageHandler mBystander = new Bystander();
    private final UserControlProcessedHandler mUserControlProcessedHandler = new UserControlProcessedHandler();

    public HdmiCecStandbyModeHandler(HdmiControlService service, HdmiCecLocalDeviceTv tv) {
        this.mService = service;
        this.mTv = tv;
        this.addHandler(4, this.mAutoOnHandler);
        this.addHandler(13, this.mAutoOnHandler);
        this.addHandler(130, this.mBystander);
        this.addHandler(133, this.mBystander);
        this.addHandler(128, this.mBystander);
        this.addHandler(129, this.mBystander);
        this.addHandler(134, this.mBystander);
        this.addHandler(54, this.mBystander);
        this.addHandler(50, this.mBystander);
        this.addHandler(135, this.mBystander);
        this.addHandler(69, this.mBystander);
        this.addHandler(144, this.mBystander);
        this.addHandler(0, this.mBystander);
        this.addHandler(157, this.mBystander);
        this.addHandler(126, this.mBystander);
        this.addHandler(122, this.mBystander);
        this.addHandler(10, this.mBystander);
        this.addHandler(15, this.mAborterIncorrectMode);
        this.addHandler(192, this.mAborterIncorrectMode);
        this.addHandler(197, this.mAborterIncorrectMode);
        this.addHandler(131, this.mBypasser);
        this.addHandler(145, this.mBypasser);
        this.addHandler(132, this.mBypasser);
        this.addHandler(140, this.mBypasser);
        this.addHandler(70, this.mBypasser);
        this.addHandler(71, this.mBypasser);
        this.addHandler(68, this.mUserControlProcessedHandler);
        this.addHandler(143, this.mBypasser);
        this.addHandler(255, this.mBypasser);
        this.addHandler(159, this.mBypasser);
        this.addHandler(160, this.mAborterIncorrectMode);
        this.addHandler(114, this.mAborterIncorrectMode);
    }

    private void addHandler(int opcode, CecMessageHandler handler) {
        this.mCecMessageHandlers.put(opcode, handler);
    }

    boolean handleCommand(HdmiCecMessage message) {
        CecMessageHandler handler = this.mCecMessageHandlers.get(message.getOpcode());
        if (handler != null) {
            return handler.handle(message);
        }
        return this.mDefaultHandler.handle(message);
    }

    private final class UserControlProcessedHandler
    implements CecMessageHandler {
        private UserControlProcessedHandler() {
        }

        @Override
        public boolean handle(HdmiCecMessage message) {
            if (HdmiCecLocalDevice.isPowerOnOrToggleCommand(message)) {
                return false;
            }
            if (HdmiCecLocalDevice.isPowerOffOrToggleCommand(message)) {
                return true;
            }
            return HdmiCecStandbyModeHandler.this.mAborterIncorrectMode.handle(message);
        }
    }

    private final class AutoOnHandler
    implements CecMessageHandler {
        private AutoOnHandler() {
        }

        @Override
        public boolean handle(HdmiCecMessage message) {
            if (!HdmiCecStandbyModeHandler.this.mTv.getAutoWakeup()) {
                HdmiCecStandbyModeHandler.this.mAborterRefused.handle(message);
                return true;
            }
            return false;
        }
    }

    private final class Aborter
    implements CecMessageHandler {
        private final int mReason;

        public Aborter(int reason) {
            this.mReason = reason;
        }

        @Override
        public boolean handle(HdmiCecMessage message) {
            HdmiCecStandbyModeHandler.this.mService.maySendFeatureAbortCommand(message, this.mReason);
            return true;
        }
    }

    private static final class Bypasser
    implements CecMessageHandler {
        private Bypasser() {
        }

        @Override
        public boolean handle(HdmiCecMessage message) {
            return false;
        }
    }

    private static final class Bystander
    implements CecMessageHandler {
        private Bystander() {
        }

        @Override
        public boolean handle(HdmiCecMessage message) {
            return true;
        }
    }

    private static interface CecMessageHandler {
        public boolean handle(HdmiCecMessage var1);
    }
}

