/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.media.AudioManager;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiLogger;
import com.android.server.hdmi.HdmiUtils;

final class VolumeControlAction
extends HdmiCecFeatureAction {
    private static final String TAG = "VolumeControlAction";
    private static final int STATE_WAIT_FOR_NEXT_VOLUME_PRESS = 1;
    private static final int MAX_VOLUME = 100;
    private static final int UNKNOWN_AVR_VOLUME = -1;
    private final int mAvrAddress;
    private boolean mIsVolumeUp;
    private long mLastKeyUpdateTime;
    private int mLastAvrVolume;
    private boolean mLastAvrMute;
    private boolean mSentKeyPressed;

    public static int scaleToCecVolume(int volume, int scale) {
        return volume * 100 / scale;
    }

    public static int scaleToCustomVolume(int cecVolume, int scale) {
        return cecVolume * scale / 100;
    }

    VolumeControlAction(HdmiCecLocalDevice source, int avrAddress, boolean isVolumeUp) {
        super(source);
        this.mAvrAddress = avrAddress;
        this.mIsVolumeUp = isVolumeUp;
        this.mLastAvrVolume = -1;
        this.mLastAvrMute = false;
        this.mSentKeyPressed = false;
        this.updateLastKeyUpdateTime();
    }

    private void updateLastKeyUpdateTime() {
        this.mLastKeyUpdateTime = System.currentTimeMillis();
    }

    @Override
    boolean start() {
        this.mState = 1;
        this.sendVolumeKeyPressed();
        this.resetTimer();
        return true;
    }

    private void sendVolumeKeyPressed() {
        this.sendCommand(HdmiCecMessageBuilder.buildUserControlPressed(this.getSourceAddress(), this.mAvrAddress, this.mIsVolumeUp ? 65 : 66));
        this.mSentKeyPressed = true;
    }

    private void resetTimer() {
        this.mActionTimer.clearTimerMessage();
        this.addTimer(1, 300);
    }

    void handleVolumeChange(boolean isVolumeUp) {
        if (this.mIsVolumeUp != isVolumeUp) {
            HdmiLogger.debug("Volume Key Status Changed[old:%b new:%b]", this.mIsVolumeUp, isVolumeUp);
            this.sendVolumeKeyReleased();
            this.mIsVolumeUp = isVolumeUp;
            this.sendVolumeKeyPressed();
            this.resetTimer();
        }
        this.updateLastKeyUpdateTime();
    }

    private void sendVolumeKeyReleased() {
        this.sendCommand(HdmiCecMessageBuilder.buildUserControlReleased(this.getSourceAddress(), this.mAvrAddress));
        this.mSentKeyPressed = false;
    }

    @Override
    boolean processCommand(HdmiCecMessage cmd) {
        if (this.mState != 1 || cmd.getSource() != this.mAvrAddress) {
            return false;
        }
        switch (cmd.getOpcode()) {
            case 122: {
                return this.handleReportAudioStatus(cmd);
            }
            case 0: {
                return this.handleFeatureAbort(cmd);
            }
        }
        return false;
    }

    private boolean handleReportAudioStatus(HdmiCecMessage cmd) {
        int volume;
        byte[] params = cmd.getParams();
        boolean mute = HdmiUtils.isAudioStatusMute(cmd);
        this.mLastAvrVolume = volume = HdmiUtils.getAudioStatusVolume(cmd);
        this.mLastAvrMute = mute;
        if (this.shouldUpdateAudioVolume(mute)) {
            HdmiLogger.debug("Force volume change[mute:%b, volume=%d]", mute, volume);
            this.tv().setAudioStatus(mute, volume);
            this.mLastAvrVolume = -1;
            this.mLastAvrMute = false;
        }
        return true;
    }

    private boolean shouldUpdateAudioVolume(boolean mute) {
        if (mute) {
            return true;
        }
        AudioManager audioManager = this.tv().getService().getAudioManager();
        int currentVolume = audioManager.getStreamVolume(3);
        if (this.mIsVolumeUp) {
            int maxVolume = audioManager.getStreamMaxVolume(3);
            return currentVolume == maxVolume;
        }
        return currentVolume == 0;
    }

    private boolean handleFeatureAbort(HdmiCecMessage cmd) {
        int originalOpcode = cmd.getParams()[0] & 0xFF;
        if (originalOpcode == 68) {
            this.finish();
            return true;
        }
        return false;
    }

    @Override
    protected void clear() {
        super.clear();
        if (this.mSentKeyPressed) {
            this.sendVolumeKeyReleased();
        }
        if (this.mLastAvrVolume != -1) {
            this.tv().setAudioStatus(this.mLastAvrMute, this.mLastAvrVolume);
            this.mLastAvrVolume = -1;
            this.mLastAvrMute = false;
        }
    }

    @Override
    void handleTimerEvent(int state) {
        if (state != 1) {
            return;
        }
        if (System.currentTimeMillis() - this.mLastKeyUpdateTime >= 300L) {
            this.finish();
        } else {
            this.sendVolumeKeyPressed();
            this.resetTimer();
        }
    }
}

