/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job;

import android.app.ActivityManager;
import android.app.IActivityManager;
import android.app.job.JobInfo;
import android.content.ComponentName;
import android.content.Context;
import android.net.NetworkRequest;
import android.os.Environment;
import android.os.Handler;
import android.os.PersistableBundle;
import android.os.SystemClock;
import android.os.UserHandle;
import android.text.format.DateUtils;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.BitUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.server.IoThread;
import com.android.server.LocalServices;
import com.android.server.content.SyncJobService;
import com.android.server.job.JobSchedulerInternal;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.controllers.JobStatus;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public final class JobStore {
    private static final String TAG = "JobStore";
    private static final boolean DEBUG = false;
    private static final int MAX_OPS_BEFORE_WRITE = 1;
    final Object mLock;
    final JobSet mJobSet;
    final Context mContext;
    private final long mXmlTimestamp;
    private boolean mRtcGood;
    private int mDirtyOperations;
    private static final Object sSingletonLock = new Object();
    private final AtomicFile mJobsFile;
    private final Handler mIoHandler = IoThread.getHandler();
    private static JobStore sSingleton;
    private JobSchedulerInternal.JobStorePersistStats mPersistInfo = new JobSchedulerInternal.JobStorePersistStats();
    private static final int JOBS_FILE_VERSION = 0;
    private static final String XML_TAG_PARAMS_CONSTRAINTS = "constraints";
    private static final String XML_TAG_PERIODIC = "periodic";
    private static final String XML_TAG_ONEOFF = "one-off";
    private static final String XML_TAG_EXTRAS = "extras";
    private final Runnable mWriteRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
            final ArrayList<JobStatus> storeCopy = new ArrayList<JobStatus>();
            Object object = JobStore.this.mLock;
            synchronized (object) {
                JobStore.this.mJobSet.forEachJob(new JobStatusFunctor(){

                    @Override
                    public void process(JobStatus job) {
                        if (job.isPersisted()) {
                            storeCopy.add(new JobStatus(job));
                        }
                    }
                });
            }
            this.writeJobsMapImpl(storeCopy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeJobsMapImpl(List<JobStatus> jobList) {
            int numJobs = 0;
            int numSystemJobs = 0;
            int numSyncJobs = 0;
            try {
                long startTime = SystemClock.uptimeMillis();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(baos, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                out.startTag(null, "job-info");
                out.attribute(null, "version", Integer.toString(0));
                for (int i = 0; i < jobList.size(); ++i) {
                    JobStatus jobStatus = jobList.get(i);
                    out.startTag(null, "job");
                    this.addAttributesToJobTag(out, jobStatus);
                    this.writeConstraintsToXml(out, jobStatus);
                    this.writeExecutionCriteriaToXml(out, jobStatus);
                    this.writeBundleToXml(jobStatus.getJob().getExtras(), out);
                    out.endTag(null, "job");
                    ++numJobs;
                    if (jobStatus.getUid() != 1000) continue;
                    ++numSystemJobs;
                    if (!JobStore.isSyncJob(jobStatus)) continue;
                    ++numSyncJobs;
                }
                out.endTag(null, "job-info");
                out.endDocument();
                FileOutputStream fos = JobStore.this.mJobsFile.startWrite(startTime);
                fos.write(baos.toByteArray());
                JobStore.this.mJobsFile.finishWrite(fos);
                JobStore.this.mDirtyOperations = 0;
            }
            catch (IOException iOException) {
            }
            catch (XmlPullParserException xmlPullParserException) {
            }
            finally {
                ((JobStore)JobStore.this).mPersistInfo.countAllJobsSaved = numJobs;
                ((JobStore)JobStore.this).mPersistInfo.countSystemServerJobsSaved = numSystemJobs;
                ((JobStore)JobStore.this).mPersistInfo.countSystemSyncManagerJobsSaved = numSyncJobs;
            }
        }

        private void addAttributesToJobTag(XmlSerializer out, JobStatus jobStatus) throws IOException {
            out.attribute(null, "jobid", Integer.toString(jobStatus.getJobId()));
            out.attribute(null, "package", jobStatus.getServiceComponent().getPackageName());
            out.attribute(null, "class", jobStatus.getServiceComponent().getClassName());
            if (jobStatus.getSourcePackageName() != null) {
                out.attribute(null, "sourcePackageName", jobStatus.getSourcePackageName());
            }
            if (jobStatus.getSourceTag() != null) {
                out.attribute(null, "sourceTag", jobStatus.getSourceTag());
            }
            out.attribute(null, "sourceUserId", String.valueOf(jobStatus.getSourceUserId()));
            out.attribute(null, "uid", Integer.toString(jobStatus.getUid()));
            out.attribute(null, "priority", String.valueOf(jobStatus.getPriority()));
            out.attribute(null, "flags", String.valueOf(jobStatus.getFlags()));
            if (jobStatus.getInternalFlags() != 0) {
                out.attribute(null, "internalFlags", String.valueOf(jobStatus.getInternalFlags()));
            }
            out.attribute(null, "lastSuccessfulRunTime", String.valueOf(jobStatus.getLastSuccessfulRunTime()));
            out.attribute(null, "lastFailedRunTime", String.valueOf(jobStatus.getLastFailedRunTime()));
        }

        private void writeBundleToXml(PersistableBundle extras, XmlSerializer out) throws IOException, XmlPullParserException {
            out.startTag(null, JobStore.XML_TAG_EXTRAS);
            PersistableBundle extrasCopy = this.deepCopyBundle(extras, 10);
            extrasCopy.saveToXml(out);
            out.endTag(null, JobStore.XML_TAG_EXTRAS);
        }

        private PersistableBundle deepCopyBundle(PersistableBundle bundle, int maxDepth) {
            if (maxDepth <= 0) {
                return null;
            }
            PersistableBundle copy = (PersistableBundle)bundle.clone();
            Set<String> keySet = bundle.keySet();
            for (String key : keySet) {
                Object o = copy.get(key);
                if (!(o instanceof PersistableBundle)) continue;
                PersistableBundle bCopy = this.deepCopyBundle((PersistableBundle)o, maxDepth - 1);
                copy.putPersistableBundle(key, bCopy);
            }
            return copy;
        }

        private void writeConstraintsToXml(XmlSerializer out, JobStatus jobStatus) throws IOException {
            out.startTag(null, JobStore.XML_TAG_PARAMS_CONSTRAINTS);
            if (jobStatus.hasConnectivityConstraint()) {
                NetworkRequest network = jobStatus.getJob().getRequiredNetwork();
                out.attribute(null, "net-capabilities", Long.toString(BitUtils.packBits(network.networkCapabilities.getCapabilities())));
                out.attribute(null, "net-transport-types", Long.toString(BitUtils.packBits(network.networkCapabilities.getTransportTypes())));
            }
            if (jobStatus.hasIdleConstraint()) {
                out.attribute(null, "idle", Boolean.toString(true));
            }
            if (jobStatus.hasChargingConstraint()) {
                out.attribute(null, "charging", Boolean.toString(true));
            }
            if (jobStatus.hasBatteryNotLowConstraint()) {
                out.attribute(null, "battery-not-low", Boolean.toString(true));
            }
            out.endTag(null, JobStore.XML_TAG_PARAMS_CONSTRAINTS);
        }

        private void writeExecutionCriteriaToXml(XmlSerializer out, JobStatus jobStatus) throws IOException {
            JobInfo job = jobStatus.getJob();
            if (jobStatus.getJob().isPeriodic()) {
                out.startTag(null, JobStore.XML_TAG_PERIODIC);
                out.attribute(null, "period", Long.toString(job.getIntervalMillis()));
                out.attribute(null, "flex", Long.toString(job.getFlexMillis()));
            } else {
                out.startTag(null, JobStore.XML_TAG_ONEOFF);
            }
            Pair<Long, Long> utcJobTimes = jobStatus.getPersistedUtcTimes();
            long nowRTC = JobSchedulerService.sSystemClock.millis();
            long nowElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
            if (jobStatus.hasDeadlineConstraint()) {
                long deadlineWallclock = utcJobTimes == null ? nowRTC + (jobStatus.getLatestRunTimeElapsed() - nowElapsed) : (Long)utcJobTimes.second;
                out.attribute(null, "deadline", Long.toString(deadlineWallclock));
            }
            if (jobStatus.hasTimingDelayConstraint()) {
                long delayWallclock = utcJobTimes == null ? nowRTC + (jobStatus.getEarliestRunTime() - nowElapsed) : (Long)utcJobTimes.first;
                out.attribute(null, "delay", Long.toString(delayWallclock));
            }
            if (jobStatus.getJob().getInitialBackoffMillis() != 30000L || jobStatus.getJob().getBackoffPolicy() != 1) {
                out.attribute(null, "backoff-policy", Integer.toString(job.getBackoffPolicy()));
                out.attribute(null, "initial-backoff", Long.toString(job.getInitialBackoffMillis()));
            }
            if (job.isPeriodic()) {
                out.endTag(null, JobStore.XML_TAG_PERIODIC);
            } else {
                out.endTag(null, JobStore.XML_TAG_ONEOFF);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JobStore initAndGet(JobSchedulerService jobManagerService) {
        Object object = sSingletonLock;
        synchronized (object) {
            if (sSingleton == null) {
                sSingleton = new JobStore(jobManagerService.getContext(), jobManagerService.getLock(), Environment.getDataDirectory());
            }
            return sSingleton;
        }
    }

    @VisibleForTesting
    public static JobStore initAndGetForTesting(Context context, File dataDir) {
        JobStore jobStoreUnderTest = new JobStore(context, new Object(), dataDir);
        jobStoreUnderTest.clear();
        return jobStoreUnderTest;
    }

    private JobStore(Context context, Object lock, File dataDir) {
        this.mLock = lock;
        this.mContext = context;
        this.mDirtyOperations = 0;
        File systemDir = new File(dataDir, "system");
        File jobDir = new File(systemDir, "job");
        jobDir.mkdirs();
        this.mJobsFile = new AtomicFile(new File(jobDir, "jobs.xml"), "jobs");
        this.mJobSet = new JobSet();
        this.mXmlTimestamp = this.mJobsFile.getLastModifiedTime();
        this.mRtcGood = JobSchedulerService.sSystemClock.millis() > this.mXmlTimestamp;
        this.readJobMapFromDisk(this.mJobSet, this.mRtcGood);
    }

    public boolean jobTimesInflatedValid() {
        return this.mRtcGood;
    }

    public boolean clockNowValidToInflate(long now) {
        return now >= this.mXmlTimestamp;
    }

    public void getRtcCorrectedJobsLocked(ArrayList<JobStatus> toAdd, ArrayList<JobStatus> toRemove) {
        long elapsedNow = JobSchedulerService.sElapsedRealtimeClock.millis();
        this.forEachJob(job -> {
            Pair<Long, Long> utcTimes = job.getPersistedUtcTimes();
            if (utcTimes != null) {
                Pair<Long, Long> elapsedRuntimes = JobStore.convertRtcBoundsToElapsed(utcTimes, elapsedNow);
                toAdd.add(new JobStatus(job, job.getBaseHeartbeat(), (Long)elapsedRuntimes.first, (Long)elapsedRuntimes.second, 0, job.getLastSuccessfulRunTime(), job.getLastFailedRunTime()));
                toRemove.add(job);
            }
        });
    }

    public boolean add(JobStatus jobStatus) {
        boolean replaced = this.mJobSet.remove(jobStatus);
        this.mJobSet.add(jobStatus);
        if (jobStatus.isPersisted()) {
            this.maybeWriteStatusToDiskAsync();
        }
        return replaced;
    }

    boolean containsJob(JobStatus jobStatus) {
        return this.mJobSet.contains(jobStatus);
    }

    public int size() {
        return this.mJobSet.size();
    }

    public JobSchedulerInternal.JobStorePersistStats getPersistStats() {
        return this.mPersistInfo;
    }

    public int countJobsForUid(int uid) {
        return this.mJobSet.countJobsForUid(uid);
    }

    public boolean remove(JobStatus jobStatus, boolean writeBack) {
        boolean removed = this.mJobSet.remove(jobStatus);
        if (!removed) {
            return false;
        }
        if (writeBack && jobStatus.isPersisted()) {
            this.maybeWriteStatusToDiskAsync();
        }
        return removed;
    }

    public void removeJobsOfNonUsers(int[] whitelist) {
        this.mJobSet.removeJobsOfNonUsers(whitelist);
    }

    @VisibleForTesting
    public void clear() {
        this.mJobSet.clear();
        this.maybeWriteStatusToDiskAsync();
    }

    public List<JobStatus> getJobsByUser(int userHandle) {
        return this.mJobSet.getJobsByUser(userHandle);
    }

    public List<JobStatus> getJobsByUid(int uid) {
        return this.mJobSet.getJobsByUid(uid);
    }

    public JobStatus getJobByUidAndJobId(int uid, int jobId) {
        return this.mJobSet.get(uid, jobId);
    }

    public void forEachJob(JobStatusFunctor functor) {
        this.mJobSet.forEachJob(functor);
    }

    public void forEachJob(int uid, JobStatusFunctor functor) {
        this.mJobSet.forEachJob(uid, functor);
    }

    public void forEachJobForSourceUid(int sourceUid, JobStatusFunctor functor) {
        this.mJobSet.forEachJobForSourceUid(sourceUid, functor);
    }

    private void maybeWriteStatusToDiskAsync() {
        ++this.mDirtyOperations;
        if (this.mDirtyOperations >= 1) {
            this.mIoHandler.removeCallbacks(this.mWriteRunnable);
            this.mIoHandler.post(this.mWriteRunnable);
        }
    }

    @VisibleForTesting
    public void readJobMapFromDisk(JobSet jobSet, boolean rtcGood) {
        new ReadJobMapFromDiskRunnable(jobSet, rtcGood).run();
    }

    private static Pair<Long, Long> convertRtcBoundsToElapsed(Pair<Long, Long> rtcTimes, long nowElapsed) {
        long nowWallclock = JobSchedulerService.sSystemClock.millis();
        long earliest = (Long)rtcTimes.first > 0L ? nowElapsed + Math.max((Long)rtcTimes.first - nowWallclock, 0L) : 0L;
        long latest = (Long)rtcTimes.second < Long.MAX_VALUE ? nowElapsed + Math.max((Long)rtcTimes.second - nowWallclock, 0L) : Long.MAX_VALUE;
        return Pair.create(earliest, latest);
    }

    private static boolean isSyncJob(JobStatus status) {
        return SyncJobService.class.getName().equals(status.getServiceComponent().getClassName());
    }

    static /* synthetic */ Pair access$400(Pair x0, long x1) {
        return JobStore.convertRtcBoundsToElapsed(x0, x1);
    }

    static final class JobSet {
        @VisibleForTesting
        final SparseArray<ArraySet<JobStatus>> mJobs = new SparseArray();
        @VisibleForTesting
        final SparseArray<ArraySet<JobStatus>> mJobsPerSourceUid = new SparseArray();

        public List<JobStatus> getJobsByUid(int uid) {
            ArrayList<JobStatus> matchingJobs = new ArrayList<JobStatus>();
            ArraySet<JobStatus> jobs = this.mJobs.get(uid);
            if (jobs != null) {
                matchingJobs.addAll(jobs);
            }
            return matchingJobs;
        }

        public List<JobStatus> getJobsByUser(int userId) {
            ArrayList<JobStatus> result = new ArrayList<JobStatus>();
            for (int i = this.mJobsPerSourceUid.size() - 1; i >= 0; --i) {
                ArraySet<JobStatus> jobs;
                if (UserHandle.getUserId(this.mJobsPerSourceUid.keyAt(i)) != userId || (jobs = this.mJobsPerSourceUid.valueAt(i)) == null) continue;
                result.addAll(jobs);
            }
            return result;
        }

        public boolean add(JobStatus job) {
            boolean addedInSource;
            boolean added;
            ArraySet<JobStatus> jobsForSourceUid;
            int uid = job.getUid();
            int sourceUid = job.getSourceUid();
            ArraySet<JobStatus> jobs = this.mJobs.get(uid);
            if (jobs == null) {
                jobs = new ArraySet();
                this.mJobs.put(uid, jobs);
            }
            if ((jobsForSourceUid = this.mJobsPerSourceUid.get(sourceUid)) == null) {
                jobsForSourceUid = new ArraySet();
                this.mJobsPerSourceUid.put(sourceUid, jobsForSourceUid);
            }
            if ((added = jobs.add(job)) != (addedInSource = jobsForSourceUid.add(job))) {
                Slog.wtf(JobStore.TAG, "mJobs and mJobsPerSourceUid mismatch; caller= " + added + " source= " + addedInSource);
            }
            return added || addedInSource;
        }

        public boolean remove(JobStatus job) {
            boolean sourceRemove;
            int uid = job.getUid();
            ArraySet<JobStatus> jobs = this.mJobs.get(uid);
            int sourceUid = job.getSourceUid();
            ArraySet<JobStatus> jobsForSourceUid = this.mJobsPerSourceUid.get(sourceUid);
            boolean didRemove = jobs != null && jobs.remove(job);
            boolean bl = sourceRemove = jobsForSourceUid != null && jobsForSourceUid.remove(job);
            if (didRemove != sourceRemove) {
                Slog.wtf(JobStore.TAG, "Job presence mismatch; caller=" + didRemove + " source=" + sourceRemove);
            }
            if (didRemove || sourceRemove) {
                if (jobs != null && jobs.size() == 0) {
                    this.mJobs.remove(uid);
                }
                if (jobsForSourceUid != null && jobsForSourceUid.size() == 0) {
                    this.mJobsPerSourceUid.remove(sourceUid);
                }
                return true;
            }
            return false;
        }

        public void removeJobsOfNonUsers(int[] whitelist) {
            Predicate<JobStatus> noSourceUser = job -> !ArrayUtils.contains(whitelist, job.getSourceUserId());
            Predicate<JobStatus> noCallingUser = job -> !ArrayUtils.contains(whitelist, job.getUserId());
            this.removeAll(noSourceUser.or(noCallingUser));
        }

        private void removeAll(Predicate<JobStatus> predicate) {
            int jobIndex;
            ArraySet<JobStatus> jobs;
            int jobSetIndex;
            for (jobSetIndex = this.mJobs.size() - 1; jobSetIndex >= 0; --jobSetIndex) {
                jobs = this.mJobs.valueAt(jobSetIndex);
                for (jobIndex = jobs.size() - 1; jobIndex >= 0; --jobIndex) {
                    if (!predicate.test(jobs.valueAt(jobIndex))) continue;
                    jobs.removeAt(jobIndex);
                }
                if (jobs.size() != 0) continue;
                this.mJobs.removeAt(jobSetIndex);
            }
            for (jobSetIndex = this.mJobsPerSourceUid.size() - 1; jobSetIndex >= 0; --jobSetIndex) {
                jobs = this.mJobsPerSourceUid.valueAt(jobSetIndex);
                for (jobIndex = jobs.size() - 1; jobIndex >= 0; --jobIndex) {
                    if (!predicate.test(jobs.valueAt(jobIndex))) continue;
                    jobs.removeAt(jobIndex);
                }
                if (jobs.size() != 0) continue;
                this.mJobsPerSourceUid.removeAt(jobSetIndex);
            }
        }

        public boolean contains(JobStatus job) {
            int uid = job.getUid();
            ArraySet<JobStatus> jobs = this.mJobs.get(uid);
            return jobs != null && jobs.contains(job);
        }

        public JobStatus get(int uid, int jobId) {
            ArraySet<JobStatus> jobs = this.mJobs.get(uid);
            if (jobs != null) {
                for (int i = jobs.size() - 1; i >= 0; --i) {
                    JobStatus job = jobs.valueAt(i);
                    if (job.getJobId() != jobId) continue;
                    return job;
                }
            }
            return null;
        }

        public List<JobStatus> getAllJobs() {
            ArrayList<JobStatus> allJobs = new ArrayList<JobStatus>(this.size());
            for (int i = this.mJobs.size() - 1; i >= 0; --i) {
                ArraySet<JobStatus> jobs = this.mJobs.valueAt(i);
                if (jobs == null) continue;
                for (int j = jobs.size() - 1; j >= 0; --j) {
                    allJobs.add(jobs.valueAt(j));
                }
            }
            return allJobs;
        }

        public void clear() {
            this.mJobs.clear();
            this.mJobsPerSourceUid.clear();
        }

        public int size() {
            int total = 0;
            for (int i = this.mJobs.size() - 1; i >= 0; --i) {
                total += this.mJobs.valueAt(i).size();
            }
            return total;
        }

        public int countJobsForUid(int uid) {
            int total = 0;
            ArraySet<JobStatus> jobs = this.mJobs.get(uid);
            if (jobs != null) {
                for (int i = jobs.size() - 1; i >= 0; --i) {
                    JobStatus job = jobs.valueAt(i);
                    if (job.getUid() != job.getSourceUid()) continue;
                    ++total;
                }
            }
            return total;
        }

        public void forEachJob(JobStatusFunctor functor) {
            for (int uidIndex = this.mJobs.size() - 1; uidIndex >= 0; --uidIndex) {
                ArraySet<JobStatus> jobs = this.mJobs.valueAt(uidIndex);
                if (jobs == null) continue;
                for (int i = jobs.size() - 1; i >= 0; --i) {
                    functor.process(jobs.valueAt(i));
                }
            }
        }

        public void forEachJob(int callingUid, JobStatusFunctor functor) {
            ArraySet<JobStatus> jobs = this.mJobs.get(callingUid);
            if (jobs != null) {
                for (int i = jobs.size() - 1; i >= 0; --i) {
                    functor.process(jobs.valueAt(i));
                }
            }
        }

        public void forEachJobForSourceUid(int sourceUid, JobStatusFunctor functor) {
            ArraySet<JobStatus> jobs = this.mJobsPerSourceUid.get(sourceUid);
            if (jobs != null) {
                for (int i = jobs.size() - 1; i >= 0; --i) {
                    functor.process(jobs.valueAt(i));
                }
            }
        }
    }

    private final class ReadJobMapFromDiskRunnable
    implements Runnable {
        private final JobSet jobSet;
        private final boolean rtcGood;

        ReadJobMapFromDiskRunnable(JobSet jobSet, boolean rtcIsGood) {
            this.jobSet = jobSet;
            this.rtcGood = rtcIsGood;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int numJobs = 0;
            int numSystemJobs = 0;
            int numSyncJobs = 0;
            try {
                FileInputStream fis = JobStore.this.mJobsFile.openRead();
                Object object = JobStore.this.mLock;
                synchronized (object) {
                    List<JobStatus> jobs = this.readJobMapImpl(fis, this.rtcGood);
                    if (jobs != null) {
                        long now = JobSchedulerService.sElapsedRealtimeClock.millis();
                        IActivityManager am = ActivityManager.getService();
                        for (int i = 0; i < jobs.size(); ++i) {
                            JobStatus js = jobs.get(i);
                            js.prepareLocked(am);
                            js.enqueueTime = now;
                            this.jobSet.add(js);
                            ++numJobs;
                            if (js.getUid() != 1000) continue;
                            ++numSystemJobs;
                            if (!JobStore.isSyncJob(js)) continue;
                            ++numSyncJobs;
                        }
                    }
                }
                fis.close();
            }
            catch (FileNotFoundException jobs) {
            }
            catch (IOException | XmlPullParserException e) {
                Slog.wtf(JobStore.TAG, "Error jobstore xml.", e);
            }
            finally {
                if (((JobStore)JobStore.this).mPersistInfo.countAllJobsLoaded < 0) {
                    ((JobStore)JobStore.this).mPersistInfo.countAllJobsLoaded = numJobs;
                    ((JobStore)JobStore.this).mPersistInfo.countSystemServerJobsLoaded = numSystemJobs;
                    ((JobStore)JobStore.this).mPersistInfo.countSystemSyncManagerJobsLoaded = numSyncJobs;
                }
            }
            Slog.i(JobStore.TAG, "Read " + numJobs + " jobs");
        }

        private List<JobStatus> readJobMapImpl(FileInputStream fis, boolean rtcIsGood) throws XmlPullParserException, IOException {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, StandardCharsets.UTF_8.name());
            int eventType = parser.getEventType();
            while (eventType != 2 && eventType != 1) {
                eventType = parser.next();
                Slog.d(JobStore.TAG, "Start tag: " + parser.getName());
            }
            if (eventType == 1) {
                return null;
            }
            String tagName = parser.getName();
            if ("job-info".equals(tagName)) {
                ArrayList<JobStatus> jobs = new ArrayList<JobStatus>();
                try {
                    int version = Integer.parseInt(parser.getAttributeValue(null, "version"));
                    if (version != 0) {
                        Slog.d(JobStore.TAG, "Invalid version number, aborting jobs file read.");
                        return null;
                    }
                }
                catch (NumberFormatException e) {
                    Slog.e(JobStore.TAG, "Invalid version number, aborting jobs file read.");
                    return null;
                }
                eventType = parser.next();
                do {
                    if (eventType != 2 || !"job".equals(tagName = parser.getName())) continue;
                    JobStatus persistedJob = this.restoreJobFromXml(rtcIsGood, parser);
                    if (persistedJob != null) {
                        jobs.add(persistedJob);
                        continue;
                    }
                    Slog.d(JobStore.TAG, "Error reading job from file.");
                } while ((eventType = parser.next()) != 1);
                return jobs;
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        private JobStatus restoreJobFromXml(boolean rtcIsGood, XmlPullParser parser) throws XmlPullParserException, IOException {
            internalFlags = 0;
            try {
                jobBuilder = this.buildBuilderFromXml(parser);
                jobBuilder.setPersisted(true);
                uid = Integer.parseInt(parser.getAttributeValue(null, "uid"));
                val = parser.getAttributeValue(null, "priority");
                if (val != null) {
                    jobBuilder.setPriority(Integer.parseInt(val));
                }
                if ((val = parser.getAttributeValue(null, "flags")) != null) {
                    jobBuilder.setFlags(Integer.parseInt(val));
                }
                if ((val = parser.getAttributeValue(null, "internalFlags")) != null) {
                    internalFlags = Integer.parseInt(val);
                }
                sourceUserId = (val = parser.getAttributeValue(null, "sourceUserId")) == null ? -1 : Integer.parseInt(val);
                val = parser.getAttributeValue(null, "lastSuccessfulRunTime");
                lastSuccessfulRunTime = val == null ? 0L : Long.parseLong(val);
                val = parser.getAttributeValue(null, "lastFailedRunTime");
                lastFailedRunTime = val == null ? 0L : Long.parseLong(val);
            }
            catch (NumberFormatException e) {
                Slog.e("JobStore", "Error parsing job's required fields, skipping");
                return null;
            }
            sourcePackageName = parser.getAttributeValue(null, "sourcePackageName");
            sourceTag = parser.getAttributeValue(null, "sourceTag");
            while ((eventType = parser.next()) == 4) {
            }
            if (eventType != 2 || !"constraints".equals(parser.getName())) {
                return null;
            }
            try {
                this.buildConstraintsFromXml(jobBuilder, parser);
            }
            catch (NumberFormatException e) {
                Slog.d("JobStore", "Error reading constraints, skipping.");
                return null;
            }
            parser.next();
            while ((eventType = parser.next()) == 4) {
            }
            if (eventType != 2) {
                return null;
            }
            try {
                rtcRuntimes = this.buildRtcExecutionTimesFromXml(parser);
            }
            catch (NumberFormatException e) {
                return null;
            }
            elapsedNow = JobSchedulerService.sElapsedRealtimeClock.millis();
            elapsedRuntimes = JobStore.access$400(rtcRuntimes, elapsedNow);
            if ("periodic".equals(parser.getName())) {
                try {
                    val = parser.getAttributeValue(null, "period");
                    periodMillis = Long.parseLong(val);
                    val = parser.getAttributeValue(null, "flex");
                    flexMillis = val != null ? Long.valueOf(val) : periodMillis;
                    jobBuilder.setPeriodic(periodMillis, flexMillis);
                    if ((Long)elapsedRuntimes.second <= elapsedNow + periodMillis + flexMillis) ** GOTO lbl85
                    clampedLateRuntimeElapsed = elapsedNow + flexMillis + periodMillis;
                    clampedEarlyRuntimeElapsed = clampedLateRuntimeElapsed - flexMillis;
                    Slog.w("JobStore", String.format("Periodic job for uid='%d' persisted run-time is too big [%s, %s]. Clamping to [%s,%s]", new Object[]{uid, DateUtils.formatElapsedTime((Long)elapsedRuntimes.first / 1000L), DateUtils.formatElapsedTime((Long)elapsedRuntimes.second / 1000L), DateUtils.formatElapsedTime(clampedEarlyRuntimeElapsed / 1000L), DateUtils.formatElapsedTime(clampedLateRuntimeElapsed / 1000L)}));
                    elapsedRuntimes = Pair.create(clampedEarlyRuntimeElapsed, clampedLateRuntimeElapsed);
                }
                catch (NumberFormatException e) {
                    Slog.d("JobStore", "Error reading periodic execution criteria, skipping.");
                    return null;
                }
            } else if ("one-off".equals(parser.getName())) {
                try {
                    if ((Long)elapsedRuntimes.first != 0L) {
                        jobBuilder.setMinimumLatency((Long)elapsedRuntimes.first - elapsedNow);
                    }
                    if ((Long)elapsedRuntimes.second == 0x7FFFFFFFFFFFFFFFL) ** GOTO lbl85
                    jobBuilder.setOverrideDeadline((Long)elapsedRuntimes.second - elapsedNow);
                }
                catch (NumberFormatException e) {
                    Slog.d("JobStore", "Error reading job execution criteria, skipping.");
                    return null;
                }
            } else {
                return null;
            }
lbl85:
            // 4 sources

            this.maybeBuildBackoffPolicyFromXml(jobBuilder, parser);
            parser.nextTag();
            while ((eventType = parser.next()) == 4) {
            }
            if (eventType != 2 || !"extras".equals(parser.getName())) {
                return null;
            }
            extras = PersistableBundle.restoreFromXml(parser);
            jobBuilder.setExtras(extras);
            parser.nextTag();
            if ("android".equals(sourcePackageName) && extras != null && extras.getBoolean("SyncManagerJob", false)) {
                sourcePackageName = extras.getString("owningPackage", sourcePackageName);
            }
            service = LocalServices.getService(JobSchedulerInternal.class);
            appBucket = JobSchedulerService.standbyBucketForPackage(sourcePackageName, sourceUserId, elapsedNow);
            currentHeartbeat = service != null ? service.currentHeartbeat() : 0L;
            js = new JobStatus(jobBuilder.build(), uid, sourcePackageName, sourceUserId, appBucket, currentHeartbeat, sourceTag, (Long)elapsedRuntimes.first, (Long)elapsedRuntimes.second, lastSuccessfulRunTime, lastFailedRunTime, rtcIsGood != false ? null : rtcRuntimes, internalFlags);
            return js;
        }

        private JobInfo.Builder buildBuilderFromXml(XmlPullParser parser) throws NumberFormatException {
            int jobId = Integer.parseInt(parser.getAttributeValue(null, "jobid"));
            String packageName = parser.getAttributeValue(null, "package");
            String className = parser.getAttributeValue(null, "class");
            ComponentName cname = new ComponentName(packageName, className);
            return new JobInfo.Builder(jobId, cname);
        }

        private void buildConstraintsFromXml(JobInfo.Builder jobBuilder, XmlPullParser parser) {
            String val;
            String netCapabilities = parser.getAttributeValue(null, "net-capabilities");
            String netTransportTypes = parser.getAttributeValue(null, "net-transport-types");
            if (netCapabilities != null && netTransportTypes != null) {
                NetworkRequest request = new NetworkRequest.Builder().build();
                request.networkCapabilities.setCapabilities(BitUtils.unpackBits(Long.parseLong(netCapabilities)));
                request.networkCapabilities.setTransportTypes(BitUtils.unpackBits(Long.parseLong(netTransportTypes)));
                jobBuilder.setRequiredNetwork(request);
            } else {
                val = parser.getAttributeValue(null, "connectivity");
                if (val != null) {
                    jobBuilder.setRequiredNetworkType(1);
                }
                if ((val = parser.getAttributeValue(null, "metered")) != null) {
                    jobBuilder.setRequiredNetworkType(4);
                }
                if ((val = parser.getAttributeValue(null, "unmetered")) != null) {
                    jobBuilder.setRequiredNetworkType(2);
                }
                if ((val = parser.getAttributeValue(null, "not-roaming")) != null) {
                    jobBuilder.setRequiredNetworkType(3);
                }
            }
            val = parser.getAttributeValue(null, "idle");
            if (val != null) {
                jobBuilder.setRequiresDeviceIdle(true);
            }
            if ((val = parser.getAttributeValue(null, "charging")) != null) {
                jobBuilder.setRequiresCharging(true);
            }
        }

        private void maybeBuildBackoffPolicyFromXml(JobInfo.Builder jobBuilder, XmlPullParser parser) {
            String val = parser.getAttributeValue(null, "initial-backoff");
            if (val != null) {
                long initialBackoff = Long.parseLong(val);
                val = parser.getAttributeValue(null, "backoff-policy");
                int backoffPolicy = Integer.parseInt(val);
                jobBuilder.setBackoffCriteria(initialBackoff, backoffPolicy);
            }
        }

        private Pair<Long, Long> buildRtcExecutionTimesFromXml(XmlPullParser parser) throws NumberFormatException {
            String val = parser.getAttributeValue(null, "delay");
            long earliestRunTimeRtc = val != null ? Long.parseLong(val) : 0L;
            val = parser.getAttributeValue(null, "deadline");
            long latestRunTimeRtc = val != null ? Long.parseLong(val) : Long.MAX_VALUE;
            return Pair.create(earliestRunTimeRtc, latestRunTimeRtc);
        }

        private Pair<Long, Long> buildExecutionTimesFromXml(XmlPullParser parser) throws NumberFormatException {
            long nowWallclock = JobSchedulerService.sSystemClock.millis();
            long nowElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
            long earliestRunTimeElapsed = 0L;
            long latestRunTimeElapsed = Long.MAX_VALUE;
            String val = parser.getAttributeValue(null, "deadline");
            if (val != null) {
                long latestRuntimeWallclock = Long.parseLong(val);
                long maxDelayElapsed = Math.max(latestRuntimeWallclock - nowWallclock, 0L);
                latestRunTimeElapsed = nowElapsed + maxDelayElapsed;
            }
            if ((val = parser.getAttributeValue(null, "delay")) != null) {
                long earliestRuntimeWallclock = Long.parseLong(val);
                long minDelayElapsed = Math.max(earliestRuntimeWallclock - nowWallclock, 0L);
                earliestRunTimeElapsed = nowElapsed + minDelayElapsed;
            }
            return Pair.create(earliestRunTimeElapsed, latestRunTimeElapsed);
        }
    }

    public static interface JobStatusFunctor {
        public void process(JobStatus var1);
    }
}

