/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.content.Context;
import android.os.UserHandle;
import android.util.proto.ProtoOutputStream;
import com.android.server.ForceAppStandbyTracker;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.JobStore;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.io.PrintWriter;

public final class BackgroundJobsController
extends StateController {
    private static final String LOG_TAG = "BackgroundJobsController";
    private static final boolean DEBUG = false;
    private static final Object sCreationLock = new Object();
    private static volatile BackgroundJobsController sController;
    private final JobSchedulerService mJobSchedulerService;
    private final ForceAppStandbyTracker mForceAppStandbyTracker;
    private final ForceAppStandbyTracker.Listener mForceAppStandbyListener = new ForceAppStandbyTracker.Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateAllJobs() {
            Object object = BackgroundJobsController.this.mLock;
            synchronized (object) {
                BackgroundJobsController.this.updateAllJobRestrictionsLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateJobsForUid(int uid) {
            Object object = BackgroundJobsController.this.mLock;
            synchronized (object) {
                BackgroundJobsController.this.updateJobRestrictionsForUidLocked(uid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateJobsForUidPackage(int uid, String packageName) {
            Object object = BackgroundJobsController.this.mLock;
            synchronized (object) {
                BackgroundJobsController.this.updateJobRestrictionsForUidLocked(uid);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackgroundJobsController get(JobSchedulerService service) {
        Object object = sCreationLock;
        synchronized (object) {
            if (sController == null) {
                sController = new BackgroundJobsController(service, service.getContext(), service.getLock());
            }
            return sController;
        }
    }

    private BackgroundJobsController(JobSchedulerService service, Context context, Object lock) {
        super(service, context, lock);
        this.mJobSchedulerService = service;
        this.mForceAppStandbyTracker = ForceAppStandbyTracker.getInstance(context);
        this.mForceAppStandbyTracker.addListener(this.mForceAppStandbyListener);
        this.mForceAppStandbyTracker.start();
    }

    @Override
    public void maybeStartTrackingJobLocked(JobStatus jobStatus, JobStatus lastJob) {
        this.updateSingleJobRestrictionLocked(jobStatus);
    }

    @Override
    public void maybeStopTrackingJobLocked(JobStatus jobStatus, JobStatus incomingJob, boolean forUpdate) {
    }

    @Override
    public void dumpControllerStateLocked(PrintWriter pw, int filterUid) {
        pw.println(LOG_TAG);
        this.mForceAppStandbyTracker.dump(pw, "");
        pw.println("Job state:");
        this.mJobSchedulerService.getJobStore().forEachJob(jobStatus -> {
            if (!jobStatus.shouldDump(filterUid)) {
                return;
            }
            int uid = jobStatus.getSourceUid();
            String sourcePkg = jobStatus.getSourcePackageName();
            pw.print("  #");
            jobStatus.printUniqueId(pw);
            pw.print(" from ");
            UserHandle.formatUid(pw, uid);
            pw.print(this.mForceAppStandbyTracker.isUidActive(uid) ? " active" : " idle");
            if (this.mForceAppStandbyTracker.isUidPowerSaveWhitelisted(uid) || this.mForceAppStandbyTracker.isUidTempPowerSaveWhitelisted(uid)) {
                pw.print(", whitelisted");
            }
            pw.print(": ");
            pw.print(sourcePkg);
            pw.print(" [RUN_ANY_IN_BACKGROUND ");
            pw.print(this.mForceAppStandbyTracker.isRunAnyInBackgroundAppOpsAllowed(uid, sourcePkg) ? "allowed]" : "disallowed]");
            if ((jobStatus.satisfiedConstraints & 0x400000) != 0) {
                pw.println(" RUNNABLE");
            } else {
                pw.println(" WAITING");
            }
        });
    }

    @Override
    public void dumpControllerStateLocked(ProtoOutputStream proto, long fieldId, int filterUid) {
        long token = proto.start(fieldId);
        long mToken = proto.start(1146756268034L);
        this.mForceAppStandbyTracker.dumpProto(proto, 0x10B00000001L);
        this.mJobSchedulerService.getJobStore().forEachJob(jobStatus -> {
            if (!jobStatus.shouldDump(filterUid)) {
                return;
            }
            long jsToken = proto.start(0x20B00000002L);
            jobStatus.writeToShortProto(proto, 0x10B00000001L);
            int sourceUid = jobStatus.getSourceUid();
            proto.write(1120986464258L, sourceUid);
            String sourcePkg = jobStatus.getSourcePackageName();
            proto.write(1138166333443L, sourcePkg);
            proto.write(1133871366148L, this.mForceAppStandbyTracker.isUidActive(sourceUid));
            proto.write(1133871366149L, this.mForceAppStandbyTracker.isUidPowerSaveWhitelisted(sourceUid) || this.mForceAppStandbyTracker.isUidTempPowerSaveWhitelisted(sourceUid));
            proto.write(1133871366150L, this.mForceAppStandbyTracker.isRunAnyInBackgroundAppOpsAllowed(sourceUid, sourcePkg));
            proto.write(1133871366151L, (jobStatus.satisfiedConstraints & 0x400000) != 0);
            proto.end(jsToken);
        });
        proto.end(mToken);
        proto.end(token);
    }

    private void updateAllJobRestrictionsLocked() {
        this.updateJobRestrictionsLocked(-1);
    }

    private void updateJobRestrictionsForUidLocked(int uid) {
        this.updateJobRestrictionsLocked(uid);
    }

    private void updateJobRestrictionsLocked(int filterUid) {
        UpdateJobFunctor updateTrackedJobs = new UpdateJobFunctor(filterUid);
        long start = 0L;
        this.mJobSchedulerService.getJobStore().forEachJob(updateTrackedJobs);
        long time = 0L;
        if (updateTrackedJobs.mChanged) {
            this.mStateChangedListener.onControllerStateChanged();
        }
    }

    boolean updateSingleJobRestrictionLocked(JobStatus jobStatus) {
        int uid = jobStatus.getSourceUid();
        String packageName = jobStatus.getSourcePackageName();
        boolean canRun = !this.mForceAppStandbyTracker.areJobsRestricted(uid, packageName, (jobStatus.getInternalFlags() & 1) != 0);
        return jobStatus.setBackgroundNotRestrictedConstraintSatisfied(canRun);
    }

    private final class UpdateJobFunctor
    implements JobStore.JobStatusFunctor {
        private final int mFilterUid;
        boolean mChanged = false;
        int mTotalCount = 0;
        int mCheckedCount = 0;

        UpdateJobFunctor(int filterUid) {
            this.mFilterUid = filterUid;
        }

        @Override
        public void process(JobStatus jobStatus) {
            ++this.mTotalCount;
            if (this.mFilterUid > 0 && this.mFilterUid != jobStatus.getSourceUid()) {
                return;
            }
            ++this.mCheckedCount;
            if (BackgroundJobsController.this.updateSingleJobRestrictionLocked(jobStatus)) {
                this.mChanged = true;
            }
        }
    }
}

