/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.BatteryManagerInternal;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.LocalServices;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.StateChangedListener;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.io.PrintWriter;

public final class BatteryController
extends StateController {
    private static final String TAG = "JobScheduler.Batt";
    private static final Object sCreationLock = new Object();
    private static volatile BatteryController sController;
    private final ArraySet<JobStatus> mTrackedTasks = new ArraySet();
    private ChargingTracker mChargeTracker = new ChargingTracker();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatteryController get(JobSchedulerService taskManagerService) {
        Object object = sCreationLock;
        synchronized (object) {
            if (sController == null) {
                sController = new BatteryController(taskManagerService, taskManagerService.getContext(), taskManagerService.getLock());
            }
        }
        return sController;
    }

    @VisibleForTesting
    public ChargingTracker getTracker() {
        return this.mChargeTracker;
    }

    @VisibleForTesting
    public static BatteryController getForTesting(StateChangedListener stateChangedListener, Context context) {
        return new BatteryController(stateChangedListener, context, new Object());
    }

    private BatteryController(StateChangedListener stateChangedListener, Context context, Object lock) {
        super(stateChangedListener, context, lock);
        this.mChargeTracker.startTracking();
    }

    @Override
    public void maybeStartTrackingJobLocked(JobStatus taskStatus, JobStatus lastJob) {
        if (taskStatus.hasPowerConstraint()) {
            this.mTrackedTasks.add(taskStatus);
            taskStatus.setTrackingController(1);
            taskStatus.setChargingConstraintSatisfied(this.mChargeTracker.isOnStablePower());
            taskStatus.setBatteryNotLowConstraintSatisfied(this.mChargeTracker.isBatteryNotLow());
        }
    }

    @Override
    public void maybeStopTrackingJobLocked(JobStatus taskStatus, JobStatus incomingJob, boolean forUpdate) {
        if (taskStatus.clearTrackingController(1)) {
            this.mTrackedTasks.remove(taskStatus);
        }
    }

    private void maybeReportNewChargingStateLocked() {
        boolean stablePower = this.mChargeTracker.isOnStablePower();
        boolean batteryNotLow = this.mChargeTracker.isBatteryNotLow();
        boolean reportChange = false;
        for (int i = this.mTrackedTasks.size() - 1; i >= 0; --i) {
            JobStatus ts = this.mTrackedTasks.valueAt(i);
            boolean previous = ts.setChargingConstraintSatisfied(stablePower);
            if (previous != stablePower) {
                reportChange = true;
            }
            if ((previous = ts.setBatteryNotLowConstraintSatisfied(batteryNotLow)) == batteryNotLow) continue;
            reportChange = true;
        }
        if (stablePower || batteryNotLow) {
            this.mStateChangedListener.onRunJobNow(null);
        } else if (reportChange) {
            this.mStateChangedListener.onControllerStateChanged();
        }
    }

    @Override
    public void dumpControllerStateLocked(PrintWriter pw, int filterUid) {
        pw.print("Battery: stable power = ");
        pw.print(this.mChargeTracker.isOnStablePower());
        pw.print(", not low = ");
        pw.println(this.mChargeTracker.isBatteryNotLow());
        if (this.mChargeTracker.isMonitoring()) {
            pw.print("MONITORING: seq=");
            pw.println(this.mChargeTracker.getSeq());
        }
        pw.print("Tracking ");
        pw.print(this.mTrackedTasks.size());
        pw.println(":");
        for (int i = 0; i < this.mTrackedTasks.size(); ++i) {
            JobStatus js = this.mTrackedTasks.valueAt(i);
            if (!js.shouldDump(filterUid)) continue;
            pw.print("  #");
            js.printUniqueId(pw);
            pw.print(" from ");
            UserHandle.formatUid(pw, js.getSourceUid());
            pw.println();
        }
    }

    @Override
    public void dumpControllerStateLocked(ProtoOutputStream proto, long fieldId, int filterUid) {
        long token = proto.start(fieldId);
        long mToken = proto.start(1146756268035L);
        proto.write(0x10800000001L, this.mChargeTracker.isOnStablePower());
        proto.write(1133871366146L, this.mChargeTracker.isBatteryNotLow());
        proto.write(1133871366147L, this.mChargeTracker.isMonitoring());
        proto.write(1120986464260L, this.mChargeTracker.getSeq());
        for (int i = 0; i < this.mTrackedTasks.size(); ++i) {
            JobStatus js = this.mTrackedTasks.valueAt(i);
            if (!js.shouldDump(filterUid)) continue;
            long jsToken = proto.start(2246267895813L);
            js.writeToShortProto(proto, 0x10B00000001L);
            proto.write(1120986464258L, js.getSourceUid());
            proto.end(jsToken);
        }
        proto.end(mToken);
        proto.end(token);
    }

    public final class ChargingTracker
    extends BroadcastReceiver {
        private boolean mCharging;
        private boolean mBatteryHealthy;
        private int mLastBatterySeq = -1;
        private BroadcastReceiver mMonitor;

        public void startTracking() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.BATTERY_LOW");
            filter.addAction("android.intent.action.BATTERY_OKAY");
            filter.addAction("android.os.action.CHARGING");
            filter.addAction("android.os.action.DISCHARGING");
            BatteryController.this.mContext.registerReceiver(this, filter);
            BatteryManagerInternal batteryManagerInternal = LocalServices.getService(BatteryManagerInternal.class);
            this.mBatteryHealthy = !batteryManagerInternal.getBatteryLevelLow();
            this.mCharging = batteryManagerInternal.isPowered(7);
        }

        public void setMonitorBatteryLocked(boolean enabled) {
            if (enabled) {
                if (this.mMonitor == null) {
                    this.mMonitor = new BroadcastReceiver(){

                        @Override
                        public void onReceive(Context context, Intent intent) {
                            ChargingTracker.this.onReceive(context, intent);
                        }
                    };
                    IntentFilter filter = new IntentFilter();
                    filter.addAction("android.intent.action.BATTERY_CHANGED");
                    BatteryController.this.mContext.registerReceiver(this.mMonitor, filter);
                }
            } else if (this.mMonitor != null) {
                BatteryController.this.mContext.unregisterReceiver(this.mMonitor);
                this.mMonitor = null;
            }
        }

        public boolean isOnStablePower() {
            return this.mCharging && this.mBatteryHealthy;
        }

        public boolean isBatteryNotLow() {
            return this.mBatteryHealthy;
        }

        public boolean isMonitoring() {
            return this.mMonitor != null;
        }

        public int getSeq() {
            return this.mLastBatterySeq;
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            this.onReceiveInternal(intent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public void onReceiveInternal(Intent intent) {
            Object object = BatteryController.this.mLock;
            synchronized (object) {
                String action = intent.getAction();
                if ("android.intent.action.BATTERY_LOW".equals(action)) {
                    this.mBatteryHealthy = false;
                    BatteryController.this.maybeReportNewChargingStateLocked();
                } else if ("android.intent.action.BATTERY_OKAY".equals(action)) {
                    this.mBatteryHealthy = true;
                    BatteryController.this.maybeReportNewChargingStateLocked();
                } else if ("android.os.action.CHARGING".equals(action)) {
                    this.mCharging = true;
                    BatteryController.this.maybeReportNewChargingStateLocked();
                } else if ("android.os.action.DISCHARGING".equals(action)) {
                    this.mCharging = false;
                    BatteryController.this.maybeReportNewChargingStateLocked();
                }
                this.mLastBatterySeq = intent.getIntExtra("seq", this.mLastBatterySeq);
            }
        }
    }
}

