/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.INetworkPolicyListener;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkPolicyManager;
import android.net.NetworkRequest;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.StateChangedListener;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.io.PrintWriter;

public final class ConnectivityController
extends StateController
implements ConnectivityManager.OnNetworkActiveListener {
    private static final String TAG = "JobScheduler.Conn";
    private static final boolean DEBUG = false;
    private final ConnectivityManager mConnManager;
    private final NetworkPolicyManager mNetPolicyManager;
    private boolean mConnected = false;
    @GuardedBy(value="mLock")
    private final ArraySet<JobStatus> mTrackedJobs = new ArraySet();
    private static ConnectivityController sSingleton;
    private static Object sCreationLock;
    private final ConnectivityManager.NetworkCallback mNetworkCallback = new ConnectivityManager.NetworkCallback(){

        @Override
        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            ConnectivityController.this.updateTrackedJobs(-1);
        }

        @Override
        public void onLost(Network network) {
            ConnectivityController.this.updateTrackedJobs(-1);
        }
    };
    private final INetworkPolicyListener mNetPolicyListener = new NetworkPolicyManager.Listener(){

        @Override
        public void onUidRulesChanged(int uid, int uidRules) {
            ConnectivityController.this.updateTrackedJobs(uid);
        }

        @Override
        public void onRestrictBackgroundChanged(boolean restrictBackground) {
            ConnectivityController.this.updateTrackedJobs(-1);
        }

        @Override
        public void onUidPoliciesChanged(int uid, int uidPolicies) {
            ConnectivityController.this.updateTrackedJobs(uid);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectivityController get(JobSchedulerService jms) {
        Object object = sCreationLock;
        synchronized (object) {
            if (sSingleton == null) {
                sSingleton = new ConnectivityController(jms, jms.getContext(), jms.getLock());
            }
            return sSingleton;
        }
    }

    private ConnectivityController(StateChangedListener stateChangedListener, Context context, Object lock) {
        super(stateChangedListener, context, lock);
        this.mConnManager = this.mContext.getSystemService(ConnectivityManager.class);
        this.mNetPolicyManager = this.mContext.getSystemService(NetworkPolicyManager.class);
        this.mConnManager.registerDefaultNetworkCallback(this.mNetworkCallback);
        this.mNetPolicyManager.registerListener(this.mNetPolicyListener);
    }

    @Override
    public void maybeStartTrackingJobLocked(JobStatus jobStatus, JobStatus lastJob) {
        if (jobStatus.hasConnectivityConstraint()) {
            this.updateConstraintsSatisfied(jobStatus);
            this.mTrackedJobs.add(jobStatus);
            jobStatus.setTrackingController(2);
        }
    }

    @Override
    public void maybeStopTrackingJobLocked(JobStatus jobStatus, JobStatus incomingJob, boolean forUpdate) {
        if (jobStatus.clearTrackingController(2)) {
            this.mTrackedJobs.remove(jobStatus);
        }
    }

    private static boolean isInsane(JobStatus jobStatus, Network network, NetworkCapabilities capabilities) {
        long estimatedBytes = jobStatus.getEstimatedNetworkBytes();
        if (estimatedBytes == -1L) {
            return false;
        }
        long slowest = NetworkCapabilities.minBandwidth(capabilities.getLinkDownstreamBandwidthKbps(), capabilities.getLinkUpstreamBandwidthKbps());
        if (slowest == 0L) {
            return false;
        }
        long estimatedMillis = estimatedBytes * 1000L / (slowest * 1024L / 8L);
        if (estimatedMillis > 600000L) {
            Slog.w(TAG, "Estimated " + estimatedBytes + " bytes over " + slowest + " kbps network would take " + estimatedMillis + "ms; that's insane!");
            return true;
        }
        return false;
    }

    private static boolean isCongestionDelayed(JobStatus jobStatus, Network network, NetworkCapabilities capabilities) {
        if (!capabilities.hasCapability(20)) {
            return (double)jobStatus.getFractionRunTime() < 0.5;
        }
        return false;
    }

    private static boolean isStrictSatisfied(JobStatus jobStatus, Network network, NetworkCapabilities capabilities) {
        return jobStatus.getJob().getRequiredNetwork().networkCapabilities.satisfiedByNetworkCapabilities(capabilities);
    }

    private static boolean isRelaxedSatisfied(JobStatus jobStatus, Network network, NetworkCapabilities capabilities) {
        if ((jobStatus.getJob().getFlags() & 4) == 0) {
            return false;
        }
        NetworkCapabilities relaxed = new NetworkCapabilities(jobStatus.getJob().getRequiredNetwork().networkCapabilities).removeCapability(11);
        if (relaxed.satisfiedByNetworkCapabilities(capabilities)) {
            return (double)jobStatus.getFractionRunTime() > 0.5;
        }
        return false;
    }

    @VisibleForTesting
    static boolean isSatisfied(JobStatus jobStatus, Network network, NetworkCapabilities capabilities) {
        if (network == null || capabilities == null) {
            return false;
        }
        if (ConnectivityController.isInsane(jobStatus, network, capabilities)) {
            return false;
        }
        if (ConnectivityController.isCongestionDelayed(jobStatus, network, capabilities)) {
            return false;
        }
        if (ConnectivityController.isStrictSatisfied(jobStatus, network, capabilities)) {
            return true;
        }
        return ConnectivityController.isRelaxedSatisfied(jobStatus, network, capabilities);
    }

    private boolean updateConstraintsSatisfied(JobStatus jobStatus) {
        int jobUid = jobStatus.getSourceUid();
        boolean ignoreBlocked = (jobStatus.getFlags() & 1) != 0;
        Network network = this.mConnManager.getActiveNetworkForUid(jobUid, ignoreBlocked);
        NetworkInfo info = this.mConnManager.getNetworkInfoForUid(network, jobUid, ignoreBlocked);
        NetworkCapabilities capabilities = this.mConnManager.getNetworkCapabilities(network);
        boolean connected = info != null && info.isConnected();
        boolean satisfied = ConnectivityController.isSatisfied(jobStatus, network, capabilities);
        boolean changed = jobStatus.setConnectivityConstraintSatisfied(connected && satisfied);
        jobStatus.network = network;
        if (jobUid == 1000) {
            this.mConnected = connected;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTrackedJobs(int uid) {
        Object object = this.mLock;
        synchronized (object) {
            boolean changed = false;
            for (int i = this.mTrackedJobs.size() - 1; i >= 0; --i) {
                JobStatus js = this.mTrackedJobs.valueAt(i);
                if (uid != -1 && uid != js.getSourceUid()) continue;
                changed |= this.updateConstraintsSatisfied(js);
            }
            if (changed) {
                this.mStateChangedListener.onControllerStateChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNetworkActive() {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mTrackedJobs.size() - 1; i >= 0; --i) {
                JobStatus js = this.mTrackedJobs.valueAt(i);
                if (!js.isReady()) continue;
                this.mStateChangedListener.onRunJobNow(js);
            }
        }
    }

    @Override
    public void dumpControllerStateLocked(PrintWriter pw, int filterUid) {
        pw.print("Connectivity: connected=");
        pw.println(this.mConnected);
        pw.print("Tracking ");
        pw.print(this.mTrackedJobs.size());
        pw.println(" jobs");
        for (int i = 0; i < this.mTrackedJobs.size(); ++i) {
            JobStatus js = this.mTrackedJobs.valueAt(i);
            if (!js.shouldDump(filterUid)) continue;
            pw.print("  #");
            js.printUniqueId(pw);
            pw.print(" from ");
            UserHandle.formatUid(pw, js.getSourceUid());
            pw.print(": ");
            pw.print(js.getJob().getRequiredNetwork());
            pw.println();
        }
    }

    @Override
    public void dumpControllerStateLocked(ProtoOutputStream proto, long fieldId, int filterUid) {
        long token = proto.start(fieldId);
        long mToken = proto.start(1146756268036L);
        proto.write(0x10800000001L, this.mConnected);
        for (int i = 0; i < this.mTrackedJobs.size(); ++i) {
            JobStatus js = this.mTrackedJobs.valueAt(i);
            if (!js.shouldDump(filterUid)) continue;
            long jsToken = proto.start(0x20B00000002L);
            js.writeToShortProto(proto, 0x10B00000001L);
            proto.write(1120986464258L, js.getSourceUid());
            NetworkRequest rn = js.getJob().getRequiredNetwork();
            if (rn != null) {
                rn.writeToProto(proto, 1146756268035L);
            }
            proto.end(jsToken);
        }
        proto.end(mToken);
        proto.end(token);
    }

    static {
        sCreationLock = new Object();
    }
}

