/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.SparseBooleanArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.ArrayUtils;
import com.android.server.DeviceIdleController;
import com.android.server.LocalServices;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.JobStore;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.io.PrintWriter;
import java.util.Arrays;

public final class DeviceIdleJobsController
extends StateController {
    private static final String LOG_TAG = "DeviceIdleJobsController";
    private static final boolean LOG_DEBUG = false;
    private static final long BACKGROUND_JOBS_DELAY = 3000L;
    static final int PROCESS_BACKGROUND_JOBS = 1;
    private static Object sCreationLock = new Object();
    private static DeviceIdleJobsController sController;
    private final ArraySet<JobStatus> mAllowInIdleJobs;
    private final SparseBooleanArray mForegroundUids;
    private final DeviceIdleUpdateFunctor mDeviceIdleUpdateFunctor;
    private final DeviceIdleJobsDelayHandler mHandler;
    private final JobSchedulerService mJobSchedulerService;
    private final PowerManager mPowerManager;
    private final DeviceIdleController.LocalService mLocalDeviceIdleController;
    private boolean mDeviceIdleMode;
    private int[] mDeviceIdleWhitelistAppIds;
    private int[] mPowerSaveTempWhitelistAppIds;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case "android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED": 
                case "android.os.action.DEVICE_IDLE_MODE_CHANGED": {
                    DeviceIdleJobsController.this.updateIdleMode(DeviceIdleJobsController.this.mPowerManager != null && (DeviceIdleJobsController.this.mPowerManager.isDeviceIdleMode() || DeviceIdleJobsController.this.mPowerManager.isLightDeviceIdleMode()));
                    break;
                }
                case "android.os.action.POWER_SAVE_WHITELIST_CHANGED": {
                    Object object = DeviceIdleJobsController.this.mLock;
                    synchronized (object) {
                        DeviceIdleJobsController.access$102(DeviceIdleJobsController.this, DeviceIdleJobsController.this.mLocalDeviceIdleController.getPowerSaveWhitelistUserAppIds());
                        break;
                    }
                }
                case "android.os.action.POWER_SAVE_TEMP_WHITELIST_CHANGED": {
                    Object object = DeviceIdleJobsController.this.mLock;
                    synchronized (object) {
                        DeviceIdleJobsController.access$302(DeviceIdleJobsController.this, DeviceIdleJobsController.this.mLocalDeviceIdleController.getPowerSaveTempWhitelistAppIds());
                        boolean changed = false;
                        for (int i = 0; i < DeviceIdleJobsController.this.mAllowInIdleJobs.size(); ++i) {
                            changed |= DeviceIdleJobsController.this.updateTaskStateLocked((JobStatus)DeviceIdleJobsController.this.mAllowInIdleJobs.valueAt(i));
                        }
                        if (changed) {
                            DeviceIdleJobsController.this.mStateChangedListener.onControllerStateChanged();
                        }
                        break;
                    }
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceIdleJobsController get(JobSchedulerService service) {
        Object object = sCreationLock;
        synchronized (object) {
            if (sController == null) {
                sController = new DeviceIdleJobsController(service, service.getContext(), service.getLock());
            }
            return sController;
        }
    }

    private DeviceIdleJobsController(JobSchedulerService jobSchedulerService, Context context, Object lock) {
        super(jobSchedulerService, context, lock);
        this.mJobSchedulerService = jobSchedulerService;
        this.mHandler = new DeviceIdleJobsDelayHandler(context.getMainLooper());
        this.mPowerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mLocalDeviceIdleController = LocalServices.getService(DeviceIdleController.LocalService.class);
        this.mDeviceIdleWhitelistAppIds = this.mLocalDeviceIdleController.getPowerSaveWhitelistUserAppIds();
        this.mPowerSaveTempWhitelistAppIds = this.mLocalDeviceIdleController.getPowerSaveTempWhitelistAppIds();
        this.mDeviceIdleUpdateFunctor = new DeviceIdleUpdateFunctor();
        this.mAllowInIdleJobs = new ArraySet();
        this.mForegroundUids = new SparseBooleanArray();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.os.action.DEVICE_IDLE_MODE_CHANGED");
        filter.addAction("android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED");
        filter.addAction("android.os.action.POWER_SAVE_WHITELIST_CHANGED");
        filter.addAction("android.os.action.POWER_SAVE_TEMP_WHITELIST_CHANGED");
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, filter, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateIdleMode(boolean enabled) {
        boolean changed = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDeviceIdleMode != enabled) {
                changed = true;
            }
            this.mDeviceIdleMode = enabled;
            if (enabled) {
                this.mHandler.removeMessages(1);
                this.mJobSchedulerService.getJobStore().forEachJob(this.mDeviceIdleUpdateFunctor);
            } else {
                for (int i = 0; i < this.mForegroundUids.size(); ++i) {
                    if (!this.mForegroundUids.valueAt(i)) continue;
                    this.mJobSchedulerService.getJobStore().forEachJobForSourceUid(this.mForegroundUids.keyAt(i), this.mDeviceIdleUpdateFunctor);
                }
                this.mHandler.sendEmptyMessageDelayed(1, 3000L);
            }
        }
        if (changed) {
            this.mStateChangedListener.onDeviceIdleStateChanged(enabled);
        }
    }

    public void setUidActiveLocked(int uid, boolean active) {
        boolean changed;
        boolean bl = changed = active != this.mForegroundUids.get(uid);
        if (!changed) {
            return;
        }
        this.mForegroundUids.put(uid, active);
        this.mDeviceIdleUpdateFunctor.mChanged = false;
        this.mJobSchedulerService.getJobStore().forEachJobForSourceUid(uid, this.mDeviceIdleUpdateFunctor);
        if (this.mDeviceIdleUpdateFunctor.mChanged) {
            this.mStateChangedListener.onControllerStateChanged();
        }
    }

    boolean isWhitelistedLocked(JobStatus job) {
        return Arrays.binarySearch(this.mDeviceIdleWhitelistAppIds, UserHandle.getAppId(job.getSourceUid())) >= 0;
    }

    boolean isTempWhitelistedLocked(JobStatus job) {
        return ArrayUtils.contains(this.mPowerSaveTempWhitelistAppIds, UserHandle.getAppId(job.getSourceUid()));
    }

    private boolean updateTaskStateLocked(JobStatus task) {
        boolean allowInIdle = (task.getFlags() & 2) != 0 && (this.mForegroundUids.get(task.getSourceUid()) || this.isTempWhitelistedLocked(task));
        boolean whitelisted = this.isWhitelistedLocked(task);
        boolean enableTask = !this.mDeviceIdleMode || whitelisted || allowInIdle;
        return task.setDeviceNotDozingConstraintSatisfied(enableTask, whitelisted);
    }

    @Override
    public void maybeStartTrackingJobLocked(JobStatus jobStatus, JobStatus lastJob) {
        if ((jobStatus.getFlags() & 2) != 0) {
            this.mAllowInIdleJobs.add(jobStatus);
        }
        this.updateTaskStateLocked(jobStatus);
    }

    @Override
    public void maybeStopTrackingJobLocked(JobStatus jobStatus, JobStatus incomingJob, boolean forUpdate) {
        if ((jobStatus.getFlags() & 2) != 0) {
            this.mAllowInIdleJobs.remove(jobStatus);
        }
    }

    @Override
    public void dumpControllerStateLocked(final PrintWriter pw, final int filterUid) {
        pw.println(LOG_TAG);
        pw.println("mDeviceIdleMode=" + this.mDeviceIdleMode);
        this.mJobSchedulerService.getJobStore().forEachJob(new JobStore.JobStatusFunctor(){

            @Override
            public void process(JobStatus jobStatus) {
                if (!jobStatus.shouldDump(filterUid)) {
                    return;
                }
                pw.print("  #");
                jobStatus.printUniqueId(pw);
                pw.print(" from ");
                UserHandle.formatUid(pw, jobStatus.getSourceUid());
                pw.print(": ");
                pw.print(jobStatus.getSourcePackageName());
                pw.print((jobStatus.satisfiedConstraints & 0x2000000) != 0 ? " RUNNABLE" : " WAITING");
                if (jobStatus.dozeWhitelisted) {
                    pw.print(" WHITELISTED");
                }
                if (DeviceIdleJobsController.this.mAllowInIdleJobs.contains(jobStatus)) {
                    pw.print(" ALLOWED_IN_DOZE");
                }
                pw.println();
            }
        });
    }

    @Override
    public void dumpControllerStateLocked(final ProtoOutputStream proto, long fieldId, final int filterUid) {
        long token = proto.start(fieldId);
        long mToken = proto.start(1146756268038L);
        proto.write(0x10800000001L, this.mDeviceIdleMode);
        this.mJobSchedulerService.getJobStore().forEachJob(new JobStore.JobStatusFunctor(){

            @Override
            public void process(JobStatus jobStatus) {
                if (!jobStatus.shouldDump(filterUid)) {
                    return;
                }
                long jsToken = proto.start(0x20B00000002L);
                jobStatus.writeToShortProto(proto, 0x10B00000001L);
                proto.write(1120986464258L, jobStatus.getSourceUid());
                proto.write(1138166333443L, jobStatus.getSourcePackageName());
                proto.write(1133871366148L, (jobStatus.satisfiedConstraints & 0x2000000) != 0);
                proto.write(1133871366149L, jobStatus.dozeWhitelisted);
                proto.write(1133871366150L, DeviceIdleJobsController.this.mAllowInIdleJobs.contains(jobStatus));
                proto.end(jsToken);
            }
        });
        proto.end(mToken);
        proto.end(token);
    }

    static /* synthetic */ int[] access$102(DeviceIdleJobsController x0, int[] x1) {
        x0.mDeviceIdleWhitelistAppIds = x1;
        return x1;
    }

    static /* synthetic */ int[] access$302(DeviceIdleJobsController x0, int[] x1) {
        x0.mPowerSaveTempWhitelistAppIds = x1;
        return x1;
    }

    final class DeviceIdleJobsDelayHandler
    extends Handler {
        public DeviceIdleJobsDelayHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Object object = DeviceIdleJobsController.this.mLock;
                    synchronized (object) {
                        ((DeviceIdleJobsController)DeviceIdleJobsController.this).mDeviceIdleUpdateFunctor.mChanged = false;
                        DeviceIdleJobsController.this.mJobSchedulerService.getJobStore().forEachJob(DeviceIdleJobsController.this.mDeviceIdleUpdateFunctor);
                        if (((DeviceIdleJobsController)DeviceIdleJobsController.this).mDeviceIdleUpdateFunctor.mChanged) {
                            DeviceIdleJobsController.this.mStateChangedListener.onControllerStateChanged();
                        }
                        break;
                    }
                }
            }
        }
    }

    final class DeviceIdleUpdateFunctor
    implements JobStore.JobStatusFunctor {
        boolean mChanged;

        DeviceIdleUpdateFunctor() {
        }

        @Override
        public void process(JobStatus jobStatus) {
            this.mChanged |= DeviceIdleJobsController.this.updateTaskStateLocked(jobStatus);
        }
    }
}

