/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.proto.ProtoOutputStream;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.StateChangedListener;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.io.PrintWriter;

public final class IdleController
extends StateController {
    private static final String TAG = "IdleController";
    private long mInactivityIdleThreshold;
    private long mIdleWindowSlop;
    final ArraySet<JobStatus> mTrackedTasks = new ArraySet();
    IdlenessTracker mIdleTracker;
    private static Object sCreationLock = new Object();
    private static volatile IdleController sController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IdleController get(JobSchedulerService service) {
        Object object = sCreationLock;
        synchronized (object) {
            if (sController == null) {
                sController = new IdleController(service, service.getContext(), service.getLock());
            }
            return sController;
        }
    }

    private IdleController(StateChangedListener stateChangedListener, Context context, Object lock) {
        super(stateChangedListener, context, lock);
        this.initIdleStateTracking();
    }

    @Override
    public void maybeStartTrackingJobLocked(JobStatus taskStatus, JobStatus lastJob) {
        if (taskStatus.hasIdleConstraint()) {
            this.mTrackedTasks.add(taskStatus);
            taskStatus.setTrackingController(8);
            taskStatus.setIdleConstraintSatisfied(this.mIdleTracker.isIdle());
        }
    }

    @Override
    public void maybeStopTrackingJobLocked(JobStatus taskStatus, JobStatus incomingJob, boolean forUpdate) {
        if (taskStatus.clearTrackingController(8)) {
            this.mTrackedTasks.remove(taskStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportNewIdleState(boolean isIdle) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mTrackedTasks.size() - 1; i >= 0; --i) {
                this.mTrackedTasks.valueAt(i).setIdleConstraintSatisfied(isIdle);
            }
        }
        this.mStateChangedListener.onControllerStateChanged();
    }

    private void initIdleStateTracking() {
        this.mInactivityIdleThreshold = this.mContext.getResources().getInteger(17694790);
        this.mIdleWindowSlop = this.mContext.getResources().getInteger(17694789);
        this.mIdleTracker = new IdlenessTracker();
        this.mIdleTracker.startTracking();
    }

    @Override
    public void dumpControllerStateLocked(PrintWriter pw, int filterUid) {
        pw.print("Idle: ");
        pw.println(this.mIdleTracker.isIdle());
        pw.print("Tracking ");
        pw.print(this.mTrackedTasks.size());
        pw.println(":");
        for (int i = 0; i < this.mTrackedTasks.size(); ++i) {
            JobStatus js = this.mTrackedTasks.valueAt(i);
            if (!js.shouldDump(filterUid)) continue;
            pw.print("  #");
            js.printUniqueId(pw);
            pw.print(" from ");
            UserHandle.formatUid(pw, js.getSourceUid());
            pw.println();
        }
    }

    @Override
    public void dumpControllerStateLocked(ProtoOutputStream proto, long fieldId, int filterUid) {
        long token = proto.start(fieldId);
        long mToken = proto.start(1146756268039L);
        proto.write(0x10800000001L, this.mIdleTracker.isIdle());
        for (int i = 0; i < this.mTrackedTasks.size(); ++i) {
            JobStatus js = this.mTrackedTasks.valueAt(i);
            if (!js.shouldDump(filterUid)) continue;
            long jsToken = proto.start(0x20B00000002L);
            js.writeToShortProto(proto, 0x10B00000001L);
            proto.write(1120986464258L, js.getSourceUid());
            proto.end(jsToken);
        }
        proto.end(mToken);
        proto.end(token);
    }

    final class IdlenessTracker
    extends BroadcastReceiver {
        private AlarmManager mAlarm;
        private PendingIntent mIdleTriggerIntent;
        boolean mIdle;
        boolean mScreenOn;

        public IdlenessTracker() {
            this.mAlarm = (AlarmManager)IdleController.this.mContext.getSystemService("alarm");
            Intent intent = new Intent("com.android.server.ACTION_TRIGGER_IDLE").setPackage("android").setFlags(0x40000000);
            this.mIdleTriggerIntent = PendingIntent.getBroadcast(IdleController.this.mContext, 0, intent, 0);
            this.mIdle = false;
            this.mScreenOn = true;
        }

        public boolean isIdle() {
            return this.mIdle;
        }

        public void startTracking() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.SCREEN_ON");
            filter.addAction("android.intent.action.SCREEN_OFF");
            filter.addAction("android.intent.action.DREAMING_STARTED");
            filter.addAction("android.intent.action.DREAMING_STOPPED");
            filter.addAction("com.android.server.ACTION_TRIGGER_IDLE");
            IdleController.this.mContext.registerReceiver(this, filter);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.SCREEN_ON") || action.equals("android.intent.action.DREAMING_STOPPED")) {
                this.mScreenOn = true;
                this.mAlarm.cancel(this.mIdleTriggerIntent);
                if (this.mIdle) {
                    this.mIdle = false;
                    IdleController.this.reportNewIdleState(this.mIdle);
                }
            } else if (action.equals("android.intent.action.SCREEN_OFF") || action.equals("android.intent.action.DREAMING_STARTED")) {
                long nowElapsed = JobSchedulerService.sElapsedRealtimeClock.millis();
                long when = nowElapsed + IdleController.this.mInactivityIdleThreshold;
                this.mScreenOn = false;
                this.mAlarm.setWindow(2, when, IdleController.this.mIdleWindowSlop, this.mIdleTriggerIntent);
            } else if (action.equals("com.android.server.ACTION_TRIGGER_IDLE") && !this.mIdle && !this.mScreenOn) {
                this.mIdle = true;
                IdleController.this.reportNewIdleState(this.mIdle);
            }
        }
    }
}

