/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.location.Geofence;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationRequest;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Slog;
import com.android.server.LocationManagerService;
import com.android.server.location.GeofenceState;
import com.android.server.location.LocationBlacklist;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class GeofenceManager
implements LocationListener,
PendingIntent.OnFinished {
    private static final String TAG = "GeofenceManager";
    private static final boolean D = LocationManagerService.D;
    private static final int MSG_UPDATE_FENCES = 1;
    private static final int MAX_SPEED_M_S = 100;
    private static final long MAX_AGE_NANOS = 300000000000L;
    private static final long DEFAULT_MIN_INTERVAL_MS = 1800000L;
    private static final long MAX_INTERVAL_MS = 0x6DDD00L;
    private final Context mContext;
    private final LocationManager mLocationManager;
    private final AppOpsManager mAppOps;
    private final PowerManager.WakeLock mWakeLock;
    private final GeofenceHandler mHandler;
    private final LocationBlacklist mBlacklist;
    private Object mLock = new Object();
    private List<GeofenceState> mFences = new LinkedList<GeofenceState>();
    private boolean mReceivingLocationUpdates;
    private long mLocationUpdateInterval;
    private Location mLastLocationUpdate;
    private boolean mPendingUpdate;
    private long mEffectiveMinIntervalMs;
    private ContentResolver mResolver;

    public GeofenceManager(Context context, LocationBlacklist blacklist) {
        this.mContext = context;
        this.mLocationManager = (LocationManager)this.mContext.getSystemService("location");
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, TAG);
        this.mHandler = new GeofenceHandler();
        this.mBlacklist = blacklist;
        this.mResolver = this.mContext.getContentResolver();
        this.updateMinInterval();
        this.mResolver.registerContentObserver(Settings.Global.getUriFor("location_background_throttle_proximity_alert_interval_ms"), true, new ContentObserver(this.mHandler){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChange(boolean selfChange) {
                Object object = GeofenceManager.this.mLock;
                synchronized (object) {
                    GeofenceManager.this.updateMinInterval();
                }
            }
        }, -1);
    }

    private void updateMinInterval() {
        this.mEffectiveMinIntervalMs = Settings.Global.getLong(this.mResolver, "location_background_throttle_proximity_alert_interval_ms", 1800000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFence(LocationRequest request, Geofence geofence, PendingIntent intent, int allowedResolutionLevel, int uid, String packageName) {
        if (D) {
            Slog.d(TAG, "addFence: request=" + request + ", geofence=" + geofence + ", intent=" + intent + ", uid=" + uid + ", packageName=" + packageName);
        }
        GeofenceState state = new GeofenceState(geofence, request.getExpireAt(), allowedResolutionLevel, uid, packageName, intent);
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mFences.size() - 1; i >= 0; --i) {
                GeofenceState w = this.mFences.get(i);
                if (!geofence.equals(w.mFence) || !intent.equals(w.mIntent)) continue;
                this.mFences.remove(i);
                break;
            }
            this.mFences.add(state);
            this.scheduleUpdateFencesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFence(Geofence fence, PendingIntent intent) {
        if (D) {
            Slog.d(TAG, "removeFence: fence=" + fence + ", intent=" + intent);
        }
        Object object = this.mLock;
        synchronized (object) {
            Iterator<GeofenceState> iter = this.mFences.iterator();
            while (iter.hasNext()) {
                GeofenceState state = iter.next();
                if (!state.mIntent.equals(intent)) continue;
                if (fence == null) {
                    iter.remove();
                    continue;
                }
                if (!fence.equals(state.mFence)) continue;
                iter.remove();
            }
            this.scheduleUpdateFencesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFence(String packageName) {
        if (D) {
            Slog.d(TAG, "removeFence: packageName=" + packageName);
        }
        Object object = this.mLock;
        synchronized (object) {
            Iterator<GeofenceState> iter = this.mFences.iterator();
            while (iter.hasNext()) {
                GeofenceState state = iter.next();
                if (!state.mPackageName.equals(packageName)) continue;
                iter.remove();
            }
            this.scheduleUpdateFencesLocked();
        }
    }

    private void removeExpiredFencesLocked() {
        long time = SystemClock.elapsedRealtime();
        Iterator<GeofenceState> iter = this.mFences.iterator();
        while (iter.hasNext()) {
            GeofenceState state = iter.next();
            if (state.mExpireAt >= time) continue;
            iter.remove();
        }
    }

    private void scheduleUpdateFencesLocked() {
        if (!this.mPendingUpdate) {
            this.mPendingUpdate = true;
            this.mHandler.sendEmptyMessage(1);
        }
    }

    private Location getFreshLocationLocked() {
        Location location;
        Location location2 = location = this.mReceivingLocationUpdates ? this.mLastLocationUpdate : null;
        if (location == null && !this.mFences.isEmpty()) {
            location = this.mLocationManager.getLastLocation();
        }
        if (location == null) {
            return null;
        }
        long now = SystemClock.elapsedRealtimeNanos();
        if (now - location.getElapsedRealtimeNanos() > 300000000000L) {
            return null;
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFences() {
        LinkedList<PendingIntent> enterIntents = new LinkedList<PendingIntent>();
        LinkedList<PendingIntent> exitIntents = new LinkedList<PendingIntent>();
        Iterator iterator = this.mLock;
        synchronized (iterator) {
            this.mPendingUpdate = false;
            this.removeExpiredFencesLocked();
            Location location = this.getFreshLocationLocked();
            double minFenceDistance = Double.MAX_VALUE;
            boolean needUpdates = false;
            for (GeofenceState state : this.mFences) {
                double fenceDistance;
                if (this.mBlacklist.isBlacklisted(state.mPackageName)) {
                    if (!D) continue;
                    Slog.d(TAG, "skipping geofence processing for blacklisted app: " + state.mPackageName);
                    continue;
                }
                int op = LocationManagerService.resolutionLevelToOp(state.mAllowedResolutionLevel);
                if (op >= 0 && this.mAppOps.noteOpNoThrow(1, state.mUid, state.mPackageName) != 0) {
                    if (!D) continue;
                    Slog.d(TAG, "skipping geofence processing for no op app: " + state.mPackageName);
                    continue;
                }
                needUpdates = true;
                if (location == null) continue;
                int event = state.processLocation(location);
                if ((event & 1) != 0) {
                    enterIntents.add(state.mIntent);
                }
                if ((event & 2) != 0) {
                    exitIntents.add(state.mIntent);
                }
                if (!((fenceDistance = state.getDistanceToBoundary()) < minFenceDistance)) continue;
                minFenceDistance = fenceDistance;
            }
            if (needUpdates) {
                long intervalMs = location != null && Double.compare(minFenceDistance, Double.MAX_VALUE) != 0 ? (long)Math.min(7200000.0, Math.max((double)this.mEffectiveMinIntervalMs, minFenceDistance * 1000.0 / 100.0)) : this.mEffectiveMinIntervalMs;
                if (!this.mReceivingLocationUpdates || this.mLocationUpdateInterval != intervalMs) {
                    this.mReceivingLocationUpdates = true;
                    this.mLocationUpdateInterval = intervalMs;
                    this.mLastLocationUpdate = location;
                    LocationRequest request = new LocationRequest();
                    request.setInterval(intervalMs).setFastestInterval(0L);
                    this.mLocationManager.requestLocationUpdates(request, this, this.mHandler.getLooper());
                }
            } else if (this.mReceivingLocationUpdates) {
                this.mReceivingLocationUpdates = false;
                this.mLocationUpdateInterval = 0L;
                this.mLastLocationUpdate = null;
                this.mLocationManager.removeUpdates(this);
            }
            if (D) {
                Slog.d(TAG, "updateFences: location=" + location + ", mFences.size()=" + this.mFences.size() + ", mReceivingLocationUpdates=" + this.mReceivingLocationUpdates + ", mLocationUpdateInterval=" + this.mLocationUpdateInterval + ", mLastLocationUpdate=" + this.mLastLocationUpdate);
            }
        }
        for (PendingIntent intent : exitIntents) {
            this.sendIntentExit(intent);
        }
        for (PendingIntent intent : enterIntents) {
            this.sendIntentEnter(intent);
        }
    }

    private void sendIntentEnter(PendingIntent pendingIntent) {
        if (D) {
            Slog.d(TAG, "sendIntentEnter: pendingIntent=" + pendingIntent);
        }
        Intent intent = new Intent();
        intent.putExtra("entering", true);
        this.sendIntent(pendingIntent, intent);
    }

    private void sendIntentExit(PendingIntent pendingIntent) {
        if (D) {
            Slog.d(TAG, "sendIntentExit: pendingIntent=" + pendingIntent);
        }
        Intent intent = new Intent();
        intent.putExtra("entering", false);
        this.sendIntent(pendingIntent, intent);
    }

    private void sendIntent(PendingIntent pendingIntent, Intent intent) {
        this.mWakeLock.acquire();
        try {
            pendingIntent.send(this.mContext, 0, intent, this, null, "android.permission.ACCESS_FINE_LOCATION");
        }
        catch (PendingIntent.CanceledException e) {
            this.removeFence(null, pendingIntent);
            this.mWakeLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocationChanged(Location location) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mReceivingLocationUpdates) {
                this.mLastLocationUpdate = location;
            }
            if (this.mPendingUpdate) {
                this.mHandler.removeMessages(1);
            } else {
                this.mPendingUpdate = true;
            }
        }
        this.updateFences();
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Override
    public void onProviderEnabled(String provider) {
    }

    @Override
    public void onProviderDisabled(String provider) {
    }

    @Override
    public void onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
        this.mWakeLock.release();
    }

    public void dump(PrintWriter pw) {
        pw.println("  Geofences:");
        for (GeofenceState state : this.mFences) {
            pw.append("    ");
            pw.append(state.mPackageName);
            pw.append(" ");
            pw.append(state.mFence.toString());
            pw.append("\n");
        }
    }

    private final class GeofenceHandler
    extends Handler {
        public GeofenceHandler() {
            super(true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    GeofenceManager.this.updateFences();
                }
            }
        }
    }
}

