/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.database.ContentObserver;
import android.os.Handler;
import android.provider.Settings;
import android.util.Log;
import android.util.Slog;
import com.android.server.LocationManagerService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public final class LocationBlacklist
extends ContentObserver {
    private static final String TAG = "LocationBlacklist";
    private static final boolean D = LocationManagerService.D;
    private static final String BLACKLIST_CONFIG_NAME = "locationPackagePrefixBlacklist";
    private static final String WHITELIST_CONFIG_NAME = "locationPackagePrefixWhitelist";
    private final Context mContext;
    private final Object mLock = new Object();
    private String[] mWhitelist = new String[0];
    private String[] mBlacklist = new String[0];
    private int mCurrentUserId = 0;

    public LocationBlacklist(Context context, Handler handler) {
        super(handler);
        this.mContext = context;
    }

    public void init() {
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor(BLACKLIST_CONFIG_NAME), false, this, -1);
        this.reloadBlacklist();
    }

    private void reloadBlacklistLocked() {
        this.mWhitelist = this.getStringArrayLocked(WHITELIST_CONFIG_NAME);
        if (D) {
            Slog.d(TAG, "whitelist: " + Arrays.toString(this.mWhitelist));
        }
        this.mBlacklist = this.getStringArrayLocked(BLACKLIST_CONFIG_NAME);
        if (D) {
            Slog.d(TAG, "blacklist: " + Arrays.toString(this.mBlacklist));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadBlacklist() {
        Object object = this.mLock;
        synchronized (object) {
            this.reloadBlacklistLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlacklisted(String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            for (String black : this.mBlacklist) {
                if (!packageName.startsWith(black) || this.inWhitelist(packageName)) continue;
                if (D) {
                    Log.d(TAG, "dropping location (blacklisted): " + packageName + " matches " + black);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inWhitelist(String pkg) {
        Object object = this.mLock;
        synchronized (object) {
            for (String white : this.mWhitelist) {
                if (!pkg.startsWith(white)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onChange(boolean selfChange) {
        this.reloadBlacklist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentUserId = userId;
            this.reloadBlacklistLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getStringArrayLocked(String key) {
        String flatString;
        Object object = this.mLock;
        synchronized (object) {
            flatString = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), key, this.mCurrentUserId);
        }
        if (flatString == null) {
            return new String[0];
        }
        String[] splitStrings = flatString.split(",");
        ArrayList<String> result = new ArrayList<String>();
        for (String pkg : splitStrings) {
            if ((pkg = pkg.trim()).isEmpty()) continue;
            result.add(pkg);
        }
        return result.toArray(new String[result.size()]);
    }

    public void dump(PrintWriter pw) {
        pw.println("mWhitelist=" + Arrays.toString(this.mWhitelist) + " mBlacklist=" + Arrays.toString(this.mBlacklist));
    }
}

