/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.WorkSource;
import android.util.Log;
import com.android.internal.location.ILocationProvider;
import com.android.internal.location.ProviderProperties;
import com.android.internal.location.ProviderRequest;
import com.android.internal.os.TransferPipe;
import com.android.server.LocationManagerService;
import com.android.server.ServiceWatcher;
import com.android.server.location.LocationProviderInterface;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;

public class LocationProviderProxy
implements LocationProviderInterface {
    private static final String TAG = "LocationProviderProxy";
    private static final boolean D = LocationManagerService.D;
    private final Context mContext;
    private final String mName;
    private final ServiceWatcher mServiceWatcher;
    private Object mLock = new Object();
    private ProviderProperties mProperties;
    private boolean mEnabled = false;
    private ProviderRequest mRequest = null;
    private WorkSource mWorksource = new WorkSource();
    private Runnable mNewServiceWork = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WorkSource source;
            ProviderRequest request;
            boolean enabled;
            if (D) {
                Log.d(LocationProviderProxy.TAG, "applying state to connected service");
            }
            final ProviderProperties[] properties = new ProviderProperties[1];
            Object object = LocationProviderProxy.this.mLock;
            synchronized (object) {
                enabled = LocationProviderProxy.this.mEnabled;
                request = LocationProviderProxy.this.mRequest;
                source = LocationProviderProxy.this.mWorksource;
            }
            LocationProviderProxy.this.mServiceWatcher.runOnBinder(new ServiceWatcher.BinderRunner(){

                @Override
                public void run(IBinder binder) {
                    ILocationProvider service = ILocationProvider.Stub.asInterface(binder);
                    try {
                        properties[0] = service.getProperties();
                        if (properties[0] == null) {
                            Log.e(LocationProviderProxy.TAG, LocationProviderProxy.this.mServiceWatcher.getBestPackageName() + " has invalid location provider properties");
                        }
                        if (enabled) {
                            service.enable();
                            if (request != null) {
                                service.setRequest(request, source);
                            }
                        }
                    }
                    catch (RemoteException e) {
                        Log.w(LocationProviderProxy.TAG, e);
                    }
                    catch (Exception e) {
                        Log.e(LocationProviderProxy.TAG, "Exception from " + LocationProviderProxy.this.mServiceWatcher.getBestPackageName(), e);
                    }
                }
            });
            object = LocationProviderProxy.this.mLock;
            synchronized (object) {
                LocationProviderProxy.this.mProperties = properties[0];
            }
        }
    };

    public static LocationProviderProxy createAndBind(Context context, String name, String action, int overlaySwitchResId, int defaultServicePackageNameResId, int initialPackageNamesResId, Handler handler) {
        LocationProviderProxy proxy = new LocationProviderProxy(context, name, action, overlaySwitchResId, defaultServicePackageNameResId, initialPackageNamesResId, handler);
        if (proxy.bind()) {
            return proxy;
        }
        return null;
    }

    private LocationProviderProxy(Context context, String name, String action, int overlaySwitchResId, int defaultServicePackageNameResId, int initialPackageNamesResId, Handler handler) {
        this.mContext = context;
        this.mName = name;
        this.mServiceWatcher = new ServiceWatcher(this.mContext, "LocationProviderProxy-" + name, action, overlaySwitchResId, defaultServicePackageNameResId, initialPackageNamesResId, this.mNewServiceWork, handler);
    }

    private boolean bind() {
        return this.mServiceWatcher.start();
    }

    public String getConnectedPackageName() {
        return this.mServiceWatcher.getBestPackageName();
    }

    @Override
    public String getName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderProperties getProperties() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enable() {
        Object object = this.mLock;
        synchronized (object) {
            this.mEnabled = true;
        }
        this.mServiceWatcher.runOnBinder(new ServiceWatcher.BinderRunner(){

            @Override
            public void run(IBinder binder) {
                ILocationProvider service = ILocationProvider.Stub.asInterface(binder);
                try {
                    service.enable();
                }
                catch (RemoteException e) {
                    Log.w(LocationProviderProxy.TAG, e);
                }
                catch (Exception e) {
                    Log.e(LocationProviderProxy.TAG, "Exception from " + LocationProviderProxy.this.mServiceWatcher.getBestPackageName(), e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable() {
        Object object = this.mLock;
        synchronized (object) {
            this.mEnabled = false;
        }
        this.mServiceWatcher.runOnBinder(new ServiceWatcher.BinderRunner(){

            @Override
            public void run(IBinder binder) {
                ILocationProvider service = ILocationProvider.Stub.asInterface(binder);
                try {
                    service.disable();
                }
                catch (RemoteException e) {
                    Log.w(LocationProviderProxy.TAG, e);
                }
                catch (Exception e) {
                    Log.e(LocationProviderProxy.TAG, "Exception from " + LocationProviderProxy.this.mServiceWatcher.getBestPackageName(), e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequest(final ProviderRequest request, final WorkSource source) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRequest = request;
            this.mWorksource = source;
        }
        this.mServiceWatcher.runOnBinder(new ServiceWatcher.BinderRunner(){

            @Override
            public void run(IBinder binder) {
                ILocationProvider service = ILocationProvider.Stub.asInterface(binder);
                try {
                    service.setRequest(request, source);
                }
                catch (RemoteException e) {
                    Log.w(LocationProviderProxy.TAG, e);
                }
                catch (Exception e) {
                    Log.e(LocationProviderProxy.TAG, "Exception from " + LocationProviderProxy.this.mServiceWatcher.getBestPackageName(), e);
                }
            }
        });
    }

    @Override
    public void dump(final FileDescriptor fd, final PrintWriter pw, final String[] args) {
        pw.append("REMOTE SERVICE");
        pw.append(" name=").append(this.mName);
        pw.append(" pkg=").append(this.mServiceWatcher.getBestPackageName());
        pw.append(" version=").append("" + this.mServiceWatcher.getBestVersion());
        pw.append('\n');
        if (!this.mServiceWatcher.runOnBinder(new ServiceWatcher.BinderRunner(){

            @Override
            public void run(IBinder binder) {
                ILocationProvider service = ILocationProvider.Stub.asInterface(binder);
                try {
                    TransferPipe.dumpAsync(service.asBinder(), fd, args);
                }
                catch (RemoteException | IOException e) {
                    pw.println("Failed to dump location provider: " + e);
                }
            }
        })) {
            pw.println("service down (null)");
        }
    }

    @Override
    public int getStatus(final Bundle extras) {
        final int[] result = new int[]{1};
        this.mServiceWatcher.runOnBinder(new ServiceWatcher.BinderRunner(){

            @Override
            public void run(IBinder binder) {
                ILocationProvider service = ILocationProvider.Stub.asInterface(binder);
                try {
                    result[0] = service.getStatus(extras);
                }
                catch (RemoteException e) {
                    Log.w(LocationProviderProxy.TAG, e);
                }
                catch (Exception e) {
                    Log.e(LocationProviderProxy.TAG, "Exception from " + LocationProviderProxy.this.mServiceWatcher.getBestPackageName(), e);
                }
            }
        });
        return result[0];
    }

    @Override
    public long getStatusUpdateTime() {
        final long[] result = new long[]{0L};
        this.mServiceWatcher.runOnBinder(new ServiceWatcher.BinderRunner(){

            @Override
            public void run(IBinder binder) {
                ILocationProvider service = ILocationProvider.Stub.asInterface(binder);
                try {
                    result[0] = service.getStatusUpdateTime();
                }
                catch (RemoteException e) {
                    Log.w(LocationProviderProxy.TAG, e);
                }
                catch (Exception e) {
                    Log.e(LocationProviderProxy.TAG, "Exception from " + LocationProviderProxy.this.mServiceWatcher.getBestPackageName(), e);
                }
            }
        });
        return result[0];
    }

    @Override
    public boolean sendExtraCommand(final String command, final Bundle extras) {
        final boolean[] result = new boolean[]{false};
        this.mServiceWatcher.runOnBinder(new ServiceWatcher.BinderRunner(){

            @Override
            public void run(IBinder binder) {
                ILocationProvider service = ILocationProvider.Stub.asInterface(binder);
                try {
                    result[0] = service.sendExtraCommand(command, extras);
                }
                catch (RemoteException e) {
                    Log.w(LocationProviderProxy.TAG, e);
                }
                catch (Exception e) {
                    Log.e(LocationProviderProxy.TAG, "Exception from " + LocationProviderProxy.this.mServiceWatcher.getBestPackageName(), e);
                }
            }
        });
        return result[0];
    }
}

